# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ListTasks200ResponseAllOfTasksInnerAnyOf5TaskOptions(BaseModel):
    """
    ListTasks200ResponseAllOfTasksInnerAnyOf5TaskOptions
    """ # noqa: E501
    web_password: Optional[StrictStr] = Field(default=None, alias="webPassword")
    web_password_hash: Optional[StrictStr] = Field(default=None, alias="webPasswordHash")
    local_script_git_id: Optional[StrictStr] = Field(default=None, alias="localScriptGitId")
    local_script_git_ref: Optional[StrictStr] = Field(default=None, alias="localScriptGitRef")
    web_user: Optional[StrictStr] = Field(default=None, alias="webUser")
    web_body: Optional[StrictStr] = Field(default=None, alias="webBody")
    web_headers: Optional[StrictStr] = Field(default=None, alias="webHeaders")
    password: Optional[StrictStr] = None
    password_hash: Optional[StrictStr] = Field(default=None, alias="passwordHash")
    username: Optional[StrictStr] = None
    ignore_ssl: Optional[StrictStr] = Field(default=None, alias="ignoreSSL")
    web_method: Optional[StrictStr] = Field(default=None, alias="webMethod")
    web_url: Optional[StrictStr] = Field(default=None, alias="webUrl")
    host: Optional[StrictStr] = None
    port: Optional[StrictStr] = None
    ssh_key: Optional[StrictStr] = Field(default=None, alias="sshKey")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["webPassword", "webPasswordHash", "localScriptGitId", "localScriptGitRef", "webUser", "webBody", "webHeaders", "password", "passwordHash", "username", "ignoreSSL", "webMethod", "webUrl", "host", "port", "sshKey"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListTasks200ResponseAllOfTasksInnerAnyOf5TaskOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if web_password (nullable) is None
        # and model_fields_set contains the field
        if self.web_password is None and "web_password" in self.model_fields_set:
            _dict['webPassword'] = None

        # set to None if web_password_hash (nullable) is None
        # and model_fields_set contains the field
        if self.web_password_hash is None and "web_password_hash" in self.model_fields_set:
            _dict['webPasswordHash'] = None

        # set to None if local_script_git_id (nullable) is None
        # and model_fields_set contains the field
        if self.local_script_git_id is None and "local_script_git_id" in self.model_fields_set:
            _dict['localScriptGitId'] = None

        # set to None if local_script_git_ref (nullable) is None
        # and model_fields_set contains the field
        if self.local_script_git_ref is None and "local_script_git_ref" in self.model_fields_set:
            _dict['localScriptGitRef'] = None

        # set to None if web_user (nullable) is None
        # and model_fields_set contains the field
        if self.web_user is None and "web_user" in self.model_fields_set:
            _dict['webUser'] = None

        # set to None if web_body (nullable) is None
        # and model_fields_set contains the field
        if self.web_body is None and "web_body" in self.model_fields_set:
            _dict['webBody'] = None

        # set to None if password (nullable) is None
        # and model_fields_set contains the field
        if self.password is None and "password" in self.model_fields_set:
            _dict['password'] = None

        # set to None if password_hash (nullable) is None
        # and model_fields_set contains the field
        if self.password_hash is None and "password_hash" in self.model_fields_set:
            _dict['passwordHash'] = None

        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        # set to None if ignore_ssl (nullable) is None
        # and model_fields_set contains the field
        if self.ignore_ssl is None and "ignore_ssl" in self.model_fields_set:
            _dict['ignoreSSL'] = None

        # set to None if web_method (nullable) is None
        # and model_fields_set contains the field
        if self.web_method is None and "web_method" in self.model_fields_set:
            _dict['webMethod'] = None

        # set to None if web_url (nullable) is None
        # and model_fields_set contains the field
        if self.web_url is None and "web_url" in self.model_fields_set:
            _dict['webUrl'] = None

        # set to None if host (nullable) is None
        # and model_fields_set contains the field
        if self.host is None and "host" in self.model_fields_set:
            _dict['host'] = None

        # set to None if port (nullable) is None
        # and model_fields_set contains the field
        if self.port is None and "port" in self.model_fields_set:
            _dict['port'] = None

        # set to None if ssh_key (nullable) is None
        # and model_fields_set contains the field
        if self.ssh_key is None and "ssh_key" in self.model_fields_set:
            _dict['sshKey'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListTasks200ResponseAllOfTasksInnerAnyOf5TaskOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "webPassword": obj.get("webPassword"),
            "webPasswordHash": obj.get("webPasswordHash"),
            "localScriptGitId": obj.get("localScriptGitId"),
            "localScriptGitRef": obj.get("localScriptGitRef"),
            "webUser": obj.get("webUser"),
            "webBody": obj.get("webBody"),
            "webHeaders": obj.get("webHeaders"),
            "password": obj.get("password"),
            "passwordHash": obj.get("passwordHash"),
            "username": obj.get("username"),
            "ignoreSSL": obj.get("ignoreSSL"),
            "webMethod": obj.get("webMethod"),
            "webUrl": obj.get("webUrl"),
            "host": obj.get("host"),
            "port": obj.get("port"),
            "sshKey": obj.get("sshKey")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


