# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from typing import Optional, Set
from typing_extensions import Self

class NetworkRouterFirewallRule(BaseModel):
    """
    NetworkRouterFirewallRule
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    priority: Optional[StrictInt] = None
    group_name: Optional[StrictStr] = Field(default=None, alias="groupName")
    direction: Optional[StrictStr] = None
    rule_type: Optional[StrictStr] = Field(default=None, alias="ruleType")
    policy: Optional[StrictStr] = None
    source: Optional[List[StrictStr]] = None
    source_type: Optional[StrictStr] = Field(default=None, alias="sourceType")
    destination: Optional[List[StrictStr]] = None
    destination_type: Optional[StrictStr] = Field(default=None, alias="destinationType")
    profiles: Optional[List[StrictStr]] = None
    protocol: Optional[StrictStr] = None
    application: Optional[StrictStr] = None
    application_type: Optional[StrictStr] = Field(default=None, alias="applicationType")
    port_range: Optional[StrictStr] = Field(default=None, alias="portRange")
    source_port_range: Optional[StrictStr] = Field(default=None, alias="sourcePortRange")
    destination_port_range: Optional[StrictStr] = Field(default=None, alias="destinationPortRange")
    source_group: Optional[StrictStr] = Field(default=None, alias="sourceGroup")
    source_tier: Optional[StrictStr] = Field(default=None, alias="sourceTier")
    applications: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "code", "enabled", "priority", "groupName", "direction", "ruleType", "policy", "source", "sourceType", "destination", "destinationType", "profiles", "protocol", "application", "applicationType", "portRange", "sourcePortRange", "destinationPortRange", "sourceGroup", "sourceTier", "applications"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NetworkRouterFirewallRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in applications (list)
        _items = []
        if self.applications:
            for _item_applications in self.applications:
                if _item_applications:
                    _items.append(_item_applications.to_dict())
            _dict['applications'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if code (nullable) is None
        # and model_fields_set contains the field
        if self.code is None and "code" in self.model_fields_set:
            _dict['code'] = None

        # set to None if protocol (nullable) is None
        # and model_fields_set contains the field
        if self.protocol is None and "protocol" in self.model_fields_set:
            _dict['protocol'] = None

        # set to None if application (nullable) is None
        # and model_fields_set contains the field
        if self.application is None and "application" in self.model_fields_set:
            _dict['application'] = None

        # set to None if port_range (nullable) is None
        # and model_fields_set contains the field
        if self.port_range is None and "port_range" in self.model_fields_set:
            _dict['portRange'] = None

        # set to None if source_port_range (nullable) is None
        # and model_fields_set contains the field
        if self.source_port_range is None and "source_port_range" in self.model_fields_set:
            _dict['sourcePortRange'] = None

        # set to None if destination_port_range (nullable) is None
        # and model_fields_set contains the field
        if self.destination_port_range is None and "destination_port_range" in self.model_fields_set:
            _dict['destinationPortRange'] = None

        # set to None if source_group (nullable) is None
        # and model_fields_set contains the field
        if self.source_group is None and "source_group" in self.model_fields_set:
            _dict['sourceGroup'] = None

        # set to None if source_tier (nullable) is None
        # and model_fields_set contains the field
        if self.source_tier is None and "source_tier" in self.model_fields_set:
            _dict['sourceTier'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NetworkRouterFirewallRule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "enabled": obj.get("enabled"),
            "priority": obj.get("priority"),
            "groupName": obj.get("groupName"),
            "direction": obj.get("direction"),
            "ruleType": obj.get("ruleType"),
            "policy": obj.get("policy"),
            "source": obj.get("source"),
            "sourceType": obj.get("sourceType"),
            "destination": obj.get("destination"),
            "destinationType": obj.get("destinationType"),
            "profiles": obj.get("profiles"),
            "protocol": obj.get("protocol"),
            "application": obj.get("application"),
            "applicationType": obj.get("applicationType"),
            "portRange": obj.get("portRange"),
            "sourcePortRange": obj.get("sourcePortRange"),
            "destinationPortRange": obj.get("destinationPortRange"),
            "sourceGroup": obj.get("sourceGroup"),
            "sourceTier": obj.get("sourceTier"),
            "applications": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["applications"]] if obj.get("applications") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


