# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class RolePermissionFeature(BaseModel):
    """
    RolePermissionFeature
    """ # noqa: E501
    permission_code: StrictStr = Field(description="The code of the feature permission being changed", alias="permissionCode")
    access: StrictStr = Field(description="The new access level.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["permissionCode", "access"]

    @field_validator('permission_code')
    def permission_code_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['account-usage', 'activity', 'admin-accounts', 'admin-accounts-users', 'admin-appliance', 'admin-backupSettings', 'admin-certificates', 'admin-clients', 'admin-cm', 'admin-containers', 'admin-distributed-workers', 'admin-environments', 'admin-global-policies', 'admin-groups', 'admin-guidanceSettings', 'admin-health', 'admin-identity-sources', 'admin-keypairs', 'admin-licenses', 'admin-logSettings', 'admin-monitorSettings', 'admin-motd', 'admin-packages', 'admin-plugins', 'admin-policies', 'admin-profiles', 'admin-provisioningSettings', 'admin-roles', 'admin-servers', 'admin-servicePlans', 'admin-users', 'admin-whitelabel', 'admin-zones', 'app-templates', 'apps', 'arm-template', 'automation-services', 'backup-services', 'backups', 'billing', 'catalog', 'cloudFormation-template', 'code-repositories', 'credentials', 'dashboard', 'deployment-services', 'deployments', 'execution-request', 'executions', 'guidance', 'helm-template', 'infrastructure-boot', 'infrastructure-cluster', 'infrastructure-dhcp-pool', 'infrastructure-domains', 'infrastructure-ippools', 'infrastructure-kube-cntl', 'infrastructure-loadbalancer', 'infrastructure-move-server', 'infrastructure-nat', 'infrastructure-network-dhcp-relay', 'infrastructure-network-dhcp-routes', 'infrastructure-network-dhcp-server', 'infrastructure-network-firewalls', 'infrastructure-network-integrations', 'infrastructure-network-router-firewalls', 'infrastructure-network-router-interfaces', 'infrastructure-network-router-redistribution', 'infrastructure-network-router-routes', 'infrastructure-network-server-groups', 'infrastructure-networks', 'infrastructure-proxies', 'infrastructure-router-dhcp-binding', 'infrastructure-router-dhcp-relay', 'infrastructure-routers', 'infrastructure-securityGroups', 'infrastructure-state', 'infrastructure-storage', 'infrastructure-storage-browser', 'integrations-ansible', 'job-executions', 'job-templates', 'kubernetes-template', 'library-advanced-node-type-options', 'library-options', 'library-templates', 'logs', 'monitoring', 'operations-alarms', 'operations-approvals', 'operations-budgets', 'operations-invoices', 'operations-wiki', 'projects', 'provisioning', 'provisioning-add', 'provisioning-admin', 'provisioning-clone', 'provisioning-delete', 'provisioning-edit', 'provisioning-environment', 'provisioning-execute-script', 'provisioning-execute-task', 'provisioning-execute-workflow', 'provisioning-force-delete', 'provisioning-import-image', 'provisioning-lock', 'provisioning-power', 'provisioning-reconfigure', 'provisioning-reconfigure-add-disk', 'provisioning-reconfigure-add-network', 'provisioning-reconfigure-change-plan', 'provisioning-reconfigure-disk-type', 'provisioning-reconfigure-modify-disk', 'provisioning-reconfigure-modify-network', 'provisioning-reconfigure-remove-disk', 'provisioning-reconfigure-remove-network', 'provisioning-remove-control', 'provisioning-scale', 'provisioning-settings', 'provisioning-state', 'reports', 'reports-analytics', 'scheduling-execute', 'scheduling-power', 'security-scan', 'service-catalog', 'service-catalog-dashboard', 'service-catalog-inventory', 'services-archives', 'services-cypher', 'services-image-builder', 'services-kubernetes', 'services-network-registry', 'services-vdi-copy', 'services-vdi-pools', 'services-vdi-printer', 'snapshots', 'task-scripts', 'tasks', 'terminal', 'terminal-access', 'terraform-template', 'thresholds', 'trust-services', 'virtual-images']):
            raise ValueError("must be one of enum values ('account-usage', 'activity', 'admin-accounts', 'admin-accounts-users', 'admin-appliance', 'admin-backupSettings', 'admin-certificates', 'admin-clients', 'admin-cm', 'admin-containers', 'admin-distributed-workers', 'admin-environments', 'admin-global-policies', 'admin-groups', 'admin-guidanceSettings', 'admin-health', 'admin-identity-sources', 'admin-keypairs', 'admin-licenses', 'admin-logSettings', 'admin-monitorSettings', 'admin-motd', 'admin-packages', 'admin-plugins', 'admin-policies', 'admin-profiles', 'admin-provisioningSettings', 'admin-roles', 'admin-servers', 'admin-servicePlans', 'admin-users', 'admin-whitelabel', 'admin-zones', 'app-templates', 'apps', 'arm-template', 'automation-services', 'backup-services', 'backups', 'billing', 'catalog', 'cloudFormation-template', 'code-repositories', 'credentials', 'dashboard', 'deployment-services', 'deployments', 'execution-request', 'executions', 'guidance', 'helm-template', 'infrastructure-boot', 'infrastructure-cluster', 'infrastructure-dhcp-pool', 'infrastructure-domains', 'infrastructure-ippools', 'infrastructure-kube-cntl', 'infrastructure-loadbalancer', 'infrastructure-move-server', 'infrastructure-nat', 'infrastructure-network-dhcp-relay', 'infrastructure-network-dhcp-routes', 'infrastructure-network-dhcp-server', 'infrastructure-network-firewalls', 'infrastructure-network-integrations', 'infrastructure-network-router-firewalls', 'infrastructure-network-router-interfaces', 'infrastructure-network-router-redistribution', 'infrastructure-network-router-routes', 'infrastructure-network-server-groups', 'infrastructure-networks', 'infrastructure-proxies', 'infrastructure-router-dhcp-binding', 'infrastructure-router-dhcp-relay', 'infrastructure-routers', 'infrastructure-securityGroups', 'infrastructure-state', 'infrastructure-storage', 'infrastructure-storage-browser', 'integrations-ansible', 'job-executions', 'job-templates', 'kubernetes-template', 'library-advanced-node-type-options', 'library-options', 'library-templates', 'logs', 'monitoring', 'operations-alarms', 'operations-approvals', 'operations-budgets', 'operations-invoices', 'operations-wiki', 'projects', 'provisioning', 'provisioning-add', 'provisioning-admin', 'provisioning-clone', 'provisioning-delete', 'provisioning-edit', 'provisioning-environment', 'provisioning-execute-script', 'provisioning-execute-task', 'provisioning-execute-workflow', 'provisioning-force-delete', 'provisioning-import-image', 'provisioning-lock', 'provisioning-power', 'provisioning-reconfigure', 'provisioning-reconfigure-add-disk', 'provisioning-reconfigure-add-network', 'provisioning-reconfigure-change-plan', 'provisioning-reconfigure-disk-type', 'provisioning-reconfigure-modify-disk', 'provisioning-reconfigure-modify-network', 'provisioning-reconfigure-remove-disk', 'provisioning-reconfigure-remove-network', 'provisioning-remove-control', 'provisioning-scale', 'provisioning-settings', 'provisioning-state', 'reports', 'reports-analytics', 'scheduling-execute', 'scheduling-power', 'security-scan', 'service-catalog', 'service-catalog-dashboard', 'service-catalog-inventory', 'services-archives', 'services-cypher', 'services-image-builder', 'services-kubernetes', 'services-network-registry', 'services-vdi-copy', 'services-vdi-pools', 'services-vdi-printer', 'snapshots', 'task-scripts', 'tasks', 'terminal', 'terminal-access', 'terraform-template', 'thresholds', 'trust-services', 'virtual-images')")
        return value

    @field_validator('access')
    def access_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['full', 'full_decrypted', 'group', 'listfiles', 'managerules', 'no', 'none', 'provision', 'read', 'rolemappings', 'user', 'view', 'yes']):
            raise ValueError("must be one of enum values ('full', 'full_decrypted', 'group', 'listfiles', 'managerules', 'no', 'none', 'provision', 'read', 'rolemappings', 'user', 'view', 'yes')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RolePermissionFeature from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RolePermissionFeature from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "permissionCode": obj.get("permissionCode"),
            "access": obj.get("access")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


