# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from morpheus.models.add_credentials_request_credential_one_of import AddCredentialsRequestCredentialOneOf
from morpheus.models.add_credentials_request_credential_one_of1 import AddCredentialsRequestCredentialOneOf1
from morpheus.models.add_credentials_request_credential_one_of2 import AddCredentialsRequestCredentialOneOf2
from morpheus.models.add_credentials_request_credential_one_of3 import AddCredentialsRequestCredentialOneOf3
from morpheus.models.add_credentials_request_credential_one_of4 import AddCredentialsRequestCredentialOneOf4
from morpheus.models.add_credentials_request_credential_one_of5 import AddCredentialsRequestCredentialOneOf5
from morpheus.models.add_credentials_request_credential_one_of6 import AddCredentialsRequestCredentialOneOf6
from morpheus.models.add_credentials_request_credential_one_of7 import AddCredentialsRequestCredentialOneOf7
from morpheus.models.add_credentials_request_credential_one_of8 import AddCredentialsRequestCredentialOneOf8
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

UPDATECREDENTIALSREQUESTCREDENTIAL_ONE_OF_SCHEMAS = ["AddCredentialsRequestCredentialOneOf", "AddCredentialsRequestCredentialOneOf1", "AddCredentialsRequestCredentialOneOf2", "AddCredentialsRequestCredentialOneOf3", "AddCredentialsRequestCredentialOneOf4", "AddCredentialsRequestCredentialOneOf5", "AddCredentialsRequestCredentialOneOf6", "AddCredentialsRequestCredentialOneOf7", "AddCredentialsRequestCredentialOneOf8"]

class UpdateCredentialsRequestCredential(BaseModel):
    """
    Payload for updating a credential
    """
    # data type: AddCredentialsRequestCredentialOneOf
    oneof_schema_1_validator: Optional[AddCredentialsRequestCredentialOneOf] = None
    # data type: AddCredentialsRequestCredentialOneOf1
    oneof_schema_2_validator: Optional[AddCredentialsRequestCredentialOneOf1] = None
    # data type: AddCredentialsRequestCredentialOneOf2
    oneof_schema_3_validator: Optional[AddCredentialsRequestCredentialOneOf2] = None
    # data type: AddCredentialsRequestCredentialOneOf3
    oneof_schema_4_validator: Optional[AddCredentialsRequestCredentialOneOf3] = None
    # data type: AddCredentialsRequestCredentialOneOf4
    oneof_schema_5_validator: Optional[AddCredentialsRequestCredentialOneOf4] = None
    # data type: AddCredentialsRequestCredentialOneOf5
    oneof_schema_6_validator: Optional[AddCredentialsRequestCredentialOneOf5] = None
    # data type: AddCredentialsRequestCredentialOneOf6
    oneof_schema_7_validator: Optional[AddCredentialsRequestCredentialOneOf6] = None
    # data type: AddCredentialsRequestCredentialOneOf7
    oneof_schema_8_validator: Optional[AddCredentialsRequestCredentialOneOf7] = None
    # data type: AddCredentialsRequestCredentialOneOf8
    oneof_schema_9_validator: Optional[AddCredentialsRequestCredentialOneOf8] = None
    actual_instance: Optional[Union[AddCredentialsRequestCredentialOneOf, AddCredentialsRequestCredentialOneOf1, AddCredentialsRequestCredentialOneOf2, AddCredentialsRequestCredentialOneOf3, AddCredentialsRequestCredentialOneOf4, AddCredentialsRequestCredentialOneOf5, AddCredentialsRequestCredentialOneOf6, AddCredentialsRequestCredentialOneOf7, AddCredentialsRequestCredentialOneOf8]] = None
    one_of_schemas: Set[str] = { "AddCredentialsRequestCredentialOneOf", "AddCredentialsRequestCredentialOneOf1", "AddCredentialsRequestCredentialOneOf2", "AddCredentialsRequestCredentialOneOf3", "AddCredentialsRequestCredentialOneOf4", "AddCredentialsRequestCredentialOneOf5", "AddCredentialsRequestCredentialOneOf6", "AddCredentialsRequestCredentialOneOf7", "AddCredentialsRequestCredentialOneOf8" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = UpdateCredentialsRequestCredential.model_construct()
        error_messages = []
        match = 0
        # validate data type: AddCredentialsRequestCredentialOneOf
        if not isinstance(v, AddCredentialsRequestCredentialOneOf):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddCredentialsRequestCredentialOneOf`")
        else:
            match += 1
        # validate data type: AddCredentialsRequestCredentialOneOf1
        if not isinstance(v, AddCredentialsRequestCredentialOneOf1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddCredentialsRequestCredentialOneOf1`")
        else:
            match += 1
        # validate data type: AddCredentialsRequestCredentialOneOf2
        if not isinstance(v, AddCredentialsRequestCredentialOneOf2):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddCredentialsRequestCredentialOneOf2`")
        else:
            match += 1
        # validate data type: AddCredentialsRequestCredentialOneOf3
        if not isinstance(v, AddCredentialsRequestCredentialOneOf3):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddCredentialsRequestCredentialOneOf3`")
        else:
            match += 1
        # validate data type: AddCredentialsRequestCredentialOneOf4
        if not isinstance(v, AddCredentialsRequestCredentialOneOf4):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddCredentialsRequestCredentialOneOf4`")
        else:
            match += 1
        # validate data type: AddCredentialsRequestCredentialOneOf5
        if not isinstance(v, AddCredentialsRequestCredentialOneOf5):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddCredentialsRequestCredentialOneOf5`")
        else:
            match += 1
        # validate data type: AddCredentialsRequestCredentialOneOf6
        if not isinstance(v, AddCredentialsRequestCredentialOneOf6):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddCredentialsRequestCredentialOneOf6`")
        else:
            match += 1
        # validate data type: AddCredentialsRequestCredentialOneOf7
        if not isinstance(v, AddCredentialsRequestCredentialOneOf7):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddCredentialsRequestCredentialOneOf7`")
        else:
            match += 1
        # validate data type: AddCredentialsRequestCredentialOneOf8
        if not isinstance(v, AddCredentialsRequestCredentialOneOf8):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AddCredentialsRequestCredentialOneOf8`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in UpdateCredentialsRequestCredential with oneOf schemas: AddCredentialsRequestCredentialOneOf, AddCredentialsRequestCredentialOneOf1, AddCredentialsRequestCredentialOneOf2, AddCredentialsRequestCredentialOneOf3, AddCredentialsRequestCredentialOneOf4, AddCredentialsRequestCredentialOneOf5, AddCredentialsRequestCredentialOneOf6, AddCredentialsRequestCredentialOneOf7, AddCredentialsRequestCredentialOneOf8. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in UpdateCredentialsRequestCredential with oneOf schemas: AddCredentialsRequestCredentialOneOf, AddCredentialsRequestCredentialOneOf1, AddCredentialsRequestCredentialOneOf2, AddCredentialsRequestCredentialOneOf3, AddCredentialsRequestCredentialOneOf4, AddCredentialsRequestCredentialOneOf5, AddCredentialsRequestCredentialOneOf6, AddCredentialsRequestCredentialOneOf7, AddCredentialsRequestCredentialOneOf8. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into AddCredentialsRequestCredentialOneOf
        try:
            instance.actual_instance = AddCredentialsRequestCredentialOneOf.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddCredentialsRequestCredentialOneOf1
        try:
            instance.actual_instance = AddCredentialsRequestCredentialOneOf1.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddCredentialsRequestCredentialOneOf2
        try:
            instance.actual_instance = AddCredentialsRequestCredentialOneOf2.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddCredentialsRequestCredentialOneOf3
        try:
            instance.actual_instance = AddCredentialsRequestCredentialOneOf3.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddCredentialsRequestCredentialOneOf4
        try:
            instance.actual_instance = AddCredentialsRequestCredentialOneOf4.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddCredentialsRequestCredentialOneOf5
        try:
            instance.actual_instance = AddCredentialsRequestCredentialOneOf5.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddCredentialsRequestCredentialOneOf6
        try:
            instance.actual_instance = AddCredentialsRequestCredentialOneOf6.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddCredentialsRequestCredentialOneOf7
        try:
            instance.actual_instance = AddCredentialsRequestCredentialOneOf7.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AddCredentialsRequestCredentialOneOf8
        try:
            instance.actual_instance = AddCredentialsRequestCredentialOneOf8.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into UpdateCredentialsRequestCredential with oneOf schemas: AddCredentialsRequestCredentialOneOf, AddCredentialsRequestCredentialOneOf1, AddCredentialsRequestCredentialOneOf2, AddCredentialsRequestCredentialOneOf3, AddCredentialsRequestCredentialOneOf4, AddCredentialsRequestCredentialOneOf5, AddCredentialsRequestCredentialOneOf6, AddCredentialsRequestCredentialOneOf7, AddCredentialsRequestCredentialOneOf8. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into UpdateCredentialsRequestCredential with oneOf schemas: AddCredentialsRequestCredentialOneOf, AddCredentialsRequestCredentialOneOf1, AddCredentialsRequestCredentialOneOf2, AddCredentialsRequestCredentialOneOf3, AddCredentialsRequestCredentialOneOf4, AddCredentialsRequestCredentialOneOf5, AddCredentialsRequestCredentialOneOf6, AddCredentialsRequestCredentialOneOf7, AddCredentialsRequestCredentialOneOf8. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], AddCredentialsRequestCredentialOneOf, AddCredentialsRequestCredentialOneOf1, AddCredentialsRequestCredentialOneOf2, AddCredentialsRequestCredentialOneOf3, AddCredentialsRequestCredentialOneOf4, AddCredentialsRequestCredentialOneOf5, AddCredentialsRequestCredentialOneOf6, AddCredentialsRequestCredentialOneOf7, AddCredentialsRequestCredentialOneOf8]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


