# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from morpheus.models.list_cloud_datastores200_response_all_of_datastores_inner_tenants_inner import ListCloudDatastores200ResponseAllOfDatastoresInnerTenantsInner
from morpheus.models.save_cloud_datastore_request_datastore_resource_permissions import SaveCloudDatastoreRequestDatastoreResourcePermissions
from typing import Optional, Set
from typing_extensions import Self

class UpdateDatastores200ResponseDatastore(BaseModel):
    """
    UpdateDatastores200ResponseDatastore
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    datastore_type: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = Field(default=None, alias="datastoreType")
    storage_server: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = Field(default=None, alias="storageServer")
    type: Optional[StrictStr] = None
    visibility: Optional[StrictStr] = None
    storage_size: Optional[StrictInt] = Field(default=None, alias="storageSize")
    free_space: Optional[StrictInt] = Field(default=None, alias="freeSpace")
    drs_enabled: Optional[StrictBool] = Field(default=None, alias="drsEnabled")
    active: Optional[StrictBool] = None
    allow_write: Optional[StrictBool] = Field(default=None, alias="allowWrite")
    default_store: Optional[StrictBool] = Field(default=None, alias="defaultStore")
    online: Optional[StrictBool] = None
    allow_read: Optional[StrictBool] = Field(default=None, alias="allowRead")
    allow_provision: Optional[StrictBool] = Field(default=None, alias="allowProvision")
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictInt] = Field(default=None, alias="refId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    zone: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    zone_pool: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = Field(default=None, alias="zonePool")
    owner: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    tenants: Optional[List[ListCloudDatastores200ResponseAllOfDatastoresInnerTenantsInner]] = None
    resource_permissions: Optional[SaveCloudDatastoreRequestDatastoreResourcePermissions] = Field(default=None, alias="resourcePermissions")
    datastores: Optional[List[Dict[str, Any]]] = None
    success: Optional[StrictBool] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "name", "code", "datastoreType", "storageServer", "type", "visibility", "storageSize", "freeSpace", "drsEnabled", "active", "allowWrite", "defaultStore", "online", "allowRead", "allowProvision", "refType", "refId", "externalId", "zone", "zonePool", "owner", "tenants", "resourcePermissions", "datastores", "success"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateDatastores200ResponseDatastore from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of datastore_type
        if self.datastore_type:
            _dict['datastoreType'] = self.datastore_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of storage_server
        if self.storage_server:
            _dict['storageServer'] = self.storage_server.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zone_pool
        if self.zone_pool:
            _dict['zonePool'] = self.zone_pool.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tenants (list)
        _items = []
        if self.tenants:
            for _item_tenants in self.tenants:
                if _item_tenants:
                    _items.append(_item_tenants.to_dict())
            _dict['tenants'] = _items
        # override the default output from pydantic by calling `to_dict()` of resource_permissions
        if self.resource_permissions:
            _dict['resourcePermissions'] = self.resource_permissions.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if code (nullable) is None
        # and model_fields_set contains the field
        if self.code is None and "code" in self.model_fields_set:
            _dict['code'] = None

        # set to None if storage_size (nullable) is None
        # and model_fields_set contains the field
        if self.storage_size is None and "storage_size" in self.model_fields_set:
            _dict['storageSize'] = None

        # set to None if free_space (nullable) is None
        # and model_fields_set contains the field
        if self.free_space is None and "free_space" in self.model_fields_set:
            _dict['freeSpace'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateDatastores200ResponseDatastore from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "datastoreType": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["datastoreType"]) if obj.get("datastoreType") is not None else None,
            "storageServer": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["storageServer"]) if obj.get("storageServer") is not None else None,
            "type": obj.get("type"),
            "visibility": obj.get("visibility"),
            "storageSize": obj.get("storageSize"),
            "freeSpace": obj.get("freeSpace"),
            "drsEnabled": obj.get("drsEnabled"),
            "active": obj.get("active"),
            "allowWrite": obj.get("allowWrite"),
            "defaultStore": obj.get("defaultStore"),
            "online": obj.get("online"),
            "allowRead": obj.get("allowRead"),
            "allowProvision": obj.get("allowProvision"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "externalId": obj.get("externalId"),
            "zone": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "zonePool": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["zonePool"]) if obj.get("zonePool") is not None else None,
            "owner": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["owner"]) if obj.get("owner") is not None else None,
            "tenants": [ListCloudDatastores200ResponseAllOfDatastoresInnerTenantsInner.from_dict(_item) for _item in obj["tenants"]] if obj.get("tenants") is not None else None,
            "resourcePermissions": SaveCloudDatastoreRequestDatastoreResourcePermissions.from_dict(obj["resourcePermissions"]) if obj.get("resourcePermissions") is not None else None,
            "datastores": obj.get("datastores"),
            "success": obj.get("success")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


