# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_evars_inner import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner
from morpheus.models.list_instances200_response_all_of_instances_inner_tags_inner import ListInstances200ResponseAllOfInstancesInnerTagsInner
from morpheus.models.update_instance_request_instance_site import UpdateInstanceRequestInstanceSite
from typing import Optional, Set
from typing_extensions import Self

class UpdateInstanceRequestInstance(BaseModel):
    """
    UpdateInstanceRequestInstance
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Unique name scoped to your account for the instance.")
    description: Optional[StrictStr] = Field(default=None, description="Optional description field.")
    instance_context: Optional[StrictStr] = Field(default=None, description="Environment", alias="instanceContext")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of strings (keywords).")
    tags: Optional[List[AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner]] = Field(default=None, description="Metadata tags, Array of objects having a name and value.")
    add_tags: Optional[List[AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner]] = Field(default=None, description="Add or update value of Metadata tags, Array of objects having a name and value.", alias="addTags")
    remove_tags: Optional[List[ListInstances200ResponseAllOfInstancesInnerTagsInner]] = Field(default=None, description="Remove Metadata tags, Array of objects having a name and an optional value. If value is passed, it must match to be removed.", alias="removeTags")
    power_schedule_type: Optional[StrictInt] = Field(default=None, description="Power schedule ID.", alias="powerScheduleType")
    site: Optional[UpdateInstanceRequestInstanceSite] = None
    owner_id: Optional[StrictInt] = Field(default=None, description="User ID, can be used to change instance owner.", alias="ownerId")
    display_name: Optional[StrictStr] = Field(default=None, description="Name used in the UI for display", alias="displayName")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "description", "instanceContext", "labels", "tags", "addTags", "removeTags", "powerScheduleType", "site", "ownerId", "displayName"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateInstanceRequestInstance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tags (list)
        _items = []
        if self.tags:
            for _item_tags in self.tags:
                if _item_tags:
                    _items.append(_item_tags.to_dict())
            _dict['tags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in add_tags (list)
        _items = []
        if self.add_tags:
            for _item_add_tags in self.add_tags:
                if _item_add_tags:
                    _items.append(_item_add_tags.to_dict())
            _dict['addTags'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in remove_tags (list)
        _items = []
        if self.remove_tags:
            for _item_remove_tags in self.remove_tags:
                if _item_remove_tags:
                    _items.append(_item_remove_tags.to_dict())
            _dict['removeTags'] = _items
        # override the default output from pydantic by calling `to_dict()` of site
        if self.site:
            _dict['site'] = self.site.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateInstanceRequestInstance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "instanceContext": obj.get("instanceContext"),
            "labels": obj.get("labels"),
            "tags": [AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner.from_dict(_item) for _item in obj["tags"]] if obj.get("tags") is not None else None,
            "addTags": [AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigEvarsInner.from_dict(_item) for _item in obj["addTags"]] if obj.get("addTags") is not None else None,
            "removeTags": [ListInstances200ResponseAllOfInstancesInnerTagsInner.from_dict(_item) for _item in obj["removeTags"]] if obj.get("removeTags") is not None else None,
            "powerScheduleType": obj.get("powerScheduleType"),
            "site": UpdateInstanceRequestInstanceSite.from_dict(obj["site"]) if obj.get("site") is not None else None,
            "ownerId": obj.get("ownerId"),
            "displayName": obj.get("displayName")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


