# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from morpheus.models.approve_policy_type_configuration import ApprovePolicyTypeConfiguration
from morpheus.models.backup_creation_policy_type_configuration import BackupCreationPolicyTypeConfiguration
from morpheus.models.backup_targets_policy_type_configuration import BackupTargetsPolicyTypeConfiguration
from morpheus.models.budget_policy_type_configuration import BudgetPolicyTypeConfiguration
from morpheus.models.cluster_resource_name_policy_type_configuration import ClusterResourceNamePolicyTypeConfiguration
from morpheus.models.cypher_access_policy_type_configuration import CypherAccessPolicyTypeConfiguration
from morpheus.models.delayed_delete_policy_type_configuration import DelayedDeletePolicyTypeConfiguration
from morpheus.models.expiration_policy_type_configuration import ExpirationPolicyTypeConfiguration
from morpheus.models.file_share_storage_quota_policy_type_configuration import FileShareStorageQuotaPolicyTypeConfiguration
from morpheus.models.hostname_policy_type_configuration import HostnamePolicyTypeConfiguration
from morpheus.models.instance_name_policy_type_configuration import InstanceNamePolicyTypeConfiguration
from morpheus.models.max_containers_policy_type_configuration import MaxContainersPolicyTypeConfiguration
from morpheus.models.max_cores_policy_type_configuration1 import MaxCoresPolicyTypeConfiguration1
from morpheus.models.max_hosts_policy_type_configuration import MaxHostsPolicyTypeConfiguration
from morpheus.models.max_load_balancer_pools_policy_type_configuration import MaxLoadBalancerPoolsPolicyTypeConfiguration
from morpheus.models.max_memory_policy_type_configuration1 import MaxMemoryPolicyTypeConfiguration1
from morpheus.models.max_pool_members_policy_type_configuration import MaxPoolMembersPolicyTypeConfiguration
from morpheus.models.max_storage_and_object_storage_quota_policy_type_configuration1 import MaxStorageAndObjectStorageQuotaPolicyTypeConfiguration1
from morpheus.models.max_virtual_servers_policy_type_configuration import MaxVirtualServersPolicyTypeConfiguration
from morpheus.models.max_vms_policy_type_configuration import MaxVMsPolicyTypeConfiguration
from morpheus.models.message_of_the_day_policy_type_configuration import MessageOfTheDayPolicyTypeConfiguration
from morpheus.models.network_quota_policy_type_configuration import NetworkQuotaPolicyTypeConfiguration
from morpheus.models.power_schedule_policy_type_configuration import PowerSchedulePolicyTypeConfiguration
from morpheus.models.router_quota_policy_type_configuration import RouterQuotaPolicyTypeConfiguration
from morpheus.models.shutdown_policy_type_configuration import ShutdownPolicyTypeConfiguration
from morpheus.models.storage_server_storage_quota_policy_type_configuration import StorageServerStorageQuotaPolicyTypeConfiguration
from morpheus.models.tags_policy_type_configuration import TagsPolicyTypeConfiguration
from morpheus.models.user_creation_policy_type_configuration import UserCreationPolicyTypeConfiguration
from morpheus.models.user_group_creation_policy_type_configuration import UserGroupCreationPolicyTypeConfiguration
from morpheus.models.workflow_policy_type_configuration import WorkflowPolicyTypeConfiguration
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

UPDATEPOLICIESREQUESTPOLICYCONFIG_ANY_OF_SCHEMAS = ["ApprovePolicyTypeConfiguration", "BackupCreationPolicyTypeConfiguration", "BackupTargetsPolicyTypeConfiguration", "BudgetPolicyTypeConfiguration", "ClusterResourceNamePolicyTypeConfiguration", "CypherAccessPolicyTypeConfiguration", "DelayedDeletePolicyTypeConfiguration", "ExpirationPolicyTypeConfiguration", "FileShareStorageQuotaPolicyTypeConfiguration", "HostnamePolicyTypeConfiguration", "InstanceNamePolicyTypeConfiguration", "MaxContainersPolicyTypeConfiguration", "MaxCoresPolicyTypeConfiguration1", "MaxHostsPolicyTypeConfiguration", "MaxLoadBalancerPoolsPolicyTypeConfiguration", "MaxMemoryPolicyTypeConfiguration1", "MaxPoolMembersPolicyTypeConfiguration", "MaxStorageAndObjectStorageQuotaPolicyTypeConfiguration1", "MaxVMsPolicyTypeConfiguration", "MaxVirtualServersPolicyTypeConfiguration", "MessageOfTheDayPolicyTypeConfiguration", "NetworkQuotaPolicyTypeConfiguration", "PowerSchedulePolicyTypeConfiguration", "RouterQuotaPolicyTypeConfiguration", "ShutdownPolicyTypeConfiguration", "StorageServerStorageQuotaPolicyTypeConfiguration", "TagsPolicyTypeConfiguration", "UserCreationPolicyTypeConfiguration", "UserGroupCreationPolicyTypeConfiguration", "WorkflowPolicyTypeConfiguration"]

class UpdatePoliciesRequestPolicyConfig(BaseModel):
    """
    A map of config values. The expected values vary by policy type. See `Retrieves all Policy Types` endpoint for `fieldName`(s) of required options.
    """

    # data type: ApprovePolicyTypeConfiguration
    anyof_schema_1_validator: Optional[ApprovePolicyTypeConfiguration] = None
    # data type: BackupCreationPolicyTypeConfiguration
    anyof_schema_2_validator: Optional[BackupCreationPolicyTypeConfiguration] = None
    # data type: BackupTargetsPolicyTypeConfiguration
    anyof_schema_3_validator: Optional[BackupTargetsPolicyTypeConfiguration] = None
    # data type: BudgetPolicyTypeConfiguration
    anyof_schema_4_validator: Optional[BudgetPolicyTypeConfiguration] = None
    # data type: ClusterResourceNamePolicyTypeConfiguration
    anyof_schema_5_validator: Optional[ClusterResourceNamePolicyTypeConfiguration] = None
    # data type: CypherAccessPolicyTypeConfiguration
    anyof_schema_6_validator: Optional[CypherAccessPolicyTypeConfiguration] = None
    # data type: DelayedDeletePolicyTypeConfiguration
    anyof_schema_7_validator: Optional[DelayedDeletePolicyTypeConfiguration] = None
    # data type: ExpirationPolicyTypeConfiguration
    anyof_schema_8_validator: Optional[ExpirationPolicyTypeConfiguration] = None
    # data type: FileShareStorageQuotaPolicyTypeConfiguration
    anyof_schema_9_validator: Optional[FileShareStorageQuotaPolicyTypeConfiguration] = None
    # data type: HostnamePolicyTypeConfiguration
    anyof_schema_10_validator: Optional[HostnamePolicyTypeConfiguration] = None
    # data type: InstanceNamePolicyTypeConfiguration
    anyof_schema_11_validator: Optional[InstanceNamePolicyTypeConfiguration] = None
    # data type: MaxContainersPolicyTypeConfiguration
    anyof_schema_12_validator: Optional[MaxContainersPolicyTypeConfiguration] = None
    # data type: MaxCoresPolicyTypeConfiguration1
    anyof_schema_13_validator: Optional[MaxCoresPolicyTypeConfiguration1] = None
    # data type: MaxHostsPolicyTypeConfiguration
    anyof_schema_14_validator: Optional[MaxHostsPolicyTypeConfiguration] = None
    # data type: MaxLoadBalancerPoolsPolicyTypeConfiguration
    anyof_schema_15_validator: Optional[MaxLoadBalancerPoolsPolicyTypeConfiguration] = None
    # data type: MaxMemoryPolicyTypeConfiguration1
    anyof_schema_16_validator: Optional[MaxMemoryPolicyTypeConfiguration1] = None
    # data type: MaxPoolMembersPolicyTypeConfiguration
    anyof_schema_17_validator: Optional[MaxPoolMembersPolicyTypeConfiguration] = None
    # data type: MaxStorageAndObjectStorageQuotaPolicyTypeConfiguration1
    anyof_schema_18_validator: Optional[MaxStorageAndObjectStorageQuotaPolicyTypeConfiguration1] = None
    # data type: MaxVirtualServersPolicyTypeConfiguration
    anyof_schema_19_validator: Optional[MaxVirtualServersPolicyTypeConfiguration] = None
    # data type: MaxVMsPolicyTypeConfiguration
    anyof_schema_20_validator: Optional[MaxVMsPolicyTypeConfiguration] = None
    # data type: MessageOfTheDayPolicyTypeConfiguration
    anyof_schema_21_validator: Optional[MessageOfTheDayPolicyTypeConfiguration] = None
    # data type: NetworkQuotaPolicyTypeConfiguration
    anyof_schema_22_validator: Optional[NetworkQuotaPolicyTypeConfiguration] = None
    # data type: PowerSchedulePolicyTypeConfiguration
    anyof_schema_23_validator: Optional[PowerSchedulePolicyTypeConfiguration] = None
    # data type: RouterQuotaPolicyTypeConfiguration
    anyof_schema_24_validator: Optional[RouterQuotaPolicyTypeConfiguration] = None
    # data type: ShutdownPolicyTypeConfiguration
    anyof_schema_25_validator: Optional[ShutdownPolicyTypeConfiguration] = None
    # data type: StorageServerStorageQuotaPolicyTypeConfiguration
    anyof_schema_26_validator: Optional[StorageServerStorageQuotaPolicyTypeConfiguration] = None
    # data type: TagsPolicyTypeConfiguration
    anyof_schema_27_validator: Optional[TagsPolicyTypeConfiguration] = None
    # data type: UserCreationPolicyTypeConfiguration
    anyof_schema_28_validator: Optional[UserCreationPolicyTypeConfiguration] = None
    # data type: UserGroupCreationPolicyTypeConfiguration
    anyof_schema_29_validator: Optional[UserGroupCreationPolicyTypeConfiguration] = None
    # data type: WorkflowPolicyTypeConfiguration
    anyof_schema_30_validator: Optional[WorkflowPolicyTypeConfiguration] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[ApprovePolicyTypeConfiguration, BackupCreationPolicyTypeConfiguration, BackupTargetsPolicyTypeConfiguration, BudgetPolicyTypeConfiguration, ClusterResourceNamePolicyTypeConfiguration, CypherAccessPolicyTypeConfiguration, DelayedDeletePolicyTypeConfiguration, ExpirationPolicyTypeConfiguration, FileShareStorageQuotaPolicyTypeConfiguration, HostnamePolicyTypeConfiguration, InstanceNamePolicyTypeConfiguration, MaxContainersPolicyTypeConfiguration, MaxCoresPolicyTypeConfiguration1, MaxHostsPolicyTypeConfiguration, MaxLoadBalancerPoolsPolicyTypeConfiguration, MaxMemoryPolicyTypeConfiguration1, MaxPoolMembersPolicyTypeConfiguration, MaxStorageAndObjectStorageQuotaPolicyTypeConfiguration1, MaxVMsPolicyTypeConfiguration, MaxVirtualServersPolicyTypeConfiguration, MessageOfTheDayPolicyTypeConfiguration, NetworkQuotaPolicyTypeConfiguration, PowerSchedulePolicyTypeConfiguration, RouterQuotaPolicyTypeConfiguration, ShutdownPolicyTypeConfiguration, StorageServerStorageQuotaPolicyTypeConfiguration, TagsPolicyTypeConfiguration, UserCreationPolicyTypeConfiguration, UserGroupCreationPolicyTypeConfiguration, WorkflowPolicyTypeConfiguration]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "ApprovePolicyTypeConfiguration", "BackupCreationPolicyTypeConfiguration", "BackupTargetsPolicyTypeConfiguration", "BudgetPolicyTypeConfiguration", "ClusterResourceNamePolicyTypeConfiguration", "CypherAccessPolicyTypeConfiguration", "DelayedDeletePolicyTypeConfiguration", "ExpirationPolicyTypeConfiguration", "FileShareStorageQuotaPolicyTypeConfiguration", "HostnamePolicyTypeConfiguration", "InstanceNamePolicyTypeConfiguration", "MaxContainersPolicyTypeConfiguration", "MaxCoresPolicyTypeConfiguration1", "MaxHostsPolicyTypeConfiguration", "MaxLoadBalancerPoolsPolicyTypeConfiguration", "MaxMemoryPolicyTypeConfiguration1", "MaxPoolMembersPolicyTypeConfiguration", "MaxStorageAndObjectStorageQuotaPolicyTypeConfiguration1", "MaxVMsPolicyTypeConfiguration", "MaxVirtualServersPolicyTypeConfiguration", "MessageOfTheDayPolicyTypeConfiguration", "NetworkQuotaPolicyTypeConfiguration", "PowerSchedulePolicyTypeConfiguration", "RouterQuotaPolicyTypeConfiguration", "ShutdownPolicyTypeConfiguration", "StorageServerStorageQuotaPolicyTypeConfiguration", "TagsPolicyTypeConfiguration", "UserCreationPolicyTypeConfiguration", "UserGroupCreationPolicyTypeConfiguration", "WorkflowPolicyTypeConfiguration" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = UpdatePoliciesRequestPolicyConfig.model_construct()
        error_messages = []
        # validate data type: ApprovePolicyTypeConfiguration
        if not isinstance(v, ApprovePolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ApprovePolicyTypeConfiguration`")
        else:
            return v

        # validate data type: BackupCreationPolicyTypeConfiguration
        if not isinstance(v, BackupCreationPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BackupCreationPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: BackupTargetsPolicyTypeConfiguration
        if not isinstance(v, BackupTargetsPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BackupTargetsPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: BudgetPolicyTypeConfiguration
        if not isinstance(v, BudgetPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BudgetPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: ClusterResourceNamePolicyTypeConfiguration
        if not isinstance(v, ClusterResourceNamePolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ClusterResourceNamePolicyTypeConfiguration`")
        else:
            return v

        # validate data type: CypherAccessPolicyTypeConfiguration
        if not isinstance(v, CypherAccessPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CypherAccessPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: DelayedDeletePolicyTypeConfiguration
        if not isinstance(v, DelayedDeletePolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `DelayedDeletePolicyTypeConfiguration`")
        else:
            return v

        # validate data type: ExpirationPolicyTypeConfiguration
        if not isinstance(v, ExpirationPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ExpirationPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: FileShareStorageQuotaPolicyTypeConfiguration
        if not isinstance(v, FileShareStorageQuotaPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `FileShareStorageQuotaPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: HostnamePolicyTypeConfiguration
        if not isinstance(v, HostnamePolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `HostnamePolicyTypeConfiguration`")
        else:
            return v

        # validate data type: InstanceNamePolicyTypeConfiguration
        if not isinstance(v, InstanceNamePolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `InstanceNamePolicyTypeConfiguration`")
        else:
            return v

        # validate data type: MaxContainersPolicyTypeConfiguration
        if not isinstance(v, MaxContainersPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MaxContainersPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: MaxCoresPolicyTypeConfiguration1
        if not isinstance(v, MaxCoresPolicyTypeConfiguration1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MaxCoresPolicyTypeConfiguration1`")
        else:
            return v

        # validate data type: MaxHostsPolicyTypeConfiguration
        if not isinstance(v, MaxHostsPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MaxHostsPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: MaxLoadBalancerPoolsPolicyTypeConfiguration
        if not isinstance(v, MaxLoadBalancerPoolsPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MaxLoadBalancerPoolsPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: MaxMemoryPolicyTypeConfiguration1
        if not isinstance(v, MaxMemoryPolicyTypeConfiguration1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MaxMemoryPolicyTypeConfiguration1`")
        else:
            return v

        # validate data type: MaxPoolMembersPolicyTypeConfiguration
        if not isinstance(v, MaxPoolMembersPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MaxPoolMembersPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: MaxStorageAndObjectStorageQuotaPolicyTypeConfiguration1
        if not isinstance(v, MaxStorageAndObjectStorageQuotaPolicyTypeConfiguration1):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MaxStorageAndObjectStorageQuotaPolicyTypeConfiguration1`")
        else:
            return v

        # validate data type: MaxVirtualServersPolicyTypeConfiguration
        if not isinstance(v, MaxVirtualServersPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MaxVirtualServersPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: MaxVMsPolicyTypeConfiguration
        if not isinstance(v, MaxVMsPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MaxVMsPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: MessageOfTheDayPolicyTypeConfiguration
        if not isinstance(v, MessageOfTheDayPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MessageOfTheDayPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: NetworkQuotaPolicyTypeConfiguration
        if not isinstance(v, NetworkQuotaPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `NetworkQuotaPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: PowerSchedulePolicyTypeConfiguration
        if not isinstance(v, PowerSchedulePolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PowerSchedulePolicyTypeConfiguration`")
        else:
            return v

        # validate data type: RouterQuotaPolicyTypeConfiguration
        if not isinstance(v, RouterQuotaPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RouterQuotaPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: ShutdownPolicyTypeConfiguration
        if not isinstance(v, ShutdownPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ShutdownPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: StorageServerStorageQuotaPolicyTypeConfiguration
        if not isinstance(v, StorageServerStorageQuotaPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `StorageServerStorageQuotaPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: TagsPolicyTypeConfiguration
        if not isinstance(v, TagsPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TagsPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: UserCreationPolicyTypeConfiguration
        if not isinstance(v, UserCreationPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `UserCreationPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: UserGroupCreationPolicyTypeConfiguration
        if not isinstance(v, UserGroupCreationPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `UserGroupCreationPolicyTypeConfiguration`")
        else:
            return v

        # validate data type: WorkflowPolicyTypeConfiguration
        if not isinstance(v, WorkflowPolicyTypeConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WorkflowPolicyTypeConfiguration`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in UpdatePoliciesRequestPolicyConfig with anyOf schemas: ApprovePolicyTypeConfiguration, BackupCreationPolicyTypeConfiguration, BackupTargetsPolicyTypeConfiguration, BudgetPolicyTypeConfiguration, ClusterResourceNamePolicyTypeConfiguration, CypherAccessPolicyTypeConfiguration, DelayedDeletePolicyTypeConfiguration, ExpirationPolicyTypeConfiguration, FileShareStorageQuotaPolicyTypeConfiguration, HostnamePolicyTypeConfiguration, InstanceNamePolicyTypeConfiguration, MaxContainersPolicyTypeConfiguration, MaxCoresPolicyTypeConfiguration1, MaxHostsPolicyTypeConfiguration, MaxLoadBalancerPoolsPolicyTypeConfiguration, MaxMemoryPolicyTypeConfiguration1, MaxPoolMembersPolicyTypeConfiguration, MaxStorageAndObjectStorageQuotaPolicyTypeConfiguration1, MaxVMsPolicyTypeConfiguration, MaxVirtualServersPolicyTypeConfiguration, MessageOfTheDayPolicyTypeConfiguration, NetworkQuotaPolicyTypeConfiguration, PowerSchedulePolicyTypeConfiguration, RouterQuotaPolicyTypeConfiguration, ShutdownPolicyTypeConfiguration, StorageServerStorageQuotaPolicyTypeConfiguration, TagsPolicyTypeConfiguration, UserCreationPolicyTypeConfiguration, UserGroupCreationPolicyTypeConfiguration, WorkflowPolicyTypeConfiguration. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[ApprovePolicyTypeConfiguration] = None
        try:
            instance.actual_instance = ApprovePolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[BackupCreationPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = BackupCreationPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[BackupTargetsPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = BackupTargetsPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[BudgetPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = BudgetPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_5_validator: Optional[ClusterResourceNamePolicyTypeConfiguration] = None
        try:
            instance.actual_instance = ClusterResourceNamePolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_6_validator: Optional[CypherAccessPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = CypherAccessPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_7_validator: Optional[DelayedDeletePolicyTypeConfiguration] = None
        try:
            instance.actual_instance = DelayedDeletePolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_8_validator: Optional[ExpirationPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = ExpirationPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_9_validator: Optional[FileShareStorageQuotaPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = FileShareStorageQuotaPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_10_validator: Optional[HostnamePolicyTypeConfiguration] = None
        try:
            instance.actual_instance = HostnamePolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_11_validator: Optional[InstanceNamePolicyTypeConfiguration] = None
        try:
            instance.actual_instance = InstanceNamePolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_12_validator: Optional[MaxContainersPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = MaxContainersPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_13_validator: Optional[MaxCoresPolicyTypeConfiguration1] = None
        try:
            instance.actual_instance = MaxCoresPolicyTypeConfiguration1.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_14_validator: Optional[MaxHostsPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = MaxHostsPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_15_validator: Optional[MaxLoadBalancerPoolsPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = MaxLoadBalancerPoolsPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_16_validator: Optional[MaxMemoryPolicyTypeConfiguration1] = None
        try:
            instance.actual_instance = MaxMemoryPolicyTypeConfiguration1.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_17_validator: Optional[MaxPoolMembersPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = MaxPoolMembersPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_18_validator: Optional[MaxStorageAndObjectStorageQuotaPolicyTypeConfiguration1] = None
        try:
            instance.actual_instance = MaxStorageAndObjectStorageQuotaPolicyTypeConfiguration1.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_19_validator: Optional[MaxVirtualServersPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = MaxVirtualServersPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_20_validator: Optional[MaxVMsPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = MaxVMsPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_21_validator: Optional[MessageOfTheDayPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = MessageOfTheDayPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_22_validator: Optional[NetworkQuotaPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = NetworkQuotaPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_23_validator: Optional[PowerSchedulePolicyTypeConfiguration] = None
        try:
            instance.actual_instance = PowerSchedulePolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_24_validator: Optional[RouterQuotaPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = RouterQuotaPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_25_validator: Optional[ShutdownPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = ShutdownPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_26_validator: Optional[StorageServerStorageQuotaPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = StorageServerStorageQuotaPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_27_validator: Optional[TagsPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = TagsPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_28_validator: Optional[UserCreationPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = UserCreationPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_29_validator: Optional[UserGroupCreationPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = UserGroupCreationPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_30_validator: Optional[WorkflowPolicyTypeConfiguration] = None
        try:
            instance.actual_instance = WorkflowPolicyTypeConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into UpdatePoliciesRequestPolicyConfig with anyOf schemas: ApprovePolicyTypeConfiguration, BackupCreationPolicyTypeConfiguration, BackupTargetsPolicyTypeConfiguration, BudgetPolicyTypeConfiguration, ClusterResourceNamePolicyTypeConfiguration, CypherAccessPolicyTypeConfiguration, DelayedDeletePolicyTypeConfiguration, ExpirationPolicyTypeConfiguration, FileShareStorageQuotaPolicyTypeConfiguration, HostnamePolicyTypeConfiguration, InstanceNamePolicyTypeConfiguration, MaxContainersPolicyTypeConfiguration, MaxCoresPolicyTypeConfiguration1, MaxHostsPolicyTypeConfiguration, MaxLoadBalancerPoolsPolicyTypeConfiguration, MaxMemoryPolicyTypeConfiguration1, MaxPoolMembersPolicyTypeConfiguration, MaxStorageAndObjectStorageQuotaPolicyTypeConfiguration1, MaxVMsPolicyTypeConfiguration, MaxVirtualServersPolicyTypeConfiguration, MessageOfTheDayPolicyTypeConfiguration, NetworkQuotaPolicyTypeConfiguration, PowerSchedulePolicyTypeConfiguration, RouterQuotaPolicyTypeConfiguration, ShutdownPolicyTypeConfiguration, StorageServerStorageQuotaPolicyTypeConfiguration, TagsPolicyTypeConfiguration, UserCreationPolicyTypeConfiguration, UserGroupCreationPolicyTypeConfiguration, WorkflowPolicyTypeConfiguration. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ApprovePolicyTypeConfiguration, BackupCreationPolicyTypeConfiguration, BackupTargetsPolicyTypeConfiguration, BudgetPolicyTypeConfiguration, ClusterResourceNamePolicyTypeConfiguration, CypherAccessPolicyTypeConfiguration, DelayedDeletePolicyTypeConfiguration, ExpirationPolicyTypeConfiguration, FileShareStorageQuotaPolicyTypeConfiguration, HostnamePolicyTypeConfiguration, InstanceNamePolicyTypeConfiguration, MaxContainersPolicyTypeConfiguration, MaxCoresPolicyTypeConfiguration1, MaxHostsPolicyTypeConfiguration, MaxLoadBalancerPoolsPolicyTypeConfiguration, MaxMemoryPolicyTypeConfiguration1, MaxPoolMembersPolicyTypeConfiguration, MaxStorageAndObjectStorageQuotaPolicyTypeConfiguration1, MaxVMsPolicyTypeConfiguration, MaxVirtualServersPolicyTypeConfiguration, MessageOfTheDayPolicyTypeConfiguration, NetworkQuotaPolicyTypeConfiguration, PowerSchedulePolicyTypeConfiguration, RouterQuotaPolicyTypeConfiguration, ShutdownPolicyTypeConfiguration, StorageServerStorageQuotaPolicyTypeConfiguration, TagsPolicyTypeConfiguration, UserCreationPolicyTypeConfiguration, UserGroupCreationPolicyTypeConfiguration, WorkflowPolicyTypeConfiguration]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


