# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.add_cluster_layouts_request_layout_provision_type import AddClusterLayoutsRequestLayoutProvisionType
from morpheus.models.add_service_plans_request_service_plan_price_sets_inner import AddServicePlansRequestServicePlanPriceSetsInner
from morpheus.models.update_service_plans_request_service_plan_config import UpdateServicePlansRequestServicePlanConfig
from typing import Optional, Set
from typing_extensions import Self

class UpdateServicePlansRequestServicePlan(BaseModel):
    """
    UpdateServicePlansRequestServicePlan
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Service plan name")
    code: Optional[StrictStr] = Field(default=None, description="Service plan code, must be unique")
    description: Optional[StrictStr] = Field(default=None, description="Service plan description")
    editable: Optional[StrictBool] = Field(default=True, description="Can be used to enable / disable the editability of the service plan.")
    max_storage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Max storage size in bytes", alias="maxStorage")
    max_memory: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Max memory size in bytes", alias="maxMemory")
    max_cores: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Max cores", alias="maxCores")
    max_disks: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Max disks allowed", alias="maxDisks")
    provision_type: Optional[AddClusterLayoutsRequestLayoutProvisionType] = Field(default=None, alias="provisionType")
    custom_cores: Optional[StrictBool] = Field(default=False, description="Can be used to enable / disable customizable cores", alias="customCores")
    custom_max_storage: Optional[StrictBool] = Field(default=False, description="Can be used to enable / disable customizable storage", alias="customMaxStorage")
    custom_max_data_storage: Optional[StrictBool] = Field(default=False, description="Can be used to enable / disable customizable extra volumes.", alias="customMaxDataStorage")
    custom_max_memory: Optional[StrictBool] = Field(default=False, description="Can be used to enable / disable customizable memory.", alias="customMaxMemory")
    add_volumes: Optional[StrictBool] = Field(default=False, description="Can be used to enable / disable ability to add volumes", alias="addVolumes")
    sort_order: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Sort order", alias="sortOrder")
    price_sets: Optional[List[AddServicePlansRequestServicePlanPriceSetsInner]] = Field(default=None, description="List of price sets to include in service plan", alias="priceSets")
    config: Optional[UpdateServicePlansRequestServicePlanConfig] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "code", "description", "editable", "maxStorage", "maxMemory", "maxCores", "maxDisks", "provisionType", "customCores", "customMaxStorage", "customMaxDataStorage", "customMaxMemory", "addVolumes", "sortOrder", "priceSets", "config"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateServicePlansRequestServicePlan from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of provision_type
        if self.provision_type:
            _dict['provisionType'] = self.provision_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in price_sets (list)
        _items = []
        if self.price_sets:
            for _item_price_sets in self.price_sets:
                if _item_price_sets:
                    _items.append(_item_price_sets.to_dict())
            _dict['priceSets'] = _items
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateServicePlansRequestServicePlan from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "code": obj.get("code"),
            "description": obj.get("description"),
            "editable": obj.get("editable") if obj.get("editable") is not None else True,
            "maxStorage": obj.get("maxStorage"),
            "maxMemory": obj.get("maxMemory"),
            "maxCores": obj.get("maxCores"),
            "maxDisks": obj.get("maxDisks"),
            "provisionType": AddClusterLayoutsRequestLayoutProvisionType.from_dict(obj["provisionType"]) if obj.get("provisionType") is not None else None,
            "customCores": obj.get("customCores") if obj.get("customCores") is not None else False,
            "customMaxStorage": obj.get("customMaxStorage") if obj.get("customMaxStorage") is not None else False,
            "customMaxDataStorage": obj.get("customMaxDataStorage") if obj.get("customMaxDataStorage") is not None else False,
            "customMaxMemory": obj.get("customMaxMemory") if obj.get("customMaxMemory") is not None else False,
            "addVolumes": obj.get("addVolumes") if obj.get("addVolumes") is not None else False,
            "sortOrder": obj.get("sortOrder"),
            "priceSets": [AddServicePlansRequestServicePlanPriceSetsInner.from_dict(_item) for _item in obj["priceSets"]] if obj.get("priceSets") is not None else None,
            "config": UpdateServicePlansRequestServicePlanConfig.from_dict(obj["config"]) if obj.get("config") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


