# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, SecretStr, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.update_user_request_user_roles_inner import UpdateUserRequestUserRolesInner
from typing import Optional, Set
from typing_extensions import Self

class UpdateUserRequestUser(BaseModel):
    """
    UpdateUserRequestUser
    """ # noqa: E501
    first_name: Optional[StrictStr] = Field(default=None, description="First Name", alias="firstName")
    last_name: Optional[StrictStr] = Field(default=None, description="Last Name", alias="lastName")
    username: Optional[StrictStr] = Field(default=None, description="Username (unique per tenant).")
    linux_username: Optional[StrictStr] = Field(default=None, alias="linuxUsername")
    linux_password: Optional[SecretStr] = Field(default=None, alias="linuxPassword")
    linux_key_pair_id: Optional[StrictInt] = Field(default=None, alias="linuxKeyPairId")
    windows_username: Optional[StrictStr] = Field(default=None, alias="windowsUsername")
    windows_password: Optional[SecretStr] = Field(default=None, alias="windowsPassword")
    email: Optional[StrictStr] = Field(default=None, description="Email address")
    password: Optional[SecretStr] = Field(default=None, description="Password")
    roles: Optional[List[UpdateUserRequestUserRolesInner]] = Field(default=None, description="List of Roles")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["firstName", "lastName", "username", "linuxUsername", "linuxPassword", "linuxKeyPairId", "windowsUsername", "windowsPassword", "email", "password", "roles"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateUserRequestUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in roles (list)
        _items = []
        if self.roles:
            for _item_roles in self.roles:
                if _item_roles:
                    _items.append(_item_roles.to_dict())
            _dict['roles'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if first_name (nullable) is None
        # and model_fields_set contains the field
        if self.first_name is None and "first_name" in self.model_fields_set:
            _dict['firstName'] = None

        # set to None if last_name (nullable) is None
        # and model_fields_set contains the field
        if self.last_name is None and "last_name" in self.model_fields_set:
            _dict['lastName'] = None

        # set to None if linux_username (nullable) is None
        # and model_fields_set contains the field
        if self.linux_username is None and "linux_username" in self.model_fields_set:
            _dict['linuxUsername'] = None

        # set to None if linux_password (nullable) is None
        # and model_fields_set contains the field
        if self.linux_password is None and "linux_password" in self.model_fields_set:
            _dict['linuxPassword'] = None

        # set to None if linux_key_pair_id (nullable) is None
        # and model_fields_set contains the field
        if self.linux_key_pair_id is None and "linux_key_pair_id" in self.model_fields_set:
            _dict['linuxKeyPairId'] = None

        # set to None if windows_username (nullable) is None
        # and model_fields_set contains the field
        if self.windows_username is None and "windows_username" in self.model_fields_set:
            _dict['windowsUsername'] = None

        # set to None if windows_password (nullable) is None
        # and model_fields_set contains the field
        if self.windows_password is None and "windows_password" in self.model_fields_set:
            _dict['windowsPassword'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateUserRequestUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "username": obj.get("username"),
            "linuxUsername": obj.get("linuxUsername"),
            "linuxPassword": obj.get("linuxPassword"),
            "linuxKeyPairId": obj.get("linuxKeyPairId"),
            "windowsUsername": obj.get("windowsUsername"),
            "windowsPassword": obj.get("windowsPassword"),
            "email": obj.get("email"),
            "password": obj.get("password"),
            "roles": [UpdateUserRequestUserRolesInner.from_dict(_item) for _item in obj["roles"]] if obj.get("roles") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


