# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.add_vdi_pools_request_vdi_pool_one_of_config import AddVDIPoolsRequestVdiPoolOneOfConfig
from typing import Optional, Set
from typing_extensions import Self

class UpdateVDIPoolsRequestVdiPool(BaseModel):
    """
    UpdateVDIPoolsRequestVdiPool
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Virtual Desktop name")
    description: Optional[StrictStr] = Field(default=None, description="Virtual Desktop description")
    owner: Optional[StrictInt] = Field(default=None, description="Owner (User) ID")
    min_idle: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Min Idle - Sets the minimum number of idle instances on standby in the pool. The pool will always try to maintain this number of available instances on standby. ", alias="minIdle")
    initial_pool_size: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="The initial size of the pool to be allocated on creation", alias="initialPoolSize")
    max_idle: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Sets the maximum number of idle instances on standby in the pool. If the number of idle instances supersedes this, the pool will start removing instances ", alias="maxIdle")
    max_pool_size: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Max limit on number of allocations and instances within the pool. ", alias="maxPoolSize")
    allocation_timeout_minutes: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Time (in minutes) after a user disconnects before an allocation is recycled or shutdown depending on persistence. ", alias="allocationTimeoutMinutes")
    persistent_user: Optional[StrictBool] = Field(default=False, description="Persistent Desktop Pool", alias="persistentUser")
    recyclable: Optional[StrictBool] = Field(default=False, description="Recyclable VDI Pools only work with cloud types that support snapshot management (i.e. Vmware, Nutanix, VCD)")
    allow_copy: Optional[StrictBool] = Field(default=False, description="Allow copy from desktop", alias="allowCopy")
    allow_printer: Optional[StrictBool] = Field(default=False, description="Allow local printers from Desktop", alias="allowPrinter")
    allow_fileshare: Optional[StrictBool] = Field(default=False, description="Allow File Share", alias="allowFileshare")
    allow_hypervisor_console: Optional[StrictBool] = Field(default=False, description="Allow hypervisor console", alias="allowHypervisorConsole")
    auto_create_local_user_on_reservation: Optional[StrictBool] = Field(default=False, description="Auto create local user upon reservation", alias="autoCreateLocalUserOnReservation")
    enabled: Optional[StrictBool] = Field(default=True, description="Can be used to enable or disable the VDI pool")
    icon_path: Optional[StrictStr] = Field(default=None, description="The relative location of an icon image", alias="iconPath")
    apps: Optional[List[StrictInt]] = Field(default=None, description="Array of VDI App IDs")
    gateway: Optional[StrictInt] = Field(default=None, description="VDI Gateway ID")
    instance_config: Optional[StrictStr] = Field(default=None, description="Instance Config JSON. Passing as a string will preserve property order.  See `config` object for required values.", alias="instanceConfig")
    config: Optional[AddVDIPoolsRequestVdiPoolOneOfConfig] = None
    guest_console_jump_host: Optional[StrictStr] = Field(default=None, description="Guest Console Jump Host", alias="guestConsoleJumpHost")
    guest_console_jump_port: Optional[StrictInt] = Field(default=None, description="Guest Console Jump Port", alias="guestConsoleJumpPort")
    guest_console_jump_username: Optional[StrictStr] = Field(default=None, description="Guest Console Jump Username", alias="guestConsoleJumpUsername")
    guest_console_jump_password: Optional[StrictStr] = Field(default=None, description="Guest Console Jump Password", alias="guestConsoleJumpPassword")
    guest_console_jump_keypair: Optional[StrictInt] = Field(default=None, description="Guest Console Jump Key Pair. see `Key Pair`", alias="guestConsoleJumpKeypair")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["name", "description", "owner", "minIdle", "initialPoolSize", "maxIdle", "maxPoolSize", "allocationTimeoutMinutes", "persistentUser", "recyclable", "allowCopy", "allowPrinter", "allowFileshare", "allowHypervisorConsole", "autoCreateLocalUserOnReservation", "enabled", "iconPath", "apps", "gateway", "instanceConfig", "config", "guestConsoleJumpHost", "guestConsoleJumpPort", "guestConsoleJumpUsername", "guestConsoleJumpPassword", "guestConsoleJumpKeypair"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateVDIPoolsRequestVdiPool from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateVDIPoolsRequestVdiPool from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "owner": obj.get("owner"),
            "minIdle": obj.get("minIdle"),
            "initialPoolSize": obj.get("initialPoolSize"),
            "maxIdle": obj.get("maxIdle"),
            "maxPoolSize": obj.get("maxPoolSize"),
            "allocationTimeoutMinutes": obj.get("allocationTimeoutMinutes"),
            "persistentUser": obj.get("persistentUser") if obj.get("persistentUser") is not None else False,
            "recyclable": obj.get("recyclable") if obj.get("recyclable") is not None else False,
            "allowCopy": obj.get("allowCopy") if obj.get("allowCopy") is not None else False,
            "allowPrinter": obj.get("allowPrinter") if obj.get("allowPrinter") is not None else False,
            "allowFileshare": obj.get("allowFileshare") if obj.get("allowFileshare") is not None else False,
            "allowHypervisorConsole": obj.get("allowHypervisorConsole") if obj.get("allowHypervisorConsole") is not None else False,
            "autoCreateLocalUserOnReservation": obj.get("autoCreateLocalUserOnReservation") if obj.get("autoCreateLocalUserOnReservation") is not None else False,
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "iconPath": obj.get("iconPath"),
            "apps": obj.get("apps"),
            "gateway": obj.get("gateway"),
            "instanceConfig": obj.get("instanceConfig"),
            "config": AddVDIPoolsRequestVdiPoolOneOfConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "guestConsoleJumpHost": obj.get("guestConsoleJumpHost"),
            "guestConsoleJumpPort": obj.get("guestConsoleJumpPort"),
            "guestConsoleJumpUsername": obj.get("guestConsoleJumpUsername"),
            "guestConsoleJumpPassword": obj.get("guestConsoleJumpPassword"),
            "guestConsoleJumpKeypair": obj.get("guestConsoleJumpKeypair")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


