# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UserSourceCreateSaml(BaseModel):
    """
    SAML Configuration
    """ # noqa: E501
    url: Optional[StrictStr] = Field(default=None, description="Login Redirect URL")
    do_not_include_saml_request: Optional[StrictBool] = Field(default=False, description="Exclude SAML Request Parameter", alias="doNotIncludeSAMLRequest")
    logout_url: Optional[StrictStr] = Field(default=None, description="Lougout Post URL", alias="logoutUrl")
    saml_signature_mode: Optional[StrictStr] = Field(default='NoSignature', description="SAML Request signing mode", alias="SAMLSignatureMode")
    request509_certificate: Optional[StrictStr] = Field(default=None, description="Only applies when `SAMLSignatureMode=CustomSignature`", alias="request509Certificate")
    request_private_key: Optional[StrictStr] = Field(default=None, description="RSA Private Key. Only applies when `SAMLSignatureMode=CustomSignature`", alias="requestPrivateKey")
    do_not_validate_signature: Optional[StrictBool] = Field(default=True, description="SAML Response Signing Flag", alias="doNotValidateSignature")
    public_key: Optional[StrictStr] = Field(default=None, description="Signing Public Key. Only applies when `doNotValidateSignature=true`", alias="publicKey")
    private_key: Optional[StrictStr] = Field(default=None, description="Encryption RSA Private Key", alias="privateKey")
    given_name_attribute: Optional[StrictStr] = Field(default=None, description="Given Name Attribute Name", alias="givenNameAttribute")
    surname_attribute: Optional[StrictStr] = Field(default=None, description="Surname Attribute Name", alias="surnameAttribute")
    role_attribute_name: Optional[StrictStr] = Field(default=None, description="Role Attribute Name", alias="roleAttributeName")
    required_attribute_value: Optional[StrictStr] = Field(default=None, description="Role Attibute Required Value", alias="requiredAttributeValue")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["url", "doNotIncludeSAMLRequest", "logoutUrl", "SAMLSignatureMode", "request509Certificate", "requestPrivateKey", "doNotValidateSignature", "publicKey", "privateKey", "givenNameAttribute", "surnameAttribute", "roleAttributeName", "requiredAttributeValue"]

    @field_validator('saml_signature_mode')
    def saml_signature_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NoSignature', 'SelfSigned', 'CustomSignature']):
            raise ValueError("must be one of enum values ('NoSignature', 'SelfSigned', 'CustomSignature')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserSourceCreateSaml from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserSourceCreateSaml from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "doNotIncludeSAMLRequest": obj.get("doNotIncludeSAMLRequest") if obj.get("doNotIncludeSAMLRequest") is not None else False,
            "logoutUrl": obj.get("logoutUrl"),
            "SAMLSignatureMode": obj.get("SAMLSignatureMode") if obj.get("SAMLSignatureMode") is not None else 'NoSignature',
            "request509Certificate": obj.get("request509Certificate"),
            "requestPrivateKey": obj.get("requestPrivateKey"),
            "doNotValidateSignature": obj.get("doNotValidateSignature") if obj.get("doNotValidateSignature") is not None else True,
            "publicKey": obj.get("publicKey"),
            "privateKey": obj.get("privateKey"),
            "givenNameAttribute": obj.get("givenNameAttribute"),
            "surnameAttribute": obj.get("surnameAttribute"),
            "roleAttributeName": obj.get("roleAttributeName"),
            "requiredAttributeValue": obj.get("requiredAttributeValue")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


