# morphodeep

[![License GNU LGPL v3.0](https://img.shields.io/pypi/l/morphodeep.svg?color=green)](https://github.com/Gitlab /morphodeep/raw/main/LICENSE)
[![PyPI](https://img.shields.io/pypi/v/morphodeep.svg?color=green)](https://pypi.org/project/morphodeep)
[![Python Version](https://img.shields.io/pypi/pyversions/morphodeep.svg?color=green)](https://python.org)
[![tests](https://github.com/Gitlab /morphodeep/workflows/tests/badge.svg)](https://github.com/Gitlab /morphodeep/actions)
[![codecov](https://codecov.io/gh/Gitlab /morphodeep/branch/main/graph/badge.svg)](https://codecov.io/gh/Gitlab /morphodeep)
[![napari hub](https://img.shields.io/endpoint?url=https://api.napari-hub.org/shields/morphodeep)](https://napari-hub.org/plugins/morphodeep)
[![npe2](https://img.shields.io/badge/plugin-npe2-blue?link=https://napari.org/stable/plugins/index.html)](https://napari.org/stable/plugins/index.html)
[![Copier](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/copier-org/copier/master/img/badge/badge-grayscale-inverted-border-purple.json)](https://github.com/copier-org/copier)

# MorphoDeep

MorphoDeep is a **napari plugin** and **Python package** for performing **membrane instance segmentation** using a pre-trained **U-Net** model.  
It produces a dense **labels image** where each unique integer corresponds to a segmented cell instance.

The plugin is designed for:

- fluorescence images of cell membranes  
- 2D and 3D volumes (with optional isotropic rescaling)  
- interactive use in napari or scripted use in Python

---
## Key features

- **Pre-trained U-Net** for 2D / pseudo-3D membrane instance segmentation  
- **Napari widget** with:
  - image layer selection
  - network patch size (`128` or `256`)
  - 2D / 3D mode
  - optional tiling (“patches mode”) for large images
  - voxel size and Z-axis selection
  - optional isotropic rescaling for anisotropic volumes
  - Automatic model download and caching on first use

---
This [napari] plugin was generated with [copier] using the [napari-plugin-template] (None).

<!--
Don't miss the full getting started guide to set up your new package:
https://github.com/napari/napari-plugin-template#getting-started

and review the napari docs for plugin developers:
https://napari.org/stable/plugins/index.html
-->

## Installation

You can install `morphodeep` via [pip]:

```
pip install morphodeep
```

If napari is not already installed, you can install `morphodeep` with napari and Qt via:

```
pip install "morphodeep[all]"
```


## Contributing

Contributions are very welcome. Tests can be run with [tox], please ensure
the coverage at least stays the same before you submit a pull request.

## License

Distributed under the terms of the [GNU LGPL v3.0] license,
"morphodeep" is free and open source software

## Issues

If you encounter any problems, please [file an issue] along with a detailed description.

[napari]: https://github.com/napari/napari
[copier]: https://copier.readthedocs.io/en/stable/
[@napari]: https://github.com/napari
[MIT]: http://opensource.org/licenses/MIT
[BSD-3]: http://opensource.org/licenses/BSD-3-Clause
[GNU GPL v3.0]: http://www.gnu.org/licenses/gpl-3.0.txt
[GNU LGPL v3.0]: http://www.gnu.org/licenses/lgpl-3.0.txt
[Apache Software License 2.0]: http://www.apache.org/licenses/LICENSE-2.0
[Mozilla Public License 2.0]: https://www.mozilla.org/media/MPL/2.0/index.txt
[napari-plugin-template]: https://github.com/napari/napari-plugin-template

[napari]: https://github.com/napari/napari
[tox]: https://tox.readthedocs.io/en/latest/
[pip]: https://pypi.org/project/pip/
[PyPI]: https://pypi.org/
