# This file was generated by the "yardl" tool. DO NOT EDIT.

# pyright: reportUnusedImport=false
# pyright: reportUnknownArgumentType=false
# pyright: reportUnknownMemberType=false
# pyright: reportUnknownVariableType=false

import datetime
import enum
import types
import typing

import numpy as np
import numpy.typing as npt

from . import yardl_types as yardl
from . import _dtypes


Y = typing.TypeVar("Y")
Y_NP = typing.TypeVar("Y_NP", bound=np.generic)
T = typing.TypeVar("T")
T_NP = typing.TypeVar("T_NP", bound=np.generic)


class AcquisitionFlags(enum.IntFlag):
    FIRST_IN_ENCODE_STEP_1 = 1
    LAST_IN_ENCODE_STEP_1 = 2
    FIRST_IN_ENCODE_STEP_2 = 4
    LAST_IN_ENCODE_STEP_2 = 8
    FIRST_IN_AVERAGE = 16
    LAST_IN_AVERAGE = 32
    FIRST_IN_SLICE = 64
    LAST_IN_SLICE = 128
    FIRST_IN_CONTRAST = 256
    LAST_IN_CONTRAST = 512
    FIRST_IN_PHASE = 1024
    LAST_IN_PHASE = 2048
    FIRST_IN_REPETITION = 4096
    LAST_IN_REPETITION = 8192
    FIRST_IN_SET = 16384
    LAST_IN_SET = 32768
    FIRST_IN_SEGMENT = 65536
    LAST_IN_SEGMENT = 131072
    IS_NOISE_MEASUREMENT = 262144
    IS_PARALLEL_CALIBRATION = 524288
    IS_PARALLEL_CALIBRATION_AND_IMAGING = 1048576
    IS_REVERSE = 2097152
    IS_NAVIGATION_DATA = 4194304
    IS_PHASECORR_DATA = 8388608
    LAST_IN_MEASUREMENT = 16777216
    IS_HPFEEDBACK_DATA = 33554432
    IS_DUMMYSCAN_DATA = 67108864
    IS_RTFEEDBACK_DATA = 134217728
    IS_SURFACECOILCORRECTIONSCAN_DATA = 268435456
    IS_PHASE_STABILIZATION_REFERENCE = 536870912
    IS_PHASE_STABILIZATION = 1073741824

    def __eq__(self, other: object) -> bool:
        return isinstance(other, AcquisitionFlags) and self.value == other.value

    def __hash__(self) -> int:
        return hash(self.value)

    __str__ = enum.Flag.__str__ # type: ignore

class EncodingCounters:
    kspace_encode_step_1: typing.Optional[yardl.UInt32]
    kspace_encode_step_2: typing.Optional[yardl.UInt32]
    average: typing.Optional[yardl.UInt32]
    slice: typing.Optional[yardl.UInt32]
    contrast: typing.Optional[yardl.UInt32]
    phase: typing.Optional[yardl.UInt32]
    repetition: typing.Optional[yardl.UInt32]
    set: typing.Optional[yardl.UInt32]
    segment: typing.Optional[yardl.UInt32]
    user: list[yardl.UInt32]

    def __init__(self, *,
        kspace_encode_step_1: typing.Optional[yardl.UInt32] = None,
        kspace_encode_step_2: typing.Optional[yardl.UInt32] = None,
        average: typing.Optional[yardl.UInt32] = None,
        slice: typing.Optional[yardl.UInt32] = None,
        contrast: typing.Optional[yardl.UInt32] = None,
        phase: typing.Optional[yardl.UInt32] = None,
        repetition: typing.Optional[yardl.UInt32] = None,
        set: typing.Optional[yardl.UInt32] = None,
        segment: typing.Optional[yardl.UInt32] = None,
        user: typing.Optional[list[yardl.UInt32]] = None,
    ):
        self.kspace_encode_step_1 = kspace_encode_step_1
        self.kspace_encode_step_2 = kspace_encode_step_2
        self.average = average
        self.slice = slice
        self.contrast = contrast
        self.phase = phase
        self.repetition = repetition
        self.set = set
        self.segment = segment
        self.user = user if user is not None else []

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, EncodingCounters)
            and self.kspace_encode_step_1 == other.kspace_encode_step_1
            and self.kspace_encode_step_2 == other.kspace_encode_step_2
            and self.average == other.average
            and self.slice == other.slice
            and self.contrast == other.contrast
            and self.phase == other.phase
            and self.repetition == other.repetition
            and self.set == other.set
            and self.segment == other.segment
            and self.user == other.user
        )

    def __str__(self) -> str:
        return f"EncodingCounters(kspaceEncodeStep1={self.kspace_encode_step_1}, kspaceEncodeStep2={self.kspace_encode_step_2}, average={self.average}, slice={self.slice}, contrast={self.contrast}, phase={self.phase}, repetition={self.repetition}, set={self.set}, segment={self.segment}, user={self.user})"

    def __repr__(self) -> str:
        return f"EncodingCounters(kspaceEncodeStep1={repr(self.kspace_encode_step_1)}, kspaceEncodeStep2={repr(self.kspace_encode_step_2)}, average={repr(self.average)}, slice={repr(self.slice)}, contrast={repr(self.contrast)}, phase={repr(self.phase)}, repetition={repr(self.repetition)}, set={repr(self.set)}, segment={repr(self.segment)}, user={repr(self.user)})"


AcquisitionData = npt.NDArray[np.complex64]

TrajectoryData = npt.NDArray[np.float32]

class Acquisition:
    flags: AcquisitionFlags
    idx: EncodingCounters
    measurement_uid: yardl.UInt32
    scan_counter: typing.Optional[yardl.UInt32]
    acquisition_time_stamp: typing.Optional[yardl.UInt32]
    physiology_time_stamp: list[yardl.UInt32]
    channel_order: list[yardl.UInt32]
    discard_pre: typing.Optional[yardl.UInt32]
    discard_post: typing.Optional[yardl.UInt32]
    center_sample: typing.Optional[yardl.UInt32]
    encoding_space_ref: typing.Optional[yardl.UInt32]
    sample_time_us: typing.Optional[yardl.Float32]
    position: npt.NDArray[np.float32]
    read_dir: npt.NDArray[np.float32]
    phase_dir: npt.NDArray[np.float32]
    slice_dir: npt.NDArray[np.float32]
    patient_table_position: npt.NDArray[np.float32]
    user_int: list[yardl.Int32]
    user_float: list[yardl.Float32]
    data: AcquisitionData
    trajectory: TrajectoryData

    def __init__(self, *,
        flags: AcquisitionFlags = AcquisitionFlags(0),
        idx: typing.Optional[EncodingCounters] = None,
        measurement_uid: yardl.UInt32 = 0,
        scan_counter: typing.Optional[yardl.UInt32] = None,
        acquisition_time_stamp: typing.Optional[yardl.UInt32] = None,
        physiology_time_stamp: typing.Optional[list[yardl.UInt32]] = None,
        channel_order: typing.Optional[list[yardl.UInt32]] = None,
        discard_pre: typing.Optional[yardl.UInt32] = None,
        discard_post: typing.Optional[yardl.UInt32] = None,
        center_sample: typing.Optional[yardl.UInt32] = None,
        encoding_space_ref: typing.Optional[yardl.UInt32] = None,
        sample_time_us: typing.Optional[yardl.Float32] = None,
        position: typing.Optional[npt.NDArray[np.float32]] = None,
        read_dir: typing.Optional[npt.NDArray[np.float32]] = None,
        phase_dir: typing.Optional[npt.NDArray[np.float32]] = None,
        slice_dir: typing.Optional[npt.NDArray[np.float32]] = None,
        patient_table_position: typing.Optional[npt.NDArray[np.float32]] = None,
        user_int: typing.Optional[list[yardl.Int32]] = None,
        user_float: typing.Optional[list[yardl.Float32]] = None,
        data: typing.Optional[AcquisitionData] = None,
        trajectory: typing.Optional[TrajectoryData] = None,
    ):
        self.flags = flags
        self.idx = idx if idx is not None else EncodingCounters()
        self.measurement_uid = measurement_uid
        self.scan_counter = scan_counter
        self.acquisition_time_stamp = acquisition_time_stamp
        self.physiology_time_stamp = physiology_time_stamp if physiology_time_stamp is not None else []
        self.channel_order = channel_order if channel_order is not None else []
        self.discard_pre = discard_pre
        self.discard_post = discard_post
        self.center_sample = center_sample
        self.encoding_space_ref = encoding_space_ref
        self.sample_time_us = sample_time_us
        self.position = position if position is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.read_dir = read_dir if read_dir is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.phase_dir = phase_dir if phase_dir is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.slice_dir = slice_dir if slice_dir is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.patient_table_position = patient_table_position if patient_table_position is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.user_int = user_int if user_int is not None else []
        self.user_float = user_float if user_float is not None else []
        self.data = data if data is not None else np.zeros((0, 0), dtype=np.dtype(np.complex64))
        self.trajectory = trajectory if trajectory is not None else np.zeros((0, 0), dtype=np.dtype(np.float32))

    def coils(self) -> yardl.Size:
        return self.data.shape[0]

    def samples(self) -> yardl.Size:
        return self.data.shape[1]

    def active_channels(self) -> yardl.Size:
        return len(self.channel_order)

    def trajectory_dimensions(self) -> yardl.Size:
        return self.trajectory.shape[0]

    def trajectory_samples(self) -> yardl.Size:
        return self.trajectory.shape[1]

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, Acquisition)
            and self.flags == other.flags
            and self.idx == other.idx
            and self.measurement_uid == other.measurement_uid
            and self.scan_counter == other.scan_counter
            and self.acquisition_time_stamp == other.acquisition_time_stamp
            and self.physiology_time_stamp == other.physiology_time_stamp
            and self.channel_order == other.channel_order
            and self.discard_pre == other.discard_pre
            and self.discard_post == other.discard_post
            and self.center_sample == other.center_sample
            and self.encoding_space_ref == other.encoding_space_ref
            and self.sample_time_us == other.sample_time_us
            and yardl.structural_equal(self.position, other.position)
            and yardl.structural_equal(self.read_dir, other.read_dir)
            and yardl.structural_equal(self.phase_dir, other.phase_dir)
            and yardl.structural_equal(self.slice_dir, other.slice_dir)
            and yardl.structural_equal(self.patient_table_position, other.patient_table_position)
            and self.user_int == other.user_int
            and self.user_float == other.user_float
            and yardl.structural_equal(self.data, other.data)
            and yardl.structural_equal(self.trajectory, other.trajectory)
        )

    def __str__(self) -> str:
        return f"Acquisition(flags={self.flags}, idx={self.idx}, measurementUid={self.measurement_uid}, scanCounter={self.scan_counter}, acquisitionTimeStamp={self.acquisition_time_stamp}, physiologyTimeStamp={self.physiology_time_stamp}, channelOrder={self.channel_order}, discardPre={self.discard_pre}, discardPost={self.discard_post}, centerSample={self.center_sample}, encodingSpaceRef={self.encoding_space_ref}, sampleTimeUs={self.sample_time_us}, position={self.position}, readDir={self.read_dir}, phaseDir={self.phase_dir}, sliceDir={self.slice_dir}, patientTablePosition={self.patient_table_position}, userInt={self.user_int}, userFloat={self.user_float}, data={self.data}, trajectory={self.trajectory})"

    def __repr__(self) -> str:
        return f"Acquisition(flags={repr(self.flags)}, idx={repr(self.idx)}, measurementUid={repr(self.measurement_uid)}, scanCounter={repr(self.scan_counter)}, acquisitionTimeStamp={repr(self.acquisition_time_stamp)}, physiologyTimeStamp={repr(self.physiology_time_stamp)}, channelOrder={repr(self.channel_order)}, discardPre={repr(self.discard_pre)}, discardPost={repr(self.discard_post)}, centerSample={repr(self.center_sample)}, encodingSpaceRef={repr(self.encoding_space_ref)}, sampleTimeUs={repr(self.sample_time_us)}, position={repr(self.position)}, readDir={repr(self.read_dir)}, phaseDir={repr(self.phase_dir)}, sliceDir={repr(self.slice_dir)}, patientTablePosition={repr(self.patient_table_position)}, userInt={repr(self.user_int)}, userFloat={repr(self.user_float)}, data={repr(self.data)}, trajectory={repr(self.trajectory)})"


class PatientGender(yardl.OutOfRangeEnum):
    M = 0
    F = 1
    O = 2

class SubjectInformationType:
    patient_name: typing.Optional[str]
    patient_weight_kg: typing.Optional[yardl.Float32]
    patient_height_m: typing.Optional[yardl.Float32]
    patient_id: typing.Optional[str]
    patient_birthdate: typing.Optional[datetime.date]
    patient_gender: typing.Optional[PatientGender]

    def __init__(self, *,
        patient_name: typing.Optional[str] = None,
        patient_weight_kg: typing.Optional[yardl.Float32] = None,
        patient_height_m: typing.Optional[yardl.Float32] = None,
        patient_id: typing.Optional[str] = None,
        patient_birthdate: typing.Optional[datetime.date] = None,
        patient_gender: typing.Optional[PatientGender] = None,
    ):
        self.patient_name = patient_name
        self.patient_weight_kg = patient_weight_kg
        self.patient_height_m = patient_height_m
        self.patient_id = patient_id
        self.patient_birthdate = patient_birthdate
        self.patient_gender = patient_gender

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, SubjectInformationType)
            and self.patient_name == other.patient_name
            and self.patient_weight_kg == other.patient_weight_kg
            and self.patient_height_m == other.patient_height_m
            and self.patient_id == other.patient_id
            and self.patient_birthdate == other.patient_birthdate
            and self.patient_gender == other.patient_gender
        )

    def __str__(self) -> str:
        return f"SubjectInformationType(patientName={self.patient_name}, patientWeightKg={self.patient_weight_kg}, patientHeightM={self.patient_height_m}, patientID={self.patient_id}, patientBirthdate={self.patient_birthdate}, patientGender={self.patient_gender})"

    def __repr__(self) -> str:
        return f"SubjectInformationType(patientName={repr(self.patient_name)}, patientWeightKg={repr(self.patient_weight_kg)}, patientHeightM={repr(self.patient_height_m)}, patientID={repr(self.patient_id)}, patientBirthdate={repr(self.patient_birthdate)}, patientGender={repr(self.patient_gender)})"


class StudyInformationType:
    study_date: typing.Optional[datetime.date]
    study_time: typing.Optional[yardl.Time]
    study_id: typing.Optional[str]
    accession_number: typing.Optional[yardl.Int64]
    referring_physician_name: typing.Optional[str]
    study_description: typing.Optional[str]
    study_instance_uid: typing.Optional[str]
    body_part_examined: typing.Optional[str]

    def __init__(self, *,
        study_date: typing.Optional[datetime.date] = None,
        study_time: typing.Optional[yardl.Time] = None,
        study_id: typing.Optional[str] = None,
        accession_number: typing.Optional[yardl.Int64] = None,
        referring_physician_name: typing.Optional[str] = None,
        study_description: typing.Optional[str] = None,
        study_instance_uid: typing.Optional[str] = None,
        body_part_examined: typing.Optional[str] = None,
    ):
        self.study_date = study_date
        self.study_time = study_time
        self.study_id = study_id
        self.accession_number = accession_number
        self.referring_physician_name = referring_physician_name
        self.study_description = study_description
        self.study_instance_uid = study_instance_uid
        self.body_part_examined = body_part_examined

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, StudyInformationType)
            and self.study_date == other.study_date
            and self.study_time == other.study_time
            and self.study_id == other.study_id
            and self.accession_number == other.accession_number
            and self.referring_physician_name == other.referring_physician_name
            and self.study_description == other.study_description
            and self.study_instance_uid == other.study_instance_uid
            and self.body_part_examined == other.body_part_examined
        )

    def __str__(self) -> str:
        return f"StudyInformationType(studyDate={self.study_date}, studyTime={self.study_time}, studyID={self.study_id}, accessionNumber={self.accession_number}, referringPhysicianName={self.referring_physician_name}, studyDescription={self.study_description}, studyInstanceUID={self.study_instance_uid}, bodyPartExamined={self.body_part_examined})"

    def __repr__(self) -> str:
        return f"StudyInformationType(studyDate={repr(self.study_date)}, studyTime={repr(self.study_time)}, studyID={repr(self.study_id)}, accessionNumber={repr(self.accession_number)}, referringPhysicianName={repr(self.referring_physician_name)}, studyDescription={repr(self.study_description)}, studyInstanceUID={repr(self.study_instance_uid)}, bodyPartExamined={repr(self.body_part_examined)})"


class PatientPosition(yardl.OutOfRangeEnum):
    H_FP = 0
    H_FS = 1
    H_FDR = 2
    H_FDL = 3
    F_FP = 4
    F_FS = 5
    F_FDR = 6
    F_FDL = 7

class ThreeDimensionalFloat:
    x: yardl.Float32
    y: yardl.Float32
    z: yardl.Float32

    def __init__(self, *,
        x: yardl.Float32 = 0.0,
        y: yardl.Float32 = 0.0,
        z: yardl.Float32 = 0.0,
    ):
        self.x = x
        self.y = y
        self.z = z

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, ThreeDimensionalFloat)
            and self.x == other.x
            and self.y == other.y
            and self.z == other.z
        )

    def __str__(self) -> str:
        return f"ThreeDimensionalFloat(x={self.x}, y={self.y}, z={self.z})"

    def __repr__(self) -> str:
        return f"ThreeDimensionalFloat(x={repr(self.x)}, y={repr(self.y)}, z={repr(self.z)})"


class MeasurementDependencyType:
    dependency_type: str
    measurement_id: str

    def __init__(self, *,
        dependency_type: str = "",
        measurement_id: str = "",
    ):
        self.dependency_type = dependency_type
        self.measurement_id = measurement_id

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, MeasurementDependencyType)
            and self.dependency_type == other.dependency_type
            and self.measurement_id == other.measurement_id
        )

    def __str__(self) -> str:
        return f"MeasurementDependencyType(dependencyType={self.dependency_type}, measurementID={self.measurement_id})"

    def __repr__(self) -> str:
        return f"MeasurementDependencyType(dependencyType={repr(self.dependency_type)}, measurementID={repr(self.measurement_id)})"


class ReferencedImageSequenceType:
    referenced_sop_instance_uid: list[str]

    def __init__(self, *,
        referenced_sop_instance_uid: typing.Optional[list[str]] = None,
    ):
        self.referenced_sop_instance_uid = referenced_sop_instance_uid if referenced_sop_instance_uid is not None else []

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, ReferencedImageSequenceType)
            and self.referenced_sop_instance_uid == other.referenced_sop_instance_uid
        )

    def __str__(self) -> str:
        return f"ReferencedImageSequenceType(referencedSOPInstanceUID={self.referenced_sop_instance_uid})"

    def __repr__(self) -> str:
        return f"ReferencedImageSequenceType(referencedSOPInstanceUID={repr(self.referenced_sop_instance_uid)})"


class MeasurementInformationType:
    measurement_id: typing.Optional[str]
    series_date: typing.Optional[datetime.date]
    series_time: typing.Optional[yardl.Time]
    patient_position: PatientPosition
    relative_table_position: typing.Optional[ThreeDimensionalFloat]
    initial_series_number: typing.Optional[yardl.Int64]
    protocol_name: typing.Optional[str]
    sequence_name: typing.Optional[str]
    series_description: typing.Optional[str]
    measurement_dependency: list[MeasurementDependencyType]
    series_instance_uid_root: typing.Optional[str]
    frame_of_reference_uid: typing.Optional[str]
    referenced_image_sequence: typing.Optional[ReferencedImageSequenceType]

    def __init__(self, *,
        measurement_id: typing.Optional[str] = None,
        series_date: typing.Optional[datetime.date] = None,
        series_time: typing.Optional[yardl.Time] = None,
        patient_position: PatientPosition = PatientPosition.H_FP,
        relative_table_position: typing.Optional[ThreeDimensionalFloat] = None,
        initial_series_number: typing.Optional[yardl.Int64] = None,
        protocol_name: typing.Optional[str] = None,
        sequence_name: typing.Optional[str] = None,
        series_description: typing.Optional[str] = None,
        measurement_dependency: typing.Optional[list[MeasurementDependencyType]] = None,
        series_instance_uid_root: typing.Optional[str] = None,
        frame_of_reference_uid: typing.Optional[str] = None,
        referenced_image_sequence: typing.Optional[ReferencedImageSequenceType] = None,
    ):
        self.measurement_id = measurement_id
        self.series_date = series_date
        self.series_time = series_time
        self.patient_position = patient_position
        self.relative_table_position = relative_table_position
        self.initial_series_number = initial_series_number
        self.protocol_name = protocol_name
        self.sequence_name = sequence_name
        self.series_description = series_description
        self.measurement_dependency = measurement_dependency if measurement_dependency is not None else []
        self.series_instance_uid_root = series_instance_uid_root
        self.frame_of_reference_uid = frame_of_reference_uid
        self.referenced_image_sequence = referenced_image_sequence

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, MeasurementInformationType)
            and self.measurement_id == other.measurement_id
            and self.series_date == other.series_date
            and self.series_time == other.series_time
            and self.patient_position == other.patient_position
            and self.relative_table_position == other.relative_table_position
            and self.initial_series_number == other.initial_series_number
            and self.protocol_name == other.protocol_name
            and self.sequence_name == other.sequence_name
            and self.series_description == other.series_description
            and self.measurement_dependency == other.measurement_dependency
            and self.series_instance_uid_root == other.series_instance_uid_root
            and self.frame_of_reference_uid == other.frame_of_reference_uid
            and self.referenced_image_sequence == other.referenced_image_sequence
        )

    def __str__(self) -> str:
        return f"MeasurementInformationType(measurementID={self.measurement_id}, seriesDate={self.series_date}, seriesTime={self.series_time}, patientPosition={self.patient_position}, relativeTablePosition={self.relative_table_position}, initialSeriesNumber={self.initial_series_number}, protocolName={self.protocol_name}, sequenceName={self.sequence_name}, seriesDescription={self.series_description}, measurementDependency={self.measurement_dependency}, seriesInstanceUIDRoot={self.series_instance_uid_root}, frameOfReferenceUID={self.frame_of_reference_uid}, referencedImageSequence={self.referenced_image_sequence})"

    def __repr__(self) -> str:
        return f"MeasurementInformationType(measurementID={repr(self.measurement_id)}, seriesDate={repr(self.series_date)}, seriesTime={repr(self.series_time)}, patientPosition={repr(self.patient_position)}, relativeTablePosition={repr(self.relative_table_position)}, initialSeriesNumber={repr(self.initial_series_number)}, protocolName={repr(self.protocol_name)}, sequenceName={repr(self.sequence_name)}, seriesDescription={repr(self.series_description)}, measurementDependency={repr(self.measurement_dependency)}, seriesInstanceUIDRoot={repr(self.series_instance_uid_root)}, frameOfReferenceUID={repr(self.frame_of_reference_uid)}, referencedImageSequence={repr(self.referenced_image_sequence)})"


class CoilLabelType:
    coil_number: yardl.UInt32
    coil_name: str

    def __init__(self, *,
        coil_number: yardl.UInt32 = 0,
        coil_name: str = "",
    ):
        self.coil_number = coil_number
        self.coil_name = coil_name

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, CoilLabelType)
            and self.coil_number == other.coil_number
            and self.coil_name == other.coil_name
        )

    def __str__(self) -> str:
        return f"CoilLabelType(coilNumber={self.coil_number}, coilName={self.coil_name})"

    def __repr__(self) -> str:
        return f"CoilLabelType(coilNumber={repr(self.coil_number)}, coilName={repr(self.coil_name)})"


class AcquisitionSystemInformationType:
    system_vendor: typing.Optional[str]
    system_model: typing.Optional[str]
    system_field_strength_t: typing.Optional[yardl.Float32]
    relative_receiver_noise_bandwidth: typing.Optional[yardl.Float32]
    receiver_channels: typing.Optional[yardl.UInt32]
    coil_label: list[CoilLabelType]
    institution_name: typing.Optional[str]
    station_name: typing.Optional[str]
    device_id: typing.Optional[str]
    device_serial_number: typing.Optional[str]

    def __init__(self, *,
        system_vendor: typing.Optional[str] = None,
        system_model: typing.Optional[str] = None,
        system_field_strength_t: typing.Optional[yardl.Float32] = None,
        relative_receiver_noise_bandwidth: typing.Optional[yardl.Float32] = None,
        receiver_channels: typing.Optional[yardl.UInt32] = None,
        coil_label: typing.Optional[list[CoilLabelType]] = None,
        institution_name: typing.Optional[str] = None,
        station_name: typing.Optional[str] = None,
        device_id: typing.Optional[str] = None,
        device_serial_number: typing.Optional[str] = None,
    ):
        self.system_vendor = system_vendor
        self.system_model = system_model
        self.system_field_strength_t = system_field_strength_t
        self.relative_receiver_noise_bandwidth = relative_receiver_noise_bandwidth
        self.receiver_channels = receiver_channels
        self.coil_label = coil_label if coil_label is not None else []
        self.institution_name = institution_name
        self.station_name = station_name
        self.device_id = device_id
        self.device_serial_number = device_serial_number

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, AcquisitionSystemInformationType)
            and self.system_vendor == other.system_vendor
            and self.system_model == other.system_model
            and self.system_field_strength_t == other.system_field_strength_t
            and self.relative_receiver_noise_bandwidth == other.relative_receiver_noise_bandwidth
            and self.receiver_channels == other.receiver_channels
            and self.coil_label == other.coil_label
            and self.institution_name == other.institution_name
            and self.station_name == other.station_name
            and self.device_id == other.device_id
            and self.device_serial_number == other.device_serial_number
        )

    def __str__(self) -> str:
        return f"AcquisitionSystemInformationType(systemVendor={self.system_vendor}, systemModel={self.system_model}, systemFieldStrengthT={self.system_field_strength_t}, relativeReceiverNoiseBandwidth={self.relative_receiver_noise_bandwidth}, receiverChannels={self.receiver_channels}, coilLabel={self.coil_label}, institutionName={self.institution_name}, stationName={self.station_name}, deviceID={self.device_id}, deviceSerialNumber={self.device_serial_number})"

    def __repr__(self) -> str:
        return f"AcquisitionSystemInformationType(systemVendor={repr(self.system_vendor)}, systemModel={repr(self.system_model)}, systemFieldStrengthT={repr(self.system_field_strength_t)}, relativeReceiverNoiseBandwidth={repr(self.relative_receiver_noise_bandwidth)}, receiverChannels={repr(self.receiver_channels)}, coilLabel={repr(self.coil_label)}, institutionName={repr(self.institution_name)}, stationName={repr(self.station_name)}, deviceID={repr(self.device_id)}, deviceSerialNumber={repr(self.device_serial_number)})"


class ExperimentalConditionsType:
    h1resonance_frequency_hz: yardl.Int64

    def __init__(self, *,
        h1resonance_frequency_hz: yardl.Int64 = 0,
    ):
        self.h1resonance_frequency_hz = h1resonance_frequency_hz

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, ExperimentalConditionsType)
            and self.h1resonance_frequency_hz == other.h1resonance_frequency_hz
        )

    def __str__(self) -> str:
        return f"ExperimentalConditionsType(h1resonanceFrequencyHz={self.h1resonance_frequency_hz})"

    def __repr__(self) -> str:
        return f"ExperimentalConditionsType(h1resonanceFrequencyHz={repr(self.h1resonance_frequency_hz)})"


class MatrixSizeType:
    x: yardl.UInt32
    y: yardl.UInt32
    z: yardl.UInt32

    def __init__(self, *,
        x: yardl.UInt32 = 0,
        y: yardl.UInt32 = 0,
        z: yardl.UInt32 = 0,
    ):
        self.x = x
        self.y = y
        self.z = z

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, MatrixSizeType)
            and self.x == other.x
            and self.y == other.y
            and self.z == other.z
        )

    def __str__(self) -> str:
        return f"MatrixSizeType(x={self.x}, y={self.y}, z={self.z})"

    def __repr__(self) -> str:
        return f"MatrixSizeType(x={repr(self.x)}, y={repr(self.y)}, z={repr(self.z)})"


class FieldOfViewMm:
    x: yardl.Float32
    y: yardl.Float32
    z: yardl.Float32

    def __init__(self, *,
        x: yardl.Float32 = 0.0,
        y: yardl.Float32 = 0.0,
        z: yardl.Float32 = 0.0,
    ):
        self.x = x
        self.y = y
        self.z = z

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, FieldOfViewMm)
            and self.x == other.x
            and self.y == other.y
            and self.z == other.z
        )

    def __str__(self) -> str:
        return f"FieldOfViewMm(x={self.x}, y={self.y}, z={self.z})"

    def __repr__(self) -> str:
        return f"FieldOfViewMm(x={repr(self.x)}, y={repr(self.y)}, z={repr(self.z)})"


class EncodingSpaceType:
    matrix_size: MatrixSizeType
    field_of_view_mm: FieldOfViewMm

    def __init__(self, *,
        matrix_size: typing.Optional[MatrixSizeType] = None,
        field_of_view_mm: typing.Optional[FieldOfViewMm] = None,
    ):
        self.matrix_size = matrix_size if matrix_size is not None else MatrixSizeType()
        self.field_of_view_mm = field_of_view_mm if field_of_view_mm is not None else FieldOfViewMm()

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, EncodingSpaceType)
            and self.matrix_size == other.matrix_size
            and self.field_of_view_mm == other.field_of_view_mm
        )

    def __str__(self) -> str:
        return f"EncodingSpaceType(matrixSize={self.matrix_size}, fieldOfViewMm={self.field_of_view_mm})"

    def __repr__(self) -> str:
        return f"EncodingSpaceType(matrixSize={repr(self.matrix_size)}, fieldOfViewMm={repr(self.field_of_view_mm)})"


class LimitType:
    minimum: yardl.UInt32
    maximum: yardl.UInt32
    center: yardl.UInt32

    def __init__(self, *,
        minimum: yardl.UInt32 = 0,
        maximum: yardl.UInt32 = 0,
        center: yardl.UInt32 = 0,
    ):
        self.minimum = minimum
        self.maximum = maximum
        self.center = center

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, LimitType)
            and self.minimum == other.minimum
            and self.maximum == other.maximum
            and self.center == other.center
        )

    def __str__(self) -> str:
        return f"LimitType(minimum={self.minimum}, maximum={self.maximum}, center={self.center})"

    def __repr__(self) -> str:
        return f"LimitType(minimum={repr(self.minimum)}, maximum={repr(self.maximum)}, center={repr(self.center)})"


class EncodingLimitsType:
    kspace_encoding_step_0: typing.Optional[LimitType]
    kspace_encoding_step_1: typing.Optional[LimitType]
    kspace_encoding_step_2: typing.Optional[LimitType]
    average: typing.Optional[LimitType]
    slice: typing.Optional[LimitType]
    contrast: typing.Optional[LimitType]
    phase: typing.Optional[LimitType]
    repetition: typing.Optional[LimitType]
    set: typing.Optional[LimitType]
    segment: typing.Optional[LimitType]
    user_0: typing.Optional[LimitType]
    user_1: typing.Optional[LimitType]
    user_2: typing.Optional[LimitType]
    user_3: typing.Optional[LimitType]
    user_4: typing.Optional[LimitType]
    user_5: typing.Optional[LimitType]
    user_6: typing.Optional[LimitType]
    user_7: typing.Optional[LimitType]

    def __init__(self, *,
        kspace_encoding_step_0: typing.Optional[LimitType] = None,
        kspace_encoding_step_1: typing.Optional[LimitType] = None,
        kspace_encoding_step_2: typing.Optional[LimitType] = None,
        average: typing.Optional[LimitType] = None,
        slice: typing.Optional[LimitType] = None,
        contrast: typing.Optional[LimitType] = None,
        phase: typing.Optional[LimitType] = None,
        repetition: typing.Optional[LimitType] = None,
        set: typing.Optional[LimitType] = None,
        segment: typing.Optional[LimitType] = None,
        user_0: typing.Optional[LimitType] = None,
        user_1: typing.Optional[LimitType] = None,
        user_2: typing.Optional[LimitType] = None,
        user_3: typing.Optional[LimitType] = None,
        user_4: typing.Optional[LimitType] = None,
        user_5: typing.Optional[LimitType] = None,
        user_6: typing.Optional[LimitType] = None,
        user_7: typing.Optional[LimitType] = None,
    ):
        self.kspace_encoding_step_0 = kspace_encoding_step_0
        self.kspace_encoding_step_1 = kspace_encoding_step_1
        self.kspace_encoding_step_2 = kspace_encoding_step_2
        self.average = average
        self.slice = slice
        self.contrast = contrast
        self.phase = phase
        self.repetition = repetition
        self.set = set
        self.segment = segment
        self.user_0 = user_0
        self.user_1 = user_1
        self.user_2 = user_2
        self.user_3 = user_3
        self.user_4 = user_4
        self.user_5 = user_5
        self.user_6 = user_6
        self.user_7 = user_7

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, EncodingLimitsType)
            and self.kspace_encoding_step_0 == other.kspace_encoding_step_0
            and self.kspace_encoding_step_1 == other.kspace_encoding_step_1
            and self.kspace_encoding_step_2 == other.kspace_encoding_step_2
            and self.average == other.average
            and self.slice == other.slice
            and self.contrast == other.contrast
            and self.phase == other.phase
            and self.repetition == other.repetition
            and self.set == other.set
            and self.segment == other.segment
            and self.user_0 == other.user_0
            and self.user_1 == other.user_1
            and self.user_2 == other.user_2
            and self.user_3 == other.user_3
            and self.user_4 == other.user_4
            and self.user_5 == other.user_5
            and self.user_6 == other.user_6
            and self.user_7 == other.user_7
        )

    def __str__(self) -> str:
        return f"EncodingLimitsType(kspaceEncodingStep0={self.kspace_encoding_step_0}, kspaceEncodingStep1={self.kspace_encoding_step_1}, kspaceEncodingStep2={self.kspace_encoding_step_2}, average={self.average}, slice={self.slice}, contrast={self.contrast}, phase={self.phase}, repetition={self.repetition}, set={self.set}, segment={self.segment}, user0={self.user_0}, user1={self.user_1}, user2={self.user_2}, user3={self.user_3}, user4={self.user_4}, user5={self.user_5}, user6={self.user_6}, user7={self.user_7})"

    def __repr__(self) -> str:
        return f"EncodingLimitsType(kspaceEncodingStep0={repr(self.kspace_encoding_step_0)}, kspaceEncodingStep1={repr(self.kspace_encoding_step_1)}, kspaceEncodingStep2={repr(self.kspace_encoding_step_2)}, average={repr(self.average)}, slice={repr(self.slice)}, contrast={repr(self.contrast)}, phase={repr(self.phase)}, repetition={repr(self.repetition)}, set={repr(self.set)}, segment={repr(self.segment)}, user0={repr(self.user_0)}, user1={repr(self.user_1)}, user2={repr(self.user_2)}, user3={repr(self.user_3)}, user4={repr(self.user_4)}, user5={repr(self.user_5)}, user6={repr(self.user_6)}, user7={repr(self.user_7)})"


class Trajectory(yardl.OutOfRangeEnum):
    CARTESIAN = 0
    EPI = 1
    RADIAL = 2
    GOLDENANGLE = 3
    SPIRAL = 4
    OTHER = 5

class UserParameterLongType:
    name: str
    value: yardl.Int64

    def __init__(self, *,
        name: str = "",
        value: yardl.Int64 = 0,
    ):
        self.name = name
        self.value = value

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, UserParameterLongType)
            and self.name == other.name
            and self.value == other.value
        )

    def __str__(self) -> str:
        return f"UserParameterLongType(name={self.name}, value={self.value})"

    def __repr__(self) -> str:
        return f"UserParameterLongType(name={repr(self.name)}, value={repr(self.value)})"


class UserParameterDoubleType:
    name: str
    value: yardl.Float64

    def __init__(self, *,
        name: str = "",
        value: yardl.Float64 = 0.0,
    ):
        self.name = name
        self.value = value

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, UserParameterDoubleType)
            and self.name == other.name
            and self.value == other.value
        )

    def __str__(self) -> str:
        return f"UserParameterDoubleType(name={self.name}, value={self.value})"

    def __repr__(self) -> str:
        return f"UserParameterDoubleType(name={repr(self.name)}, value={repr(self.value)})"


class UserParameterStringType:
    name: str
    value: str

    def __init__(self, *,
        name: str = "",
        value: str = "",
    ):
        self.name = name
        self.value = value

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, UserParameterStringType)
            and self.name == other.name
            and self.value == other.value
        )

    def __str__(self) -> str:
        return f"UserParameterStringType(name={self.name}, value={self.value})"

    def __repr__(self) -> str:
        return f"UserParameterStringType(name={repr(self.name)}, value={repr(self.value)})"


class TrajectoryDescriptionType:
    identifier: str
    user_parameter_long: list[UserParameterLongType]
    user_parameter_double: list[UserParameterDoubleType]
    user_parameter_string: list[UserParameterStringType]
    comment: typing.Optional[str]

    def __init__(self, *,
        identifier: str = "",
        user_parameter_long: typing.Optional[list[UserParameterLongType]] = None,
        user_parameter_double: typing.Optional[list[UserParameterDoubleType]] = None,
        user_parameter_string: typing.Optional[list[UserParameterStringType]] = None,
        comment: typing.Optional[str] = None,
    ):
        self.identifier = identifier
        self.user_parameter_long = user_parameter_long if user_parameter_long is not None else []
        self.user_parameter_double = user_parameter_double if user_parameter_double is not None else []
        self.user_parameter_string = user_parameter_string if user_parameter_string is not None else []
        self.comment = comment

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, TrajectoryDescriptionType)
            and self.identifier == other.identifier
            and self.user_parameter_long == other.user_parameter_long
            and self.user_parameter_double == other.user_parameter_double
            and self.user_parameter_string == other.user_parameter_string
            and self.comment == other.comment
        )

    def __str__(self) -> str:
        return f"TrajectoryDescriptionType(identifier={self.identifier}, userParameterLong={self.user_parameter_long}, userParameterDouble={self.user_parameter_double}, userParameterString={self.user_parameter_string}, comment={self.comment})"

    def __repr__(self) -> str:
        return f"TrajectoryDescriptionType(identifier={repr(self.identifier)}, userParameterLong={repr(self.user_parameter_long)}, userParameterDouble={repr(self.user_parameter_double)}, userParameterString={repr(self.user_parameter_string)}, comment={repr(self.comment)})"


class AccelerationFactorType:
    kspace_encoding_step_1: yardl.UInt32
    kspace_encoding_step_2: yardl.UInt32

    def __init__(self, *,
        kspace_encoding_step_1: yardl.UInt32 = 0,
        kspace_encoding_step_2: yardl.UInt32 = 0,
    ):
        self.kspace_encoding_step_1 = kspace_encoding_step_1
        self.kspace_encoding_step_2 = kspace_encoding_step_2

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, AccelerationFactorType)
            and self.kspace_encoding_step_1 == other.kspace_encoding_step_1
            and self.kspace_encoding_step_2 == other.kspace_encoding_step_2
        )

    def __str__(self) -> str:
        return f"AccelerationFactorType(kspaceEncodingStep1={self.kspace_encoding_step_1}, kspaceEncodingStep2={self.kspace_encoding_step_2})"

    def __repr__(self) -> str:
        return f"AccelerationFactorType(kspaceEncodingStep1={repr(self.kspace_encoding_step_1)}, kspaceEncodingStep2={repr(self.kspace_encoding_step_2)})"


class CalibrationMode(yardl.OutOfRangeEnum):
    EMBEDDED = 0
    INTERLEAVED = 1
    SEPARATE = 2
    EXTERNAL = 3
    OTHER = 4

class InterleavingDimension(yardl.OutOfRangeEnum):
    PHASE = 0
    REPETITION = 1
    CONTRAST = 2
    AVERAGE = 3
    OTHER = 4

class MultibandSpacingType:
    d_z: list[yardl.Float32]

    def __init__(self, *,
        d_z: typing.Optional[list[yardl.Float32]] = None,
    ):
        self.d_z = d_z if d_z is not None else []

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, MultibandSpacingType)
            and self.d_z == other.d_z
        )

    def __str__(self) -> str:
        return f"MultibandSpacingType(dZ={self.d_z})"

    def __repr__(self) -> str:
        return f"MultibandSpacingType(dZ={repr(self.d_z)})"


class Calibration(yardl.OutOfRangeEnum):
    SEPARABLE_2D = 0
    FULL_3D = 1
    OTHER = 2

class MultibandType:
    spacing: list[MultibandSpacingType]
    delta_kz: yardl.Float32
    multiband_factor: yardl.UInt32
    calibration: Calibration
    calibration_encoding: yardl.UInt64

    def __init__(self, *,
        spacing: typing.Optional[list[MultibandSpacingType]] = None,
        delta_kz: yardl.Float32 = 0.0,
        multiband_factor: yardl.UInt32 = 0,
        calibration: Calibration = Calibration.SEPARABLE_2D,
        calibration_encoding: yardl.UInt64 = 0,
    ):
        self.spacing = spacing if spacing is not None else []
        self.delta_kz = delta_kz
        self.multiband_factor = multiband_factor
        self.calibration = calibration
        self.calibration_encoding = calibration_encoding

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, MultibandType)
            and self.spacing == other.spacing
            and self.delta_kz == other.delta_kz
            and self.multiband_factor == other.multiband_factor
            and self.calibration == other.calibration
            and self.calibration_encoding == other.calibration_encoding
        )

    def __str__(self) -> str:
        return f"MultibandType(spacing={self.spacing}, deltaKz={self.delta_kz}, multibandFactor={self.multiband_factor}, calibration={self.calibration}, calibrationEncoding={self.calibration_encoding})"

    def __repr__(self) -> str:
        return f"MultibandType(spacing={repr(self.spacing)}, deltaKz={repr(self.delta_kz)}, multibandFactor={repr(self.multiband_factor)}, calibration={repr(self.calibration)}, calibrationEncoding={repr(self.calibration_encoding)})"


class ParallelImagingType:
    acceleration_factor: AccelerationFactorType
    calibration_mode: typing.Optional[CalibrationMode]
    interleaving_dimension: typing.Optional[InterleavingDimension]
    multiband: typing.Optional[MultibandType]

    def __init__(self, *,
        acceleration_factor: typing.Optional[AccelerationFactorType] = None,
        calibration_mode: typing.Optional[CalibrationMode] = None,
        interleaving_dimension: typing.Optional[InterleavingDimension] = None,
        multiband: typing.Optional[MultibandType] = None,
    ):
        self.acceleration_factor = acceleration_factor if acceleration_factor is not None else AccelerationFactorType()
        self.calibration_mode = calibration_mode
        self.interleaving_dimension = interleaving_dimension
        self.multiband = multiband

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, ParallelImagingType)
            and self.acceleration_factor == other.acceleration_factor
            and self.calibration_mode == other.calibration_mode
            and self.interleaving_dimension == other.interleaving_dimension
            and self.multiband == other.multiband
        )

    def __str__(self) -> str:
        return f"ParallelImagingType(accelerationFactor={self.acceleration_factor}, calibrationMode={self.calibration_mode}, interleavingDimension={self.interleaving_dimension}, multiband={self.multiband})"

    def __repr__(self) -> str:
        return f"ParallelImagingType(accelerationFactor={repr(self.acceleration_factor)}, calibrationMode={repr(self.calibration_mode)}, interleavingDimension={repr(self.interleaving_dimension)}, multiband={repr(self.multiband)})"


class EncodingType:
    encoded_space: EncodingSpaceType
    recon_space: EncodingSpaceType
    encoding_limits: EncodingLimitsType
    trajectory: Trajectory
    trajectory_description: typing.Optional[TrajectoryDescriptionType]
    parallel_imaging: typing.Optional[ParallelImagingType]
    echo_train_length: typing.Optional[yardl.Int64]

    def __init__(self, *,
        encoded_space: typing.Optional[EncodingSpaceType] = None,
        recon_space: typing.Optional[EncodingSpaceType] = None,
        encoding_limits: typing.Optional[EncodingLimitsType] = None,
        trajectory: Trajectory = Trajectory.CARTESIAN,
        trajectory_description: typing.Optional[TrajectoryDescriptionType] = None,
        parallel_imaging: typing.Optional[ParallelImagingType] = None,
        echo_train_length: typing.Optional[yardl.Int64] = None,
    ):
        self.encoded_space = encoded_space if encoded_space is not None else EncodingSpaceType()
        self.recon_space = recon_space if recon_space is not None else EncodingSpaceType()
        self.encoding_limits = encoding_limits if encoding_limits is not None else EncodingLimitsType()
        self.trajectory = trajectory
        self.trajectory_description = trajectory_description
        self.parallel_imaging = parallel_imaging
        self.echo_train_length = echo_train_length

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, EncodingType)
            and self.encoded_space == other.encoded_space
            and self.recon_space == other.recon_space
            and self.encoding_limits == other.encoding_limits
            and self.trajectory == other.trajectory
            and self.trajectory_description == other.trajectory_description
            and self.parallel_imaging == other.parallel_imaging
            and self.echo_train_length == other.echo_train_length
        )

    def __str__(self) -> str:
        return f"EncodingType(encodedSpace={self.encoded_space}, reconSpace={self.recon_space}, encodingLimits={self.encoding_limits}, trajectory={self.trajectory}, trajectoryDescription={self.trajectory_description}, parallelImaging={self.parallel_imaging}, echoTrainLength={self.echo_train_length})"

    def __repr__(self) -> str:
        return f"EncodingType(encodedSpace={repr(self.encoded_space)}, reconSpace={repr(self.recon_space)}, encodingLimits={repr(self.encoding_limits)}, trajectory={repr(self.trajectory)}, trajectoryDescription={repr(self.trajectory_description)}, parallelImaging={repr(self.parallel_imaging)}, echoTrainLength={repr(self.echo_train_length)})"


class DiffusionDimension(yardl.OutOfRangeEnum):
    AVERAGE = 0
    CONTRAST = 1
    PHASE = 2
    REPETITION = 3
    SET = 4
    SEGMENT = 5
    USER_0 = 6
    USER_1 = 7
    USER_2 = 8
    USER_3 = 9
    USER_4 = 10
    USER_5 = 11
    USER_6 = 12
    USER_7 = 13

class GradientDirectionType:
    rl: yardl.Float32
    ap: yardl.Float32
    fh: yardl.Float32

    def __init__(self, *,
        rl: yardl.Float32 = 0.0,
        ap: yardl.Float32 = 0.0,
        fh: yardl.Float32 = 0.0,
    ):
        self.rl = rl
        self.ap = ap
        self.fh = fh

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, GradientDirectionType)
            and self.rl == other.rl
            and self.ap == other.ap
            and self.fh == other.fh
        )

    def __str__(self) -> str:
        return f"GradientDirectionType(rl={self.rl}, ap={self.ap}, fh={self.fh})"

    def __repr__(self) -> str:
        return f"GradientDirectionType(rl={repr(self.rl)}, ap={repr(self.ap)}, fh={repr(self.fh)})"


class DiffusionType:
    gradient_direction: GradientDirectionType
    bvalue: yardl.Float32

    def __init__(self, *,
        gradient_direction: typing.Optional[GradientDirectionType] = None,
        bvalue: yardl.Float32 = 0.0,
    ):
        self.gradient_direction = gradient_direction if gradient_direction is not None else GradientDirectionType()
        self.bvalue = bvalue

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, DiffusionType)
            and self.gradient_direction == other.gradient_direction
            and self.bvalue == other.bvalue
        )

    def __str__(self) -> str:
        return f"DiffusionType(gradientDirection={self.gradient_direction}, bvalue={self.bvalue})"

    def __repr__(self) -> str:
        return f"DiffusionType(gradientDirection={repr(self.gradient_direction)}, bvalue={repr(self.bvalue)})"


class SequenceParametersType:
    t_r: list[yardl.Float32]
    t_e: list[yardl.Float32]
    t_i: list[yardl.Float32]
    flip_angle_deg: list[yardl.Float32]
    sequence_type: typing.Optional[str]
    echo_spacing: list[yardl.Float32]
    diffusion_dimension: typing.Optional[DiffusionDimension]
    diffusion: list[DiffusionType]
    diffusion_scheme: typing.Optional[str]

    def __init__(self, *,
        t_r: typing.Optional[list[yardl.Float32]] = None,
        t_e: typing.Optional[list[yardl.Float32]] = None,
        t_i: typing.Optional[list[yardl.Float32]] = None,
        flip_angle_deg: typing.Optional[list[yardl.Float32]] = None,
        sequence_type: typing.Optional[str] = None,
        echo_spacing: typing.Optional[list[yardl.Float32]] = None,
        diffusion_dimension: typing.Optional[DiffusionDimension] = None,
        diffusion: typing.Optional[list[DiffusionType]] = None,
        diffusion_scheme: typing.Optional[str] = None,
    ):
        self.t_r = t_r if t_r is not None else []
        self.t_e = t_e if t_e is not None else []
        self.t_i = t_i if t_i is not None else []
        self.flip_angle_deg = flip_angle_deg if flip_angle_deg is not None else []
        self.sequence_type = sequence_type
        self.echo_spacing = echo_spacing if echo_spacing is not None else []
        self.diffusion_dimension = diffusion_dimension
        self.diffusion = diffusion if diffusion is not None else []
        self.diffusion_scheme = diffusion_scheme

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, SequenceParametersType)
            and self.t_r == other.t_r
            and self.t_e == other.t_e
            and self.t_i == other.t_i
            and self.flip_angle_deg == other.flip_angle_deg
            and self.sequence_type == other.sequence_type
            and self.echo_spacing == other.echo_spacing
            and self.diffusion_dimension == other.diffusion_dimension
            and self.diffusion == other.diffusion
            and self.diffusion_scheme == other.diffusion_scheme
        )

    def __str__(self) -> str:
        return f"SequenceParametersType(tR={self.t_r}, tE={self.t_e}, tI={self.t_i}, flipAngleDeg={self.flip_angle_deg}, sequenceType={self.sequence_type}, echoSpacing={self.echo_spacing}, diffusionDimension={self.diffusion_dimension}, diffusion={self.diffusion}, diffusionScheme={self.diffusion_scheme})"

    def __repr__(self) -> str:
        return f"SequenceParametersType(tR={repr(self.t_r)}, tE={repr(self.t_e)}, tI={repr(self.t_i)}, flipAngleDeg={repr(self.flip_angle_deg)}, sequenceType={repr(self.sequence_type)}, echoSpacing={repr(self.echo_spacing)}, diffusionDimension={repr(self.diffusion_dimension)}, diffusion={repr(self.diffusion)}, diffusionScheme={repr(self.diffusion_scheme)})"


class UserParameterBase64Type:
    name: str
    value: str

    def __init__(self, *,
        name: str = "",
        value: str = "",
    ):
        self.name = name
        self.value = value

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, UserParameterBase64Type)
            and self.name == other.name
            and self.value == other.value
        )

    def __str__(self) -> str:
        return f"UserParameterBase64Type(name={self.name}, value={self.value})"

    def __repr__(self) -> str:
        return f"UserParameterBase64Type(name={repr(self.name)}, value={repr(self.value)})"


class UserParametersType:
    user_parameter_long: list[UserParameterLongType]
    user_parameter_double: list[UserParameterDoubleType]
    user_parameter_string: list[UserParameterStringType]
    user_parameter_base64: list[UserParameterBase64Type]

    def __init__(self, *,
        user_parameter_long: typing.Optional[list[UserParameterLongType]] = None,
        user_parameter_double: typing.Optional[list[UserParameterDoubleType]] = None,
        user_parameter_string: typing.Optional[list[UserParameterStringType]] = None,
        user_parameter_base64: typing.Optional[list[UserParameterBase64Type]] = None,
    ):
        self.user_parameter_long = user_parameter_long if user_parameter_long is not None else []
        self.user_parameter_double = user_parameter_double if user_parameter_double is not None else []
        self.user_parameter_string = user_parameter_string if user_parameter_string is not None else []
        self.user_parameter_base64 = user_parameter_base64 if user_parameter_base64 is not None else []

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, UserParametersType)
            and self.user_parameter_long == other.user_parameter_long
            and self.user_parameter_double == other.user_parameter_double
            and self.user_parameter_string == other.user_parameter_string
            and self.user_parameter_base64 == other.user_parameter_base64
        )

    def __str__(self) -> str:
        return f"UserParametersType(userParameterLong={self.user_parameter_long}, userParameterDouble={self.user_parameter_double}, userParameterString={self.user_parameter_string}, userParameterBase64={self.user_parameter_base64})"

    def __repr__(self) -> str:
        return f"UserParametersType(userParameterLong={repr(self.user_parameter_long)}, userParameterDouble={repr(self.user_parameter_double)}, userParameterString={repr(self.user_parameter_string)}, userParameterBase64={repr(self.user_parameter_base64)})"


class WaveformType(yardl.OutOfRangeEnum):
    ECG = 0
    PULSE = 1
    RESPIRATORY = 2
    TRIGGER = 3
    GRADIENTWAVEFORM = 4
    OTHER = 5

class WaveformInformationType:
    waveform_name: str
    waveform_type: WaveformType
    user_parameters: UserParametersType

    def __init__(self, *,
        waveform_name: str = "",
        waveform_type: WaveformType = WaveformType.ECG,
        user_parameters: typing.Optional[UserParametersType] = None,
    ):
        self.waveform_name = waveform_name
        self.waveform_type = waveform_type
        self.user_parameters = user_parameters if user_parameters is not None else UserParametersType()

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, WaveformInformationType)
            and self.waveform_name == other.waveform_name
            and self.waveform_type == other.waveform_type
            and self.user_parameters == other.user_parameters
        )

    def __str__(self) -> str:
        return f"WaveformInformationType(waveformName={self.waveform_name}, waveformType={self.waveform_type}, userParameters={self.user_parameters})"

    def __repr__(self) -> str:
        return f"WaveformInformationType(waveformName={repr(self.waveform_name)}, waveformType={repr(self.waveform_type)}, userParameters={repr(self.user_parameters)})"


class Header:
    version: typing.Optional[yardl.Int64]
    subject_information: typing.Optional[SubjectInformationType]
    study_information: typing.Optional[StudyInformationType]
    measurement_information: typing.Optional[MeasurementInformationType]
    acquisition_system_information: typing.Optional[AcquisitionSystemInformationType]
    experimental_conditions: ExperimentalConditionsType
    encoding: list[EncodingType]
    sequence_parameters: typing.Optional[SequenceParametersType]
    user_parameters: typing.Optional[UserParametersType]
    waveform_information: list[WaveformInformationType]

    def __init__(self, *,
        version: typing.Optional[yardl.Int64] = None,
        subject_information: typing.Optional[SubjectInformationType] = None,
        study_information: typing.Optional[StudyInformationType] = None,
        measurement_information: typing.Optional[MeasurementInformationType] = None,
        acquisition_system_information: typing.Optional[AcquisitionSystemInformationType] = None,
        experimental_conditions: typing.Optional[ExperimentalConditionsType] = None,
        encoding: typing.Optional[list[EncodingType]] = None,
        sequence_parameters: typing.Optional[SequenceParametersType] = None,
        user_parameters: typing.Optional[UserParametersType] = None,
        waveform_information: typing.Optional[list[WaveformInformationType]] = None,
    ):
        self.version = version
        self.subject_information = subject_information
        self.study_information = study_information
        self.measurement_information = measurement_information
        self.acquisition_system_information = acquisition_system_information
        self.experimental_conditions = experimental_conditions if experimental_conditions is not None else ExperimentalConditionsType()
        self.encoding = encoding if encoding is not None else []
        self.sequence_parameters = sequence_parameters
        self.user_parameters = user_parameters
        self.waveform_information = waveform_information if waveform_information is not None else []

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, Header)
            and self.version == other.version
            and self.subject_information == other.subject_information
            and self.study_information == other.study_information
            and self.measurement_information == other.measurement_information
            and self.acquisition_system_information == other.acquisition_system_information
            and self.experimental_conditions == other.experimental_conditions
            and self.encoding == other.encoding
            and self.sequence_parameters == other.sequence_parameters
            and self.user_parameters == other.user_parameters
            and self.waveform_information == other.waveform_information
        )

    def __str__(self) -> str:
        return f"Header(version={self.version}, subjectInformation={self.subject_information}, studyInformation={self.study_information}, measurementInformation={self.measurement_information}, acquisitionSystemInformation={self.acquisition_system_information}, experimentalConditions={self.experimental_conditions}, encoding={self.encoding}, sequenceParameters={self.sequence_parameters}, userParameters={self.user_parameters}, waveformInformation={self.waveform_information})"

    def __repr__(self) -> str:
        return f"Header(version={repr(self.version)}, subjectInformation={repr(self.subject_information)}, studyInformation={repr(self.study_information)}, measurementInformation={repr(self.measurement_information)}, acquisitionSystemInformation={repr(self.acquisition_system_information)}, experimentalConditions={repr(self.experimental_conditions)}, encoding={repr(self.encoding)}, sequenceParameters={repr(self.sequence_parameters)}, userParameters={repr(self.user_parameters)}, waveformInformation={repr(self.waveform_information)})"


class ImageFlags(enum.IntFlag):
    IS_NAVIGATION_DATA = 1
    FIRST_IN_AVERAGE = 16
    LAST_IN_AVERAGE = 32
    FIRST_IN_SLICE = 64
    LAST_IN_SLICE = 128
    FIRST_IN_CONTRAST = 256
    LAST_IN_CONTRAST = 512
    FIRST_IN_PHASE = 1024
    LAST_IN_PHASE = 2048
    FIRST_IN_REPETITION = 4096
    LAST_IN_REPETITION = 8192
    FIRST_IN_SET = 16384
    LAST_IN_SET = 32768

    def __eq__(self, other: object) -> bool:
        return isinstance(other, ImageFlags) and self.value == other.value

    def __hash__(self) -> int:
        return hash(self.value)

    __str__ = enum.Flag.__str__ # type: ignore

class ImageType(yardl.OutOfRangeEnum):
    MAGNITUDE = 1
    PHASE = 2
    REAL = 3
    IMAG = 4
    COMPLEX = 5

ImageData = npt.NDArray[Y_NP]

class ImageMetaData:
    name: str
    value: str

    def __init__(self, *,
        name: str = "",
        value: str = "",
    ):
        self.name = name
        self.value = value

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, ImageMetaData)
            and self.name == other.name
            and self.value == other.value
        )

    def __str__(self) -> str:
        return f"ImageMetaData(name={self.name}, value={self.value})"

    def __repr__(self) -> str:
        return f"ImageMetaData(name={repr(self.name)}, value={repr(self.value)})"


class Image(typing.Generic[T_NP]):
    flags: ImageFlags
    measurement_uid: yardl.UInt32
    field_of_view: npt.NDArray[np.float32]
    position: npt.NDArray[np.float32]
    col_dir: npt.NDArray[np.float32]
    line_dir: npt.NDArray[np.float32]
    slice_dir: npt.NDArray[np.float32]
    patient_table_position: npt.NDArray[np.float32]
    average: typing.Optional[yardl.UInt32]
    slice: typing.Optional[yardl.UInt32]
    contrast: typing.Optional[yardl.UInt32]
    phase: typing.Optional[yardl.UInt32]
    repetition: typing.Optional[yardl.UInt32]
    set: typing.Optional[yardl.UInt32]
    acquisition_time_stamp: typing.Optional[yardl.UInt32]
    physiology_time_stamp: list[yardl.UInt32]
    image_type: ImageType
    image_index: typing.Optional[yardl.UInt32]
    image_series_index: typing.Optional[yardl.UInt32]
    user_int: list[yardl.Int32]
    user_float: list[yardl.Float32]
    data: ImageData[T_NP]
    meta: dict[str, list[str]]

    def __init__(self, *,
        flags: ImageFlags = ImageFlags(0),
        measurement_uid: yardl.UInt32 = 0,
        field_of_view: typing.Optional[npt.NDArray[np.float32]] = None,
        position: typing.Optional[npt.NDArray[np.float32]] = None,
        col_dir: typing.Optional[npt.NDArray[np.float32]] = None,
        line_dir: typing.Optional[npt.NDArray[np.float32]] = None,
        slice_dir: typing.Optional[npt.NDArray[np.float32]] = None,
        patient_table_position: typing.Optional[npt.NDArray[np.float32]] = None,
        average: typing.Optional[yardl.UInt32] = None,
        slice: typing.Optional[yardl.UInt32] = None,
        contrast: typing.Optional[yardl.UInt32] = None,
        phase: typing.Optional[yardl.UInt32] = None,
        repetition: typing.Optional[yardl.UInt32] = None,
        set: typing.Optional[yardl.UInt32] = None,
        acquisition_time_stamp: typing.Optional[yardl.UInt32] = None,
        physiology_time_stamp: typing.Optional[list[yardl.UInt32]] = None,
        image_type: ImageType,
        image_index: typing.Optional[yardl.UInt32] = None,
        image_series_index: typing.Optional[yardl.UInt32] = None,
        user_int: typing.Optional[list[yardl.Int32]] = None,
        user_float: typing.Optional[list[yardl.Float32]] = None,
        data: ImageData[T_NP],
        meta: typing.Optional[dict[str, list[str]]] = None,
    ):
        self.flags = flags
        self.measurement_uid = measurement_uid
        self.field_of_view = field_of_view if field_of_view is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.position = position if position is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.col_dir = col_dir if col_dir is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.line_dir = line_dir if line_dir is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.slice_dir = slice_dir if slice_dir is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.patient_table_position = patient_table_position if patient_table_position is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.average = average
        self.slice = slice
        self.contrast = contrast
        self.phase = phase
        self.repetition = repetition
        self.set = set
        self.acquisition_time_stamp = acquisition_time_stamp
        self.physiology_time_stamp = physiology_time_stamp if physiology_time_stamp is not None else []
        self.image_type = image_type
        self.image_index = image_index
        self.image_series_index = image_series_index
        self.user_int = user_int if user_int is not None else []
        self.user_float = user_float if user_float is not None else []
        self.data = data
        self.meta = meta if meta is not None else {}

    def channels(self) -> yardl.Size:
        return self.data.shape[0]

    def slices(self) -> yardl.Size:
        return self.data.shape[1]

    def rows(self) -> yardl.Size:
        return self.data.shape[2]

    def cols(self) -> yardl.Size:
        return self.data.shape[3]

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, Image)
            and self.flags == other.flags
            and self.measurement_uid == other.measurement_uid
            and yardl.structural_equal(self.field_of_view, other.field_of_view)
            and yardl.structural_equal(self.position, other.position)
            and yardl.structural_equal(self.col_dir, other.col_dir)
            and yardl.structural_equal(self.line_dir, other.line_dir)
            and yardl.structural_equal(self.slice_dir, other.slice_dir)
            and yardl.structural_equal(self.patient_table_position, other.patient_table_position)
            and self.average == other.average
            and self.slice == other.slice
            and self.contrast == other.contrast
            and self.phase == other.phase
            and self.repetition == other.repetition
            and self.set == other.set
            and self.acquisition_time_stamp == other.acquisition_time_stamp
            and self.physiology_time_stamp == other.physiology_time_stamp
            and self.image_type == other.image_type
            and self.image_index == other.image_index
            and self.image_series_index == other.image_series_index
            and self.user_int == other.user_int
            and self.user_float == other.user_float
            and yardl.structural_equal(self.data, other.data)
            and self.meta == other.meta
        )

    def __str__(self) -> str:
        return f"Image(flags={self.flags}, measurementUid={self.measurement_uid}, fieldOfView={self.field_of_view}, position={self.position}, colDir={self.col_dir}, lineDir={self.line_dir}, sliceDir={self.slice_dir}, patientTablePosition={self.patient_table_position}, average={self.average}, slice={self.slice}, contrast={self.contrast}, phase={self.phase}, repetition={self.repetition}, set={self.set}, acquisitionTimeStamp={self.acquisition_time_stamp}, physiologyTimeStamp={self.physiology_time_stamp}, imageType={self.image_type}, imageIndex={self.image_index}, imageSeriesIndex={self.image_series_index}, userInt={self.user_int}, userFloat={self.user_float}, data={self.data}, meta={self.meta})"

    def __repr__(self) -> str:
        return f"Image(flags={repr(self.flags)}, measurementUid={repr(self.measurement_uid)}, fieldOfView={repr(self.field_of_view)}, position={repr(self.position)}, colDir={repr(self.col_dir)}, lineDir={repr(self.line_dir)}, sliceDir={repr(self.slice_dir)}, patientTablePosition={repr(self.patient_table_position)}, average={repr(self.average)}, slice={repr(self.slice)}, contrast={repr(self.contrast)}, phase={repr(self.phase)}, repetition={repr(self.repetition)}, set={repr(self.set)}, acquisitionTimeStamp={repr(self.acquisition_time_stamp)}, physiologyTimeStamp={repr(self.physiology_time_stamp)}, imageType={repr(self.image_type)}, imageIndex={repr(self.image_index)}, imageSeriesIndex={repr(self.image_series_index)}, userInt={repr(self.user_int)}, userFloat={repr(self.user_float)}, data={repr(self.data)}, meta={repr(self.meta)})"


WaveformSamples = npt.NDArray[T_NP]

class Waveform(typing.Generic[T_NP]):
    flags: yardl.UInt64
    measurement_uid: yardl.UInt32
    scan_counter: yardl.UInt32
    time_stamp: yardl.UInt32
    sample_time_us: yardl.Float32
    waveform_id: yardl.UInt32
    data: WaveformSamples[T_NP]

    def __init__(self, *,
        flags: yardl.UInt64 = 0,
        measurement_uid: yardl.UInt32 = 0,
        scan_counter: yardl.UInt32 = 0,
        time_stamp: yardl.UInt32 = 0,
        sample_time_us: yardl.Float32 = 0.0,
        waveform_id: yardl.UInt32 = 0,
        data: WaveformSamples[T_NP],
    ):
        self.flags = flags
        self.measurement_uid = measurement_uid
        self.scan_counter = scan_counter
        self.time_stamp = time_stamp
        self.sample_time_us = sample_time_us
        self.waveform_id = waveform_id
        self.data = data

    def channels(self) -> yardl.Size:
        return self.data.shape[0]

    def number_of_samples(self) -> yardl.Size:
        return self.data.shape[1]

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, Waveform)
            and self.flags == other.flags
            and self.measurement_uid == other.measurement_uid
            and self.scan_counter == other.scan_counter
            and self.time_stamp == other.time_stamp
            and self.sample_time_us == other.sample_time_us
            and self.waveform_id == other.waveform_id
            and yardl.structural_equal(self.data, other.data)
        )

    def __str__(self) -> str:
        return f"Waveform(flags={self.flags}, measurementUid={self.measurement_uid}, scanCounter={self.scan_counter}, timeStamp={self.time_stamp}, sampleTimeUs={self.sample_time_us}, waveformId={self.waveform_id}, data={self.data})"

    def __repr__(self) -> str:
        return f"Waveform(flags={repr(self.flags)}, measurementUid={repr(self.measurement_uid)}, scanCounter={repr(self.scan_counter)}, timeStamp={repr(self.time_stamp)}, sampleTimeUs={repr(self.sample_time_us)}, waveformId={repr(self.waveform_id)}, data={repr(self.data)})"


WaveformUint32 = Waveform[np.uint32]

ImageUint16 = Image[np.uint16]

ImageInt16 = Image[np.int16]

ImageUint = Image[np.uint32]

ImageInt = Image[np.int32]

ImageFloat = Image[np.float32]

ImageDouble = Image[np.float64]

ImageComplexFloat = Image[np.complex64]

ImageComplexDouble = Image[np.complex128]

_T = typing.TypeVar('_T')

class StreamItem:
    Acquisition: typing.ClassVar[type["StreamItemUnionCase[Acquisition]"]]
    WaveformUint32: typing.ClassVar[type["StreamItemUnionCase[WaveformUint32]"]]
    ImageUint16: typing.ClassVar[type["StreamItemUnionCase[ImageUint16]"]]
    ImageInt16: typing.ClassVar[type["StreamItemUnionCase[ImageInt16]"]]
    ImageUint: typing.ClassVar[type["StreamItemUnionCase[ImageUint]"]]
    ImageInt: typing.ClassVar[type["StreamItemUnionCase[ImageInt]"]]
    ImageFloat: typing.ClassVar[type["StreamItemUnionCase[ImageFloat]"]]
    ImageDouble: typing.ClassVar[type["StreamItemUnionCase[ImageDouble]"]]
    ImageComplexFloat: typing.ClassVar[type["StreamItemUnionCase[ImageComplexFloat]"]]
    ImageComplexDouble: typing.ClassVar[type["StreamItemUnionCase[ImageComplexDouble]"]]

class StreamItemUnionCase(StreamItem, yardl.UnionCase[_T]):
    pass

StreamItem.Acquisition = type("StreamItem.Acquisition", (StreamItemUnionCase,), {"index": 0, "tag": "Acquisition"})
StreamItem.WaveformUint32 = type("StreamItem.WaveformUint32", (StreamItemUnionCase,), {"index": 1, "tag": "WaveformUint32"})
StreamItem.ImageUint16 = type("StreamItem.ImageUint16", (StreamItemUnionCase,), {"index": 2, "tag": "ImageUint16"})
StreamItem.ImageInt16 = type("StreamItem.ImageInt16", (StreamItemUnionCase,), {"index": 3, "tag": "ImageInt16"})
StreamItem.ImageUint = type("StreamItem.ImageUint", (StreamItemUnionCase,), {"index": 4, "tag": "ImageUint"})
StreamItem.ImageInt = type("StreamItem.ImageInt", (StreamItemUnionCase,), {"index": 5, "tag": "ImageInt"})
StreamItem.ImageFloat = type("StreamItem.ImageFloat", (StreamItemUnionCase,), {"index": 6, "tag": "ImageFloat"})
StreamItem.ImageDouble = type("StreamItem.ImageDouble", (StreamItemUnionCase,), {"index": 7, "tag": "ImageDouble"})
StreamItem.ImageComplexFloat = type("StreamItem.ImageComplexFloat", (StreamItemUnionCase,), {"index": 8, "tag": "ImageComplexFloat"})
StreamItem.ImageComplexDouble = type("StreamItem.ImageComplexDouble", (StreamItemUnionCase,), {"index": 9, "tag": "ImageComplexDouble"})
del StreamItemUnionCase

def _mk_get_dtype():
    dtype_map: dict[typing.Union[type, types.GenericAlias], typing.Union[np.dtype[typing.Any], typing.Callable[[tuple[type, ...]], np.dtype[typing.Any]]]] = {}
    get_dtype = _dtypes.make_get_dtype_func(dtype_map)

    dtype_map.setdefault(AcquisitionFlags, np.dtype(np.uint64))
    dtype_map.setdefault(EncodingCounters, np.dtype([('kspace_encode_step_1', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('kspace_encode_step_2', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('average', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('slice', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('contrast', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('phase', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('repetition', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('set', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('segment', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('user', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(Acquisition, np.dtype([('flags', get_dtype(AcquisitionFlags)), ('idx', get_dtype(EncodingCounters)), ('measurement_uid', np.dtype(np.uint32)), ('scan_counter', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('acquisition_time_stamp', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('physiology_time_stamp', np.dtype(np.object_)), ('channel_order', np.dtype(np.object_)), ('discard_pre', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('discard_post', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('center_sample', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('encoding_space_ref', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('sample_time_us', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.float32))], align=True)), ('position', np.dtype(np.float32), (3,)), ('read_dir', np.dtype(np.float32), (3,)), ('phase_dir', np.dtype(np.float32), (3,)), ('slice_dir', np.dtype(np.float32), (3,)), ('patient_table_position', np.dtype(np.float32), (3,)), ('user_int', np.dtype(np.object_)), ('user_float', np.dtype(np.object_)), ('data', np.dtype(np.object_)), ('trajectory', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(PatientGender, np.dtype(np.int32))
    dtype_map.setdefault(SubjectInformationType, np.dtype([('patient_name', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('patient_weight_kg', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.float32))], align=True)), ('patient_height_m', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.float32))], align=True)), ('patient_id', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('patient_birthdate', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.datetime64))], align=True)), ('patient_gender', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(PatientGender))], align=True))], align=True))
    dtype_map.setdefault(StudyInformationType, np.dtype([('study_date', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.datetime64))], align=True)), ('study_time', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.timedelta64))], align=True)), ('study_id', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('accession_number', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.int64))], align=True)), ('referring_physician_name', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('study_description', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('study_instance_uid', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('body_part_examined', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True))], align=True))
    dtype_map.setdefault(PatientPosition, np.dtype(np.int32))
    dtype_map.setdefault(ThreeDimensionalFloat, np.dtype([('x', np.dtype(np.float32)), ('y', np.dtype(np.float32)), ('z', np.dtype(np.float32))], align=True))
    dtype_map.setdefault(MeasurementDependencyType, np.dtype([('dependency_type', np.dtype(np.object_)), ('measurement_id', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(ReferencedImageSequenceType, np.dtype([('referenced_sop_instance_uid', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(MeasurementInformationType, np.dtype([('measurement_id', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('series_date', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.datetime64))], align=True)), ('series_time', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.timedelta64))], align=True)), ('patient_position', get_dtype(PatientPosition)), ('relative_table_position', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(ThreeDimensionalFloat))], align=True)), ('initial_series_number', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.int64))], align=True)), ('protocol_name', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('sequence_name', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('series_description', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('measurement_dependency', np.dtype(np.object_)), ('series_instance_uid_root', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('frame_of_reference_uid', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('referenced_image_sequence', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(ReferencedImageSequenceType))], align=True))], align=True))
    dtype_map.setdefault(CoilLabelType, np.dtype([('coil_number', np.dtype(np.uint32)), ('coil_name', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(AcquisitionSystemInformationType, np.dtype([('system_vendor', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('system_model', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('system_field_strength_t', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.float32))], align=True)), ('relative_receiver_noise_bandwidth', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.float32))], align=True)), ('receiver_channels', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('coil_label', np.dtype(np.object_)), ('institution_name', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('station_name', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('device_id', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('device_serial_number', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True))], align=True))
    dtype_map.setdefault(ExperimentalConditionsType, np.dtype([('h1resonance_frequency_hz', np.dtype(np.int64))], align=True))
    dtype_map.setdefault(MatrixSizeType, np.dtype([('x', np.dtype(np.uint32)), ('y', np.dtype(np.uint32)), ('z', np.dtype(np.uint32))], align=True))
    dtype_map.setdefault(FieldOfViewMm, np.dtype([('x', np.dtype(np.float32)), ('y', np.dtype(np.float32)), ('z', np.dtype(np.float32))], align=True))
    dtype_map.setdefault(EncodingSpaceType, np.dtype([('matrix_size', get_dtype(MatrixSizeType)), ('field_of_view_mm', get_dtype(FieldOfViewMm))], align=True))
    dtype_map.setdefault(LimitType, np.dtype([('minimum', np.dtype(np.uint32)), ('maximum', np.dtype(np.uint32)), ('center', np.dtype(np.uint32))], align=True))
    dtype_map.setdefault(EncodingLimitsType, np.dtype([('kspace_encoding_step_0', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('kspace_encoding_step_1', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('kspace_encoding_step_2', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('average', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('slice', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('contrast', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('phase', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('repetition', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('set', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('segment', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('user_0', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('user_1', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('user_2', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('user_3', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('user_4', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('user_5', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('user_6', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('user_7', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True))], align=True))
    dtype_map.setdefault(Trajectory, np.dtype(np.int32))
    dtype_map.setdefault(UserParameterLongType, np.dtype([('name', np.dtype(np.object_)), ('value', np.dtype(np.int64))], align=True))
    dtype_map.setdefault(UserParameterDoubleType, np.dtype([('name', np.dtype(np.object_)), ('value', np.dtype(np.float64))], align=True))
    dtype_map.setdefault(UserParameterStringType, np.dtype([('name', np.dtype(np.object_)), ('value', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(TrajectoryDescriptionType, np.dtype([('identifier', np.dtype(np.object_)), ('user_parameter_long', np.dtype(np.object_)), ('user_parameter_double', np.dtype(np.object_)), ('user_parameter_string', np.dtype(np.object_)), ('comment', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True))], align=True))
    dtype_map.setdefault(AccelerationFactorType, np.dtype([('kspace_encoding_step_1', np.dtype(np.uint32)), ('kspace_encoding_step_2', np.dtype(np.uint32))], align=True))
    dtype_map.setdefault(CalibrationMode, np.dtype(np.int32))
    dtype_map.setdefault(InterleavingDimension, np.dtype(np.int32))
    dtype_map.setdefault(MultibandSpacingType, np.dtype([('d_z', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(Calibration, np.dtype(np.int32))
    dtype_map.setdefault(MultibandType, np.dtype([('spacing', np.dtype(np.object_)), ('delta_kz', np.dtype(np.float32)), ('multiband_factor', np.dtype(np.uint32)), ('calibration', get_dtype(Calibration)), ('calibration_encoding', np.dtype(np.uint64))], align=True))
    dtype_map.setdefault(ParallelImagingType, np.dtype([('acceleration_factor', get_dtype(AccelerationFactorType)), ('calibration_mode', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(CalibrationMode))], align=True)), ('interleaving_dimension', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(InterleavingDimension))], align=True)), ('multiband', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(MultibandType))], align=True))], align=True))
    dtype_map.setdefault(EncodingType, np.dtype([('encoded_space', get_dtype(EncodingSpaceType)), ('recon_space', get_dtype(EncodingSpaceType)), ('encoding_limits', get_dtype(EncodingLimitsType)), ('trajectory', get_dtype(Trajectory)), ('trajectory_description', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(TrajectoryDescriptionType))], align=True)), ('parallel_imaging', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(ParallelImagingType))], align=True)), ('echo_train_length', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.int64))], align=True))], align=True))
    dtype_map.setdefault(DiffusionDimension, np.dtype(np.int32))
    dtype_map.setdefault(GradientDirectionType, np.dtype([('rl', np.dtype(np.float32)), ('ap', np.dtype(np.float32)), ('fh', np.dtype(np.float32))], align=True))
    dtype_map.setdefault(DiffusionType, np.dtype([('gradient_direction', get_dtype(GradientDirectionType)), ('bvalue', np.dtype(np.float32))], align=True))
    dtype_map.setdefault(SequenceParametersType, np.dtype([('t_r', np.dtype(np.object_)), ('t_e', np.dtype(np.object_)), ('t_i', np.dtype(np.object_)), ('flip_angle_deg', np.dtype(np.object_)), ('sequence_type', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('echo_spacing', np.dtype(np.object_)), ('diffusion_dimension', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(DiffusionDimension))], align=True)), ('diffusion', np.dtype(np.object_)), ('diffusion_scheme', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True))], align=True))
    dtype_map.setdefault(UserParameterBase64Type, np.dtype([('name', np.dtype(np.object_)), ('value', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(UserParametersType, np.dtype([('user_parameter_long', np.dtype(np.object_)), ('user_parameter_double', np.dtype(np.object_)), ('user_parameter_string', np.dtype(np.object_)), ('user_parameter_base64', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(WaveformType, np.dtype(np.int32))
    dtype_map.setdefault(WaveformInformationType, np.dtype([('waveform_name', np.dtype(np.object_)), ('waveform_type', get_dtype(WaveformType)), ('user_parameters', get_dtype(UserParametersType))], align=True))
    dtype_map.setdefault(Header, np.dtype([('version', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.int64))], align=True)), ('subject_information', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(SubjectInformationType))], align=True)), ('study_information', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(StudyInformationType))], align=True)), ('measurement_information', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(MeasurementInformationType))], align=True)), ('acquisition_system_information', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(AcquisitionSystemInformationType))], align=True)), ('experimental_conditions', get_dtype(ExperimentalConditionsType)), ('encoding', np.dtype(np.object_)), ('sequence_parameters', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(SequenceParametersType))], align=True)), ('user_parameters', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(UserParametersType))], align=True)), ('waveform_information', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(ImageFlags, np.dtype(np.uint64))
    dtype_map.setdefault(ImageType, np.dtype(np.int32))
    dtype_map.setdefault(ImageMetaData, np.dtype([('name', np.dtype(np.object_)), ('value', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(Image, lambda type_args: np.dtype([('flags', get_dtype(ImageFlags)), ('measurement_uid', np.dtype(np.uint32)), ('field_of_view', np.dtype(np.float32), (3,)), ('position', np.dtype(np.float32), (3,)), ('col_dir', np.dtype(np.float32), (3,)), ('line_dir', np.dtype(np.float32), (3,)), ('slice_dir', np.dtype(np.float32), (3,)), ('patient_table_position', np.dtype(np.float32), (3,)), ('average', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('slice', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('contrast', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('phase', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('repetition', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('set', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('acquisition_time_stamp', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('physiology_time_stamp', np.dtype(np.object_)), ('image_type', get_dtype(ImageType)), ('image_index', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('image_series_index', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('user_int', np.dtype(np.object_)), ('user_float', np.dtype(np.object_)), ('data', np.dtype(np.object_)), ('meta', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(Waveform, lambda type_args: np.dtype([('flags', np.dtype(np.uint64)), ('measurement_uid', np.dtype(np.uint32)), ('scan_counter', np.dtype(np.uint32)), ('time_stamp', np.dtype(np.uint32)), ('sample_time_us', np.dtype(np.float32)), ('waveform_id', np.dtype(np.uint32)), ('data', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(WaveformUint32, get_dtype(types.GenericAlias(Waveform, (yardl.UInt32,))))
    dtype_map.setdefault(ImageUint16, get_dtype(types.GenericAlias(Image, (yardl.UInt16,))))
    dtype_map.setdefault(ImageInt16, get_dtype(types.GenericAlias(Image, (yardl.Int16,))))
    dtype_map.setdefault(ImageUint, get_dtype(types.GenericAlias(Image, (yardl.UInt32,))))
    dtype_map.setdefault(ImageInt, get_dtype(types.GenericAlias(Image, (yardl.Int32,))))
    dtype_map.setdefault(ImageFloat, get_dtype(types.GenericAlias(Image, (yardl.Float32,))))
    dtype_map.setdefault(ImageDouble, get_dtype(types.GenericAlias(Image, (yardl.Float64,))))
    dtype_map.setdefault(ImageComplexFloat, get_dtype(types.GenericAlias(Image, (yardl.ComplexFloat,))))
    dtype_map.setdefault(ImageComplexDouble, get_dtype(types.GenericAlias(Image, (yardl.ComplexDouble,))))
    dtype_map.setdefault(StreamItem, np.dtype(np.object_))

    return get_dtype

get_dtype = _mk_get_dtype()

