# This file was generated by the "yardl" tool. DO NOT EDIT.

# pyright: reportUnusedClass=false
# pyright: reportUnusedImport=false
# pyright: reportUnknownArgumentType=false
# pyright: reportUnknownMemberType=false
# pyright: reportUnknownVariableType=false

import collections.abc
import io
import typing

import numpy as np
import numpy.typing as npt

from .types import *

from .protocols import *
from . import _binary
from . import yardl_types as yardl

class BinaryMrdWriter(_binary.BinaryProtocolWriter, MrdWriterBase):
    """Binary writer for the Mrd protocol.

    The MRD Protocol
    """


    def __init__(self, stream: typing.Union[typing.BinaryIO, str]) -> None:
        MrdWriterBase.__init__(self)
        _binary.BinaryProtocolWriter.__init__(self, stream, MrdWriterBase.schema)

    def _write_header(self, value: typing.Optional[Header]) -> None:
        _binary.OptionalSerializer(HeaderSerializer()).write(self._stream, value)

    def _write_data(self, value: collections.abc.Iterable[StreamItem]) -> None:
        _binary.StreamSerializer(_binary.UnionSerializer(StreamItem, [(StreamItem.Acquisition, AcquisitionSerializer()), (StreamItem.WaveformUint32, WaveformSerializer(_binary.uint32_serializer)), (StreamItem.ImageUint16, ImageSerializer(_binary.uint16_serializer)), (StreamItem.ImageInt16, ImageSerializer(_binary.int16_serializer)), (StreamItem.ImageUint32, ImageSerializer(_binary.uint32_serializer)), (StreamItem.ImageInt32, ImageSerializer(_binary.int32_serializer)), (StreamItem.ImageFloat, ImageSerializer(_binary.float32_serializer)), (StreamItem.ImageDouble, ImageSerializer(_binary.float64_serializer)), (StreamItem.ImageComplexFloat, ImageSerializer(_binary.complexfloat32_serializer)), (StreamItem.ImageComplexDouble, ImageSerializer(_binary.complexfloat64_serializer)), (StreamItem.AcquisitionBucket, AcquisitionBucketSerializer()), (StreamItem.ReconData, ReconDataSerializer()), (StreamItem.ArrayComplexFloat, _binary.DynamicNDArraySerializer(_binary.complexfloat32_serializer)), (StreamItem.ImageArray, ImageArraySerializer())])).write(self._stream, value)


class BinaryMrdReader(_binary.BinaryProtocolReader, MrdReaderBase):
    """Binary writer for the Mrd protocol.

    The MRD Protocol
    """


    def __init__(self, stream: typing.Union[io.BufferedReader, io.BytesIO, typing.BinaryIO, str], skip_completed_check: bool = False) -> None:
        MrdReaderBase.__init__(self, skip_completed_check)
        _binary.BinaryProtocolReader.__init__(self, stream, MrdReaderBase.schema)

    def _read_header(self) -> typing.Optional[Header]:
        return _binary.OptionalSerializer(HeaderSerializer()).read(self._stream)

    def _read_data(self) -> collections.abc.Iterable[StreamItem]:
        return _binary.StreamSerializer(_binary.UnionSerializer(StreamItem, [(StreamItem.Acquisition, AcquisitionSerializer()), (StreamItem.WaveformUint32, WaveformSerializer(_binary.uint32_serializer)), (StreamItem.ImageUint16, ImageSerializer(_binary.uint16_serializer)), (StreamItem.ImageInt16, ImageSerializer(_binary.int16_serializer)), (StreamItem.ImageUint32, ImageSerializer(_binary.uint32_serializer)), (StreamItem.ImageInt32, ImageSerializer(_binary.int32_serializer)), (StreamItem.ImageFloat, ImageSerializer(_binary.float32_serializer)), (StreamItem.ImageDouble, ImageSerializer(_binary.float64_serializer)), (StreamItem.ImageComplexFloat, ImageSerializer(_binary.complexfloat32_serializer)), (StreamItem.ImageComplexDouble, ImageSerializer(_binary.complexfloat64_serializer)), (StreamItem.AcquisitionBucket, AcquisitionBucketSerializer()), (StreamItem.ReconData, ReconDataSerializer()), (StreamItem.ArrayComplexFloat, _binary.DynamicNDArraySerializer(_binary.complexfloat32_serializer)), (StreamItem.ImageArray, ImageArraySerializer())])).read(self._stream)

class BinaryMrdNoiseCovarianceWriter(_binary.BinaryProtocolWriter, MrdNoiseCovarianceWriterBase):
    """Binary writer for the MrdNoiseCovariance protocol.

    Protocol for serializing a noise covariance matrix
    """


    def __init__(self, stream: typing.Union[typing.BinaryIO, str]) -> None:
        MrdNoiseCovarianceWriterBase.__init__(self)
        _binary.BinaryProtocolWriter.__init__(self, stream, MrdNoiseCovarianceWriterBase.schema)

    def _write_noise_covariance(self, value: NoiseCovariance) -> None:
        NoiseCovarianceSerializer().write(self._stream, value)


class BinaryMrdNoiseCovarianceReader(_binary.BinaryProtocolReader, MrdNoiseCovarianceReaderBase):
    """Binary writer for the MrdNoiseCovariance protocol.

    Protocol for serializing a noise covariance matrix
    """


    def __init__(self, stream: typing.Union[io.BufferedReader, io.BytesIO, typing.BinaryIO, str], skip_completed_check: bool = False) -> None:
        MrdNoiseCovarianceReaderBase.__init__(self, skip_completed_check)
        _binary.BinaryProtocolReader.__init__(self, stream, MrdNoiseCovarianceReaderBase.schema)

    def _read_noise_covariance(self) -> NoiseCovariance:
        return NoiseCovarianceSerializer().read(self._stream)

class EncodingCountersSerializer(_binary.RecordSerializer[EncodingCounters]):
    def __init__(self) -> None:
        super().__init__([("kspace_encode_step_1", _binary.OptionalSerializer(_binary.uint32_serializer)), ("kspace_encode_step_2", _binary.OptionalSerializer(_binary.uint32_serializer)), ("average", _binary.OptionalSerializer(_binary.uint32_serializer)), ("slice", _binary.OptionalSerializer(_binary.uint32_serializer)), ("contrast", _binary.OptionalSerializer(_binary.uint32_serializer)), ("phase", _binary.OptionalSerializer(_binary.uint32_serializer)), ("repetition", _binary.OptionalSerializer(_binary.uint32_serializer)), ("set", _binary.OptionalSerializer(_binary.uint32_serializer)), ("segment", _binary.OptionalSerializer(_binary.uint32_serializer)), ("user", _binary.VectorSerializer(_binary.uint32_serializer))])

    def write(self, stream: _binary.CodedOutputStream, value: EncodingCounters) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.kspace_encode_step_1, value.kspace_encode_step_2, value.average, value.slice, value.contrast, value.phase, value.repetition, value.set, value.segment, value.user)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['kspace_encode_step_1'], value['kspace_encode_step_2'], value['average'], value['slice'], value['contrast'], value['phase'], value['repetition'], value['set'], value['segment'], value['user'])

    def read(self, stream: _binary.CodedInputStream) -> EncodingCounters:
        field_values = self._read(stream)
        return EncodingCounters(kspace_encode_step_1=field_values[0], kspace_encode_step_2=field_values[1], average=field_values[2], slice=field_values[3], contrast=field_values[4], phase=field_values[5], repetition=field_values[6], set=field_values[7], segment=field_values[8], user=field_values[9])


class AcquisitionHeaderSerializer(_binary.RecordSerializer[AcquisitionHeader]):
    def __init__(self) -> None:
        super().__init__([("flags", _binary.EnumSerializer(_binary.uint64_serializer, AcquisitionFlags)), ("idx", EncodingCountersSerializer()), ("measurement_uid", _binary.uint32_serializer), ("scan_counter", _binary.OptionalSerializer(_binary.uint32_serializer)), ("acquisition_time_stamp_ns", _binary.OptionalSerializer(_binary.uint64_serializer)), ("physiology_time_stamp_ns", _binary.VectorSerializer(_binary.uint64_serializer)), ("channel_order", _binary.VectorSerializer(_binary.uint32_serializer)), ("discard_pre", _binary.OptionalSerializer(_binary.uint32_serializer)), ("discard_post", _binary.OptionalSerializer(_binary.uint32_serializer)), ("center_sample", _binary.OptionalSerializer(_binary.uint32_serializer)), ("encoding_space_ref", _binary.OptionalSerializer(_binary.uint32_serializer)), ("sample_time_ns", _binary.OptionalSerializer(_binary.uint64_serializer)), ("position", _binary.FixedNDArraySerializer(_binary.float32_serializer, (3,))), ("read_dir", _binary.FixedNDArraySerializer(_binary.float32_serializer, (3,))), ("phase_dir", _binary.FixedNDArraySerializer(_binary.float32_serializer, (3,))), ("slice_dir", _binary.FixedNDArraySerializer(_binary.float32_serializer, (3,))), ("patient_table_position", _binary.FixedNDArraySerializer(_binary.float32_serializer, (3,))), ("user_int", _binary.VectorSerializer(_binary.int32_serializer)), ("user_float", _binary.VectorSerializer(_binary.float32_serializer))])

    def write(self, stream: _binary.CodedOutputStream, value: AcquisitionHeader) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.flags, value.idx, value.measurement_uid, value.scan_counter, value.acquisition_time_stamp_ns, value.physiology_time_stamp_ns, value.channel_order, value.discard_pre, value.discard_post, value.center_sample, value.encoding_space_ref, value.sample_time_ns, value.position, value.read_dir, value.phase_dir, value.slice_dir, value.patient_table_position, value.user_int, value.user_float)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['flags'], value['idx'], value['measurement_uid'], value['scan_counter'], value['acquisition_time_stamp_ns'], value['physiology_time_stamp_ns'], value['channel_order'], value['discard_pre'], value['discard_post'], value['center_sample'], value['encoding_space_ref'], value['sample_time_ns'], value['position'], value['read_dir'], value['phase_dir'], value['slice_dir'], value['patient_table_position'], value['user_int'], value['user_float'])

    def read(self, stream: _binary.CodedInputStream) -> AcquisitionHeader:
        field_values = self._read(stream)
        return AcquisitionHeader(flags=field_values[0], idx=field_values[1], measurement_uid=field_values[2], scan_counter=field_values[3], acquisition_time_stamp_ns=field_values[4], physiology_time_stamp_ns=field_values[5], channel_order=field_values[6], discard_pre=field_values[7], discard_post=field_values[8], center_sample=field_values[9], encoding_space_ref=field_values[10], sample_time_ns=field_values[11], position=field_values[12], read_dir=field_values[13], phase_dir=field_values[14], slice_dir=field_values[15], patient_table_position=field_values[16], user_int=field_values[17], user_float=field_values[18])


class AcquisitionSerializer(_binary.RecordSerializer[Acquisition]):
    def __init__(self) -> None:
        super().__init__([("head", AcquisitionHeaderSerializer()), ("data", _binary.NDArraySerializer(_binary.complexfloat32_serializer, 2)), ("trajectory", _binary.NDArraySerializer(_binary.float32_serializer, 2))])

    def write(self, stream: _binary.CodedOutputStream, value: Acquisition) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.head, value.data, value.trajectory)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['head'], value['data'], value['trajectory'])

    def read(self, stream: _binary.CodedInputStream) -> Acquisition:
        field_values = self._read(stream)
        return Acquisition(head=field_values[0], data=field_values[1], trajectory=field_values[2])


class SubjectInformationTypeSerializer(_binary.RecordSerializer[SubjectInformationType]):
    def __init__(self) -> None:
        super().__init__([("patient_name", _binary.OptionalSerializer(_binary.string_serializer)), ("patient_weight_kg", _binary.OptionalSerializer(_binary.float32_serializer)), ("patient_height_m", _binary.OptionalSerializer(_binary.float32_serializer)), ("patient_id", _binary.OptionalSerializer(_binary.string_serializer)), ("patient_birthdate", _binary.OptionalSerializer(_binary.date_serializer)), ("patient_gender", _binary.OptionalSerializer(_binary.EnumSerializer(_binary.int32_serializer, PatientGender)))])

    def write(self, stream: _binary.CodedOutputStream, value: SubjectInformationType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.patient_name, value.patient_weight_kg, value.patient_height_m, value.patient_id, value.patient_birthdate, value.patient_gender)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['patient_name'], value['patient_weight_kg'], value['patient_height_m'], value['patient_id'], value['patient_birthdate'], value['patient_gender'])

    def read(self, stream: _binary.CodedInputStream) -> SubjectInformationType:
        field_values = self._read(stream)
        return SubjectInformationType(patient_name=field_values[0], patient_weight_kg=field_values[1], patient_height_m=field_values[2], patient_id=field_values[3], patient_birthdate=field_values[4], patient_gender=field_values[5])


class StudyInformationTypeSerializer(_binary.RecordSerializer[StudyInformationType]):
    def __init__(self) -> None:
        super().__init__([("study_date", _binary.OptionalSerializer(_binary.date_serializer)), ("study_time", _binary.OptionalSerializer(_binary.time_serializer)), ("study_id", _binary.OptionalSerializer(_binary.string_serializer)), ("accession_number", _binary.OptionalSerializer(_binary.int64_serializer)), ("referring_physician_name", _binary.OptionalSerializer(_binary.string_serializer)), ("study_description", _binary.OptionalSerializer(_binary.string_serializer)), ("study_instance_uid", _binary.OptionalSerializer(_binary.string_serializer)), ("body_part_examined", _binary.OptionalSerializer(_binary.string_serializer))])

    def write(self, stream: _binary.CodedOutputStream, value: StudyInformationType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.study_date, value.study_time, value.study_id, value.accession_number, value.referring_physician_name, value.study_description, value.study_instance_uid, value.body_part_examined)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['study_date'], value['study_time'], value['study_id'], value['accession_number'], value['referring_physician_name'], value['study_description'], value['study_instance_uid'], value['body_part_examined'])

    def read(self, stream: _binary.CodedInputStream) -> StudyInformationType:
        field_values = self._read(stream)
        return StudyInformationType(study_date=field_values[0], study_time=field_values[1], study_id=field_values[2], accession_number=field_values[3], referring_physician_name=field_values[4], study_description=field_values[5], study_instance_uid=field_values[6], body_part_examined=field_values[7])


class ThreeDimensionalFloatSerializer(_binary.RecordSerializer[ThreeDimensionalFloat]):
    def __init__(self) -> None:
        super().__init__([("x", _binary.float32_serializer), ("y", _binary.float32_serializer), ("z", _binary.float32_serializer)])

    def write(self, stream: _binary.CodedOutputStream, value: ThreeDimensionalFloat) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.x, value.y, value.z)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['x'], value['y'], value['z'])

    def read(self, stream: _binary.CodedInputStream) -> ThreeDimensionalFloat:
        field_values = self._read(stream)
        return ThreeDimensionalFloat(x=field_values[0], y=field_values[1], z=field_values[2])


class MeasurementDependencyTypeSerializer(_binary.RecordSerializer[MeasurementDependencyType]):
    def __init__(self) -> None:
        super().__init__([("dependency_type", _binary.string_serializer), ("measurement_id", _binary.string_serializer)])

    def write(self, stream: _binary.CodedOutputStream, value: MeasurementDependencyType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.dependency_type, value.measurement_id)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['dependency_type'], value['measurement_id'])

    def read(self, stream: _binary.CodedInputStream) -> MeasurementDependencyType:
        field_values = self._read(stream)
        return MeasurementDependencyType(dependency_type=field_values[0], measurement_id=field_values[1])


class ReferencedImageSequenceTypeSerializer(_binary.RecordSerializer[ReferencedImageSequenceType]):
    def __init__(self) -> None:
        super().__init__([("referenced_sop_instance_uid", _binary.VectorSerializer(_binary.string_serializer))])

    def write(self, stream: _binary.CodedOutputStream, value: ReferencedImageSequenceType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.referenced_sop_instance_uid)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['referenced_sop_instance_uid'])

    def read(self, stream: _binary.CodedInputStream) -> ReferencedImageSequenceType:
        field_values = self._read(stream)
        return ReferencedImageSequenceType(referenced_sop_instance_uid=field_values[0])


class MeasurementInformationTypeSerializer(_binary.RecordSerializer[MeasurementInformationType]):
    def __init__(self) -> None:
        super().__init__([("measurement_id", _binary.OptionalSerializer(_binary.string_serializer)), ("series_date", _binary.OptionalSerializer(_binary.date_serializer)), ("series_time", _binary.OptionalSerializer(_binary.time_serializer)), ("patient_position", _binary.EnumSerializer(_binary.int32_serializer, PatientPosition)), ("relative_table_position", _binary.OptionalSerializer(ThreeDimensionalFloatSerializer())), ("initial_series_number", _binary.OptionalSerializer(_binary.int64_serializer)), ("protocol_name", _binary.OptionalSerializer(_binary.string_serializer)), ("sequence_name", _binary.OptionalSerializer(_binary.string_serializer)), ("series_description", _binary.OptionalSerializer(_binary.string_serializer)), ("measurement_dependency", _binary.VectorSerializer(MeasurementDependencyTypeSerializer())), ("series_instance_uid_root", _binary.OptionalSerializer(_binary.string_serializer)), ("frame_of_reference_uid", _binary.OptionalSerializer(_binary.string_serializer)), ("referenced_image_sequence", _binary.OptionalSerializer(ReferencedImageSequenceTypeSerializer()))])

    def write(self, stream: _binary.CodedOutputStream, value: MeasurementInformationType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.measurement_id, value.series_date, value.series_time, value.patient_position, value.relative_table_position, value.initial_series_number, value.protocol_name, value.sequence_name, value.series_description, value.measurement_dependency, value.series_instance_uid_root, value.frame_of_reference_uid, value.referenced_image_sequence)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['measurement_id'], value['series_date'], value['series_time'], value['patient_position'], value['relative_table_position'], value['initial_series_number'], value['protocol_name'], value['sequence_name'], value['series_description'], value['measurement_dependency'], value['series_instance_uid_root'], value['frame_of_reference_uid'], value['referenced_image_sequence'])

    def read(self, stream: _binary.CodedInputStream) -> MeasurementInformationType:
        field_values = self._read(stream)
        return MeasurementInformationType(measurement_id=field_values[0], series_date=field_values[1], series_time=field_values[2], patient_position=field_values[3], relative_table_position=field_values[4], initial_series_number=field_values[5], protocol_name=field_values[6], sequence_name=field_values[7], series_description=field_values[8], measurement_dependency=field_values[9], series_instance_uid_root=field_values[10], frame_of_reference_uid=field_values[11], referenced_image_sequence=field_values[12])


class CoilLabelTypeSerializer(_binary.RecordSerializer[CoilLabelType]):
    def __init__(self) -> None:
        super().__init__([("coil_number", _binary.uint32_serializer), ("coil_name", _binary.string_serializer)])

    def write(self, stream: _binary.CodedOutputStream, value: CoilLabelType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.coil_number, value.coil_name)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['coil_number'], value['coil_name'])

    def read(self, stream: _binary.CodedInputStream) -> CoilLabelType:
        field_values = self._read(stream)
        return CoilLabelType(coil_number=field_values[0], coil_name=field_values[1])


class AcquisitionSystemInformationTypeSerializer(_binary.RecordSerializer[AcquisitionSystemInformationType]):
    def __init__(self) -> None:
        super().__init__([("system_vendor", _binary.OptionalSerializer(_binary.string_serializer)), ("system_model", _binary.OptionalSerializer(_binary.string_serializer)), ("system_field_strength_t", _binary.OptionalSerializer(_binary.float32_serializer)), ("relative_receiver_noise_bandwidth", _binary.OptionalSerializer(_binary.float32_serializer)), ("receiver_channels", _binary.OptionalSerializer(_binary.uint32_serializer)), ("coil_label", _binary.VectorSerializer(CoilLabelTypeSerializer())), ("institution_name", _binary.OptionalSerializer(_binary.string_serializer)), ("station_name", _binary.OptionalSerializer(_binary.string_serializer)), ("device_id", _binary.OptionalSerializer(_binary.string_serializer)), ("device_serial_number", _binary.OptionalSerializer(_binary.string_serializer))])

    def write(self, stream: _binary.CodedOutputStream, value: AcquisitionSystemInformationType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.system_vendor, value.system_model, value.system_field_strength_t, value.relative_receiver_noise_bandwidth, value.receiver_channels, value.coil_label, value.institution_name, value.station_name, value.device_id, value.device_serial_number)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['system_vendor'], value['system_model'], value['system_field_strength_t'], value['relative_receiver_noise_bandwidth'], value['receiver_channels'], value['coil_label'], value['institution_name'], value['station_name'], value['device_id'], value['device_serial_number'])

    def read(self, stream: _binary.CodedInputStream) -> AcquisitionSystemInformationType:
        field_values = self._read(stream)
        return AcquisitionSystemInformationType(system_vendor=field_values[0], system_model=field_values[1], system_field_strength_t=field_values[2], relative_receiver_noise_bandwidth=field_values[3], receiver_channels=field_values[4], coil_label=field_values[5], institution_name=field_values[6], station_name=field_values[7], device_id=field_values[8], device_serial_number=field_values[9])


class ExperimentalConditionsTypeSerializer(_binary.RecordSerializer[ExperimentalConditionsType]):
    def __init__(self) -> None:
        super().__init__([("h1resonance_frequency_hz", _binary.int64_serializer)])

    def write(self, stream: _binary.CodedOutputStream, value: ExperimentalConditionsType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.h1resonance_frequency_hz)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['h1resonance_frequency_hz'])

    def read(self, stream: _binary.CodedInputStream) -> ExperimentalConditionsType:
        field_values = self._read(stream)
        return ExperimentalConditionsType(h1resonance_frequency_hz=field_values[0])


class MatrixSizeTypeSerializer(_binary.RecordSerializer[MatrixSizeType]):
    def __init__(self) -> None:
        super().__init__([("x", _binary.uint32_serializer), ("y", _binary.uint32_serializer), ("z", _binary.uint32_serializer)])

    def write(self, stream: _binary.CodedOutputStream, value: MatrixSizeType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.x, value.y, value.z)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['x'], value['y'], value['z'])

    def read(self, stream: _binary.CodedInputStream) -> MatrixSizeType:
        field_values = self._read(stream)
        return MatrixSizeType(x=field_values[0], y=field_values[1], z=field_values[2])


class FieldOfViewMmSerializer(_binary.RecordSerializer[FieldOfViewMm]):
    def __init__(self) -> None:
        super().__init__([("x", _binary.float32_serializer), ("y", _binary.float32_serializer), ("z", _binary.float32_serializer)])

    def write(self, stream: _binary.CodedOutputStream, value: FieldOfViewMm) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.x, value.y, value.z)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['x'], value['y'], value['z'])

    def read(self, stream: _binary.CodedInputStream) -> FieldOfViewMm:
        field_values = self._read(stream)
        return FieldOfViewMm(x=field_values[0], y=field_values[1], z=field_values[2])


class EncodingSpaceTypeSerializer(_binary.RecordSerializer[EncodingSpaceType]):
    def __init__(self) -> None:
        super().__init__([("matrix_size", MatrixSizeTypeSerializer()), ("field_of_view_mm", FieldOfViewMmSerializer())])

    def write(self, stream: _binary.CodedOutputStream, value: EncodingSpaceType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.matrix_size, value.field_of_view_mm)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['matrix_size'], value['field_of_view_mm'])

    def read(self, stream: _binary.CodedInputStream) -> EncodingSpaceType:
        field_values = self._read(stream)
        return EncodingSpaceType(matrix_size=field_values[0], field_of_view_mm=field_values[1])


class LimitTypeSerializer(_binary.RecordSerializer[LimitType]):
    def __init__(self) -> None:
        super().__init__([("minimum", _binary.uint32_serializer), ("maximum", _binary.uint32_serializer), ("center", _binary.uint32_serializer)])

    def write(self, stream: _binary.CodedOutputStream, value: LimitType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.minimum, value.maximum, value.center)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['minimum'], value['maximum'], value['center'])

    def read(self, stream: _binary.CodedInputStream) -> LimitType:
        field_values = self._read(stream)
        return LimitType(minimum=field_values[0], maximum=field_values[1], center=field_values[2])


class EncodingLimitsTypeSerializer(_binary.RecordSerializer[EncodingLimitsType]):
    def __init__(self) -> None:
        super().__init__([("kspace_encoding_step_0", _binary.OptionalSerializer(LimitTypeSerializer())), ("kspace_encoding_step_1", _binary.OptionalSerializer(LimitTypeSerializer())), ("kspace_encoding_step_2", _binary.OptionalSerializer(LimitTypeSerializer())), ("average", _binary.OptionalSerializer(LimitTypeSerializer())), ("slice", _binary.OptionalSerializer(LimitTypeSerializer())), ("contrast", _binary.OptionalSerializer(LimitTypeSerializer())), ("phase", _binary.OptionalSerializer(LimitTypeSerializer())), ("repetition", _binary.OptionalSerializer(LimitTypeSerializer())), ("set", _binary.OptionalSerializer(LimitTypeSerializer())), ("segment", _binary.OptionalSerializer(LimitTypeSerializer())), ("user_0", _binary.OptionalSerializer(LimitTypeSerializer())), ("user_1", _binary.OptionalSerializer(LimitTypeSerializer())), ("user_2", _binary.OptionalSerializer(LimitTypeSerializer())), ("user_3", _binary.OptionalSerializer(LimitTypeSerializer())), ("user_4", _binary.OptionalSerializer(LimitTypeSerializer())), ("user_5", _binary.OptionalSerializer(LimitTypeSerializer())), ("user_6", _binary.OptionalSerializer(LimitTypeSerializer())), ("user_7", _binary.OptionalSerializer(LimitTypeSerializer()))])

    def write(self, stream: _binary.CodedOutputStream, value: EncodingLimitsType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.kspace_encoding_step_0, value.kspace_encoding_step_1, value.kspace_encoding_step_2, value.average, value.slice, value.contrast, value.phase, value.repetition, value.set, value.segment, value.user_0, value.user_1, value.user_2, value.user_3, value.user_4, value.user_5, value.user_6, value.user_7)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['kspace_encoding_step_0'], value['kspace_encoding_step_1'], value['kspace_encoding_step_2'], value['average'], value['slice'], value['contrast'], value['phase'], value['repetition'], value['set'], value['segment'], value['user_0'], value['user_1'], value['user_2'], value['user_3'], value['user_4'], value['user_5'], value['user_6'], value['user_7'])

    def read(self, stream: _binary.CodedInputStream) -> EncodingLimitsType:
        field_values = self._read(stream)
        return EncodingLimitsType(kspace_encoding_step_0=field_values[0], kspace_encoding_step_1=field_values[1], kspace_encoding_step_2=field_values[2], average=field_values[3], slice=field_values[4], contrast=field_values[5], phase=field_values[6], repetition=field_values[7], set=field_values[8], segment=field_values[9], user_0=field_values[10], user_1=field_values[11], user_2=field_values[12], user_3=field_values[13], user_4=field_values[14], user_5=field_values[15], user_6=field_values[16], user_7=field_values[17])


class UserParameterLongTypeSerializer(_binary.RecordSerializer[UserParameterLongType]):
    def __init__(self) -> None:
        super().__init__([("name", _binary.string_serializer), ("value", _binary.int64_serializer)])

    def write(self, stream: _binary.CodedOutputStream, value: UserParameterLongType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.name, value.value)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['name'], value['value'])

    def read(self, stream: _binary.CodedInputStream) -> UserParameterLongType:
        field_values = self._read(stream)
        return UserParameterLongType(name=field_values[0], value=field_values[1])


class UserParameterDoubleTypeSerializer(_binary.RecordSerializer[UserParameterDoubleType]):
    def __init__(self) -> None:
        super().__init__([("name", _binary.string_serializer), ("value", _binary.float64_serializer)])

    def write(self, stream: _binary.CodedOutputStream, value: UserParameterDoubleType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.name, value.value)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['name'], value['value'])

    def read(self, stream: _binary.CodedInputStream) -> UserParameterDoubleType:
        field_values = self._read(stream)
        return UserParameterDoubleType(name=field_values[0], value=field_values[1])


class UserParameterStringTypeSerializer(_binary.RecordSerializer[UserParameterStringType]):
    def __init__(self) -> None:
        super().__init__([("name", _binary.string_serializer), ("value", _binary.string_serializer)])

    def write(self, stream: _binary.CodedOutputStream, value: UserParameterStringType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.name, value.value)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['name'], value['value'])

    def read(self, stream: _binary.CodedInputStream) -> UserParameterStringType:
        field_values = self._read(stream)
        return UserParameterStringType(name=field_values[0], value=field_values[1])


class TrajectoryDescriptionTypeSerializer(_binary.RecordSerializer[TrajectoryDescriptionType]):
    def __init__(self) -> None:
        super().__init__([("identifier", _binary.string_serializer), ("user_parameter_long", _binary.VectorSerializer(UserParameterLongTypeSerializer())), ("user_parameter_double", _binary.VectorSerializer(UserParameterDoubleTypeSerializer())), ("user_parameter_string", _binary.VectorSerializer(UserParameterStringTypeSerializer())), ("comment", _binary.OptionalSerializer(_binary.string_serializer))])

    def write(self, stream: _binary.CodedOutputStream, value: TrajectoryDescriptionType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.identifier, value.user_parameter_long, value.user_parameter_double, value.user_parameter_string, value.comment)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['identifier'], value['user_parameter_long'], value['user_parameter_double'], value['user_parameter_string'], value['comment'])

    def read(self, stream: _binary.CodedInputStream) -> TrajectoryDescriptionType:
        field_values = self._read(stream)
        return TrajectoryDescriptionType(identifier=field_values[0], user_parameter_long=field_values[1], user_parameter_double=field_values[2], user_parameter_string=field_values[3], comment=field_values[4])


class AccelerationFactorTypeSerializer(_binary.RecordSerializer[AccelerationFactorType]):
    def __init__(self) -> None:
        super().__init__([("kspace_encoding_step_1", _binary.uint32_serializer), ("kspace_encoding_step_2", _binary.uint32_serializer)])

    def write(self, stream: _binary.CodedOutputStream, value: AccelerationFactorType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.kspace_encoding_step_1, value.kspace_encoding_step_2)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['kspace_encoding_step_1'], value['kspace_encoding_step_2'])

    def read(self, stream: _binary.CodedInputStream) -> AccelerationFactorType:
        field_values = self._read(stream)
        return AccelerationFactorType(kspace_encoding_step_1=field_values[0], kspace_encoding_step_2=field_values[1])


class MultibandSpacingTypeSerializer(_binary.RecordSerializer[MultibandSpacingType]):
    def __init__(self) -> None:
        super().__init__([("d_z", _binary.VectorSerializer(_binary.float32_serializer))])

    def write(self, stream: _binary.CodedOutputStream, value: MultibandSpacingType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.d_z)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['d_z'])

    def read(self, stream: _binary.CodedInputStream) -> MultibandSpacingType:
        field_values = self._read(stream)
        return MultibandSpacingType(d_z=field_values[0])


class MultibandTypeSerializer(_binary.RecordSerializer[MultibandType]):
    def __init__(self) -> None:
        super().__init__([("spacing", _binary.VectorSerializer(MultibandSpacingTypeSerializer())), ("delta_kz", _binary.float32_serializer), ("multiband_factor", _binary.uint32_serializer), ("calibration", _binary.EnumSerializer(_binary.int32_serializer, Calibration)), ("calibration_encoding", _binary.uint64_serializer)])

    def write(self, stream: _binary.CodedOutputStream, value: MultibandType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.spacing, value.delta_kz, value.multiband_factor, value.calibration, value.calibration_encoding)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['spacing'], value['delta_kz'], value['multiband_factor'], value['calibration'], value['calibration_encoding'])

    def read(self, stream: _binary.CodedInputStream) -> MultibandType:
        field_values = self._read(stream)
        return MultibandType(spacing=field_values[0], delta_kz=field_values[1], multiband_factor=field_values[2], calibration=field_values[3], calibration_encoding=field_values[4])


class ParallelImagingTypeSerializer(_binary.RecordSerializer[ParallelImagingType]):
    def __init__(self) -> None:
        super().__init__([("acceleration_factor", AccelerationFactorTypeSerializer()), ("calibration_mode", _binary.OptionalSerializer(_binary.EnumSerializer(_binary.int32_serializer, CalibrationMode))), ("interleaving_dimension", _binary.OptionalSerializer(_binary.EnumSerializer(_binary.int32_serializer, InterleavingDimension))), ("multiband", _binary.OptionalSerializer(MultibandTypeSerializer()))])

    def write(self, stream: _binary.CodedOutputStream, value: ParallelImagingType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.acceleration_factor, value.calibration_mode, value.interleaving_dimension, value.multiband)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['acceleration_factor'], value['calibration_mode'], value['interleaving_dimension'], value['multiband'])

    def read(self, stream: _binary.CodedInputStream) -> ParallelImagingType:
        field_values = self._read(stream)
        return ParallelImagingType(acceleration_factor=field_values[0], calibration_mode=field_values[1], interleaving_dimension=field_values[2], multiband=field_values[3])


class EncodingTypeSerializer(_binary.RecordSerializer[EncodingType]):
    def __init__(self) -> None:
        super().__init__([("encoded_space", EncodingSpaceTypeSerializer()), ("recon_space", EncodingSpaceTypeSerializer()), ("encoding_limits", EncodingLimitsTypeSerializer()), ("trajectory", _binary.EnumSerializer(_binary.int32_serializer, Trajectory)), ("trajectory_description", _binary.OptionalSerializer(TrajectoryDescriptionTypeSerializer())), ("parallel_imaging", _binary.OptionalSerializer(ParallelImagingTypeSerializer())), ("echo_train_length", _binary.OptionalSerializer(_binary.int64_serializer))])

    def write(self, stream: _binary.CodedOutputStream, value: EncodingType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.encoded_space, value.recon_space, value.encoding_limits, value.trajectory, value.trajectory_description, value.parallel_imaging, value.echo_train_length)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['encoded_space'], value['recon_space'], value['encoding_limits'], value['trajectory'], value['trajectory_description'], value['parallel_imaging'], value['echo_train_length'])

    def read(self, stream: _binary.CodedInputStream) -> EncodingType:
        field_values = self._read(stream)
        return EncodingType(encoded_space=field_values[0], recon_space=field_values[1], encoding_limits=field_values[2], trajectory=field_values[3], trajectory_description=field_values[4], parallel_imaging=field_values[5], echo_train_length=field_values[6])


class GradientDirectionTypeSerializer(_binary.RecordSerializer[GradientDirectionType]):
    def __init__(self) -> None:
        super().__init__([("rl", _binary.float32_serializer), ("ap", _binary.float32_serializer), ("fh", _binary.float32_serializer)])

    def write(self, stream: _binary.CodedOutputStream, value: GradientDirectionType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.rl, value.ap, value.fh)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['rl'], value['ap'], value['fh'])

    def read(self, stream: _binary.CodedInputStream) -> GradientDirectionType:
        field_values = self._read(stream)
        return GradientDirectionType(rl=field_values[0], ap=field_values[1], fh=field_values[2])


class DiffusionTypeSerializer(_binary.RecordSerializer[DiffusionType]):
    def __init__(self) -> None:
        super().__init__([("gradient_direction", GradientDirectionTypeSerializer()), ("bvalue", _binary.float32_serializer)])

    def write(self, stream: _binary.CodedOutputStream, value: DiffusionType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.gradient_direction, value.bvalue)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['gradient_direction'], value['bvalue'])

    def read(self, stream: _binary.CodedInputStream) -> DiffusionType:
        field_values = self._read(stream)
        return DiffusionType(gradient_direction=field_values[0], bvalue=field_values[1])


class SequenceParametersTypeSerializer(_binary.RecordSerializer[SequenceParametersType]):
    def __init__(self) -> None:
        super().__init__([("t_r", _binary.VectorSerializer(_binary.float32_serializer)), ("t_e", _binary.VectorSerializer(_binary.float32_serializer)), ("t_i", _binary.VectorSerializer(_binary.float32_serializer)), ("flip_angle_deg", _binary.VectorSerializer(_binary.float32_serializer)), ("sequence_type", _binary.OptionalSerializer(_binary.string_serializer)), ("echo_spacing", _binary.VectorSerializer(_binary.float32_serializer)), ("diffusion_dimension", _binary.OptionalSerializer(_binary.EnumSerializer(_binary.int32_serializer, DiffusionDimension))), ("diffusion", _binary.VectorSerializer(DiffusionTypeSerializer())), ("diffusion_scheme", _binary.OptionalSerializer(_binary.string_serializer))])

    def write(self, stream: _binary.CodedOutputStream, value: SequenceParametersType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.t_r, value.t_e, value.t_i, value.flip_angle_deg, value.sequence_type, value.echo_spacing, value.diffusion_dimension, value.diffusion, value.diffusion_scheme)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['t_r'], value['t_e'], value['t_i'], value['flip_angle_deg'], value['sequence_type'], value['echo_spacing'], value['diffusion_dimension'], value['diffusion'], value['diffusion_scheme'])

    def read(self, stream: _binary.CodedInputStream) -> SequenceParametersType:
        field_values = self._read(stream)
        return SequenceParametersType(t_r=field_values[0], t_e=field_values[1], t_i=field_values[2], flip_angle_deg=field_values[3], sequence_type=field_values[4], echo_spacing=field_values[5], diffusion_dimension=field_values[6], diffusion=field_values[7], diffusion_scheme=field_values[8])


class UserParameterBase64TypeSerializer(_binary.RecordSerializer[UserParameterBase64Type]):
    def __init__(self) -> None:
        super().__init__([("name", _binary.string_serializer), ("value", _binary.string_serializer)])

    def write(self, stream: _binary.CodedOutputStream, value: UserParameterBase64Type) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.name, value.value)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['name'], value['value'])

    def read(self, stream: _binary.CodedInputStream) -> UserParameterBase64Type:
        field_values = self._read(stream)
        return UserParameterBase64Type(name=field_values[0], value=field_values[1])


class UserParametersTypeSerializer(_binary.RecordSerializer[UserParametersType]):
    def __init__(self) -> None:
        super().__init__([("user_parameter_long", _binary.VectorSerializer(UserParameterLongTypeSerializer())), ("user_parameter_double", _binary.VectorSerializer(UserParameterDoubleTypeSerializer())), ("user_parameter_string", _binary.VectorSerializer(UserParameterStringTypeSerializer())), ("user_parameter_base64", _binary.VectorSerializer(UserParameterBase64TypeSerializer()))])

    def write(self, stream: _binary.CodedOutputStream, value: UserParametersType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.user_parameter_long, value.user_parameter_double, value.user_parameter_string, value.user_parameter_base64)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['user_parameter_long'], value['user_parameter_double'], value['user_parameter_string'], value['user_parameter_base64'])

    def read(self, stream: _binary.CodedInputStream) -> UserParametersType:
        field_values = self._read(stream)
        return UserParametersType(user_parameter_long=field_values[0], user_parameter_double=field_values[1], user_parameter_string=field_values[2], user_parameter_base64=field_values[3])


class WaveformInformationTypeSerializer(_binary.RecordSerializer[WaveformInformationType]):
    def __init__(self) -> None:
        super().__init__([("waveform_name", _binary.string_serializer), ("waveform_type", _binary.EnumSerializer(_binary.int32_serializer, WaveformType)), ("user_parameters", UserParametersTypeSerializer())])

    def write(self, stream: _binary.CodedOutputStream, value: WaveformInformationType) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.waveform_name, value.waveform_type, value.user_parameters)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['waveform_name'], value['waveform_type'], value['user_parameters'])

    def read(self, stream: _binary.CodedInputStream) -> WaveformInformationType:
        field_values = self._read(stream)
        return WaveformInformationType(waveform_name=field_values[0], waveform_type=field_values[1], user_parameters=field_values[2])


class HeaderSerializer(_binary.RecordSerializer[Header]):
    def __init__(self) -> None:
        super().__init__([("version", _binary.OptionalSerializer(_binary.int64_serializer)), ("subject_information", _binary.OptionalSerializer(SubjectInformationTypeSerializer())), ("study_information", _binary.OptionalSerializer(StudyInformationTypeSerializer())), ("measurement_information", _binary.OptionalSerializer(MeasurementInformationTypeSerializer())), ("acquisition_system_information", _binary.OptionalSerializer(AcquisitionSystemInformationTypeSerializer())), ("experimental_conditions", ExperimentalConditionsTypeSerializer()), ("encoding", _binary.VectorSerializer(EncodingTypeSerializer())), ("sequence_parameters", _binary.OptionalSerializer(SequenceParametersTypeSerializer())), ("user_parameters", _binary.OptionalSerializer(UserParametersTypeSerializer())), ("waveform_information", _binary.VectorSerializer(WaveformInformationTypeSerializer()))])

    def write(self, stream: _binary.CodedOutputStream, value: Header) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.version, value.subject_information, value.study_information, value.measurement_information, value.acquisition_system_information, value.experimental_conditions, value.encoding, value.sequence_parameters, value.user_parameters, value.waveform_information)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['version'], value['subject_information'], value['study_information'], value['measurement_information'], value['acquisition_system_information'], value['experimental_conditions'], value['encoding'], value['sequence_parameters'], value['user_parameters'], value['waveform_information'])

    def read(self, stream: _binary.CodedInputStream) -> Header:
        field_values = self._read(stream)
        return Header(version=field_values[0], subject_information=field_values[1], study_information=field_values[2], measurement_information=field_values[3], acquisition_system_information=field_values[4], experimental_conditions=field_values[5], encoding=field_values[6], sequence_parameters=field_values[7], user_parameters=field_values[8], waveform_information=field_values[9])


class ImageHeaderSerializer(_binary.RecordSerializer[ImageHeader]):
    def __init__(self) -> None:
        super().__init__([("flags", _binary.EnumSerializer(_binary.uint64_serializer, ImageFlags)), ("measurement_uid", _binary.uint32_serializer), ("field_of_view", _binary.FixedNDArraySerializer(_binary.float32_serializer, (3,))), ("position", _binary.FixedNDArraySerializer(_binary.float32_serializer, (3,))), ("col_dir", _binary.FixedNDArraySerializer(_binary.float32_serializer, (3,))), ("line_dir", _binary.FixedNDArraySerializer(_binary.float32_serializer, (3,))), ("slice_dir", _binary.FixedNDArraySerializer(_binary.float32_serializer, (3,))), ("patient_table_position", _binary.FixedNDArraySerializer(_binary.float32_serializer, (3,))), ("average", _binary.OptionalSerializer(_binary.uint32_serializer)), ("slice", _binary.OptionalSerializer(_binary.uint32_serializer)), ("contrast", _binary.OptionalSerializer(_binary.uint32_serializer)), ("phase", _binary.OptionalSerializer(_binary.uint32_serializer)), ("repetition", _binary.OptionalSerializer(_binary.uint32_serializer)), ("set", _binary.OptionalSerializer(_binary.uint32_serializer)), ("acquisition_time_stamp_ns", _binary.OptionalSerializer(_binary.uint64_serializer)), ("physiology_time_stamp_ns", _binary.VectorSerializer(_binary.uint64_serializer)), ("image_type", _binary.EnumSerializer(_binary.int32_serializer, ImageType)), ("image_index", _binary.OptionalSerializer(_binary.uint32_serializer)), ("image_series_index", _binary.OptionalSerializer(_binary.uint32_serializer)), ("user_int", _binary.VectorSerializer(_binary.int32_serializer)), ("user_float", _binary.VectorSerializer(_binary.float32_serializer))])

    def write(self, stream: _binary.CodedOutputStream, value: ImageHeader) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.flags, value.measurement_uid, value.field_of_view, value.position, value.col_dir, value.line_dir, value.slice_dir, value.patient_table_position, value.average, value.slice, value.contrast, value.phase, value.repetition, value.set, value.acquisition_time_stamp_ns, value.physiology_time_stamp_ns, value.image_type, value.image_index, value.image_series_index, value.user_int, value.user_float)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['flags'], value['measurement_uid'], value['field_of_view'], value['position'], value['col_dir'], value['line_dir'], value['slice_dir'], value['patient_table_position'], value['average'], value['slice'], value['contrast'], value['phase'], value['repetition'], value['set'], value['acquisition_time_stamp_ns'], value['physiology_time_stamp_ns'], value['image_type'], value['image_index'], value['image_series_index'], value['user_int'], value['user_float'])

    def read(self, stream: _binary.CodedInputStream) -> ImageHeader:
        field_values = self._read(stream)
        return ImageHeader(flags=field_values[0], measurement_uid=field_values[1], field_of_view=field_values[2], position=field_values[3], col_dir=field_values[4], line_dir=field_values[5], slice_dir=field_values[6], patient_table_position=field_values[7], average=field_values[8], slice=field_values[9], contrast=field_values[10], phase=field_values[11], repetition=field_values[12], set=field_values[13], acquisition_time_stamp_ns=field_values[14], physiology_time_stamp_ns=field_values[15], image_type=field_values[16], image_index=field_values[17], image_series_index=field_values[18], user_int=field_values[19], user_float=field_values[20])


class ImageSerializer(typing.Generic[T, T_NP], _binary.RecordSerializer[Image[T_NP]]):
    def __init__(self, t_serializer: _binary.TypeSerializer[T, T_NP]) -> None:
        super().__init__([("head", ImageHeaderSerializer()), ("data", _binary.NDArraySerializer(t_serializer, 4)), ("meta", _binary.MapSerializer(_binary.string_serializer, _binary.VectorSerializer(_binary.UnionSerializer(ImageMetaValue, [(ImageMetaValue.String, _binary.string_serializer), (ImageMetaValue.Int64, _binary.int64_serializer), (ImageMetaValue.Float64, _binary.float64_serializer)]))))])

    def write(self, stream: _binary.CodedOutputStream, value: Image[T_NP]) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.head, value.data, value.meta)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['head'], value['data'], value['meta'])

    def read(self, stream: _binary.CodedInputStream) -> Image[T_NP]:
        field_values = self._read(stream)
        return Image[T_NP](head=field_values[0], data=field_values[1], meta=field_values[2])


class NoiseCovarianceSerializer(_binary.RecordSerializer[NoiseCovariance]):
    def __init__(self) -> None:
        super().__init__([("coil_labels", _binary.VectorSerializer(CoilLabelTypeSerializer())), ("receiver_noise_bandwidth", _binary.float32_serializer), ("noise_dwell_time_ns", _binary.uint64_serializer), ("sample_count", _binary.size_serializer), ("matrix", _binary.NDArraySerializer(_binary.complexfloat32_serializer, 2))])

    def write(self, stream: _binary.CodedOutputStream, value: NoiseCovariance) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.coil_labels, value.receiver_noise_bandwidth, value.noise_dwell_time_ns, value.sample_count, value.matrix)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['coil_labels'], value['receiver_noise_bandwidth'], value['noise_dwell_time_ns'], value['sample_count'], value['matrix'])

    def read(self, stream: _binary.CodedInputStream) -> NoiseCovariance:
        field_values = self._read(stream)
        return NoiseCovariance(coil_labels=field_values[0], receiver_noise_bandwidth=field_values[1], noise_dwell_time_ns=field_values[2], sample_count=field_values[3], matrix=field_values[4])


class WaveformSerializer(typing.Generic[T, T_NP], _binary.RecordSerializer[Waveform[T_NP]]):
    def __init__(self, t_serializer: _binary.TypeSerializer[T, T_NP]) -> None:
        super().__init__([("flags", _binary.uint64_serializer), ("measurement_uid", _binary.uint32_serializer), ("scan_counter", _binary.uint32_serializer), ("time_stamp_ns", _binary.uint64_serializer), ("sample_time_ns", _binary.uint64_serializer), ("waveform_id", _binary.uint32_serializer), ("data", _binary.NDArraySerializer(t_serializer, 2))])

    def write(self, stream: _binary.CodedOutputStream, value: Waveform[T_NP]) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.flags, value.measurement_uid, value.scan_counter, value.time_stamp_ns, value.sample_time_ns, value.waveform_id, value.data)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['flags'], value['measurement_uid'], value['scan_counter'], value['time_stamp_ns'], value['sample_time_ns'], value['waveform_id'], value['data'])

    def read(self, stream: _binary.CodedInputStream) -> Waveform[T_NP]:
        field_values = self._read(stream)
        return Waveform[T_NP](flags=field_values[0], measurement_uid=field_values[1], scan_counter=field_values[2], time_stamp_ns=field_values[3], sample_time_ns=field_values[4], waveform_id=field_values[5], data=field_values[6])


class AcquisitionBucketSerializer(_binary.RecordSerializer[AcquisitionBucket]):
    def __init__(self) -> None:
        super().__init__([("data", _binary.VectorSerializer(AcquisitionSerializer())), ("ref", _binary.VectorSerializer(AcquisitionSerializer())), ("datastats", _binary.VectorSerializer(EncodingLimitsTypeSerializer())), ("refstats", _binary.VectorSerializer(EncodingLimitsTypeSerializer())), ("waveforms", _binary.VectorSerializer(WaveformSerializer(_binary.uint32_serializer)))])

    def write(self, stream: _binary.CodedOutputStream, value: AcquisitionBucket) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.data, value.ref, value.datastats, value.refstats, value.waveforms)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['data'], value['ref'], value['datastats'], value['refstats'], value['waveforms'])

    def read(self, stream: _binary.CodedInputStream) -> AcquisitionBucket:
        field_values = self._read(stream)
        return AcquisitionBucket(data=field_values[0], ref=field_values[1], datastats=field_values[2], refstats=field_values[3], waveforms=field_values[4])


class SamplingLimitsSerializer(_binary.RecordSerializer[SamplingLimits]):
    def __init__(self) -> None:
        super().__init__([("kspace_encoding_step_0", LimitTypeSerializer()), ("kspace_encoding_step_1", LimitTypeSerializer()), ("kspace_encoding_step_2", LimitTypeSerializer())])

    def write(self, stream: _binary.CodedOutputStream, value: SamplingLimits) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.kspace_encoding_step_0, value.kspace_encoding_step_1, value.kspace_encoding_step_2)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['kspace_encoding_step_0'], value['kspace_encoding_step_1'], value['kspace_encoding_step_2'])

    def read(self, stream: _binary.CodedInputStream) -> SamplingLimits:
        field_values = self._read(stream)
        return SamplingLimits(kspace_encoding_step_0=field_values[0], kspace_encoding_step_1=field_values[1], kspace_encoding_step_2=field_values[2])


class SamplingDescriptionSerializer(_binary.RecordSerializer[SamplingDescription]):
    def __init__(self) -> None:
        super().__init__([("encoded_fov", FieldOfViewMmSerializer()), ("recon_fov", FieldOfViewMmSerializer()), ("encoded_matrix", MatrixSizeTypeSerializer()), ("recon_matrix", MatrixSizeTypeSerializer()), ("sampling_limits", SamplingLimitsSerializer())])

    def write(self, stream: _binary.CodedOutputStream, value: SamplingDescription) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.encoded_fov, value.recon_fov, value.encoded_matrix, value.recon_matrix, value.sampling_limits)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['encoded_fov'], value['recon_fov'], value['encoded_matrix'], value['recon_matrix'], value['sampling_limits'])

    def read(self, stream: _binary.CodedInputStream) -> SamplingDescription:
        field_values = self._read(stream)
        return SamplingDescription(encoded_fov=field_values[0], recon_fov=field_values[1], encoded_matrix=field_values[2], recon_matrix=field_values[3], sampling_limits=field_values[4])


class ReconBufferSerializer(_binary.RecordSerializer[ReconBuffer]):
    def __init__(self) -> None:
        super().__init__([("data", _binary.NDArraySerializer(_binary.complexfloat32_serializer, 7)), ("trajectory", _binary.NDArraySerializer(_binary.float32_serializer, 7)), ("density", _binary.OptionalSerializer(_binary.NDArraySerializer(_binary.float32_serializer, 6))), ("headers", _binary.NDArraySerializer(AcquisitionHeaderSerializer(), 5)), ("sampling", SamplingDescriptionSerializer())])

    def write(self, stream: _binary.CodedOutputStream, value: ReconBuffer) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.data, value.trajectory, value.density, value.headers, value.sampling)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['data'], value['trajectory'], value['density'], value['headers'], value['sampling'])

    def read(self, stream: _binary.CodedInputStream) -> ReconBuffer:
        field_values = self._read(stream)
        return ReconBuffer(data=field_values[0], trajectory=field_values[1], density=field_values[2], headers=field_values[3], sampling=field_values[4])


class ReconAssemblySerializer(_binary.RecordSerializer[ReconAssembly]):
    def __init__(self) -> None:
        super().__init__([("data", ReconBufferSerializer()), ("ref", _binary.OptionalSerializer(ReconBufferSerializer()))])

    def write(self, stream: _binary.CodedOutputStream, value: ReconAssembly) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.data, value.ref)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['data'], value['ref'])

    def read(self, stream: _binary.CodedInputStream) -> ReconAssembly:
        field_values = self._read(stream)
        return ReconAssembly(data=field_values[0], ref=field_values[1])


class ReconDataSerializer(_binary.RecordSerializer[ReconData]):
    def __init__(self) -> None:
        super().__init__([("buffers", _binary.VectorSerializer(ReconAssemblySerializer()))])

    def write(self, stream: _binary.CodedOutputStream, value: ReconData) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.buffers)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['buffers'])

    def read(self, stream: _binary.CodedInputStream) -> ReconData:
        field_values = self._read(stream)
        return ReconData(buffers=field_values[0])


class ImageArraySerializer(_binary.RecordSerializer[ImageArray]):
    def __init__(self) -> None:
        super().__init__([("data", _binary.NDArraySerializer(_binary.complexfloat32_serializer, 7)), ("headers", _binary.NDArraySerializer(ImageHeaderSerializer(), 3)), ("meta", _binary.NDArraySerializer(_binary.MapSerializer(_binary.string_serializer, _binary.VectorSerializer(_binary.UnionSerializer(ImageMetaValue, [(ImageMetaValue.String, _binary.string_serializer), (ImageMetaValue.Int64, _binary.int64_serializer), (ImageMetaValue.Float64, _binary.float64_serializer)]))), 3)), ("waveforms", _binary.VectorSerializer(WaveformSerializer(_binary.uint32_serializer)))])

    def write(self, stream: _binary.CodedOutputStream, value: ImageArray) -> None:
        if isinstance(value, np.void):
            self.write_numpy(stream, value)
            return
        self._write(stream, value.data, value.headers, value.meta, value.waveforms)

    def write_numpy(self, stream: _binary.CodedOutputStream, value: np.void) -> None:
        self._write(stream, value['data'], value['headers'], value['meta'], value['waveforms'])

    def read(self, stream: _binary.CodedInputStream) -> ImageArray:
        field_values = self._read(stream)
        return ImageArray(data=field_values[0], headers=field_values[1], meta=field_values[2], waveforms=field_values[3])


