# This file was generated by the "yardl" tool. DO NOT EDIT.

# pyright: reportUnusedClass=false
# pyright: reportUnusedImport=false
# pyright: reportUnknownArgumentType=false
# pyright: reportUnknownMemberType=false
# pyright: reportUnknownVariableType=false

import collections.abc
import io
import typing

import numpy as np
import numpy.typing as npt

from .types import *

from .protocols import *
from . import _ndjson
from . import yardl_types as yardl

acquisition_flags_name_to_value_map = {
    "firstInEncodeStep1": AcquisitionFlags.FIRST_IN_ENCODE_STEP_1,
    "lastInEncodeStep1": AcquisitionFlags.LAST_IN_ENCODE_STEP_1,
    "firstInEncodeStep2": AcquisitionFlags.FIRST_IN_ENCODE_STEP_2,
    "lastInEncodeStep2": AcquisitionFlags.LAST_IN_ENCODE_STEP_2,
    "firstInAverage": AcquisitionFlags.FIRST_IN_AVERAGE,
    "lastInAverage": AcquisitionFlags.LAST_IN_AVERAGE,
    "firstInSlice": AcquisitionFlags.FIRST_IN_SLICE,
    "lastInSlice": AcquisitionFlags.LAST_IN_SLICE,
    "firstInContrast": AcquisitionFlags.FIRST_IN_CONTRAST,
    "lastInContrast": AcquisitionFlags.LAST_IN_CONTRAST,
    "firstInPhase": AcquisitionFlags.FIRST_IN_PHASE,
    "lastInPhase": AcquisitionFlags.LAST_IN_PHASE,
    "firstInRepetition": AcquisitionFlags.FIRST_IN_REPETITION,
    "lastInRepetition": AcquisitionFlags.LAST_IN_REPETITION,
    "firstInSet": AcquisitionFlags.FIRST_IN_SET,
    "lastInSet": AcquisitionFlags.LAST_IN_SET,
    "firstInSegment": AcquisitionFlags.FIRST_IN_SEGMENT,
    "lastInSegment": AcquisitionFlags.LAST_IN_SEGMENT,
    "isNoiseMeasurement": AcquisitionFlags.IS_NOISE_MEASUREMENT,
    "isParallelCalibration": AcquisitionFlags.IS_PARALLEL_CALIBRATION,
    "isParallelCalibrationAndImaging": AcquisitionFlags.IS_PARALLEL_CALIBRATION_AND_IMAGING,
    "isReverse": AcquisitionFlags.IS_REVERSE,
    "isNavigationData": AcquisitionFlags.IS_NAVIGATION_DATA,
    "isPhasecorrData": AcquisitionFlags.IS_PHASECORR_DATA,
    "lastInMeasurement": AcquisitionFlags.LAST_IN_MEASUREMENT,
    "isHpfeedbackData": AcquisitionFlags.IS_HPFEEDBACK_DATA,
    "isDummyscanData": AcquisitionFlags.IS_DUMMYSCAN_DATA,
    "isRtfeedbackData": AcquisitionFlags.IS_RTFEEDBACK_DATA,
    "isSurfacecoilcorrectionscanData": AcquisitionFlags.IS_SURFACECOILCORRECTIONSCAN_DATA,
    "isPhaseStabilizationReference": AcquisitionFlags.IS_PHASE_STABILIZATION_REFERENCE,
    "isPhaseStabilization": AcquisitionFlags.IS_PHASE_STABILIZATION,
}
acquisition_flags_value_to_name_map = {v: n for n, v in acquisition_flags_name_to_value_map.items()}

class EncodingCountersConverter(_ndjson.JsonConverter[EncodingCounters, np.void]):
    def __init__(self) -> None:
        self._kspace_encode_step_1_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._kspace_encode_step_2_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._average_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._slice_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._contrast_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._phase_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._repetition_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._set_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._segment_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._user_converter = _ndjson.VectorConverter(_ndjson.uint32_converter)
        super().__init__(np.dtype([
            ("kspace_encode_step_1", self._kspace_encode_step_1_converter.overall_dtype()),
            ("kspace_encode_step_2", self._kspace_encode_step_2_converter.overall_dtype()),
            ("average", self._average_converter.overall_dtype()),
            ("slice", self._slice_converter.overall_dtype()),
            ("contrast", self._contrast_converter.overall_dtype()),
            ("phase", self._phase_converter.overall_dtype()),
            ("repetition", self._repetition_converter.overall_dtype()),
            ("set", self._set_converter.overall_dtype()),
            ("segment", self._segment_converter.overall_dtype()),
            ("user", self._user_converter.overall_dtype()),
        ]))

    def to_json(self, value: EncodingCounters) -> object:
        if not isinstance(value, EncodingCounters): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'EncodingCounters' instance")
        json_object = {}

        if value.kspace_encode_step_1 is not None:
            json_object["kspaceEncodeStep1"] = self._kspace_encode_step_1_converter.to_json(value.kspace_encode_step_1)
        if value.kspace_encode_step_2 is not None:
            json_object["kspaceEncodeStep2"] = self._kspace_encode_step_2_converter.to_json(value.kspace_encode_step_2)
        if value.average is not None:
            json_object["average"] = self._average_converter.to_json(value.average)
        if value.slice is not None:
            json_object["slice"] = self._slice_converter.to_json(value.slice)
        if value.contrast is not None:
            json_object["contrast"] = self._contrast_converter.to_json(value.contrast)
        if value.phase is not None:
            json_object["phase"] = self._phase_converter.to_json(value.phase)
        if value.repetition is not None:
            json_object["repetition"] = self._repetition_converter.to_json(value.repetition)
        if value.set is not None:
            json_object["set"] = self._set_converter.to_json(value.set)
        if value.segment is not None:
            json_object["segment"] = self._segment_converter.to_json(value.segment)
        json_object["user"] = self._user_converter.to_json(value.user)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        if (field_val := value["kspace_encode_step_1"]) is not None:
            json_object["kspaceEncodeStep1"] = self._kspace_encode_step_1_converter.numpy_to_json(field_val)
        if (field_val := value["kspace_encode_step_2"]) is not None:
            json_object["kspaceEncodeStep2"] = self._kspace_encode_step_2_converter.numpy_to_json(field_val)
        if (field_val := value["average"]) is not None:
            json_object["average"] = self._average_converter.numpy_to_json(field_val)
        if (field_val := value["slice"]) is not None:
            json_object["slice"] = self._slice_converter.numpy_to_json(field_val)
        if (field_val := value["contrast"]) is not None:
            json_object["contrast"] = self._contrast_converter.numpy_to_json(field_val)
        if (field_val := value["phase"]) is not None:
            json_object["phase"] = self._phase_converter.numpy_to_json(field_val)
        if (field_val := value["repetition"]) is not None:
            json_object["repetition"] = self._repetition_converter.numpy_to_json(field_val)
        if (field_val := value["set"]) is not None:
            json_object["set"] = self._set_converter.numpy_to_json(field_val)
        if (field_val := value["segment"]) is not None:
            json_object["segment"] = self._segment_converter.numpy_to_json(field_val)
        json_object["user"] = self._user_converter.numpy_to_json(value["user"])
        return json_object

    def from_json(self, json_object: object) -> EncodingCounters:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return EncodingCounters(
            kspace_encode_step_1=self._kspace_encode_step_1_converter.from_json(json_object.get("kspaceEncodeStep1")),
            kspace_encode_step_2=self._kspace_encode_step_2_converter.from_json(json_object.get("kspaceEncodeStep2")),
            average=self._average_converter.from_json(json_object.get("average")),
            slice=self._slice_converter.from_json(json_object.get("slice")),
            contrast=self._contrast_converter.from_json(json_object.get("contrast")),
            phase=self._phase_converter.from_json(json_object.get("phase")),
            repetition=self._repetition_converter.from_json(json_object.get("repetition")),
            set=self._set_converter.from_json(json_object.get("set")),
            segment=self._segment_converter.from_json(json_object.get("segment")),
            user=self._user_converter.from_json(json_object["user"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._kspace_encode_step_1_converter.from_json_to_numpy(json_object.get("kspaceEncodeStep1")),
            self._kspace_encode_step_2_converter.from_json_to_numpy(json_object.get("kspaceEncodeStep2")),
            self._average_converter.from_json_to_numpy(json_object.get("average")),
            self._slice_converter.from_json_to_numpy(json_object.get("slice")),
            self._contrast_converter.from_json_to_numpy(json_object.get("contrast")),
            self._phase_converter.from_json_to_numpy(json_object.get("phase")),
            self._repetition_converter.from_json_to_numpy(json_object.get("repetition")),
            self._set_converter.from_json_to_numpy(json_object.get("set")),
            self._segment_converter.from_json_to_numpy(json_object.get("segment")),
            self._user_converter.from_json_to_numpy(json_object["user"]),
        ) # type:ignore 


class AcquisitionHeaderConverter(_ndjson.JsonConverter[AcquisitionHeader, np.void]):
    def __init__(self) -> None:
        self._flags_converter = _ndjson.FlagsConverter(AcquisitionFlags, np.uint64, acquisition_flags_name_to_value_map, acquisition_flags_value_to_name_map)
        self._idx_converter = EncodingCountersConverter()
        self._measurement_uid_converter = _ndjson.uint32_converter
        self._scan_counter_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._acquisition_time_stamp_ns_converter = _ndjson.OptionalConverter(_ndjson.uint64_converter)
        self._physiology_time_stamp_ns_converter = _ndjson.VectorConverter(_ndjson.uint64_converter)
        self._channel_order_converter = _ndjson.VectorConverter(_ndjson.uint32_converter)
        self._discard_pre_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._discard_post_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._center_sample_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._encoding_space_ref_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._sample_time_ns_converter = _ndjson.OptionalConverter(_ndjson.uint64_converter)
        self._position_converter = _ndjson.FixedNDArrayConverter(_ndjson.float32_converter, (3,))
        self._read_dir_converter = _ndjson.FixedNDArrayConverter(_ndjson.float32_converter, (3,))
        self._phase_dir_converter = _ndjson.FixedNDArrayConverter(_ndjson.float32_converter, (3,))
        self._slice_dir_converter = _ndjson.FixedNDArrayConverter(_ndjson.float32_converter, (3,))
        self._patient_table_position_converter = _ndjson.FixedNDArrayConverter(_ndjson.float32_converter, (3,))
        self._user_int_converter = _ndjson.VectorConverter(_ndjson.int32_converter)
        self._user_float_converter = _ndjson.VectorConverter(_ndjson.float32_converter)
        super().__init__(np.dtype([
            ("flags", self._flags_converter.overall_dtype()),
            ("idx", self._idx_converter.overall_dtype()),
            ("measurement_uid", self._measurement_uid_converter.overall_dtype()),
            ("scan_counter", self._scan_counter_converter.overall_dtype()),
            ("acquisition_time_stamp_ns", self._acquisition_time_stamp_ns_converter.overall_dtype()),
            ("physiology_time_stamp_ns", self._physiology_time_stamp_ns_converter.overall_dtype()),
            ("channel_order", self._channel_order_converter.overall_dtype()),
            ("discard_pre", self._discard_pre_converter.overall_dtype()),
            ("discard_post", self._discard_post_converter.overall_dtype()),
            ("center_sample", self._center_sample_converter.overall_dtype()),
            ("encoding_space_ref", self._encoding_space_ref_converter.overall_dtype()),
            ("sample_time_ns", self._sample_time_ns_converter.overall_dtype()),
            ("position", self._position_converter.overall_dtype()),
            ("read_dir", self._read_dir_converter.overall_dtype()),
            ("phase_dir", self._phase_dir_converter.overall_dtype()),
            ("slice_dir", self._slice_dir_converter.overall_dtype()),
            ("patient_table_position", self._patient_table_position_converter.overall_dtype()),
            ("user_int", self._user_int_converter.overall_dtype()),
            ("user_float", self._user_float_converter.overall_dtype()),
        ]))

    def to_json(self, value: AcquisitionHeader) -> object:
        if not isinstance(value, AcquisitionHeader): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'AcquisitionHeader' instance")
        json_object = {}

        json_object["flags"] = self._flags_converter.to_json(value.flags)
        json_object["idx"] = self._idx_converter.to_json(value.idx)
        json_object["measurementUid"] = self._measurement_uid_converter.to_json(value.measurement_uid)
        if value.scan_counter is not None:
            json_object["scanCounter"] = self._scan_counter_converter.to_json(value.scan_counter)
        if value.acquisition_time_stamp_ns is not None:
            json_object["acquisitionTimeStampNs"] = self._acquisition_time_stamp_ns_converter.to_json(value.acquisition_time_stamp_ns)
        json_object["physiologyTimeStampNs"] = self._physiology_time_stamp_ns_converter.to_json(value.physiology_time_stamp_ns)
        json_object["channelOrder"] = self._channel_order_converter.to_json(value.channel_order)
        if value.discard_pre is not None:
            json_object["discardPre"] = self._discard_pre_converter.to_json(value.discard_pre)
        if value.discard_post is not None:
            json_object["discardPost"] = self._discard_post_converter.to_json(value.discard_post)
        if value.center_sample is not None:
            json_object["centerSample"] = self._center_sample_converter.to_json(value.center_sample)
        if value.encoding_space_ref is not None:
            json_object["encodingSpaceRef"] = self._encoding_space_ref_converter.to_json(value.encoding_space_ref)
        if value.sample_time_ns is not None:
            json_object["sampleTimeNs"] = self._sample_time_ns_converter.to_json(value.sample_time_ns)
        json_object["position"] = self._position_converter.to_json(value.position)
        json_object["readDir"] = self._read_dir_converter.to_json(value.read_dir)
        json_object["phaseDir"] = self._phase_dir_converter.to_json(value.phase_dir)
        json_object["sliceDir"] = self._slice_dir_converter.to_json(value.slice_dir)
        json_object["patientTablePosition"] = self._patient_table_position_converter.to_json(value.patient_table_position)
        json_object["userInt"] = self._user_int_converter.to_json(value.user_int)
        json_object["userFloat"] = self._user_float_converter.to_json(value.user_float)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["flags"] = self._flags_converter.numpy_to_json(value["flags"])
        json_object["idx"] = self._idx_converter.numpy_to_json(value["idx"])
        json_object["measurementUid"] = self._measurement_uid_converter.numpy_to_json(value["measurement_uid"])
        if (field_val := value["scan_counter"]) is not None:
            json_object["scanCounter"] = self._scan_counter_converter.numpy_to_json(field_val)
        if (field_val := value["acquisition_time_stamp_ns"]) is not None:
            json_object["acquisitionTimeStampNs"] = self._acquisition_time_stamp_ns_converter.numpy_to_json(field_val)
        json_object["physiologyTimeStampNs"] = self._physiology_time_stamp_ns_converter.numpy_to_json(value["physiology_time_stamp_ns"])
        json_object["channelOrder"] = self._channel_order_converter.numpy_to_json(value["channel_order"])
        if (field_val := value["discard_pre"]) is not None:
            json_object["discardPre"] = self._discard_pre_converter.numpy_to_json(field_val)
        if (field_val := value["discard_post"]) is not None:
            json_object["discardPost"] = self._discard_post_converter.numpy_to_json(field_val)
        if (field_val := value["center_sample"]) is not None:
            json_object["centerSample"] = self._center_sample_converter.numpy_to_json(field_val)
        if (field_val := value["encoding_space_ref"]) is not None:
            json_object["encodingSpaceRef"] = self._encoding_space_ref_converter.numpy_to_json(field_val)
        if (field_val := value["sample_time_ns"]) is not None:
            json_object["sampleTimeNs"] = self._sample_time_ns_converter.numpy_to_json(field_val)
        json_object["position"] = self._position_converter.numpy_to_json(value["position"])
        json_object["readDir"] = self._read_dir_converter.numpy_to_json(value["read_dir"])
        json_object["phaseDir"] = self._phase_dir_converter.numpy_to_json(value["phase_dir"])
        json_object["sliceDir"] = self._slice_dir_converter.numpy_to_json(value["slice_dir"])
        json_object["patientTablePosition"] = self._patient_table_position_converter.numpy_to_json(value["patient_table_position"])
        json_object["userInt"] = self._user_int_converter.numpy_to_json(value["user_int"])
        json_object["userFloat"] = self._user_float_converter.numpy_to_json(value["user_float"])
        return json_object

    def from_json(self, json_object: object) -> AcquisitionHeader:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return AcquisitionHeader(
            flags=self._flags_converter.from_json(json_object["flags"],),
            idx=self._idx_converter.from_json(json_object["idx"],),
            measurement_uid=self._measurement_uid_converter.from_json(json_object["measurementUid"],),
            scan_counter=self._scan_counter_converter.from_json(json_object.get("scanCounter")),
            acquisition_time_stamp_ns=self._acquisition_time_stamp_ns_converter.from_json(json_object.get("acquisitionTimeStampNs")),
            physiology_time_stamp_ns=self._physiology_time_stamp_ns_converter.from_json(json_object["physiologyTimeStampNs"],),
            channel_order=self._channel_order_converter.from_json(json_object["channelOrder"],),
            discard_pre=self._discard_pre_converter.from_json(json_object.get("discardPre")),
            discard_post=self._discard_post_converter.from_json(json_object.get("discardPost")),
            center_sample=self._center_sample_converter.from_json(json_object.get("centerSample")),
            encoding_space_ref=self._encoding_space_ref_converter.from_json(json_object.get("encodingSpaceRef")),
            sample_time_ns=self._sample_time_ns_converter.from_json(json_object.get("sampleTimeNs")),
            position=self._position_converter.from_json(json_object["position"],),
            read_dir=self._read_dir_converter.from_json(json_object["readDir"],),
            phase_dir=self._phase_dir_converter.from_json(json_object["phaseDir"],),
            slice_dir=self._slice_dir_converter.from_json(json_object["sliceDir"],),
            patient_table_position=self._patient_table_position_converter.from_json(json_object["patientTablePosition"],),
            user_int=self._user_int_converter.from_json(json_object["userInt"],),
            user_float=self._user_float_converter.from_json(json_object["userFloat"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._flags_converter.from_json_to_numpy(json_object["flags"]),
            self._idx_converter.from_json_to_numpy(json_object["idx"]),
            self._measurement_uid_converter.from_json_to_numpy(json_object["measurementUid"]),
            self._scan_counter_converter.from_json_to_numpy(json_object.get("scanCounter")),
            self._acquisition_time_stamp_ns_converter.from_json_to_numpy(json_object.get("acquisitionTimeStampNs")),
            self._physiology_time_stamp_ns_converter.from_json_to_numpy(json_object["physiologyTimeStampNs"]),
            self._channel_order_converter.from_json_to_numpy(json_object["channelOrder"]),
            self._discard_pre_converter.from_json_to_numpy(json_object.get("discardPre")),
            self._discard_post_converter.from_json_to_numpy(json_object.get("discardPost")),
            self._center_sample_converter.from_json_to_numpy(json_object.get("centerSample")),
            self._encoding_space_ref_converter.from_json_to_numpy(json_object.get("encodingSpaceRef")),
            self._sample_time_ns_converter.from_json_to_numpy(json_object.get("sampleTimeNs")),
            self._position_converter.from_json_to_numpy(json_object["position"]),
            self._read_dir_converter.from_json_to_numpy(json_object["readDir"]),
            self._phase_dir_converter.from_json_to_numpy(json_object["phaseDir"]),
            self._slice_dir_converter.from_json_to_numpy(json_object["sliceDir"]),
            self._patient_table_position_converter.from_json_to_numpy(json_object["patientTablePosition"]),
            self._user_int_converter.from_json_to_numpy(json_object["userInt"]),
            self._user_float_converter.from_json_to_numpy(json_object["userFloat"]),
        ) # type:ignore 


class AcquisitionConverter(_ndjson.JsonConverter[Acquisition, np.void]):
    def __init__(self) -> None:
        self._head_converter = AcquisitionHeaderConverter()
        self._data_converter = _ndjson.NDArrayConverter(_ndjson.complexfloat32_converter, 2)
        self._trajectory_converter = _ndjson.NDArrayConverter(_ndjson.float32_converter, 2)
        super().__init__(np.dtype([
            ("head", self._head_converter.overall_dtype()),
            ("data", self._data_converter.overall_dtype()),
            ("trajectory", self._trajectory_converter.overall_dtype()),
        ]))

    def to_json(self, value: Acquisition) -> object:
        if not isinstance(value, Acquisition): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'Acquisition' instance")
        json_object = {}

        json_object["head"] = self._head_converter.to_json(value.head)
        json_object["data"] = self._data_converter.to_json(value.data)
        json_object["trajectory"] = self._trajectory_converter.to_json(value.trajectory)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["head"] = self._head_converter.numpy_to_json(value["head"])
        json_object["data"] = self._data_converter.numpy_to_json(value["data"])
        json_object["trajectory"] = self._trajectory_converter.numpy_to_json(value["trajectory"])
        return json_object

    def from_json(self, json_object: object) -> Acquisition:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return Acquisition(
            head=self._head_converter.from_json(json_object["head"],),
            data=self._data_converter.from_json(json_object["data"],),
            trajectory=self._trajectory_converter.from_json(json_object["trajectory"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._head_converter.from_json_to_numpy(json_object["head"]),
            self._data_converter.from_json_to_numpy(json_object["data"]),
            self._trajectory_converter.from_json_to_numpy(json_object["trajectory"]),
        ) # type:ignore 


patient_gender_name_to_value_map = {
    "m": PatientGender.M,
    "f": PatientGender.F,
    "o": PatientGender.O,
}
patient_gender_value_to_name_map = {v: n for n, v in patient_gender_name_to_value_map.items()}

class SubjectInformationTypeConverter(_ndjson.JsonConverter[SubjectInformationType, np.void]):
    def __init__(self) -> None:
        self._patient_name_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._patient_weight_kg_converter = _ndjson.OptionalConverter(_ndjson.float32_converter)
        self._patient_height_m_converter = _ndjson.OptionalConverter(_ndjson.float32_converter)
        self._patient_id_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._patient_birthdate_converter = _ndjson.OptionalConverter(_ndjson.date_converter)
        self._patient_gender_converter = _ndjson.OptionalConverter(_ndjson.EnumConverter(PatientGender, np.int32, patient_gender_name_to_value_map, patient_gender_value_to_name_map))
        super().__init__(np.dtype([
            ("patient_name", self._patient_name_converter.overall_dtype()),
            ("patient_weight_kg", self._patient_weight_kg_converter.overall_dtype()),
            ("patient_height_m", self._patient_height_m_converter.overall_dtype()),
            ("patient_id", self._patient_id_converter.overall_dtype()),
            ("patient_birthdate", self._patient_birthdate_converter.overall_dtype()),
            ("patient_gender", self._patient_gender_converter.overall_dtype()),
        ]))

    def to_json(self, value: SubjectInformationType) -> object:
        if not isinstance(value, SubjectInformationType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'SubjectInformationType' instance")
        json_object = {}

        if value.patient_name is not None:
            json_object["patientName"] = self._patient_name_converter.to_json(value.patient_name)
        if value.patient_weight_kg is not None:
            json_object["patientWeightKg"] = self._patient_weight_kg_converter.to_json(value.patient_weight_kg)
        if value.patient_height_m is not None:
            json_object["patientHeightM"] = self._patient_height_m_converter.to_json(value.patient_height_m)
        if value.patient_id is not None:
            json_object["patientID"] = self._patient_id_converter.to_json(value.patient_id)
        if value.patient_birthdate is not None:
            json_object["patientBirthdate"] = self._patient_birthdate_converter.to_json(value.patient_birthdate)
        if value.patient_gender is not None:
            json_object["patientGender"] = self._patient_gender_converter.to_json(value.patient_gender)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        if (field_val := value["patient_name"]) is not None:
            json_object["patientName"] = self._patient_name_converter.numpy_to_json(field_val)
        if (field_val := value["patient_weight_kg"]) is not None:
            json_object["patientWeightKg"] = self._patient_weight_kg_converter.numpy_to_json(field_val)
        if (field_val := value["patient_height_m"]) is not None:
            json_object["patientHeightM"] = self._patient_height_m_converter.numpy_to_json(field_val)
        if (field_val := value["patient_id"]) is not None:
            json_object["patientID"] = self._patient_id_converter.numpy_to_json(field_val)
        if (field_val := value["patient_birthdate"]) is not None:
            json_object["patientBirthdate"] = self._patient_birthdate_converter.numpy_to_json(field_val)
        if (field_val := value["patient_gender"]) is not None:
            json_object["patientGender"] = self._patient_gender_converter.numpy_to_json(field_val)
        return json_object

    def from_json(self, json_object: object) -> SubjectInformationType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return SubjectInformationType(
            patient_name=self._patient_name_converter.from_json(json_object.get("patientName")),
            patient_weight_kg=self._patient_weight_kg_converter.from_json(json_object.get("patientWeightKg")),
            patient_height_m=self._patient_height_m_converter.from_json(json_object.get("patientHeightM")),
            patient_id=self._patient_id_converter.from_json(json_object.get("patientID")),
            patient_birthdate=self._patient_birthdate_converter.from_json(json_object.get("patientBirthdate")),
            patient_gender=self._patient_gender_converter.from_json(json_object.get("patientGender")),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._patient_name_converter.from_json_to_numpy(json_object.get("patientName")),
            self._patient_weight_kg_converter.from_json_to_numpy(json_object.get("patientWeightKg")),
            self._patient_height_m_converter.from_json_to_numpy(json_object.get("patientHeightM")),
            self._patient_id_converter.from_json_to_numpy(json_object.get("patientID")),
            self._patient_birthdate_converter.from_json_to_numpy(json_object.get("patientBirthdate")),
            self._patient_gender_converter.from_json_to_numpy(json_object.get("patientGender")),
        ) # type:ignore 


class StudyInformationTypeConverter(_ndjson.JsonConverter[StudyInformationType, np.void]):
    def __init__(self) -> None:
        self._study_date_converter = _ndjson.OptionalConverter(_ndjson.date_converter)
        self._study_time_converter = _ndjson.OptionalConverter(_ndjson.time_converter)
        self._study_id_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._accession_number_converter = _ndjson.OptionalConverter(_ndjson.int64_converter)
        self._referring_physician_name_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._study_description_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._study_instance_uid_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._body_part_examined_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        super().__init__(np.dtype([
            ("study_date", self._study_date_converter.overall_dtype()),
            ("study_time", self._study_time_converter.overall_dtype()),
            ("study_id", self._study_id_converter.overall_dtype()),
            ("accession_number", self._accession_number_converter.overall_dtype()),
            ("referring_physician_name", self._referring_physician_name_converter.overall_dtype()),
            ("study_description", self._study_description_converter.overall_dtype()),
            ("study_instance_uid", self._study_instance_uid_converter.overall_dtype()),
            ("body_part_examined", self._body_part_examined_converter.overall_dtype()),
        ]))

    def to_json(self, value: StudyInformationType) -> object:
        if not isinstance(value, StudyInformationType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'StudyInformationType' instance")
        json_object = {}

        if value.study_date is not None:
            json_object["studyDate"] = self._study_date_converter.to_json(value.study_date)
        if value.study_time is not None:
            json_object["studyTime"] = self._study_time_converter.to_json(value.study_time)
        if value.study_id is not None:
            json_object["studyID"] = self._study_id_converter.to_json(value.study_id)
        if value.accession_number is not None:
            json_object["accessionNumber"] = self._accession_number_converter.to_json(value.accession_number)
        if value.referring_physician_name is not None:
            json_object["referringPhysicianName"] = self._referring_physician_name_converter.to_json(value.referring_physician_name)
        if value.study_description is not None:
            json_object["studyDescription"] = self._study_description_converter.to_json(value.study_description)
        if value.study_instance_uid is not None:
            json_object["studyInstanceUID"] = self._study_instance_uid_converter.to_json(value.study_instance_uid)
        if value.body_part_examined is not None:
            json_object["bodyPartExamined"] = self._body_part_examined_converter.to_json(value.body_part_examined)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        if (field_val := value["study_date"]) is not None:
            json_object["studyDate"] = self._study_date_converter.numpy_to_json(field_val)
        if (field_val := value["study_time"]) is not None:
            json_object["studyTime"] = self._study_time_converter.numpy_to_json(field_val)
        if (field_val := value["study_id"]) is not None:
            json_object["studyID"] = self._study_id_converter.numpy_to_json(field_val)
        if (field_val := value["accession_number"]) is not None:
            json_object["accessionNumber"] = self._accession_number_converter.numpy_to_json(field_val)
        if (field_val := value["referring_physician_name"]) is not None:
            json_object["referringPhysicianName"] = self._referring_physician_name_converter.numpy_to_json(field_val)
        if (field_val := value["study_description"]) is not None:
            json_object["studyDescription"] = self._study_description_converter.numpy_to_json(field_val)
        if (field_val := value["study_instance_uid"]) is not None:
            json_object["studyInstanceUID"] = self._study_instance_uid_converter.numpy_to_json(field_val)
        if (field_val := value["body_part_examined"]) is not None:
            json_object["bodyPartExamined"] = self._body_part_examined_converter.numpy_to_json(field_val)
        return json_object

    def from_json(self, json_object: object) -> StudyInformationType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return StudyInformationType(
            study_date=self._study_date_converter.from_json(json_object.get("studyDate")),
            study_time=self._study_time_converter.from_json(json_object.get("studyTime")),
            study_id=self._study_id_converter.from_json(json_object.get("studyID")),
            accession_number=self._accession_number_converter.from_json(json_object.get("accessionNumber")),
            referring_physician_name=self._referring_physician_name_converter.from_json(json_object.get("referringPhysicianName")),
            study_description=self._study_description_converter.from_json(json_object.get("studyDescription")),
            study_instance_uid=self._study_instance_uid_converter.from_json(json_object.get("studyInstanceUID")),
            body_part_examined=self._body_part_examined_converter.from_json(json_object.get("bodyPartExamined")),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._study_date_converter.from_json_to_numpy(json_object.get("studyDate")),
            self._study_time_converter.from_json_to_numpy(json_object.get("studyTime")),
            self._study_id_converter.from_json_to_numpy(json_object.get("studyID")),
            self._accession_number_converter.from_json_to_numpy(json_object.get("accessionNumber")),
            self._referring_physician_name_converter.from_json_to_numpy(json_object.get("referringPhysicianName")),
            self._study_description_converter.from_json_to_numpy(json_object.get("studyDescription")),
            self._study_instance_uid_converter.from_json_to_numpy(json_object.get("studyInstanceUID")),
            self._body_part_examined_converter.from_json_to_numpy(json_object.get("bodyPartExamined")),
        ) # type:ignore 


patient_position_name_to_value_map = {
    "hFP": PatientPosition.H_FP,
    "hFS": PatientPosition.H_FS,
    "hFDR": PatientPosition.H_FDR,
    "hFDL": PatientPosition.H_FDL,
    "fFP": PatientPosition.F_FP,
    "fFS": PatientPosition.F_FS,
    "fFDR": PatientPosition.F_FDR,
    "fFDL": PatientPosition.F_FDL,
}
patient_position_value_to_name_map = {v: n for n, v in patient_position_name_to_value_map.items()}

class ThreeDimensionalFloatConverter(_ndjson.JsonConverter[ThreeDimensionalFloat, np.void]):
    def __init__(self) -> None:
        self._x_converter = _ndjson.float32_converter
        self._y_converter = _ndjson.float32_converter
        self._z_converter = _ndjson.float32_converter
        super().__init__(np.dtype([
            ("x", self._x_converter.overall_dtype()),
            ("y", self._y_converter.overall_dtype()),
            ("z", self._z_converter.overall_dtype()),
        ]))

    def to_json(self, value: ThreeDimensionalFloat) -> object:
        if not isinstance(value, ThreeDimensionalFloat): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'ThreeDimensionalFloat' instance")
        json_object = {}

        json_object["x"] = self._x_converter.to_json(value.x)
        json_object["y"] = self._y_converter.to_json(value.y)
        json_object["z"] = self._z_converter.to_json(value.z)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["x"] = self._x_converter.numpy_to_json(value["x"])
        json_object["y"] = self._y_converter.numpy_to_json(value["y"])
        json_object["z"] = self._z_converter.numpy_to_json(value["z"])
        return json_object

    def from_json(self, json_object: object) -> ThreeDimensionalFloat:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return ThreeDimensionalFloat(
            x=self._x_converter.from_json(json_object["x"],),
            y=self._y_converter.from_json(json_object["y"],),
            z=self._z_converter.from_json(json_object["z"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._x_converter.from_json_to_numpy(json_object["x"]),
            self._y_converter.from_json_to_numpy(json_object["y"]),
            self._z_converter.from_json_to_numpy(json_object["z"]),
        ) # type:ignore 


class MeasurementDependencyTypeConverter(_ndjson.JsonConverter[MeasurementDependencyType, np.void]):
    def __init__(self) -> None:
        self._dependency_type_converter = _ndjson.string_converter
        self._measurement_id_converter = _ndjson.string_converter
        super().__init__(np.dtype([
            ("dependency_type", self._dependency_type_converter.overall_dtype()),
            ("measurement_id", self._measurement_id_converter.overall_dtype()),
        ]))

    def to_json(self, value: MeasurementDependencyType) -> object:
        if not isinstance(value, MeasurementDependencyType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'MeasurementDependencyType' instance")
        json_object = {}

        json_object["dependencyType"] = self._dependency_type_converter.to_json(value.dependency_type)
        json_object["measurementID"] = self._measurement_id_converter.to_json(value.measurement_id)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["dependencyType"] = self._dependency_type_converter.numpy_to_json(value["dependency_type"])
        json_object["measurementID"] = self._measurement_id_converter.numpy_to_json(value["measurement_id"])
        return json_object

    def from_json(self, json_object: object) -> MeasurementDependencyType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return MeasurementDependencyType(
            dependency_type=self._dependency_type_converter.from_json(json_object["dependencyType"],),
            measurement_id=self._measurement_id_converter.from_json(json_object["measurementID"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._dependency_type_converter.from_json_to_numpy(json_object["dependencyType"]),
            self._measurement_id_converter.from_json_to_numpy(json_object["measurementID"]),
        ) # type:ignore 


class ReferencedImageSequenceTypeConverter(_ndjson.JsonConverter[ReferencedImageSequenceType, np.void]):
    def __init__(self) -> None:
        self._referenced_sop_instance_uid_converter = _ndjson.VectorConverter(_ndjson.string_converter)
        super().__init__(np.dtype([
            ("referenced_sop_instance_uid", self._referenced_sop_instance_uid_converter.overall_dtype()),
        ]))

    def to_json(self, value: ReferencedImageSequenceType) -> object:
        if not isinstance(value, ReferencedImageSequenceType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'ReferencedImageSequenceType' instance")
        json_object = {}

        json_object["referencedSOPInstanceUID"] = self._referenced_sop_instance_uid_converter.to_json(value.referenced_sop_instance_uid)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["referencedSOPInstanceUID"] = self._referenced_sop_instance_uid_converter.numpy_to_json(value["referenced_sop_instance_uid"])
        return json_object

    def from_json(self, json_object: object) -> ReferencedImageSequenceType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return ReferencedImageSequenceType(
            referenced_sop_instance_uid=self._referenced_sop_instance_uid_converter.from_json(json_object["referencedSOPInstanceUID"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._referenced_sop_instance_uid_converter.from_json_to_numpy(json_object["referencedSOPInstanceUID"]),
        ) # type:ignore 


class MeasurementInformationTypeConverter(_ndjson.JsonConverter[MeasurementInformationType, np.void]):
    def __init__(self) -> None:
        self._measurement_id_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._series_date_converter = _ndjson.OptionalConverter(_ndjson.date_converter)
        self._series_time_converter = _ndjson.OptionalConverter(_ndjson.time_converter)
        self._patient_position_converter = _ndjson.EnumConverter(PatientPosition, np.int32, patient_position_name_to_value_map, patient_position_value_to_name_map)
        self._relative_table_position_converter = _ndjson.OptionalConverter(ThreeDimensionalFloatConverter())
        self._initial_series_number_converter = _ndjson.OptionalConverter(_ndjson.int64_converter)
        self._protocol_name_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._sequence_name_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._series_description_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._measurement_dependency_converter = _ndjson.VectorConverter(MeasurementDependencyTypeConverter())
        self._series_instance_uid_root_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._frame_of_reference_uid_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._referenced_image_sequence_converter = _ndjson.OptionalConverter(ReferencedImageSequenceTypeConverter())
        super().__init__(np.dtype([
            ("measurement_id", self._measurement_id_converter.overall_dtype()),
            ("series_date", self._series_date_converter.overall_dtype()),
            ("series_time", self._series_time_converter.overall_dtype()),
            ("patient_position", self._patient_position_converter.overall_dtype()),
            ("relative_table_position", self._relative_table_position_converter.overall_dtype()),
            ("initial_series_number", self._initial_series_number_converter.overall_dtype()),
            ("protocol_name", self._protocol_name_converter.overall_dtype()),
            ("sequence_name", self._sequence_name_converter.overall_dtype()),
            ("series_description", self._series_description_converter.overall_dtype()),
            ("measurement_dependency", self._measurement_dependency_converter.overall_dtype()),
            ("series_instance_uid_root", self._series_instance_uid_root_converter.overall_dtype()),
            ("frame_of_reference_uid", self._frame_of_reference_uid_converter.overall_dtype()),
            ("referenced_image_sequence", self._referenced_image_sequence_converter.overall_dtype()),
        ]))

    def to_json(self, value: MeasurementInformationType) -> object:
        if not isinstance(value, MeasurementInformationType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'MeasurementInformationType' instance")
        json_object = {}

        if value.measurement_id is not None:
            json_object["measurementID"] = self._measurement_id_converter.to_json(value.measurement_id)
        if value.series_date is not None:
            json_object["seriesDate"] = self._series_date_converter.to_json(value.series_date)
        if value.series_time is not None:
            json_object["seriesTime"] = self._series_time_converter.to_json(value.series_time)
        json_object["patientPosition"] = self._patient_position_converter.to_json(value.patient_position)
        if value.relative_table_position is not None:
            json_object["relativeTablePosition"] = self._relative_table_position_converter.to_json(value.relative_table_position)
        if value.initial_series_number is not None:
            json_object["initialSeriesNumber"] = self._initial_series_number_converter.to_json(value.initial_series_number)
        if value.protocol_name is not None:
            json_object["protocolName"] = self._protocol_name_converter.to_json(value.protocol_name)
        if value.sequence_name is not None:
            json_object["sequenceName"] = self._sequence_name_converter.to_json(value.sequence_name)
        if value.series_description is not None:
            json_object["seriesDescription"] = self._series_description_converter.to_json(value.series_description)
        json_object["measurementDependency"] = self._measurement_dependency_converter.to_json(value.measurement_dependency)
        if value.series_instance_uid_root is not None:
            json_object["seriesInstanceUIDRoot"] = self._series_instance_uid_root_converter.to_json(value.series_instance_uid_root)
        if value.frame_of_reference_uid is not None:
            json_object["frameOfReferenceUID"] = self._frame_of_reference_uid_converter.to_json(value.frame_of_reference_uid)
        if value.referenced_image_sequence is not None:
            json_object["referencedImageSequence"] = self._referenced_image_sequence_converter.to_json(value.referenced_image_sequence)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        if (field_val := value["measurement_id"]) is not None:
            json_object["measurementID"] = self._measurement_id_converter.numpy_to_json(field_val)
        if (field_val := value["series_date"]) is not None:
            json_object["seriesDate"] = self._series_date_converter.numpy_to_json(field_val)
        if (field_val := value["series_time"]) is not None:
            json_object["seriesTime"] = self._series_time_converter.numpy_to_json(field_val)
        json_object["patientPosition"] = self._patient_position_converter.numpy_to_json(value["patient_position"])
        if (field_val := value["relative_table_position"]) is not None:
            json_object["relativeTablePosition"] = self._relative_table_position_converter.numpy_to_json(field_val)
        if (field_val := value["initial_series_number"]) is not None:
            json_object["initialSeriesNumber"] = self._initial_series_number_converter.numpy_to_json(field_val)
        if (field_val := value["protocol_name"]) is not None:
            json_object["protocolName"] = self._protocol_name_converter.numpy_to_json(field_val)
        if (field_val := value["sequence_name"]) is not None:
            json_object["sequenceName"] = self._sequence_name_converter.numpy_to_json(field_val)
        if (field_val := value["series_description"]) is not None:
            json_object["seriesDescription"] = self._series_description_converter.numpy_to_json(field_val)
        json_object["measurementDependency"] = self._measurement_dependency_converter.numpy_to_json(value["measurement_dependency"])
        if (field_val := value["series_instance_uid_root"]) is not None:
            json_object["seriesInstanceUIDRoot"] = self._series_instance_uid_root_converter.numpy_to_json(field_val)
        if (field_val := value["frame_of_reference_uid"]) is not None:
            json_object["frameOfReferenceUID"] = self._frame_of_reference_uid_converter.numpy_to_json(field_val)
        if (field_val := value["referenced_image_sequence"]) is not None:
            json_object["referencedImageSequence"] = self._referenced_image_sequence_converter.numpy_to_json(field_val)
        return json_object

    def from_json(self, json_object: object) -> MeasurementInformationType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return MeasurementInformationType(
            measurement_id=self._measurement_id_converter.from_json(json_object.get("measurementID")),
            series_date=self._series_date_converter.from_json(json_object.get("seriesDate")),
            series_time=self._series_time_converter.from_json(json_object.get("seriesTime")),
            patient_position=self._patient_position_converter.from_json(json_object["patientPosition"],),
            relative_table_position=self._relative_table_position_converter.from_json(json_object.get("relativeTablePosition")),
            initial_series_number=self._initial_series_number_converter.from_json(json_object.get("initialSeriesNumber")),
            protocol_name=self._protocol_name_converter.from_json(json_object.get("protocolName")),
            sequence_name=self._sequence_name_converter.from_json(json_object.get("sequenceName")),
            series_description=self._series_description_converter.from_json(json_object.get("seriesDescription")),
            measurement_dependency=self._measurement_dependency_converter.from_json(json_object["measurementDependency"],),
            series_instance_uid_root=self._series_instance_uid_root_converter.from_json(json_object.get("seriesInstanceUIDRoot")),
            frame_of_reference_uid=self._frame_of_reference_uid_converter.from_json(json_object.get("frameOfReferenceUID")),
            referenced_image_sequence=self._referenced_image_sequence_converter.from_json(json_object.get("referencedImageSequence")),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._measurement_id_converter.from_json_to_numpy(json_object.get("measurementID")),
            self._series_date_converter.from_json_to_numpy(json_object.get("seriesDate")),
            self._series_time_converter.from_json_to_numpy(json_object.get("seriesTime")),
            self._patient_position_converter.from_json_to_numpy(json_object["patientPosition"]),
            self._relative_table_position_converter.from_json_to_numpy(json_object.get("relativeTablePosition")),
            self._initial_series_number_converter.from_json_to_numpy(json_object.get("initialSeriesNumber")),
            self._protocol_name_converter.from_json_to_numpy(json_object.get("protocolName")),
            self._sequence_name_converter.from_json_to_numpy(json_object.get("sequenceName")),
            self._series_description_converter.from_json_to_numpy(json_object.get("seriesDescription")),
            self._measurement_dependency_converter.from_json_to_numpy(json_object["measurementDependency"]),
            self._series_instance_uid_root_converter.from_json_to_numpy(json_object.get("seriesInstanceUIDRoot")),
            self._frame_of_reference_uid_converter.from_json_to_numpy(json_object.get("frameOfReferenceUID")),
            self._referenced_image_sequence_converter.from_json_to_numpy(json_object.get("referencedImageSequence")),
        ) # type:ignore 


class CoilLabelTypeConverter(_ndjson.JsonConverter[CoilLabelType, np.void]):
    def __init__(self) -> None:
        self._coil_number_converter = _ndjson.uint32_converter
        self._coil_name_converter = _ndjson.string_converter
        super().__init__(np.dtype([
            ("coil_number", self._coil_number_converter.overall_dtype()),
            ("coil_name", self._coil_name_converter.overall_dtype()),
        ]))

    def to_json(self, value: CoilLabelType) -> object:
        if not isinstance(value, CoilLabelType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'CoilLabelType' instance")
        json_object = {}

        json_object["coilNumber"] = self._coil_number_converter.to_json(value.coil_number)
        json_object["coilName"] = self._coil_name_converter.to_json(value.coil_name)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["coilNumber"] = self._coil_number_converter.numpy_to_json(value["coil_number"])
        json_object["coilName"] = self._coil_name_converter.numpy_to_json(value["coil_name"])
        return json_object

    def from_json(self, json_object: object) -> CoilLabelType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return CoilLabelType(
            coil_number=self._coil_number_converter.from_json(json_object["coilNumber"],),
            coil_name=self._coil_name_converter.from_json(json_object["coilName"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._coil_number_converter.from_json_to_numpy(json_object["coilNumber"]),
            self._coil_name_converter.from_json_to_numpy(json_object["coilName"]),
        ) # type:ignore 


class AcquisitionSystemInformationTypeConverter(_ndjson.JsonConverter[AcquisitionSystemInformationType, np.void]):
    def __init__(self) -> None:
        self._system_vendor_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._system_model_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._system_field_strength_t_converter = _ndjson.OptionalConverter(_ndjson.float32_converter)
        self._relative_receiver_noise_bandwidth_converter = _ndjson.OptionalConverter(_ndjson.float32_converter)
        self._receiver_channels_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._coil_label_converter = _ndjson.VectorConverter(CoilLabelTypeConverter())
        self._institution_name_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._station_name_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._device_id_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._device_serial_number_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        super().__init__(np.dtype([
            ("system_vendor", self._system_vendor_converter.overall_dtype()),
            ("system_model", self._system_model_converter.overall_dtype()),
            ("system_field_strength_t", self._system_field_strength_t_converter.overall_dtype()),
            ("relative_receiver_noise_bandwidth", self._relative_receiver_noise_bandwidth_converter.overall_dtype()),
            ("receiver_channels", self._receiver_channels_converter.overall_dtype()),
            ("coil_label", self._coil_label_converter.overall_dtype()),
            ("institution_name", self._institution_name_converter.overall_dtype()),
            ("station_name", self._station_name_converter.overall_dtype()),
            ("device_id", self._device_id_converter.overall_dtype()),
            ("device_serial_number", self._device_serial_number_converter.overall_dtype()),
        ]))

    def to_json(self, value: AcquisitionSystemInformationType) -> object:
        if not isinstance(value, AcquisitionSystemInformationType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'AcquisitionSystemInformationType' instance")
        json_object = {}

        if value.system_vendor is not None:
            json_object["systemVendor"] = self._system_vendor_converter.to_json(value.system_vendor)
        if value.system_model is not None:
            json_object["systemModel"] = self._system_model_converter.to_json(value.system_model)
        if value.system_field_strength_t is not None:
            json_object["systemFieldStrengthT"] = self._system_field_strength_t_converter.to_json(value.system_field_strength_t)
        if value.relative_receiver_noise_bandwidth is not None:
            json_object["relativeReceiverNoiseBandwidth"] = self._relative_receiver_noise_bandwidth_converter.to_json(value.relative_receiver_noise_bandwidth)
        if value.receiver_channels is not None:
            json_object["receiverChannels"] = self._receiver_channels_converter.to_json(value.receiver_channels)
        json_object["coilLabel"] = self._coil_label_converter.to_json(value.coil_label)
        if value.institution_name is not None:
            json_object["institutionName"] = self._institution_name_converter.to_json(value.institution_name)
        if value.station_name is not None:
            json_object["stationName"] = self._station_name_converter.to_json(value.station_name)
        if value.device_id is not None:
            json_object["deviceID"] = self._device_id_converter.to_json(value.device_id)
        if value.device_serial_number is not None:
            json_object["deviceSerialNumber"] = self._device_serial_number_converter.to_json(value.device_serial_number)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        if (field_val := value["system_vendor"]) is not None:
            json_object["systemVendor"] = self._system_vendor_converter.numpy_to_json(field_val)
        if (field_val := value["system_model"]) is not None:
            json_object["systemModel"] = self._system_model_converter.numpy_to_json(field_val)
        if (field_val := value["system_field_strength_t"]) is not None:
            json_object["systemFieldStrengthT"] = self._system_field_strength_t_converter.numpy_to_json(field_val)
        if (field_val := value["relative_receiver_noise_bandwidth"]) is not None:
            json_object["relativeReceiverNoiseBandwidth"] = self._relative_receiver_noise_bandwidth_converter.numpy_to_json(field_val)
        if (field_val := value["receiver_channels"]) is not None:
            json_object["receiverChannels"] = self._receiver_channels_converter.numpy_to_json(field_val)
        json_object["coilLabel"] = self._coil_label_converter.numpy_to_json(value["coil_label"])
        if (field_val := value["institution_name"]) is not None:
            json_object["institutionName"] = self._institution_name_converter.numpy_to_json(field_val)
        if (field_val := value["station_name"]) is not None:
            json_object["stationName"] = self._station_name_converter.numpy_to_json(field_val)
        if (field_val := value["device_id"]) is not None:
            json_object["deviceID"] = self._device_id_converter.numpy_to_json(field_val)
        if (field_val := value["device_serial_number"]) is not None:
            json_object["deviceSerialNumber"] = self._device_serial_number_converter.numpy_to_json(field_val)
        return json_object

    def from_json(self, json_object: object) -> AcquisitionSystemInformationType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return AcquisitionSystemInformationType(
            system_vendor=self._system_vendor_converter.from_json(json_object.get("systemVendor")),
            system_model=self._system_model_converter.from_json(json_object.get("systemModel")),
            system_field_strength_t=self._system_field_strength_t_converter.from_json(json_object.get("systemFieldStrengthT")),
            relative_receiver_noise_bandwidth=self._relative_receiver_noise_bandwidth_converter.from_json(json_object.get("relativeReceiverNoiseBandwidth")),
            receiver_channels=self._receiver_channels_converter.from_json(json_object.get("receiverChannels")),
            coil_label=self._coil_label_converter.from_json(json_object["coilLabel"],),
            institution_name=self._institution_name_converter.from_json(json_object.get("institutionName")),
            station_name=self._station_name_converter.from_json(json_object.get("stationName")),
            device_id=self._device_id_converter.from_json(json_object.get("deviceID")),
            device_serial_number=self._device_serial_number_converter.from_json(json_object.get("deviceSerialNumber")),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._system_vendor_converter.from_json_to_numpy(json_object.get("systemVendor")),
            self._system_model_converter.from_json_to_numpy(json_object.get("systemModel")),
            self._system_field_strength_t_converter.from_json_to_numpy(json_object.get("systemFieldStrengthT")),
            self._relative_receiver_noise_bandwidth_converter.from_json_to_numpy(json_object.get("relativeReceiverNoiseBandwidth")),
            self._receiver_channels_converter.from_json_to_numpy(json_object.get("receiverChannels")),
            self._coil_label_converter.from_json_to_numpy(json_object["coilLabel"]),
            self._institution_name_converter.from_json_to_numpy(json_object.get("institutionName")),
            self._station_name_converter.from_json_to_numpy(json_object.get("stationName")),
            self._device_id_converter.from_json_to_numpy(json_object.get("deviceID")),
            self._device_serial_number_converter.from_json_to_numpy(json_object.get("deviceSerialNumber")),
        ) # type:ignore 


class ExperimentalConditionsTypeConverter(_ndjson.JsonConverter[ExperimentalConditionsType, np.void]):
    def __init__(self) -> None:
        self._h1resonance_frequency_hz_converter = _ndjson.int64_converter
        super().__init__(np.dtype([
            ("h1resonance_frequency_hz", self._h1resonance_frequency_hz_converter.overall_dtype()),
        ]))

    def to_json(self, value: ExperimentalConditionsType) -> object:
        if not isinstance(value, ExperimentalConditionsType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'ExperimentalConditionsType' instance")
        json_object = {}

        json_object["h1resonanceFrequencyHz"] = self._h1resonance_frequency_hz_converter.to_json(value.h1resonance_frequency_hz)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["h1resonanceFrequencyHz"] = self._h1resonance_frequency_hz_converter.numpy_to_json(value["h1resonance_frequency_hz"])
        return json_object

    def from_json(self, json_object: object) -> ExperimentalConditionsType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return ExperimentalConditionsType(
            h1resonance_frequency_hz=self._h1resonance_frequency_hz_converter.from_json(json_object["h1resonanceFrequencyHz"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._h1resonance_frequency_hz_converter.from_json_to_numpy(json_object["h1resonanceFrequencyHz"]),
        ) # type:ignore 


class MatrixSizeTypeConverter(_ndjson.JsonConverter[MatrixSizeType, np.void]):
    def __init__(self) -> None:
        self._x_converter = _ndjson.uint32_converter
        self._y_converter = _ndjson.uint32_converter
        self._z_converter = _ndjson.uint32_converter
        super().__init__(np.dtype([
            ("x", self._x_converter.overall_dtype()),
            ("y", self._y_converter.overall_dtype()),
            ("z", self._z_converter.overall_dtype()),
        ]))

    def to_json(self, value: MatrixSizeType) -> object:
        if not isinstance(value, MatrixSizeType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'MatrixSizeType' instance")
        json_object = {}

        json_object["x"] = self._x_converter.to_json(value.x)
        json_object["y"] = self._y_converter.to_json(value.y)
        json_object["z"] = self._z_converter.to_json(value.z)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["x"] = self._x_converter.numpy_to_json(value["x"])
        json_object["y"] = self._y_converter.numpy_to_json(value["y"])
        json_object["z"] = self._z_converter.numpy_to_json(value["z"])
        return json_object

    def from_json(self, json_object: object) -> MatrixSizeType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return MatrixSizeType(
            x=self._x_converter.from_json(json_object["x"],),
            y=self._y_converter.from_json(json_object["y"],),
            z=self._z_converter.from_json(json_object["z"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._x_converter.from_json_to_numpy(json_object["x"]),
            self._y_converter.from_json_to_numpy(json_object["y"]),
            self._z_converter.from_json_to_numpy(json_object["z"]),
        ) # type:ignore 


class FieldOfViewMmConverter(_ndjson.JsonConverter[FieldOfViewMm, np.void]):
    def __init__(self) -> None:
        self._x_converter = _ndjson.float32_converter
        self._y_converter = _ndjson.float32_converter
        self._z_converter = _ndjson.float32_converter
        super().__init__(np.dtype([
            ("x", self._x_converter.overall_dtype()),
            ("y", self._y_converter.overall_dtype()),
            ("z", self._z_converter.overall_dtype()),
        ]))

    def to_json(self, value: FieldOfViewMm) -> object:
        if not isinstance(value, FieldOfViewMm): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'FieldOfViewMm' instance")
        json_object = {}

        json_object["x"] = self._x_converter.to_json(value.x)
        json_object["y"] = self._y_converter.to_json(value.y)
        json_object["z"] = self._z_converter.to_json(value.z)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["x"] = self._x_converter.numpy_to_json(value["x"])
        json_object["y"] = self._y_converter.numpy_to_json(value["y"])
        json_object["z"] = self._z_converter.numpy_to_json(value["z"])
        return json_object

    def from_json(self, json_object: object) -> FieldOfViewMm:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return FieldOfViewMm(
            x=self._x_converter.from_json(json_object["x"],),
            y=self._y_converter.from_json(json_object["y"],),
            z=self._z_converter.from_json(json_object["z"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._x_converter.from_json_to_numpy(json_object["x"]),
            self._y_converter.from_json_to_numpy(json_object["y"]),
            self._z_converter.from_json_to_numpy(json_object["z"]),
        ) # type:ignore 


class EncodingSpaceTypeConverter(_ndjson.JsonConverter[EncodingSpaceType, np.void]):
    def __init__(self) -> None:
        self._matrix_size_converter = MatrixSizeTypeConverter()
        self._field_of_view_mm_converter = FieldOfViewMmConverter()
        super().__init__(np.dtype([
            ("matrix_size", self._matrix_size_converter.overall_dtype()),
            ("field_of_view_mm", self._field_of_view_mm_converter.overall_dtype()),
        ]))

    def to_json(self, value: EncodingSpaceType) -> object:
        if not isinstance(value, EncodingSpaceType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'EncodingSpaceType' instance")
        json_object = {}

        json_object["matrixSize"] = self._matrix_size_converter.to_json(value.matrix_size)
        json_object["fieldOfViewMm"] = self._field_of_view_mm_converter.to_json(value.field_of_view_mm)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["matrixSize"] = self._matrix_size_converter.numpy_to_json(value["matrix_size"])
        json_object["fieldOfViewMm"] = self._field_of_view_mm_converter.numpy_to_json(value["field_of_view_mm"])
        return json_object

    def from_json(self, json_object: object) -> EncodingSpaceType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return EncodingSpaceType(
            matrix_size=self._matrix_size_converter.from_json(json_object["matrixSize"],),
            field_of_view_mm=self._field_of_view_mm_converter.from_json(json_object["fieldOfViewMm"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._matrix_size_converter.from_json_to_numpy(json_object["matrixSize"]),
            self._field_of_view_mm_converter.from_json_to_numpy(json_object["fieldOfViewMm"]),
        ) # type:ignore 


class LimitTypeConverter(_ndjson.JsonConverter[LimitType, np.void]):
    def __init__(self) -> None:
        self._minimum_converter = _ndjson.uint32_converter
        self._maximum_converter = _ndjson.uint32_converter
        self._center_converter = _ndjson.uint32_converter
        super().__init__(np.dtype([
            ("minimum", self._minimum_converter.overall_dtype()),
            ("maximum", self._maximum_converter.overall_dtype()),
            ("center", self._center_converter.overall_dtype()),
        ]))

    def to_json(self, value: LimitType) -> object:
        if not isinstance(value, LimitType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'LimitType' instance")
        json_object = {}

        json_object["minimum"] = self._minimum_converter.to_json(value.minimum)
        json_object["maximum"] = self._maximum_converter.to_json(value.maximum)
        json_object["center"] = self._center_converter.to_json(value.center)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["minimum"] = self._minimum_converter.numpy_to_json(value["minimum"])
        json_object["maximum"] = self._maximum_converter.numpy_to_json(value["maximum"])
        json_object["center"] = self._center_converter.numpy_to_json(value["center"])
        return json_object

    def from_json(self, json_object: object) -> LimitType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return LimitType(
            minimum=self._minimum_converter.from_json(json_object["minimum"],),
            maximum=self._maximum_converter.from_json(json_object["maximum"],),
            center=self._center_converter.from_json(json_object["center"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._minimum_converter.from_json_to_numpy(json_object["minimum"]),
            self._maximum_converter.from_json_to_numpy(json_object["maximum"]),
            self._center_converter.from_json_to_numpy(json_object["center"]),
        ) # type:ignore 


class EncodingLimitsTypeConverter(_ndjson.JsonConverter[EncodingLimitsType, np.void]):
    def __init__(self) -> None:
        self._kspace_encoding_step_0_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._kspace_encoding_step_1_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._kspace_encoding_step_2_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._average_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._slice_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._contrast_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._phase_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._repetition_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._set_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._segment_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._user_0_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._user_1_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._user_2_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._user_3_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._user_4_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._user_5_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._user_6_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        self._user_7_converter = _ndjson.OptionalConverter(LimitTypeConverter())
        super().__init__(np.dtype([
            ("kspace_encoding_step_0", self._kspace_encoding_step_0_converter.overall_dtype()),
            ("kspace_encoding_step_1", self._kspace_encoding_step_1_converter.overall_dtype()),
            ("kspace_encoding_step_2", self._kspace_encoding_step_2_converter.overall_dtype()),
            ("average", self._average_converter.overall_dtype()),
            ("slice", self._slice_converter.overall_dtype()),
            ("contrast", self._contrast_converter.overall_dtype()),
            ("phase", self._phase_converter.overall_dtype()),
            ("repetition", self._repetition_converter.overall_dtype()),
            ("set", self._set_converter.overall_dtype()),
            ("segment", self._segment_converter.overall_dtype()),
            ("user_0", self._user_0_converter.overall_dtype()),
            ("user_1", self._user_1_converter.overall_dtype()),
            ("user_2", self._user_2_converter.overall_dtype()),
            ("user_3", self._user_3_converter.overall_dtype()),
            ("user_4", self._user_4_converter.overall_dtype()),
            ("user_5", self._user_5_converter.overall_dtype()),
            ("user_6", self._user_6_converter.overall_dtype()),
            ("user_7", self._user_7_converter.overall_dtype()),
        ]))

    def to_json(self, value: EncodingLimitsType) -> object:
        if not isinstance(value, EncodingLimitsType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'EncodingLimitsType' instance")
        json_object = {}

        if value.kspace_encoding_step_0 is not None:
            json_object["kspaceEncodingStep0"] = self._kspace_encoding_step_0_converter.to_json(value.kspace_encoding_step_0)
        if value.kspace_encoding_step_1 is not None:
            json_object["kspaceEncodingStep1"] = self._kspace_encoding_step_1_converter.to_json(value.kspace_encoding_step_1)
        if value.kspace_encoding_step_2 is not None:
            json_object["kspaceEncodingStep2"] = self._kspace_encoding_step_2_converter.to_json(value.kspace_encoding_step_2)
        if value.average is not None:
            json_object["average"] = self._average_converter.to_json(value.average)
        if value.slice is not None:
            json_object["slice"] = self._slice_converter.to_json(value.slice)
        if value.contrast is not None:
            json_object["contrast"] = self._contrast_converter.to_json(value.contrast)
        if value.phase is not None:
            json_object["phase"] = self._phase_converter.to_json(value.phase)
        if value.repetition is not None:
            json_object["repetition"] = self._repetition_converter.to_json(value.repetition)
        if value.set is not None:
            json_object["set"] = self._set_converter.to_json(value.set)
        if value.segment is not None:
            json_object["segment"] = self._segment_converter.to_json(value.segment)
        if value.user_0 is not None:
            json_object["user0"] = self._user_0_converter.to_json(value.user_0)
        if value.user_1 is not None:
            json_object["user1"] = self._user_1_converter.to_json(value.user_1)
        if value.user_2 is not None:
            json_object["user2"] = self._user_2_converter.to_json(value.user_2)
        if value.user_3 is not None:
            json_object["user3"] = self._user_3_converter.to_json(value.user_3)
        if value.user_4 is not None:
            json_object["user4"] = self._user_4_converter.to_json(value.user_4)
        if value.user_5 is not None:
            json_object["user5"] = self._user_5_converter.to_json(value.user_5)
        if value.user_6 is not None:
            json_object["user6"] = self._user_6_converter.to_json(value.user_6)
        if value.user_7 is not None:
            json_object["user7"] = self._user_7_converter.to_json(value.user_7)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        if (field_val := value["kspace_encoding_step_0"]) is not None:
            json_object["kspaceEncodingStep0"] = self._kspace_encoding_step_0_converter.numpy_to_json(field_val)
        if (field_val := value["kspace_encoding_step_1"]) is not None:
            json_object["kspaceEncodingStep1"] = self._kspace_encoding_step_1_converter.numpy_to_json(field_val)
        if (field_val := value["kspace_encoding_step_2"]) is not None:
            json_object["kspaceEncodingStep2"] = self._kspace_encoding_step_2_converter.numpy_to_json(field_val)
        if (field_val := value["average"]) is not None:
            json_object["average"] = self._average_converter.numpy_to_json(field_val)
        if (field_val := value["slice"]) is not None:
            json_object["slice"] = self._slice_converter.numpy_to_json(field_val)
        if (field_val := value["contrast"]) is not None:
            json_object["contrast"] = self._contrast_converter.numpy_to_json(field_val)
        if (field_val := value["phase"]) is not None:
            json_object["phase"] = self._phase_converter.numpy_to_json(field_val)
        if (field_val := value["repetition"]) is not None:
            json_object["repetition"] = self._repetition_converter.numpy_to_json(field_val)
        if (field_val := value["set"]) is not None:
            json_object["set"] = self._set_converter.numpy_to_json(field_val)
        if (field_val := value["segment"]) is not None:
            json_object["segment"] = self._segment_converter.numpy_to_json(field_val)
        if (field_val := value["user_0"]) is not None:
            json_object["user0"] = self._user_0_converter.numpy_to_json(field_val)
        if (field_val := value["user_1"]) is not None:
            json_object["user1"] = self._user_1_converter.numpy_to_json(field_val)
        if (field_val := value["user_2"]) is not None:
            json_object["user2"] = self._user_2_converter.numpy_to_json(field_val)
        if (field_val := value["user_3"]) is not None:
            json_object["user3"] = self._user_3_converter.numpy_to_json(field_val)
        if (field_val := value["user_4"]) is not None:
            json_object["user4"] = self._user_4_converter.numpy_to_json(field_val)
        if (field_val := value["user_5"]) is not None:
            json_object["user5"] = self._user_5_converter.numpy_to_json(field_val)
        if (field_val := value["user_6"]) is not None:
            json_object["user6"] = self._user_6_converter.numpy_to_json(field_val)
        if (field_val := value["user_7"]) is not None:
            json_object["user7"] = self._user_7_converter.numpy_to_json(field_val)
        return json_object

    def from_json(self, json_object: object) -> EncodingLimitsType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return EncodingLimitsType(
            kspace_encoding_step_0=self._kspace_encoding_step_0_converter.from_json(json_object.get("kspaceEncodingStep0")),
            kspace_encoding_step_1=self._kspace_encoding_step_1_converter.from_json(json_object.get("kspaceEncodingStep1")),
            kspace_encoding_step_2=self._kspace_encoding_step_2_converter.from_json(json_object.get("kspaceEncodingStep2")),
            average=self._average_converter.from_json(json_object.get("average")),
            slice=self._slice_converter.from_json(json_object.get("slice")),
            contrast=self._contrast_converter.from_json(json_object.get("contrast")),
            phase=self._phase_converter.from_json(json_object.get("phase")),
            repetition=self._repetition_converter.from_json(json_object.get("repetition")),
            set=self._set_converter.from_json(json_object.get("set")),
            segment=self._segment_converter.from_json(json_object.get("segment")),
            user_0=self._user_0_converter.from_json(json_object.get("user0")),
            user_1=self._user_1_converter.from_json(json_object.get("user1")),
            user_2=self._user_2_converter.from_json(json_object.get("user2")),
            user_3=self._user_3_converter.from_json(json_object.get("user3")),
            user_4=self._user_4_converter.from_json(json_object.get("user4")),
            user_5=self._user_5_converter.from_json(json_object.get("user5")),
            user_6=self._user_6_converter.from_json(json_object.get("user6")),
            user_7=self._user_7_converter.from_json(json_object.get("user7")),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._kspace_encoding_step_0_converter.from_json_to_numpy(json_object.get("kspaceEncodingStep0")),
            self._kspace_encoding_step_1_converter.from_json_to_numpy(json_object.get("kspaceEncodingStep1")),
            self._kspace_encoding_step_2_converter.from_json_to_numpy(json_object.get("kspaceEncodingStep2")),
            self._average_converter.from_json_to_numpy(json_object.get("average")),
            self._slice_converter.from_json_to_numpy(json_object.get("slice")),
            self._contrast_converter.from_json_to_numpy(json_object.get("contrast")),
            self._phase_converter.from_json_to_numpy(json_object.get("phase")),
            self._repetition_converter.from_json_to_numpy(json_object.get("repetition")),
            self._set_converter.from_json_to_numpy(json_object.get("set")),
            self._segment_converter.from_json_to_numpy(json_object.get("segment")),
            self._user_0_converter.from_json_to_numpy(json_object.get("user0")),
            self._user_1_converter.from_json_to_numpy(json_object.get("user1")),
            self._user_2_converter.from_json_to_numpy(json_object.get("user2")),
            self._user_3_converter.from_json_to_numpy(json_object.get("user3")),
            self._user_4_converter.from_json_to_numpy(json_object.get("user4")),
            self._user_5_converter.from_json_to_numpy(json_object.get("user5")),
            self._user_6_converter.from_json_to_numpy(json_object.get("user6")),
            self._user_7_converter.from_json_to_numpy(json_object.get("user7")),
        ) # type:ignore 


trajectory_name_to_value_map = {
    "cartesian": Trajectory.CARTESIAN,
    "epi": Trajectory.EPI,
    "radial": Trajectory.RADIAL,
    "goldenangle": Trajectory.GOLDENANGLE,
    "spiral": Trajectory.SPIRAL,
    "other": Trajectory.OTHER,
}
trajectory_value_to_name_map = {v: n for n, v in trajectory_name_to_value_map.items()}

class UserParameterLongTypeConverter(_ndjson.JsonConverter[UserParameterLongType, np.void]):
    def __init__(self) -> None:
        self._name_converter = _ndjson.string_converter
        self._value_converter = _ndjson.int64_converter
        super().__init__(np.dtype([
            ("name", self._name_converter.overall_dtype()),
            ("value", self._value_converter.overall_dtype()),
        ]))

    def to_json(self, value: UserParameterLongType) -> object:
        if not isinstance(value, UserParameterLongType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'UserParameterLongType' instance")
        json_object = {}

        json_object["name"] = self._name_converter.to_json(value.name)
        json_object["value"] = self._value_converter.to_json(value.value)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["name"] = self._name_converter.numpy_to_json(value["name"])
        json_object["value"] = self._value_converter.numpy_to_json(value["value"])
        return json_object

    def from_json(self, json_object: object) -> UserParameterLongType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return UserParameterLongType(
            name=self._name_converter.from_json(json_object["name"],),
            value=self._value_converter.from_json(json_object["value"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._name_converter.from_json_to_numpy(json_object["name"]),
            self._value_converter.from_json_to_numpy(json_object["value"]),
        ) # type:ignore 


class UserParameterDoubleTypeConverter(_ndjson.JsonConverter[UserParameterDoubleType, np.void]):
    def __init__(self) -> None:
        self._name_converter = _ndjson.string_converter
        self._value_converter = _ndjson.float64_converter
        super().__init__(np.dtype([
            ("name", self._name_converter.overall_dtype()),
            ("value", self._value_converter.overall_dtype()),
        ]))

    def to_json(self, value: UserParameterDoubleType) -> object:
        if not isinstance(value, UserParameterDoubleType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'UserParameterDoubleType' instance")
        json_object = {}

        json_object["name"] = self._name_converter.to_json(value.name)
        json_object["value"] = self._value_converter.to_json(value.value)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["name"] = self._name_converter.numpy_to_json(value["name"])
        json_object["value"] = self._value_converter.numpy_to_json(value["value"])
        return json_object

    def from_json(self, json_object: object) -> UserParameterDoubleType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return UserParameterDoubleType(
            name=self._name_converter.from_json(json_object["name"],),
            value=self._value_converter.from_json(json_object["value"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._name_converter.from_json_to_numpy(json_object["name"]),
            self._value_converter.from_json_to_numpy(json_object["value"]),
        ) # type:ignore 


class UserParameterStringTypeConverter(_ndjson.JsonConverter[UserParameterStringType, np.void]):
    def __init__(self) -> None:
        self._name_converter = _ndjson.string_converter
        self._value_converter = _ndjson.string_converter
        super().__init__(np.dtype([
            ("name", self._name_converter.overall_dtype()),
            ("value", self._value_converter.overall_dtype()),
        ]))

    def to_json(self, value: UserParameterStringType) -> object:
        if not isinstance(value, UserParameterStringType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'UserParameterStringType' instance")
        json_object = {}

        json_object["name"] = self._name_converter.to_json(value.name)
        json_object["value"] = self._value_converter.to_json(value.value)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["name"] = self._name_converter.numpy_to_json(value["name"])
        json_object["value"] = self._value_converter.numpy_to_json(value["value"])
        return json_object

    def from_json(self, json_object: object) -> UserParameterStringType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return UserParameterStringType(
            name=self._name_converter.from_json(json_object["name"],),
            value=self._value_converter.from_json(json_object["value"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._name_converter.from_json_to_numpy(json_object["name"]),
            self._value_converter.from_json_to_numpy(json_object["value"]),
        ) # type:ignore 


class TrajectoryDescriptionTypeConverter(_ndjson.JsonConverter[TrajectoryDescriptionType, np.void]):
    def __init__(self) -> None:
        self._identifier_converter = _ndjson.string_converter
        self._user_parameter_long_converter = _ndjson.VectorConverter(UserParameterLongTypeConverter())
        self._user_parameter_double_converter = _ndjson.VectorConverter(UserParameterDoubleTypeConverter())
        self._user_parameter_string_converter = _ndjson.VectorConverter(UserParameterStringTypeConverter())
        self._comment_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        super().__init__(np.dtype([
            ("identifier", self._identifier_converter.overall_dtype()),
            ("user_parameter_long", self._user_parameter_long_converter.overall_dtype()),
            ("user_parameter_double", self._user_parameter_double_converter.overall_dtype()),
            ("user_parameter_string", self._user_parameter_string_converter.overall_dtype()),
            ("comment", self._comment_converter.overall_dtype()),
        ]))

    def to_json(self, value: TrajectoryDescriptionType) -> object:
        if not isinstance(value, TrajectoryDescriptionType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'TrajectoryDescriptionType' instance")
        json_object = {}

        json_object["identifier"] = self._identifier_converter.to_json(value.identifier)
        json_object["userParameterLong"] = self._user_parameter_long_converter.to_json(value.user_parameter_long)
        json_object["userParameterDouble"] = self._user_parameter_double_converter.to_json(value.user_parameter_double)
        json_object["userParameterString"] = self._user_parameter_string_converter.to_json(value.user_parameter_string)
        if value.comment is not None:
            json_object["comment"] = self._comment_converter.to_json(value.comment)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["identifier"] = self._identifier_converter.numpy_to_json(value["identifier"])
        json_object["userParameterLong"] = self._user_parameter_long_converter.numpy_to_json(value["user_parameter_long"])
        json_object["userParameterDouble"] = self._user_parameter_double_converter.numpy_to_json(value["user_parameter_double"])
        json_object["userParameterString"] = self._user_parameter_string_converter.numpy_to_json(value["user_parameter_string"])
        if (field_val := value["comment"]) is not None:
            json_object["comment"] = self._comment_converter.numpy_to_json(field_val)
        return json_object

    def from_json(self, json_object: object) -> TrajectoryDescriptionType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return TrajectoryDescriptionType(
            identifier=self._identifier_converter.from_json(json_object["identifier"],),
            user_parameter_long=self._user_parameter_long_converter.from_json(json_object["userParameterLong"],),
            user_parameter_double=self._user_parameter_double_converter.from_json(json_object["userParameterDouble"],),
            user_parameter_string=self._user_parameter_string_converter.from_json(json_object["userParameterString"],),
            comment=self._comment_converter.from_json(json_object.get("comment")),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._identifier_converter.from_json_to_numpy(json_object["identifier"]),
            self._user_parameter_long_converter.from_json_to_numpy(json_object["userParameterLong"]),
            self._user_parameter_double_converter.from_json_to_numpy(json_object["userParameterDouble"]),
            self._user_parameter_string_converter.from_json_to_numpy(json_object["userParameterString"]),
            self._comment_converter.from_json_to_numpy(json_object.get("comment")),
        ) # type:ignore 


class AccelerationFactorTypeConverter(_ndjson.JsonConverter[AccelerationFactorType, np.void]):
    def __init__(self) -> None:
        self._kspace_encoding_step_1_converter = _ndjson.uint32_converter
        self._kspace_encoding_step_2_converter = _ndjson.uint32_converter
        super().__init__(np.dtype([
            ("kspace_encoding_step_1", self._kspace_encoding_step_1_converter.overall_dtype()),
            ("kspace_encoding_step_2", self._kspace_encoding_step_2_converter.overall_dtype()),
        ]))

    def to_json(self, value: AccelerationFactorType) -> object:
        if not isinstance(value, AccelerationFactorType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'AccelerationFactorType' instance")
        json_object = {}

        json_object["kspaceEncodingStep1"] = self._kspace_encoding_step_1_converter.to_json(value.kspace_encoding_step_1)
        json_object["kspaceEncodingStep2"] = self._kspace_encoding_step_2_converter.to_json(value.kspace_encoding_step_2)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["kspaceEncodingStep1"] = self._kspace_encoding_step_1_converter.numpy_to_json(value["kspace_encoding_step_1"])
        json_object["kspaceEncodingStep2"] = self._kspace_encoding_step_2_converter.numpy_to_json(value["kspace_encoding_step_2"])
        return json_object

    def from_json(self, json_object: object) -> AccelerationFactorType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return AccelerationFactorType(
            kspace_encoding_step_1=self._kspace_encoding_step_1_converter.from_json(json_object["kspaceEncodingStep1"],),
            kspace_encoding_step_2=self._kspace_encoding_step_2_converter.from_json(json_object["kspaceEncodingStep2"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._kspace_encoding_step_1_converter.from_json_to_numpy(json_object["kspaceEncodingStep1"]),
            self._kspace_encoding_step_2_converter.from_json_to_numpy(json_object["kspaceEncodingStep2"]),
        ) # type:ignore 


calibration_mode_name_to_value_map = {
    "noacceleration": CalibrationMode.NOACCELERATION,
    "embedded": CalibrationMode.EMBEDDED,
    "interleaved": CalibrationMode.INTERLEAVED,
    "separate": CalibrationMode.SEPARATE,
    "external": CalibrationMode.EXTERNAL,
    "other": CalibrationMode.OTHER,
}
calibration_mode_value_to_name_map = {v: n for n, v in calibration_mode_name_to_value_map.items()}

interleaving_dimension_name_to_value_map = {
    "phase": InterleavingDimension.PHASE,
    "repetition": InterleavingDimension.REPETITION,
    "contrast": InterleavingDimension.CONTRAST,
    "average": InterleavingDimension.AVERAGE,
    "other": InterleavingDimension.OTHER,
}
interleaving_dimension_value_to_name_map = {v: n for n, v in interleaving_dimension_name_to_value_map.items()}

class MultibandSpacingTypeConverter(_ndjson.JsonConverter[MultibandSpacingType, np.void]):
    def __init__(self) -> None:
        self._d_z_converter = _ndjson.VectorConverter(_ndjson.float32_converter)
        super().__init__(np.dtype([
            ("d_z", self._d_z_converter.overall_dtype()),
        ]))

    def to_json(self, value: MultibandSpacingType) -> object:
        if not isinstance(value, MultibandSpacingType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'MultibandSpacingType' instance")
        json_object = {}

        json_object["dZ"] = self._d_z_converter.to_json(value.d_z)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["dZ"] = self._d_z_converter.numpy_to_json(value["d_z"])
        return json_object

    def from_json(self, json_object: object) -> MultibandSpacingType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return MultibandSpacingType(
            d_z=self._d_z_converter.from_json(json_object["dZ"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._d_z_converter.from_json_to_numpy(json_object["dZ"]),
        ) # type:ignore 


calibration_name_to_value_map = {
    "separable2D": Calibration.SEPARABLE_2D,
    "full3D": Calibration.FULL_3D,
    "other": Calibration.OTHER,
}
calibration_value_to_name_map = {v: n for n, v in calibration_name_to_value_map.items()}

class MultibandTypeConverter(_ndjson.JsonConverter[MultibandType, np.void]):
    def __init__(self) -> None:
        self._spacing_converter = _ndjson.VectorConverter(MultibandSpacingTypeConverter())
        self._delta_kz_converter = _ndjson.float32_converter
        self._multiband_factor_converter = _ndjson.uint32_converter
        self._calibration_converter = _ndjson.EnumConverter(Calibration, np.int32, calibration_name_to_value_map, calibration_value_to_name_map)
        self._calibration_encoding_converter = _ndjson.uint64_converter
        super().__init__(np.dtype([
            ("spacing", self._spacing_converter.overall_dtype()),
            ("delta_kz", self._delta_kz_converter.overall_dtype()),
            ("multiband_factor", self._multiband_factor_converter.overall_dtype()),
            ("calibration", self._calibration_converter.overall_dtype()),
            ("calibration_encoding", self._calibration_encoding_converter.overall_dtype()),
        ]))

    def to_json(self, value: MultibandType) -> object:
        if not isinstance(value, MultibandType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'MultibandType' instance")
        json_object = {}

        json_object["spacing"] = self._spacing_converter.to_json(value.spacing)
        json_object["deltaKz"] = self._delta_kz_converter.to_json(value.delta_kz)
        json_object["multibandFactor"] = self._multiband_factor_converter.to_json(value.multiband_factor)
        json_object["calibration"] = self._calibration_converter.to_json(value.calibration)
        json_object["calibrationEncoding"] = self._calibration_encoding_converter.to_json(value.calibration_encoding)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["spacing"] = self._spacing_converter.numpy_to_json(value["spacing"])
        json_object["deltaKz"] = self._delta_kz_converter.numpy_to_json(value["delta_kz"])
        json_object["multibandFactor"] = self._multiband_factor_converter.numpy_to_json(value["multiband_factor"])
        json_object["calibration"] = self._calibration_converter.numpy_to_json(value["calibration"])
        json_object["calibrationEncoding"] = self._calibration_encoding_converter.numpy_to_json(value["calibration_encoding"])
        return json_object

    def from_json(self, json_object: object) -> MultibandType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return MultibandType(
            spacing=self._spacing_converter.from_json(json_object["spacing"],),
            delta_kz=self._delta_kz_converter.from_json(json_object["deltaKz"],),
            multiband_factor=self._multiband_factor_converter.from_json(json_object["multibandFactor"],),
            calibration=self._calibration_converter.from_json(json_object["calibration"],),
            calibration_encoding=self._calibration_encoding_converter.from_json(json_object["calibrationEncoding"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._spacing_converter.from_json_to_numpy(json_object["spacing"]),
            self._delta_kz_converter.from_json_to_numpy(json_object["deltaKz"]),
            self._multiband_factor_converter.from_json_to_numpy(json_object["multibandFactor"]),
            self._calibration_converter.from_json_to_numpy(json_object["calibration"]),
            self._calibration_encoding_converter.from_json_to_numpy(json_object["calibrationEncoding"]),
        ) # type:ignore 


class ParallelImagingTypeConverter(_ndjson.JsonConverter[ParallelImagingType, np.void]):
    def __init__(self) -> None:
        self._acceleration_factor_converter = AccelerationFactorTypeConverter()
        self._calibration_mode_converter = _ndjson.OptionalConverter(_ndjson.EnumConverter(CalibrationMode, np.int32, calibration_mode_name_to_value_map, calibration_mode_value_to_name_map))
        self._interleaving_dimension_converter = _ndjson.OptionalConverter(_ndjson.EnumConverter(InterleavingDimension, np.int32, interleaving_dimension_name_to_value_map, interleaving_dimension_value_to_name_map))
        self._multiband_converter = _ndjson.OptionalConverter(MultibandTypeConverter())
        super().__init__(np.dtype([
            ("acceleration_factor", self._acceleration_factor_converter.overall_dtype()),
            ("calibration_mode", self._calibration_mode_converter.overall_dtype()),
            ("interleaving_dimension", self._interleaving_dimension_converter.overall_dtype()),
            ("multiband", self._multiband_converter.overall_dtype()),
        ]))

    def to_json(self, value: ParallelImagingType) -> object:
        if not isinstance(value, ParallelImagingType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'ParallelImagingType' instance")
        json_object = {}

        json_object["accelerationFactor"] = self._acceleration_factor_converter.to_json(value.acceleration_factor)
        if value.calibration_mode is not None:
            json_object["calibrationMode"] = self._calibration_mode_converter.to_json(value.calibration_mode)
        if value.interleaving_dimension is not None:
            json_object["interleavingDimension"] = self._interleaving_dimension_converter.to_json(value.interleaving_dimension)
        if value.multiband is not None:
            json_object["multiband"] = self._multiband_converter.to_json(value.multiband)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["accelerationFactor"] = self._acceleration_factor_converter.numpy_to_json(value["acceleration_factor"])
        if (field_val := value["calibration_mode"]) is not None:
            json_object["calibrationMode"] = self._calibration_mode_converter.numpy_to_json(field_val)
        if (field_val := value["interleaving_dimension"]) is not None:
            json_object["interleavingDimension"] = self._interleaving_dimension_converter.numpy_to_json(field_val)
        if (field_val := value["multiband"]) is not None:
            json_object["multiband"] = self._multiband_converter.numpy_to_json(field_val)
        return json_object

    def from_json(self, json_object: object) -> ParallelImagingType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return ParallelImagingType(
            acceleration_factor=self._acceleration_factor_converter.from_json(json_object["accelerationFactor"],),
            calibration_mode=self._calibration_mode_converter.from_json(json_object.get("calibrationMode")),
            interleaving_dimension=self._interleaving_dimension_converter.from_json(json_object.get("interleavingDimension")),
            multiband=self._multiband_converter.from_json(json_object.get("multiband")),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._acceleration_factor_converter.from_json_to_numpy(json_object["accelerationFactor"]),
            self._calibration_mode_converter.from_json_to_numpy(json_object.get("calibrationMode")),
            self._interleaving_dimension_converter.from_json_to_numpy(json_object.get("interleavingDimension")),
            self._multiband_converter.from_json_to_numpy(json_object.get("multiband")),
        ) # type:ignore 


class EncodingTypeConverter(_ndjson.JsonConverter[EncodingType, np.void]):
    def __init__(self) -> None:
        self._encoded_space_converter = EncodingSpaceTypeConverter()
        self._recon_space_converter = EncodingSpaceTypeConverter()
        self._encoding_limits_converter = EncodingLimitsTypeConverter()
        self._trajectory_converter = _ndjson.EnumConverter(Trajectory, np.int32, trajectory_name_to_value_map, trajectory_value_to_name_map)
        self._trajectory_description_converter = _ndjson.OptionalConverter(TrajectoryDescriptionTypeConverter())
        self._parallel_imaging_converter = _ndjson.OptionalConverter(ParallelImagingTypeConverter())
        self._echo_train_length_converter = _ndjson.OptionalConverter(_ndjson.int64_converter)
        super().__init__(np.dtype([
            ("encoded_space", self._encoded_space_converter.overall_dtype()),
            ("recon_space", self._recon_space_converter.overall_dtype()),
            ("encoding_limits", self._encoding_limits_converter.overall_dtype()),
            ("trajectory", self._trajectory_converter.overall_dtype()),
            ("trajectory_description", self._trajectory_description_converter.overall_dtype()),
            ("parallel_imaging", self._parallel_imaging_converter.overall_dtype()),
            ("echo_train_length", self._echo_train_length_converter.overall_dtype()),
        ]))

    def to_json(self, value: EncodingType) -> object:
        if not isinstance(value, EncodingType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'EncodingType' instance")
        json_object = {}

        json_object["encodedSpace"] = self._encoded_space_converter.to_json(value.encoded_space)
        json_object["reconSpace"] = self._recon_space_converter.to_json(value.recon_space)
        json_object["encodingLimits"] = self._encoding_limits_converter.to_json(value.encoding_limits)
        json_object["trajectory"] = self._trajectory_converter.to_json(value.trajectory)
        if value.trajectory_description is not None:
            json_object["trajectoryDescription"] = self._trajectory_description_converter.to_json(value.trajectory_description)
        if value.parallel_imaging is not None:
            json_object["parallelImaging"] = self._parallel_imaging_converter.to_json(value.parallel_imaging)
        if value.echo_train_length is not None:
            json_object["echoTrainLength"] = self._echo_train_length_converter.to_json(value.echo_train_length)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["encodedSpace"] = self._encoded_space_converter.numpy_to_json(value["encoded_space"])
        json_object["reconSpace"] = self._recon_space_converter.numpy_to_json(value["recon_space"])
        json_object["encodingLimits"] = self._encoding_limits_converter.numpy_to_json(value["encoding_limits"])
        json_object["trajectory"] = self._trajectory_converter.numpy_to_json(value["trajectory"])
        if (field_val := value["trajectory_description"]) is not None:
            json_object["trajectoryDescription"] = self._trajectory_description_converter.numpy_to_json(field_val)
        if (field_val := value["parallel_imaging"]) is not None:
            json_object["parallelImaging"] = self._parallel_imaging_converter.numpy_to_json(field_val)
        if (field_val := value["echo_train_length"]) is not None:
            json_object["echoTrainLength"] = self._echo_train_length_converter.numpy_to_json(field_val)
        return json_object

    def from_json(self, json_object: object) -> EncodingType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return EncodingType(
            encoded_space=self._encoded_space_converter.from_json(json_object["encodedSpace"],),
            recon_space=self._recon_space_converter.from_json(json_object["reconSpace"],),
            encoding_limits=self._encoding_limits_converter.from_json(json_object["encodingLimits"],),
            trajectory=self._trajectory_converter.from_json(json_object["trajectory"],),
            trajectory_description=self._trajectory_description_converter.from_json(json_object.get("trajectoryDescription")),
            parallel_imaging=self._parallel_imaging_converter.from_json(json_object.get("parallelImaging")),
            echo_train_length=self._echo_train_length_converter.from_json(json_object.get("echoTrainLength")),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._encoded_space_converter.from_json_to_numpy(json_object["encodedSpace"]),
            self._recon_space_converter.from_json_to_numpy(json_object["reconSpace"]),
            self._encoding_limits_converter.from_json_to_numpy(json_object["encodingLimits"]),
            self._trajectory_converter.from_json_to_numpy(json_object["trajectory"]),
            self._trajectory_description_converter.from_json_to_numpy(json_object.get("trajectoryDescription")),
            self._parallel_imaging_converter.from_json_to_numpy(json_object.get("parallelImaging")),
            self._echo_train_length_converter.from_json_to_numpy(json_object.get("echoTrainLength")),
        ) # type:ignore 


diffusion_dimension_name_to_value_map = {
    "average": DiffusionDimension.AVERAGE,
    "contrast": DiffusionDimension.CONTRAST,
    "phase": DiffusionDimension.PHASE,
    "repetition": DiffusionDimension.REPETITION,
    "set": DiffusionDimension.SET,
    "segment": DiffusionDimension.SEGMENT,
    "user0": DiffusionDimension.USER_0,
    "user1": DiffusionDimension.USER_1,
    "user2": DiffusionDimension.USER_2,
    "user3": DiffusionDimension.USER_3,
    "user4": DiffusionDimension.USER_4,
    "user5": DiffusionDimension.USER_5,
    "user6": DiffusionDimension.USER_6,
    "user7": DiffusionDimension.USER_7,
}
diffusion_dimension_value_to_name_map = {v: n for n, v in diffusion_dimension_name_to_value_map.items()}

class GradientDirectionTypeConverter(_ndjson.JsonConverter[GradientDirectionType, np.void]):
    def __init__(self) -> None:
        self._rl_converter = _ndjson.float32_converter
        self._ap_converter = _ndjson.float32_converter
        self._fh_converter = _ndjson.float32_converter
        super().__init__(np.dtype([
            ("rl", self._rl_converter.overall_dtype()),
            ("ap", self._ap_converter.overall_dtype()),
            ("fh", self._fh_converter.overall_dtype()),
        ]))

    def to_json(self, value: GradientDirectionType) -> object:
        if not isinstance(value, GradientDirectionType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'GradientDirectionType' instance")
        json_object = {}

        json_object["rl"] = self._rl_converter.to_json(value.rl)
        json_object["ap"] = self._ap_converter.to_json(value.ap)
        json_object["fh"] = self._fh_converter.to_json(value.fh)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["rl"] = self._rl_converter.numpy_to_json(value["rl"])
        json_object["ap"] = self._ap_converter.numpy_to_json(value["ap"])
        json_object["fh"] = self._fh_converter.numpy_to_json(value["fh"])
        return json_object

    def from_json(self, json_object: object) -> GradientDirectionType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return GradientDirectionType(
            rl=self._rl_converter.from_json(json_object["rl"],),
            ap=self._ap_converter.from_json(json_object["ap"],),
            fh=self._fh_converter.from_json(json_object["fh"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._rl_converter.from_json_to_numpy(json_object["rl"]),
            self._ap_converter.from_json_to_numpy(json_object["ap"]),
            self._fh_converter.from_json_to_numpy(json_object["fh"]),
        ) # type:ignore 


class DiffusionTypeConverter(_ndjson.JsonConverter[DiffusionType, np.void]):
    def __init__(self) -> None:
        self._gradient_direction_converter = GradientDirectionTypeConverter()
        self._bvalue_converter = _ndjson.float32_converter
        super().__init__(np.dtype([
            ("gradient_direction", self._gradient_direction_converter.overall_dtype()),
            ("bvalue", self._bvalue_converter.overall_dtype()),
        ]))

    def to_json(self, value: DiffusionType) -> object:
        if not isinstance(value, DiffusionType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'DiffusionType' instance")
        json_object = {}

        json_object["gradientDirection"] = self._gradient_direction_converter.to_json(value.gradient_direction)
        json_object["bvalue"] = self._bvalue_converter.to_json(value.bvalue)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["gradientDirection"] = self._gradient_direction_converter.numpy_to_json(value["gradient_direction"])
        json_object["bvalue"] = self._bvalue_converter.numpy_to_json(value["bvalue"])
        return json_object

    def from_json(self, json_object: object) -> DiffusionType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return DiffusionType(
            gradient_direction=self._gradient_direction_converter.from_json(json_object["gradientDirection"],),
            bvalue=self._bvalue_converter.from_json(json_object["bvalue"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._gradient_direction_converter.from_json_to_numpy(json_object["gradientDirection"]),
            self._bvalue_converter.from_json_to_numpy(json_object["bvalue"]),
        ) # type:ignore 


class SequenceParametersTypeConverter(_ndjson.JsonConverter[SequenceParametersType, np.void]):
    def __init__(self) -> None:
        self._t_r_converter = _ndjson.VectorConverter(_ndjson.float32_converter)
        self._t_e_converter = _ndjson.VectorConverter(_ndjson.float32_converter)
        self._t_i_converter = _ndjson.VectorConverter(_ndjson.float32_converter)
        self._flip_angle_deg_converter = _ndjson.VectorConverter(_ndjson.float32_converter)
        self._sequence_type_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        self._echo_spacing_converter = _ndjson.VectorConverter(_ndjson.float32_converter)
        self._diffusion_dimension_converter = _ndjson.OptionalConverter(_ndjson.EnumConverter(DiffusionDimension, np.int32, diffusion_dimension_name_to_value_map, diffusion_dimension_value_to_name_map))
        self._diffusion_converter = _ndjson.VectorConverter(DiffusionTypeConverter())
        self._diffusion_scheme_converter = _ndjson.OptionalConverter(_ndjson.string_converter)
        super().__init__(np.dtype([
            ("t_r", self._t_r_converter.overall_dtype()),
            ("t_e", self._t_e_converter.overall_dtype()),
            ("t_i", self._t_i_converter.overall_dtype()),
            ("flip_angle_deg", self._flip_angle_deg_converter.overall_dtype()),
            ("sequence_type", self._sequence_type_converter.overall_dtype()),
            ("echo_spacing", self._echo_spacing_converter.overall_dtype()),
            ("diffusion_dimension", self._diffusion_dimension_converter.overall_dtype()),
            ("diffusion", self._diffusion_converter.overall_dtype()),
            ("diffusion_scheme", self._diffusion_scheme_converter.overall_dtype()),
        ]))

    def to_json(self, value: SequenceParametersType) -> object:
        if not isinstance(value, SequenceParametersType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'SequenceParametersType' instance")
        json_object = {}

        json_object["tR"] = self._t_r_converter.to_json(value.t_r)
        json_object["tE"] = self._t_e_converter.to_json(value.t_e)
        json_object["tI"] = self._t_i_converter.to_json(value.t_i)
        json_object["flipAngleDeg"] = self._flip_angle_deg_converter.to_json(value.flip_angle_deg)
        if value.sequence_type is not None:
            json_object["sequenceType"] = self._sequence_type_converter.to_json(value.sequence_type)
        json_object["echoSpacing"] = self._echo_spacing_converter.to_json(value.echo_spacing)
        if value.diffusion_dimension is not None:
            json_object["diffusionDimension"] = self._diffusion_dimension_converter.to_json(value.diffusion_dimension)
        json_object["diffusion"] = self._diffusion_converter.to_json(value.diffusion)
        if value.diffusion_scheme is not None:
            json_object["diffusionScheme"] = self._diffusion_scheme_converter.to_json(value.diffusion_scheme)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["tR"] = self._t_r_converter.numpy_to_json(value["t_r"])
        json_object["tE"] = self._t_e_converter.numpy_to_json(value["t_e"])
        json_object["tI"] = self._t_i_converter.numpy_to_json(value["t_i"])
        json_object["flipAngleDeg"] = self._flip_angle_deg_converter.numpy_to_json(value["flip_angle_deg"])
        if (field_val := value["sequence_type"]) is not None:
            json_object["sequenceType"] = self._sequence_type_converter.numpy_to_json(field_val)
        json_object["echoSpacing"] = self._echo_spacing_converter.numpy_to_json(value["echo_spacing"])
        if (field_val := value["diffusion_dimension"]) is not None:
            json_object["diffusionDimension"] = self._diffusion_dimension_converter.numpy_to_json(field_val)
        json_object["diffusion"] = self._diffusion_converter.numpy_to_json(value["diffusion"])
        if (field_val := value["diffusion_scheme"]) is not None:
            json_object["diffusionScheme"] = self._diffusion_scheme_converter.numpy_to_json(field_val)
        return json_object

    def from_json(self, json_object: object) -> SequenceParametersType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return SequenceParametersType(
            t_r=self._t_r_converter.from_json(json_object["tR"],),
            t_e=self._t_e_converter.from_json(json_object["tE"],),
            t_i=self._t_i_converter.from_json(json_object["tI"],),
            flip_angle_deg=self._flip_angle_deg_converter.from_json(json_object["flipAngleDeg"],),
            sequence_type=self._sequence_type_converter.from_json(json_object.get("sequenceType")),
            echo_spacing=self._echo_spacing_converter.from_json(json_object["echoSpacing"],),
            diffusion_dimension=self._diffusion_dimension_converter.from_json(json_object.get("diffusionDimension")),
            diffusion=self._diffusion_converter.from_json(json_object["diffusion"],),
            diffusion_scheme=self._diffusion_scheme_converter.from_json(json_object.get("diffusionScheme")),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._t_r_converter.from_json_to_numpy(json_object["tR"]),
            self._t_e_converter.from_json_to_numpy(json_object["tE"]),
            self._t_i_converter.from_json_to_numpy(json_object["tI"]),
            self._flip_angle_deg_converter.from_json_to_numpy(json_object["flipAngleDeg"]),
            self._sequence_type_converter.from_json_to_numpy(json_object.get("sequenceType")),
            self._echo_spacing_converter.from_json_to_numpy(json_object["echoSpacing"]),
            self._diffusion_dimension_converter.from_json_to_numpy(json_object.get("diffusionDimension")),
            self._diffusion_converter.from_json_to_numpy(json_object["diffusion"]),
            self._diffusion_scheme_converter.from_json_to_numpy(json_object.get("diffusionScheme")),
        ) # type:ignore 


class UserParameterBase64TypeConverter(_ndjson.JsonConverter[UserParameterBase64Type, np.void]):
    def __init__(self) -> None:
        self._name_converter = _ndjson.string_converter
        self._value_converter = _ndjson.string_converter
        super().__init__(np.dtype([
            ("name", self._name_converter.overall_dtype()),
            ("value", self._value_converter.overall_dtype()),
        ]))

    def to_json(self, value: UserParameterBase64Type) -> object:
        if not isinstance(value, UserParameterBase64Type): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'UserParameterBase64Type' instance")
        json_object = {}

        json_object["name"] = self._name_converter.to_json(value.name)
        json_object["value"] = self._value_converter.to_json(value.value)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["name"] = self._name_converter.numpy_to_json(value["name"])
        json_object["value"] = self._value_converter.numpy_to_json(value["value"])
        return json_object

    def from_json(self, json_object: object) -> UserParameterBase64Type:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return UserParameterBase64Type(
            name=self._name_converter.from_json(json_object["name"],),
            value=self._value_converter.from_json(json_object["value"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._name_converter.from_json_to_numpy(json_object["name"]),
            self._value_converter.from_json_to_numpy(json_object["value"]),
        ) # type:ignore 


class UserParametersTypeConverter(_ndjson.JsonConverter[UserParametersType, np.void]):
    def __init__(self) -> None:
        self._user_parameter_long_converter = _ndjson.VectorConverter(UserParameterLongTypeConverter())
        self._user_parameter_double_converter = _ndjson.VectorConverter(UserParameterDoubleTypeConverter())
        self._user_parameter_string_converter = _ndjson.VectorConverter(UserParameterStringTypeConverter())
        self._user_parameter_base64_converter = _ndjson.VectorConverter(UserParameterBase64TypeConverter())
        super().__init__(np.dtype([
            ("user_parameter_long", self._user_parameter_long_converter.overall_dtype()),
            ("user_parameter_double", self._user_parameter_double_converter.overall_dtype()),
            ("user_parameter_string", self._user_parameter_string_converter.overall_dtype()),
            ("user_parameter_base64", self._user_parameter_base64_converter.overall_dtype()),
        ]))

    def to_json(self, value: UserParametersType) -> object:
        if not isinstance(value, UserParametersType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'UserParametersType' instance")
        json_object = {}

        json_object["userParameterLong"] = self._user_parameter_long_converter.to_json(value.user_parameter_long)
        json_object["userParameterDouble"] = self._user_parameter_double_converter.to_json(value.user_parameter_double)
        json_object["userParameterString"] = self._user_parameter_string_converter.to_json(value.user_parameter_string)
        json_object["userParameterBase64"] = self._user_parameter_base64_converter.to_json(value.user_parameter_base64)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["userParameterLong"] = self._user_parameter_long_converter.numpy_to_json(value["user_parameter_long"])
        json_object["userParameterDouble"] = self._user_parameter_double_converter.numpy_to_json(value["user_parameter_double"])
        json_object["userParameterString"] = self._user_parameter_string_converter.numpy_to_json(value["user_parameter_string"])
        json_object["userParameterBase64"] = self._user_parameter_base64_converter.numpy_to_json(value["user_parameter_base64"])
        return json_object

    def from_json(self, json_object: object) -> UserParametersType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return UserParametersType(
            user_parameter_long=self._user_parameter_long_converter.from_json(json_object["userParameterLong"],),
            user_parameter_double=self._user_parameter_double_converter.from_json(json_object["userParameterDouble"],),
            user_parameter_string=self._user_parameter_string_converter.from_json(json_object["userParameterString"],),
            user_parameter_base64=self._user_parameter_base64_converter.from_json(json_object["userParameterBase64"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._user_parameter_long_converter.from_json_to_numpy(json_object["userParameterLong"]),
            self._user_parameter_double_converter.from_json_to_numpy(json_object["userParameterDouble"]),
            self._user_parameter_string_converter.from_json_to_numpy(json_object["userParameterString"]),
            self._user_parameter_base64_converter.from_json_to_numpy(json_object["userParameterBase64"]),
        ) # type:ignore 


waveform_type_name_to_value_map = {
    "ecg": WaveformType.ECG,
    "pulse": WaveformType.PULSE,
    "respiratory": WaveformType.RESPIRATORY,
    "trigger": WaveformType.TRIGGER,
    "gradientwaveform": WaveformType.GRADIENTWAVEFORM,
    "other": WaveformType.OTHER,
}
waveform_type_value_to_name_map = {v: n for n, v in waveform_type_name_to_value_map.items()}

class WaveformInformationTypeConverter(_ndjson.JsonConverter[WaveformInformationType, np.void]):
    def __init__(self) -> None:
        self._waveform_name_converter = _ndjson.string_converter
        self._waveform_type_converter = _ndjson.EnumConverter(WaveformType, np.int32, waveform_type_name_to_value_map, waveform_type_value_to_name_map)
        self._user_parameters_converter = UserParametersTypeConverter()
        super().__init__(np.dtype([
            ("waveform_name", self._waveform_name_converter.overall_dtype()),
            ("waveform_type", self._waveform_type_converter.overall_dtype()),
            ("user_parameters", self._user_parameters_converter.overall_dtype()),
        ]))

    def to_json(self, value: WaveformInformationType) -> object:
        if not isinstance(value, WaveformInformationType): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'WaveformInformationType' instance")
        json_object = {}

        json_object["waveformName"] = self._waveform_name_converter.to_json(value.waveform_name)
        json_object["waveformType"] = self._waveform_type_converter.to_json(value.waveform_type)
        json_object["userParameters"] = self._user_parameters_converter.to_json(value.user_parameters)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["waveformName"] = self._waveform_name_converter.numpy_to_json(value["waveform_name"])
        json_object["waveformType"] = self._waveform_type_converter.numpy_to_json(value["waveform_type"])
        json_object["userParameters"] = self._user_parameters_converter.numpy_to_json(value["user_parameters"])
        return json_object

    def from_json(self, json_object: object) -> WaveformInformationType:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return WaveformInformationType(
            waveform_name=self._waveform_name_converter.from_json(json_object["waveformName"],),
            waveform_type=self._waveform_type_converter.from_json(json_object["waveformType"],),
            user_parameters=self._user_parameters_converter.from_json(json_object["userParameters"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._waveform_name_converter.from_json_to_numpy(json_object["waveformName"]),
            self._waveform_type_converter.from_json_to_numpy(json_object["waveformType"]),
            self._user_parameters_converter.from_json_to_numpy(json_object["userParameters"]),
        ) # type:ignore 


class HeaderConverter(_ndjson.JsonConverter[Header, np.void]):
    def __init__(self) -> None:
        self._version_converter = _ndjson.OptionalConverter(_ndjson.int64_converter)
        self._subject_information_converter = _ndjson.OptionalConverter(SubjectInformationTypeConverter())
        self._study_information_converter = _ndjson.OptionalConverter(StudyInformationTypeConverter())
        self._measurement_information_converter = _ndjson.OptionalConverter(MeasurementInformationTypeConverter())
        self._acquisition_system_information_converter = _ndjson.OptionalConverter(AcquisitionSystemInformationTypeConverter())
        self._experimental_conditions_converter = ExperimentalConditionsTypeConverter()
        self._encoding_converter = _ndjson.VectorConverter(EncodingTypeConverter())
        self._sequence_parameters_converter = _ndjson.OptionalConverter(SequenceParametersTypeConverter())
        self._user_parameters_converter = _ndjson.OptionalConverter(UserParametersTypeConverter())
        self._waveform_information_converter = _ndjson.VectorConverter(WaveformInformationTypeConverter())
        super().__init__(np.dtype([
            ("version", self._version_converter.overall_dtype()),
            ("subject_information", self._subject_information_converter.overall_dtype()),
            ("study_information", self._study_information_converter.overall_dtype()),
            ("measurement_information", self._measurement_information_converter.overall_dtype()),
            ("acquisition_system_information", self._acquisition_system_information_converter.overall_dtype()),
            ("experimental_conditions", self._experimental_conditions_converter.overall_dtype()),
            ("encoding", self._encoding_converter.overall_dtype()),
            ("sequence_parameters", self._sequence_parameters_converter.overall_dtype()),
            ("user_parameters", self._user_parameters_converter.overall_dtype()),
            ("waveform_information", self._waveform_information_converter.overall_dtype()),
        ]))

    def to_json(self, value: Header) -> object:
        if not isinstance(value, Header): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'Header' instance")
        json_object = {}

        if value.version is not None:
            json_object["version"] = self._version_converter.to_json(value.version)
        if value.subject_information is not None:
            json_object["subjectInformation"] = self._subject_information_converter.to_json(value.subject_information)
        if value.study_information is not None:
            json_object["studyInformation"] = self._study_information_converter.to_json(value.study_information)
        if value.measurement_information is not None:
            json_object["measurementInformation"] = self._measurement_information_converter.to_json(value.measurement_information)
        if value.acquisition_system_information is not None:
            json_object["acquisitionSystemInformation"] = self._acquisition_system_information_converter.to_json(value.acquisition_system_information)
        json_object["experimentalConditions"] = self._experimental_conditions_converter.to_json(value.experimental_conditions)
        json_object["encoding"] = self._encoding_converter.to_json(value.encoding)
        if value.sequence_parameters is not None:
            json_object["sequenceParameters"] = self._sequence_parameters_converter.to_json(value.sequence_parameters)
        if value.user_parameters is not None:
            json_object["userParameters"] = self._user_parameters_converter.to_json(value.user_parameters)
        json_object["waveformInformation"] = self._waveform_information_converter.to_json(value.waveform_information)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        if (field_val := value["version"]) is not None:
            json_object["version"] = self._version_converter.numpy_to_json(field_val)
        if (field_val := value["subject_information"]) is not None:
            json_object["subjectInformation"] = self._subject_information_converter.numpy_to_json(field_val)
        if (field_val := value["study_information"]) is not None:
            json_object["studyInformation"] = self._study_information_converter.numpy_to_json(field_val)
        if (field_val := value["measurement_information"]) is not None:
            json_object["measurementInformation"] = self._measurement_information_converter.numpy_to_json(field_val)
        if (field_val := value["acquisition_system_information"]) is not None:
            json_object["acquisitionSystemInformation"] = self._acquisition_system_information_converter.numpy_to_json(field_val)
        json_object["experimentalConditions"] = self._experimental_conditions_converter.numpy_to_json(value["experimental_conditions"])
        json_object["encoding"] = self._encoding_converter.numpy_to_json(value["encoding"])
        if (field_val := value["sequence_parameters"]) is not None:
            json_object["sequenceParameters"] = self._sequence_parameters_converter.numpy_to_json(field_val)
        if (field_val := value["user_parameters"]) is not None:
            json_object["userParameters"] = self._user_parameters_converter.numpy_to_json(field_val)
        json_object["waveformInformation"] = self._waveform_information_converter.numpy_to_json(value["waveform_information"])
        return json_object

    def from_json(self, json_object: object) -> Header:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return Header(
            version=self._version_converter.from_json(json_object.get("version")),
            subject_information=self._subject_information_converter.from_json(json_object.get("subjectInformation")),
            study_information=self._study_information_converter.from_json(json_object.get("studyInformation")),
            measurement_information=self._measurement_information_converter.from_json(json_object.get("measurementInformation")),
            acquisition_system_information=self._acquisition_system_information_converter.from_json(json_object.get("acquisitionSystemInformation")),
            experimental_conditions=self._experimental_conditions_converter.from_json(json_object["experimentalConditions"],),
            encoding=self._encoding_converter.from_json(json_object["encoding"],),
            sequence_parameters=self._sequence_parameters_converter.from_json(json_object.get("sequenceParameters")),
            user_parameters=self._user_parameters_converter.from_json(json_object.get("userParameters")),
            waveform_information=self._waveform_information_converter.from_json(json_object["waveformInformation"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._version_converter.from_json_to_numpy(json_object.get("version")),
            self._subject_information_converter.from_json_to_numpy(json_object.get("subjectInformation")),
            self._study_information_converter.from_json_to_numpy(json_object.get("studyInformation")),
            self._measurement_information_converter.from_json_to_numpy(json_object.get("measurementInformation")),
            self._acquisition_system_information_converter.from_json_to_numpy(json_object.get("acquisitionSystemInformation")),
            self._experimental_conditions_converter.from_json_to_numpy(json_object["experimentalConditions"]),
            self._encoding_converter.from_json_to_numpy(json_object["encoding"]),
            self._sequence_parameters_converter.from_json_to_numpy(json_object.get("sequenceParameters")),
            self._user_parameters_converter.from_json_to_numpy(json_object.get("userParameters")),
            self._waveform_information_converter.from_json_to_numpy(json_object["waveformInformation"]),
        ) # type:ignore 


image_flags_name_to_value_map = {
    "isNavigationData": ImageFlags.IS_NAVIGATION_DATA,
    "firstInAverage": ImageFlags.FIRST_IN_AVERAGE,
    "lastInAverage": ImageFlags.LAST_IN_AVERAGE,
    "firstInSlice": ImageFlags.FIRST_IN_SLICE,
    "lastInSlice": ImageFlags.LAST_IN_SLICE,
    "firstInContrast": ImageFlags.FIRST_IN_CONTRAST,
    "lastInContrast": ImageFlags.LAST_IN_CONTRAST,
    "firstInPhase": ImageFlags.FIRST_IN_PHASE,
    "lastInPhase": ImageFlags.LAST_IN_PHASE,
    "firstInRepetition": ImageFlags.FIRST_IN_REPETITION,
    "lastInRepetition": ImageFlags.LAST_IN_REPETITION,
    "firstInSet": ImageFlags.FIRST_IN_SET,
    "lastInSet": ImageFlags.LAST_IN_SET,
}
image_flags_value_to_name_map = {v: n for n, v in image_flags_name_to_value_map.items()}

image_type_name_to_value_map = {
    "magnitude": ImageType.MAGNITUDE,
    "phase": ImageType.PHASE,
    "real": ImageType.REAL,
    "imag": ImageType.IMAG,
    "complex": ImageType.COMPLEX,
}
image_type_value_to_name_map = {v: n for n, v in image_type_name_to_value_map.items()}

class ImageHeaderConverter(_ndjson.JsonConverter[ImageHeader, np.void]):
    def __init__(self) -> None:
        self._flags_converter = _ndjson.FlagsConverter(ImageFlags, np.uint64, image_flags_name_to_value_map, image_flags_value_to_name_map)
        self._measurement_uid_converter = _ndjson.uint32_converter
        self._field_of_view_converter = _ndjson.FixedNDArrayConverter(_ndjson.float32_converter, (3,))
        self._position_converter = _ndjson.FixedNDArrayConverter(_ndjson.float32_converter, (3,))
        self._col_dir_converter = _ndjson.FixedNDArrayConverter(_ndjson.float32_converter, (3,))
        self._line_dir_converter = _ndjson.FixedNDArrayConverter(_ndjson.float32_converter, (3,))
        self._slice_dir_converter = _ndjson.FixedNDArrayConverter(_ndjson.float32_converter, (3,))
        self._patient_table_position_converter = _ndjson.FixedNDArrayConverter(_ndjson.float32_converter, (3,))
        self._average_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._slice_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._contrast_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._phase_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._repetition_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._set_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._acquisition_time_stamp_ns_converter = _ndjson.OptionalConverter(_ndjson.uint64_converter)
        self._physiology_time_stamp_ns_converter = _ndjson.VectorConverter(_ndjson.uint64_converter)
        self._image_type_converter = _ndjson.EnumConverter(ImageType, np.int32, image_type_name_to_value_map, image_type_value_to_name_map)
        self._image_index_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._image_series_index_converter = _ndjson.OptionalConverter(_ndjson.uint32_converter)
        self._user_int_converter = _ndjson.VectorConverter(_ndjson.int32_converter)
        self._user_float_converter = _ndjson.VectorConverter(_ndjson.float32_converter)
        super().__init__(np.dtype([
            ("flags", self._flags_converter.overall_dtype()),
            ("measurement_uid", self._measurement_uid_converter.overall_dtype()),
            ("field_of_view", self._field_of_view_converter.overall_dtype()),
            ("position", self._position_converter.overall_dtype()),
            ("col_dir", self._col_dir_converter.overall_dtype()),
            ("line_dir", self._line_dir_converter.overall_dtype()),
            ("slice_dir", self._slice_dir_converter.overall_dtype()),
            ("patient_table_position", self._patient_table_position_converter.overall_dtype()),
            ("average", self._average_converter.overall_dtype()),
            ("slice", self._slice_converter.overall_dtype()),
            ("contrast", self._contrast_converter.overall_dtype()),
            ("phase", self._phase_converter.overall_dtype()),
            ("repetition", self._repetition_converter.overall_dtype()),
            ("set", self._set_converter.overall_dtype()),
            ("acquisition_time_stamp_ns", self._acquisition_time_stamp_ns_converter.overall_dtype()),
            ("physiology_time_stamp_ns", self._physiology_time_stamp_ns_converter.overall_dtype()),
            ("image_type", self._image_type_converter.overall_dtype()),
            ("image_index", self._image_index_converter.overall_dtype()),
            ("image_series_index", self._image_series_index_converter.overall_dtype()),
            ("user_int", self._user_int_converter.overall_dtype()),
            ("user_float", self._user_float_converter.overall_dtype()),
        ]))

    def to_json(self, value: ImageHeader) -> object:
        if not isinstance(value, ImageHeader): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'ImageHeader' instance")
        json_object = {}

        json_object["flags"] = self._flags_converter.to_json(value.flags)
        json_object["measurementUid"] = self._measurement_uid_converter.to_json(value.measurement_uid)
        json_object["fieldOfView"] = self._field_of_view_converter.to_json(value.field_of_view)
        json_object["position"] = self._position_converter.to_json(value.position)
        json_object["colDir"] = self._col_dir_converter.to_json(value.col_dir)
        json_object["lineDir"] = self._line_dir_converter.to_json(value.line_dir)
        json_object["sliceDir"] = self._slice_dir_converter.to_json(value.slice_dir)
        json_object["patientTablePosition"] = self._patient_table_position_converter.to_json(value.patient_table_position)
        if value.average is not None:
            json_object["average"] = self._average_converter.to_json(value.average)
        if value.slice is not None:
            json_object["slice"] = self._slice_converter.to_json(value.slice)
        if value.contrast is not None:
            json_object["contrast"] = self._contrast_converter.to_json(value.contrast)
        if value.phase is not None:
            json_object["phase"] = self._phase_converter.to_json(value.phase)
        if value.repetition is not None:
            json_object["repetition"] = self._repetition_converter.to_json(value.repetition)
        if value.set is not None:
            json_object["set"] = self._set_converter.to_json(value.set)
        if value.acquisition_time_stamp_ns is not None:
            json_object["acquisitionTimeStampNs"] = self._acquisition_time_stamp_ns_converter.to_json(value.acquisition_time_stamp_ns)
        json_object["physiologyTimeStampNs"] = self._physiology_time_stamp_ns_converter.to_json(value.physiology_time_stamp_ns)
        json_object["imageType"] = self._image_type_converter.to_json(value.image_type)
        if value.image_index is not None:
            json_object["imageIndex"] = self._image_index_converter.to_json(value.image_index)
        if value.image_series_index is not None:
            json_object["imageSeriesIndex"] = self._image_series_index_converter.to_json(value.image_series_index)
        json_object["userInt"] = self._user_int_converter.to_json(value.user_int)
        json_object["userFloat"] = self._user_float_converter.to_json(value.user_float)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["flags"] = self._flags_converter.numpy_to_json(value["flags"])
        json_object["measurementUid"] = self._measurement_uid_converter.numpy_to_json(value["measurement_uid"])
        json_object["fieldOfView"] = self._field_of_view_converter.numpy_to_json(value["field_of_view"])
        json_object["position"] = self._position_converter.numpy_to_json(value["position"])
        json_object["colDir"] = self._col_dir_converter.numpy_to_json(value["col_dir"])
        json_object["lineDir"] = self._line_dir_converter.numpy_to_json(value["line_dir"])
        json_object["sliceDir"] = self._slice_dir_converter.numpy_to_json(value["slice_dir"])
        json_object["patientTablePosition"] = self._patient_table_position_converter.numpy_to_json(value["patient_table_position"])
        if (field_val := value["average"]) is not None:
            json_object["average"] = self._average_converter.numpy_to_json(field_val)
        if (field_val := value["slice"]) is not None:
            json_object["slice"] = self._slice_converter.numpy_to_json(field_val)
        if (field_val := value["contrast"]) is not None:
            json_object["contrast"] = self._contrast_converter.numpy_to_json(field_val)
        if (field_val := value["phase"]) is not None:
            json_object["phase"] = self._phase_converter.numpy_to_json(field_val)
        if (field_val := value["repetition"]) is not None:
            json_object["repetition"] = self._repetition_converter.numpy_to_json(field_val)
        if (field_val := value["set"]) is not None:
            json_object["set"] = self._set_converter.numpy_to_json(field_val)
        if (field_val := value["acquisition_time_stamp_ns"]) is not None:
            json_object["acquisitionTimeStampNs"] = self._acquisition_time_stamp_ns_converter.numpy_to_json(field_val)
        json_object["physiologyTimeStampNs"] = self._physiology_time_stamp_ns_converter.numpy_to_json(value["physiology_time_stamp_ns"])
        json_object["imageType"] = self._image_type_converter.numpy_to_json(value["image_type"])
        if (field_val := value["image_index"]) is not None:
            json_object["imageIndex"] = self._image_index_converter.numpy_to_json(field_val)
        if (field_val := value["image_series_index"]) is not None:
            json_object["imageSeriesIndex"] = self._image_series_index_converter.numpy_to_json(field_val)
        json_object["userInt"] = self._user_int_converter.numpy_to_json(value["user_int"])
        json_object["userFloat"] = self._user_float_converter.numpy_to_json(value["user_float"])
        return json_object

    def from_json(self, json_object: object) -> ImageHeader:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return ImageHeader(
            flags=self._flags_converter.from_json(json_object["flags"],),
            measurement_uid=self._measurement_uid_converter.from_json(json_object["measurementUid"],),
            field_of_view=self._field_of_view_converter.from_json(json_object["fieldOfView"],),
            position=self._position_converter.from_json(json_object["position"],),
            col_dir=self._col_dir_converter.from_json(json_object["colDir"],),
            line_dir=self._line_dir_converter.from_json(json_object["lineDir"],),
            slice_dir=self._slice_dir_converter.from_json(json_object["sliceDir"],),
            patient_table_position=self._patient_table_position_converter.from_json(json_object["patientTablePosition"],),
            average=self._average_converter.from_json(json_object.get("average")),
            slice=self._slice_converter.from_json(json_object.get("slice")),
            contrast=self._contrast_converter.from_json(json_object.get("contrast")),
            phase=self._phase_converter.from_json(json_object.get("phase")),
            repetition=self._repetition_converter.from_json(json_object.get("repetition")),
            set=self._set_converter.from_json(json_object.get("set")),
            acquisition_time_stamp_ns=self._acquisition_time_stamp_ns_converter.from_json(json_object.get("acquisitionTimeStampNs")),
            physiology_time_stamp_ns=self._physiology_time_stamp_ns_converter.from_json(json_object["physiologyTimeStampNs"],),
            image_type=self._image_type_converter.from_json(json_object["imageType"],),
            image_index=self._image_index_converter.from_json(json_object.get("imageIndex")),
            image_series_index=self._image_series_index_converter.from_json(json_object.get("imageSeriesIndex")),
            user_int=self._user_int_converter.from_json(json_object["userInt"],),
            user_float=self._user_float_converter.from_json(json_object["userFloat"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._flags_converter.from_json_to_numpy(json_object["flags"]),
            self._measurement_uid_converter.from_json_to_numpy(json_object["measurementUid"]),
            self._field_of_view_converter.from_json_to_numpy(json_object["fieldOfView"]),
            self._position_converter.from_json_to_numpy(json_object["position"]),
            self._col_dir_converter.from_json_to_numpy(json_object["colDir"]),
            self._line_dir_converter.from_json_to_numpy(json_object["lineDir"]),
            self._slice_dir_converter.from_json_to_numpy(json_object["sliceDir"]),
            self._patient_table_position_converter.from_json_to_numpy(json_object["patientTablePosition"]),
            self._average_converter.from_json_to_numpy(json_object.get("average")),
            self._slice_converter.from_json_to_numpy(json_object.get("slice")),
            self._contrast_converter.from_json_to_numpy(json_object.get("contrast")),
            self._phase_converter.from_json_to_numpy(json_object.get("phase")),
            self._repetition_converter.from_json_to_numpy(json_object.get("repetition")),
            self._set_converter.from_json_to_numpy(json_object.get("set")),
            self._acquisition_time_stamp_ns_converter.from_json_to_numpy(json_object.get("acquisitionTimeStampNs")),
            self._physiology_time_stamp_ns_converter.from_json_to_numpy(json_object["physiologyTimeStampNs"]),
            self._image_type_converter.from_json_to_numpy(json_object["imageType"]),
            self._image_index_converter.from_json_to_numpy(json_object.get("imageIndex")),
            self._image_series_index_converter.from_json_to_numpy(json_object.get("imageSeriesIndex")),
            self._user_int_converter.from_json_to_numpy(json_object["userInt"]),
            self._user_float_converter.from_json_to_numpy(json_object["userFloat"]),
        ) # type:ignore 


class ImageConverter(typing.Generic[T, T_NP], _ndjson.JsonConverter[Image[T_NP], np.void]):
    def __init__(self, t_converter: _ndjson.JsonConverter[T, T_NP]) -> None:
        self._head_converter = ImageHeaderConverter()
        self._data_converter = _ndjson.NDArrayConverter(t_converter, 4)
        self._meta_converter = _ndjson.MapConverter(_ndjson.string_converter, _ndjson.VectorConverter(_ndjson.UnionConverter(ImageMetaValue, [(ImageMetaValue.String, _ndjson.string_converter, [str]), (ImageMetaValue.Int64, _ndjson.int64_converter, [int, float]), (ImageMetaValue.Float64, _ndjson.float64_converter, [int, float])], False)))
        super().__init__(np.dtype([
            ("head", self._head_converter.overall_dtype()),
            ("data", self._data_converter.overall_dtype()),
            ("meta", self._meta_converter.overall_dtype()),
        ]))

    def to_json(self, value: Image[T_NP]) -> object:
        if not isinstance(value, Image): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'Image[T_NP]' instance")
        json_object = {}

        json_object["head"] = self._head_converter.to_json(value.head)
        json_object["data"] = self._data_converter.to_json(value.data)
        json_object["meta"] = self._meta_converter.to_json(value.meta)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["head"] = self._head_converter.numpy_to_json(value["head"])
        json_object["data"] = self._data_converter.numpy_to_json(value["data"])
        json_object["meta"] = self._meta_converter.numpy_to_json(value["meta"])
        return json_object

    def from_json(self, json_object: object) -> Image[T_NP]:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return Image[T_NP](
            head=self._head_converter.from_json(json_object["head"],),
            data=self._data_converter.from_json(json_object["data"],),
            meta=self._meta_converter.from_json(json_object["meta"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._head_converter.from_json_to_numpy(json_object["head"]),
            self._data_converter.from_json_to_numpy(json_object["data"]),
            self._meta_converter.from_json_to_numpy(json_object["meta"]),
        ) # type:ignore 


class NoiseCovarianceConverter(_ndjson.JsonConverter[NoiseCovariance, np.void]):
    def __init__(self) -> None:
        self._coil_labels_converter = _ndjson.VectorConverter(CoilLabelTypeConverter())
        self._receiver_noise_bandwidth_converter = _ndjson.float32_converter
        self._noise_dwell_time_ns_converter = _ndjson.uint64_converter
        self._sample_count_converter = _ndjson.size_converter
        self._matrix_converter = _ndjson.NDArrayConverter(_ndjson.complexfloat32_converter, 2)
        super().__init__(np.dtype([
            ("coil_labels", self._coil_labels_converter.overall_dtype()),
            ("receiver_noise_bandwidth", self._receiver_noise_bandwidth_converter.overall_dtype()),
            ("noise_dwell_time_ns", self._noise_dwell_time_ns_converter.overall_dtype()),
            ("sample_count", self._sample_count_converter.overall_dtype()),
            ("matrix", self._matrix_converter.overall_dtype()),
        ]))

    def to_json(self, value: NoiseCovariance) -> object:
        if not isinstance(value, NoiseCovariance): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'NoiseCovariance' instance")
        json_object = {}

        json_object["coilLabels"] = self._coil_labels_converter.to_json(value.coil_labels)
        json_object["receiverNoiseBandwidth"] = self._receiver_noise_bandwidth_converter.to_json(value.receiver_noise_bandwidth)
        json_object["noiseDwellTimeNs"] = self._noise_dwell_time_ns_converter.to_json(value.noise_dwell_time_ns)
        json_object["sampleCount"] = self._sample_count_converter.to_json(value.sample_count)
        json_object["matrix"] = self._matrix_converter.to_json(value.matrix)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["coilLabels"] = self._coil_labels_converter.numpy_to_json(value["coil_labels"])
        json_object["receiverNoiseBandwidth"] = self._receiver_noise_bandwidth_converter.numpy_to_json(value["receiver_noise_bandwidth"])
        json_object["noiseDwellTimeNs"] = self._noise_dwell_time_ns_converter.numpy_to_json(value["noise_dwell_time_ns"])
        json_object["sampleCount"] = self._sample_count_converter.numpy_to_json(value["sample_count"])
        json_object["matrix"] = self._matrix_converter.numpy_to_json(value["matrix"])
        return json_object

    def from_json(self, json_object: object) -> NoiseCovariance:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return NoiseCovariance(
            coil_labels=self._coil_labels_converter.from_json(json_object["coilLabels"],),
            receiver_noise_bandwidth=self._receiver_noise_bandwidth_converter.from_json(json_object["receiverNoiseBandwidth"],),
            noise_dwell_time_ns=self._noise_dwell_time_ns_converter.from_json(json_object["noiseDwellTimeNs"],),
            sample_count=self._sample_count_converter.from_json(json_object["sampleCount"],),
            matrix=self._matrix_converter.from_json(json_object["matrix"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._coil_labels_converter.from_json_to_numpy(json_object["coilLabels"]),
            self._receiver_noise_bandwidth_converter.from_json_to_numpy(json_object["receiverNoiseBandwidth"]),
            self._noise_dwell_time_ns_converter.from_json_to_numpy(json_object["noiseDwellTimeNs"]),
            self._sample_count_converter.from_json_to_numpy(json_object["sampleCount"]),
            self._matrix_converter.from_json_to_numpy(json_object["matrix"]),
        ) # type:ignore 


class WaveformConverter(typing.Generic[T, T_NP], _ndjson.JsonConverter[Waveform[T_NP], np.void]):
    def __init__(self, t_converter: _ndjson.JsonConverter[T, T_NP]) -> None:
        self._flags_converter = _ndjson.uint64_converter
        self._measurement_uid_converter = _ndjson.uint32_converter
        self._scan_counter_converter = _ndjson.uint32_converter
        self._time_stamp_ns_converter = _ndjson.uint64_converter
        self._sample_time_ns_converter = _ndjson.uint64_converter
        self._waveform_id_converter = _ndjson.uint32_converter
        self._data_converter = _ndjson.NDArrayConverter(t_converter, 2)
        super().__init__(np.dtype([
            ("flags", self._flags_converter.overall_dtype()),
            ("measurement_uid", self._measurement_uid_converter.overall_dtype()),
            ("scan_counter", self._scan_counter_converter.overall_dtype()),
            ("time_stamp_ns", self._time_stamp_ns_converter.overall_dtype()),
            ("sample_time_ns", self._sample_time_ns_converter.overall_dtype()),
            ("waveform_id", self._waveform_id_converter.overall_dtype()),
            ("data", self._data_converter.overall_dtype()),
        ]))

    def to_json(self, value: Waveform[T_NP]) -> object:
        if not isinstance(value, Waveform): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'Waveform[T_NP]' instance")
        json_object = {}

        json_object["flags"] = self._flags_converter.to_json(value.flags)
        json_object["measurementUid"] = self._measurement_uid_converter.to_json(value.measurement_uid)
        json_object["scanCounter"] = self._scan_counter_converter.to_json(value.scan_counter)
        json_object["timeStampNs"] = self._time_stamp_ns_converter.to_json(value.time_stamp_ns)
        json_object["sampleTimeNs"] = self._sample_time_ns_converter.to_json(value.sample_time_ns)
        json_object["waveformId"] = self._waveform_id_converter.to_json(value.waveform_id)
        json_object["data"] = self._data_converter.to_json(value.data)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["flags"] = self._flags_converter.numpy_to_json(value["flags"])
        json_object["measurementUid"] = self._measurement_uid_converter.numpy_to_json(value["measurement_uid"])
        json_object["scanCounter"] = self._scan_counter_converter.numpy_to_json(value["scan_counter"])
        json_object["timeStampNs"] = self._time_stamp_ns_converter.numpy_to_json(value["time_stamp_ns"])
        json_object["sampleTimeNs"] = self._sample_time_ns_converter.numpy_to_json(value["sample_time_ns"])
        json_object["waveformId"] = self._waveform_id_converter.numpy_to_json(value["waveform_id"])
        json_object["data"] = self._data_converter.numpy_to_json(value["data"])
        return json_object

    def from_json(self, json_object: object) -> Waveform[T_NP]:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return Waveform[T_NP](
            flags=self._flags_converter.from_json(json_object["flags"],),
            measurement_uid=self._measurement_uid_converter.from_json(json_object["measurementUid"],),
            scan_counter=self._scan_counter_converter.from_json(json_object["scanCounter"],),
            time_stamp_ns=self._time_stamp_ns_converter.from_json(json_object["timeStampNs"],),
            sample_time_ns=self._sample_time_ns_converter.from_json(json_object["sampleTimeNs"],),
            waveform_id=self._waveform_id_converter.from_json(json_object["waveformId"],),
            data=self._data_converter.from_json(json_object["data"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._flags_converter.from_json_to_numpy(json_object["flags"]),
            self._measurement_uid_converter.from_json_to_numpy(json_object["measurementUid"]),
            self._scan_counter_converter.from_json_to_numpy(json_object["scanCounter"]),
            self._time_stamp_ns_converter.from_json_to_numpy(json_object["timeStampNs"]),
            self._sample_time_ns_converter.from_json_to_numpy(json_object["sampleTimeNs"]),
            self._waveform_id_converter.from_json_to_numpy(json_object["waveformId"]),
            self._data_converter.from_json_to_numpy(json_object["data"]),
        ) # type:ignore 


class AcquisitionBucketConverter(_ndjson.JsonConverter[AcquisitionBucket, np.void]):
    def __init__(self) -> None:
        self._data_converter = _ndjson.VectorConverter(AcquisitionConverter())
        self._ref_converter = _ndjson.VectorConverter(AcquisitionConverter())
        self._datastats_converter = _ndjson.VectorConverter(EncodingLimitsTypeConverter())
        self._refstats_converter = _ndjson.VectorConverter(EncodingLimitsTypeConverter())
        self._waveforms_converter = _ndjson.VectorConverter(WaveformConverter(_ndjson.uint32_converter))
        super().__init__(np.dtype([
            ("data", self._data_converter.overall_dtype()),
            ("ref", self._ref_converter.overall_dtype()),
            ("datastats", self._datastats_converter.overall_dtype()),
            ("refstats", self._refstats_converter.overall_dtype()),
            ("waveforms", self._waveforms_converter.overall_dtype()),
        ]))

    def to_json(self, value: AcquisitionBucket) -> object:
        if not isinstance(value, AcquisitionBucket): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'AcquisitionBucket' instance")
        json_object = {}

        json_object["data"] = self._data_converter.to_json(value.data)
        json_object["ref"] = self._ref_converter.to_json(value.ref)
        json_object["datastats"] = self._datastats_converter.to_json(value.datastats)
        json_object["refstats"] = self._refstats_converter.to_json(value.refstats)
        json_object["waveforms"] = self._waveforms_converter.to_json(value.waveforms)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["data"] = self._data_converter.numpy_to_json(value["data"])
        json_object["ref"] = self._ref_converter.numpy_to_json(value["ref"])
        json_object["datastats"] = self._datastats_converter.numpy_to_json(value["datastats"])
        json_object["refstats"] = self._refstats_converter.numpy_to_json(value["refstats"])
        json_object["waveforms"] = self._waveforms_converter.numpy_to_json(value["waveforms"])
        return json_object

    def from_json(self, json_object: object) -> AcquisitionBucket:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return AcquisitionBucket(
            data=self._data_converter.from_json(json_object["data"],),
            ref=self._ref_converter.from_json(json_object["ref"],),
            datastats=self._datastats_converter.from_json(json_object["datastats"],),
            refstats=self._refstats_converter.from_json(json_object["refstats"],),
            waveforms=self._waveforms_converter.from_json(json_object["waveforms"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._data_converter.from_json_to_numpy(json_object["data"]),
            self._ref_converter.from_json_to_numpy(json_object["ref"]),
            self._datastats_converter.from_json_to_numpy(json_object["datastats"]),
            self._refstats_converter.from_json_to_numpy(json_object["refstats"]),
            self._waveforms_converter.from_json_to_numpy(json_object["waveforms"]),
        ) # type:ignore 


class SamplingLimitsConverter(_ndjson.JsonConverter[SamplingLimits, np.void]):
    def __init__(self) -> None:
        self._kspace_encoding_step_0_converter = LimitTypeConverter()
        self._kspace_encoding_step_1_converter = LimitTypeConverter()
        self._kspace_encoding_step_2_converter = LimitTypeConverter()
        super().__init__(np.dtype([
            ("kspace_encoding_step_0", self._kspace_encoding_step_0_converter.overall_dtype()),
            ("kspace_encoding_step_1", self._kspace_encoding_step_1_converter.overall_dtype()),
            ("kspace_encoding_step_2", self._kspace_encoding_step_2_converter.overall_dtype()),
        ]))

    def to_json(self, value: SamplingLimits) -> object:
        if not isinstance(value, SamplingLimits): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'SamplingLimits' instance")
        json_object = {}

        json_object["kspaceEncodingStep0"] = self._kspace_encoding_step_0_converter.to_json(value.kspace_encoding_step_0)
        json_object["kspaceEncodingStep1"] = self._kspace_encoding_step_1_converter.to_json(value.kspace_encoding_step_1)
        json_object["kspaceEncodingStep2"] = self._kspace_encoding_step_2_converter.to_json(value.kspace_encoding_step_2)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["kspaceEncodingStep0"] = self._kspace_encoding_step_0_converter.numpy_to_json(value["kspace_encoding_step_0"])
        json_object["kspaceEncodingStep1"] = self._kspace_encoding_step_1_converter.numpy_to_json(value["kspace_encoding_step_1"])
        json_object["kspaceEncodingStep2"] = self._kspace_encoding_step_2_converter.numpy_to_json(value["kspace_encoding_step_2"])
        return json_object

    def from_json(self, json_object: object) -> SamplingLimits:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return SamplingLimits(
            kspace_encoding_step_0=self._kspace_encoding_step_0_converter.from_json(json_object["kspaceEncodingStep0"],),
            kspace_encoding_step_1=self._kspace_encoding_step_1_converter.from_json(json_object["kspaceEncodingStep1"],),
            kspace_encoding_step_2=self._kspace_encoding_step_2_converter.from_json(json_object["kspaceEncodingStep2"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._kspace_encoding_step_0_converter.from_json_to_numpy(json_object["kspaceEncodingStep0"]),
            self._kspace_encoding_step_1_converter.from_json_to_numpy(json_object["kspaceEncodingStep1"]),
            self._kspace_encoding_step_2_converter.from_json_to_numpy(json_object["kspaceEncodingStep2"]),
        ) # type:ignore 


class SamplingDescriptionConverter(_ndjson.JsonConverter[SamplingDescription, np.void]):
    def __init__(self) -> None:
        self._encoded_fov_converter = FieldOfViewMmConverter()
        self._recon_fov_converter = FieldOfViewMmConverter()
        self._encoded_matrix_converter = MatrixSizeTypeConverter()
        self._recon_matrix_converter = MatrixSizeTypeConverter()
        self._sampling_limits_converter = SamplingLimitsConverter()
        super().__init__(np.dtype([
            ("encoded_fov", self._encoded_fov_converter.overall_dtype()),
            ("recon_fov", self._recon_fov_converter.overall_dtype()),
            ("encoded_matrix", self._encoded_matrix_converter.overall_dtype()),
            ("recon_matrix", self._recon_matrix_converter.overall_dtype()),
            ("sampling_limits", self._sampling_limits_converter.overall_dtype()),
        ]))

    def to_json(self, value: SamplingDescription) -> object:
        if not isinstance(value, SamplingDescription): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'SamplingDescription' instance")
        json_object = {}

        json_object["encodedFOV"] = self._encoded_fov_converter.to_json(value.encoded_fov)
        json_object["reconFOV"] = self._recon_fov_converter.to_json(value.recon_fov)
        json_object["encodedMatrix"] = self._encoded_matrix_converter.to_json(value.encoded_matrix)
        json_object["reconMatrix"] = self._recon_matrix_converter.to_json(value.recon_matrix)
        json_object["samplingLimits"] = self._sampling_limits_converter.to_json(value.sampling_limits)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["encodedFOV"] = self._encoded_fov_converter.numpy_to_json(value["encoded_fov"])
        json_object["reconFOV"] = self._recon_fov_converter.numpy_to_json(value["recon_fov"])
        json_object["encodedMatrix"] = self._encoded_matrix_converter.numpy_to_json(value["encoded_matrix"])
        json_object["reconMatrix"] = self._recon_matrix_converter.numpy_to_json(value["recon_matrix"])
        json_object["samplingLimits"] = self._sampling_limits_converter.numpy_to_json(value["sampling_limits"])
        return json_object

    def from_json(self, json_object: object) -> SamplingDescription:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return SamplingDescription(
            encoded_fov=self._encoded_fov_converter.from_json(json_object["encodedFOV"],),
            recon_fov=self._recon_fov_converter.from_json(json_object["reconFOV"],),
            encoded_matrix=self._encoded_matrix_converter.from_json(json_object["encodedMatrix"],),
            recon_matrix=self._recon_matrix_converter.from_json(json_object["reconMatrix"],),
            sampling_limits=self._sampling_limits_converter.from_json(json_object["samplingLimits"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._encoded_fov_converter.from_json_to_numpy(json_object["encodedFOV"]),
            self._recon_fov_converter.from_json_to_numpy(json_object["reconFOV"]),
            self._encoded_matrix_converter.from_json_to_numpy(json_object["encodedMatrix"]),
            self._recon_matrix_converter.from_json_to_numpy(json_object["reconMatrix"]),
            self._sampling_limits_converter.from_json_to_numpy(json_object["samplingLimits"]),
        ) # type:ignore 


class ReconBufferConverter(_ndjson.JsonConverter[ReconBuffer, np.void]):
    def __init__(self) -> None:
        self._data_converter = _ndjson.NDArrayConverter(_ndjson.complexfloat32_converter, 7)
        self._trajectory_converter = _ndjson.NDArrayConverter(_ndjson.float32_converter, 7)
        self._density_converter = _ndjson.OptionalConverter(_ndjson.NDArrayConverter(_ndjson.float32_converter, 6))
        self._headers_converter = _ndjson.NDArrayConverter(AcquisitionHeaderConverter(), 5)
        self._sampling_converter = SamplingDescriptionConverter()
        super().__init__(np.dtype([
            ("data", self._data_converter.overall_dtype()),
            ("trajectory", self._trajectory_converter.overall_dtype()),
            ("density", self._density_converter.overall_dtype()),
            ("headers", self._headers_converter.overall_dtype()),
            ("sampling", self._sampling_converter.overall_dtype()),
        ]))

    def to_json(self, value: ReconBuffer) -> object:
        if not isinstance(value, ReconBuffer): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'ReconBuffer' instance")
        json_object = {}

        json_object["data"] = self._data_converter.to_json(value.data)
        json_object["trajectory"] = self._trajectory_converter.to_json(value.trajectory)
        if value.density is not None:
            json_object["density"] = self._density_converter.to_json(value.density)
        json_object["headers"] = self._headers_converter.to_json(value.headers)
        json_object["sampling"] = self._sampling_converter.to_json(value.sampling)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["data"] = self._data_converter.numpy_to_json(value["data"])
        json_object["trajectory"] = self._trajectory_converter.numpy_to_json(value["trajectory"])
        if (field_val := value["density"]) is not None:
            json_object["density"] = self._density_converter.numpy_to_json(field_val)
        json_object["headers"] = self._headers_converter.numpy_to_json(value["headers"])
        json_object["sampling"] = self._sampling_converter.numpy_to_json(value["sampling"])
        return json_object

    def from_json(self, json_object: object) -> ReconBuffer:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return ReconBuffer(
            data=self._data_converter.from_json(json_object["data"],),
            trajectory=self._trajectory_converter.from_json(json_object["trajectory"],),
            density=self._density_converter.from_json(json_object.get("density")),
            headers=self._headers_converter.from_json(json_object["headers"],),
            sampling=self._sampling_converter.from_json(json_object["sampling"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._data_converter.from_json_to_numpy(json_object["data"]),
            self._trajectory_converter.from_json_to_numpy(json_object["trajectory"]),
            self._density_converter.from_json_to_numpy(json_object.get("density")),
            self._headers_converter.from_json_to_numpy(json_object["headers"]),
            self._sampling_converter.from_json_to_numpy(json_object["sampling"]),
        ) # type:ignore 


class ReconAssemblyConverter(_ndjson.JsonConverter[ReconAssembly, np.void]):
    def __init__(self) -> None:
        self._data_converter = ReconBufferConverter()
        self._ref_converter = _ndjson.OptionalConverter(ReconBufferConverter())
        super().__init__(np.dtype([
            ("data", self._data_converter.overall_dtype()),
            ("ref", self._ref_converter.overall_dtype()),
        ]))

    def to_json(self, value: ReconAssembly) -> object:
        if not isinstance(value, ReconAssembly): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'ReconAssembly' instance")
        json_object = {}

        json_object["data"] = self._data_converter.to_json(value.data)
        if value.ref is not None:
            json_object["ref"] = self._ref_converter.to_json(value.ref)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["data"] = self._data_converter.numpy_to_json(value["data"])
        if (field_val := value["ref"]) is not None:
            json_object["ref"] = self._ref_converter.numpy_to_json(field_val)
        return json_object

    def from_json(self, json_object: object) -> ReconAssembly:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return ReconAssembly(
            data=self._data_converter.from_json(json_object["data"],),
            ref=self._ref_converter.from_json(json_object.get("ref")),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._data_converter.from_json_to_numpy(json_object["data"]),
            self._ref_converter.from_json_to_numpy(json_object.get("ref")),
        ) # type:ignore 


class ReconDataConverter(_ndjson.JsonConverter[ReconData, np.void]):
    def __init__(self) -> None:
        self._buffers_converter = _ndjson.VectorConverter(ReconAssemblyConverter())
        super().__init__(np.dtype([
            ("buffers", self._buffers_converter.overall_dtype()),
        ]))

    def to_json(self, value: ReconData) -> object:
        if not isinstance(value, ReconData): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'ReconData' instance")
        json_object = {}

        json_object["buffers"] = self._buffers_converter.to_json(value.buffers)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["buffers"] = self._buffers_converter.numpy_to_json(value["buffers"])
        return json_object

    def from_json(self, json_object: object) -> ReconData:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return ReconData(
            buffers=self._buffers_converter.from_json(json_object["buffers"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._buffers_converter.from_json_to_numpy(json_object["buffers"]),
        ) # type:ignore 


class ImageArrayConverter(_ndjson.JsonConverter[ImageArray, np.void]):
    def __init__(self) -> None:
        self._data_converter = _ndjson.NDArrayConverter(_ndjson.complexfloat32_converter, 7)
        self._headers_converter = _ndjson.NDArrayConverter(ImageHeaderConverter(), 3)
        self._meta_converter = _ndjson.NDArrayConverter(_ndjson.MapConverter(_ndjson.string_converter, _ndjson.VectorConverter(_ndjson.UnionConverter(ImageMetaValue, [(ImageMetaValue.String, _ndjson.string_converter, [str]), (ImageMetaValue.Int64, _ndjson.int64_converter, [int, float]), (ImageMetaValue.Float64, _ndjson.float64_converter, [int, float])], False))), 3)
        self._waveforms_converter = _ndjson.VectorConverter(WaveformConverter(_ndjson.uint32_converter))
        super().__init__(np.dtype([
            ("data", self._data_converter.overall_dtype()),
            ("headers", self._headers_converter.overall_dtype()),
            ("meta", self._meta_converter.overall_dtype()),
            ("waveforms", self._waveforms_converter.overall_dtype()),
        ]))

    def to_json(self, value: ImageArray) -> object:
        if not isinstance(value, ImageArray): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'ImageArray' instance")
        json_object = {}

        json_object["data"] = self._data_converter.to_json(value.data)
        json_object["headers"] = self._headers_converter.to_json(value.headers)
        json_object["meta"] = self._meta_converter.to_json(value.meta)
        json_object["waveforms"] = self._waveforms_converter.to_json(value.waveforms)
        return json_object

    def numpy_to_json(self, value: np.void) -> object:
        if not isinstance(value, np.void): # pyright: ignore [reportUnnecessaryIsInstance]
            raise TypeError("Expected 'np.void' instance")
        json_object = {}

        json_object["data"] = self._data_converter.numpy_to_json(value["data"])
        json_object["headers"] = self._headers_converter.numpy_to_json(value["headers"])
        json_object["meta"] = self._meta_converter.numpy_to_json(value["meta"])
        json_object["waveforms"] = self._waveforms_converter.numpy_to_json(value["waveforms"])
        return json_object

    def from_json(self, json_object: object) -> ImageArray:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return ImageArray(
            data=self._data_converter.from_json(json_object["data"],),
            headers=self._headers_converter.from_json(json_object["headers"],),
            meta=self._meta_converter.from_json(json_object["meta"],),
            waveforms=self._waveforms_converter.from_json(json_object["waveforms"],),
        )

    def from_json_to_numpy(self, json_object: object) -> np.void:
        if not isinstance(json_object, dict):
            raise TypeError("Expected 'dict' instance")
        return (
            self._data_converter.from_json_to_numpy(json_object["data"]),
            self._headers_converter.from_json_to_numpy(json_object["headers"]),
            self._meta_converter.from_json_to_numpy(json_object["meta"]),
            self._waveforms_converter.from_json_to_numpy(json_object["waveforms"]),
        ) # type:ignore 


class NDJsonMrdWriter(_ndjson.NDJsonProtocolWriter, MrdWriterBase):
    """NDJson writer for the Mrd protocol.

    The MRD Protocol
    """


    def __init__(self, stream: typing.Union[typing.TextIO, str]) -> None:
        MrdWriterBase.__init__(self)
        _ndjson.NDJsonProtocolWriter.__init__(self, stream, MrdWriterBase.schema)

    def _write_header(self, value: typing.Optional[Header]) -> None:
        converter = _ndjson.OptionalConverter(HeaderConverter())
        json_value = converter.to_json(value)
        self._write_json_line({"header": json_value})

    def _write_data(self, value: collections.abc.Iterable[StreamItem]) -> None:
        converter = _ndjson.UnionConverter(StreamItem, [(StreamItem.Acquisition, AcquisitionConverter(), [dict]), (StreamItem.WaveformUint32, WaveformConverter(_ndjson.uint32_converter), [dict]), (StreamItem.ImageUint16, ImageConverter(_ndjson.uint16_converter), [dict]), (StreamItem.ImageInt16, ImageConverter(_ndjson.int16_converter), [dict]), (StreamItem.ImageUint32, ImageConverter(_ndjson.uint32_converter), [dict]), (StreamItem.ImageInt32, ImageConverter(_ndjson.int32_converter), [dict]), (StreamItem.ImageFloat, ImageConverter(_ndjson.float32_converter), [dict]), (StreamItem.ImageDouble, ImageConverter(_ndjson.float64_converter), [dict]), (StreamItem.ImageComplexFloat, ImageConverter(_ndjson.complexfloat32_converter), [dict]), (StreamItem.ImageComplexDouble, ImageConverter(_ndjson.complexfloat64_converter), [dict]), (StreamItem.AcquisitionBucket, AcquisitionBucketConverter(), [dict]), (StreamItem.ReconData, ReconDataConverter(), [dict]), (StreamItem.ArrayComplexFloat, _ndjson.DynamicNDArrayConverter(_ndjson.complexfloat32_converter), [dict]), (StreamItem.ImageArray, ImageArrayConverter(), [dict])], False)
        for item in value:
            json_item = converter.to_json(item)
            self._write_json_line({"data": json_item})


class NDJsonMrdReader(_ndjson.NDJsonProtocolReader, MrdReaderBase):
    """NDJson writer for the Mrd protocol.

    The MRD Protocol
    """


    def __init__(self, stream: typing.Union[io.BufferedReader, typing.TextIO, str], skip_completed_check: bool = False) -> None:
        MrdReaderBase.__init__(self, skip_completed_check)
        _ndjson.NDJsonProtocolReader.__init__(self, stream, MrdReaderBase.schema)

    def _read_header(self) -> typing.Optional[Header]:
        json_object = self._read_json_line("header", True)
        converter = _ndjson.OptionalConverter(HeaderConverter())
        return converter.from_json(json_object)

    def _read_data(self) -> collections.abc.Iterable[StreamItem]:
        converter = _ndjson.UnionConverter(StreamItem, [(StreamItem.Acquisition, AcquisitionConverter(), [dict]), (StreamItem.WaveformUint32, WaveformConverter(_ndjson.uint32_converter), [dict]), (StreamItem.ImageUint16, ImageConverter(_ndjson.uint16_converter), [dict]), (StreamItem.ImageInt16, ImageConverter(_ndjson.int16_converter), [dict]), (StreamItem.ImageUint32, ImageConverter(_ndjson.uint32_converter), [dict]), (StreamItem.ImageInt32, ImageConverter(_ndjson.int32_converter), [dict]), (StreamItem.ImageFloat, ImageConverter(_ndjson.float32_converter), [dict]), (StreamItem.ImageDouble, ImageConverter(_ndjson.float64_converter), [dict]), (StreamItem.ImageComplexFloat, ImageConverter(_ndjson.complexfloat32_converter), [dict]), (StreamItem.ImageComplexDouble, ImageConverter(_ndjson.complexfloat64_converter), [dict]), (StreamItem.AcquisitionBucket, AcquisitionBucketConverter(), [dict]), (StreamItem.ReconData, ReconDataConverter(), [dict]), (StreamItem.ArrayComplexFloat, _ndjson.DynamicNDArrayConverter(_ndjson.complexfloat32_converter), [dict]), (StreamItem.ImageArray, ImageArrayConverter(), [dict])], False)
        while (json_object := self._read_json_line("data", False)) is not _ndjson.MISSING_SENTINEL:
            yield converter.from_json(json_object)

class NDJsonMrdNoiseCovarianceWriter(_ndjson.NDJsonProtocolWriter, MrdNoiseCovarianceWriterBase):
    """NDJson writer for the MrdNoiseCovariance protocol.

    Protocol for serializing a noise covariance matrix
    """


    def __init__(self, stream: typing.Union[typing.TextIO, str]) -> None:
        MrdNoiseCovarianceWriterBase.__init__(self)
        _ndjson.NDJsonProtocolWriter.__init__(self, stream, MrdNoiseCovarianceWriterBase.schema)

    def _write_noise_covariance(self, value: NoiseCovariance) -> None:
        converter = NoiseCovarianceConverter()
        json_value = converter.to_json(value)
        self._write_json_line({"noiseCovariance": json_value})


class NDJsonMrdNoiseCovarianceReader(_ndjson.NDJsonProtocolReader, MrdNoiseCovarianceReaderBase):
    """NDJson writer for the MrdNoiseCovariance protocol.

    Protocol for serializing a noise covariance matrix
    """


    def __init__(self, stream: typing.Union[io.BufferedReader, typing.TextIO, str], skip_completed_check: bool = False) -> None:
        MrdNoiseCovarianceReaderBase.__init__(self, skip_completed_check)
        _ndjson.NDJsonProtocolReader.__init__(self, stream, MrdNoiseCovarianceReaderBase.schema)

    def _read_noise_covariance(self) -> NoiseCovariance:
        json_object = self._read_json_line("noiseCovariance", True)
        converter = NoiseCovarianceConverter()
        return converter.from_json(json_object)

