# This file was generated by the "yardl" tool. DO NOT EDIT.

# pyright: reportUnusedImport=false
# pyright: reportUnknownArgumentType=false
# pyright: reportUnknownMemberType=false
# pyright: reportUnknownVariableType=false

import datetime
import enum
import types
import typing

import numpy as np
import numpy.typing as npt

from . import yardl_types as yardl
from . import _dtypes


Y = typing.TypeVar("Y")
Y_NP = typing.TypeVar("Y_NP", bound=np.generic)
T = typing.TypeVar("T")
T_NP = typing.TypeVar("T_NP", bound=np.generic)


class AcquisitionFlags(enum.IntFlag):
    FIRST_IN_ENCODE_STEP_1 = 1
    LAST_IN_ENCODE_STEP_1 = 2
    FIRST_IN_ENCODE_STEP_2 = 4
    LAST_IN_ENCODE_STEP_2 = 8
    FIRST_IN_AVERAGE = 16
    LAST_IN_AVERAGE = 32
    FIRST_IN_SLICE = 64
    LAST_IN_SLICE = 128
    FIRST_IN_CONTRAST = 256
    LAST_IN_CONTRAST = 512
    FIRST_IN_PHASE = 1024
    LAST_IN_PHASE = 2048
    FIRST_IN_REPETITION = 4096
    LAST_IN_REPETITION = 8192
    FIRST_IN_SET = 16384
    LAST_IN_SET = 32768
    FIRST_IN_SEGMENT = 65536
    LAST_IN_SEGMENT = 131072
    IS_NOISE_MEASUREMENT = 262144
    IS_PARALLEL_CALIBRATION = 524288
    IS_PARALLEL_CALIBRATION_AND_IMAGING = 1048576
    IS_REVERSE = 2097152
    IS_NAVIGATION_DATA = 4194304
    IS_PHASECORR_DATA = 8388608
    LAST_IN_MEASUREMENT = 16777216
    IS_HPFEEDBACK_DATA = 33554432
    IS_DUMMYSCAN_DATA = 67108864
    IS_RTFEEDBACK_DATA = 134217728
    IS_SURFACECOILCORRECTIONSCAN_DATA = 268435456
    IS_PHASE_STABILIZATION_REFERENCE = 536870912
    IS_PHASE_STABILIZATION = 1073741824

    def __eq__(self, other: object) -> bool:
        return isinstance(other, AcquisitionFlags) and self.value == other.value

    def __hash__(self) -> int:
        return hash(self.value)

    __str__ = enum.Flag.__str__ # type: ignore

class EncodingCounters:
    kspace_encode_step_1: typing.Optional[yardl.UInt32]
    """Phase encoding line"""

    kspace_encode_step_2: typing.Optional[yardl.UInt32]
    """Partition encoding"""

    average: typing.Optional[yardl.UInt32]
    """Signal average"""

    slice: typing.Optional[yardl.UInt32]
    """Slice number (multi-slice 2D)"""

    contrast: typing.Optional[yardl.UInt32]
    """Echo number in multi-echo"""

    phase: typing.Optional[yardl.UInt32]
    """Cardiac phase"""

    repetition: typing.Optional[yardl.UInt32]
    """Counter in repeated/dynamic acquisitions"""

    set: typing.Optional[yardl.UInt32]
    """Sets of different preparation, e.g. flow encoding, diffusion weighting"""

    segment: typing.Optional[yardl.UInt32]
    """Counter for segmented acquisitions"""

    user: list[yardl.UInt32]
    """User-defined counters"""


    def __init__(self, *,
        kspace_encode_step_1: typing.Optional[yardl.UInt32] = None,
        kspace_encode_step_2: typing.Optional[yardl.UInt32] = None,
        average: typing.Optional[yardl.UInt32] = None,
        slice: typing.Optional[yardl.UInt32] = None,
        contrast: typing.Optional[yardl.UInt32] = None,
        phase: typing.Optional[yardl.UInt32] = None,
        repetition: typing.Optional[yardl.UInt32] = None,
        set: typing.Optional[yardl.UInt32] = None,
        segment: typing.Optional[yardl.UInt32] = None,
        user: typing.Optional[list[yardl.UInt32]] = None,
    ):
        self.kspace_encode_step_1 = kspace_encode_step_1
        self.kspace_encode_step_2 = kspace_encode_step_2
        self.average = average
        self.slice = slice
        self.contrast = contrast
        self.phase = phase
        self.repetition = repetition
        self.set = set
        self.segment = segment
        self.user = user if user is not None else []

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, EncodingCounters)
            and self.kspace_encode_step_1 == other.kspace_encode_step_1
            and self.kspace_encode_step_2 == other.kspace_encode_step_2
            and self.average == other.average
            and self.slice == other.slice
            and self.contrast == other.contrast
            and self.phase == other.phase
            and self.repetition == other.repetition
            and self.set == other.set
            and self.segment == other.segment
            and self.user == other.user
        )

    def __str__(self) -> str:
        return f"EncodingCounters(kspace_encode_step_1={self.kspace_encode_step_1}, kspace_encode_step_2={self.kspace_encode_step_2}, average={self.average}, slice={self.slice}, contrast={self.contrast}, phase={self.phase}, repetition={self.repetition}, set={self.set}, segment={self.segment}, user={self.user})"

    def __repr__(self) -> str:
        return f"EncodingCounters(kspace_encode_step_1={repr(self.kspace_encode_step_1)}, kspace_encode_step_2={repr(self.kspace_encode_step_2)}, average={repr(self.average)}, slice={repr(self.slice)}, contrast={repr(self.contrast)}, phase={repr(self.phase)}, repetition={repr(self.repetition)}, set={repr(self.set)}, segment={repr(self.segment)}, user={repr(self.user)})"


AcquisitionData = npt.NDArray[np.complex64]

TrajectoryData = npt.NDArray[np.float32]

class AcquisitionHeader:
    flags: AcquisitionFlags
    """A bit mask of common attributes applicable to individual acquisition"""

    idx: EncodingCounters
    """Encoding loop counters"""

    measurement_uid: yardl.UInt32
    """Unique ID corresponding to the readout"""

    scan_counter: typing.Optional[yardl.UInt32]
    """Zero-indexed incrementing counter for readouts"""

    acquisition_time_stamp_ns: typing.Optional[yardl.UInt64]
    """Clock time stamp (e.g. nanoseconds since midnight)"""

    physiology_time_stamp_ns: list[yardl.UInt64]
    """Time stamps relative to physiological triggering in nanoseconds"""

    channel_order: list[yardl.UInt32]
    """Channel numbers"""

    discard_pre: typing.Optional[yardl.UInt32]
    """Number of readout samples to be discarded at the beginning
      (e.g. if the ADC is active during gradient events)
    """

    discard_post: typing.Optional[yardl.UInt32]
    """Number of readout samples to be discarded at the end
      (e.g. if the ADC is active during gradient events)
    """

    center_sample: typing.Optional[yardl.UInt32]
    """Index of the readout sample corresponing to k-space center (zero indexed)"""

    encoding_space_ref: typing.Optional[yardl.UInt32]
    """Indexed reference to the encoding spaces enumerated in the MRD Header"""

    sample_time_ns: typing.Optional[yardl.UInt64]
    """Readout bandwidth, as time between samples in nanoseconds"""

    position: npt.NDArray[np.float32]
    """Center of the excited volume, in LPS coordinates relative to isocenter in millimeters"""

    read_dir: npt.NDArray[np.float32]
    """Directional cosine of readout/frequency encoding"""

    phase_dir: npt.NDArray[np.float32]
    """Directional cosine of phase encoding (2D)"""

    slice_dir: npt.NDArray[np.float32]
    """Directional cosine of slice normal, i.e. cross-product of read_dir and phase_dir"""

    patient_table_position: npt.NDArray[np.float32]
    """Offset position of the patient table, in LPS coordinates"""

    user_int: list[yardl.Int32]
    """User-defined integer parameters"""

    user_float: list[yardl.Float32]
    """User-defined float parameters"""


    def __init__(self, *,
        flags: AcquisitionFlags = AcquisitionFlags(0),
        idx: typing.Optional[EncodingCounters] = None,
        measurement_uid: yardl.UInt32 = 0,
        scan_counter: typing.Optional[yardl.UInt32] = None,
        acquisition_time_stamp_ns: typing.Optional[yardl.UInt64] = None,
        physiology_time_stamp_ns: typing.Optional[list[yardl.UInt64]] = None,
        channel_order: typing.Optional[list[yardl.UInt32]] = None,
        discard_pre: typing.Optional[yardl.UInt32] = None,
        discard_post: typing.Optional[yardl.UInt32] = None,
        center_sample: typing.Optional[yardl.UInt32] = None,
        encoding_space_ref: typing.Optional[yardl.UInt32] = None,
        sample_time_ns: typing.Optional[yardl.UInt64] = None,
        position: typing.Optional[npt.NDArray[np.float32]] = None,
        read_dir: typing.Optional[npt.NDArray[np.float32]] = None,
        phase_dir: typing.Optional[npt.NDArray[np.float32]] = None,
        slice_dir: typing.Optional[npt.NDArray[np.float32]] = None,
        patient_table_position: typing.Optional[npt.NDArray[np.float32]] = None,
        user_int: typing.Optional[list[yardl.Int32]] = None,
        user_float: typing.Optional[list[yardl.Float32]] = None,
    ):
        self.flags = flags
        self.idx = idx if idx is not None else EncodingCounters()
        self.measurement_uid = measurement_uid
        self.scan_counter = scan_counter
        self.acquisition_time_stamp_ns = acquisition_time_stamp_ns
        self.physiology_time_stamp_ns = physiology_time_stamp_ns if physiology_time_stamp_ns is not None else []
        self.channel_order = channel_order if channel_order is not None else []
        self.discard_pre = discard_pre
        self.discard_post = discard_post
        self.center_sample = center_sample
        self.encoding_space_ref = encoding_space_ref
        self.sample_time_ns = sample_time_ns
        self.position = position if position is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.read_dir = read_dir if read_dir is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.phase_dir = phase_dir if phase_dir is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.slice_dir = slice_dir if slice_dir is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.patient_table_position = patient_table_position if patient_table_position is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.user_int = user_int if user_int is not None else []
        self.user_float = user_float if user_float is not None else []

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, AcquisitionHeader)
            and self.flags == other.flags
            and self.idx == other.idx
            and self.measurement_uid == other.measurement_uid
            and self.scan_counter == other.scan_counter
            and self.acquisition_time_stamp_ns == other.acquisition_time_stamp_ns
            and self.physiology_time_stamp_ns == other.physiology_time_stamp_ns
            and self.channel_order == other.channel_order
            and self.discard_pre == other.discard_pre
            and self.discard_post == other.discard_post
            and self.center_sample == other.center_sample
            and self.encoding_space_ref == other.encoding_space_ref
            and self.sample_time_ns == other.sample_time_ns
            and yardl.structural_equal(self.position, other.position)
            and yardl.structural_equal(self.read_dir, other.read_dir)
            and yardl.structural_equal(self.phase_dir, other.phase_dir)
            and yardl.structural_equal(self.slice_dir, other.slice_dir)
            and yardl.structural_equal(self.patient_table_position, other.patient_table_position)
            and self.user_int == other.user_int
            and self.user_float == other.user_float
        )

    def __str__(self) -> str:
        return f"AcquisitionHeader(flags={self.flags}, idx={self.idx}, measurement_uid={self.measurement_uid}, scan_counter={self.scan_counter}, acquisition_time_stamp_ns={self.acquisition_time_stamp_ns}, physiology_time_stamp_ns={self.physiology_time_stamp_ns}, channel_order={self.channel_order}, discard_pre={self.discard_pre}, discard_post={self.discard_post}, center_sample={self.center_sample}, encoding_space_ref={self.encoding_space_ref}, sample_time_ns={self.sample_time_ns}, position={self.position}, read_dir={self.read_dir}, phase_dir={self.phase_dir}, slice_dir={self.slice_dir}, patient_table_position={self.patient_table_position}, user_int={self.user_int}, user_float={self.user_float})"

    def __repr__(self) -> str:
        return f"AcquisitionHeader(flags={repr(self.flags)}, idx={repr(self.idx)}, measurement_uid={repr(self.measurement_uid)}, scan_counter={repr(self.scan_counter)}, acquisition_time_stamp_ns={repr(self.acquisition_time_stamp_ns)}, physiology_time_stamp_ns={repr(self.physiology_time_stamp_ns)}, channel_order={repr(self.channel_order)}, discard_pre={repr(self.discard_pre)}, discard_post={repr(self.discard_post)}, center_sample={repr(self.center_sample)}, encoding_space_ref={repr(self.encoding_space_ref)}, sample_time_ns={repr(self.sample_time_ns)}, position={repr(self.position)}, read_dir={repr(self.read_dir)}, phase_dir={repr(self.phase_dir)}, slice_dir={repr(self.slice_dir)}, patient_table_position={repr(self.patient_table_position)}, user_int={repr(self.user_int)}, user_float={repr(self.user_float)})"


class Acquisition:
    head: AcquisitionHeader
    """Acquisition header"""

    data: AcquisitionData
    """Raw k-space samples array"""

    trajectory: TrajectoryData
    """Trajectory array"""


    def __init__(self, *,
        head: typing.Optional[AcquisitionHeader] = None,
        data: typing.Optional[AcquisitionData] = None,
        trajectory: typing.Optional[TrajectoryData] = None,
    ):
        self.head = head if head is not None else AcquisitionHeader()
        self.data = data if data is not None else np.zeros((0, 0), dtype=np.dtype(np.complex64))
        self.trajectory = trajectory if trajectory is not None else np.zeros((0, 0), dtype=np.dtype(np.float32))

    def coils(self) -> yardl.Size:
        return self.data.shape[0]

    def samples(self) -> yardl.Size:
        return self.data.shape[1]

    def active_channels(self) -> yardl.Size:
        return len(self.head.channel_order)

    def trajectory_dimensions(self) -> yardl.Size:
        return self.trajectory.shape[0]

    def trajectory_samples(self) -> yardl.Size:
        return self.trajectory.shape[1]

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, Acquisition)
            and self.head == other.head
            and yardl.structural_equal(self.data, other.data)
            and yardl.structural_equal(self.trajectory, other.trajectory)
        )

    def __str__(self) -> str:
        return f"Acquisition(head={self.head}, data={self.data}, trajectory={self.trajectory})"

    def __repr__(self) -> str:
        return f"Acquisition(head={repr(self.head)}, data={repr(self.data)}, trajectory={repr(self.trajectory)})"


class PatientGender(yardl.OutOfRangeEnum):
    M = 0
    F = 1
    O = 2

class SubjectInformationType:
    patient_name: typing.Optional[str]
    patient_weight_kg: typing.Optional[yardl.Float32]
    patient_height_m: typing.Optional[yardl.Float32]
    patient_id: typing.Optional[str]
    patient_birthdate: typing.Optional[datetime.date]
    patient_gender: typing.Optional[PatientGender]

    def __init__(self, *,
        patient_name: typing.Optional[str] = None,
        patient_weight_kg: typing.Optional[yardl.Float32] = None,
        patient_height_m: typing.Optional[yardl.Float32] = None,
        patient_id: typing.Optional[str] = None,
        patient_birthdate: typing.Optional[datetime.date] = None,
        patient_gender: typing.Optional[PatientGender] = None,
    ):
        self.patient_name = patient_name
        self.patient_weight_kg = patient_weight_kg
        self.patient_height_m = patient_height_m
        self.patient_id = patient_id
        self.patient_birthdate = patient_birthdate
        self.patient_gender = patient_gender

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, SubjectInformationType)
            and self.patient_name == other.patient_name
            and self.patient_weight_kg == other.patient_weight_kg
            and self.patient_height_m == other.patient_height_m
            and self.patient_id == other.patient_id
            and self.patient_birthdate == other.patient_birthdate
            and self.patient_gender == other.patient_gender
        )

    def __str__(self) -> str:
        return f"SubjectInformationType(patient_name={self.patient_name}, patient_weight_kg={self.patient_weight_kg}, patient_height_m={self.patient_height_m}, patient_id={self.patient_id}, patient_birthdate={self.patient_birthdate}, patient_gender={self.patient_gender})"

    def __repr__(self) -> str:
        return f"SubjectInformationType(patient_name={repr(self.patient_name)}, patient_weight_kg={repr(self.patient_weight_kg)}, patient_height_m={repr(self.patient_height_m)}, patient_id={repr(self.patient_id)}, patient_birthdate={repr(self.patient_birthdate)}, patient_gender={repr(self.patient_gender)})"


class StudyInformationType:
    study_date: typing.Optional[datetime.date]
    study_time: typing.Optional[yardl.Time]
    study_id: typing.Optional[str]
    accession_number: typing.Optional[yardl.Int64]
    referring_physician_name: typing.Optional[str]
    study_description: typing.Optional[str]
    study_instance_uid: typing.Optional[str]
    body_part_examined: typing.Optional[str]

    def __init__(self, *,
        study_date: typing.Optional[datetime.date] = None,
        study_time: typing.Optional[yardl.Time] = None,
        study_id: typing.Optional[str] = None,
        accession_number: typing.Optional[yardl.Int64] = None,
        referring_physician_name: typing.Optional[str] = None,
        study_description: typing.Optional[str] = None,
        study_instance_uid: typing.Optional[str] = None,
        body_part_examined: typing.Optional[str] = None,
    ):
        self.study_date = study_date
        self.study_time = study_time
        self.study_id = study_id
        self.accession_number = accession_number
        self.referring_physician_name = referring_physician_name
        self.study_description = study_description
        self.study_instance_uid = study_instance_uid
        self.body_part_examined = body_part_examined

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, StudyInformationType)
            and self.study_date == other.study_date
            and self.study_time == other.study_time
            and self.study_id == other.study_id
            and self.accession_number == other.accession_number
            and self.referring_physician_name == other.referring_physician_name
            and self.study_description == other.study_description
            and self.study_instance_uid == other.study_instance_uid
            and self.body_part_examined == other.body_part_examined
        )

    def __str__(self) -> str:
        return f"StudyInformationType(study_date={self.study_date}, study_time={self.study_time}, study_id={self.study_id}, accession_number={self.accession_number}, referring_physician_name={self.referring_physician_name}, study_description={self.study_description}, study_instance_uid={self.study_instance_uid}, body_part_examined={self.body_part_examined})"

    def __repr__(self) -> str:
        return f"StudyInformationType(study_date={repr(self.study_date)}, study_time={repr(self.study_time)}, study_id={repr(self.study_id)}, accession_number={repr(self.accession_number)}, referring_physician_name={repr(self.referring_physician_name)}, study_description={repr(self.study_description)}, study_instance_uid={repr(self.study_instance_uid)}, body_part_examined={repr(self.body_part_examined)})"


class PatientPosition(yardl.OutOfRangeEnum):
    H_FP = 0
    H_FS = 1
    H_FDR = 2
    H_FDL = 3
    F_FP = 4
    F_FS = 5
    F_FDR = 6
    F_FDL = 7

class ThreeDimensionalFloat:
    x: yardl.Float32
    y: yardl.Float32
    z: yardl.Float32

    def __init__(self, *,
        x: yardl.Float32 = 0.0,
        y: yardl.Float32 = 0.0,
        z: yardl.Float32 = 0.0,
    ):
        self.x = x
        self.y = y
        self.z = z

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, ThreeDimensionalFloat)
            and self.x == other.x
            and self.y == other.y
            and self.z == other.z
        )

    def __str__(self) -> str:
        return f"ThreeDimensionalFloat(x={self.x}, y={self.y}, z={self.z})"

    def __repr__(self) -> str:
        return f"ThreeDimensionalFloat(x={repr(self.x)}, y={repr(self.y)}, z={repr(self.z)})"


class MeasurementDependencyType:
    dependency_type: str
    measurement_id: str

    def __init__(self, *,
        dependency_type: str = "",
        measurement_id: str = "",
    ):
        self.dependency_type = dependency_type
        self.measurement_id = measurement_id

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, MeasurementDependencyType)
            and self.dependency_type == other.dependency_type
            and self.measurement_id == other.measurement_id
        )

    def __str__(self) -> str:
        return f"MeasurementDependencyType(dependency_type={self.dependency_type}, measurement_id={self.measurement_id})"

    def __repr__(self) -> str:
        return f"MeasurementDependencyType(dependency_type={repr(self.dependency_type)}, measurement_id={repr(self.measurement_id)})"


class ReferencedImageSequenceType:
    referenced_sop_instance_uid: list[str]

    def __init__(self, *,
        referenced_sop_instance_uid: typing.Optional[list[str]] = None,
    ):
        self.referenced_sop_instance_uid = referenced_sop_instance_uid if referenced_sop_instance_uid is not None else []

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, ReferencedImageSequenceType)
            and self.referenced_sop_instance_uid == other.referenced_sop_instance_uid
        )

    def __str__(self) -> str:
        return f"ReferencedImageSequenceType(referenced_sop_instance_uid={self.referenced_sop_instance_uid})"

    def __repr__(self) -> str:
        return f"ReferencedImageSequenceType(referenced_sop_instance_uid={repr(self.referenced_sop_instance_uid)})"


class MeasurementInformationType:
    measurement_id: typing.Optional[str]
    series_date: typing.Optional[datetime.date]
    series_time: typing.Optional[yardl.Time]
    patient_position: PatientPosition
    relative_table_position: typing.Optional[ThreeDimensionalFloat]
    initial_series_number: typing.Optional[yardl.Int64]
    protocol_name: typing.Optional[str]
    sequence_name: typing.Optional[str]
    series_description: typing.Optional[str]
    measurement_dependency: list[MeasurementDependencyType]
    series_instance_uid_root: typing.Optional[str]
    frame_of_reference_uid: typing.Optional[str]
    referenced_image_sequence: typing.Optional[ReferencedImageSequenceType]

    def __init__(self, *,
        measurement_id: typing.Optional[str] = None,
        series_date: typing.Optional[datetime.date] = None,
        series_time: typing.Optional[yardl.Time] = None,
        patient_position: PatientPosition = PatientPosition.H_FP,
        relative_table_position: typing.Optional[ThreeDimensionalFloat] = None,
        initial_series_number: typing.Optional[yardl.Int64] = None,
        protocol_name: typing.Optional[str] = None,
        sequence_name: typing.Optional[str] = None,
        series_description: typing.Optional[str] = None,
        measurement_dependency: typing.Optional[list[MeasurementDependencyType]] = None,
        series_instance_uid_root: typing.Optional[str] = None,
        frame_of_reference_uid: typing.Optional[str] = None,
        referenced_image_sequence: typing.Optional[ReferencedImageSequenceType] = None,
    ):
        self.measurement_id = measurement_id
        self.series_date = series_date
        self.series_time = series_time
        self.patient_position = patient_position
        self.relative_table_position = relative_table_position
        self.initial_series_number = initial_series_number
        self.protocol_name = protocol_name
        self.sequence_name = sequence_name
        self.series_description = series_description
        self.measurement_dependency = measurement_dependency if measurement_dependency is not None else []
        self.series_instance_uid_root = series_instance_uid_root
        self.frame_of_reference_uid = frame_of_reference_uid
        self.referenced_image_sequence = referenced_image_sequence

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, MeasurementInformationType)
            and self.measurement_id == other.measurement_id
            and self.series_date == other.series_date
            and self.series_time == other.series_time
            and self.patient_position == other.patient_position
            and self.relative_table_position == other.relative_table_position
            and self.initial_series_number == other.initial_series_number
            and self.protocol_name == other.protocol_name
            and self.sequence_name == other.sequence_name
            and self.series_description == other.series_description
            and self.measurement_dependency == other.measurement_dependency
            and self.series_instance_uid_root == other.series_instance_uid_root
            and self.frame_of_reference_uid == other.frame_of_reference_uid
            and self.referenced_image_sequence == other.referenced_image_sequence
        )

    def __str__(self) -> str:
        return f"MeasurementInformationType(measurement_id={self.measurement_id}, series_date={self.series_date}, series_time={self.series_time}, patient_position={self.patient_position}, relative_table_position={self.relative_table_position}, initial_series_number={self.initial_series_number}, protocol_name={self.protocol_name}, sequence_name={self.sequence_name}, series_description={self.series_description}, measurement_dependency={self.measurement_dependency}, series_instance_uid_root={self.series_instance_uid_root}, frame_of_reference_uid={self.frame_of_reference_uid}, referenced_image_sequence={self.referenced_image_sequence})"

    def __repr__(self) -> str:
        return f"MeasurementInformationType(measurement_id={repr(self.measurement_id)}, series_date={repr(self.series_date)}, series_time={repr(self.series_time)}, patient_position={repr(self.patient_position)}, relative_table_position={repr(self.relative_table_position)}, initial_series_number={repr(self.initial_series_number)}, protocol_name={repr(self.protocol_name)}, sequence_name={repr(self.sequence_name)}, series_description={repr(self.series_description)}, measurement_dependency={repr(self.measurement_dependency)}, series_instance_uid_root={repr(self.series_instance_uid_root)}, frame_of_reference_uid={repr(self.frame_of_reference_uid)}, referenced_image_sequence={repr(self.referenced_image_sequence)})"


class CoilLabelType:
    coil_number: yardl.UInt32
    coil_name: str

    def __init__(self, *,
        coil_number: yardl.UInt32 = 0,
        coil_name: str = "",
    ):
        self.coil_number = coil_number
        self.coil_name = coil_name

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, CoilLabelType)
            and self.coil_number == other.coil_number
            and self.coil_name == other.coil_name
        )

    def __str__(self) -> str:
        return f"CoilLabelType(coil_number={self.coil_number}, coil_name={self.coil_name})"

    def __repr__(self) -> str:
        return f"CoilLabelType(coil_number={repr(self.coil_number)}, coil_name={repr(self.coil_name)})"


class AcquisitionSystemInformationType:
    system_vendor: typing.Optional[str]
    system_model: typing.Optional[str]
    system_field_strength_t: typing.Optional[yardl.Float32]
    relative_receiver_noise_bandwidth: typing.Optional[yardl.Float32]
    receiver_channels: typing.Optional[yardl.UInt32]
    coil_label: list[CoilLabelType]
    institution_name: typing.Optional[str]
    station_name: typing.Optional[str]
    device_id: typing.Optional[str]
    device_serial_number: typing.Optional[str]

    def __init__(self, *,
        system_vendor: typing.Optional[str] = None,
        system_model: typing.Optional[str] = None,
        system_field_strength_t: typing.Optional[yardl.Float32] = None,
        relative_receiver_noise_bandwidth: typing.Optional[yardl.Float32] = None,
        receiver_channels: typing.Optional[yardl.UInt32] = None,
        coil_label: typing.Optional[list[CoilLabelType]] = None,
        institution_name: typing.Optional[str] = None,
        station_name: typing.Optional[str] = None,
        device_id: typing.Optional[str] = None,
        device_serial_number: typing.Optional[str] = None,
    ):
        self.system_vendor = system_vendor
        self.system_model = system_model
        self.system_field_strength_t = system_field_strength_t
        self.relative_receiver_noise_bandwidth = relative_receiver_noise_bandwidth
        self.receiver_channels = receiver_channels
        self.coil_label = coil_label if coil_label is not None else []
        self.institution_name = institution_name
        self.station_name = station_name
        self.device_id = device_id
        self.device_serial_number = device_serial_number

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, AcquisitionSystemInformationType)
            and self.system_vendor == other.system_vendor
            and self.system_model == other.system_model
            and self.system_field_strength_t == other.system_field_strength_t
            and self.relative_receiver_noise_bandwidth == other.relative_receiver_noise_bandwidth
            and self.receiver_channels == other.receiver_channels
            and self.coil_label == other.coil_label
            and self.institution_name == other.institution_name
            and self.station_name == other.station_name
            and self.device_id == other.device_id
            and self.device_serial_number == other.device_serial_number
        )

    def __str__(self) -> str:
        return f"AcquisitionSystemInformationType(system_vendor={self.system_vendor}, system_model={self.system_model}, system_field_strength_t={self.system_field_strength_t}, relative_receiver_noise_bandwidth={self.relative_receiver_noise_bandwidth}, receiver_channels={self.receiver_channels}, coil_label={self.coil_label}, institution_name={self.institution_name}, station_name={self.station_name}, device_id={self.device_id}, device_serial_number={self.device_serial_number})"

    def __repr__(self) -> str:
        return f"AcquisitionSystemInformationType(system_vendor={repr(self.system_vendor)}, system_model={repr(self.system_model)}, system_field_strength_t={repr(self.system_field_strength_t)}, relative_receiver_noise_bandwidth={repr(self.relative_receiver_noise_bandwidth)}, receiver_channels={repr(self.receiver_channels)}, coil_label={repr(self.coil_label)}, institution_name={repr(self.institution_name)}, station_name={repr(self.station_name)}, device_id={repr(self.device_id)}, device_serial_number={repr(self.device_serial_number)})"


class ExperimentalConditionsType:
    h1resonance_frequency_hz: yardl.Int64

    def __init__(self, *,
        h1resonance_frequency_hz: yardl.Int64 = 0,
    ):
        self.h1resonance_frequency_hz = h1resonance_frequency_hz

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, ExperimentalConditionsType)
            and self.h1resonance_frequency_hz == other.h1resonance_frequency_hz
        )

    def __str__(self) -> str:
        return f"ExperimentalConditionsType(h1resonance_frequency_hz={self.h1resonance_frequency_hz})"

    def __repr__(self) -> str:
        return f"ExperimentalConditionsType(h1resonance_frequency_hz={repr(self.h1resonance_frequency_hz)})"


class MatrixSizeType:
    x: yardl.UInt32
    y: yardl.UInt32
    z: yardl.UInt32

    def __init__(self, *,
        x: yardl.UInt32 = 0,
        y: yardl.UInt32 = 0,
        z: yardl.UInt32 = 0,
    ):
        self.x = x
        self.y = y
        self.z = z

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, MatrixSizeType)
            and self.x == other.x
            and self.y == other.y
            and self.z == other.z
        )

    def __str__(self) -> str:
        return f"MatrixSizeType(x={self.x}, y={self.y}, z={self.z})"

    def __repr__(self) -> str:
        return f"MatrixSizeType(x={repr(self.x)}, y={repr(self.y)}, z={repr(self.z)})"


class FieldOfViewMm:
    x: yardl.Float32
    y: yardl.Float32
    z: yardl.Float32

    def __init__(self, *,
        x: yardl.Float32 = 0.0,
        y: yardl.Float32 = 0.0,
        z: yardl.Float32 = 0.0,
    ):
        self.x = x
        self.y = y
        self.z = z

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, FieldOfViewMm)
            and self.x == other.x
            and self.y == other.y
            and self.z == other.z
        )

    def __str__(self) -> str:
        return f"FieldOfViewMm(x={self.x}, y={self.y}, z={self.z})"

    def __repr__(self) -> str:
        return f"FieldOfViewMm(x={repr(self.x)}, y={repr(self.y)}, z={repr(self.z)})"


class EncodingSpaceType:
    matrix_size: MatrixSizeType
    field_of_view_mm: FieldOfViewMm

    def __init__(self, *,
        matrix_size: typing.Optional[MatrixSizeType] = None,
        field_of_view_mm: typing.Optional[FieldOfViewMm] = None,
    ):
        self.matrix_size = matrix_size if matrix_size is not None else MatrixSizeType()
        self.field_of_view_mm = field_of_view_mm if field_of_view_mm is not None else FieldOfViewMm()

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, EncodingSpaceType)
            and self.matrix_size == other.matrix_size
            and self.field_of_view_mm == other.field_of_view_mm
        )

    def __str__(self) -> str:
        return f"EncodingSpaceType(matrix_size={self.matrix_size}, field_of_view_mm={self.field_of_view_mm})"

    def __repr__(self) -> str:
        return f"EncodingSpaceType(matrix_size={repr(self.matrix_size)}, field_of_view_mm={repr(self.field_of_view_mm)})"


class LimitType:
    minimum: yardl.UInt32
    maximum: yardl.UInt32
    center: yardl.UInt32

    def __init__(self, *,
        minimum: yardl.UInt32 = 0,
        maximum: yardl.UInt32 = 0,
        center: yardl.UInt32 = 0,
    ):
        self.minimum = minimum
        self.maximum = maximum
        self.center = center

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, LimitType)
            and self.minimum == other.minimum
            and self.maximum == other.maximum
            and self.center == other.center
        )

    def __str__(self) -> str:
        return f"LimitType(minimum={self.minimum}, maximum={self.maximum}, center={self.center})"

    def __repr__(self) -> str:
        return f"LimitType(minimum={repr(self.minimum)}, maximum={repr(self.maximum)}, center={repr(self.center)})"


class EncodingLimitsType:
    kspace_encoding_step_0: typing.Optional[LimitType]
    kspace_encoding_step_1: typing.Optional[LimitType]
    kspace_encoding_step_2: typing.Optional[LimitType]
    average: typing.Optional[LimitType]
    slice: typing.Optional[LimitType]
    contrast: typing.Optional[LimitType]
    phase: typing.Optional[LimitType]
    repetition: typing.Optional[LimitType]
    set: typing.Optional[LimitType]
    segment: typing.Optional[LimitType]
    user_0: typing.Optional[LimitType]
    user_1: typing.Optional[LimitType]
    user_2: typing.Optional[LimitType]
    user_3: typing.Optional[LimitType]
    user_4: typing.Optional[LimitType]
    user_5: typing.Optional[LimitType]
    user_6: typing.Optional[LimitType]
    user_7: typing.Optional[LimitType]

    def __init__(self, *,
        kspace_encoding_step_0: typing.Optional[LimitType] = None,
        kspace_encoding_step_1: typing.Optional[LimitType] = None,
        kspace_encoding_step_2: typing.Optional[LimitType] = None,
        average: typing.Optional[LimitType] = None,
        slice: typing.Optional[LimitType] = None,
        contrast: typing.Optional[LimitType] = None,
        phase: typing.Optional[LimitType] = None,
        repetition: typing.Optional[LimitType] = None,
        set: typing.Optional[LimitType] = None,
        segment: typing.Optional[LimitType] = None,
        user_0: typing.Optional[LimitType] = None,
        user_1: typing.Optional[LimitType] = None,
        user_2: typing.Optional[LimitType] = None,
        user_3: typing.Optional[LimitType] = None,
        user_4: typing.Optional[LimitType] = None,
        user_5: typing.Optional[LimitType] = None,
        user_6: typing.Optional[LimitType] = None,
        user_7: typing.Optional[LimitType] = None,
    ):
        self.kspace_encoding_step_0 = kspace_encoding_step_0
        self.kspace_encoding_step_1 = kspace_encoding_step_1
        self.kspace_encoding_step_2 = kspace_encoding_step_2
        self.average = average
        self.slice = slice
        self.contrast = contrast
        self.phase = phase
        self.repetition = repetition
        self.set = set
        self.segment = segment
        self.user_0 = user_0
        self.user_1 = user_1
        self.user_2 = user_2
        self.user_3 = user_3
        self.user_4 = user_4
        self.user_5 = user_5
        self.user_6 = user_6
        self.user_7 = user_7

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, EncodingLimitsType)
            and self.kspace_encoding_step_0 == other.kspace_encoding_step_0
            and self.kspace_encoding_step_1 == other.kspace_encoding_step_1
            and self.kspace_encoding_step_2 == other.kspace_encoding_step_2
            and self.average == other.average
            and self.slice == other.slice
            and self.contrast == other.contrast
            and self.phase == other.phase
            and self.repetition == other.repetition
            and self.set == other.set
            and self.segment == other.segment
            and self.user_0 == other.user_0
            and self.user_1 == other.user_1
            and self.user_2 == other.user_2
            and self.user_3 == other.user_3
            and self.user_4 == other.user_4
            and self.user_5 == other.user_5
            and self.user_6 == other.user_6
            and self.user_7 == other.user_7
        )

    def __str__(self) -> str:
        return f"EncodingLimitsType(kspace_encoding_step_0={self.kspace_encoding_step_0}, kspace_encoding_step_1={self.kspace_encoding_step_1}, kspace_encoding_step_2={self.kspace_encoding_step_2}, average={self.average}, slice={self.slice}, contrast={self.contrast}, phase={self.phase}, repetition={self.repetition}, set={self.set}, segment={self.segment}, user_0={self.user_0}, user_1={self.user_1}, user_2={self.user_2}, user_3={self.user_3}, user_4={self.user_4}, user_5={self.user_5}, user_6={self.user_6}, user_7={self.user_7})"

    def __repr__(self) -> str:
        return f"EncodingLimitsType(kspace_encoding_step_0={repr(self.kspace_encoding_step_0)}, kspace_encoding_step_1={repr(self.kspace_encoding_step_1)}, kspace_encoding_step_2={repr(self.kspace_encoding_step_2)}, average={repr(self.average)}, slice={repr(self.slice)}, contrast={repr(self.contrast)}, phase={repr(self.phase)}, repetition={repr(self.repetition)}, set={repr(self.set)}, segment={repr(self.segment)}, user_0={repr(self.user_0)}, user_1={repr(self.user_1)}, user_2={repr(self.user_2)}, user_3={repr(self.user_3)}, user_4={repr(self.user_4)}, user_5={repr(self.user_5)}, user_6={repr(self.user_6)}, user_7={repr(self.user_7)})"


class Trajectory(yardl.OutOfRangeEnum):
    CARTESIAN = 0
    EPI = 1
    RADIAL = 2
    GOLDENANGLE = 3
    SPIRAL = 4
    OTHER = 5

class UserParameterLongType:
    name: str
    value: yardl.Int64

    def __init__(self, *,
        name: str = "",
        value: yardl.Int64 = 0,
    ):
        self.name = name
        self.value = value

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, UserParameterLongType)
            and self.name == other.name
            and self.value == other.value
        )

    def __str__(self) -> str:
        return f"UserParameterLongType(name={self.name}, value={self.value})"

    def __repr__(self) -> str:
        return f"UserParameterLongType(name={repr(self.name)}, value={repr(self.value)})"


class UserParameterDoubleType:
    name: str
    value: yardl.Float64

    def __init__(self, *,
        name: str = "",
        value: yardl.Float64 = 0.0,
    ):
        self.name = name
        self.value = value

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, UserParameterDoubleType)
            and self.name == other.name
            and self.value == other.value
        )

    def __str__(self) -> str:
        return f"UserParameterDoubleType(name={self.name}, value={self.value})"

    def __repr__(self) -> str:
        return f"UserParameterDoubleType(name={repr(self.name)}, value={repr(self.value)})"


class UserParameterStringType:
    name: str
    value: str

    def __init__(self, *,
        name: str = "",
        value: str = "",
    ):
        self.name = name
        self.value = value

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, UserParameterStringType)
            and self.name == other.name
            and self.value == other.value
        )

    def __str__(self) -> str:
        return f"UserParameterStringType(name={self.name}, value={self.value})"

    def __repr__(self) -> str:
        return f"UserParameterStringType(name={repr(self.name)}, value={repr(self.value)})"


class TrajectoryDescriptionType:
    identifier: str
    user_parameter_long: list[UserParameterLongType]
    user_parameter_double: list[UserParameterDoubleType]
    user_parameter_string: list[UserParameterStringType]
    comment: typing.Optional[str]

    def __init__(self, *,
        identifier: str = "",
        user_parameter_long: typing.Optional[list[UserParameterLongType]] = None,
        user_parameter_double: typing.Optional[list[UserParameterDoubleType]] = None,
        user_parameter_string: typing.Optional[list[UserParameterStringType]] = None,
        comment: typing.Optional[str] = None,
    ):
        self.identifier = identifier
        self.user_parameter_long = user_parameter_long if user_parameter_long is not None else []
        self.user_parameter_double = user_parameter_double if user_parameter_double is not None else []
        self.user_parameter_string = user_parameter_string if user_parameter_string is not None else []
        self.comment = comment

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, TrajectoryDescriptionType)
            and self.identifier == other.identifier
            and self.user_parameter_long == other.user_parameter_long
            and self.user_parameter_double == other.user_parameter_double
            and self.user_parameter_string == other.user_parameter_string
            and self.comment == other.comment
        )

    def __str__(self) -> str:
        return f"TrajectoryDescriptionType(identifier={self.identifier}, user_parameter_long={self.user_parameter_long}, user_parameter_double={self.user_parameter_double}, user_parameter_string={self.user_parameter_string}, comment={self.comment})"

    def __repr__(self) -> str:
        return f"TrajectoryDescriptionType(identifier={repr(self.identifier)}, user_parameter_long={repr(self.user_parameter_long)}, user_parameter_double={repr(self.user_parameter_double)}, user_parameter_string={repr(self.user_parameter_string)}, comment={repr(self.comment)})"


class AccelerationFactorType:
    kspace_encoding_step_1: yardl.UInt32
    kspace_encoding_step_2: yardl.UInt32

    def __init__(self, *,
        kspace_encoding_step_1: yardl.UInt32 = 0,
        kspace_encoding_step_2: yardl.UInt32 = 0,
    ):
        self.kspace_encoding_step_1 = kspace_encoding_step_1
        self.kspace_encoding_step_2 = kspace_encoding_step_2

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, AccelerationFactorType)
            and self.kspace_encoding_step_1 == other.kspace_encoding_step_1
            and self.kspace_encoding_step_2 == other.kspace_encoding_step_2
        )

    def __str__(self) -> str:
        return f"AccelerationFactorType(kspace_encoding_step_1={self.kspace_encoding_step_1}, kspace_encoding_step_2={self.kspace_encoding_step_2})"

    def __repr__(self) -> str:
        return f"AccelerationFactorType(kspace_encoding_step_1={repr(self.kspace_encoding_step_1)}, kspace_encoding_step_2={repr(self.kspace_encoding_step_2)})"


class CalibrationMode(yardl.OutOfRangeEnum):
    NOACCELERATION = 0
    EMBEDDED = 1
    INTERLEAVED = 2
    SEPARATE = 3
    EXTERNAL = 4
    OTHER = 5

class InterleavingDimension(yardl.OutOfRangeEnum):
    PHASE = 0
    REPETITION = 1
    CONTRAST = 2
    AVERAGE = 3
    OTHER = 4

class MultibandSpacingType:
    d_z: list[yardl.Float32]

    def __init__(self, *,
        d_z: typing.Optional[list[yardl.Float32]] = None,
    ):
        self.d_z = d_z if d_z is not None else []

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, MultibandSpacingType)
            and self.d_z == other.d_z
        )

    def __str__(self) -> str:
        return f"MultibandSpacingType(d_z={self.d_z})"

    def __repr__(self) -> str:
        return f"MultibandSpacingType(d_z={repr(self.d_z)})"


class Calibration(yardl.OutOfRangeEnum):
    SEPARABLE_2D = 0
    FULL_3D = 1
    OTHER = 2

class MultibandType:
    spacing: list[MultibandSpacingType]
    delta_kz: yardl.Float32
    multiband_factor: yardl.UInt32
    calibration: Calibration
    calibration_encoding: yardl.UInt64

    def __init__(self, *,
        spacing: typing.Optional[list[MultibandSpacingType]] = None,
        delta_kz: yardl.Float32 = 0.0,
        multiband_factor: yardl.UInt32 = 0,
        calibration: Calibration = Calibration.SEPARABLE_2D,
        calibration_encoding: yardl.UInt64 = 0,
    ):
        self.spacing = spacing if spacing is not None else []
        self.delta_kz = delta_kz
        self.multiband_factor = multiband_factor
        self.calibration = calibration
        self.calibration_encoding = calibration_encoding

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, MultibandType)
            and self.spacing == other.spacing
            and self.delta_kz == other.delta_kz
            and self.multiband_factor == other.multiband_factor
            and self.calibration == other.calibration
            and self.calibration_encoding == other.calibration_encoding
        )

    def __str__(self) -> str:
        return f"MultibandType(spacing={self.spacing}, delta_kz={self.delta_kz}, multiband_factor={self.multiband_factor}, calibration={self.calibration}, calibration_encoding={self.calibration_encoding})"

    def __repr__(self) -> str:
        return f"MultibandType(spacing={repr(self.spacing)}, delta_kz={repr(self.delta_kz)}, multiband_factor={repr(self.multiband_factor)}, calibration={repr(self.calibration)}, calibration_encoding={repr(self.calibration_encoding)})"


class ParallelImagingType:
    acceleration_factor: AccelerationFactorType
    calibration_mode: typing.Optional[CalibrationMode]
    interleaving_dimension: typing.Optional[InterleavingDimension]
    multiband: typing.Optional[MultibandType]

    def __init__(self, *,
        acceleration_factor: typing.Optional[AccelerationFactorType] = None,
        calibration_mode: typing.Optional[CalibrationMode] = None,
        interleaving_dimension: typing.Optional[InterleavingDimension] = None,
        multiband: typing.Optional[MultibandType] = None,
    ):
        self.acceleration_factor = acceleration_factor if acceleration_factor is not None else AccelerationFactorType()
        self.calibration_mode = calibration_mode
        self.interleaving_dimension = interleaving_dimension
        self.multiband = multiband

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, ParallelImagingType)
            and self.acceleration_factor == other.acceleration_factor
            and self.calibration_mode == other.calibration_mode
            and self.interleaving_dimension == other.interleaving_dimension
            and self.multiband == other.multiband
        )

    def __str__(self) -> str:
        return f"ParallelImagingType(acceleration_factor={self.acceleration_factor}, calibration_mode={self.calibration_mode}, interleaving_dimension={self.interleaving_dimension}, multiband={self.multiband})"

    def __repr__(self) -> str:
        return f"ParallelImagingType(acceleration_factor={repr(self.acceleration_factor)}, calibration_mode={repr(self.calibration_mode)}, interleaving_dimension={repr(self.interleaving_dimension)}, multiband={repr(self.multiband)})"


class EncodingType:
    encoded_space: EncodingSpaceType
    recon_space: EncodingSpaceType
    encoding_limits: EncodingLimitsType
    trajectory: Trajectory
    trajectory_description: typing.Optional[TrajectoryDescriptionType]
    parallel_imaging: typing.Optional[ParallelImagingType]
    echo_train_length: typing.Optional[yardl.Int64]

    def __init__(self, *,
        encoded_space: typing.Optional[EncodingSpaceType] = None,
        recon_space: typing.Optional[EncodingSpaceType] = None,
        encoding_limits: typing.Optional[EncodingLimitsType] = None,
        trajectory: Trajectory = Trajectory.CARTESIAN,
        trajectory_description: typing.Optional[TrajectoryDescriptionType] = None,
        parallel_imaging: typing.Optional[ParallelImagingType] = None,
        echo_train_length: typing.Optional[yardl.Int64] = None,
    ):
        self.encoded_space = encoded_space if encoded_space is not None else EncodingSpaceType()
        self.recon_space = recon_space if recon_space is not None else EncodingSpaceType()
        self.encoding_limits = encoding_limits if encoding_limits is not None else EncodingLimitsType()
        self.trajectory = trajectory
        self.trajectory_description = trajectory_description
        self.parallel_imaging = parallel_imaging
        self.echo_train_length = echo_train_length

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, EncodingType)
            and self.encoded_space == other.encoded_space
            and self.recon_space == other.recon_space
            and self.encoding_limits == other.encoding_limits
            and self.trajectory == other.trajectory
            and self.trajectory_description == other.trajectory_description
            and self.parallel_imaging == other.parallel_imaging
            and self.echo_train_length == other.echo_train_length
        )

    def __str__(self) -> str:
        return f"EncodingType(encoded_space={self.encoded_space}, recon_space={self.recon_space}, encoding_limits={self.encoding_limits}, trajectory={self.trajectory}, trajectory_description={self.trajectory_description}, parallel_imaging={self.parallel_imaging}, echo_train_length={self.echo_train_length})"

    def __repr__(self) -> str:
        return f"EncodingType(encoded_space={repr(self.encoded_space)}, recon_space={repr(self.recon_space)}, encoding_limits={repr(self.encoding_limits)}, trajectory={repr(self.trajectory)}, trajectory_description={repr(self.trajectory_description)}, parallel_imaging={repr(self.parallel_imaging)}, echo_train_length={repr(self.echo_train_length)})"


class DiffusionDimension(yardl.OutOfRangeEnum):
    AVERAGE = 0
    CONTRAST = 1
    PHASE = 2
    REPETITION = 3
    SET = 4
    SEGMENT = 5
    USER_0 = 6
    USER_1 = 7
    USER_2 = 8
    USER_3 = 9
    USER_4 = 10
    USER_5 = 11
    USER_6 = 12
    USER_7 = 13

class GradientDirectionType:
    rl: yardl.Float32
    ap: yardl.Float32
    fh: yardl.Float32

    def __init__(self, *,
        rl: yardl.Float32 = 0.0,
        ap: yardl.Float32 = 0.0,
        fh: yardl.Float32 = 0.0,
    ):
        self.rl = rl
        self.ap = ap
        self.fh = fh

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, GradientDirectionType)
            and self.rl == other.rl
            and self.ap == other.ap
            and self.fh == other.fh
        )

    def __str__(self) -> str:
        return f"GradientDirectionType(rl={self.rl}, ap={self.ap}, fh={self.fh})"

    def __repr__(self) -> str:
        return f"GradientDirectionType(rl={repr(self.rl)}, ap={repr(self.ap)}, fh={repr(self.fh)})"


class DiffusionType:
    gradient_direction: GradientDirectionType
    bvalue: yardl.Float32

    def __init__(self, *,
        gradient_direction: typing.Optional[GradientDirectionType] = None,
        bvalue: yardl.Float32 = 0.0,
    ):
        self.gradient_direction = gradient_direction if gradient_direction is not None else GradientDirectionType()
        self.bvalue = bvalue

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, DiffusionType)
            and self.gradient_direction == other.gradient_direction
            and self.bvalue == other.bvalue
        )

    def __str__(self) -> str:
        return f"DiffusionType(gradient_direction={self.gradient_direction}, bvalue={self.bvalue})"

    def __repr__(self) -> str:
        return f"DiffusionType(gradient_direction={repr(self.gradient_direction)}, bvalue={repr(self.bvalue)})"


class SequenceParametersType:
    t_r: list[yardl.Float32]
    t_e: list[yardl.Float32]
    t_i: list[yardl.Float32]
    flip_angle_deg: list[yardl.Float32]
    sequence_type: typing.Optional[str]
    echo_spacing: list[yardl.Float32]
    diffusion_dimension: typing.Optional[DiffusionDimension]
    diffusion: list[DiffusionType]
    diffusion_scheme: typing.Optional[str]

    def __init__(self, *,
        t_r: typing.Optional[list[yardl.Float32]] = None,
        t_e: typing.Optional[list[yardl.Float32]] = None,
        t_i: typing.Optional[list[yardl.Float32]] = None,
        flip_angle_deg: typing.Optional[list[yardl.Float32]] = None,
        sequence_type: typing.Optional[str] = None,
        echo_spacing: typing.Optional[list[yardl.Float32]] = None,
        diffusion_dimension: typing.Optional[DiffusionDimension] = None,
        diffusion: typing.Optional[list[DiffusionType]] = None,
        diffusion_scheme: typing.Optional[str] = None,
    ):
        self.t_r = t_r if t_r is not None else []
        self.t_e = t_e if t_e is not None else []
        self.t_i = t_i if t_i is not None else []
        self.flip_angle_deg = flip_angle_deg if flip_angle_deg is not None else []
        self.sequence_type = sequence_type
        self.echo_spacing = echo_spacing if echo_spacing is not None else []
        self.diffusion_dimension = diffusion_dimension
        self.diffusion = diffusion if diffusion is not None else []
        self.diffusion_scheme = diffusion_scheme

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, SequenceParametersType)
            and self.t_r == other.t_r
            and self.t_e == other.t_e
            and self.t_i == other.t_i
            and self.flip_angle_deg == other.flip_angle_deg
            and self.sequence_type == other.sequence_type
            and self.echo_spacing == other.echo_spacing
            and self.diffusion_dimension == other.diffusion_dimension
            and self.diffusion == other.diffusion
            and self.diffusion_scheme == other.diffusion_scheme
        )

    def __str__(self) -> str:
        return f"SequenceParametersType(t_r={self.t_r}, t_e={self.t_e}, t_i={self.t_i}, flip_angle_deg={self.flip_angle_deg}, sequence_type={self.sequence_type}, echo_spacing={self.echo_spacing}, diffusion_dimension={self.diffusion_dimension}, diffusion={self.diffusion}, diffusion_scheme={self.diffusion_scheme})"

    def __repr__(self) -> str:
        return f"SequenceParametersType(t_r={repr(self.t_r)}, t_e={repr(self.t_e)}, t_i={repr(self.t_i)}, flip_angle_deg={repr(self.flip_angle_deg)}, sequence_type={repr(self.sequence_type)}, echo_spacing={repr(self.echo_spacing)}, diffusion_dimension={repr(self.diffusion_dimension)}, diffusion={repr(self.diffusion)}, diffusion_scheme={repr(self.diffusion_scheme)})"


class UserParameterBase64Type:
    name: str
    value: str

    def __init__(self, *,
        name: str = "",
        value: str = "",
    ):
        self.name = name
        self.value = value

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, UserParameterBase64Type)
            and self.name == other.name
            and self.value == other.value
        )

    def __str__(self) -> str:
        return f"UserParameterBase64Type(name={self.name}, value={self.value})"

    def __repr__(self) -> str:
        return f"UserParameterBase64Type(name={repr(self.name)}, value={repr(self.value)})"


class UserParametersType:
    user_parameter_long: list[UserParameterLongType]
    user_parameter_double: list[UserParameterDoubleType]
    user_parameter_string: list[UserParameterStringType]
    user_parameter_base64: list[UserParameterBase64Type]

    def __init__(self, *,
        user_parameter_long: typing.Optional[list[UserParameterLongType]] = None,
        user_parameter_double: typing.Optional[list[UserParameterDoubleType]] = None,
        user_parameter_string: typing.Optional[list[UserParameterStringType]] = None,
        user_parameter_base64: typing.Optional[list[UserParameterBase64Type]] = None,
    ):
        self.user_parameter_long = user_parameter_long if user_parameter_long is not None else []
        self.user_parameter_double = user_parameter_double if user_parameter_double is not None else []
        self.user_parameter_string = user_parameter_string if user_parameter_string is not None else []
        self.user_parameter_base64 = user_parameter_base64 if user_parameter_base64 is not None else []

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, UserParametersType)
            and self.user_parameter_long == other.user_parameter_long
            and self.user_parameter_double == other.user_parameter_double
            and self.user_parameter_string == other.user_parameter_string
            and self.user_parameter_base64 == other.user_parameter_base64
        )

    def __str__(self) -> str:
        return f"UserParametersType(user_parameter_long={self.user_parameter_long}, user_parameter_double={self.user_parameter_double}, user_parameter_string={self.user_parameter_string}, user_parameter_base64={self.user_parameter_base64})"

    def __repr__(self) -> str:
        return f"UserParametersType(user_parameter_long={repr(self.user_parameter_long)}, user_parameter_double={repr(self.user_parameter_double)}, user_parameter_string={repr(self.user_parameter_string)}, user_parameter_base64={repr(self.user_parameter_base64)})"


class WaveformType(yardl.OutOfRangeEnum):
    ECG = 0
    PULSE = 1
    RESPIRATORY = 2
    TRIGGER = 3
    GRADIENTWAVEFORM = 4
    OTHER = 5

class WaveformInformationType:
    waveform_name: str
    waveform_type: WaveformType
    user_parameters: UserParametersType

    def __init__(self, *,
        waveform_name: str = "",
        waveform_type: WaveformType = WaveformType.ECG,
        user_parameters: typing.Optional[UserParametersType] = None,
    ):
        self.waveform_name = waveform_name
        self.waveform_type = waveform_type
        self.user_parameters = user_parameters if user_parameters is not None else UserParametersType()

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, WaveformInformationType)
            and self.waveform_name == other.waveform_name
            and self.waveform_type == other.waveform_type
            and self.user_parameters == other.user_parameters
        )

    def __str__(self) -> str:
        return f"WaveformInformationType(waveform_name={self.waveform_name}, waveform_type={self.waveform_type}, user_parameters={self.user_parameters})"

    def __repr__(self) -> str:
        return f"WaveformInformationType(waveform_name={repr(self.waveform_name)}, waveform_type={repr(self.waveform_type)}, user_parameters={repr(self.user_parameters)})"


class Header:
    version: typing.Optional[yardl.Int64]
    subject_information: typing.Optional[SubjectInformationType]
    study_information: typing.Optional[StudyInformationType]
    measurement_information: typing.Optional[MeasurementInformationType]
    acquisition_system_information: typing.Optional[AcquisitionSystemInformationType]
    experimental_conditions: ExperimentalConditionsType
    encoding: list[EncodingType]
    sequence_parameters: typing.Optional[SequenceParametersType]
    user_parameters: typing.Optional[UserParametersType]
    waveform_information: list[WaveformInformationType]

    def __init__(self, *,
        version: typing.Optional[yardl.Int64] = None,
        subject_information: typing.Optional[SubjectInformationType] = None,
        study_information: typing.Optional[StudyInformationType] = None,
        measurement_information: typing.Optional[MeasurementInformationType] = None,
        acquisition_system_information: typing.Optional[AcquisitionSystemInformationType] = None,
        experimental_conditions: typing.Optional[ExperimentalConditionsType] = None,
        encoding: typing.Optional[list[EncodingType]] = None,
        sequence_parameters: typing.Optional[SequenceParametersType] = None,
        user_parameters: typing.Optional[UserParametersType] = None,
        waveform_information: typing.Optional[list[WaveformInformationType]] = None,
    ):
        self.version = version
        self.subject_information = subject_information
        self.study_information = study_information
        self.measurement_information = measurement_information
        self.acquisition_system_information = acquisition_system_information
        self.experimental_conditions = experimental_conditions if experimental_conditions is not None else ExperimentalConditionsType()
        self.encoding = encoding if encoding is not None else []
        self.sequence_parameters = sequence_parameters
        self.user_parameters = user_parameters
        self.waveform_information = waveform_information if waveform_information is not None else []

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, Header)
            and self.version == other.version
            and self.subject_information == other.subject_information
            and self.study_information == other.study_information
            and self.measurement_information == other.measurement_information
            and self.acquisition_system_information == other.acquisition_system_information
            and self.experimental_conditions == other.experimental_conditions
            and self.encoding == other.encoding
            and self.sequence_parameters == other.sequence_parameters
            and self.user_parameters == other.user_parameters
            and self.waveform_information == other.waveform_information
        )

    def __str__(self) -> str:
        return f"Header(version={self.version}, subject_information={self.subject_information}, study_information={self.study_information}, measurement_information={self.measurement_information}, acquisition_system_information={self.acquisition_system_information}, experimental_conditions={self.experimental_conditions}, encoding={self.encoding}, sequence_parameters={self.sequence_parameters}, user_parameters={self.user_parameters}, waveform_information={self.waveform_information})"

    def __repr__(self) -> str:
        return f"Header(version={repr(self.version)}, subject_information={repr(self.subject_information)}, study_information={repr(self.study_information)}, measurement_information={repr(self.measurement_information)}, acquisition_system_information={repr(self.acquisition_system_information)}, experimental_conditions={repr(self.experimental_conditions)}, encoding={repr(self.encoding)}, sequence_parameters={repr(self.sequence_parameters)}, user_parameters={repr(self.user_parameters)}, waveform_information={repr(self.waveform_information)})"


class ImageFlags(enum.IntFlag):
    IS_NAVIGATION_DATA = 1
    FIRST_IN_AVERAGE = 16
    LAST_IN_AVERAGE = 32
    FIRST_IN_SLICE = 64
    LAST_IN_SLICE = 128
    FIRST_IN_CONTRAST = 256
    LAST_IN_CONTRAST = 512
    FIRST_IN_PHASE = 1024
    LAST_IN_PHASE = 2048
    FIRST_IN_REPETITION = 4096
    LAST_IN_REPETITION = 8192
    FIRST_IN_SET = 16384
    LAST_IN_SET = 32768

    def __eq__(self, other: object) -> bool:
        return isinstance(other, ImageFlags) and self.value == other.value

    def __hash__(self) -> int:
        return hash(self.value)

    __str__ = enum.Flag.__str__ # type: ignore

class ImageType(yardl.OutOfRangeEnum):
    MAGNITUDE = 1
    PHASE = 2
    REAL = 3
    IMAG = 4
    COMPLEX = 5

ImageData = npt.NDArray[Y_NP]

class ImageHeader:
    flags: ImageFlags
    """A bit mask of common attributes applicable to individual images"""

    measurement_uid: yardl.UInt32
    """Unique ID corresponding to the image"""

    field_of_view: npt.NDArray[np.float32]
    """Physical size (in mm) in each of the 3 dimensions in the image"""

    position: npt.NDArray[np.float32]
    """Center of the excited volume, in LPS coordinates relative to isocenter in millimeters"""

    col_dir: npt.NDArray[np.float32]
    """Directional cosine of readout/frequency encoding"""

    line_dir: npt.NDArray[np.float32]
    """Directional cosine of phase encoding (2D)"""

    slice_dir: npt.NDArray[np.float32]
    """Directional cosine of 3D phase encoding direction"""

    patient_table_position: npt.NDArray[np.float32]
    """Offset position of the patient table, in LPS coordinates"""

    average: typing.Optional[yardl.UInt32]
    """Signal average"""

    slice: typing.Optional[yardl.UInt32]
    """Slice number (multi-slice 2D)"""

    contrast: typing.Optional[yardl.UInt32]
    """Echo number in multi-echo"""

    phase: typing.Optional[yardl.UInt32]
    """Cardiac phase"""

    repetition: typing.Optional[yardl.UInt32]
    """Counter in repeated/dynamic acquisitions"""

    set: typing.Optional[yardl.UInt32]
    """Sets of different preparation, e.g. flow encoding, diffusion weighting"""

    acquisition_time_stamp_ns: typing.Optional[yardl.UInt64]
    """Clock time stamp (e.g. nanoseconds since midnight)"""

    physiology_time_stamp_ns: list[yardl.UInt64]
    """Time stamps relative to physiological triggering in nanoseconds, e.g. ECG, pulse oximetry, respiratory"""

    image_type: ImageType
    """Interpretation type of the image"""

    image_index: typing.Optional[yardl.UInt32]
    """Image index number within a series of images, corresponding to DICOM InstanceNumber (0020,0013)"""

    image_series_index: typing.Optional[yardl.UInt32]
    """Series index, used to separate images into different series, corresponding to DICOM SeriesNumber (0020,0011)"""

    user_int: list[yardl.Int32]
    """User-defined int parameters"""

    user_float: list[yardl.Float32]
    """User-defined float parameters"""


    def __init__(self, *,
        flags: ImageFlags = ImageFlags(0),
        measurement_uid: yardl.UInt32 = 0,
        field_of_view: typing.Optional[npt.NDArray[np.float32]] = None,
        position: typing.Optional[npt.NDArray[np.float32]] = None,
        col_dir: typing.Optional[npt.NDArray[np.float32]] = None,
        line_dir: typing.Optional[npt.NDArray[np.float32]] = None,
        slice_dir: typing.Optional[npt.NDArray[np.float32]] = None,
        patient_table_position: typing.Optional[npt.NDArray[np.float32]] = None,
        average: typing.Optional[yardl.UInt32] = None,
        slice: typing.Optional[yardl.UInt32] = None,
        contrast: typing.Optional[yardl.UInt32] = None,
        phase: typing.Optional[yardl.UInt32] = None,
        repetition: typing.Optional[yardl.UInt32] = None,
        set: typing.Optional[yardl.UInt32] = None,
        acquisition_time_stamp_ns: typing.Optional[yardl.UInt64] = None,
        physiology_time_stamp_ns: typing.Optional[list[yardl.UInt64]] = None,
        image_type: ImageType,
        image_index: typing.Optional[yardl.UInt32] = None,
        image_series_index: typing.Optional[yardl.UInt32] = None,
        user_int: typing.Optional[list[yardl.Int32]] = None,
        user_float: typing.Optional[list[yardl.Float32]] = None,
    ):
        self.flags = flags
        self.measurement_uid = measurement_uid
        self.field_of_view = field_of_view if field_of_view is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.position = position if position is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.col_dir = col_dir if col_dir is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.line_dir = line_dir if line_dir is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.slice_dir = slice_dir if slice_dir is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.patient_table_position = patient_table_position if patient_table_position is not None else np.zeros((3,), dtype=np.dtype(np.float32))
        self.average = average
        self.slice = slice
        self.contrast = contrast
        self.phase = phase
        self.repetition = repetition
        self.set = set
        self.acquisition_time_stamp_ns = acquisition_time_stamp_ns
        self.physiology_time_stamp_ns = physiology_time_stamp_ns if physiology_time_stamp_ns is not None else []
        self.image_type = image_type
        self.image_index = image_index
        self.image_series_index = image_series_index
        self.user_int = user_int if user_int is not None else []
        self.user_float = user_float if user_float is not None else []

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, ImageHeader)
            and self.flags == other.flags
            and self.measurement_uid == other.measurement_uid
            and yardl.structural_equal(self.field_of_view, other.field_of_view)
            and yardl.structural_equal(self.position, other.position)
            and yardl.structural_equal(self.col_dir, other.col_dir)
            and yardl.structural_equal(self.line_dir, other.line_dir)
            and yardl.structural_equal(self.slice_dir, other.slice_dir)
            and yardl.structural_equal(self.patient_table_position, other.patient_table_position)
            and self.average == other.average
            and self.slice == other.slice
            and self.contrast == other.contrast
            and self.phase == other.phase
            and self.repetition == other.repetition
            and self.set == other.set
            and self.acquisition_time_stamp_ns == other.acquisition_time_stamp_ns
            and self.physiology_time_stamp_ns == other.physiology_time_stamp_ns
            and self.image_type == other.image_type
            and self.image_index == other.image_index
            and self.image_series_index == other.image_series_index
            and self.user_int == other.user_int
            and self.user_float == other.user_float
        )

    def __str__(self) -> str:
        return f"ImageHeader(flags={self.flags}, measurement_uid={self.measurement_uid}, field_of_view={self.field_of_view}, position={self.position}, col_dir={self.col_dir}, line_dir={self.line_dir}, slice_dir={self.slice_dir}, patient_table_position={self.patient_table_position}, average={self.average}, slice={self.slice}, contrast={self.contrast}, phase={self.phase}, repetition={self.repetition}, set={self.set}, acquisition_time_stamp_ns={self.acquisition_time_stamp_ns}, physiology_time_stamp_ns={self.physiology_time_stamp_ns}, image_type={self.image_type}, image_index={self.image_index}, image_series_index={self.image_series_index}, user_int={self.user_int}, user_float={self.user_float})"

    def __repr__(self) -> str:
        return f"ImageHeader(flags={repr(self.flags)}, measurement_uid={repr(self.measurement_uid)}, field_of_view={repr(self.field_of_view)}, position={repr(self.position)}, col_dir={repr(self.col_dir)}, line_dir={repr(self.line_dir)}, slice_dir={repr(self.slice_dir)}, patient_table_position={repr(self.patient_table_position)}, average={repr(self.average)}, slice={repr(self.slice)}, contrast={repr(self.contrast)}, phase={repr(self.phase)}, repetition={repr(self.repetition)}, set={repr(self.set)}, acquisition_time_stamp_ns={repr(self.acquisition_time_stamp_ns)}, physiology_time_stamp_ns={repr(self.physiology_time_stamp_ns)}, image_type={repr(self.image_type)}, image_index={repr(self.image_index)}, image_series_index={repr(self.image_series_index)}, user_int={repr(self.user_int)}, user_float={repr(self.user_float)})"


_T = typing.TypeVar('_T')

class ImageMetaValue:
    String: typing.ClassVar[type["ImageMetaValueUnionCase[str]"]]
    Int64: typing.ClassVar[type["ImageMetaValueUnionCase[yardl.Int64]"]]
    Float64: typing.ClassVar[type["ImageMetaValueUnionCase[yardl.Float64]"]]

class ImageMetaValueUnionCase(ImageMetaValue, yardl.UnionCase[_T]):
    pass

ImageMetaValue.String = type("ImageMetaValue.String", (ImageMetaValueUnionCase,), {"index": 0, "tag": "string"})
ImageMetaValue.Int64 = type("ImageMetaValue.Int64", (ImageMetaValueUnionCase,), {"index": 1, "tag": "int64"})
ImageMetaValue.Float64 = type("ImageMetaValue.Float64", (ImageMetaValueUnionCase,), {"index": 2, "tag": "float64"})
del ImageMetaValueUnionCase

ImageMeta = dict[str, list[ImageMetaValue]]

class Image(typing.Generic[T_NP]):
    head: ImageHeader
    """Image header"""

    data: ImageData[T_NP]
    """Image data array"""

    meta: ImageMeta
    """Meta attributes"""


    def __init__(self, *,
        head: ImageHeader,
        data: ImageData[T_NP],
        meta: typing.Optional[ImageMeta] = None,
    ):
        self.head = head
        self.data = data
        self.meta = meta if meta is not None else {}

    def channels(self) -> yardl.Size:
        return self.data.shape[0]

    def slices(self) -> yardl.Size:
        return self.data.shape[1]

    def rows(self) -> yardl.Size:
        return self.data.shape[2]

    def cols(self) -> yardl.Size:
        return self.data.shape[3]

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, Image)
            and self.head == other.head
            and yardl.structural_equal(self.data, other.data)
            and self.meta == other.meta
        )

    def __str__(self) -> str:
        return f"Image(head={self.head}, data={self.data}, meta={self.meta})"

    def __repr__(self) -> str:
        return f"Image(head={repr(self.head)}, data={repr(self.data)}, meta={repr(self.meta)})"


ImageUint16 = Image[np.uint16]

ImageInt16 = Image[np.int16]

ImageUint32 = Image[np.uint32]

ImageInt32 = Image[np.int32]

ImageFloat = Image[np.float32]

ImageDouble = Image[np.float64]

ImageComplexFloat = Image[np.complex64]

ImageComplexDouble = Image[np.complex128]

class AnyImage:
    ImageUint16: typing.ClassVar[type["AnyImageUnionCase[ImageUint16]"]]
    ImageInt16: typing.ClassVar[type["AnyImageUnionCase[ImageInt16]"]]
    ImageUint32: typing.ClassVar[type["AnyImageUnionCase[ImageUint32]"]]
    ImageInt32: typing.ClassVar[type["AnyImageUnionCase[ImageInt32]"]]
    ImageFloat: typing.ClassVar[type["AnyImageUnionCase[ImageFloat]"]]
    ImageDouble: typing.ClassVar[type["AnyImageUnionCase[ImageDouble]"]]
    ImageComplexFloat: typing.ClassVar[type["AnyImageUnionCase[ImageComplexFloat]"]]
    ImageComplexDouble: typing.ClassVar[type["AnyImageUnionCase[ImageComplexDouble]"]]

class AnyImageUnionCase(AnyImage, yardl.UnionCase[_T]):
    pass

AnyImage.ImageUint16 = type("AnyImage.ImageUint16", (AnyImageUnionCase,), {"index": 0, "tag": "ImageUint16"})
AnyImage.ImageInt16 = type("AnyImage.ImageInt16", (AnyImageUnionCase,), {"index": 1, "tag": "ImageInt16"})
AnyImage.ImageUint32 = type("AnyImage.ImageUint32", (AnyImageUnionCase,), {"index": 2, "tag": "ImageUint32"})
AnyImage.ImageInt32 = type("AnyImage.ImageInt32", (AnyImageUnionCase,), {"index": 3, "tag": "ImageInt32"})
AnyImage.ImageFloat = type("AnyImage.ImageFloat", (AnyImageUnionCase,), {"index": 4, "tag": "ImageFloat"})
AnyImage.ImageDouble = type("AnyImage.ImageDouble", (AnyImageUnionCase,), {"index": 5, "tag": "ImageDouble"})
AnyImage.ImageComplexFloat = type("AnyImage.ImageComplexFloat", (AnyImageUnionCase,), {"index": 6, "tag": "ImageComplexFloat"})
AnyImage.ImageComplexDouble = type("AnyImage.ImageComplexDouble", (AnyImageUnionCase,), {"index": 7, "tag": "ImageComplexDouble"})
del AnyImageUnionCase

class NoiseCovariance:
    coil_labels: list[CoilLabelType]
    """Comes from Header.acquisitionSystemInformation.coilLabel"""

    receiver_noise_bandwidth: yardl.Float32
    """Comes from Header.acquisitionSystemInformation.relativeReceiverNoiseBandwidth"""

    noise_dwell_time_ns: yardl.UInt64
    """Comes from Acquisition.sampleTimeNs"""

    sample_count: yardl.Size
    """Number of samples used to compute matrix"""

    matrix: npt.NDArray[np.complex64]
    """Noise covariance matrix with dimensions [coil, coil]"""


    def __init__(self, *,
        coil_labels: typing.Optional[list[CoilLabelType]] = None,
        receiver_noise_bandwidth: yardl.Float32 = 0.0,
        noise_dwell_time_ns: yardl.UInt64 = 0,
        sample_count: yardl.Size = 0,
        matrix: typing.Optional[npt.NDArray[np.complex64]] = None,
    ):
        self.coil_labels = coil_labels if coil_labels is not None else []
        self.receiver_noise_bandwidth = receiver_noise_bandwidth
        self.noise_dwell_time_ns = noise_dwell_time_ns
        self.sample_count = sample_count
        self.matrix = matrix if matrix is not None else np.zeros((0, 0), dtype=np.dtype(np.complex64))

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, NoiseCovariance)
            and self.coil_labels == other.coil_labels
            and self.receiver_noise_bandwidth == other.receiver_noise_bandwidth
            and self.noise_dwell_time_ns == other.noise_dwell_time_ns
            and self.sample_count == other.sample_count
            and yardl.structural_equal(self.matrix, other.matrix)
        )

    def __str__(self) -> str:
        return f"NoiseCovariance(coil_labels={self.coil_labels}, receiver_noise_bandwidth={self.receiver_noise_bandwidth}, noise_dwell_time_ns={self.noise_dwell_time_ns}, sample_count={self.sample_count}, matrix={self.matrix})"

    def __repr__(self) -> str:
        return f"NoiseCovariance(coil_labels={repr(self.coil_labels)}, receiver_noise_bandwidth={repr(self.receiver_noise_bandwidth)}, noise_dwell_time_ns={repr(self.noise_dwell_time_ns)}, sample_count={repr(self.sample_count)}, matrix={repr(self.matrix)})"


WaveformSamples = npt.NDArray[T_NP]

class Waveform(typing.Generic[T_NP]):
    flags: yardl.UInt64
    """Bit field of flags. Currently unused"""

    measurement_uid: yardl.UInt32
    """Unique ID for this measurement"""

    scan_counter: yardl.UInt32
    """Number of the acquisition after this waveform"""

    time_stamp_ns: yardl.UInt64
    """Starting timestamp of this waveform"""

    sample_time_ns: yardl.UInt64
    """Time between samples in nanoseconds"""

    waveform_id: yardl.UInt32
    """ID matching the waveform in the MRD header"""

    data: WaveformSamples[T_NP]
    """Waveform sample array"""


    def __init__(self, *,
        flags: yardl.UInt64 = 0,
        measurement_uid: yardl.UInt32 = 0,
        scan_counter: yardl.UInt32 = 0,
        time_stamp_ns: yardl.UInt64 = 0,
        sample_time_ns: yardl.UInt64 = 0,
        waveform_id: yardl.UInt32 = 0,
        data: WaveformSamples[T_NP],
    ):
        self.flags = flags
        self.measurement_uid = measurement_uid
        self.scan_counter = scan_counter
        self.time_stamp_ns = time_stamp_ns
        self.sample_time_ns = sample_time_ns
        self.waveform_id = waveform_id
        self.data = data

    def channels(self) -> yardl.Size:
        return self.data.shape[0]

    def number_of_samples(self) -> yardl.Size:
        return self.data.shape[1]

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, Waveform)
            and self.flags == other.flags
            and self.measurement_uid == other.measurement_uid
            and self.scan_counter == other.scan_counter
            and self.time_stamp_ns == other.time_stamp_ns
            and self.sample_time_ns == other.sample_time_ns
            and self.waveform_id == other.waveform_id
            and yardl.structural_equal(self.data, other.data)
        )

    def __str__(self) -> str:
        return f"Waveform(flags={self.flags}, measurement_uid={self.measurement_uid}, scan_counter={self.scan_counter}, time_stamp_ns={self.time_stamp_ns}, sample_time_ns={self.sample_time_ns}, waveform_id={self.waveform_id}, data={self.data})"

    def __repr__(self) -> str:
        return f"Waveform(flags={repr(self.flags)}, measurement_uid={repr(self.measurement_uid)}, scan_counter={repr(self.scan_counter)}, time_stamp_ns={repr(self.time_stamp_ns)}, sample_time_ns={repr(self.sample_time_ns)}, waveform_id={repr(self.waveform_id)}, data={repr(self.data)})"


WaveformUint32 = Waveform[np.uint32]

class AcquisitionBucket:
    data: list[Acquisition]
    ref: list[Acquisition]
    datastats: list[EncodingLimitsType]
    refstats: list[EncodingLimitsType]
    waveforms: list[WaveformUint32]

    def __init__(self, *,
        data: typing.Optional[list[Acquisition]] = None,
        ref: typing.Optional[list[Acquisition]] = None,
        datastats: typing.Optional[list[EncodingLimitsType]] = None,
        refstats: typing.Optional[list[EncodingLimitsType]] = None,
        waveforms: typing.Optional[list[WaveformUint32]] = None,
    ):
        self.data = data if data is not None else []
        self.ref = ref if ref is not None else []
        self.datastats = datastats if datastats is not None else []
        self.refstats = refstats if refstats is not None else []
        self.waveforms = waveforms if waveforms is not None else []

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, AcquisitionBucket)
            and len(self.data) == len(other.data) and all(a == b for a, b in zip(self.data, other.data))
            and len(self.ref) == len(other.ref) and all(a == b for a, b in zip(self.ref, other.ref))
            and self.datastats == other.datastats
            and self.refstats == other.refstats
            and len(self.waveforms) == len(other.waveforms) and all(a == b for a, b in zip(self.waveforms, other.waveforms))
        )

    def __str__(self) -> str:
        return f"AcquisitionBucket(data={self.data}, ref={self.ref}, datastats={self.datastats}, refstats={self.refstats}, waveforms={self.waveforms})"

    def __repr__(self) -> str:
        return f"AcquisitionBucket(data={repr(self.data)}, ref={repr(self.ref)}, datastats={repr(self.datastats)}, refstats={repr(self.refstats)}, waveforms={repr(self.waveforms)})"


class SamplingLimits:
    """Sampled range along E0, E1, E2 (for asymmetric echo and partial fourier)"""

    kspace_encoding_step_0: LimitType
    kspace_encoding_step_1: LimitType
    kspace_encoding_step_2: LimitType

    def __init__(self, *,
        kspace_encoding_step_0: typing.Optional[LimitType] = None,
        kspace_encoding_step_1: typing.Optional[LimitType] = None,
        kspace_encoding_step_2: typing.Optional[LimitType] = None,
    ):
        self.kspace_encoding_step_0 = kspace_encoding_step_0 if kspace_encoding_step_0 is not None else LimitType()
        self.kspace_encoding_step_1 = kspace_encoding_step_1 if kspace_encoding_step_1 is not None else LimitType()
        self.kspace_encoding_step_2 = kspace_encoding_step_2 if kspace_encoding_step_2 is not None else LimitType()

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, SamplingLimits)
            and self.kspace_encoding_step_0 == other.kspace_encoding_step_0
            and self.kspace_encoding_step_1 == other.kspace_encoding_step_1
            and self.kspace_encoding_step_2 == other.kspace_encoding_step_2
        )

    def __str__(self) -> str:
        return f"SamplingLimits(kspace_encoding_step_0={self.kspace_encoding_step_0}, kspace_encoding_step_1={self.kspace_encoding_step_1}, kspace_encoding_step_2={self.kspace_encoding_step_2})"

    def __repr__(self) -> str:
        return f"SamplingLimits(kspace_encoding_step_0={repr(self.kspace_encoding_step_0)}, kspace_encoding_step_1={repr(self.kspace_encoding_step_1)}, kspace_encoding_step_2={repr(self.kspace_encoding_step_2)})"


class SamplingDescription:
    encoded_fov: FieldOfViewMm
    recon_fov: FieldOfViewMm
    encoded_matrix: MatrixSizeType
    recon_matrix: MatrixSizeType
    sampling_limits: SamplingLimits

    def __init__(self, *,
        encoded_fov: typing.Optional[FieldOfViewMm] = None,
        recon_fov: typing.Optional[FieldOfViewMm] = None,
        encoded_matrix: typing.Optional[MatrixSizeType] = None,
        recon_matrix: typing.Optional[MatrixSizeType] = None,
        sampling_limits: typing.Optional[SamplingLimits] = None,
    ):
        self.encoded_fov = encoded_fov if encoded_fov is not None else FieldOfViewMm()
        self.recon_fov = recon_fov if recon_fov is not None else FieldOfViewMm()
        self.encoded_matrix = encoded_matrix if encoded_matrix is not None else MatrixSizeType()
        self.recon_matrix = recon_matrix if recon_matrix is not None else MatrixSizeType()
        self.sampling_limits = sampling_limits if sampling_limits is not None else SamplingLimits()

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, SamplingDescription)
            and self.encoded_fov == other.encoded_fov
            and self.recon_fov == other.recon_fov
            and self.encoded_matrix == other.encoded_matrix
            and self.recon_matrix == other.recon_matrix
            and self.sampling_limits == other.sampling_limits
        )

    def __str__(self) -> str:
        return f"SamplingDescription(encoded_fov={self.encoded_fov}, recon_fov={self.recon_fov}, encoded_matrix={self.encoded_matrix}, recon_matrix={self.recon_matrix}, sampling_limits={self.sampling_limits})"

    def __repr__(self) -> str:
        return f"SamplingDescription(encoded_fov={repr(self.encoded_fov)}, recon_fov={repr(self.recon_fov)}, encoded_matrix={repr(self.encoded_matrix)}, recon_matrix={repr(self.recon_matrix)}, sampling_limits={repr(self.sampling_limits)})"


class ReconBuffer:
    data: npt.NDArray[np.complex64]
    """Buffered Acquisition data"""

    trajectory: npt.NDArray[np.float32]
    """Buffered Trajectory data"""

    density: typing.Optional[npt.NDArray[np.float32]]
    """Buffered Density weights"""

    headers: npt.NDArray[np.void]
    """Buffered AcquisitionHeaders"""

    sampling: SamplingDescription
    """Sampling details for these Acquisitions"""


    def __init__(self, *,
        data: typing.Optional[npt.NDArray[np.complex64]] = None,
        trajectory: typing.Optional[npt.NDArray[np.float32]] = None,
        density: typing.Optional[npt.NDArray[np.float32]] = None,
        headers: typing.Optional[npt.NDArray[np.void]] = None,
        sampling: typing.Optional[SamplingDescription] = None,
    ):
        self.data = data if data is not None else np.zeros((0, 0, 0, 0, 0, 0, 0), dtype=np.dtype(np.complex64))
        self.trajectory = trajectory if trajectory is not None else np.zeros((0, 0, 0, 0, 0, 0, 0), dtype=np.dtype(np.float32))
        self.density = density
        self.headers = headers if headers is not None else np.zeros((0, 0, 0, 0, 0), dtype=get_dtype(AcquisitionHeader))
        self.sampling = sampling if sampling is not None else SamplingDescription()

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, ReconBuffer)
            and yardl.structural_equal(self.data, other.data)
            and yardl.structural_equal(self.trajectory, other.trajectory)
            and (other.density is None if self.density is None else (other.density is not None and yardl.structural_equal(self.density, other.density)))
            and yardl.structural_equal(self.headers, other.headers)
            and self.sampling == other.sampling
        )

    def __str__(self) -> str:
        return f"ReconBuffer(data={self.data}, trajectory={self.trajectory}, density={self.density}, headers={self.headers}, sampling={self.sampling})"

    def __repr__(self) -> str:
        return f"ReconBuffer(data={repr(self.data)}, trajectory={repr(self.trajectory)}, density={repr(self.density)}, headers={repr(self.headers)}, sampling={repr(self.sampling)})"


class ReconAssembly:
    data: ReconBuffer
    ref: typing.Optional[ReconBuffer]

    def __init__(self, *,
        data: typing.Optional[ReconBuffer] = None,
        ref: typing.Optional[ReconBuffer] = None,
    ):
        self.data = data if data is not None else ReconBuffer()
        self.ref = ref

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, ReconAssembly)
            and self.data == other.data
            and (other.ref is None if self.ref is None else (other.ref is not None and self.ref == other.ref))
        )

    def __str__(self) -> str:
        return f"ReconAssembly(data={self.data}, ref={self.ref})"

    def __repr__(self) -> str:
        return f"ReconAssembly(data={repr(self.data)}, ref={repr(self.ref)})"


class ReconData:
    buffers: list[ReconAssembly]

    def __init__(self, *,
        buffers: typing.Optional[list[ReconAssembly]] = None,
    ):
        self.buffers = buffers if buffers is not None else []

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, ReconData)
            and len(self.buffers) == len(other.buffers) and all(a == b for a, b in zip(self.buffers, other.buffers))
        )

    def __str__(self) -> str:
        return f"ReconData(buffers={self.buffers})"

    def __repr__(self) -> str:
        return f"ReconData(buffers={repr(self.buffers)})"


class ImageArray:
    data: npt.NDArray[np.complex64]
    headers: npt.NDArray[np.void]
    meta: npt.NDArray[np.object_]
    waveforms: list[WaveformUint32]

    def __init__(self, *,
        data: typing.Optional[npt.NDArray[np.complex64]] = None,
        headers: typing.Optional[npt.NDArray[np.void]] = None,
        meta: typing.Optional[npt.NDArray[np.object_]] = None,
        waveforms: typing.Optional[list[WaveformUint32]] = None,
    ):
        self.data = data if data is not None else np.zeros((0, 0, 0, 0, 0, 0, 0), dtype=np.dtype(np.complex64))
        self.headers = headers if headers is not None else np.zeros((0, 0, 0), dtype=get_dtype(ImageHeader))
        self.meta = meta if meta is not None else np.zeros((0, 0, 0), dtype=np.dtype(np.object_))
        self.waveforms = waveforms if waveforms is not None else []

    def __eq__(self, other: object) -> bool:
        return (
            isinstance(other, ImageArray)
            and yardl.structural_equal(self.data, other.data)
            and yardl.structural_equal(self.headers, other.headers)
            and yardl.structural_equal(self.meta, other.meta)
            and len(self.waveforms) == len(other.waveforms) and all(a == b for a, b in zip(self.waveforms, other.waveforms))
        )

    def __str__(self) -> str:
        return f"ImageArray(data={self.data}, headers={self.headers}, meta={self.meta}, waveforms={self.waveforms})"

    def __repr__(self) -> str:
        return f"ImageArray(data={repr(self.data)}, headers={repr(self.headers)}, meta={repr(self.meta)}, waveforms={repr(self.waveforms)})"


Array = npt.NDArray[T_NP]

ArrayComplexFloat = Array[np.complex64]

class StreamItem:
    Acquisition: typing.ClassVar[type["StreamItemUnionCase[Acquisition]"]]
    WaveformUint32: typing.ClassVar[type["StreamItemUnionCase[WaveformUint32]"]]
    ImageUint16: typing.ClassVar[type["StreamItemUnionCase[ImageUint16]"]]
    ImageInt16: typing.ClassVar[type["StreamItemUnionCase[ImageInt16]"]]
    ImageUint32: typing.ClassVar[type["StreamItemUnionCase[ImageUint32]"]]
    ImageInt32: typing.ClassVar[type["StreamItemUnionCase[ImageInt32]"]]
    ImageFloat: typing.ClassVar[type["StreamItemUnionCase[ImageFloat]"]]
    ImageDouble: typing.ClassVar[type["StreamItemUnionCase[ImageDouble]"]]
    ImageComplexFloat: typing.ClassVar[type["StreamItemUnionCase[ImageComplexFloat]"]]
    ImageComplexDouble: typing.ClassVar[type["StreamItemUnionCase[ImageComplexDouble]"]]
    AcquisitionBucket: typing.ClassVar[type["StreamItemUnionCase[AcquisitionBucket]"]]
    ReconData: typing.ClassVar[type["StreamItemUnionCase[ReconData]"]]
    ArrayComplexFloat: typing.ClassVar[type["StreamItemUnionCase[ArrayComplexFloat]"]]
    ImageArray: typing.ClassVar[type["StreamItemUnionCase[ImageArray]"]]

class StreamItemUnionCase(StreamItem, yardl.UnionCase[_T]):
    pass

StreamItem.Acquisition = type("StreamItem.Acquisition", (StreamItemUnionCase,), {"index": 0, "tag": "Acquisition"})
StreamItem.WaveformUint32 = type("StreamItem.WaveformUint32", (StreamItemUnionCase,), {"index": 1, "tag": "WaveformUint32"})
StreamItem.ImageUint16 = type("StreamItem.ImageUint16", (StreamItemUnionCase,), {"index": 2, "tag": "ImageUint16"})
StreamItem.ImageInt16 = type("StreamItem.ImageInt16", (StreamItemUnionCase,), {"index": 3, "tag": "ImageInt16"})
StreamItem.ImageUint32 = type("StreamItem.ImageUint32", (StreamItemUnionCase,), {"index": 4, "tag": "ImageUint32"})
StreamItem.ImageInt32 = type("StreamItem.ImageInt32", (StreamItemUnionCase,), {"index": 5, "tag": "ImageInt32"})
StreamItem.ImageFloat = type("StreamItem.ImageFloat", (StreamItemUnionCase,), {"index": 6, "tag": "ImageFloat"})
StreamItem.ImageDouble = type("StreamItem.ImageDouble", (StreamItemUnionCase,), {"index": 7, "tag": "ImageDouble"})
StreamItem.ImageComplexFloat = type("StreamItem.ImageComplexFloat", (StreamItemUnionCase,), {"index": 8, "tag": "ImageComplexFloat"})
StreamItem.ImageComplexDouble = type("StreamItem.ImageComplexDouble", (StreamItemUnionCase,), {"index": 9, "tag": "ImageComplexDouble"})
StreamItem.AcquisitionBucket = type("StreamItem.AcquisitionBucket", (StreamItemUnionCase,), {"index": 10, "tag": "AcquisitionBucket"})
StreamItem.ReconData = type("StreamItem.ReconData", (StreamItemUnionCase,), {"index": 11, "tag": "ReconData"})
StreamItem.ArrayComplexFloat = type("StreamItem.ArrayComplexFloat", (StreamItemUnionCase,), {"index": 12, "tag": "ArrayComplexFloat"})
StreamItem.ImageArray = type("StreamItem.ImageArray", (StreamItemUnionCase,), {"index": 13, "tag": "ImageArray"})
del StreamItemUnionCase

def _mk_get_dtype():
    dtype_map: dict[typing.Union[type, types.GenericAlias, typing.Annotated[typing.Any, typing.Any]], typing.Union[np.dtype[typing.Any], typing.Callable[[tuple[type, ...]], np.dtype[typing.Any]]]] = {}
    get_dtype = _dtypes.make_get_dtype_func(dtype_map)

    dtype_map.setdefault(AcquisitionFlags, np.dtype(np.uint64))
    dtype_map.setdefault(EncodingCounters, np.dtype([('kspace_encode_step_1', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('kspace_encode_step_2', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('average', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('slice', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('contrast', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('phase', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('repetition', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('set', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('segment', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('user', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(AcquisitionHeader, np.dtype([('flags', get_dtype(AcquisitionFlags)), ('idx', get_dtype(EncodingCounters)), ('measurement_uid', np.dtype(np.uint32)), ('scan_counter', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('acquisition_time_stamp_ns', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint64))], align=True)), ('physiology_time_stamp_ns', np.dtype(np.object_)), ('channel_order', np.dtype(np.object_)), ('discard_pre', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('discard_post', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('center_sample', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('encoding_space_ref', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('sample_time_ns', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint64))], align=True)), ('position', np.dtype(np.float32), (3,)), ('read_dir', np.dtype(np.float32), (3,)), ('phase_dir', np.dtype(np.float32), (3,)), ('slice_dir', np.dtype(np.float32), (3,)), ('patient_table_position', np.dtype(np.float32), (3,)), ('user_int', np.dtype(np.object_)), ('user_float', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(Acquisition, np.dtype([('head', get_dtype(AcquisitionHeader)), ('data', np.dtype(np.object_)), ('trajectory', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(PatientGender, np.dtype(np.int32))
    dtype_map.setdefault(SubjectInformationType, np.dtype([('patient_name', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('patient_weight_kg', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.float32))], align=True)), ('patient_height_m', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.float32))], align=True)), ('patient_id', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('patient_birthdate', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.datetime64))], align=True)), ('patient_gender', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(PatientGender))], align=True))], align=True))
    dtype_map.setdefault(StudyInformationType, np.dtype([('study_date', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.datetime64))], align=True)), ('study_time', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.timedelta64))], align=True)), ('study_id', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('accession_number', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.int64))], align=True)), ('referring_physician_name', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('study_description', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('study_instance_uid', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('body_part_examined', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True))], align=True))
    dtype_map.setdefault(PatientPosition, np.dtype(np.int32))
    dtype_map.setdefault(ThreeDimensionalFloat, np.dtype([('x', np.dtype(np.float32)), ('y', np.dtype(np.float32)), ('z', np.dtype(np.float32))], align=True))
    dtype_map.setdefault(MeasurementDependencyType, np.dtype([('dependency_type', np.dtype(np.object_)), ('measurement_id', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(ReferencedImageSequenceType, np.dtype([('referenced_sop_instance_uid', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(MeasurementInformationType, np.dtype([('measurement_id', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('series_date', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.datetime64))], align=True)), ('series_time', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.timedelta64))], align=True)), ('patient_position', get_dtype(PatientPosition)), ('relative_table_position', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(ThreeDimensionalFloat))], align=True)), ('initial_series_number', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.int64))], align=True)), ('protocol_name', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('sequence_name', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('series_description', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('measurement_dependency', np.dtype(np.object_)), ('series_instance_uid_root', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('frame_of_reference_uid', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('referenced_image_sequence', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(ReferencedImageSequenceType))], align=True))], align=True))
    dtype_map.setdefault(CoilLabelType, np.dtype([('coil_number', np.dtype(np.uint32)), ('coil_name', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(AcquisitionSystemInformationType, np.dtype([('system_vendor', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('system_model', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('system_field_strength_t', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.float32))], align=True)), ('relative_receiver_noise_bandwidth', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.float32))], align=True)), ('receiver_channels', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('coil_label', np.dtype(np.object_)), ('institution_name', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('station_name', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('device_id', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('device_serial_number', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True))], align=True))
    dtype_map.setdefault(ExperimentalConditionsType, np.dtype([('h1resonance_frequency_hz', np.dtype(np.int64))], align=True))
    dtype_map.setdefault(MatrixSizeType, np.dtype([('x', np.dtype(np.uint32)), ('y', np.dtype(np.uint32)), ('z', np.dtype(np.uint32))], align=True))
    dtype_map.setdefault(FieldOfViewMm, np.dtype([('x', np.dtype(np.float32)), ('y', np.dtype(np.float32)), ('z', np.dtype(np.float32))], align=True))
    dtype_map.setdefault(EncodingSpaceType, np.dtype([('matrix_size', get_dtype(MatrixSizeType)), ('field_of_view_mm', get_dtype(FieldOfViewMm))], align=True))
    dtype_map.setdefault(LimitType, np.dtype([('minimum', np.dtype(np.uint32)), ('maximum', np.dtype(np.uint32)), ('center', np.dtype(np.uint32))], align=True))
    dtype_map.setdefault(EncodingLimitsType, np.dtype([('kspace_encoding_step_0', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('kspace_encoding_step_1', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('kspace_encoding_step_2', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('average', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('slice', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('contrast', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('phase', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('repetition', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('set', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('segment', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('user_0', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('user_1', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('user_2', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('user_3', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('user_4', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('user_5', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('user_6', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True)), ('user_7', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(LimitType))], align=True))], align=True))
    dtype_map.setdefault(Trajectory, np.dtype(np.int32))
    dtype_map.setdefault(UserParameterLongType, np.dtype([('name', np.dtype(np.object_)), ('value', np.dtype(np.int64))], align=True))
    dtype_map.setdefault(UserParameterDoubleType, np.dtype([('name', np.dtype(np.object_)), ('value', np.dtype(np.float64))], align=True))
    dtype_map.setdefault(UserParameterStringType, np.dtype([('name', np.dtype(np.object_)), ('value', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(TrajectoryDescriptionType, np.dtype([('identifier', np.dtype(np.object_)), ('user_parameter_long', np.dtype(np.object_)), ('user_parameter_double', np.dtype(np.object_)), ('user_parameter_string', np.dtype(np.object_)), ('comment', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True))], align=True))
    dtype_map.setdefault(AccelerationFactorType, np.dtype([('kspace_encoding_step_1', np.dtype(np.uint32)), ('kspace_encoding_step_2', np.dtype(np.uint32))], align=True))
    dtype_map.setdefault(CalibrationMode, np.dtype(np.int32))
    dtype_map.setdefault(InterleavingDimension, np.dtype(np.int32))
    dtype_map.setdefault(MultibandSpacingType, np.dtype([('d_z', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(Calibration, np.dtype(np.int32))
    dtype_map.setdefault(MultibandType, np.dtype([('spacing', np.dtype(np.object_)), ('delta_kz', np.dtype(np.float32)), ('multiband_factor', np.dtype(np.uint32)), ('calibration', get_dtype(Calibration)), ('calibration_encoding', np.dtype(np.uint64))], align=True))
    dtype_map.setdefault(ParallelImagingType, np.dtype([('acceleration_factor', get_dtype(AccelerationFactorType)), ('calibration_mode', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(CalibrationMode))], align=True)), ('interleaving_dimension', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(InterleavingDimension))], align=True)), ('multiband', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(MultibandType))], align=True))], align=True))
    dtype_map.setdefault(EncodingType, np.dtype([('encoded_space', get_dtype(EncodingSpaceType)), ('recon_space', get_dtype(EncodingSpaceType)), ('encoding_limits', get_dtype(EncodingLimitsType)), ('trajectory', get_dtype(Trajectory)), ('trajectory_description', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(TrajectoryDescriptionType))], align=True)), ('parallel_imaging', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(ParallelImagingType))], align=True)), ('echo_train_length', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.int64))], align=True))], align=True))
    dtype_map.setdefault(DiffusionDimension, np.dtype(np.int32))
    dtype_map.setdefault(GradientDirectionType, np.dtype([('rl', np.dtype(np.float32)), ('ap', np.dtype(np.float32)), ('fh', np.dtype(np.float32))], align=True))
    dtype_map.setdefault(DiffusionType, np.dtype([('gradient_direction', get_dtype(GradientDirectionType)), ('bvalue', np.dtype(np.float32))], align=True))
    dtype_map.setdefault(SequenceParametersType, np.dtype([('t_r', np.dtype(np.object_)), ('t_e', np.dtype(np.object_)), ('t_i', np.dtype(np.object_)), ('flip_angle_deg', np.dtype(np.object_)), ('sequence_type', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('echo_spacing', np.dtype(np.object_)), ('diffusion_dimension', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(DiffusionDimension))], align=True)), ('diffusion', np.dtype(np.object_)), ('diffusion_scheme', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True))], align=True))
    dtype_map.setdefault(UserParameterBase64Type, np.dtype([('name', np.dtype(np.object_)), ('value', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(UserParametersType, np.dtype([('user_parameter_long', np.dtype(np.object_)), ('user_parameter_double', np.dtype(np.object_)), ('user_parameter_string', np.dtype(np.object_)), ('user_parameter_base64', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(WaveformType, np.dtype(np.int32))
    dtype_map.setdefault(WaveformInformationType, np.dtype([('waveform_name', np.dtype(np.object_)), ('waveform_type', get_dtype(WaveformType)), ('user_parameters', get_dtype(UserParametersType))], align=True))
    dtype_map.setdefault(Header, np.dtype([('version', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.int64))], align=True)), ('subject_information', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(SubjectInformationType))], align=True)), ('study_information', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(StudyInformationType))], align=True)), ('measurement_information', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(MeasurementInformationType))], align=True)), ('acquisition_system_information', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(AcquisitionSystemInformationType))], align=True)), ('experimental_conditions', get_dtype(ExperimentalConditionsType)), ('encoding', np.dtype(np.object_)), ('sequence_parameters', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(SequenceParametersType))], align=True)), ('user_parameters', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(UserParametersType))], align=True)), ('waveform_information', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(ImageFlags, np.dtype(np.uint64))
    dtype_map.setdefault(ImageType, np.dtype(np.int32))
    dtype_map.setdefault(ImageHeader, np.dtype([('flags', get_dtype(ImageFlags)), ('measurement_uid', np.dtype(np.uint32)), ('field_of_view', np.dtype(np.float32), (3,)), ('position', np.dtype(np.float32), (3,)), ('col_dir', np.dtype(np.float32), (3,)), ('line_dir', np.dtype(np.float32), (3,)), ('slice_dir', np.dtype(np.float32), (3,)), ('patient_table_position', np.dtype(np.float32), (3,)), ('average', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('slice', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('contrast', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('phase', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('repetition', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('set', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('acquisition_time_stamp_ns', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint64))], align=True)), ('physiology_time_stamp_ns', np.dtype(np.object_)), ('image_type', get_dtype(ImageType)), ('image_index', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('image_series_index', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.uint32))], align=True)), ('user_int', np.dtype(np.object_)), ('user_float', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(ImageMetaValue, np.dtype(np.object_))
    dtype_map.setdefault(Image, lambda type_args: np.dtype([('head', get_dtype(ImageHeader)), ('data', np.dtype(np.object_)), ('meta', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(ImageUint16, get_dtype(types.GenericAlias(Image, (yardl.UInt16,))))
    dtype_map.setdefault(ImageInt16, get_dtype(types.GenericAlias(Image, (yardl.Int16,))))
    dtype_map.setdefault(ImageUint32, get_dtype(types.GenericAlias(Image, (yardl.UInt32,))))
    dtype_map.setdefault(ImageInt32, get_dtype(types.GenericAlias(Image, (yardl.Int32,))))
    dtype_map.setdefault(ImageFloat, get_dtype(types.GenericAlias(Image, (yardl.Float32,))))
    dtype_map.setdefault(ImageDouble, get_dtype(types.GenericAlias(Image, (yardl.Float64,))))
    dtype_map.setdefault(ImageComplexFloat, get_dtype(types.GenericAlias(Image, (yardl.ComplexFloat,))))
    dtype_map.setdefault(ImageComplexDouble, get_dtype(types.GenericAlias(Image, (yardl.ComplexDouble,))))
    dtype_map.setdefault(AnyImage, np.dtype(np.object_))
    dtype_map.setdefault(NoiseCovariance, np.dtype([('coil_labels', np.dtype(np.object_)), ('receiver_noise_bandwidth', np.dtype(np.float32)), ('noise_dwell_time_ns', np.dtype(np.uint64)), ('sample_count', np.dtype(np.uint64)), ('matrix', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(Waveform, lambda type_args: np.dtype([('flags', np.dtype(np.uint64)), ('measurement_uid', np.dtype(np.uint32)), ('scan_counter', np.dtype(np.uint32)), ('time_stamp_ns', np.dtype(np.uint64)), ('sample_time_ns', np.dtype(np.uint64)), ('waveform_id', np.dtype(np.uint32)), ('data', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(WaveformUint32, get_dtype(types.GenericAlias(Waveform, (yardl.UInt32,))))
    dtype_map.setdefault(AcquisitionBucket, np.dtype([('data', np.dtype(np.object_)), ('ref', np.dtype(np.object_)), ('datastats', np.dtype(np.object_)), ('refstats', np.dtype(np.object_)), ('waveforms', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(SamplingLimits, np.dtype([('kspace_encoding_step_0', get_dtype(LimitType)), ('kspace_encoding_step_1', get_dtype(LimitType)), ('kspace_encoding_step_2', get_dtype(LimitType))], align=True))
    dtype_map.setdefault(SamplingDescription, np.dtype([('encoded_fov', get_dtype(FieldOfViewMm)), ('recon_fov', get_dtype(FieldOfViewMm)), ('encoded_matrix', get_dtype(MatrixSizeType)), ('recon_matrix', get_dtype(MatrixSizeType)), ('sampling_limits', get_dtype(SamplingLimits))], align=True))
    dtype_map.setdefault(ReconBuffer, np.dtype([('data', np.dtype(np.object_)), ('trajectory', np.dtype(np.object_)), ('density', np.dtype([('has_value', np.dtype(np.bool_)), ('value', np.dtype(np.object_))], align=True)), ('headers', np.dtype(np.object_)), ('sampling', get_dtype(SamplingDescription))], align=True))
    dtype_map.setdefault(ReconAssembly, np.dtype([('data', get_dtype(ReconBuffer)), ('ref', np.dtype([('has_value', np.dtype(np.bool_)), ('value', get_dtype(ReconBuffer))], align=True))], align=True))
    dtype_map.setdefault(ReconData, np.dtype([('buffers', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(ImageArray, np.dtype([('data', np.dtype(np.object_)), ('headers', np.dtype(np.object_)), ('meta', np.dtype(np.object_)), ('waveforms', np.dtype(np.object_))], align=True))
    dtype_map.setdefault(StreamItem, np.dtype(np.object_))

    return get_dtype

get_dtype = _mk_get_dtype()

