# MultiInstanceLinux
Multi Instance Macro Handler for Minecraft on Linux.

# Features
- 1.16.1 RSG support.
- Wall support.
- OBS integration for Wall Resetting.
- Full keyboard support.
- Distributed through pip for easy installation.
- Multi Threading for better script performance.
- An "almost" drop-in repleacement on Linux for [Specnr's macro designed for Windows](https://github.com/Specnr/MultiResetWall)

# Dependencies
- [keyboard](https://github.com/boppreh/keyboard) (Installed by pip)
- [wmctrl](https://github.com/dancor/wmctrl)
- [xdotool](https://github.com/jordansissel/xdotool)
- [Atum](https://github.com/VoidXWalker/Atum)
- [FastReset](https://github.com/jan-leila/FastReset/tree/1.16.1-1.4.1)
- [obs-websocket-py](https://github.com/Elektordi/obs-websocket-py) (Optional but installed by pip)
- [OBS websocket plugin](https://github.com/obsproject/obs-websocket) (Optional)
- [WorldPreview](https://github.com/VoidXWalker/worldPreview/tree/1.16.1) (Optional)

# Installation
- Installation instructions have been moved to the wiki. Refer [here](https://github.com/sathya-pramodh/MultiInstanceLinux/wiki/1.-Home).

# Contribution
- Code contributions can be made to the main branch. Pull requests must be made with proper comments and documentation.
- The code must follow all PEP 8 conventions and must be in python3.x ONLY.
- Contributions to the documentation or testing are always appreciated.

# Default Keybinds
- `u` - Reset all instances (RSG)
- `p` - Reset the current instance (RSG)
- `o` - Switch to the wall scene on OBS (Only while using wall).
- `Ctrl+1` - Switch to Instance 1
- `Ctrl+2` - Switch to Instance 2
- `Ctrl+3` - Switch to Instance 3
- `Ctrl+4` - Switch to Instance 4
- `Ctrl+5` - Switch to Instance 5
- `Ctrl+6` - Switch to Instance 6
- `Ctrl+7` - Switch to Instance 7
- `Ctrl+8` - Switch to Instance 8
- `Ctrl+9` - Switch to Instance 9

# Configuration
- Configuration instructions and variable descriptions have been moved to the wiki. Refer [here](https://github.com/sathya-pramodh/MultiInstanceLinux/wiki/6.-Configuring-the-Script).

# Planned features
- Mouse support on wall.
- Instance locking support.
- TTS support.

# Thanks
- [GuffGuffGuffy](https://twitch.tv/guffguffguffy) for helping me with the testing of the macro.
- [Specnr](https://github.com/specnr) for creating the macro for Windows.
- Everyone else that Specnr mentioned [here](https://github.com/specnr/MultiResetWall).
- All the devs of the dependency packages/modules.
