# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class CreateLiveStreamRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'playback_policy': 'list[PlaybackPolicy]',
        'new_asset_settings': 'CreateAssetRequest',
        'reconnect_window': 'float',
        'use_slate_for_standard_latency': 'bool',
        'reconnect_slate_url': 'str',
        'passthrough': 'str',
        'audio_only': 'bool',
        'embedded_subtitles': 'list[LiveStreamEmbeddedSubtitleSettings]',
        'generated_subtitles': 'list[LiveStreamGeneratedSubtitleSettings]',
        'reduced_latency': 'bool',
        'low_latency': 'bool',
        'latency_mode': 'str',
        'test': 'bool',
        'simulcast_targets': 'list[CreateSimulcastTargetRequest]',
        'max_continuous_duration': 'int'
    }

    attribute_map = {
        'playback_policy': 'playback_policy',
        'new_asset_settings': 'new_asset_settings',
        'reconnect_window': 'reconnect_window',
        'use_slate_for_standard_latency': 'use_slate_for_standard_latency',
        'reconnect_slate_url': 'reconnect_slate_url',
        'passthrough': 'passthrough',
        'audio_only': 'audio_only',
        'embedded_subtitles': 'embedded_subtitles',
        'generated_subtitles': 'generated_subtitles',
        'reduced_latency': 'reduced_latency',
        'low_latency': 'low_latency',
        'latency_mode': 'latency_mode',
        'test': 'test',
        'simulcast_targets': 'simulcast_targets',
        'max_continuous_duration': 'max_continuous_duration'
    }

    def __init__(self, playback_policy=None, new_asset_settings=None, reconnect_window=60, use_slate_for_standard_latency=False, reconnect_slate_url=None, passthrough=None, audio_only=None, embedded_subtitles=None, generated_subtitles=None, reduced_latency=None, low_latency=None, latency_mode=None, test=None, simulcast_targets=None, max_continuous_duration=43200, local_vars_configuration=None):  # noqa: E501
        """CreateLiveStreamRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._playback_policy = None
        self._new_asset_settings = None
        self._reconnect_window = None
        self._use_slate_for_standard_latency = None
        self._reconnect_slate_url = None
        self._passthrough = None
        self._audio_only = None
        self._embedded_subtitles = None
        self._generated_subtitles = None
        self._reduced_latency = None
        self._low_latency = None
        self._latency_mode = None
        self._test = None
        self._simulcast_targets = None
        self._max_continuous_duration = None
        self.discriminator = None

        if playback_policy is not None:
            self.playback_policy = playback_policy
        if new_asset_settings is not None:
            self.new_asset_settings = new_asset_settings
        if reconnect_window is not None:
            self.reconnect_window = reconnect_window
        if use_slate_for_standard_latency is not None:
            self.use_slate_for_standard_latency = use_slate_for_standard_latency
        if reconnect_slate_url is not None:
            self.reconnect_slate_url = reconnect_slate_url
        if passthrough is not None:
            self.passthrough = passthrough
        if audio_only is not None:
            self.audio_only = audio_only
        if embedded_subtitles is not None:
            self.embedded_subtitles = embedded_subtitles
        if generated_subtitles is not None:
            self.generated_subtitles = generated_subtitles
        if reduced_latency is not None:
            self.reduced_latency = reduced_latency
        if low_latency is not None:
            self.low_latency = low_latency
        if latency_mode is not None:
            self.latency_mode = latency_mode
        if test is not None:
            self.test = test
        if simulcast_targets is not None:
            self.simulcast_targets = simulcast_targets
        if max_continuous_duration is not None:
            self.max_continuous_duration = max_continuous_duration

    @property
    def playback_policy(self):
        """Gets the playback_policy of this CreateLiveStreamRequest.  # noqa: E501


        :return: The playback_policy of this CreateLiveStreamRequest.  # noqa: E501
        :rtype: list[PlaybackPolicy]
        """
        return self._playback_policy

    @playback_policy.setter
    def playback_policy(self, playback_policy):
        """Sets the playback_policy of this CreateLiveStreamRequest.


        :param playback_policy: The playback_policy of this CreateLiveStreamRequest.  # noqa: E501
        :type playback_policy: list[PlaybackPolicy]
        """

        self._playback_policy = playback_policy

    @property
    def new_asset_settings(self):
        """Gets the new_asset_settings of this CreateLiveStreamRequest.  # noqa: E501


        :return: The new_asset_settings of this CreateLiveStreamRequest.  # noqa: E501
        :rtype: CreateAssetRequest
        """
        return self._new_asset_settings

    @new_asset_settings.setter
    def new_asset_settings(self, new_asset_settings):
        """Sets the new_asset_settings of this CreateLiveStreamRequest.


        :param new_asset_settings: The new_asset_settings of this CreateLiveStreamRequest.  # noqa: E501
        :type new_asset_settings: CreateAssetRequest
        """

        self._new_asset_settings = new_asset_settings

    @property
    def reconnect_window(self):
        """Gets the reconnect_window of this CreateLiveStreamRequest.  # noqa: E501

        When live streaming software disconnects from Mux, either intentionally or due to a drop in the network, the Reconnect Window is the time in seconds that Mux should wait for the streaming software to reconnect before considering the live stream finished and completing the recorded asset. Defaults to 60 seconds on the API if not specified.  If not specified directly, Standard Latency streams have a Reconnect Window of 60 seconds; Reduced and Low Latency streams have a default of 0 seconds, or no Reconnect Window. For that reason, we suggest specifying a value other than zero for Reduced and Low Latency streams.  Reduced and Low Latency streams with a Reconnect Window greater than zero will insert slate media into the recorded asset while waiting for the streaming software to reconnect or when there are brief interruptions in the live stream media. When using a Reconnect Window setting higher than 60 seconds with a Standard Latency stream, we highly recommend enabling slate with the `use_slate_for_standard_latency` option.   # noqa: E501

        :return: The reconnect_window of this CreateLiveStreamRequest.  # noqa: E501
        :rtype: float
        """
        return self._reconnect_window

    @reconnect_window.setter
    def reconnect_window(self, reconnect_window):
        """Sets the reconnect_window of this CreateLiveStreamRequest.

        When live streaming software disconnects from Mux, either intentionally or due to a drop in the network, the Reconnect Window is the time in seconds that Mux should wait for the streaming software to reconnect before considering the live stream finished and completing the recorded asset. Defaults to 60 seconds on the API if not specified.  If not specified directly, Standard Latency streams have a Reconnect Window of 60 seconds; Reduced and Low Latency streams have a default of 0 seconds, or no Reconnect Window. For that reason, we suggest specifying a value other than zero for Reduced and Low Latency streams.  Reduced and Low Latency streams with a Reconnect Window greater than zero will insert slate media into the recorded asset while waiting for the streaming software to reconnect or when there are brief interruptions in the live stream media. When using a Reconnect Window setting higher than 60 seconds with a Standard Latency stream, we highly recommend enabling slate with the `use_slate_for_standard_latency` option.   # noqa: E501

        :param reconnect_window: The reconnect_window of this CreateLiveStreamRequest.  # noqa: E501
        :type reconnect_window: float
        """
        if (self.local_vars_configuration.client_side_validation and
                reconnect_window is not None and reconnect_window > 1800):  # noqa: E501
            raise ValueError("Invalid value for `reconnect_window`, must be a value less than or equal to `1800`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                reconnect_window is not None and reconnect_window < 0):  # noqa: E501
            raise ValueError("Invalid value for `reconnect_window`, must be a value greater than or equal to `0`")  # noqa: E501

        self._reconnect_window = reconnect_window

    @property
    def use_slate_for_standard_latency(self):
        """Gets the use_slate_for_standard_latency of this CreateLiveStreamRequest.  # noqa: E501

        By default, Standard Latency live streams do not have slate media inserted while waiting for live streaming software to reconnect to Mux. Setting this to true enables slate insertion on a Standard Latency stream.  # noqa: E501

        :return: The use_slate_for_standard_latency of this CreateLiveStreamRequest.  # noqa: E501
        :rtype: bool
        """
        return self._use_slate_for_standard_latency

    @use_slate_for_standard_latency.setter
    def use_slate_for_standard_latency(self, use_slate_for_standard_latency):
        """Sets the use_slate_for_standard_latency of this CreateLiveStreamRequest.

        By default, Standard Latency live streams do not have slate media inserted while waiting for live streaming software to reconnect to Mux. Setting this to true enables slate insertion on a Standard Latency stream.  # noqa: E501

        :param use_slate_for_standard_latency: The use_slate_for_standard_latency of this CreateLiveStreamRequest.  # noqa: E501
        :type use_slate_for_standard_latency: bool
        """

        self._use_slate_for_standard_latency = use_slate_for_standard_latency

    @property
    def reconnect_slate_url(self):
        """Gets the reconnect_slate_url of this CreateLiveStreamRequest.  # noqa: E501

        The URL of the image file that Mux should download and use as slate media during interruptions of the live stream media. This file will be downloaded each time a new recorded asset is created from the live stream. If this is not set, the default slate media will be used.  # noqa: E501

        :return: The reconnect_slate_url of this CreateLiveStreamRequest.  # noqa: E501
        :rtype: str
        """
        return self._reconnect_slate_url

    @reconnect_slate_url.setter
    def reconnect_slate_url(self, reconnect_slate_url):
        """Sets the reconnect_slate_url of this CreateLiveStreamRequest.

        The URL of the image file that Mux should download and use as slate media during interruptions of the live stream media. This file will be downloaded each time a new recorded asset is created from the live stream. If this is not set, the default slate media will be used.  # noqa: E501

        :param reconnect_slate_url: The reconnect_slate_url of this CreateLiveStreamRequest.  # noqa: E501
        :type reconnect_slate_url: str
        """

        self._reconnect_slate_url = reconnect_slate_url

    @property
    def passthrough(self):
        """Gets the passthrough of this CreateLiveStreamRequest.  # noqa: E501


        :return: The passthrough of this CreateLiveStreamRequest.  # noqa: E501
        :rtype: str
        """
        return self._passthrough

    @passthrough.setter
    def passthrough(self, passthrough):
        """Sets the passthrough of this CreateLiveStreamRequest.


        :param passthrough: The passthrough of this CreateLiveStreamRequest.  # noqa: E501
        :type passthrough: str
        """

        self._passthrough = passthrough

    @property
    def audio_only(self):
        """Gets the audio_only of this CreateLiveStreamRequest.  # noqa: E501

        Force the live stream to only process the audio track when the value is set to true. Mux drops the video track if broadcasted.  # noqa: E501

        :return: The audio_only of this CreateLiveStreamRequest.  # noqa: E501
        :rtype: bool
        """
        return self._audio_only

    @audio_only.setter
    def audio_only(self, audio_only):
        """Sets the audio_only of this CreateLiveStreamRequest.

        Force the live stream to only process the audio track when the value is set to true. Mux drops the video track if broadcasted.  # noqa: E501

        :param audio_only: The audio_only of this CreateLiveStreamRequest.  # noqa: E501
        :type audio_only: bool
        """

        self._audio_only = audio_only

    @property
    def embedded_subtitles(self):
        """Gets the embedded_subtitles of this CreateLiveStreamRequest.  # noqa: E501

        Describe the embedded closed caption contents of the incoming live stream.  # noqa: E501

        :return: The embedded_subtitles of this CreateLiveStreamRequest.  # noqa: E501
        :rtype: list[LiveStreamEmbeddedSubtitleSettings]
        """
        return self._embedded_subtitles

    @embedded_subtitles.setter
    def embedded_subtitles(self, embedded_subtitles):
        """Sets the embedded_subtitles of this CreateLiveStreamRequest.

        Describe the embedded closed caption contents of the incoming live stream.  # noqa: E501

        :param embedded_subtitles: The embedded_subtitles of this CreateLiveStreamRequest.  # noqa: E501
        :type embedded_subtitles: list[LiveStreamEmbeddedSubtitleSettings]
        """

        self._embedded_subtitles = embedded_subtitles

    @property
    def generated_subtitles(self):
        """Gets the generated_subtitles of this CreateLiveStreamRequest.  # noqa: E501

        Configure the incoming live stream to include subtitles created with automatic speech recognition. Each Asset created from a live stream with `generated_subtitles` configured will automatically receive two text tracks. The first of these will have a `text_source` value of `generated_live`, and will be available with `ready` status as soon as the stream is live. The second text track will have a `text_source` value of `generated_live_final` and will contain subtitles with improved accuracy, timing, and formatting. However, `generated_live_final` tracks will not be available in `ready` status until the live stream ends. If an Asset has both `generated_live` and `generated_live_final` tracks that are `ready`, then only the `generated_live_final` track will be included during playback.  # noqa: E501

        :return: The generated_subtitles of this CreateLiveStreamRequest.  # noqa: E501
        :rtype: list[LiveStreamGeneratedSubtitleSettings]
        """
        return self._generated_subtitles

    @generated_subtitles.setter
    def generated_subtitles(self, generated_subtitles):
        """Sets the generated_subtitles of this CreateLiveStreamRequest.

        Configure the incoming live stream to include subtitles created with automatic speech recognition. Each Asset created from a live stream with `generated_subtitles` configured will automatically receive two text tracks. The first of these will have a `text_source` value of `generated_live`, and will be available with `ready` status as soon as the stream is live. The second text track will have a `text_source` value of `generated_live_final` and will contain subtitles with improved accuracy, timing, and formatting. However, `generated_live_final` tracks will not be available in `ready` status until the live stream ends. If an Asset has both `generated_live` and `generated_live_final` tracks that are `ready`, then only the `generated_live_final` track will be included during playback.  # noqa: E501

        :param generated_subtitles: The generated_subtitles of this CreateLiveStreamRequest.  # noqa: E501
        :type generated_subtitles: list[LiveStreamGeneratedSubtitleSettings]
        """

        self._generated_subtitles = generated_subtitles

    @property
    def reduced_latency(self):
        """Gets the reduced_latency of this CreateLiveStreamRequest.  # noqa: E501

        This field is deprecated. Please use `latency_mode` instead. Latency is the time from when the streamer transmits a frame of video to when you see it in the player. Set this if you want lower latency for your live stream. Read more here: https://mux.com/blog/reduced-latency-for-mux-live-streaming-now-available/  # noqa: E501

        :return: The reduced_latency of this CreateLiveStreamRequest.  # noqa: E501
        :rtype: bool
        """
        return self._reduced_latency

    @reduced_latency.setter
    def reduced_latency(self, reduced_latency):
        """Sets the reduced_latency of this CreateLiveStreamRequest.

        This field is deprecated. Please use `latency_mode` instead. Latency is the time from when the streamer transmits a frame of video to when you see it in the player. Set this if you want lower latency for your live stream. Read more here: https://mux.com/blog/reduced-latency-for-mux-live-streaming-now-available/  # noqa: E501

        :param reduced_latency: The reduced_latency of this CreateLiveStreamRequest.  # noqa: E501
        :type reduced_latency: bool
        """

        self._reduced_latency = reduced_latency

    @property
    def low_latency(self):
        """Gets the low_latency of this CreateLiveStreamRequest.  # noqa: E501

        This field is deprecated. Please use `latency_mode` instead. Latency is the time from when the streamer transmits a frame of video to when you see it in the player. Setting this option will enable compatibility with the LL-HLS specification for low-latency streaming. This typically has lower latency than Reduced Latency streams, and cannot be combined with Reduced Latency.  # noqa: E501

        :return: The low_latency of this CreateLiveStreamRequest.  # noqa: E501
        :rtype: bool
        """
        return self._low_latency

    @low_latency.setter
    def low_latency(self, low_latency):
        """Sets the low_latency of this CreateLiveStreamRequest.

        This field is deprecated. Please use `latency_mode` instead. Latency is the time from when the streamer transmits a frame of video to when you see it in the player. Setting this option will enable compatibility with the LL-HLS specification for low-latency streaming. This typically has lower latency than Reduced Latency streams, and cannot be combined with Reduced Latency.  # noqa: E501

        :param low_latency: The low_latency of this CreateLiveStreamRequest.  # noqa: E501
        :type low_latency: bool
        """

        self._low_latency = low_latency

    @property
    def latency_mode(self):
        """Gets the latency_mode of this CreateLiveStreamRequest.  # noqa: E501

        Latency is the time from when the streamer transmits a frame of video to when you see it in the player. Set this as an alternative to setting low latency or reduced latency flags. The Low Latency value is a beta feature. Read more here: https://mux.com/blog/introducing-low-latency-live-streaming/  # noqa: E501

        :return: The latency_mode of this CreateLiveStreamRequest.  # noqa: E501
        :rtype: str
        """
        return self._latency_mode

    @latency_mode.setter
    def latency_mode(self, latency_mode):
        """Sets the latency_mode of this CreateLiveStreamRequest.

        Latency is the time from when the streamer transmits a frame of video to when you see it in the player. Set this as an alternative to setting low latency or reduced latency flags. The Low Latency value is a beta feature. Read more here: https://mux.com/blog/introducing-low-latency-live-streaming/  # noqa: E501

        :param latency_mode: The latency_mode of this CreateLiveStreamRequest.  # noqa: E501
        :type latency_mode: str
        """
        allowed_values = ["low", "reduced", "standard"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and latency_mode not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `latency_mode` ({0}), must be one of {1}"  # noqa: E501
                .format(latency_mode, allowed_values)
            )

        self._latency_mode = latency_mode

    @property
    def test(self):
        """Gets the test of this CreateLiveStreamRequest.  # noqa: E501

        Marks the live stream as a test live stream when the value is set to true. A test live stream can help evaluate the Mux Video APIs without incurring any cost. There is no limit on number of test live streams created. Test live streams are watermarked with the Mux logo and limited to 5 minutes. The test live stream is disabled after the stream is active for 5 mins and the recorded asset also deleted after 24 hours.  # noqa: E501

        :return: The test of this CreateLiveStreamRequest.  # noqa: E501
        :rtype: bool
        """
        return self._test

    @test.setter
    def test(self, test):
        """Sets the test of this CreateLiveStreamRequest.

        Marks the live stream as a test live stream when the value is set to true. A test live stream can help evaluate the Mux Video APIs without incurring any cost. There is no limit on number of test live streams created. Test live streams are watermarked with the Mux logo and limited to 5 minutes. The test live stream is disabled after the stream is active for 5 mins and the recorded asset also deleted after 24 hours.  # noqa: E501

        :param test: The test of this CreateLiveStreamRequest.  # noqa: E501
        :type test: bool
        """

        self._test = test

    @property
    def simulcast_targets(self):
        """Gets the simulcast_targets of this CreateLiveStreamRequest.  # noqa: E501


        :return: The simulcast_targets of this CreateLiveStreamRequest.  # noqa: E501
        :rtype: list[CreateSimulcastTargetRequest]
        """
        return self._simulcast_targets

    @simulcast_targets.setter
    def simulcast_targets(self, simulcast_targets):
        """Sets the simulcast_targets of this CreateLiveStreamRequest.


        :param simulcast_targets: The simulcast_targets of this CreateLiveStreamRequest.  # noqa: E501
        :type simulcast_targets: list[CreateSimulcastTargetRequest]
        """

        self._simulcast_targets = simulcast_targets

    @property
    def max_continuous_duration(self):
        """Gets the max_continuous_duration of this CreateLiveStreamRequest.  # noqa: E501

        The time in seconds a live stream may be continuously active before being disconnected. Defaults to 12 hours.  # noqa: E501

        :return: The max_continuous_duration of this CreateLiveStreamRequest.  # noqa: E501
        :rtype: int
        """
        return self._max_continuous_duration

    @max_continuous_duration.setter
    def max_continuous_duration(self, max_continuous_duration):
        """Sets the max_continuous_duration of this CreateLiveStreamRequest.

        The time in seconds a live stream may be continuously active before being disconnected. Defaults to 12 hours.  # noqa: E501

        :param max_continuous_duration: The max_continuous_duration of this CreateLiveStreamRequest.  # noqa: E501
        :type max_continuous_duration: int
        """
        if (self.local_vars_configuration.client_side_validation and
                max_continuous_duration is not None and max_continuous_duration > 43200):  # noqa: E501
            raise ValueError("Invalid value for `max_continuous_duration`, must be a value less than or equal to `43200`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                max_continuous_duration is not None and max_continuous_duration < 60):  # noqa: E501
            raise ValueError("Invalid value for `max_continuous_duration`, must be a value greater than or equal to `60`")  # noqa: E501

        self._max_continuous_duration = max_continuous_duration

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateLiveStreamRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CreateLiveStreamRequest):
            return True

        return self.to_dict() != other.to_dict()
