# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class PlaybackRestriction(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'created_at': 'str',
        'updated_at': 'str',
        'referrer': 'ReferrerDomainRestriction'
    }

    attribute_map = {
        'id': 'id',
        'created_at': 'created_at',
        'updated_at': 'updated_at',
        'referrer': 'referrer'
    }

    def __init__(self, id=None, created_at=None, updated_at=None, referrer=None, local_vars_configuration=None):  # noqa: E501
        """PlaybackRestriction - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._created_at = None
        self._updated_at = None
        self._referrer = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if referrer is not None:
            self.referrer = referrer

    @property
    def id(self):
        """Gets the id of this PlaybackRestriction.  # noqa: E501

        Unique identifier for the Playback Restriction. Max 255 characters.  # noqa: E501

        :return: The id of this PlaybackRestriction.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this PlaybackRestriction.

        Unique identifier for the Playback Restriction. Max 255 characters.  # noqa: E501

        :param id: The id of this PlaybackRestriction.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def created_at(self):
        """Gets the created_at of this PlaybackRestriction.  # noqa: E501

        Time the Playback Restriction was created, defined as a Unix timestamp (seconds since epoch).  # noqa: E501

        :return: The created_at of this PlaybackRestriction.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this PlaybackRestriction.

        Time the Playback Restriction was created, defined as a Unix timestamp (seconds since epoch).  # noqa: E501

        :param created_at: The created_at of this PlaybackRestriction.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this PlaybackRestriction.  # noqa: E501

        Time the Playback Restriction was last updated, defined as a Unix timestamp (seconds since epoch).  # noqa: E501

        :return: The updated_at of this PlaybackRestriction.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this PlaybackRestriction.

        Time the Playback Restriction was last updated, defined as a Unix timestamp (seconds since epoch).  # noqa: E501

        :param updated_at: The updated_at of this PlaybackRestriction.  # noqa: E501
        :type updated_at: str
        """

        self._updated_at = updated_at

    @property
    def referrer(self):
        """Gets the referrer of this PlaybackRestriction.  # noqa: E501


        :return: The referrer of this PlaybackRestriction.  # noqa: E501
        :rtype: ReferrerDomainRestriction
        """
        return self._referrer

    @referrer.setter
    def referrer(self, referrer):
        """Sets the referrer of this PlaybackRestriction.


        :param referrer: The referrer of this PlaybackRestriction.  # noqa: E501
        :type referrer: ReferrerDomainRestriction
        """

        self._referrer = referrer

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PlaybackRestriction):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PlaybackRestriction):
            return True

        return self.to_dict() != other.to_dict()
