# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class Asset(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'created_at': 'str',
        'status': 'str',
        'duration': 'float',
        'max_stored_resolution': 'str',
        'resolution_tier': 'str',
        'max_resolution_tier': 'str',
        'encoding_tier': 'str',
        'max_stored_frame_rate': 'float',
        'aspect_ratio': 'str',
        'playback_ids': 'list[PlaybackID]',
        'tracks': 'list[Track]',
        'errors': 'AssetErrors',
        'per_title_encode': 'bool',
        'upload_id': 'str',
        'is_live': 'bool',
        'passthrough': 'str',
        'live_stream_id': 'str',
        'master': 'AssetMaster',
        'master_access': 'str',
        'mp4_support': 'str',
        'source_asset_id': 'str',
        'normalize_audio': 'bool',
        'static_renditions': 'AssetStaticRenditions',
        'recording_times': 'list[AssetRecordingTimes]',
        'non_standard_input_reasons': 'AssetNonStandardInputReasons',
        'test': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'created_at': 'created_at',
        'status': 'status',
        'duration': 'duration',
        'max_stored_resolution': 'max_stored_resolution',
        'resolution_tier': 'resolution_tier',
        'max_resolution_tier': 'max_resolution_tier',
        'encoding_tier': 'encoding_tier',
        'max_stored_frame_rate': 'max_stored_frame_rate',
        'aspect_ratio': 'aspect_ratio',
        'playback_ids': 'playback_ids',
        'tracks': 'tracks',
        'errors': 'errors',
        'per_title_encode': 'per_title_encode',
        'upload_id': 'upload_id',
        'is_live': 'is_live',
        'passthrough': 'passthrough',
        'live_stream_id': 'live_stream_id',
        'master': 'master',
        'master_access': 'master_access',
        'mp4_support': 'mp4_support',
        'source_asset_id': 'source_asset_id',
        'normalize_audio': 'normalize_audio',
        'static_renditions': 'static_renditions',
        'recording_times': 'recording_times',
        'non_standard_input_reasons': 'non_standard_input_reasons',
        'test': 'test'
    }

    def __init__(self, id=None, created_at=None, status=None, duration=None, max_stored_resolution=None, resolution_tier=None, max_resolution_tier=None, encoding_tier=None, max_stored_frame_rate=None, aspect_ratio=None, playback_ids=None, tracks=None, errors=None, per_title_encode=None, upload_id=None, is_live=None, passthrough=None, live_stream_id=None, master=None, master_access='none', mp4_support='none', source_asset_id=None, normalize_audio=False, static_renditions=None, recording_times=None, non_standard_input_reasons=None, test=None, local_vars_configuration=None):  # noqa: E501
        """Asset - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._created_at = None
        self._status = None
        self._duration = None
        self._max_stored_resolution = None
        self._resolution_tier = None
        self._max_resolution_tier = None
        self._encoding_tier = None
        self._max_stored_frame_rate = None
        self._aspect_ratio = None
        self._playback_ids = None
        self._tracks = None
        self._errors = None
        self._per_title_encode = None
        self._upload_id = None
        self._is_live = None
        self._passthrough = None
        self._live_stream_id = None
        self._master = None
        self._master_access = None
        self._mp4_support = None
        self._source_asset_id = None
        self._normalize_audio = None
        self._static_renditions = None
        self._recording_times = None
        self._non_standard_input_reasons = None
        self._test = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if created_at is not None:
            self.created_at = created_at
        if status is not None:
            self.status = status
        if duration is not None:
            self.duration = duration
        if max_stored_resolution is not None:
            self.max_stored_resolution = max_stored_resolution
        if resolution_tier is not None:
            self.resolution_tier = resolution_tier
        if max_resolution_tier is not None:
            self.max_resolution_tier = max_resolution_tier
        if encoding_tier is not None:
            self.encoding_tier = encoding_tier
        if max_stored_frame_rate is not None:
            self.max_stored_frame_rate = max_stored_frame_rate
        if aspect_ratio is not None:
            self.aspect_ratio = aspect_ratio
        if playback_ids is not None:
            self.playback_ids = playback_ids
        if tracks is not None:
            self.tracks = tracks
        if errors is not None:
            self.errors = errors
        if per_title_encode is not None:
            self.per_title_encode = per_title_encode
        if upload_id is not None:
            self.upload_id = upload_id
        if is_live is not None:
            self.is_live = is_live
        if passthrough is not None:
            self.passthrough = passthrough
        if live_stream_id is not None:
            self.live_stream_id = live_stream_id
        if master is not None:
            self.master = master
        if master_access is not None:
            self.master_access = master_access
        if mp4_support is not None:
            self.mp4_support = mp4_support
        if source_asset_id is not None:
            self.source_asset_id = source_asset_id
        if normalize_audio is not None:
            self.normalize_audio = normalize_audio
        if static_renditions is not None:
            self.static_renditions = static_renditions
        if recording_times is not None:
            self.recording_times = recording_times
        if non_standard_input_reasons is not None:
            self.non_standard_input_reasons = non_standard_input_reasons
        if test is not None:
            self.test = test

    @property
    def id(self):
        """Gets the id of this Asset.  # noqa: E501

        Unique identifier for the Asset. Max 255 characters.  # noqa: E501

        :return: The id of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Asset.

        Unique identifier for the Asset. Max 255 characters.  # noqa: E501

        :param id: The id of this Asset.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def created_at(self):
        """Gets the created_at of this Asset.  # noqa: E501

        Time the Asset was created, defined as a Unix timestamp (seconds since epoch).  # noqa: E501

        :return: The created_at of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Asset.

        Time the Asset was created, defined as a Unix timestamp (seconds since epoch).  # noqa: E501

        :param created_at: The created_at of this Asset.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def status(self):
        """Gets the status of this Asset.  # noqa: E501

        The status of the asset.  # noqa: E501

        :return: The status of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Asset.

        The status of the asset.  # noqa: E501

        :param status: The status of this Asset.  # noqa: E501
        :type status: str
        """
        allowed_values = ["preparing", "ready", "errored"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def duration(self):
        """Gets the duration of this Asset.  # noqa: E501

        The duration of the asset in seconds (max duration for a single asset is 12 hours).  # noqa: E501

        :return: The duration of this Asset.  # noqa: E501
        :rtype: float
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this Asset.

        The duration of the asset in seconds (max duration for a single asset is 12 hours).  # noqa: E501

        :param duration: The duration of this Asset.  # noqa: E501
        :type duration: float
        """

        self._duration = duration

    @property
    def max_stored_resolution(self):
        """Gets the max_stored_resolution of this Asset.  # noqa: E501

        This field is deprecated. Please use `resolution_tier` instead. The maximum resolution that has been stored for the asset. The asset may be delivered at lower resolutions depending on the device and bandwidth, however it cannot be delivered at a higher value than is stored.  # noqa: E501

        :return: The max_stored_resolution of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._max_stored_resolution

    @max_stored_resolution.setter
    def max_stored_resolution(self, max_stored_resolution):
        """Sets the max_stored_resolution of this Asset.

        This field is deprecated. Please use `resolution_tier` instead. The maximum resolution that has been stored for the asset. The asset may be delivered at lower resolutions depending on the device and bandwidth, however it cannot be delivered at a higher value than is stored.  # noqa: E501

        :param max_stored_resolution: The max_stored_resolution of this Asset.  # noqa: E501
        :type max_stored_resolution: str
        """
        allowed_values = ["Audio only", "SD", "HD", "FHD", "UHD"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and max_stored_resolution not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `max_stored_resolution` ({0}), must be one of {1}"  # noqa: E501
                .format(max_stored_resolution, allowed_values)
            )

        self._max_stored_resolution = max_stored_resolution

    @property
    def resolution_tier(self):
        """Gets the resolution_tier of this Asset.  # noqa: E501

        The resolution tier that the asset was ingested at, affecting billing for ingest & storage. This field also represents the highest resolution tier that the content can be delivered at, however the actual resolution may be lower depending on the device, bandwidth, and exact resolution of the uploaded asset.  # noqa: E501

        :return: The resolution_tier of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._resolution_tier

    @resolution_tier.setter
    def resolution_tier(self, resolution_tier):
        """Sets the resolution_tier of this Asset.

        The resolution tier that the asset was ingested at, affecting billing for ingest & storage. This field also represents the highest resolution tier that the content can be delivered at, however the actual resolution may be lower depending on the device, bandwidth, and exact resolution of the uploaded asset.  # noqa: E501

        :param resolution_tier: The resolution_tier of this Asset.  # noqa: E501
        :type resolution_tier: str
        """
        allowed_values = ["audio-only", "720p", "1080p", "1440p", "2160p"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and resolution_tier not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `resolution_tier` ({0}), must be one of {1}"  # noqa: E501
                .format(resolution_tier, allowed_values)
            )

        self._resolution_tier = resolution_tier

    @property
    def max_resolution_tier(self):
        """Gets the max_resolution_tier of this Asset.  # noqa: E501

        Max resolution tier can be used to control the maximum `resolution_tier` your asset is encoded, stored, and streamed at. If not set, this defaults to `1080p`.  # noqa: E501

        :return: The max_resolution_tier of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._max_resolution_tier

    @max_resolution_tier.setter
    def max_resolution_tier(self, max_resolution_tier):
        """Sets the max_resolution_tier of this Asset.

        Max resolution tier can be used to control the maximum `resolution_tier` your asset is encoded, stored, and streamed at. If not set, this defaults to `1080p`.  # noqa: E501

        :param max_resolution_tier: The max_resolution_tier of this Asset.  # noqa: E501
        :type max_resolution_tier: str
        """
        allowed_values = ["1080p", "1440p", "2160p"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and max_resolution_tier not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `max_resolution_tier` ({0}), must be one of {1}"  # noqa: E501
                .format(max_resolution_tier, allowed_values)
            )

        self._max_resolution_tier = max_resolution_tier

    @property
    def encoding_tier(self):
        """Gets the encoding_tier of this Asset.  # noqa: E501

        The encoding tier informs the cost, quality, and available platform features for the asset. By default the `smart` encoding tier is used. [See the guide for more details.](https://docs.mux.com/guides/use-encoding-tiers)  # noqa: E501

        :return: The encoding_tier of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._encoding_tier

    @encoding_tier.setter
    def encoding_tier(self, encoding_tier):
        """Sets the encoding_tier of this Asset.

        The encoding tier informs the cost, quality, and available platform features for the asset. By default the `smart` encoding tier is used. [See the guide for more details.](https://docs.mux.com/guides/use-encoding-tiers)  # noqa: E501

        :param encoding_tier: The encoding_tier of this Asset.  # noqa: E501
        :type encoding_tier: str
        """
        allowed_values = ["smart", "baseline"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and encoding_tier not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `encoding_tier` ({0}), must be one of {1}"  # noqa: E501
                .format(encoding_tier, allowed_values)
            )

        self._encoding_tier = encoding_tier

    @property
    def max_stored_frame_rate(self):
        """Gets the max_stored_frame_rate of this Asset.  # noqa: E501

        The maximum frame rate that has been stored for the asset. The asset may be delivered at lower frame rates depending on the device and bandwidth, however it cannot be delivered at a higher value than is stored. This field may return -1 if the frame rate of the input cannot be reliably determined.  # noqa: E501

        :return: The max_stored_frame_rate of this Asset.  # noqa: E501
        :rtype: float
        """
        return self._max_stored_frame_rate

    @max_stored_frame_rate.setter
    def max_stored_frame_rate(self, max_stored_frame_rate):
        """Sets the max_stored_frame_rate of this Asset.

        The maximum frame rate that has been stored for the asset. The asset may be delivered at lower frame rates depending on the device and bandwidth, however it cannot be delivered at a higher value than is stored. This field may return -1 if the frame rate of the input cannot be reliably determined.  # noqa: E501

        :param max_stored_frame_rate: The max_stored_frame_rate of this Asset.  # noqa: E501
        :type max_stored_frame_rate: float
        """

        self._max_stored_frame_rate = max_stored_frame_rate

    @property
    def aspect_ratio(self):
        """Gets the aspect_ratio of this Asset.  # noqa: E501

        The aspect ratio of the asset in the form of `width:height`, for example `16:9`.  # noqa: E501

        :return: The aspect_ratio of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._aspect_ratio

    @aspect_ratio.setter
    def aspect_ratio(self, aspect_ratio):
        """Sets the aspect_ratio of this Asset.

        The aspect ratio of the asset in the form of `width:height`, for example `16:9`.  # noqa: E501

        :param aspect_ratio: The aspect_ratio of this Asset.  # noqa: E501
        :type aspect_ratio: str
        """

        self._aspect_ratio = aspect_ratio

    @property
    def playback_ids(self):
        """Gets the playback_ids of this Asset.  # noqa: E501

        An array of Playback ID objects. Use these to create HLS playback URLs. See [Play your videos](https://docs.mux.com/guides/play-your-videos) for more details.  # noqa: E501

        :return: The playback_ids of this Asset.  # noqa: E501
        :rtype: list[PlaybackID]
        """
        return self._playback_ids

    @playback_ids.setter
    def playback_ids(self, playback_ids):
        """Sets the playback_ids of this Asset.

        An array of Playback ID objects. Use these to create HLS playback URLs. See [Play your videos](https://docs.mux.com/guides/play-your-videos) for more details.  # noqa: E501

        :param playback_ids: The playback_ids of this Asset.  # noqa: E501
        :type playback_ids: list[PlaybackID]
        """

        self._playback_ids = playback_ids

    @property
    def tracks(self):
        """Gets the tracks of this Asset.  # noqa: E501

        The individual media tracks that make up an asset.  # noqa: E501

        :return: The tracks of this Asset.  # noqa: E501
        :rtype: list[Track]
        """
        return self._tracks

    @tracks.setter
    def tracks(self, tracks):
        """Sets the tracks of this Asset.

        The individual media tracks that make up an asset.  # noqa: E501

        :param tracks: The tracks of this Asset.  # noqa: E501
        :type tracks: list[Track]
        """

        self._tracks = tracks

    @property
    def errors(self):
        """Gets the errors of this Asset.  # noqa: E501


        :return: The errors of this Asset.  # noqa: E501
        :rtype: AssetErrors
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """Sets the errors of this Asset.


        :param errors: The errors of this Asset.  # noqa: E501
        :type errors: AssetErrors
        """

        self._errors = errors

    @property
    def per_title_encode(self):
        """Gets the per_title_encode of this Asset.  # noqa: E501


        :return: The per_title_encode of this Asset.  # noqa: E501
        :rtype: bool
        """
        return self._per_title_encode

    @per_title_encode.setter
    def per_title_encode(self, per_title_encode):
        """Sets the per_title_encode of this Asset.


        :param per_title_encode: The per_title_encode of this Asset.  # noqa: E501
        :type per_title_encode: bool
        """

        self._per_title_encode = per_title_encode

    @property
    def upload_id(self):
        """Gets the upload_id of this Asset.  # noqa: E501

        Unique identifier for the Direct Upload. This is an optional parameter added when the asset is created from a direct upload.  # noqa: E501

        :return: The upload_id of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._upload_id

    @upload_id.setter
    def upload_id(self, upload_id):
        """Sets the upload_id of this Asset.

        Unique identifier for the Direct Upload. This is an optional parameter added when the asset is created from a direct upload.  # noqa: E501

        :param upload_id: The upload_id of this Asset.  # noqa: E501
        :type upload_id: str
        """

        self._upload_id = upload_id

    @property
    def is_live(self):
        """Gets the is_live of this Asset.  # noqa: E501

        Indicates whether the live stream that created this asset is currently `active` and not in `idle` state. This is an optional parameter added when the asset is created from a live stream.  # noqa: E501

        :return: The is_live of this Asset.  # noqa: E501
        :rtype: bool
        """
        return self._is_live

    @is_live.setter
    def is_live(self, is_live):
        """Sets the is_live of this Asset.

        Indicates whether the live stream that created this asset is currently `active` and not in `idle` state. This is an optional parameter added when the asset is created from a live stream.  # noqa: E501

        :param is_live: The is_live of this Asset.  # noqa: E501
        :type is_live: bool
        """

        self._is_live = is_live

    @property
    def passthrough(self):
        """Gets the passthrough of this Asset.  # noqa: E501

        Arbitrary user-supplied metadata set for the asset. Max 255 characters.  # noqa: E501

        :return: The passthrough of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._passthrough

    @passthrough.setter
    def passthrough(self, passthrough):
        """Sets the passthrough of this Asset.

        Arbitrary user-supplied metadata set for the asset. Max 255 characters.  # noqa: E501

        :param passthrough: The passthrough of this Asset.  # noqa: E501
        :type passthrough: str
        """

        self._passthrough = passthrough

    @property
    def live_stream_id(self):
        """Gets the live_stream_id of this Asset.  # noqa: E501

        Unique identifier for the live stream. This is an optional parameter added when the asset is created from a live stream.  # noqa: E501

        :return: The live_stream_id of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._live_stream_id

    @live_stream_id.setter
    def live_stream_id(self, live_stream_id):
        """Sets the live_stream_id of this Asset.

        Unique identifier for the live stream. This is an optional parameter added when the asset is created from a live stream.  # noqa: E501

        :param live_stream_id: The live_stream_id of this Asset.  # noqa: E501
        :type live_stream_id: str
        """

        self._live_stream_id = live_stream_id

    @property
    def master(self):
        """Gets the master of this Asset.  # noqa: E501


        :return: The master of this Asset.  # noqa: E501
        :rtype: AssetMaster
        """
        return self._master

    @master.setter
    def master(self, master):
        """Sets the master of this Asset.


        :param master: The master of this Asset.  # noqa: E501
        :type master: AssetMaster
        """

        self._master = master

    @property
    def master_access(self):
        """Gets the master_access of this Asset.  # noqa: E501


        :return: The master_access of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._master_access

    @master_access.setter
    def master_access(self, master_access):
        """Sets the master_access of this Asset.


        :param master_access: The master_access of this Asset.  # noqa: E501
        :type master_access: str
        """
        allowed_values = ["temporary", "none"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and master_access not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `master_access` ({0}), must be one of {1}"  # noqa: E501
                .format(master_access, allowed_values)
            )

        self._master_access = master_access

    @property
    def mp4_support(self):
        """Gets the mp4_support of this Asset.  # noqa: E501


        :return: The mp4_support of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._mp4_support

    @mp4_support.setter
    def mp4_support(self, mp4_support):
        """Sets the mp4_support of this Asset.


        :param mp4_support: The mp4_support of this Asset.  # noqa: E501
        :type mp4_support: str
        """
        allowed_values = ["standard", "none"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and mp4_support not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `mp4_support` ({0}), must be one of {1}"  # noqa: E501
                .format(mp4_support, allowed_values)
            )

        self._mp4_support = mp4_support

    @property
    def source_asset_id(self):
        """Gets the source_asset_id of this Asset.  # noqa: E501

        Asset Identifier of the video used as the source for creating the clip.  # noqa: E501

        :return: The source_asset_id of this Asset.  # noqa: E501
        :rtype: str
        """
        return self._source_asset_id

    @source_asset_id.setter
    def source_asset_id(self, source_asset_id):
        """Sets the source_asset_id of this Asset.

        Asset Identifier of the video used as the source for creating the clip.  # noqa: E501

        :param source_asset_id: The source_asset_id of this Asset.  # noqa: E501
        :type source_asset_id: str
        """

        self._source_asset_id = source_asset_id

    @property
    def normalize_audio(self):
        """Gets the normalize_audio of this Asset.  # noqa: E501

        Normalize the audio track loudness level. This parameter is only applicable to on-demand (not live) assets.  # noqa: E501

        :return: The normalize_audio of this Asset.  # noqa: E501
        :rtype: bool
        """
        return self._normalize_audio

    @normalize_audio.setter
    def normalize_audio(self, normalize_audio):
        """Sets the normalize_audio of this Asset.

        Normalize the audio track loudness level. This parameter is only applicable to on-demand (not live) assets.  # noqa: E501

        :param normalize_audio: The normalize_audio of this Asset.  # noqa: E501
        :type normalize_audio: bool
        """

        self._normalize_audio = normalize_audio

    @property
    def static_renditions(self):
        """Gets the static_renditions of this Asset.  # noqa: E501


        :return: The static_renditions of this Asset.  # noqa: E501
        :rtype: AssetStaticRenditions
        """
        return self._static_renditions

    @static_renditions.setter
    def static_renditions(self, static_renditions):
        """Sets the static_renditions of this Asset.


        :param static_renditions: The static_renditions of this Asset.  # noqa: E501
        :type static_renditions: AssetStaticRenditions
        """

        self._static_renditions = static_renditions

    @property
    def recording_times(self):
        """Gets the recording_times of this Asset.  # noqa: E501

        An array of individual live stream recording sessions. A recording session is created on each encoder connection during the live stream. Additionally any time slate media is inserted during brief interruptions in the live stream media or times when the live streaming software disconnects, a recording session representing the slate media will be added with a \"slate\" type.  # noqa: E501

        :return: The recording_times of this Asset.  # noqa: E501
        :rtype: list[AssetRecordingTimes]
        """
        return self._recording_times

    @recording_times.setter
    def recording_times(self, recording_times):
        """Sets the recording_times of this Asset.

        An array of individual live stream recording sessions. A recording session is created on each encoder connection during the live stream. Additionally any time slate media is inserted during brief interruptions in the live stream media or times when the live streaming software disconnects, a recording session representing the slate media will be added with a \"slate\" type.  # noqa: E501

        :param recording_times: The recording_times of this Asset.  # noqa: E501
        :type recording_times: list[AssetRecordingTimes]
        """

        self._recording_times = recording_times

    @property
    def non_standard_input_reasons(self):
        """Gets the non_standard_input_reasons of this Asset.  # noqa: E501


        :return: The non_standard_input_reasons of this Asset.  # noqa: E501
        :rtype: AssetNonStandardInputReasons
        """
        return self._non_standard_input_reasons

    @non_standard_input_reasons.setter
    def non_standard_input_reasons(self, non_standard_input_reasons):
        """Sets the non_standard_input_reasons of this Asset.


        :param non_standard_input_reasons: The non_standard_input_reasons of this Asset.  # noqa: E501
        :type non_standard_input_reasons: AssetNonStandardInputReasons
        """

        self._non_standard_input_reasons = non_standard_input_reasons

    @property
    def test(self):
        """Gets the test of this Asset.  # noqa: E501

        True means this live stream is a test asset. A test asset can help evaluate the Mux Video APIs without incurring any cost. There is no limit on number of test assets created. Test assets are watermarked with the Mux logo, limited to 10 seconds, and deleted after 24 hrs.  # noqa: E501

        :return: The test of this Asset.  # noqa: E501
        :rtype: bool
        """
        return self._test

    @test.setter
    def test(self, test):
        """Sets the test of this Asset.

        True means this live stream is a test asset. A test asset can help evaluate the Mux Video APIs without incurring any cost. There is no limit on number of test assets created. Test assets are watermarked with the Mux logo, limited to 10 seconds, and deleted after 24 hrs.  # noqa: E501

        :param test: The test of this Asset.  # noqa: E501
        :type test: bool
        """

        self._test = test

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Asset):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Asset):
            return True

        return self.to_dict() != other.to_dict()
