# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class ReferrerDomainRestriction(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'allowed_domains': 'list[str]',
        'allow_no_referrer': 'bool'
    }

    attribute_map = {
        'allowed_domains': 'allowed_domains',
        'allow_no_referrer': 'allow_no_referrer'
    }

    def __init__(self, allowed_domains=None, allow_no_referrer=False, local_vars_configuration=None):  # noqa: E501
        """ReferrerDomainRestriction - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._allowed_domains = None
        self._allow_no_referrer = None
        self.discriminator = None

        if allowed_domains is not None:
            self.allowed_domains = allowed_domains
        if allow_no_referrer is not None:
            self.allow_no_referrer = allow_no_referrer

    @property
    def allowed_domains(self):
        """Gets the allowed_domains of this ReferrerDomainRestriction.  # noqa: E501

        List of domains allowed to play videos. Possible values are   * `[]` Empty Array indicates deny video playback requests for all domains   * `[\"*\"]` A Single Wildcard `*` entry means allow video playback requests from any domain   * `[\"*.example.com\", \"foo.com\"]` A list of up to 10 domains or valid dns-style wildcards   # noqa: E501

        :return: The allowed_domains of this ReferrerDomainRestriction.  # noqa: E501
        :rtype: list[str]
        """
        return self._allowed_domains

    @allowed_domains.setter
    def allowed_domains(self, allowed_domains):
        """Sets the allowed_domains of this ReferrerDomainRestriction.

        List of domains allowed to play videos. Possible values are   * `[]` Empty Array indicates deny video playback requests for all domains   * `[\"*\"]` A Single Wildcard `*` entry means allow video playback requests from any domain   * `[\"*.example.com\", \"foo.com\"]` A list of up to 10 domains or valid dns-style wildcards   # noqa: E501

        :param allowed_domains: The allowed_domains of this ReferrerDomainRestriction.  # noqa: E501
        :type allowed_domains: list[str]
        """

        self._allowed_domains = allowed_domains

    @property
    def allow_no_referrer(self):
        """Gets the allow_no_referrer of this ReferrerDomainRestriction.  # noqa: E501

        A boolean to determine whether to allow or deny HTTP requests without `Referer` HTTP request header. Playback requests coming from non-web/native applications like iOS, Android or smart TVs will not have a `Referer` HTTP header. Set this value to `true` to allow these playback requests.  # noqa: E501

        :return: The allow_no_referrer of this ReferrerDomainRestriction.  # noqa: E501
        :rtype: bool
        """
        return self._allow_no_referrer

    @allow_no_referrer.setter
    def allow_no_referrer(self, allow_no_referrer):
        """Sets the allow_no_referrer of this ReferrerDomainRestriction.

        A boolean to determine whether to allow or deny HTTP requests without `Referer` HTTP request header. Playback requests coming from non-web/native applications like iOS, Android or smart TVs will not have a `Referer` HTTP header. Set this value to `true` to allow these playback requests.  # noqa: E501

        :param allow_no_referrer: The allow_no_referrer of this ReferrerDomainRestriction.  # noqa: E501
        :type allow_no_referrer: bool
        """

        self._allow_no_referrer = allow_no_referrer

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReferrerDomainRestriction):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ReferrerDomainRestriction):
            return True

        return self.to_dict() != other.to_dict()
