# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class UpdateLiveStreamRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'passthrough': 'str',
        'latency_mode': 'str',
        'reconnect_window': 'float',
        'use_slate_for_standard_latency': 'bool',
        'reconnect_slate_url': 'str',
        'max_continuous_duration': 'int'
    }

    attribute_map = {
        'passthrough': 'passthrough',
        'latency_mode': 'latency_mode',
        'reconnect_window': 'reconnect_window',
        'use_slate_for_standard_latency': 'use_slate_for_standard_latency',
        'reconnect_slate_url': 'reconnect_slate_url',
        'max_continuous_duration': 'max_continuous_duration'
    }

    def __init__(self, passthrough=None, latency_mode=None, reconnect_window=60, use_slate_for_standard_latency=False, reconnect_slate_url=None, max_continuous_duration=43200, local_vars_configuration=None):  # noqa: E501
        """UpdateLiveStreamRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._passthrough = None
        self._latency_mode = None
        self._reconnect_window = None
        self._use_slate_for_standard_latency = None
        self._reconnect_slate_url = None
        self._max_continuous_duration = None
        self.discriminator = None

        if passthrough is not None:
            self.passthrough = passthrough
        if latency_mode is not None:
            self.latency_mode = latency_mode
        if reconnect_window is not None:
            self.reconnect_window = reconnect_window
        if use_slate_for_standard_latency is not None:
            self.use_slate_for_standard_latency = use_slate_for_standard_latency
        if reconnect_slate_url is not None:
            self.reconnect_slate_url = reconnect_slate_url
        if max_continuous_duration is not None:
            self.max_continuous_duration = max_continuous_duration

    @property
    def passthrough(self):
        """Gets the passthrough of this UpdateLiveStreamRequest.  # noqa: E501

        Arbitrary user-supplied metadata set for the live stream. Max 255 characters. In order to clear this value, the field should be included with an empty-string value.  # noqa: E501

        :return: The passthrough of this UpdateLiveStreamRequest.  # noqa: E501
        :rtype: str
        """
        return self._passthrough

    @passthrough.setter
    def passthrough(self, passthrough):
        """Sets the passthrough of this UpdateLiveStreamRequest.

        Arbitrary user-supplied metadata set for the live stream. Max 255 characters. In order to clear this value, the field should be included with an empty-string value.  # noqa: E501

        :param passthrough: The passthrough of this UpdateLiveStreamRequest.  # noqa: E501
        :type passthrough: str
        """

        self._passthrough = passthrough

    @property
    def latency_mode(self):
        """Gets the latency_mode of this UpdateLiveStreamRequest.  # noqa: E501

        Latency is the time from when the streamer transmits a frame of video to when you see it in the player. Set this as an alternative to setting low latency or reduced latency flags.  # noqa: E501

        :return: The latency_mode of this UpdateLiveStreamRequest.  # noqa: E501
        :rtype: str
        """
        return self._latency_mode

    @latency_mode.setter
    def latency_mode(self, latency_mode):
        """Sets the latency_mode of this UpdateLiveStreamRequest.

        Latency is the time from when the streamer transmits a frame of video to when you see it in the player. Set this as an alternative to setting low latency or reduced latency flags.  # noqa: E501

        :param latency_mode: The latency_mode of this UpdateLiveStreamRequest.  # noqa: E501
        :type latency_mode: str
        """
        allowed_values = ["low", "reduced", "standard"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and latency_mode not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `latency_mode` ({0}), must be one of {1}"  # noqa: E501
                .format(latency_mode, allowed_values)
            )

        self._latency_mode = latency_mode

    @property
    def reconnect_window(self):
        """Gets the reconnect_window of this UpdateLiveStreamRequest.  # noqa: E501

        When live streaming software disconnects from Mux, either intentionally or due to a drop in the network, the Reconnect Window is the time in seconds that Mux should wait for the streaming software to reconnect before considering the live stream finished and completing the recorded asset.  If not specified directly, Standard Latency streams have a Reconnect Window of 60 seconds; Reduced and Low Latency streams have a default of 0 seconds, or no Reconnect Window. For that reason, we suggest specifying a value other than zero for Reduced and Low Latency streams.  Reduced and Low Latency streams with a Reconnect Window greater than zero will insert slate media into the recorded asset while waiting for the streaming software to reconnect or when there are brief interruptions in the live stream media. When using a Reconnect Window setting higher than 60 seconds with a Standard Latency stream, we highly recommend enabling slate with the `use_slate_for_standard_latency` option.   # noqa: E501

        :return: The reconnect_window of this UpdateLiveStreamRequest.  # noqa: E501
        :rtype: float
        """
        return self._reconnect_window

    @reconnect_window.setter
    def reconnect_window(self, reconnect_window):
        """Sets the reconnect_window of this UpdateLiveStreamRequest.

        When live streaming software disconnects from Mux, either intentionally or due to a drop in the network, the Reconnect Window is the time in seconds that Mux should wait for the streaming software to reconnect before considering the live stream finished and completing the recorded asset.  If not specified directly, Standard Latency streams have a Reconnect Window of 60 seconds; Reduced and Low Latency streams have a default of 0 seconds, or no Reconnect Window. For that reason, we suggest specifying a value other than zero for Reduced and Low Latency streams.  Reduced and Low Latency streams with a Reconnect Window greater than zero will insert slate media into the recorded asset while waiting for the streaming software to reconnect or when there are brief interruptions in the live stream media. When using a Reconnect Window setting higher than 60 seconds with a Standard Latency stream, we highly recommend enabling slate with the `use_slate_for_standard_latency` option.   # noqa: E501

        :param reconnect_window: The reconnect_window of this UpdateLiveStreamRequest.  # noqa: E501
        :type reconnect_window: float
        """
        if (self.local_vars_configuration.client_side_validation and
                reconnect_window is not None and reconnect_window > 1800):  # noqa: E501
            raise ValueError("Invalid value for `reconnect_window`, must be a value less than or equal to `1800`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                reconnect_window is not None and reconnect_window < 0):  # noqa: E501
            raise ValueError("Invalid value for `reconnect_window`, must be a value greater than or equal to `0`")  # noqa: E501

        self._reconnect_window = reconnect_window

    @property
    def use_slate_for_standard_latency(self):
        """Gets the use_slate_for_standard_latency of this UpdateLiveStreamRequest.  # noqa: E501

        By default, Standard Latency live streams do not have slate media inserted while waiting for live streaming software to reconnect to Mux. Setting this to true enables slate insertion on a Standard Latency stream.  # noqa: E501

        :return: The use_slate_for_standard_latency of this UpdateLiveStreamRequest.  # noqa: E501
        :rtype: bool
        """
        return self._use_slate_for_standard_latency

    @use_slate_for_standard_latency.setter
    def use_slate_for_standard_latency(self, use_slate_for_standard_latency):
        """Sets the use_slate_for_standard_latency of this UpdateLiveStreamRequest.

        By default, Standard Latency live streams do not have slate media inserted while waiting for live streaming software to reconnect to Mux. Setting this to true enables slate insertion on a Standard Latency stream.  # noqa: E501

        :param use_slate_for_standard_latency: The use_slate_for_standard_latency of this UpdateLiveStreamRequest.  # noqa: E501
        :type use_slate_for_standard_latency: bool
        """

        self._use_slate_for_standard_latency = use_slate_for_standard_latency

    @property
    def reconnect_slate_url(self):
        """Gets the reconnect_slate_url of this UpdateLiveStreamRequest.  # noqa: E501

        The URL of the image file that Mux should download and use as slate media during interruptions of the live stream media. This file will be downloaded each time a new recorded asset is created from the live stream. Set this to a blank string to clear the value so that the default slate media will be used.  # noqa: E501

        :return: The reconnect_slate_url of this UpdateLiveStreamRequest.  # noqa: E501
        :rtype: str
        """
        return self._reconnect_slate_url

    @reconnect_slate_url.setter
    def reconnect_slate_url(self, reconnect_slate_url):
        """Sets the reconnect_slate_url of this UpdateLiveStreamRequest.

        The URL of the image file that Mux should download and use as slate media during interruptions of the live stream media. This file will be downloaded each time a new recorded asset is created from the live stream. Set this to a blank string to clear the value so that the default slate media will be used.  # noqa: E501

        :param reconnect_slate_url: The reconnect_slate_url of this UpdateLiveStreamRequest.  # noqa: E501
        :type reconnect_slate_url: str
        """

        self._reconnect_slate_url = reconnect_slate_url

    @property
    def max_continuous_duration(self):
        """Gets the max_continuous_duration of this UpdateLiveStreamRequest.  # noqa: E501

        The time in seconds a live stream may be continuously active before being disconnected. Defaults to 12 hours.  # noqa: E501

        :return: The max_continuous_duration of this UpdateLiveStreamRequest.  # noqa: E501
        :rtype: int
        """
        return self._max_continuous_duration

    @max_continuous_duration.setter
    def max_continuous_duration(self, max_continuous_duration):
        """Sets the max_continuous_duration of this UpdateLiveStreamRequest.

        The time in seconds a live stream may be continuously active before being disconnected. Defaults to 12 hours.  # noqa: E501

        :param max_continuous_duration: The max_continuous_duration of this UpdateLiveStreamRequest.  # noqa: E501
        :type max_continuous_duration: int
        """
        if (self.local_vars_configuration.client_side_validation and
                max_continuous_duration is not None and max_continuous_duration > 43200):  # noqa: E501
            raise ValueError("Invalid value for `max_continuous_duration`, must be a value less than or equal to `43200`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                max_continuous_duration is not None and max_continuous_duration < 60):  # noqa: E501
            raise ValueError("Invalid value for `max_continuous_duration`, must be a value greater than or equal to `60`")  # noqa: E501

        self._max_continuous_duration = max_continuous_duration

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpdateLiveStreamRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UpdateLiveStreamRequest):
            return True

        return self.to_dict() != other.to_dict()
