# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mux_python.api_client import ApiClient
from mux_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class AssetsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_asset(self, create_asset_request, **kwargs):  # noqa: E501
        """Create an asset  # noqa: E501

        Create a new Mux Video asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_asset(create_asset_request, async_req=True)
        >>> result = thread.get()

        :param create_asset_request: (required)
        :type create_asset_request: CreateAssetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AssetResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_asset_with_http_info(create_asset_request, **kwargs)  # noqa: E501

    def create_asset_with_http_info(self, create_asset_request, **kwargs):  # noqa: E501
        """Create an asset  # noqa: E501

        Create a new Mux Video asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_asset_with_http_info(create_asset_request, async_req=True)
        >>> result = thread.get()

        :param create_asset_request: (required)
        :type create_asset_request: CreateAssetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AssetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'create_asset_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_asset" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_asset_request' is set
        if self.api_client.client_side_validation and ('create_asset_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_asset_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_asset_request` when calling `create_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_asset_request' in local_var_params:
            body_params = local_var_params['create_asset_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            201: "AssetResponse",
        }

        return self.api_client.call_api(
            '/video/v1/assets', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_asset_playback_id(self, asset_id, create_playback_id_request, **kwargs):  # noqa: E501
        """Create a playback ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_asset_playback_id(asset_id, create_playback_id_request, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param create_playback_id_request: (required)
        :type create_playback_id_request: CreatePlaybackIDRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreatePlaybackIDResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_asset_playback_id_with_http_info(asset_id, create_playback_id_request, **kwargs)  # noqa: E501

    def create_asset_playback_id_with_http_info(self, asset_id, create_playback_id_request, **kwargs):  # noqa: E501
        """Create a playback ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_asset_playback_id_with_http_info(asset_id, create_playback_id_request, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param create_playback_id_request: (required)
        :type create_playback_id_request: CreatePlaybackIDRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreatePlaybackIDResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'asset_id',
            'create_playback_id_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_asset_playback_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'asset_id' is set
        if self.api_client.client_side_validation and ('asset_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['asset_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `asset_id` when calling `create_asset_playback_id`")  # noqa: E501
        # verify the required parameter 'create_playback_id_request' is set
        if self.api_client.client_side_validation and ('create_playback_id_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_playback_id_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_playback_id_request` when calling `create_asset_playback_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in local_var_params:
            path_params['ASSET_ID'] = local_var_params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_playback_id_request' in local_var_params:
            body_params = local_var_params['create_playback_id_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            201: "CreatePlaybackIDResponse",
        }

        return self.api_client.call_api(
            '/video/v1/assets/{ASSET_ID}/playback-ids', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_asset_track(self, asset_id, create_track_request, **kwargs):  # noqa: E501
        """Create an asset track  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_asset_track(asset_id, create_track_request, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param create_track_request: (required)
        :type create_track_request: CreateTrackRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateTrackResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_asset_track_with_http_info(asset_id, create_track_request, **kwargs)  # noqa: E501

    def create_asset_track_with_http_info(self, asset_id, create_track_request, **kwargs):  # noqa: E501
        """Create an asset track  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_asset_track_with_http_info(asset_id, create_track_request, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param create_track_request: (required)
        :type create_track_request: CreateTrackRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateTrackResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'asset_id',
            'create_track_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_asset_track" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'asset_id' is set
        if self.api_client.client_side_validation and ('asset_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['asset_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `asset_id` when calling `create_asset_track`")  # noqa: E501
        # verify the required parameter 'create_track_request' is set
        if self.api_client.client_side_validation and ('create_track_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_track_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_track_request` when calling `create_asset_track`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in local_var_params:
            path_params['ASSET_ID'] = local_var_params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_track_request' in local_var_params:
            body_params = local_var_params['create_track_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            201: "CreateTrackResponse",
        }

        return self.api_client.call_api(
            '/video/v1/assets/{ASSET_ID}/tracks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_asset(self, asset_id, **kwargs):  # noqa: E501
        """Delete an asset  # noqa: E501

        Deletes a video asset and all its data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_asset_with_http_info(asset_id, **kwargs)  # noqa: E501

    def delete_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Delete an asset  # noqa: E501

        Deletes a video asset and all its data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'asset_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_asset" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'asset_id' is set
        if self.api_client.client_side_validation and ('asset_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['asset_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `asset_id` when calling `delete_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in local_var_params:
            path_params['ASSET_ID'] = local_var_params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {}

        return self.api_client.call_api(
            '/video/v1/assets/{ASSET_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_asset_playback_id(self, asset_id, playback_id, **kwargs):  # noqa: E501
        """Delete a playback ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_asset_playback_id(asset_id, playback_id, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param playback_id: The live stream's playback ID. (required)
        :type playback_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_asset_playback_id_with_http_info(asset_id, playback_id, **kwargs)  # noqa: E501

    def delete_asset_playback_id_with_http_info(self, asset_id, playback_id, **kwargs):  # noqa: E501
        """Delete a playback ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_asset_playback_id_with_http_info(asset_id, playback_id, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param playback_id: The live stream's playback ID. (required)
        :type playback_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'asset_id',
            'playback_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_asset_playback_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'asset_id' is set
        if self.api_client.client_side_validation and ('asset_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['asset_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `asset_id` when calling `delete_asset_playback_id`")  # noqa: E501
        # verify the required parameter 'playback_id' is set
        if self.api_client.client_side_validation and ('playback_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['playback_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `playback_id` when calling `delete_asset_playback_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in local_var_params:
            path_params['ASSET_ID'] = local_var_params['asset_id']  # noqa: E501
        if 'playback_id' in local_var_params:
            path_params['PLAYBACK_ID'] = local_var_params['playback_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {}

        return self.api_client.call_api(
            '/video/v1/assets/{ASSET_ID}/playback-ids/{PLAYBACK_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_asset_track(self, asset_id, track_id, **kwargs):  # noqa: E501
        """Delete an asset track  # noqa: E501

        Removes a text track from an asset. Audio and video tracks on assets cannot be removed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_asset_track(asset_id, track_id, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param track_id: The track ID. (required)
        :type track_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_asset_track_with_http_info(asset_id, track_id, **kwargs)  # noqa: E501

    def delete_asset_track_with_http_info(self, asset_id, track_id, **kwargs):  # noqa: E501
        """Delete an asset track  # noqa: E501

        Removes a text track from an asset. Audio and video tracks on assets cannot be removed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_asset_track_with_http_info(asset_id, track_id, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param track_id: The track ID. (required)
        :type track_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'asset_id',
            'track_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_asset_track" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'asset_id' is set
        if self.api_client.client_side_validation and ('asset_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['asset_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `asset_id` when calling `delete_asset_track`")  # noqa: E501
        # verify the required parameter 'track_id' is set
        if self.api_client.client_side_validation and ('track_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['track_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `track_id` when calling `delete_asset_track`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in local_var_params:
            path_params['ASSET_ID'] = local_var_params['asset_id']  # noqa: E501
        if 'track_id' in local_var_params:
            path_params['TRACK_ID'] = local_var_params['track_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {}

        return self.api_client.call_api(
            '/video/v1/assets/{ASSET_ID}/tracks/{TRACK_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_asset(self, asset_id, **kwargs):  # noqa: E501
        """Retrieve an asset  # noqa: E501

        Retrieves the details of an asset that has previously been created. Supply the unique asset ID that was returned from your previous request, and Mux will return the corresponding asset information. The same information is returned when creating an asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_asset(asset_id, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AssetResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_asset_with_http_info(asset_id, **kwargs)  # noqa: E501

    def get_asset_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Retrieve an asset  # noqa: E501

        Retrieves the details of an asset that has previously been created. Supply the unique asset ID that was returned from your previous request, and Mux will return the corresponding asset information. The same information is returned when creating an asset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_asset_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AssetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'asset_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'asset_id' is set
        if self.api_client.client_side_validation and ('asset_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['asset_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `asset_id` when calling `get_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in local_var_params:
            path_params['ASSET_ID'] = local_var_params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "AssetResponse",
        }

        return self.api_client.call_api(
            '/video/v1/assets/{ASSET_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_asset_input_info(self, asset_id, **kwargs):  # noqa: E501
        """Retrieve asset input info  # noqa: E501

        Returns a list of the input objects that were used to create the asset along with any settings that were applied to each input.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_asset_input_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetAssetInputInfoResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_asset_input_info_with_http_info(asset_id, **kwargs)  # noqa: E501

    def get_asset_input_info_with_http_info(self, asset_id, **kwargs):  # noqa: E501
        """Retrieve asset input info  # noqa: E501

        Returns a list of the input objects that were used to create the asset along with any settings that were applied to each input.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_asset_input_info_with_http_info(asset_id, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetAssetInputInfoResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'asset_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_input_info" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'asset_id' is set
        if self.api_client.client_side_validation and ('asset_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['asset_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `asset_id` when calling `get_asset_input_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in local_var_params:
            path_params['ASSET_ID'] = local_var_params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "GetAssetInputInfoResponse",
        }

        return self.api_client.call_api(
            '/video/v1/assets/{ASSET_ID}/input-info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_asset_playback_id(self, asset_id, playback_id, **kwargs):  # noqa: E501
        """Retrieve a playback ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_asset_playback_id(asset_id, playback_id, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param playback_id: The live stream's playback ID. (required)
        :type playback_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetAssetPlaybackIDResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_asset_playback_id_with_http_info(asset_id, playback_id, **kwargs)  # noqa: E501

    def get_asset_playback_id_with_http_info(self, asset_id, playback_id, **kwargs):  # noqa: E501
        """Retrieve a playback ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_asset_playback_id_with_http_info(asset_id, playback_id, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param playback_id: The live stream's playback ID. (required)
        :type playback_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetAssetPlaybackIDResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'asset_id',
            'playback_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_asset_playback_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'asset_id' is set
        if self.api_client.client_side_validation and ('asset_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['asset_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `asset_id` when calling `get_asset_playback_id`")  # noqa: E501
        # verify the required parameter 'playback_id' is set
        if self.api_client.client_side_validation and ('playback_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['playback_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `playback_id` when calling `get_asset_playback_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in local_var_params:
            path_params['ASSET_ID'] = local_var_params['asset_id']  # noqa: E501
        if 'playback_id' in local_var_params:
            path_params['PLAYBACK_ID'] = local_var_params['playback_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "GetAssetPlaybackIDResponse",
        }

        return self.api_client.call_api(
            '/video/v1/assets/{ASSET_ID}/playback-ids/{PLAYBACK_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_assets(self, **kwargs):  # noqa: E501
        """List assets  # noqa: E501

        List all Mux assets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_assets(async_req=True)
        >>> result = thread.get()

        :param limit: Number of items to include in the response
        :type limit: int
        :param page: Offset by this many pages, of the size of `limit`
        :type page: int
        :param live_stream_id: Filter response to return all the assets for this live stream only
        :type live_stream_id: str
        :param upload_id: Filter response to return an asset created from this direct upload only
        :type upload_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListAssetsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.list_assets_with_http_info(**kwargs)  # noqa: E501

    def list_assets_with_http_info(self, **kwargs):  # noqa: E501
        """List assets  # noqa: E501

        List all Mux assets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_assets_with_http_info(async_req=True)
        >>> result = thread.get()

        :param limit: Number of items to include in the response
        :type limit: int
        :param page: Offset by this many pages, of the size of `limit`
        :type page: int
        :param live_stream_id: Filter response to return all the assets for this live stream only
        :type live_stream_id: str
        :param upload_id: Filter response to return an asset created from this direct upload only
        :type upload_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListAssetsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'page',
            'live_stream_id',
            'upload_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_assets" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'live_stream_id' in local_var_params and local_var_params['live_stream_id'] is not None:  # noqa: E501
            query_params.append(('live_stream_id', local_var_params['live_stream_id']))  # noqa: E501
        if 'upload_id' in local_var_params and local_var_params['upload_id'] is not None:  # noqa: E501
            query_params.append(('upload_id', local_var_params['upload_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "ListAssetsResponse",
        }

        return self.api_client.call_api(
            '/video/v1/assets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_asset(self, asset_id, update_asset_request, **kwargs):  # noqa: E501
        """Update an Asset  # noqa: E501

        Updates the details of an already-created Asset with the provided Asset ID. This currently supports only the `passthrough` field.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_asset(asset_id, update_asset_request, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param update_asset_request: (required)
        :type update_asset_request: UpdateAssetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AssetResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_asset_with_http_info(asset_id, update_asset_request, **kwargs)  # noqa: E501

    def update_asset_with_http_info(self, asset_id, update_asset_request, **kwargs):  # noqa: E501
        """Update an Asset  # noqa: E501

        Updates the details of an already-created Asset with the provided Asset ID. This currently supports only the `passthrough` field.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_asset_with_http_info(asset_id, update_asset_request, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param update_asset_request: (required)
        :type update_asset_request: UpdateAssetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AssetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'asset_id',
            'update_asset_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_asset" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'asset_id' is set
        if self.api_client.client_side_validation and ('asset_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['asset_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `asset_id` when calling `update_asset`")  # noqa: E501
        # verify the required parameter 'update_asset_request' is set
        if self.api_client.client_side_validation and ('update_asset_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_asset_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_asset_request` when calling `update_asset`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in local_var_params:
            path_params['ASSET_ID'] = local_var_params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_asset_request' in local_var_params:
            body_params = local_var_params['update_asset_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "AssetResponse",
        }

        return self.api_client.call_api(
            '/video/v1/assets/{ASSET_ID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_asset_master_access(self, asset_id, update_asset_master_access_request, **kwargs):  # noqa: E501
        """Update master access  # noqa: E501

        Allows you to add temporary access to the master (highest-quality) version of the asset in MP4 format. A URL will be created that can be used to download the master version for 24 hours. After 24 hours Master Access will revert to \"none\". This master version is not optimized for web and not meant to be streamed, only downloaded for purposes like archiving or editing the video offline.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_asset_master_access(asset_id, update_asset_master_access_request, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param update_asset_master_access_request: (required)
        :type update_asset_master_access_request: UpdateAssetMasterAccessRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AssetResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_asset_master_access_with_http_info(asset_id, update_asset_master_access_request, **kwargs)  # noqa: E501

    def update_asset_master_access_with_http_info(self, asset_id, update_asset_master_access_request, **kwargs):  # noqa: E501
        """Update master access  # noqa: E501

        Allows you to add temporary access to the master (highest-quality) version of the asset in MP4 format. A URL will be created that can be used to download the master version for 24 hours. After 24 hours Master Access will revert to \"none\". This master version is not optimized for web and not meant to be streamed, only downloaded for purposes like archiving or editing the video offline.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_asset_master_access_with_http_info(asset_id, update_asset_master_access_request, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param update_asset_master_access_request: (required)
        :type update_asset_master_access_request: UpdateAssetMasterAccessRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AssetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'asset_id',
            'update_asset_master_access_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_asset_master_access" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'asset_id' is set
        if self.api_client.client_side_validation and ('asset_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['asset_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `asset_id` when calling `update_asset_master_access`")  # noqa: E501
        # verify the required parameter 'update_asset_master_access_request' is set
        if self.api_client.client_side_validation and ('update_asset_master_access_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_asset_master_access_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_asset_master_access_request` when calling `update_asset_master_access`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in local_var_params:
            path_params['ASSET_ID'] = local_var_params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_asset_master_access_request' in local_var_params:
            body_params = local_var_params['update_asset_master_access_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "AssetResponse",
        }

        return self.api_client.call_api(
            '/video/v1/assets/{ASSET_ID}/master-access', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_asset_mp4_support(self, asset_id, update_asset_mp4_support_request, **kwargs):  # noqa: E501
        """Update MP4 support  # noqa: E501

        Allows you to add or remove mp4 support for assets that were created without it. Currently there are two values supported in this request, `standard` and `none`. `none` means that an asset *does not* have mp4 support, so submitting a request with `mp4_support` set to `none` will delete the mp4 assets from the asset in question.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_asset_mp4_support(asset_id, update_asset_mp4_support_request, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param update_asset_mp4_support_request: (required)
        :type update_asset_mp4_support_request: UpdateAssetMP4SupportRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AssetResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_asset_mp4_support_with_http_info(asset_id, update_asset_mp4_support_request, **kwargs)  # noqa: E501

    def update_asset_mp4_support_with_http_info(self, asset_id, update_asset_mp4_support_request, **kwargs):  # noqa: E501
        """Update MP4 support  # noqa: E501

        Allows you to add or remove mp4 support for assets that were created without it. Currently there are two values supported in this request, `standard` and `none`. `none` means that an asset *does not* have mp4 support, so submitting a request with `mp4_support` set to `none` will delete the mp4 assets from the asset in question.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_asset_mp4_support_with_http_info(asset_id, update_asset_mp4_support_request, async_req=True)
        >>> result = thread.get()

        :param asset_id: The asset ID. (required)
        :type asset_id: str
        :param update_asset_mp4_support_request: (required)
        :type update_asset_mp4_support_request: UpdateAssetMP4SupportRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AssetResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'asset_id',
            'update_asset_mp4_support_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_asset_mp4_support" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'asset_id' is set
        if self.api_client.client_side_validation and ('asset_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['asset_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `asset_id` when calling `update_asset_mp4_support`")  # noqa: E501
        # verify the required parameter 'update_asset_mp4_support_request' is set
        if self.api_client.client_side_validation and ('update_asset_mp4_support_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_asset_mp4_support_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_asset_mp4_support_request` when calling `update_asset_mp4_support`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'asset_id' in local_var_params:
            path_params['ASSET_ID'] = local_var_params['asset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_asset_mp4_support_request' in local_var_params:
            body_params = local_var_params['update_asset_mp4_support_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "AssetResponse",
        }

        return self.api_client.call_api(
            '/video/v1/assets/{ASSET_ID}/mp4-support', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
