# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mux_python.api_client import ApiClient
from mux_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class MetricsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_metric_timeseries_data(self, metric_id, **kwargs):  # noqa: E501
        """Get metric timeseries data  # noqa: E501

        Returns timeseries data for a specific metric.  Each interval represented in the data array contains an array with the following values:   * the first element is the interval time   * the second element is the calculated metric value    * the third element is the number of views in the interval that have a valid metric value   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_metric_timeseries_data(metric_id, async_req=True)
        >>> result = thread.get()

        :param metric_id: ID of the Metric (required)
        :type metric_id: str
        :param timeframe: Timeframe window to limit results by. Must be provided as an array query string parameter (e.g. timeframe[]=).  Accepted formats are...    * array of epoch timestamps e.g. `timeframe[]=1498867200&timeframe[]=1498953600`   * duration string e.g. `timeframe[]=24:hours or timeframe[]=7:days` 
        :type timeframe: list[str]
        :param filters: Limit the results to rows that match conditions from provided key:value pairs. Must be provided as an array query string parameter.  To exclude rows that match a certain condition, prepend a `!` character to the dimension.  Possible filter names are the same as returned by the List Filters endpoint.  Example:    * `filters[]=operating_system:windows&filters[]=!country:US` 
        :type filters: list[str]
        :param measurement: Measurement for the provided metric. If omitted, the default for the metric will be used.
        :type measurement: str
        :param order_direction: Sort order.
        :type order_direction: str
        :param group_by: Time granularity to group results by. If this value is omitted, a default granularity is chosen based on the timeframe.  For timeframes of 6 hours or less, the default granularity is `ten_minutes`. Between 6 hours and 15 hours inclusive, the default granularity is `hour`. The granularity of timeframes that exceed 15 hours is `day`. This default behaviour is subject to change; it is strongly suggested that you explicitly specify the granularity. 
        :type group_by: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetMetricTimeseriesDataResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_metric_timeseries_data_with_http_info(metric_id, **kwargs)  # noqa: E501

    def get_metric_timeseries_data_with_http_info(self, metric_id, **kwargs):  # noqa: E501
        """Get metric timeseries data  # noqa: E501

        Returns timeseries data for a specific metric.  Each interval represented in the data array contains an array with the following values:   * the first element is the interval time   * the second element is the calculated metric value    * the third element is the number of views in the interval that have a valid metric value   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_metric_timeseries_data_with_http_info(metric_id, async_req=True)
        >>> result = thread.get()

        :param metric_id: ID of the Metric (required)
        :type metric_id: str
        :param timeframe: Timeframe window to limit results by. Must be provided as an array query string parameter (e.g. timeframe[]=).  Accepted formats are...    * array of epoch timestamps e.g. `timeframe[]=1498867200&timeframe[]=1498953600`   * duration string e.g. `timeframe[]=24:hours or timeframe[]=7:days` 
        :type timeframe: list[str]
        :param filters: Limit the results to rows that match conditions from provided key:value pairs. Must be provided as an array query string parameter.  To exclude rows that match a certain condition, prepend a `!` character to the dimension.  Possible filter names are the same as returned by the List Filters endpoint.  Example:    * `filters[]=operating_system:windows&filters[]=!country:US` 
        :type filters: list[str]
        :param measurement: Measurement for the provided metric. If omitted, the default for the metric will be used.
        :type measurement: str
        :param order_direction: Sort order.
        :type order_direction: str
        :param group_by: Time granularity to group results by. If this value is omitted, a default granularity is chosen based on the timeframe.  For timeframes of 6 hours or less, the default granularity is `ten_minutes`. Between 6 hours and 15 hours inclusive, the default granularity is `hour`. The granularity of timeframes that exceed 15 hours is `day`. This default behaviour is subject to change; it is strongly suggested that you explicitly specify the granularity. 
        :type group_by: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetMetricTimeseriesDataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'metric_id',
            'timeframe',
            'filters',
            'measurement',
            'order_direction',
            'group_by'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metric_timeseries_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'metric_id' is set
        if self.api_client.client_side_validation and ('metric_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['metric_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `metric_id` when calling `get_metric_timeseries_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'metric_id' in local_var_params:
            path_params['METRIC_ID'] = local_var_params['metric_id']  # noqa: E501

        query_params = []
        if 'timeframe' in local_var_params and local_var_params['timeframe'] is not None:  # noqa: E501
            query_params.append(('timeframe[]', local_var_params['timeframe']))  # noqa: E501
            collection_formats['timeframe[]'] = 'multi'  # noqa: E501
        if 'filters' in local_var_params and local_var_params['filters'] is not None:  # noqa: E501
            query_params.append(('filters[]', local_var_params['filters']))  # noqa: E501
            collection_formats['filters[]'] = 'multi'  # noqa: E501
        if 'measurement' in local_var_params and local_var_params['measurement'] is not None:  # noqa: E501
            query_params.append(('measurement', local_var_params['measurement']))  # noqa: E501
        if 'order_direction' in local_var_params and local_var_params['order_direction'] is not None:  # noqa: E501
            query_params.append(('order_direction', local_var_params['order_direction']))  # noqa: E501
        if 'group_by' in local_var_params and local_var_params['group_by'] is not None:  # noqa: E501
            query_params.append(('group_by', local_var_params['group_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "GetMetricTimeseriesDataResponse",
        }

        return self.api_client.call_api(
            '/data/v1/metrics/{METRIC_ID}/timeseries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_overall_values(self, metric_id, **kwargs):  # noqa: E501
        """Get Overall values  # noqa: E501

        Returns the overall value for a specific metric, as well as the total view count, watch time, and the Mux Global metric value for the metric.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_overall_values(metric_id, async_req=True)
        >>> result = thread.get()

        :param metric_id: ID of the Metric (required)
        :type metric_id: str
        :param timeframe: Timeframe window to limit results by. Must be provided as an array query string parameter (e.g. timeframe[]=).  Accepted formats are...    * array of epoch timestamps e.g. `timeframe[]=1498867200&timeframe[]=1498953600`   * duration string e.g. `timeframe[]=24:hours or timeframe[]=7:days` 
        :type timeframe: list[str]
        :param filters: Limit the results to rows that match conditions from provided key:value pairs. Must be provided as an array query string parameter.  To exclude rows that match a certain condition, prepend a `!` character to the dimension.  Possible filter names are the same as returned by the List Filters endpoint.  Example:    * `filters[]=operating_system:windows&filters[]=!country:US` 
        :type filters: list[str]
        :param measurement: Measurement for the provided metric. If omitted, the default for the metric will be used.
        :type measurement: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetOverallValuesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_overall_values_with_http_info(metric_id, **kwargs)  # noqa: E501

    def get_overall_values_with_http_info(self, metric_id, **kwargs):  # noqa: E501
        """Get Overall values  # noqa: E501

        Returns the overall value for a specific metric, as well as the total view count, watch time, and the Mux Global metric value for the metric.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_overall_values_with_http_info(metric_id, async_req=True)
        >>> result = thread.get()

        :param metric_id: ID of the Metric (required)
        :type metric_id: str
        :param timeframe: Timeframe window to limit results by. Must be provided as an array query string parameter (e.g. timeframe[]=).  Accepted formats are...    * array of epoch timestamps e.g. `timeframe[]=1498867200&timeframe[]=1498953600`   * duration string e.g. `timeframe[]=24:hours or timeframe[]=7:days` 
        :type timeframe: list[str]
        :param filters: Limit the results to rows that match conditions from provided key:value pairs. Must be provided as an array query string parameter.  To exclude rows that match a certain condition, prepend a `!` character to the dimension.  Possible filter names are the same as returned by the List Filters endpoint.  Example:    * `filters[]=operating_system:windows&filters[]=!country:US` 
        :type filters: list[str]
        :param measurement: Measurement for the provided metric. If omitted, the default for the metric will be used.
        :type measurement: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetOverallValuesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'metric_id',
            'timeframe',
            'filters',
            'measurement'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_overall_values" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'metric_id' is set
        if self.api_client.client_side_validation and ('metric_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['metric_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `metric_id` when calling `get_overall_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'metric_id' in local_var_params:
            path_params['METRIC_ID'] = local_var_params['metric_id']  # noqa: E501

        query_params = []
        if 'timeframe' in local_var_params and local_var_params['timeframe'] is not None:  # noqa: E501
            query_params.append(('timeframe[]', local_var_params['timeframe']))  # noqa: E501
            collection_formats['timeframe[]'] = 'multi'  # noqa: E501
        if 'filters' in local_var_params and local_var_params['filters'] is not None:  # noqa: E501
            query_params.append(('filters[]', local_var_params['filters']))  # noqa: E501
            collection_formats['filters[]'] = 'multi'  # noqa: E501
        if 'measurement' in local_var_params and local_var_params['measurement'] is not None:  # noqa: E501
            query_params.append(('measurement', local_var_params['measurement']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "GetOverallValuesResponse",
        }

        return self.api_client.call_api(
            '/data/v1/metrics/{METRIC_ID}/overall', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_all_metric_values(self, **kwargs):  # noqa: E501
        """List all metric values  # noqa: E501

        List all of the values across every breakdown for a specific metric.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_all_metric_values(async_req=True)
        >>> result = thread.get()

        :param timeframe: Timeframe window to limit results by. Must be provided as an array query string parameter (e.g. timeframe[]=).  Accepted formats are...    * array of epoch timestamps e.g. `timeframe[]=1498867200&timeframe[]=1498953600`   * duration string e.g. `timeframe[]=24:hours or timeframe[]=7:days` 
        :type timeframe: list[str]
        :param filters: Limit the results to rows that match conditions from provided key:value pairs. Must be provided as an array query string parameter.  To exclude rows that match a certain condition, prepend a `!` character to the dimension.  Possible filter names are the same as returned by the List Filters endpoint.  Example:    * `filters[]=operating_system:windows&filters[]=!country:US` 
        :type filters: list[str]
        :param dimension: Dimension the specified value belongs to
        :type dimension: str
        :param value: Value to show all available metrics for
        :type value: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListAllMetricValuesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.list_all_metric_values_with_http_info(**kwargs)  # noqa: E501

    def list_all_metric_values_with_http_info(self, **kwargs):  # noqa: E501
        """List all metric values  # noqa: E501

        List all of the values across every breakdown for a specific metric.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_all_metric_values_with_http_info(async_req=True)
        >>> result = thread.get()

        :param timeframe: Timeframe window to limit results by. Must be provided as an array query string parameter (e.g. timeframe[]=).  Accepted formats are...    * array of epoch timestamps e.g. `timeframe[]=1498867200&timeframe[]=1498953600`   * duration string e.g. `timeframe[]=24:hours or timeframe[]=7:days` 
        :type timeframe: list[str]
        :param filters: Limit the results to rows that match conditions from provided key:value pairs. Must be provided as an array query string parameter.  To exclude rows that match a certain condition, prepend a `!` character to the dimension.  Possible filter names are the same as returned by the List Filters endpoint.  Example:    * `filters[]=operating_system:windows&filters[]=!country:US` 
        :type filters: list[str]
        :param dimension: Dimension the specified value belongs to
        :type dimension: str
        :param value: Value to show all available metrics for
        :type value: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListAllMetricValuesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'timeframe',
            'filters',
            'dimension',
            'value'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_all_metric_values" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timeframe' in local_var_params and local_var_params['timeframe'] is not None:  # noqa: E501
            query_params.append(('timeframe[]', local_var_params['timeframe']))  # noqa: E501
            collection_formats['timeframe[]'] = 'multi'  # noqa: E501
        if 'filters' in local_var_params and local_var_params['filters'] is not None:  # noqa: E501
            query_params.append(('filters[]', local_var_params['filters']))  # noqa: E501
            collection_formats['filters[]'] = 'multi'  # noqa: E501
        if 'dimension' in local_var_params and local_var_params['dimension'] is not None:  # noqa: E501
            query_params.append(('dimension', local_var_params['dimension']))  # noqa: E501
        if 'value' in local_var_params and local_var_params['value'] is not None:  # noqa: E501
            query_params.append(('value', local_var_params['value']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "ListAllMetricValuesResponse",
        }

        return self.api_client.call_api(
            '/data/v1/metrics/comparison', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_breakdown_values(self, metric_id, **kwargs):  # noqa: E501
        """List breakdown values  # noqa: E501

        List the breakdown values for a specific metric.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_breakdown_values(metric_id, async_req=True)
        >>> result = thread.get()

        :param metric_id: ID of the Metric (required)
        :type metric_id: str
        :param group_by: Breakdown value to group the results by
        :type group_by: str
        :param measurement: Measurement for the provided metric. If omitted, the default for the metric will be used.
        :type measurement: str
        :param filters: Limit the results to rows that match conditions from provided key:value pairs. Must be provided as an array query string parameter.  To exclude rows that match a certain condition, prepend a `!` character to the dimension.  Possible filter names are the same as returned by the List Filters endpoint.  Example:    * `filters[]=operating_system:windows&filters[]=!country:US` 
        :type filters: list[str]
        :param limit: Number of items to include in the response
        :type limit: int
        :param page: Offset by this many pages, of the size of `limit`
        :type page: int
        :param order_by: Value to order the results by
        :type order_by: str
        :param order_direction: Sort order.
        :type order_direction: str
        :param timeframe: Timeframe window to limit results by. Must be provided as an array query string parameter (e.g. timeframe[]=).  Accepted formats are...    * array of epoch timestamps e.g. `timeframe[]=1498867200&timeframe[]=1498953600`   * duration string e.g. `timeframe[]=24:hours or timeframe[]=7:days` 
        :type timeframe: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListBreakdownValuesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.list_breakdown_values_with_http_info(metric_id, **kwargs)  # noqa: E501

    def list_breakdown_values_with_http_info(self, metric_id, **kwargs):  # noqa: E501
        """List breakdown values  # noqa: E501

        List the breakdown values for a specific metric.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_breakdown_values_with_http_info(metric_id, async_req=True)
        >>> result = thread.get()

        :param metric_id: ID of the Metric (required)
        :type metric_id: str
        :param group_by: Breakdown value to group the results by
        :type group_by: str
        :param measurement: Measurement for the provided metric. If omitted, the default for the metric will be used.
        :type measurement: str
        :param filters: Limit the results to rows that match conditions from provided key:value pairs. Must be provided as an array query string parameter.  To exclude rows that match a certain condition, prepend a `!` character to the dimension.  Possible filter names are the same as returned by the List Filters endpoint.  Example:    * `filters[]=operating_system:windows&filters[]=!country:US` 
        :type filters: list[str]
        :param limit: Number of items to include in the response
        :type limit: int
        :param page: Offset by this many pages, of the size of `limit`
        :type page: int
        :param order_by: Value to order the results by
        :type order_by: str
        :param order_direction: Sort order.
        :type order_direction: str
        :param timeframe: Timeframe window to limit results by. Must be provided as an array query string parameter (e.g. timeframe[]=).  Accepted formats are...    * array of epoch timestamps e.g. `timeframe[]=1498867200&timeframe[]=1498953600`   * duration string e.g. `timeframe[]=24:hours or timeframe[]=7:days` 
        :type timeframe: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListBreakdownValuesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'metric_id',
            'group_by',
            'measurement',
            'filters',
            'limit',
            'page',
            'order_by',
            'order_direction',
            'timeframe'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_breakdown_values" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'metric_id' is set
        if self.api_client.client_side_validation and ('metric_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['metric_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `metric_id` when calling `list_breakdown_values`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'metric_id' in local_var_params:
            path_params['METRIC_ID'] = local_var_params['metric_id']  # noqa: E501

        query_params = []
        if 'group_by' in local_var_params and local_var_params['group_by'] is not None:  # noqa: E501
            query_params.append(('group_by', local_var_params['group_by']))  # noqa: E501
        if 'measurement' in local_var_params and local_var_params['measurement'] is not None:  # noqa: E501
            query_params.append(('measurement', local_var_params['measurement']))  # noqa: E501
        if 'filters' in local_var_params and local_var_params['filters'] is not None:  # noqa: E501
            query_params.append(('filters[]', local_var_params['filters']))  # noqa: E501
            collection_formats['filters[]'] = 'multi'  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'order_by' in local_var_params and local_var_params['order_by'] is not None:  # noqa: E501
            query_params.append(('order_by', local_var_params['order_by']))  # noqa: E501
        if 'order_direction' in local_var_params and local_var_params['order_direction'] is not None:  # noqa: E501
            query_params.append(('order_direction', local_var_params['order_direction']))  # noqa: E501
        if 'timeframe' in local_var_params and local_var_params['timeframe'] is not None:  # noqa: E501
            query_params.append(('timeframe[]', local_var_params['timeframe']))  # noqa: E501
            collection_formats['timeframe[]'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "ListBreakdownValuesResponse",
        }

        return self.api_client.call_api(
            '/data/v1/metrics/{METRIC_ID}/breakdown', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_insights(self, metric_id, **kwargs):  # noqa: E501
        """List Insights  # noqa: E501

        Returns a list of insights for a metric. These are the worst performing values across all breakdowns sorted by how much they negatively impact a specific metric.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_insights(metric_id, async_req=True)
        >>> result = thread.get()

        :param metric_id: ID of the Metric (required)
        :type metric_id: str
        :param measurement: Measurement for the provided metric. If omitted, the default for the metric will be used.
        :type measurement: str
        :param order_direction: Sort order.
        :type order_direction: str
        :param timeframe: Timeframe window to limit results by. Must be provided as an array query string parameter (e.g. timeframe[]=).  Accepted formats are...    * array of epoch timestamps e.g. `timeframe[]=1498867200&timeframe[]=1498953600`   * duration string e.g. `timeframe[]=24:hours or timeframe[]=7:days` 
        :type timeframe: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListInsightsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.list_insights_with_http_info(metric_id, **kwargs)  # noqa: E501

    def list_insights_with_http_info(self, metric_id, **kwargs):  # noqa: E501
        """List Insights  # noqa: E501

        Returns a list of insights for a metric. These are the worst performing values across all breakdowns sorted by how much they negatively impact a specific metric.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_insights_with_http_info(metric_id, async_req=True)
        >>> result = thread.get()

        :param metric_id: ID of the Metric (required)
        :type metric_id: str
        :param measurement: Measurement for the provided metric. If omitted, the default for the metric will be used.
        :type measurement: str
        :param order_direction: Sort order.
        :type order_direction: str
        :param timeframe: Timeframe window to limit results by. Must be provided as an array query string parameter (e.g. timeframe[]=).  Accepted formats are...    * array of epoch timestamps e.g. `timeframe[]=1498867200&timeframe[]=1498953600`   * duration string e.g. `timeframe[]=24:hours or timeframe[]=7:days` 
        :type timeframe: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListInsightsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'metric_id',
            'measurement',
            'order_direction',
            'timeframe'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_insights" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'metric_id' is set
        if self.api_client.client_side_validation and ('metric_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['metric_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `metric_id` when calling `list_insights`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'metric_id' in local_var_params:
            path_params['METRIC_ID'] = local_var_params['metric_id']  # noqa: E501

        query_params = []
        if 'measurement' in local_var_params and local_var_params['measurement'] is not None:  # noqa: E501
            query_params.append(('measurement', local_var_params['measurement']))  # noqa: E501
        if 'order_direction' in local_var_params and local_var_params['order_direction'] is not None:  # noqa: E501
            query_params.append(('order_direction', local_var_params['order_direction']))  # noqa: E501
        if 'timeframe' in local_var_params and local_var_params['timeframe'] is not None:  # noqa: E501
            query_params.append(('timeframe[]', local_var_params['timeframe']))  # noqa: E501
            collection_formats['timeframe[]'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "ListInsightsResponse",
        }

        return self.api_client.call_api(
            '/data/v1/metrics/{METRIC_ID}/insights', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
