# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mux_python.api_client import ApiClient
from mux_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class SpacesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_space(self, create_space_request, **kwargs):  # noqa: E501
        """Create a space  # noqa: E501

        Create a new space. Spaces are used to build [real-time video applications.](https://mux.com/real-time-video)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_space(create_space_request, async_req=True)
        >>> result = thread.get()

        :param create_space_request: (required)
        :type create_space_request: CreateSpaceRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpaceResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_space_with_http_info(create_space_request, **kwargs)  # noqa: E501

    def create_space_with_http_info(self, create_space_request, **kwargs):  # noqa: E501
        """Create a space  # noqa: E501

        Create a new space. Spaces are used to build [real-time video applications.](https://mux.com/real-time-video)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_space_with_http_info(create_space_request, async_req=True)
        >>> result = thread.get()

        :param create_space_request: (required)
        :type create_space_request: CreateSpaceRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpaceResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'create_space_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_space" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_space_request' is set
        if self.api_client.client_side_validation and ('create_space_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_space_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_space_request` when calling `create_space`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_space_request' in local_var_params:
            body_params = local_var_params['create_space_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            201: "SpaceResponse",
        }

        return self.api_client.call_api(
            '/video/v1/spaces', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_space_broadcast(self, space_id, create_broadcast_request, **kwargs):  # noqa: E501
        """Create a space broadcast  # noqa: E501

        Creates a new broadcast. Broadcasts are used to create composited versions of your space, which can be broadcast to live streams.  **Note:** By default only a single broadcast destination can be specified. Contact Mux support if you need more.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_space_broadcast(space_id, create_broadcast_request, async_req=True)
        >>> result = thread.get()

        :param space_id: The space ID. (required)
        :type space_id: str
        :param create_broadcast_request: (required)
        :type create_broadcast_request: CreateBroadcastRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BroadcastResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_space_broadcast_with_http_info(space_id, create_broadcast_request, **kwargs)  # noqa: E501

    def create_space_broadcast_with_http_info(self, space_id, create_broadcast_request, **kwargs):  # noqa: E501
        """Create a space broadcast  # noqa: E501

        Creates a new broadcast. Broadcasts are used to create composited versions of your space, which can be broadcast to live streams.  **Note:** By default only a single broadcast destination can be specified. Contact Mux support if you need more.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_space_broadcast_with_http_info(space_id, create_broadcast_request, async_req=True)
        >>> result = thread.get()

        :param space_id: The space ID. (required)
        :type space_id: str
        :param create_broadcast_request: (required)
        :type create_broadcast_request: CreateBroadcastRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BroadcastResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'space_id',
            'create_broadcast_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_space_broadcast" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_id' is set
        if self.api_client.client_side_validation and ('space_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['space_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `space_id` when calling `create_space_broadcast`")  # noqa: E501
        # verify the required parameter 'create_broadcast_request' is set
        if self.api_client.client_side_validation and ('create_broadcast_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_broadcast_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_broadcast_request` when calling `create_space_broadcast`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'space_id' in local_var_params:
            path_params['SPACE_ID'] = local_var_params['space_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_broadcast_request' in local_var_params:
            body_params = local_var_params['create_broadcast_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            201: "BroadcastResponse",
        }

        return self.api_client.call_api(
            '/video/v1/spaces/${SPACE_ID}/broadcasts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_space(self, space_id, **kwargs):  # noqa: E501
        """Delete a space  # noqa: E501

        Deletes a space. Spaces can only be deleted when `idle`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_space(space_id, async_req=True)
        >>> result = thread.get()

        :param space_id: The space ID. (required)
        :type space_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_space_with_http_info(space_id, **kwargs)  # noqa: E501

    def delete_space_with_http_info(self, space_id, **kwargs):  # noqa: E501
        """Delete a space  # noqa: E501

        Deletes a space. Spaces can only be deleted when `idle`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_space_with_http_info(space_id, async_req=True)
        >>> result = thread.get()

        :param space_id: The space ID. (required)
        :type space_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'space_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_space" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_id' is set
        if self.api_client.client_side_validation and ('space_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['space_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `space_id` when calling `delete_space`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'space_id' in local_var_params:
            path_params['SPACE_ID'] = local_var_params['space_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {}

        return self.api_client.call_api(
            '/video/v1/spaces/${SPACE_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_space_broadcast(self, space_id, broadcast_id, **kwargs):  # noqa: E501
        """Delete a space broadcast  # noqa: E501

        Deletes a single broadcast of a specific space. Broadcasts can only be deleted when `idle`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_space_broadcast(space_id, broadcast_id, async_req=True)
        >>> result = thread.get()

        :param space_id: The space ID. (required)
        :type space_id: str
        :param broadcast_id: The broadcast ID. (required)
        :type broadcast_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_space_broadcast_with_http_info(space_id, broadcast_id, **kwargs)  # noqa: E501

    def delete_space_broadcast_with_http_info(self, space_id, broadcast_id, **kwargs):  # noqa: E501
        """Delete a space broadcast  # noqa: E501

        Deletes a single broadcast of a specific space. Broadcasts can only be deleted when `idle`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_space_broadcast_with_http_info(space_id, broadcast_id, async_req=True)
        >>> result = thread.get()

        :param space_id: The space ID. (required)
        :type space_id: str
        :param broadcast_id: The broadcast ID. (required)
        :type broadcast_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'space_id',
            'broadcast_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_space_broadcast" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_id' is set
        if self.api_client.client_side_validation and ('space_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['space_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `space_id` when calling `delete_space_broadcast`")  # noqa: E501
        # verify the required parameter 'broadcast_id' is set
        if self.api_client.client_side_validation and ('broadcast_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['broadcast_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `broadcast_id` when calling `delete_space_broadcast`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'space_id' in local_var_params:
            path_params['SPACE_ID'] = local_var_params['space_id']  # noqa: E501
        if 'broadcast_id' in local_var_params:
            path_params['BROADCAST_ID'] = local_var_params['broadcast_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {}

        return self.api_client.call_api(
            '/video/v1/spaces/${SPACE_ID}/broadcasts/${BROADCAST_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_space(self, space_id, **kwargs):  # noqa: E501
        """Retrieve a space  # noqa: E501

        Retrieves the details of a space that has previously been created. Supply the unique space ID that was returned from your create space request, and Mux will return the information about the corresponding space. The same information is returned when creating a space.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_space(space_id, async_req=True)
        >>> result = thread.get()

        :param space_id: The space ID. (required)
        :type space_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpaceResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_space_with_http_info(space_id, **kwargs)  # noqa: E501

    def get_space_with_http_info(self, space_id, **kwargs):  # noqa: E501
        """Retrieve a space  # noqa: E501

        Retrieves the details of a space that has previously been created. Supply the unique space ID that was returned from your create space request, and Mux will return the information about the corresponding space. The same information is returned when creating a space.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_space_with_http_info(space_id, async_req=True)
        >>> result = thread.get()

        :param space_id: The space ID. (required)
        :type space_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpaceResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'space_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_space" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_id' is set
        if self.api_client.client_side_validation and ('space_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['space_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `space_id` when calling `get_space`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'space_id' in local_var_params:
            path_params['SPACE_ID'] = local_var_params['space_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "SpaceResponse",
        }

        return self.api_client.call_api(
            '/video/v1/spaces/${SPACE_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_space_broadcast(self, space_id, broadcast_id, **kwargs):  # noqa: E501
        """Retrieve space broadcast  # noqa: E501

        Retrieves the details of a broadcast of a specific space.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_space_broadcast(space_id, broadcast_id, async_req=True)
        >>> result = thread.get()

        :param space_id: The space ID. (required)
        :type space_id: str
        :param broadcast_id: The broadcast ID. (required)
        :type broadcast_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BroadcastResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_space_broadcast_with_http_info(space_id, broadcast_id, **kwargs)  # noqa: E501

    def get_space_broadcast_with_http_info(self, space_id, broadcast_id, **kwargs):  # noqa: E501
        """Retrieve space broadcast  # noqa: E501

        Retrieves the details of a broadcast of a specific space.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_space_broadcast_with_http_info(space_id, broadcast_id, async_req=True)
        >>> result = thread.get()

        :param space_id: The space ID. (required)
        :type space_id: str
        :param broadcast_id: The broadcast ID. (required)
        :type broadcast_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BroadcastResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'space_id',
            'broadcast_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_space_broadcast" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_id' is set
        if self.api_client.client_side_validation and ('space_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['space_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `space_id` when calling `get_space_broadcast`")  # noqa: E501
        # verify the required parameter 'broadcast_id' is set
        if self.api_client.client_side_validation and ('broadcast_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['broadcast_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `broadcast_id` when calling `get_space_broadcast`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'space_id' in local_var_params:
            path_params['SPACE_ID'] = local_var_params['space_id']  # noqa: E501
        if 'broadcast_id' in local_var_params:
            path_params['BROADCAST_ID'] = local_var_params['broadcast_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "BroadcastResponse",
        }

        return self.api_client.call_api(
            '/video/v1/spaces/${SPACE_ID}/broadcasts/${BROADCAST_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_spaces(self, **kwargs):  # noqa: E501
        """List spaces  # noqa: E501

        List all spaces in the current enviroment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_spaces(async_req=True)
        >>> result = thread.get()

        :param limit: Number of items to include in the response
        :type limit: int
        :param page: Offset by this many pages, of the size of `limit`
        :type page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListSpacesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.list_spaces_with_http_info(**kwargs)  # noqa: E501

    def list_spaces_with_http_info(self, **kwargs):  # noqa: E501
        """List spaces  # noqa: E501

        List all spaces in the current enviroment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_spaces_with_http_info(async_req=True)
        >>> result = thread.get()

        :param limit: Number of items to include in the response
        :type limit: int
        :param page: Offset by this many pages, of the size of `limit`
        :type page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListSpacesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_spaces" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "ListSpacesResponse",
        }

        return self.api_client.call_api(
            '/video/v1/spaces', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def start_space_broadcast(self, space_id, broadcast_id, **kwargs):  # noqa: E501
        """Start a space broadcast  # noqa: E501

        Starts broadcasting a space to the associated destination. Broadcasts can only be started when the space is `active` (when there are participants connected).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.start_space_broadcast(space_id, broadcast_id, async_req=True)
        >>> result = thread.get()

        :param space_id: The space ID. (required)
        :type space_id: str
        :param broadcast_id: The broadcast ID. (required)
        :type broadcast_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartSpaceBroadcastResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.start_space_broadcast_with_http_info(space_id, broadcast_id, **kwargs)  # noqa: E501

    def start_space_broadcast_with_http_info(self, space_id, broadcast_id, **kwargs):  # noqa: E501
        """Start a space broadcast  # noqa: E501

        Starts broadcasting a space to the associated destination. Broadcasts can only be started when the space is `active` (when there are participants connected).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.start_space_broadcast_with_http_info(space_id, broadcast_id, async_req=True)
        >>> result = thread.get()

        :param space_id: The space ID. (required)
        :type space_id: str
        :param broadcast_id: The broadcast ID. (required)
        :type broadcast_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartSpaceBroadcastResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'space_id',
            'broadcast_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_space_broadcast" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_id' is set
        if self.api_client.client_side_validation and ('space_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['space_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `space_id` when calling `start_space_broadcast`")  # noqa: E501
        # verify the required parameter 'broadcast_id' is set
        if self.api_client.client_side_validation and ('broadcast_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['broadcast_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `broadcast_id` when calling `start_space_broadcast`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'space_id' in local_var_params:
            path_params['SPACE_ID'] = local_var_params['space_id']  # noqa: E501
        if 'broadcast_id' in local_var_params:
            path_params['BROADCAST_ID'] = local_var_params['broadcast_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "StartSpaceBroadcastResponse",
        }

        return self.api_client.call_api(
            '/video/v1/spaces/${SPACE_ID}/broadcasts/${BROADCAST_ID}/start', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def stop_space_broadcast(self, space_id, broadcast_id, **kwargs):  # noqa: E501
        """Stop a space broadcast  # noqa: E501

        Stops broadcasting a space, causing the destination live stream to become idle. This API also automatically calls `complete` on the destination live stream. Broadcasts are also automatically stopped when a space becomes idle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stop_space_broadcast(space_id, broadcast_id, async_req=True)
        >>> result = thread.get()

        :param space_id: The space ID. (required)
        :type space_id: str
        :param broadcast_id: The broadcast ID. (required)
        :type broadcast_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StopSpaceBroadcastResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.stop_space_broadcast_with_http_info(space_id, broadcast_id, **kwargs)  # noqa: E501

    def stop_space_broadcast_with_http_info(self, space_id, broadcast_id, **kwargs):  # noqa: E501
        """Stop a space broadcast  # noqa: E501

        Stops broadcasting a space, causing the destination live stream to become idle. This API also automatically calls `complete` on the destination live stream. Broadcasts are also automatically stopped when a space becomes idle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stop_space_broadcast_with_http_info(space_id, broadcast_id, async_req=True)
        >>> result = thread.get()

        :param space_id: The space ID. (required)
        :type space_id: str
        :param broadcast_id: The broadcast ID. (required)
        :type broadcast_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StopSpaceBroadcastResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'space_id',
            'broadcast_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stop_space_broadcast" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'space_id' is set
        if self.api_client.client_side_validation and ('space_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['space_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `space_id` when calling `stop_space_broadcast`")  # noqa: E501
        # verify the required parameter 'broadcast_id' is set
        if self.api_client.client_side_validation and ('broadcast_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['broadcast_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `broadcast_id` when calling `stop_space_broadcast`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'space_id' in local_var_params:
            path_params['SPACE_ID'] = local_var_params['space_id']  # noqa: E501
        if 'broadcast_id' in local_var_params:
            path_params['BROADCAST_ID'] = local_var_params['broadcast_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "StopSpaceBroadcastResponse",
        }

        return self.api_client.call_api(
            '/video/v1/spaces/${SPACE_ID}/broadcasts/${BROADCAST_ID}/stop', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
