# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


import inspect
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class LiveStream(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'created_at': 'str',
        'stream_key': 'str',
        'active_asset_id': 'str',
        'recent_asset_ids': 'list[str]',
        'status': 'LiveStreamStatus',
        'playback_ids': 'list[PlaybackID]',
        'new_asset_settings': 'CreateAssetRequest',
        'passthrough': 'str',
        'audio_only': 'bool',
        'embedded_subtitles': 'list[LiveStreamEmbeddedSubtitleSettings]',
        'generated_subtitles': 'list[LiveStreamGeneratedSubtitleSettings]',
        'reconnect_window': 'float',
        'reduced_latency': 'bool',
        'low_latency': 'bool',
        'simulcast_targets': 'list[SimulcastTarget]',
        'latency_mode': 'str',
        'test': 'bool',
        'max_continuous_duration': 'int'
    }

    attribute_map = {
        'id': 'id',
        'created_at': 'created_at',
        'stream_key': 'stream_key',
        'active_asset_id': 'active_asset_id',
        'recent_asset_ids': 'recent_asset_ids',
        'status': 'status',
        'playback_ids': 'playback_ids',
        'new_asset_settings': 'new_asset_settings',
        'passthrough': 'passthrough',
        'audio_only': 'audio_only',
        'embedded_subtitles': 'embedded_subtitles',
        'generated_subtitles': 'generated_subtitles',
        'reconnect_window': 'reconnect_window',
        'reduced_latency': 'reduced_latency',
        'low_latency': 'low_latency',
        'simulcast_targets': 'simulcast_targets',
        'latency_mode': 'latency_mode',
        'test': 'test',
        'max_continuous_duration': 'max_continuous_duration'
    }

    def __init__(self, id=None, created_at=None, stream_key=None, active_asset_id=None, recent_asset_ids=None, status=None, playback_ids=None, new_asset_settings=None, passthrough=None, audio_only=None, embedded_subtitles=None, generated_subtitles=None, reconnect_window=60, reduced_latency=None, low_latency=None, simulcast_targets=None, latency_mode=None, test=None, max_continuous_duration=43200, local_vars_configuration=None):  # noqa: E501
        """LiveStream - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._created_at = None
        self._stream_key = None
        self._active_asset_id = None
        self._recent_asset_ids = None
        self._status = None
        self._playback_ids = None
        self._new_asset_settings = None
        self._passthrough = None
        self._audio_only = None
        self._embedded_subtitles = None
        self._generated_subtitles = None
        self._reconnect_window = None
        self._reduced_latency = None
        self._low_latency = None
        self._simulcast_targets = None
        self._latency_mode = None
        self._test = None
        self._max_continuous_duration = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if created_at is not None:
            self.created_at = created_at
        if stream_key is not None:
            self.stream_key = stream_key
        if active_asset_id is not None:
            self.active_asset_id = active_asset_id
        if recent_asset_ids is not None:
            self.recent_asset_ids = recent_asset_ids
        if status is not None:
            self.status = status
        if playback_ids is not None:
            self.playback_ids = playback_ids
        if new_asset_settings is not None:
            self.new_asset_settings = new_asset_settings
        if passthrough is not None:
            self.passthrough = passthrough
        if audio_only is not None:
            self.audio_only = audio_only
        if embedded_subtitles is not None:
            self.embedded_subtitles = embedded_subtitles
        if generated_subtitles is not None:
            self.generated_subtitles = generated_subtitles
        if reconnect_window is not None:
            self.reconnect_window = reconnect_window
        if reduced_latency is not None:
            self.reduced_latency = reduced_latency
        if low_latency is not None:
            self.low_latency = low_latency
        if simulcast_targets is not None:
            self.simulcast_targets = simulcast_targets
        if latency_mode is not None:
            self.latency_mode = latency_mode
        if test is not None:
            self.test = test
        if max_continuous_duration is not None:
            self.max_continuous_duration = max_continuous_duration

    @property
    def id(self):
        """Gets the id of this LiveStream.  # noqa: E501

        Unique identifier for the Live Stream. Max 255 characters.  # noqa: E501

        :return: The id of this LiveStream.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this LiveStream.

        Unique identifier for the Live Stream. Max 255 characters.  # noqa: E501

        :param id: The id of this LiveStream.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def created_at(self):
        """Gets the created_at of this LiveStream.  # noqa: E501

        Time the Live Stream was created, defined as a Unix timestamp (seconds since epoch).  # noqa: E501

        :return: The created_at of this LiveStream.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this LiveStream.

        Time the Live Stream was created, defined as a Unix timestamp (seconds since epoch).  # noqa: E501

        :param created_at: The created_at of this LiveStream.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def stream_key(self):
        """Gets the stream_key of this LiveStream.  # noqa: E501

        Unique key used for streaming to a Mux RTMP endpoint. This should be considered as sensitive as credentials, anyone with this stream key can begin streaming.  # noqa: E501

        :return: The stream_key of this LiveStream.  # noqa: E501
        :rtype: str
        """
        return self._stream_key

    @stream_key.setter
    def stream_key(self, stream_key):
        """Sets the stream_key of this LiveStream.

        Unique key used for streaming to a Mux RTMP endpoint. This should be considered as sensitive as credentials, anyone with this stream key can begin streaming.  # noqa: E501

        :param stream_key: The stream_key of this LiveStream.  # noqa: E501
        :type stream_key: str
        """

        self._stream_key = stream_key

    @property
    def active_asset_id(self):
        """Gets the active_asset_id of this LiveStream.  # noqa: E501

        The Asset that is currently being created if there is an active broadcast.  # noqa: E501

        :return: The active_asset_id of this LiveStream.  # noqa: E501
        :rtype: str
        """
        return self._active_asset_id

    @active_asset_id.setter
    def active_asset_id(self, active_asset_id):
        """Sets the active_asset_id of this LiveStream.

        The Asset that is currently being created if there is an active broadcast.  # noqa: E501

        :param active_asset_id: The active_asset_id of this LiveStream.  # noqa: E501
        :type active_asset_id: str
        """

        self._active_asset_id = active_asset_id

    @property
    def recent_asset_ids(self):
        """Gets the recent_asset_ids of this LiveStream.  # noqa: E501

        An array of strings with the most recent Assets that were created from this live stream.  # noqa: E501

        :return: The recent_asset_ids of this LiveStream.  # noqa: E501
        :rtype: list[str]
        """
        return self._recent_asset_ids

    @recent_asset_ids.setter
    def recent_asset_ids(self, recent_asset_ids):
        """Sets the recent_asset_ids of this LiveStream.

        An array of strings with the most recent Assets that were created from this live stream.  # noqa: E501

        :param recent_asset_ids: The recent_asset_ids of this LiveStream.  # noqa: E501
        :type recent_asset_ids: list[str]
        """

        self._recent_asset_ids = recent_asset_ids

    @property
    def status(self):
        """Gets the status of this LiveStream.  # noqa: E501


        :return: The status of this LiveStream.  # noqa: E501
        :rtype: LiveStreamStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this LiveStream.


        :param status: The status of this LiveStream.  # noqa: E501
        :type status: LiveStreamStatus
        """

        self._status = status

    @property
    def playback_ids(self):
        """Gets the playback_ids of this LiveStream.  # noqa: E501

        An array of Playback ID objects. Use these to create HLS playback URLs. See [Play your videos](https://docs.mux.com/guides/video/play-your-videos) for more details.  # noqa: E501

        :return: The playback_ids of this LiveStream.  # noqa: E501
        :rtype: list[PlaybackID]
        """
        return self._playback_ids

    @playback_ids.setter
    def playback_ids(self, playback_ids):
        """Sets the playback_ids of this LiveStream.

        An array of Playback ID objects. Use these to create HLS playback URLs. See [Play your videos](https://docs.mux.com/guides/video/play-your-videos) for more details.  # noqa: E501

        :param playback_ids: The playback_ids of this LiveStream.  # noqa: E501
        :type playback_ids: list[PlaybackID]
        """

        self._playback_ids = playback_ids

    @property
    def new_asset_settings(self):
        """Gets the new_asset_settings of this LiveStream.  # noqa: E501


        :return: The new_asset_settings of this LiveStream.  # noqa: E501
        :rtype: CreateAssetRequest
        """
        return self._new_asset_settings

    @new_asset_settings.setter
    def new_asset_settings(self, new_asset_settings):
        """Sets the new_asset_settings of this LiveStream.


        :param new_asset_settings: The new_asset_settings of this LiveStream.  # noqa: E501
        :type new_asset_settings: CreateAssetRequest
        """

        self._new_asset_settings = new_asset_settings

    @property
    def passthrough(self):
        """Gets the passthrough of this LiveStream.  # noqa: E501

        Arbitrary user-supplied metadata set for the asset. Max 255 characters.  # noqa: E501

        :return: The passthrough of this LiveStream.  # noqa: E501
        :rtype: str
        """
        return self._passthrough

    @passthrough.setter
    def passthrough(self, passthrough):
        """Sets the passthrough of this LiveStream.

        Arbitrary user-supplied metadata set for the asset. Max 255 characters.  # noqa: E501

        :param passthrough: The passthrough of this LiveStream.  # noqa: E501
        :type passthrough: str
        """

        self._passthrough = passthrough

    @property
    def audio_only(self):
        """Gets the audio_only of this LiveStream.  # noqa: E501

        The live stream only processes the audio track if the value is set to true. Mux drops the video track if broadcasted.  # noqa: E501

        :return: The audio_only of this LiveStream.  # noqa: E501
        :rtype: bool
        """
        return self._audio_only

    @audio_only.setter
    def audio_only(self, audio_only):
        """Sets the audio_only of this LiveStream.

        The live stream only processes the audio track if the value is set to true. Mux drops the video track if broadcasted.  # noqa: E501

        :param audio_only: The audio_only of this LiveStream.  # noqa: E501
        :type audio_only: bool
        """

        self._audio_only = audio_only

    @property
    def embedded_subtitles(self):
        """Gets the embedded_subtitles of this LiveStream.  # noqa: E501

        Describes the embedded closed caption configuration of the incoming live stream.  # noqa: E501

        :return: The embedded_subtitles of this LiveStream.  # noqa: E501
        :rtype: list[LiveStreamEmbeddedSubtitleSettings]
        """
        return self._embedded_subtitles

    @embedded_subtitles.setter
    def embedded_subtitles(self, embedded_subtitles):
        """Sets the embedded_subtitles of this LiveStream.

        Describes the embedded closed caption configuration of the incoming live stream.  # noqa: E501

        :param embedded_subtitles: The embedded_subtitles of this LiveStream.  # noqa: E501
        :type embedded_subtitles: list[LiveStreamEmbeddedSubtitleSettings]
        """

        self._embedded_subtitles = embedded_subtitles

    @property
    def generated_subtitles(self):
        """Gets the generated_subtitles of this LiveStream.  # noqa: E501

        Configure the incoming live stream to include subtitles created with automatic speech recognition. Each Asset created from a live stream with `generated_subtitles` configured will automatically receive two text tracks. The first of these will have a `text_source` value of `generated_live`, and will be available with `ready` status as soon as the stream is live. The second text track will have a `text_source` value of `generated_live_final` and will contain subtitles with improved accuracy, timing, and formatting. However, `generated_live_final` tracks will not be available in `ready` status until the live stream ends. If an Asset has both `generated_live` and `generated_live_final` tracks that are `ready`, then only the `generated_live_final` track will be included during playback.  # noqa: E501

        :return: The generated_subtitles of this LiveStream.  # noqa: E501
        :rtype: list[LiveStreamGeneratedSubtitleSettings]
        """
        return self._generated_subtitles

    @generated_subtitles.setter
    def generated_subtitles(self, generated_subtitles):
        """Sets the generated_subtitles of this LiveStream.

        Configure the incoming live stream to include subtitles created with automatic speech recognition. Each Asset created from a live stream with `generated_subtitles` configured will automatically receive two text tracks. The first of these will have a `text_source` value of `generated_live`, and will be available with `ready` status as soon as the stream is live. The second text track will have a `text_source` value of `generated_live_final` and will contain subtitles with improved accuracy, timing, and formatting. However, `generated_live_final` tracks will not be available in `ready` status until the live stream ends. If an Asset has both `generated_live` and `generated_live_final` tracks that are `ready`, then only the `generated_live_final` track will be included during playback.  # noqa: E501

        :param generated_subtitles: The generated_subtitles of this LiveStream.  # noqa: E501
        :type generated_subtitles: list[LiveStreamGeneratedSubtitleSettings]
        """

        self._generated_subtitles = generated_subtitles

    @property
    def reconnect_window(self):
        """Gets the reconnect_window of this LiveStream.  # noqa: E501

        When live streaming software disconnects from Mux, either intentionally or due to a drop in the network, the Reconnect Window is the time in seconds that Mux should wait for the streaming software to reconnect before considering the live stream finished and completing the recorded asset. **Min**: 0.1s. **Max**: 1800s (30 minutes).  # noqa: E501

        :return: The reconnect_window of this LiveStream.  # noqa: E501
        :rtype: float
        """
        return self._reconnect_window

    @reconnect_window.setter
    def reconnect_window(self, reconnect_window):
        """Sets the reconnect_window of this LiveStream.

        When live streaming software disconnects from Mux, either intentionally or due to a drop in the network, the Reconnect Window is the time in seconds that Mux should wait for the streaming software to reconnect before considering the live stream finished and completing the recorded asset. **Min**: 0.1s. **Max**: 1800s (30 minutes).  # noqa: E501

        :param reconnect_window: The reconnect_window of this LiveStream.  # noqa: E501
        :type reconnect_window: float
        """

        self._reconnect_window = reconnect_window

    @property
    def reduced_latency(self):
        """Gets the reduced_latency of this LiveStream.  # noqa: E501

        This field is deprecated. Please use latency_mode instead. Latency is the time from when the streamer transmits a frame of video to when you see it in the player. Set this if you want lower latency for your live stream. **Note**: Reconnect windows are incompatible with Reduced Latency and will always be set to zero (0) seconds. See the [Reduce live stream latency guide](https://docs.mux.com/guides/video/reduce-live-stream-latency) to understand the tradeoffs.  # noqa: E501

        :return: The reduced_latency of this LiveStream.  # noqa: E501
        :rtype: bool
        """
        return self._reduced_latency

    @reduced_latency.setter
    def reduced_latency(self, reduced_latency):
        """Sets the reduced_latency of this LiveStream.

        This field is deprecated. Please use latency_mode instead. Latency is the time from when the streamer transmits a frame of video to when you see it in the player. Set this if you want lower latency for your live stream. **Note**: Reconnect windows are incompatible with Reduced Latency and will always be set to zero (0) seconds. See the [Reduce live stream latency guide](https://docs.mux.com/guides/video/reduce-live-stream-latency) to understand the tradeoffs.  # noqa: E501

        :param reduced_latency: The reduced_latency of this LiveStream.  # noqa: E501
        :type reduced_latency: bool
        """

        self._reduced_latency = reduced_latency

    @property
    def low_latency(self):
        """Gets the low_latency of this LiveStream.  # noqa: E501

        This field is deprecated. Please use latency_mode instead. Latency is the time from when the streamer transmits a frame of video to when you see it in the player. Setting this option will enable compatibility with the LL-HLS specification for low-latency streaming. This typically has lower latency than Reduced Latency streams, and cannot be combined with Reduced Latency. Note: Reconnect windows are incompatible with Low Latency and will always be set to zero (0) seconds.  # noqa: E501

        :return: The low_latency of this LiveStream.  # noqa: E501
        :rtype: bool
        """
        return self._low_latency

    @low_latency.setter
    def low_latency(self, low_latency):
        """Sets the low_latency of this LiveStream.

        This field is deprecated. Please use latency_mode instead. Latency is the time from when the streamer transmits a frame of video to when you see it in the player. Setting this option will enable compatibility with the LL-HLS specification for low-latency streaming. This typically has lower latency than Reduced Latency streams, and cannot be combined with Reduced Latency. Note: Reconnect windows are incompatible with Low Latency and will always be set to zero (0) seconds.  # noqa: E501

        :param low_latency: The low_latency of this LiveStream.  # noqa: E501
        :type low_latency: bool
        """

        self._low_latency = low_latency

    @property
    def simulcast_targets(self):
        """Gets the simulcast_targets of this LiveStream.  # noqa: E501

        Each Simulcast Target contains configuration details to broadcast (or \"restream\") a live stream to a third-party streaming service. [See the Stream live to 3rd party platforms guide](https://docs.mux.com/guides/video/stream-live-to-3rd-party-platforms).  # noqa: E501

        :return: The simulcast_targets of this LiveStream.  # noqa: E501
        :rtype: list[SimulcastTarget]
        """
        return self._simulcast_targets

    @simulcast_targets.setter
    def simulcast_targets(self, simulcast_targets):
        """Sets the simulcast_targets of this LiveStream.

        Each Simulcast Target contains configuration details to broadcast (or \"restream\") a live stream to a third-party streaming service. [See the Stream live to 3rd party platforms guide](https://docs.mux.com/guides/video/stream-live-to-3rd-party-platforms).  # noqa: E501

        :param simulcast_targets: The simulcast_targets of this LiveStream.  # noqa: E501
        :type simulcast_targets: list[SimulcastTarget]
        """

        self._simulcast_targets = simulcast_targets

    @property
    def latency_mode(self):
        """Gets the latency_mode of this LiveStream.  # noqa: E501

        Latency is the time from when the streamer transmits a frame of video to when you see it in the player. Set this as an alternative to setting low latency or reduced latency flags. The Low Latency value is a beta feature. Note: Reconnect windows are incompatible with Reduced Latency and Low Latency and will always be set to zero (0) seconds. Read more here: https://mux.com/blog/introducing-low-latency-live-streaming/  # noqa: E501

        :return: The latency_mode of this LiveStream.  # noqa: E501
        :rtype: str
        """
        return self._latency_mode

    @latency_mode.setter
    def latency_mode(self, latency_mode):
        """Sets the latency_mode of this LiveStream.

        Latency is the time from when the streamer transmits a frame of video to when you see it in the player. Set this as an alternative to setting low latency or reduced latency flags. The Low Latency value is a beta feature. Note: Reconnect windows are incompatible with Reduced Latency and Low Latency and will always be set to zero (0) seconds. Read more here: https://mux.com/blog/introducing-low-latency-live-streaming/  # noqa: E501

        :param latency_mode: The latency_mode of this LiveStream.  # noqa: E501
        :type latency_mode: str
        """
        allowed_values = ["low", "reduced", "standard"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and latency_mode not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `latency_mode` ({0}), must be one of {1}"  # noqa: E501
                .format(latency_mode, allowed_values)
            )

        self._latency_mode = latency_mode

    @property
    def test(self):
        """Gets the test of this LiveStream.  # noqa: E501

        True means this live stream is a test live stream. Test live streams can be used to help evaluate the Mux Video APIs for free. There is no limit on the number of test live streams, but they are watermarked with the Mux logo, and limited to 5 minutes. The test live stream is disabled after the stream is active for 5 mins and the recorded asset also deleted after 24 hours.  # noqa: E501

        :return: The test of this LiveStream.  # noqa: E501
        :rtype: bool
        """
        return self._test

    @test.setter
    def test(self, test):
        """Sets the test of this LiveStream.

        True means this live stream is a test live stream. Test live streams can be used to help evaluate the Mux Video APIs for free. There is no limit on the number of test live streams, but they are watermarked with the Mux logo, and limited to 5 minutes. The test live stream is disabled after the stream is active for 5 mins and the recorded asset also deleted after 24 hours.  # noqa: E501

        :param test: The test of this LiveStream.  # noqa: E501
        :type test: bool
        """

        self._test = test

    @property
    def max_continuous_duration(self):
        """Gets the max_continuous_duration of this LiveStream.  # noqa: E501

        The time in seconds a live stream may be continuously active before being disconnected. Defaults to 12 hours.  # noqa: E501

        :return: The max_continuous_duration of this LiveStream.  # noqa: E501
        :rtype: int
        """
        return self._max_continuous_duration

    @max_continuous_duration.setter
    def max_continuous_duration(self, max_continuous_duration):
        """Sets the max_continuous_duration of this LiveStream.

        The time in seconds a live stream may be continuously active before being disconnected. Defaults to 12 hours.  # noqa: E501

        :param max_continuous_duration: The max_continuous_duration of this LiveStream.  # noqa: E501
        :type max_continuous_duration: int
        """
        if (self.local_vars_configuration.client_side_validation and
                max_continuous_duration is not None and max_continuous_duration > 43200):  # noqa: E501
            raise ValueError("Invalid value for `max_continuous_duration`, must be a value less than or equal to `43200`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                max_continuous_duration is not None and max_continuous_duration < 60):  # noqa: E501
            raise ValueError("Invalid value for `max_continuous_duration`, must be a value greater than or equal to `60`")  # noqa: E501

        self._max_continuous_duration = max_continuous_duration

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LiveStream):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LiveStream):
            return True

        return self.to_dict() != other.to_dict()
