# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class InputFile(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'container_format': 'str',
        'tracks': 'list[InputTrack]'
    }

    attribute_map = {
        'container_format': 'container_format',
        'tracks': 'tracks'
    }

    def __init__(self, container_format=None, tracks=None, local_vars_configuration=None):  # noqa: E501
        """InputFile - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._container_format = None
        self._tracks = None
        self.discriminator = None

        if container_format is not None:
            self.container_format = container_format
        if tracks is not None:
            self.tracks = tracks

    @property
    def container_format(self):
        """Gets the container_format of this InputFile.  # noqa: E501


        :return: The container_format of this InputFile.  # noqa: E501
        :rtype: str
        """
        return self._container_format

    @container_format.setter
    def container_format(self, container_format):
        """Sets the container_format of this InputFile.


        :param container_format: The container_format of this InputFile.  # noqa: E501
        :type container_format: str
        """

        self._container_format = container_format

    @property
    def tracks(self):
        """Gets the tracks of this InputFile.  # noqa: E501


        :return: The tracks of this InputFile.  # noqa: E501
        :rtype: list[InputTrack]
        """
        return self._tracks

    @tracks.setter
    def tracks(self, tracks):
        """Sets the tracks of this InputFile.


        :param tracks: The tracks of this InputFile.  # noqa: E501
        :type tracks: list[InputTrack]
        """

        self._tracks = tracks

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InputFile):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InputFile):
            return True

        return self.to_dict() != other.to_dict()
