# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class Score(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'watch_time': 'int',
        'view_count': 'int',
        'name': 'str',
        'value': 'float',
        'metric': 'str',
        'items': 'list[Metric]'
    }

    attribute_map = {
        'watch_time': 'watch_time',
        'view_count': 'view_count',
        'name': 'name',
        'value': 'value',
        'metric': 'metric',
        'items': 'items'
    }

    def __init__(self, watch_time=None, view_count=None, name=None, value=None, metric=None, items=None, local_vars_configuration=None):  # noqa: E501
        """Score - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._watch_time = None
        self._view_count = None
        self._name = None
        self._value = None
        self._metric = None
        self._items = None
        self.discriminator = None

        if watch_time is not None:
            self.watch_time = watch_time
        if view_count is not None:
            self.view_count = view_count
        if name is not None:
            self.name = name
        if value is not None:
            self.value = value
        if metric is not None:
            self.metric = metric
        if items is not None:
            self.items = items

    @property
    def watch_time(self):
        """Gets the watch_time of this Score.  # noqa: E501


        :return: The watch_time of this Score.  # noqa: E501
        :rtype: int
        """
        return self._watch_time

    @watch_time.setter
    def watch_time(self, watch_time):
        """Sets the watch_time of this Score.


        :param watch_time: The watch_time of this Score.  # noqa: E501
        :type watch_time: int
        """

        self._watch_time = watch_time

    @property
    def view_count(self):
        """Gets the view_count of this Score.  # noqa: E501


        :return: The view_count of this Score.  # noqa: E501
        :rtype: int
        """
        return self._view_count

    @view_count.setter
    def view_count(self, view_count):
        """Sets the view_count of this Score.


        :param view_count: The view_count of this Score.  # noqa: E501
        :type view_count: int
        """

        self._view_count = view_count

    @property
    def name(self):
        """Gets the name of this Score.  # noqa: E501


        :return: The name of this Score.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Score.


        :param name: The name of this Score.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def value(self):
        """Gets the value of this Score.  # noqa: E501


        :return: The value of this Score.  # noqa: E501
        :rtype: float
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this Score.


        :param value: The value of this Score.  # noqa: E501
        :type value: float
        """

        self._value = value

    @property
    def metric(self):
        """Gets the metric of this Score.  # noqa: E501


        :return: The metric of this Score.  # noqa: E501
        :rtype: str
        """
        return self._metric

    @metric.setter
    def metric(self, metric):
        """Sets the metric of this Score.


        :param metric: The metric of this Score.  # noqa: E501
        :type metric: str
        """

        self._metric = metric

    @property
    def items(self):
        """Gets the items of this Score.  # noqa: E501


        :return: The items of this Score.  # noqa: E501
        :rtype: list[Metric]
        """
        return self._items

    @items.setter
    def items(self, items):
        """Sets the items of this Score.


        :param items: The items of this Score.  # noqa: E501
        :type items: list[Metric]
        """

        self._items = items

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Score):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Score):
            return True

        return self.to_dict() != other.to_dict()
