# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class Space(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'created_at': 'str',
        'type': 'SpaceType',
        'status': 'SpaceStatus',
        'passthrough': 'str',
        'broadcasts': 'list[Broadcast]',
        'active_session_id': 'str'
    }

    attribute_map = {
        'id': 'id',
        'created_at': 'created_at',
        'type': 'type',
        'status': 'status',
        'passthrough': 'passthrough',
        'broadcasts': 'broadcasts',
        'active_session_id': 'active_session_id'
    }

    def __init__(self, id=None, created_at=None, type=None, status=None, passthrough=None, broadcasts=None, active_session_id=None, local_vars_configuration=None):  # noqa: E501
        """Space - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._created_at = None
        self._type = None
        self._status = None
        self._passthrough = None
        self._broadcasts = None
        self._active_session_id = None
        self.discriminator = None

        self.id = id
        self.created_at = created_at
        self.type = type
        self.status = status
        if passthrough is not None:
            self.passthrough = passthrough
        if broadcasts is not None:
            self.broadcasts = broadcasts
        if active_session_id is not None:
            self.active_session_id = active_session_id

    @property
    def id(self):
        """Gets the id of this Space.  # noqa: E501

        Unique identifier for the space. Max 255 characters.  # noqa: E501

        :return: The id of this Space.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Space.

        Unique identifier for the space. Max 255 characters.  # noqa: E501

        :param id: The id of this Space.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def created_at(self):
        """Gets the created_at of this Space.  # noqa: E501

        Time the space was created, defined as a Unix timestamp (seconds since epoch).  # noqa: E501

        :return: The created_at of this Space.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Space.

        Time the space was created, defined as a Unix timestamp (seconds since epoch).  # noqa: E501

        :param created_at: The created_at of this Space.  # noqa: E501
        :type created_at: str
        """
        if self.local_vars_configuration.client_side_validation and created_at is None:  # noqa: E501
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def type(self):
        """Gets the type of this Space.  # noqa: E501


        :return: The type of this Space.  # noqa: E501
        :rtype: SpaceType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Space.


        :param type: The type of this Space.  # noqa: E501
        :type type: SpaceType
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def status(self):
        """Gets the status of this Space.  # noqa: E501


        :return: The status of this Space.  # noqa: E501
        :rtype: SpaceStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Space.


        :param status: The status of this Space.  # noqa: E501
        :type status: SpaceStatus
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def passthrough(self):
        """Gets the passthrough of this Space.  # noqa: E501

        Arbitrary user-supplied metadata that will be included in the space details and related webhooks. Max: 255 characters.  # noqa: E501

        :return: The passthrough of this Space.  # noqa: E501
        :rtype: str
        """
        return self._passthrough

    @passthrough.setter
    def passthrough(self, passthrough):
        """Sets the passthrough of this Space.

        Arbitrary user-supplied metadata that will be included in the space details and related webhooks. Max: 255 characters.  # noqa: E501

        :param passthrough: The passthrough of this Space.  # noqa: E501
        :type passthrough: str
        """

        self._passthrough = passthrough

    @property
    def broadcasts(self):
        """Gets the broadcasts of this Space.  # noqa: E501

        An array of broadcast destinations.  # noqa: E501

        :return: The broadcasts of this Space.  # noqa: E501
        :rtype: list[Broadcast]
        """
        return self._broadcasts

    @broadcasts.setter
    def broadcasts(self, broadcasts):
        """Sets the broadcasts of this Space.

        An array of broadcast destinations.  # noqa: E501

        :param broadcasts: The broadcasts of this Space.  # noqa: E501
        :type broadcasts: list[Broadcast]
        """

        self._broadcasts = broadcasts

    @property
    def active_session_id(self):
        """Gets the active_session_id of this Space.  # noqa: E501

        Unique identifier for the current lifecycle of the space. Only set when the space is `active` and is set to a new value each time the space transitions from `idle` to `active`. This value is useful for logging and debugging issues. Max 255 characters.  # noqa: E501

        :return: The active_session_id of this Space.  # noqa: E501
        :rtype: str
        """
        return self._active_session_id

    @active_session_id.setter
    def active_session_id(self, active_session_id):
        """Sets the active_session_id of this Space.

        Unique identifier for the current lifecycle of the space. Only set when the space is `active` and is set to a new value each time the space transitions from `idle` to `active`. This value is useful for logging and debugging issues. Max 255 characters.  # noqa: E501

        :param active_session_id: The active_session_id of this Space.  # noqa: E501
        :type active_session_id: str
        """

        self._active_session_id = active_session_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Space):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Space):
            return True

        return self.to_dict() != other.to_dict()
