# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class DeliveryReportDeliveredSecondsByResolution(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'tier_1080p': 'float',
        'tier_720p': 'float',
        'tier_audio_only': 'float'
    }

    attribute_map = {
        'tier_1080p': 'tier_1080p',
        'tier_720p': 'tier_720p',
        'tier_audio_only': 'tier_audio_only'
    }

    def __init__(self, tier_1080p=None, tier_720p=None, tier_audio_only=None, local_vars_configuration=None):  # noqa: E501
        """DeliveryReportDeliveredSecondsByResolution - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._tier_1080p = None
        self._tier_720p = None
        self._tier_audio_only = None
        self.discriminator = None

        if tier_1080p is not None:
            self.tier_1080p = tier_1080p
        if tier_720p is not None:
            self.tier_720p = tier_720p
        if tier_audio_only is not None:
            self.tier_audio_only = tier_audio_only

    @property
    def tier_1080p(self):
        """Gets the tier_1080p of this DeliveryReportDeliveredSecondsByResolution.  # noqa: E501

        Total number of delivered seconds during this time window that had a resolution larger than the 720p tier (over 921,600 pixels total).  # noqa: E501

        :return: The tier_1080p of this DeliveryReportDeliveredSecondsByResolution.  # noqa: E501
        :rtype: float
        """
        return self._tier_1080p

    @tier_1080p.setter
    def tier_1080p(self, tier_1080p):
        """Sets the tier_1080p of this DeliveryReportDeliveredSecondsByResolution.

        Total number of delivered seconds during this time window that had a resolution larger than the 720p tier (over 921,600 pixels total).  # noqa: E501

        :param tier_1080p: The tier_1080p of this DeliveryReportDeliveredSecondsByResolution.  # noqa: E501
        :type tier_1080p: float
        """

        self._tier_1080p = tier_1080p

    @property
    def tier_720p(self):
        """Gets the tier_720p of this DeliveryReportDeliveredSecondsByResolution.  # noqa: E501

        Total number of delivered seconds during this time window that had a resolution within the 720p tier (up to 921,600 pixels total, based on typical 1280x720).  # noqa: E501

        :return: The tier_720p of this DeliveryReportDeliveredSecondsByResolution.  # noqa: E501
        :rtype: float
        """
        return self._tier_720p

    @tier_720p.setter
    def tier_720p(self, tier_720p):
        """Sets the tier_720p of this DeliveryReportDeliveredSecondsByResolution.

        Total number of delivered seconds during this time window that had a resolution within the 720p tier (up to 921,600 pixels total, based on typical 1280x720).  # noqa: E501

        :param tier_720p: The tier_720p of this DeliveryReportDeliveredSecondsByResolution.  # noqa: E501
        :type tier_720p: float
        """

        self._tier_720p = tier_720p

    @property
    def tier_audio_only(self):
        """Gets the tier_audio_only of this DeliveryReportDeliveredSecondsByResolution.  # noqa: E501

        Total number of delivered seconds during this time window that had a resolution of audio only.  # noqa: E501

        :return: The tier_audio_only of this DeliveryReportDeliveredSecondsByResolution.  # noqa: E501
        :rtype: float
        """
        return self._tier_audio_only

    @tier_audio_only.setter
    def tier_audio_only(self, tier_audio_only):
        """Sets the tier_audio_only of this DeliveryReportDeliveredSecondsByResolution.

        Total number of delivered seconds during this time window that had a resolution of audio only.  # noqa: E501

        :param tier_audio_only: The tier_audio_only of this DeliveryReportDeliveredSecondsByResolution.  # noqa: E501
        :type tier_audio_only: float
        """

        self._tier_audio_only = tier_audio_only

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeliveryReportDeliveredSecondsByResolution):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DeliveryReportDeliveredSecondsByResolution):
            return True

        return self.to_dict() != other.to_dict()
