# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mux_python.api_client import ApiClient
from mux_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class WebInputsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_web_input(self, create_web_input_request, **kwargs):  # noqa: E501
        """Create a new Web Input  # noqa: E501

        Create a new Web Input  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_web_input(create_web_input_request, async_req=True)
        >>> result = thread.get()

        :param create_web_input_request: (required)
        :type create_web_input_request: CreateWebInputRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebInputResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_web_input_with_http_info(create_web_input_request, **kwargs)  # noqa: E501

    def create_web_input_with_http_info(self, create_web_input_request, **kwargs):  # noqa: E501
        """Create a new Web Input  # noqa: E501

        Create a new Web Input  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_web_input_with_http_info(create_web_input_request, async_req=True)
        >>> result = thread.get()

        :param create_web_input_request: (required)
        :type create_web_input_request: CreateWebInputRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebInputResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'create_web_input_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_web_input" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_web_input_request' is set
        if self.api_client.client_side_validation and ('create_web_input_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_web_input_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_web_input_request` when calling `create_web_input`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_web_input_request' in local_var_params:
            body_params = local_var_params['create_web_input_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            201: "WebInputResponse",
        }

        return self.api_client.call_api(
            '/video/v1/web-inputs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_web_input(self, web_input_id, **kwargs):  # noqa: E501
        """Delete a Web Input  # noqa: E501

        Deletes a Web Input and all its data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_web_input(web_input_id, async_req=True)
        >>> result = thread.get()

        :param web_input_id: The Web Input ID (required)
        :type web_input_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_web_input_with_http_info(web_input_id, **kwargs)  # noqa: E501

    def delete_web_input_with_http_info(self, web_input_id, **kwargs):  # noqa: E501
        """Delete a Web Input  # noqa: E501

        Deletes a Web Input and all its data  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_web_input_with_http_info(web_input_id, async_req=True)
        >>> result = thread.get()

        :param web_input_id: The Web Input ID (required)
        :type web_input_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'web_input_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_web_input" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'web_input_id' is set
        if self.api_client.client_side_validation and ('web_input_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['web_input_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `web_input_id` when calling `delete_web_input`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'web_input_id' in local_var_params:
            path_params['WEB_INPUT_ID'] = local_var_params['web_input_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {}

        return self.api_client.call_api(
            '/video/v1/web-inputs/{WEB_INPUT_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_web_input(self, web_input_id, **kwargs):  # noqa: E501
        """Retrieve a Web Input  # noqa: E501

        Retrieve a single Web Input's info  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_web_input(web_input_id, async_req=True)
        >>> result = thread.get()

        :param web_input_id: The Web Input ID (required)
        :type web_input_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebInputResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_web_input_with_http_info(web_input_id, **kwargs)  # noqa: E501

    def get_web_input_with_http_info(self, web_input_id, **kwargs):  # noqa: E501
        """Retrieve a Web Input  # noqa: E501

        Retrieve a single Web Input's info  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_web_input_with_http_info(web_input_id, async_req=True)
        >>> result = thread.get()

        :param web_input_id: The Web Input ID (required)
        :type web_input_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebInputResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'web_input_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_web_input" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'web_input_id' is set
        if self.api_client.client_side_validation and ('web_input_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['web_input_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `web_input_id` when calling `get_web_input`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'web_input_id' in local_var_params:
            path_params['WEB_INPUT_ID'] = local_var_params['web_input_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "WebInputResponse",
        }

        return self.api_client.call_api(
            '/video/v1/web-inputs/{WEB_INPUT_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def launch_web_input(self, web_input_id, **kwargs):  # noqa: E501
        """Launch a Web Input  # noqa: E501

        Launches the browsers instance, loads the URL specified, and then starts streaming to the specified Live Stream.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.launch_web_input(web_input_id, async_req=True)
        >>> result = thread.get()

        :param web_input_id: The Web Input ID (required)
        :type web_input_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LaunchWebInputResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.launch_web_input_with_http_info(web_input_id, **kwargs)  # noqa: E501

    def launch_web_input_with_http_info(self, web_input_id, **kwargs):  # noqa: E501
        """Launch a Web Input  # noqa: E501

        Launches the browsers instance, loads the URL specified, and then starts streaming to the specified Live Stream.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.launch_web_input_with_http_info(web_input_id, async_req=True)
        >>> result = thread.get()

        :param web_input_id: The Web Input ID (required)
        :type web_input_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LaunchWebInputResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'web_input_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method launch_web_input" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'web_input_id' is set
        if self.api_client.client_side_validation and ('web_input_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['web_input_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `web_input_id` when calling `launch_web_input`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'web_input_id' in local_var_params:
            path_params['WEB_INPUT_ID'] = local_var_params['web_input_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "LaunchWebInputResponse",
        }

        return self.api_client.call_api(
            '/video/v1/web-inputs/{WEB_INPUT_ID}/launch', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_web_inputs(self, **kwargs):  # noqa: E501
        """List Web Inputs  # noqa: E501

        List Web Inputs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_web_inputs(async_req=True)
        >>> result = thread.get()

        :param limit: Number of items to include in the response
        :type limit: int
        :param page: Offset by this many pages, of the size of `limit`
        :type page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListWebInputsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.list_web_inputs_with_http_info(**kwargs)  # noqa: E501

    def list_web_inputs_with_http_info(self, **kwargs):  # noqa: E501
        """List Web Inputs  # noqa: E501

        List Web Inputs  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_web_inputs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param limit: Number of items to include in the response
        :type limit: int
        :param page: Offset by this many pages, of the size of `limit`
        :type page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListWebInputsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_web_inputs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "ListWebInputsResponse",
        }

        return self.api_client.call_api(
            '/video/v1/web-inputs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def reload_web_input(self, web_input_id, **kwargs):  # noqa: E501
        """Reload a Web Input  # noqa: E501

        Reloads the page that a Web Input is displaying.  Note: Using this when the Web Input is streaming will display the page reloading.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reload_web_input(web_input_id, async_req=True)
        >>> result = thread.get()

        :param web_input_id: The Web Input ID (required)
        :type web_input_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ReloadWebInputResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.reload_web_input_with_http_info(web_input_id, **kwargs)  # noqa: E501

    def reload_web_input_with_http_info(self, web_input_id, **kwargs):  # noqa: E501
        """Reload a Web Input  # noqa: E501

        Reloads the page that a Web Input is displaying.  Note: Using this when the Web Input is streaming will display the page reloading.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reload_web_input_with_http_info(web_input_id, async_req=True)
        >>> result = thread.get()

        :param web_input_id: The Web Input ID (required)
        :type web_input_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ReloadWebInputResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'web_input_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reload_web_input" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'web_input_id' is set
        if self.api_client.client_side_validation and ('web_input_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['web_input_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `web_input_id` when calling `reload_web_input`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'web_input_id' in local_var_params:
            path_params['WEB_INPUT_ID'] = local_var_params['web_input_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "ReloadWebInputResponse",
        }

        return self.api_client.call_api(
            '/video/v1/web-inputs/{WEB_INPUT_ID}/reload', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def shutdown_web_input(self, web_input_id, **kwargs):  # noqa: E501
        """Shut down a Web Input  # noqa: E501

        Ends streaming to the specified Live Stream, and then shuts down the Web Input browser instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shutdown_web_input(web_input_id, async_req=True)
        >>> result = thread.get()

        :param web_input_id: The Web Input ID (required)
        :type web_input_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ShutdownWebInputResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.shutdown_web_input_with_http_info(web_input_id, **kwargs)  # noqa: E501

    def shutdown_web_input_with_http_info(self, web_input_id, **kwargs):  # noqa: E501
        """Shut down a Web Input  # noqa: E501

        Ends streaming to the specified Live Stream, and then shuts down the Web Input browser instance.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.shutdown_web_input_with_http_info(web_input_id, async_req=True)
        >>> result = thread.get()

        :param web_input_id: The Web Input ID (required)
        :type web_input_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ShutdownWebInputResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'web_input_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method shutdown_web_input" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'web_input_id' is set
        if self.api_client.client_side_validation and ('web_input_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['web_input_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `web_input_id` when calling `shutdown_web_input`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'web_input_id' in local_var_params:
            path_params['WEB_INPUT_ID'] = local_var_params['web_input_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "ShutdownWebInputResponse",
        }

        return self.api_client.call_api(
            '/video/v1/web-inputs/{WEB_INPUT_ID}/shutdown', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_web_input_url(self, web_input_id, update_web_input_url_request, **kwargs):  # noqa: E501
        """Update Web Input URL  # noqa: E501

        Changes the URL that a Web Input loads when it launches.  Note: This can only be called when the Web Input is idle.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_web_input_url(web_input_id, update_web_input_url_request, async_req=True)
        >>> result = thread.get()

        :param web_input_id: The Web Input ID (required)
        :type web_input_id: str
        :param update_web_input_url_request: (required)
        :type update_web_input_url_request: UpdateWebInputUrlRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebInputResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_web_input_url_with_http_info(web_input_id, update_web_input_url_request, **kwargs)  # noqa: E501

    def update_web_input_url_with_http_info(self, web_input_id, update_web_input_url_request, **kwargs):  # noqa: E501
        """Update Web Input URL  # noqa: E501

        Changes the URL that a Web Input loads when it launches.  Note: This can only be called when the Web Input is idle.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_web_input_url_with_http_info(web_input_id, update_web_input_url_request, async_req=True)
        >>> result = thread.get()

        :param web_input_id: The Web Input ID (required)
        :type web_input_id: str
        :param update_web_input_url_request: (required)
        :type update_web_input_url_request: UpdateWebInputUrlRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebInputResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'web_input_id',
            'update_web_input_url_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_web_input_url" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'web_input_id' is set
        if self.api_client.client_side_validation and ('web_input_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['web_input_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `web_input_id` when calling `update_web_input_url`")  # noqa: E501
        # verify the required parameter 'update_web_input_url_request' is set
        if self.api_client.client_side_validation and ('update_web_input_url_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_web_input_url_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_web_input_url_request` when calling `update_web_input_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'web_input_id' in local_var_params:
            path_params['WEB_INPUT_ID'] = local_var_params['web_input_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_web_input_url_request' in local_var_params:
            body_params = local_var_params['update_web_input_url_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "WebInputResponse",
        }

        return self.api_client.call_api(
            '/video/v1/web-inputs/{WEB_INPUT_ID}/url', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
