# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class AssetMetadata(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'title': 'str',
        'creator_id': 'str',
        'external_id': 'str'
    }

    attribute_map = {
        'title': 'title',
        'creator_id': 'creator_id',
        'external_id': 'external_id'
    }

    def __init__(self, title=None, creator_id=None, external_id=None, local_vars_configuration=None):  # noqa: E501
        """AssetMetadata - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._title = None
        self._creator_id = None
        self._external_id = None
        self.discriminator = None

        if title is not None:
            self.title = title
        if creator_id is not None:
            self.creator_id = creator_id
        if external_id is not None:
            self.external_id = external_id

    @property
    def title(self):
        """Gets the title of this AssetMetadata.  # noqa: E501

        The video title. Max 512 code points.  # noqa: E501

        :return: The title of this AssetMetadata.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this AssetMetadata.

        The video title. Max 512 code points.  # noqa: E501

        :param title: The title of this AssetMetadata.  # noqa: E501
        :type title: str
        """
        if (self.local_vars_configuration.client_side_validation and
                title is not None and len(title) > 512):
            raise ValueError("Invalid value for `title`, length must be less than or equal to `512`")  # noqa: E501

        self._title = title

    @property
    def creator_id(self):
        """Gets the creator_id of this AssetMetadata.  # noqa: E501

        This is an identifier you provide to keep track of the creator of the video. Max 128 code points.  # noqa: E501

        :return: The creator_id of this AssetMetadata.  # noqa: E501
        :rtype: str
        """
        return self._creator_id

    @creator_id.setter
    def creator_id(self, creator_id):
        """Sets the creator_id of this AssetMetadata.

        This is an identifier you provide to keep track of the creator of the video. Max 128 code points.  # noqa: E501

        :param creator_id: The creator_id of this AssetMetadata.  # noqa: E501
        :type creator_id: str
        """
        if (self.local_vars_configuration.client_side_validation and
                creator_id is not None and len(creator_id) > 128):
            raise ValueError("Invalid value for `creator_id`, length must be less than or equal to `128`")  # noqa: E501

        self._creator_id = creator_id

    @property
    def external_id(self):
        """Gets the external_id of this AssetMetadata.  # noqa: E501

        This is an identifier you provide to link the video to your own data. Max 128 code points.  # noqa: E501

        :return: The external_id of this AssetMetadata.  # noqa: E501
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id):
        """Sets the external_id of this AssetMetadata.

        This is an identifier you provide to link the video to your own data. Max 128 code points.  # noqa: E501

        :param external_id: The external_id of this AssetMetadata.  # noqa: E501
        :type external_id: str
        """
        if (self.local_vars_configuration.client_side_validation and
                external_id is not None and len(external_id) > 128):
            raise ValueError("Invalid value for `external_id`, length must be less than or equal to `128`")  # noqa: E501

        self._external_id = external_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AssetMetadata):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AssetMetadata):
            return True

        return self.to_dict() != other.to_dict()
