# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class SimulcastTarget(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'passthrough': 'str',
        'status': 'str',
        'stream_key': 'str',
        'url': 'str',
        'error_severity': 'str'
    }

    attribute_map = {
        'id': 'id',
        'passthrough': 'passthrough',
        'status': 'status',
        'stream_key': 'stream_key',
        'url': 'url',
        'error_severity': 'error_severity'
    }

    def __init__(self, id=None, passthrough=None, status=None, stream_key=None, url=None, error_severity=None, local_vars_configuration=None):  # noqa: E501
        """SimulcastTarget - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._passthrough = None
        self._status = None
        self._stream_key = None
        self._url = None
        self._error_severity = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if passthrough is not None:
            self.passthrough = passthrough
        if status is not None:
            self.status = status
        if stream_key is not None:
            self.stream_key = stream_key
        if url is not None:
            self.url = url
        if error_severity is not None:
            self.error_severity = error_severity

    @property
    def id(self):
        """Gets the id of this SimulcastTarget.  # noqa: E501

        ID of the Simulcast Target  # noqa: E501

        :return: The id of this SimulcastTarget.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SimulcastTarget.

        ID of the Simulcast Target  # noqa: E501

        :param id: The id of this SimulcastTarget.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def passthrough(self):
        """Gets the passthrough of this SimulcastTarget.  # noqa: E501

        Arbitrary user-supplied metadata set when creating a simulcast target.  # noqa: E501

        :return: The passthrough of this SimulcastTarget.  # noqa: E501
        :rtype: str
        """
        return self._passthrough

    @passthrough.setter
    def passthrough(self, passthrough):
        """Sets the passthrough of this SimulcastTarget.

        Arbitrary user-supplied metadata set when creating a simulcast target.  # noqa: E501

        :param passthrough: The passthrough of this SimulcastTarget.  # noqa: E501
        :type passthrough: str
        """

        self._passthrough = passthrough

    @property
    def status(self):
        """Gets the status of this SimulcastTarget.  # noqa: E501

        The current status of the simulcast target. See Statuses below for detailed description.   * `idle`: Default status. When the parent live stream is in disconnected status, simulcast targets will be idle state.   * `starting`: The simulcast target transitions into this state when the parent live stream transition into connected state.   * `broadcasting`: The simulcast target has successfully connected to the third party live streaming service and is pushing video to that service.   * `errored`: The simulcast target encountered an error either while attempting to connect to the third party live streaming service, or mid-broadcasting. When a simulcast target has this status it will have an `error_severity` field with more details about the error.   # noqa: E501

        :return: The status of this SimulcastTarget.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this SimulcastTarget.

        The current status of the simulcast target. See Statuses below for detailed description.   * `idle`: Default status. When the parent live stream is in disconnected status, simulcast targets will be idle state.   * `starting`: The simulcast target transitions into this state when the parent live stream transition into connected state.   * `broadcasting`: The simulcast target has successfully connected to the third party live streaming service and is pushing video to that service.   * `errored`: The simulcast target encountered an error either while attempting to connect to the third party live streaming service, or mid-broadcasting. When a simulcast target has this status it will have an `error_severity` field with more details about the error.   # noqa: E501

        :param status: The status of this SimulcastTarget.  # noqa: E501
        :type status: str
        """
        allowed_values = ["idle", "starting", "broadcasting", "errored"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def stream_key(self):
        """Gets the stream_key of this SimulcastTarget.  # noqa: E501

        Stream Key represents a stream identifier on the third party live streaming service to send the parent live stream to. Only used for RTMP(s) simulcast destinations.  # noqa: E501

        :return: The stream_key of this SimulcastTarget.  # noqa: E501
        :rtype: str
        """
        return self._stream_key

    @stream_key.setter
    def stream_key(self, stream_key):
        """Sets the stream_key of this SimulcastTarget.

        Stream Key represents a stream identifier on the third party live streaming service to send the parent live stream to. Only used for RTMP(s) simulcast destinations.  # noqa: E501

        :param stream_key: The stream_key of this SimulcastTarget.  # noqa: E501
        :type stream_key: str
        """

        self._stream_key = stream_key

    @property
    def url(self):
        """Gets the url of this SimulcastTarget.  # noqa: E501

        The RTMP(s) or SRT endpoint for a simulcast destination. * For RTMP(s) destinations, this should include the application name for the third party live streaming service, for example: `rtmp://live.example.com/app`. * For SRT destinations, this should be a fully formed SRT connection string, for example: `srt://srt-live.example.com:1234?streamid={stream_key}&passphrase={srt_passphrase}`.  Note: SRT simulcast targets can only be used when an source is connected over SRT.   # noqa: E501

        :return: The url of this SimulcastTarget.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this SimulcastTarget.

        The RTMP(s) or SRT endpoint for a simulcast destination. * For RTMP(s) destinations, this should include the application name for the third party live streaming service, for example: `rtmp://live.example.com/app`. * For SRT destinations, this should be a fully formed SRT connection string, for example: `srt://srt-live.example.com:1234?streamid={stream_key}&passphrase={srt_passphrase}`.  Note: SRT simulcast targets can only be used when an source is connected over SRT.   # noqa: E501

        :param url: The url of this SimulcastTarget.  # noqa: E501
        :type url: str
        """

        self._url = url

    @property
    def error_severity(self):
        """Gets the error_severity of this SimulcastTarget.  # noqa: E501

        The severity of the error encountered by the simulcast target. This field is only set when the simulcast target is in the `errored` status. See the values of severities below and their descriptions.   * `normal`: The simulcast target encountered an error either while attempting to connect to the third party live streaming service, or mid-broadcasting. A simulcast may transition back into the broadcasting state if a connection with the service can be re-established.   * `fatal`: The simulcast target is incompatible with the current input to the parent live stream. No further attempts to this simulcast target will be made for the current live stream asset.   # noqa: E501

        :return: The error_severity of this SimulcastTarget.  # noqa: E501
        :rtype: str
        """
        return self._error_severity

    @error_severity.setter
    def error_severity(self, error_severity):
        """Sets the error_severity of this SimulcastTarget.

        The severity of the error encountered by the simulcast target. This field is only set when the simulcast target is in the `errored` status. See the values of severities below and their descriptions.   * `normal`: The simulcast target encountered an error either while attempting to connect to the third party live streaming service, or mid-broadcasting. A simulcast may transition back into the broadcasting state if a connection with the service can be re-established.   * `fatal`: The simulcast target is incompatible with the current input to the parent live stream. No further attempts to this simulcast target will be made for the current live stream asset.   # noqa: E501

        :param error_severity: The error_severity of this SimulcastTarget.  # noqa: E501
        :type error_severity: str
        """
        allowed_values = ["normal", "fatal"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and error_severity not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `error_severity` ({0}), must be one of {1}"  # noqa: E501
                .format(error_severity, allowed_values)
            )

        self._error_severity = error_severity

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SimulcastTarget):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SimulcastTarget):
            return True

        return self.to_dict() != other.to_dict()
