# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class StaticRendition(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'ext': 'str',
        'height': 'int',
        'width': 'int',
        'bitrate': 'int',
        'filesize': 'str',
        'type': 'str',
        'status': 'str',
        'resolution_tier': 'str',
        'resolution': 'str',
        'id': 'str',
        'passthrough': 'str'
    }

    attribute_map = {
        'name': 'name',
        'ext': 'ext',
        'height': 'height',
        'width': 'width',
        'bitrate': 'bitrate',
        'filesize': 'filesize',
        'type': 'type',
        'status': 'status',
        'resolution_tier': 'resolution_tier',
        'resolution': 'resolution',
        'id': 'id',
        'passthrough': 'passthrough'
    }

    def __init__(self, name=None, ext=None, height=None, width=None, bitrate=None, filesize=None, type=None, status=None, resolution_tier=None, resolution=None, id=None, passthrough=None, local_vars_configuration=None):  # noqa: E501
        """StaticRendition - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._ext = None
        self._height = None
        self._width = None
        self._bitrate = None
        self._filesize = None
        self._type = None
        self._status = None
        self._resolution_tier = None
        self._resolution = None
        self._id = None
        self._passthrough = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if ext is not None:
            self.ext = ext
        if height is not None:
            self.height = height
        if width is not None:
            self.width = width
        if bitrate is not None:
            self.bitrate = bitrate
        if filesize is not None:
            self.filesize = filesize
        if type is not None:
            self.type = type
        if status is not None:
            self.status = status
        if resolution_tier is not None:
            self.resolution_tier = resolution_tier
        if resolution is not None:
            self.resolution = resolution
        if id is not None:
            self.id = id
        if passthrough is not None:
            self.passthrough = passthrough

    @property
    def name(self):
        """Gets the name of this StaticRendition.  # noqa: E501

        Name of the static rendition file  # noqa: E501

        :return: The name of this StaticRendition.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this StaticRendition.

        Name of the static rendition file  # noqa: E501

        :param name: The name of this StaticRendition.  # noqa: E501
        :type name: str
        """
        allowed_values = ["low.mp4", "medium.mp4", "high.mp4", "highest.mp4", "audio.m4a", "capped-1080p.mp4", "2160p.mp4", "1440p.mp4", "1080p.mp4", "720p.mp4", "540p.mp4", "480p.mp4", "360p.mp4", "270p.mp4"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and name not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `name` ({0}), must be one of {1}"  # noqa: E501
                .format(name, allowed_values)
            )

        self._name = name

    @property
    def ext(self):
        """Gets the ext of this StaticRendition.  # noqa: E501

        Extension of the static rendition file  # noqa: E501

        :return: The ext of this StaticRendition.  # noqa: E501
        :rtype: str
        """
        return self._ext

    @ext.setter
    def ext(self, ext):
        """Sets the ext of this StaticRendition.

        Extension of the static rendition file  # noqa: E501

        :param ext: The ext of this StaticRendition.  # noqa: E501
        :type ext: str
        """
        allowed_values = ["mp4", "m4a"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and ext not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `ext` ({0}), must be one of {1}"  # noqa: E501
                .format(ext, allowed_values)
            )

        self._ext = ext

    @property
    def height(self):
        """Gets the height of this StaticRendition.  # noqa: E501

        The height of the static rendition's file in pixels  # noqa: E501

        :return: The height of this StaticRendition.  # noqa: E501
        :rtype: int
        """
        return self._height

    @height.setter
    def height(self, height):
        """Sets the height of this StaticRendition.

        The height of the static rendition's file in pixels  # noqa: E501

        :param height: The height of this StaticRendition.  # noqa: E501
        :type height: int
        """

        self._height = height

    @property
    def width(self):
        """Gets the width of this StaticRendition.  # noqa: E501

        The width of the static rendition's file in pixels  # noqa: E501

        :return: The width of this StaticRendition.  # noqa: E501
        :rtype: int
        """
        return self._width

    @width.setter
    def width(self, width):
        """Sets the width of this StaticRendition.

        The width of the static rendition's file in pixels  # noqa: E501

        :param width: The width of this StaticRendition.  # noqa: E501
        :type width: int
        """

        self._width = width

    @property
    def bitrate(self):
        """Gets the bitrate of this StaticRendition.  # noqa: E501

        The bitrate in bits per second  # noqa: E501

        :return: The bitrate of this StaticRendition.  # noqa: E501
        :rtype: int
        """
        return self._bitrate

    @bitrate.setter
    def bitrate(self, bitrate):
        """Sets the bitrate of this StaticRendition.

        The bitrate in bits per second  # noqa: E501

        :param bitrate: The bitrate of this StaticRendition.  # noqa: E501
        :type bitrate: int
        """

        self._bitrate = bitrate

    @property
    def filesize(self):
        """Gets the filesize of this StaticRendition.  # noqa: E501

        The file size in bytes  # noqa: E501

        :return: The filesize of this StaticRendition.  # noqa: E501
        :rtype: str
        """
        return self._filesize

    @filesize.setter
    def filesize(self, filesize):
        """Sets the filesize of this StaticRendition.

        The file size in bytes  # noqa: E501

        :param filesize: The filesize of this StaticRendition.  # noqa: E501
        :type filesize: str
        """

        self._filesize = filesize

    @property
    def type(self):
        """Gets the type of this StaticRendition.  # noqa: E501

        Indicates the static rendition type of this specific MP4 version of this asset. This field is only valid for `static_renditions`, not for `mp4_support`.  # noqa: E501

        :return: The type of this StaticRendition.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this StaticRendition.

        Indicates the static rendition type of this specific MP4 version of this asset. This field is only valid for `static_renditions`, not for `mp4_support`.  # noqa: E501

        :param type: The type of this StaticRendition.  # noqa: E501
        :type type: str
        """
        allowed_values = ["standard", "advanced"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def status(self):
        """Gets the status of this StaticRendition.  # noqa: E501

        Indicates the status of this specific MP4 version of this asset. This field is only valid for `static_renditions`, not for `mp4_support`. * `ready` indicates the MP4 has been generated and is ready for download * `preparing` indicates the asset has not been ingested or the static rendition is still being generated after an asset is ready * `skipped` indicates the static rendition will not be generated because the requested resolution conflicts with the asset attributes after the asset has been ingested * `errored` indicates the static rendition cannot be generated. For example, an asset could not be ingested   # noqa: E501

        :return: The status of this StaticRendition.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this StaticRendition.

        Indicates the status of this specific MP4 version of this asset. This field is only valid for `static_renditions`, not for `mp4_support`. * `ready` indicates the MP4 has been generated and is ready for download * `preparing` indicates the asset has not been ingested or the static rendition is still being generated after an asset is ready * `skipped` indicates the static rendition will not be generated because the requested resolution conflicts with the asset attributes after the asset has been ingested * `errored` indicates the static rendition cannot be generated. For example, an asset could not be ingested   # noqa: E501

        :param status: The status of this StaticRendition.  # noqa: E501
        :type status: str
        """
        allowed_values = ["ready", "preparing", "skipped", "errored"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def resolution_tier(self):
        """Gets the resolution_tier of this StaticRendition.  # noqa: E501

        Indicates the resolution tier of this specific MP4 version of this asset. This field is only valid for `static_renditions`, not for `mp4_support`.  # noqa: E501

        :return: The resolution_tier of this StaticRendition.  # noqa: E501
        :rtype: str
        """
        return self._resolution_tier

    @resolution_tier.setter
    def resolution_tier(self, resolution_tier):
        """Sets the resolution_tier of this StaticRendition.

        Indicates the resolution tier of this specific MP4 version of this asset. This field is only valid for `static_renditions`, not for `mp4_support`.  # noqa: E501

        :param resolution_tier: The resolution_tier of this StaticRendition.  # noqa: E501
        :type resolution_tier: str
        """
        allowed_values = ["2160p", "1440p", "1080p", "720p", "audio-only"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and resolution_tier not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `resolution_tier` ({0}), must be one of {1}"  # noqa: E501
                .format(resolution_tier, allowed_values)
            )

        self._resolution_tier = resolution_tier

    @property
    def resolution(self):
        """Gets the resolution of this StaticRendition.  # noqa: E501

        Indicates the resolution of this specific MP4 version of this asset. This field is only valid for `static_renditions`, not for `mp4_support`.  # noqa: E501

        :return: The resolution of this StaticRendition.  # noqa: E501
        :rtype: str
        """
        return self._resolution

    @resolution.setter
    def resolution(self, resolution):
        """Sets the resolution of this StaticRendition.

        Indicates the resolution of this specific MP4 version of this asset. This field is only valid for `static_renditions`, not for `mp4_support`.  # noqa: E501

        :param resolution: The resolution of this StaticRendition.  # noqa: E501
        :type resolution: str
        """
        allowed_values = ["highest", "audio-only", "2160p", "1440p", "1080p", "720p", "540p", "480p", "360p", "270p"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and resolution not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `resolution` ({0}), must be one of {1}"  # noqa: E501
                .format(resolution, allowed_values)
            )

        self._resolution = resolution

    @property
    def id(self):
        """Gets the id of this StaticRendition.  # noqa: E501

        The ID of this static rendition, used in managing this static rendition. This field is only valid for `static_renditions`, not for `mp4_support`.  # noqa: E501

        :return: The id of this StaticRendition.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this StaticRendition.

        The ID of this static rendition, used in managing this static rendition. This field is only valid for `static_renditions`, not for `mp4_support`.  # noqa: E501

        :param id: The id of this StaticRendition.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def passthrough(self):
        """Gets the passthrough of this StaticRendition.  # noqa: E501

        Arbitrary user-supplied metadata set for the static rendition. Max 255 characters.  # noqa: E501

        :return: The passthrough of this StaticRendition.  # noqa: E501
        :rtype: str
        """
        return self._passthrough

    @passthrough.setter
    def passthrough(self, passthrough):
        """Sets the passthrough of this StaticRendition.

        Arbitrary user-supplied metadata set for the static rendition. Max 255 characters.  # noqa: E501

        :param passthrough: The passthrough of this StaticRendition.  # noqa: E501
        :type passthrough: str
        """

        self._passthrough = passthrough

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StaticRendition):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StaticRendition):
            return True

        return self.to_dict() != other.to_dict()
