# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class TranscriptionVocabulary(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'name': 'str',
        'phrases': 'list[str]',
        'passthrough': 'str',
        'created_at': 'str',
        'updated_at': 'str'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'phrases': 'phrases',
        'passthrough': 'passthrough',
        'created_at': 'created_at',
        'updated_at': 'updated_at'
    }

    def __init__(self, id=None, name=None, phrases=None, passthrough=None, created_at=None, updated_at=None, local_vars_configuration=None):  # noqa: E501
        """TranscriptionVocabulary - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._phrases = None
        self._passthrough = None
        self._created_at = None
        self._updated_at = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if phrases is not None:
            self.phrases = phrases
        if passthrough is not None:
            self.passthrough = passthrough
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at

    @property
    def id(self):
        """Gets the id of this TranscriptionVocabulary.  # noqa: E501

        Unique identifier for the Transcription Vocabulary  # noqa: E501

        :return: The id of this TranscriptionVocabulary.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this TranscriptionVocabulary.

        Unique identifier for the Transcription Vocabulary  # noqa: E501

        :param id: The id of this TranscriptionVocabulary.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this TranscriptionVocabulary.  # noqa: E501

        The user-supplied name of the Transcription Vocabulary.  # noqa: E501

        :return: The name of this TranscriptionVocabulary.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TranscriptionVocabulary.

        The user-supplied name of the Transcription Vocabulary.  # noqa: E501

        :param name: The name of this TranscriptionVocabulary.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def phrases(self):
        """Gets the phrases of this TranscriptionVocabulary.  # noqa: E501

        Phrases, individual words, or proper names to include in the Transcription Vocabulary. When the Transcription Vocabulary is attached to a live stream's `generated_subtitles` configuration, the probability of successful speech recognition for these words or phrases is boosted.  # noqa: E501

        :return: The phrases of this TranscriptionVocabulary.  # noqa: E501
        :rtype: list[str]
        """
        return self._phrases

    @phrases.setter
    def phrases(self, phrases):
        """Sets the phrases of this TranscriptionVocabulary.

        Phrases, individual words, or proper names to include in the Transcription Vocabulary. When the Transcription Vocabulary is attached to a live stream's `generated_subtitles` configuration, the probability of successful speech recognition for these words or phrases is boosted.  # noqa: E501

        :param phrases: The phrases of this TranscriptionVocabulary.  # noqa: E501
        :type phrases: list[str]
        """
        if (self.local_vars_configuration.client_side_validation and
                phrases is not None and len(phrases) > 1000):
            raise ValueError("Invalid value for `phrases`, number of items must be less than or equal to `1000`")  # noqa: E501

        self._phrases = phrases

    @property
    def passthrough(self):
        """Gets the passthrough of this TranscriptionVocabulary.  # noqa: E501

        Arbitrary user-supplied metadata set for the Transcription Vocabulary. Max 255 characters.  # noqa: E501

        :return: The passthrough of this TranscriptionVocabulary.  # noqa: E501
        :rtype: str
        """
        return self._passthrough

    @passthrough.setter
    def passthrough(self, passthrough):
        """Sets the passthrough of this TranscriptionVocabulary.

        Arbitrary user-supplied metadata set for the Transcription Vocabulary. Max 255 characters.  # noqa: E501

        :param passthrough: The passthrough of this TranscriptionVocabulary.  # noqa: E501
        :type passthrough: str
        """

        self._passthrough = passthrough

    @property
    def created_at(self):
        """Gets the created_at of this TranscriptionVocabulary.  # noqa: E501

        Time the Transcription Vocabulary was created, defined as a Unix timestamp (seconds since epoch).  # noqa: E501

        :return: The created_at of this TranscriptionVocabulary.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this TranscriptionVocabulary.

        Time the Transcription Vocabulary was created, defined as a Unix timestamp (seconds since epoch).  # noqa: E501

        :param created_at: The created_at of this TranscriptionVocabulary.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this TranscriptionVocabulary.  # noqa: E501

        Time the Transcription Vocabulary was updated, defined as a Unix timestamp (seconds since epoch).  # noqa: E501

        :return: The updated_at of this TranscriptionVocabulary.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this TranscriptionVocabulary.

        Time the Transcription Vocabulary was updated, defined as a Unix timestamp (seconds since epoch).  # noqa: E501

        :param updated_at: The updated_at of this TranscriptionVocabulary.  # noqa: E501
        :type updated_at: str
        """

        self._updated_at = updated_at

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TranscriptionVocabulary):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TranscriptionVocabulary):
            return True

        return self.to_dict() != other.to_dict()
