# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class UpdateUserAgentRestrictionRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'allow_no_user_agent': 'bool',
        'allow_high_risk_user_agent': 'bool'
    }

    attribute_map = {
        'allow_no_user_agent': 'allow_no_user_agent',
        'allow_high_risk_user_agent': 'allow_high_risk_user_agent'
    }

    def __init__(self, allow_no_user_agent=True, allow_high_risk_user_agent=True, local_vars_configuration=None):  # noqa: E501
        """UpdateUserAgentRestrictionRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._allow_no_user_agent = None
        self._allow_high_risk_user_agent = None
        self.discriminator = None

        if allow_no_user_agent is not None:
            self.allow_no_user_agent = allow_no_user_agent
        if allow_high_risk_user_agent is not None:
            self.allow_high_risk_user_agent = allow_high_risk_user_agent

    @property
    def allow_no_user_agent(self):
        """Gets the allow_no_user_agent of this UpdateUserAgentRestrictionRequest.  # noqa: E501

        Whether or not to allow views without a `User-Agent` HTTP request header.  # noqa: E501

        :return: The allow_no_user_agent of this UpdateUserAgentRestrictionRequest.  # noqa: E501
        :rtype: bool
        """
        return self._allow_no_user_agent

    @allow_no_user_agent.setter
    def allow_no_user_agent(self, allow_no_user_agent):
        """Sets the allow_no_user_agent of this UpdateUserAgentRestrictionRequest.

        Whether or not to allow views without a `User-Agent` HTTP request header.  # noqa: E501

        :param allow_no_user_agent: The allow_no_user_agent of this UpdateUserAgentRestrictionRequest.  # noqa: E501
        :type allow_no_user_agent: bool
        """

        self._allow_no_user_agent = allow_no_user_agent

    @property
    def allow_high_risk_user_agent(self):
        """Gets the allow_high_risk_user_agent of this UpdateUserAgentRestrictionRequest.  # noqa: E501

        Whether or not to allow high risk user agents. The high risk user agents are defined by Mux.  # noqa: E501

        :return: The allow_high_risk_user_agent of this UpdateUserAgentRestrictionRequest.  # noqa: E501
        :rtype: bool
        """
        return self._allow_high_risk_user_agent

    @allow_high_risk_user_agent.setter
    def allow_high_risk_user_agent(self, allow_high_risk_user_agent):
        """Sets the allow_high_risk_user_agent of this UpdateUserAgentRestrictionRequest.

        Whether or not to allow high risk user agents. The high risk user agents are defined by Mux.  # noqa: E501

        :param allow_high_risk_user_agent: The allow_high_risk_user_agent of this UpdateUserAgentRestrictionRequest.  # noqa: E501
        :type allow_high_risk_user_agent: bool
        """

        self._allow_high_risk_user_agent = allow_high_risk_user_agent

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UpdateUserAgentRestrictionRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UpdateUserAgentRestrictionRequest):
            return True

        return self.to_dict() != other.to_dict()
