# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class WebInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'created_at': 'str',
        'url': 'str',
        'auto_launch': 'bool',
        'live_stream_id': 'str',
        'status': 'str',
        'passthrough': 'str',
        'resolution': 'str',
        'timeout': 'int'
    }

    attribute_map = {
        'id': 'id',
        'created_at': 'created_at',
        'url': 'url',
        'auto_launch': 'auto_launch',
        'live_stream_id': 'live_stream_id',
        'status': 'status',
        'passthrough': 'passthrough',
        'resolution': 'resolution',
        'timeout': 'timeout'
    }

    def __init__(self, id=None, created_at=None, url=None, auto_launch=None, live_stream_id=None, status=None, passthrough=None, resolution='1920x1080', timeout=3600, local_vars_configuration=None):  # noqa: E501
        """WebInput - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._created_at = None
        self._url = None
        self._auto_launch = None
        self._live_stream_id = None
        self._status = None
        self._passthrough = None
        self._resolution = None
        self._timeout = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if created_at is not None:
            self.created_at = created_at
        if url is not None:
            self.url = url
        if auto_launch is not None:
            self.auto_launch = auto_launch
        if live_stream_id is not None:
            self.live_stream_id = live_stream_id
        if status is not None:
            self.status = status
        if passthrough is not None:
            self.passthrough = passthrough
        if resolution is not None:
            self.resolution = resolution
        if timeout is not None:
            self.timeout = timeout

    @property
    def id(self):
        """Gets the id of this WebInput.  # noqa: E501

        Unique identifier for the Web Input.  # noqa: E501

        :return: The id of this WebInput.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this WebInput.

        Unique identifier for the Web Input.  # noqa: E501

        :param id: The id of this WebInput.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def created_at(self):
        """Gets the created_at of this WebInput.  # noqa: E501

        Time the Web Input was created, defined as a Unix timestamp (seconds since epoch).  # noqa: E501

        :return: The created_at of this WebInput.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this WebInput.

        Time the Web Input was created, defined as a Unix timestamp (seconds since epoch).  # noqa: E501

        :param created_at: The created_at of this WebInput.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def url(self):
        """Gets the url of this WebInput.  # noqa: E501

        The URL for the Web Input to load.  # noqa: E501

        :return: The url of this WebInput.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this WebInput.

        The URL for the Web Input to load.  # noqa: E501

        :param url: The url of this WebInput.  # noqa: E501
        :type url: str
        """

        self._url = url

    @property
    def auto_launch(self):
        """Gets the auto_launch of this WebInput.  # noqa: E501

        When set to `true` the Web Input will automatically launch and start streaming immediately after creation  # noqa: E501

        :return: The auto_launch of this WebInput.  # noqa: E501
        :rtype: bool
        """
        return self._auto_launch

    @auto_launch.setter
    def auto_launch(self, auto_launch):
        """Sets the auto_launch of this WebInput.

        When set to `true` the Web Input will automatically launch and start streaming immediately after creation  # noqa: E501

        :param auto_launch: The auto_launch of this WebInput.  # noqa: E501
        :type auto_launch: bool
        """

        self._auto_launch = auto_launch

    @property
    def live_stream_id(self):
        """Gets the live_stream_id of this WebInput.  # noqa: E501

        The Live Stream ID to broadcast this Web Input to  # noqa: E501

        :return: The live_stream_id of this WebInput.  # noqa: E501
        :rtype: str
        """
        return self._live_stream_id

    @live_stream_id.setter
    def live_stream_id(self, live_stream_id):
        """Sets the live_stream_id of this WebInput.

        The Live Stream ID to broadcast this Web Input to  # noqa: E501

        :param live_stream_id: The live_stream_id of this WebInput.  # noqa: E501
        :type live_stream_id: str
        """

        self._live_stream_id = live_stream_id

    @property
    def status(self):
        """Gets the status of this WebInput.  # noqa: E501


        :return: The status of this WebInput.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this WebInput.


        :param status: The status of this WebInput.  # noqa: E501
        :type status: str
        """
        allowed_values = ["idle", "launching", "streaming"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def passthrough(self):
        """Gets the passthrough of this WebInput.  # noqa: E501

        Arbitrary metadata that will be included in the Web Input details and related webhooks. Can be used to store your own ID for the Web Input. **Max: 255 characters**.  # noqa: E501

        :return: The passthrough of this WebInput.  # noqa: E501
        :rtype: str
        """
        return self._passthrough

    @passthrough.setter
    def passthrough(self, passthrough):
        """Sets the passthrough of this WebInput.

        Arbitrary metadata that will be included in the Web Input details and related webhooks. Can be used to store your own ID for the Web Input. **Max: 255 characters**.  # noqa: E501

        :param passthrough: The passthrough of this WebInput.  # noqa: E501
        :type passthrough: str
        """

        self._passthrough = passthrough

    @property
    def resolution(self):
        """Gets the resolution of this WebInput.  # noqa: E501

        The resolution of the viewport of the Web Input's browser instance. Defaults to 1920x1080 if not set.  # noqa: E501

        :return: The resolution of this WebInput.  # noqa: E501
        :rtype: str
        """
        return self._resolution

    @resolution.setter
    def resolution(self, resolution):
        """Sets the resolution of this WebInput.

        The resolution of the viewport of the Web Input's browser instance. Defaults to 1920x1080 if not set.  # noqa: E501

        :param resolution: The resolution of this WebInput.  # noqa: E501
        :type resolution: str
        """
        allowed_values = ["1920x1080", "1280x720", "1080x1920", "720x1280", "1080x1080", "720x720"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and resolution not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `resolution` ({0}), must be one of {1}"  # noqa: E501
                .format(resolution, allowed_values)
            )

        self._resolution = resolution

    @property
    def timeout(self):
        """Gets the timeout of this WebInput.  # noqa: E501

        The number of seconds that the Web Input should stream for before automatically shutting down.  # noqa: E501

        :return: The timeout of this WebInput.  # noqa: E501
        :rtype: int
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout):
        """Sets the timeout of this WebInput.

        The number of seconds that the Web Input should stream for before automatically shutting down.  # noqa: E501

        :param timeout: The timeout of this WebInput.  # noqa: E501
        :type timeout: int
        """

        self._timeout = timeout

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WebInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WebInput):
            return True

        return self.to_dict() != other.to_dict()
