# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class CreateStaticRenditionRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'resolution': 'str',
        'passthrough': 'str'
    }

    attribute_map = {
        'resolution': 'resolution',
        'passthrough': 'passthrough'
    }

    def __init__(self, resolution=None, passthrough=None, local_vars_configuration=None):  # noqa: E501
        """CreateStaticRenditionRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._resolution = None
        self._passthrough = None
        self.discriminator = None

        if resolution is not None:
            self.resolution = resolution
        if passthrough is not None:
            self.passthrough = passthrough

    @property
    def resolution(self):
        """Gets the resolution of this CreateStaticRenditionRequest.  # noqa: E501


        :return: The resolution of this CreateStaticRenditionRequest.  # noqa: E501
        :rtype: str
        """
        return self._resolution

    @resolution.setter
    def resolution(self, resolution):
        """Sets the resolution of this CreateStaticRenditionRequest.


        :param resolution: The resolution of this CreateStaticRenditionRequest.  # noqa: E501
        :type resolution: str
        """
        allowed_values = ["highest", "audio-only", "2160p", "1440p", "1080p", "720p", "540p", "480p", "360p", "270p"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and resolution not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `resolution` ({0}), must be one of {1}"  # noqa: E501
                .format(resolution, allowed_values)
            )

        self._resolution = resolution

    @property
    def passthrough(self):
        """Gets the passthrough of this CreateStaticRenditionRequest.  # noqa: E501

        Arbitrary user-supplied metadata set for the static rendition. Max 255 characters.  # noqa: E501

        :return: The passthrough of this CreateStaticRenditionRequest.  # noqa: E501
        :rtype: str
        """
        return self._passthrough

    @passthrough.setter
    def passthrough(self, passthrough):
        """Sets the passthrough of this CreateStaticRenditionRequest.

        Arbitrary user-supplied metadata set for the static rendition. Max 255 characters.  # noqa: E501

        :param passthrough: The passthrough of this CreateStaticRenditionRequest.  # noqa: E501
        :type passthrough: str
        """

        self._passthrough = passthrough

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateStaticRenditionRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CreateStaticRenditionRequest):
            return True

        return self.to_dict() != other.to_dict()
