# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class LiveStreamGeneratedSubtitleSettings(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'passthrough': 'str',
        'language_code': 'str',
        'transcription_vocabulary_ids': 'list[str]'
    }

    attribute_map = {
        'name': 'name',
        'passthrough': 'passthrough',
        'language_code': 'language_code',
        'transcription_vocabulary_ids': 'transcription_vocabulary_ids'
    }

    def __init__(self, name=None, passthrough=None, language_code='en', transcription_vocabulary_ids=None, local_vars_configuration=None):  # noqa: E501
        """LiveStreamGeneratedSubtitleSettings - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._passthrough = None
        self._language_code = None
        self._transcription_vocabulary_ids = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if passthrough is not None:
            self.passthrough = passthrough
        if language_code is not None:
            self.language_code = language_code
        if transcription_vocabulary_ids is not None:
            self.transcription_vocabulary_ids = transcription_vocabulary_ids

    @property
    def name(self):
        """Gets the name of this LiveStreamGeneratedSubtitleSettings.  # noqa: E501

        A name for this live stream subtitle track.  # noqa: E501

        :return: The name of this LiveStreamGeneratedSubtitleSettings.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this LiveStreamGeneratedSubtitleSettings.

        A name for this live stream subtitle track.  # noqa: E501

        :param name: The name of this LiveStreamGeneratedSubtitleSettings.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def passthrough(self):
        """Gets the passthrough of this LiveStreamGeneratedSubtitleSettings.  # noqa: E501

        Arbitrary metadata set for the live stream subtitle track. Max 255 characters.  # noqa: E501

        :return: The passthrough of this LiveStreamGeneratedSubtitleSettings.  # noqa: E501
        :rtype: str
        """
        return self._passthrough

    @passthrough.setter
    def passthrough(self, passthrough):
        """Sets the passthrough of this LiveStreamGeneratedSubtitleSettings.

        Arbitrary metadata set for the live stream subtitle track. Max 255 characters.  # noqa: E501

        :param passthrough: The passthrough of this LiveStreamGeneratedSubtitleSettings.  # noqa: E501
        :type passthrough: str
        """

        self._passthrough = passthrough

    @property
    def language_code(self):
        """Gets the language_code of this LiveStreamGeneratedSubtitleSettings.  # noqa: E501

        The language to generate subtitles in.  # noqa: E501

        :return: The language_code of this LiveStreamGeneratedSubtitleSettings.  # noqa: E501
        :rtype: str
        """
        return self._language_code

    @language_code.setter
    def language_code(self, language_code):
        """Sets the language_code of this LiveStreamGeneratedSubtitleSettings.

        The language to generate subtitles in.  # noqa: E501

        :param language_code: The language_code of this LiveStreamGeneratedSubtitleSettings.  # noqa: E501
        :type language_code: str
        """
        allowed_values = ["en", "en-US", "es", "fr", "de", "pt", "it"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and language_code not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `language_code` ({0}), must be one of {1}"  # noqa: E501
                .format(language_code, allowed_values)
            )

        self._language_code = language_code

    @property
    def transcription_vocabulary_ids(self):
        """Gets the transcription_vocabulary_ids of this LiveStreamGeneratedSubtitleSettings.  # noqa: E501

        Unique identifiers for existing Transcription Vocabularies to use while generating subtitles for the live stream. If the Transcription Vocabularies provided collectively have more than 1000 phrases, only the first 1000 phrases will be included.  # noqa: E501

        :return: The transcription_vocabulary_ids of this LiveStreamGeneratedSubtitleSettings.  # noqa: E501
        :rtype: list[str]
        """
        return self._transcription_vocabulary_ids

    @transcription_vocabulary_ids.setter
    def transcription_vocabulary_ids(self, transcription_vocabulary_ids):
        """Sets the transcription_vocabulary_ids of this LiveStreamGeneratedSubtitleSettings.

        Unique identifiers for existing Transcription Vocabularies to use while generating subtitles for the live stream. If the Transcription Vocabularies provided collectively have more than 1000 phrases, only the first 1000 phrases will be included.  # noqa: E501

        :param transcription_vocabulary_ids: The transcription_vocabulary_ids of this LiveStreamGeneratedSubtitleSettings.  # noqa: E501
        :type transcription_vocabulary_ids: list[str]
        """

        self._transcription_vocabulary_ids = transcription_vocabulary_ids

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LiveStreamGeneratedSubtitleSettings):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LiveStreamGeneratedSubtitleSettings):
            return True

        return self.to_dict() != other.to_dict()
