# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class AnnotationInput(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'note': 'str',
        'date': 'int',
        'sub_property_id': 'str'
    }

    attribute_map = {
        'note': 'note',
        'date': 'date',
        'sub_property_id': 'sub_property_id'
    }

    def __init__(self, note=None, date=None, sub_property_id=None, local_vars_configuration=None):  # noqa: E501
        """AnnotationInput - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._note = None
        self._date = None
        self._sub_property_id = None
        self.discriminator = None

        if note is not None:
            self.note = note
        if date is not None:
            self.date = date
        if sub_property_id is not None:
            self.sub_property_id = sub_property_id

    @property
    def note(self):
        """Gets the note of this AnnotationInput.  # noqa: E501

        The annotation note content  # noqa: E501

        :return: The note of this AnnotationInput.  # noqa: E501
        :rtype: str
        """
        return self._note

    @note.setter
    def note(self, note):
        """Sets the note of this AnnotationInput.

        The annotation note content  # noqa: E501

        :param note: The note of this AnnotationInput.  # noqa: E501
        :type note: str
        """

        self._note = note

    @property
    def date(self):
        """Gets the date of this AnnotationInput.  # noqa: E501

        Datetime when the annotation applies (Unix timestamp)  # noqa: E501

        :return: The date of this AnnotationInput.  # noqa: E501
        :rtype: int
        """
        return self._date

    @date.setter
    def date(self, date):
        """Sets the date of this AnnotationInput.

        Datetime when the annotation applies (Unix timestamp)  # noqa: E501

        :param date: The date of this AnnotationInput.  # noqa: E501
        :type date: int
        """

        self._date = date

    @property
    def sub_property_id(self):
        """Gets the sub_property_id of this AnnotationInput.  # noqa: E501

        Customer-defined sub-property identifier  # noqa: E501

        :return: The sub_property_id of this AnnotationInput.  # noqa: E501
        :rtype: str
        """
        return self._sub_property_id

    @sub_property_id.setter
    def sub_property_id(self, sub_property_id):
        """Sets the sub_property_id of this AnnotationInput.

        Customer-defined sub-property identifier  # noqa: E501

        :param sub_property_id: The sub_property_id of this AnnotationInput.  # noqa: E501
        :type sub_property_id: str
        """

        self._sub_property_id = sub_property_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AnnotationInput):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AnnotationInput):
            return True

        return self.to_dict() != other.to_dict()
