# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class AssetProgress(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'state': 'str',
        'progress': 'float'
    }

    attribute_map = {
        'state': 'state',
        'progress': 'progress'
    }

    def __init__(self, state=None, progress=None, local_vars_configuration=None):  # noqa: E501
        """AssetProgress - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._state = None
        self._progress = None
        self.discriminator = None

        if state is not None:
            self.state = state
        if progress is not None:
            self.progress = progress

    @property
    def state(self):
        """Gets the state of this AssetProgress.  # noqa: E501

        The detailed state of the asset ingest process. This field is useful for relaying more granular processing information to end users when a [non-standard input is encountered](https://www.mux.com/docs/guides/minimize-processing-time#non-standard-input).  - `ingesting`: Asset is being ingested (initial processing before or after transcoding). While in this state, the `progress` percentage will be 0. - `transcoding`: Asset is undergoing non-standard transcoding. - `completed`: Asset processing is complete (`status` is `ready`). While in this state, the `progress` percentage will be 100. - `live`: Asset is a live stream currently in progress. While in this state, the `progress` percentage will be -1. - `errored`: Asset has encountered an error (`status` is `errored`). While in this state, the `progress` percentage will be -1.   # noqa: E501

        :return: The state of this AssetProgress.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this AssetProgress.

        The detailed state of the asset ingest process. This field is useful for relaying more granular processing information to end users when a [non-standard input is encountered](https://www.mux.com/docs/guides/minimize-processing-time#non-standard-input).  - `ingesting`: Asset is being ingested (initial processing before or after transcoding). While in this state, the `progress` percentage will be 0. - `transcoding`: Asset is undergoing non-standard transcoding. - `completed`: Asset processing is complete (`status` is `ready`). While in this state, the `progress` percentage will be 100. - `live`: Asset is a live stream currently in progress. While in this state, the `progress` percentage will be -1. - `errored`: Asset has encountered an error (`status` is `errored`). While in this state, the `progress` percentage will be -1.   # noqa: E501

        :param state: The state of this AssetProgress.  # noqa: E501
        :type state: str
        """
        allowed_values = ["ingesting", "transcoding", "completed", "live", "errored"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def progress(self):
        """Gets the progress of this AssetProgress.  # noqa: E501

        Represents the estimated completion percentage. Returns `0 - 100` when in `ingesting`, `transcoding`, or `completed` state, and `-1` when in `live` or `errored` state.  # noqa: E501

        :return: The progress of this AssetProgress.  # noqa: E501
        :rtype: float
        """
        return self._progress

    @progress.setter
    def progress(self, progress):
        """Sets the progress of this AssetProgress.

        Represents the estimated completion percentage. Returns `0 - 100` when in `ingesting`, `transcoding`, or `completed` state, and `-1` when in `live` or `errored` state.  # noqa: E501

        :param progress: The progress of this AssetProgress.  # noqa: E501
        :type progress: float
        """
        if (self.local_vars_configuration.client_side_validation and
                progress is not None and progress > 100):  # noqa: E501
            raise ValueError("Invalid value for `progress`, must be a value less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                progress is not None and progress < -1):  # noqa: E501
            raise ValueError("Invalid value for `progress`, must be a value greater than or equal to `-1`")  # noqa: E501

        self._progress = progress

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AssetProgress):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AssetProgress):
            return True

        return self.to_dict() != other.to_dict()
