# generated by datamodel-codegen:
#   filename:  https://raw.githubusercontent.com/openai/openai-openapi/master/openapi.yaml
#   timestamp: 2024-09-09T08:46:49+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import (
    AnyUrl,
    BaseModel,
    ConfigDict,
    Field,
    PositiveFloat,
    RootModel,
    confloat,
    conint,
    constr,
)


class Error(BaseModel):
    code: str
    message: str
    param: str
    type: str


class ErrorResponse(BaseModel):
    error: Error


class Object(Enum):
    list = 'list'


class DeleteModelResponse(BaseModel):
    id: str
    deleted: bool
    object: str


class Model1(Enum):
    gpt_3_5_turbo_instruct = 'gpt-3.5-turbo-instruct'
    davinci_002 = 'davinci-002'
    babbage_002 = 'babbage-002'


class PromptItem(RootModel[List[int]]):
    root: List[int]


class FinishReason(Enum):
    stop = 'stop'
    length = 'length'
    content_filter = 'content_filter'


class Logprobs(BaseModel):
    text_offset: Optional[List[int]] = None
    token_logprobs: Optional[List[float]] = None
    tokens: Optional[List[str]] = None
    top_logprobs: Optional[List[Dict[str, float]]] = None


class Choice(BaseModel):
    finish_reason: FinishReason = Field(
        ...,
        description='The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,\n`length` if the maximum number of tokens specified in the request was reached,\nor `content_filter` if content was omitted due to a flag from our content filters.\n',
    )
    index: int
    logprobs: Logprobs
    text: str


class Object1(Enum):
    text_completion = 'text_completion'


class Type(Enum):
    text = 'text'


class ChatCompletionRequestMessageContentPartText(BaseModel):
    type: Type = Field(..., description='The type of the content part.')
    text: str = Field(..., description='The text content.')


class Type1(Enum):
    image_url = 'image_url'


class Detail(Enum):
    auto = 'auto'
    low = 'low'
    high = 'high'


class ImageUrl(BaseModel):
    url: AnyUrl = Field(
        ..., description='Either a URL of the image or the base64 encoded image data.'
    )
    detail: Optional[Detail] = Field(
        'auto',
        description='Specifies the detail level of the image. Learn more in the [Vision guide](/docs/guides/vision/low-or-high-fidelity-image-understanding).',
    )


class ChatCompletionRequestMessageContentPartImage(BaseModel):
    type: Type1 = Field(..., description='The type of the content part.')
    image_url: ImageUrl


class Type2(Enum):
    refusal = 'refusal'


class ChatCompletionRequestMessageContentPartRefusal(BaseModel):
    type: Type2 = Field(..., description='The type of the content part.')
    refusal: str = Field(..., description='The refusal message generated by the model.')


class ChatCompletionRequestSystemMessageContentPart(
    RootModel[ChatCompletionRequestMessageContentPartText]
):
    root: ChatCompletionRequestMessageContentPartText


class ChatCompletionRequestUserMessageContentPart(
    RootModel[
        Union[
            ChatCompletionRequestMessageContentPartText,
            ChatCompletionRequestMessageContentPartImage,
        ]
    ]
):
    root: Union[
        ChatCompletionRequestMessageContentPartText,
        ChatCompletionRequestMessageContentPartImage,
    ]


class ChatCompletionRequestAssistantMessageContentPart(
    RootModel[
        Union[
            ChatCompletionRequestMessageContentPartText,
            ChatCompletionRequestMessageContentPartRefusal,
        ]
    ]
):
    root: Union[
        ChatCompletionRequestMessageContentPartText,
        ChatCompletionRequestMessageContentPartRefusal,
    ]


class ChatCompletionRequestToolMessageContentPart(
    ChatCompletionRequestSystemMessageContentPart
):
    pass


class Role(Enum):
    system = 'system'


class ChatCompletionRequestSystemMessage(BaseModel):
    content: Union[str, List[ChatCompletionRequestSystemMessageContentPart]] = Field(
        ..., description='The contents of the system message.'
    )
    role: Role = Field(
        ..., description='The role of the messages author, in this case `system`.'
    )
    name: Optional[str] = Field(
        None,
        description='An optional name for the participant. Provides the model information to differentiate between participants of the same role.',
    )


class Role1(Enum):
    user = 'user'


class ChatCompletionRequestUserMessage(BaseModel):
    content: Union[str, List[ChatCompletionRequestUserMessageContentPart]] = Field(
        ..., description='The contents of the user message.\n'
    )
    role: Role1 = Field(
        ..., description='The role of the messages author, in this case `user`.'
    )
    name: Optional[str] = Field(
        None,
        description='An optional name for the participant. Provides the model information to differentiate between participants of the same role.',
    )


class Role2(Enum):
    assistant = 'assistant'


class FunctionCall(BaseModel):
    arguments: str = Field(
        ...,
        description='The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.',
    )
    name: str = Field(..., description='The name of the function to call.')


class Weight(Enum):
    integer_0 = 0
    integer_1 = 1


class Role3(Enum):
    tool = 'tool'


class ChatCompletionRequestToolMessage(BaseModel):
    role: Role3 = Field(
        ..., description='The role of the messages author, in this case `tool`.'
    )
    content: Union[str, List[ChatCompletionRequestToolMessageContentPart]] = Field(
        ..., description='The contents of the tool message.'
    )
    tool_call_id: str = Field(
        ..., description='Tool call that this message is responding to.'
    )


class Role4(Enum):
    function = 'function'


class ChatCompletionRequestFunctionMessage(BaseModel):
    role: Role4 = Field(
        ..., description='The role of the messages author, in this case `function`.'
    )
    content: str = Field(..., description='The contents of the function message.')
    name: str = Field(..., description='The name of the function to call.')


class FunctionParameters(BaseModel):
    pass
    model_config = ConfigDict(
        extra='allow',
    )


class ChatCompletionFunctions(BaseModel):
    description: Optional[str] = Field(
        None,
        description='A description of what the function does, used by the model to choose when and how to call the function.',
    )
    name: str = Field(
        ...,
        description='The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.',
    )
    parameters: Optional[FunctionParameters] = None


class ChatCompletionFunctionCallOption(BaseModel):
    name: str = Field(..., description='The name of the function to call.')


class FunctionObject(BaseModel):
    description: Optional[str] = Field(
        None,
        description='A description of what the function does, used by the model to choose when and how to call the function.',
    )
    name: str = Field(
        ...,
        description='The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.',
    )
    parameters: Optional[FunctionParameters] = None
    strict: Optional[bool] = Field(
        False,
        description='Whether to enable strict schema adherence when generating the function call. If set to true, the model will follow the exact schema defined in the `parameters` field. Only a subset of JSON Schema is supported when `strict` is `true`. Learn more about Structured Outputs in the [function calling guide](docs/guides/function-calling).',
    )


class ResponseFormatText(BaseModel):
    type: Type = Field(
        ..., description='The type of response format being defined: `text`'
    )


class Type5(Enum):
    json_object = 'json_object'


class ResponseFormatJsonObject(BaseModel):
    type: Type5 = Field(
        ..., description='The type of response format being defined: `json_object`'
    )


class ResponseFormatJsonSchemaSchema(FunctionParameters):
    pass


class Type6(Enum):
    json_schema = 'json_schema'


class JsonSchema(BaseModel):
    description: Optional[str] = Field(
        None,
        description='A description of what the response format is for, used by the model to determine how to respond in the format.',
    )
    name: str = Field(
        ...,
        description='The name of the response format. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.',
    )
    schema_: Optional[ResponseFormatJsonSchemaSchema] = Field(None, alias='schema')
    strict: Optional[bool] = Field(
        False,
        description='Whether to enable strict schema adherence when generating the output. If set to true, the model will always follow the exact schema defined in the `schema` field. Only a subset of JSON Schema is supported when `strict` is `true`. To learn more, read the [Structured Outputs guide](/docs/guides/structured-outputs).',
    )


class ResponseFormatJsonSchema(BaseModel):
    type: Type6 = Field(
        ..., description='The type of response format being defined: `json_schema`'
    )
    json_schema: JsonSchema


class ChatCompletionToolChoiceOption1(Enum):
    none = 'none'
    auto = 'auto'
    required = 'required'


class Function(ChatCompletionFunctionCallOption):
    pass


class ChatCompletionNamedToolChoice(BaseModel):
    type: Role4 = Field(
        ...,
        description='The type of the tool. Currently, only `function` is supported.',
    )
    function: Function


class ParallelToolCalls(RootModel[bool]):
    root: bool = Field(
        ...,
        description='Whether to enable [parallel function calling](/docs/guides/function-calling/parallel-function-calling) during tool use.',
    )


class Function1(BaseModel):
    name: str = Field(..., description='The name of the function to call.')
    arguments: str = Field(
        ...,
        description='The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.',
    )


class ChatCompletionMessageToolCall(BaseModel):
    id: str = Field(..., description='The ID of the tool call.')
    type: Role4 = Field(
        ...,
        description='The type of the tool. Currently, only `function` is supported.',
    )
    function: Function1 = Field(..., description='The function that the model called.')


class Function2(BaseModel):
    name: Optional[str] = Field(None, description='The name of the function to call.')
    arguments: Optional[str] = Field(
        None,
        description='The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.',
    )


class ChatCompletionMessageToolCallChunk(BaseModel):
    index: int
    id: Optional[str] = Field(None, description='The ID of the tool call.')
    type: Optional[Role4] = Field(
        None,
        description='The type of the tool. Currently, only `function` is supported.',
    )
    function: Optional[Function2] = None


class ChatCompletionRole(Enum):
    system = 'system'
    user = 'user'
    assistant = 'assistant'
    tool = 'tool'
    function = 'function'


class ChatCompletionStreamOptions(BaseModel):
    include_usage: Optional[bool] = Field(
        None,
        description='If set, an additional chunk will be streamed before the `data: [DONE]` message. The `usage` field on this chunk shows the token usage statistics for the entire request, and the `choices` field will always be an empty array. All other chunks will also include a `usage` field, but with a null value.\n',
    )


class FunctionCall2(BaseModel):
    arguments: Optional[str] = Field(
        None,
        description='The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.',
    )
    name: Optional[str] = Field(None, description='The name of the function to call.')


class Role6(Enum):
    system = 'system'
    user = 'user'
    assistant = 'assistant'
    tool = 'tool'


class ChatCompletionStreamResponseDelta(BaseModel):
    content: Optional[str] = Field(
        None, description='The contents of the chunk message.'
    )
    function_call: Optional[FunctionCall2] = Field(
        None,
        description='Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.',
    )
    tool_calls: Optional[List[ChatCompletionMessageToolCallChunk]] = None
    role: Optional[Role6] = Field(
        None, description='The role of the author of this message.'
    )
    refusal: Optional[str] = Field(
        None, description='The refusal message generated by the model.'
    )


class Model2(Enum):
    gpt_4o = 'gpt-4o'
    gpt_4o_2024_05_13 = 'gpt-4o-2024-05-13'
    gpt_4o_2024_08_06 = 'gpt-4o-2024-08-06'
    chatgpt_4o_latest = 'chatgpt-4o-latest'
    gpt_4o_mini = 'gpt-4o-mini'
    gpt_4o_mini_2024_07_18 = 'gpt-4o-mini-2024-07-18'
    gpt_4_turbo = 'gpt-4-turbo'
    gpt_4_turbo_2024_04_09 = 'gpt-4-turbo-2024-04-09'
    gpt_4_0125_preview = 'gpt-4-0125-preview'
    gpt_4_turbo_preview = 'gpt-4-turbo-preview'
    gpt_4_1106_preview = 'gpt-4-1106-preview'
    gpt_4_vision_preview = 'gpt-4-vision-preview'
    gpt_4 = 'gpt-4'
    gpt_4_0314 = 'gpt-4-0314'
    gpt_4_0613 = 'gpt-4-0613'
    gpt_4_32k = 'gpt-4-32k'
    gpt_4_32k_0314 = 'gpt-4-32k-0314'
    gpt_4_32k_0613 = 'gpt-4-32k-0613'
    gpt_3_5_turbo = 'gpt-3.5-turbo'
    gpt_3_5_turbo_16k = 'gpt-3.5-turbo-16k'
    gpt_3_5_turbo_0301 = 'gpt-3.5-turbo-0301'
    gpt_3_5_turbo_0613 = 'gpt-3.5-turbo-0613'
    gpt_3_5_turbo_1106 = 'gpt-3.5-turbo-1106'
    gpt_3_5_turbo_0125 = 'gpt-3.5-turbo-0125'
    gpt_3_5_turbo_16k_0613 = 'gpt-3.5-turbo-16k-0613'


class ServiceTier(Enum):
    auto = 'auto'
    default = 'default'


class FunctionCall3(Enum):
    none = 'none'
    auto = 'auto'


class FinishReason1(Enum):
    stop = 'stop'
    length = 'length'
    tool_calls = 'tool_calls'
    content_filter = 'content_filter'
    function_call = 'function_call'


class ServiceTier1(Enum):
    scale = 'scale'
    default = 'default'


class Object2(Enum):
    chat_completion = 'chat.completion'


class FinishReason2(Enum):
    stop = 'stop'
    length = 'length'
    function_call = 'function_call'
    content_filter = 'content_filter'


class TopLogprob(BaseModel):
    token: str = Field(..., description='The token.')
    logprob: float = Field(
        ...,
        description='The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value `-9999.0` is used to signify that the token is very unlikely.',
    )
    bytes: List[int] = Field(
        ...,
        description='A list of integers representing the UTF-8 bytes representation of the token. Useful in instances where characters are represented by multiple tokens and their byte representations must be combined to generate the correct text representation. Can be `null` if there is no bytes representation for the token.',
    )


class ChatCompletionTokenLogprob(BaseModel):
    token: str = Field(..., description='The token.')
    logprob: float = Field(
        ...,
        description='The log probability of this token, if it is within the top 20 most likely tokens. Otherwise, the value `-9999.0` is used to signify that the token is very unlikely.',
    )
    bytes: List[int] = Field(
        ...,
        description='A list of integers representing the UTF-8 bytes representation of the token. Useful in instances where characters are represented by multiple tokens and their byte representations must be combined to generate the correct text representation. Can be `null` if there is no bytes representation for the token.',
    )
    top_logprobs: List[TopLogprob] = Field(
        ...,
        description='List of the most likely tokens and their log probability, at this token position. In rare cases, there may be fewer than the number of requested `top_logprobs` returned.',
    )


class Logprobs2(BaseModel):
    content: List[ChatCompletionTokenLogprob] = Field(
        ...,
        description='A list of message content tokens with log probability information.',
    )
    refusal: List[ChatCompletionTokenLogprob] = Field(
        ...,
        description='A list of message refusal tokens with log probability information.',
    )


class Choice3(BaseModel):
    delta: ChatCompletionStreamResponseDelta
    logprobs: Optional[Logprobs2] = Field(
        None, description='Log probability information for the choice.'
    )
    finish_reason: FinishReason1 = Field(
        ...,
        description='The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,\n`length` if the maximum number of tokens specified in the request was reached,\n`content_filter` if content was omitted due to a flag from our content filters,\n`tool_calls` if the model called a tool, or `function_call` (deprecated) if the model called a function.\n',
    )
    index: int = Field(
        ..., description='The index of the choice in the list of choices.'
    )


class Object5(Enum):
    chat_completion_chunk = 'chat.completion.chunk'


class Usage(BaseModel):
    completion_tokens: int = Field(
        ..., description='Number of tokens in the generated completion.'
    )
    prompt_tokens: int = Field(..., description='Number of tokens in the prompt.')
    total_tokens: int = Field(
        ...,
        description='Total number of tokens used in the request (prompt + completion).',
    )


class CreateChatCompletionStreamResponse(BaseModel):
    id: str = Field(
        ...,
        description='A unique identifier for the chat completion. Each chunk has the same ID.',
    )
    choices: List[Choice3] = Field(
        ...,
        description='A list of chat completion choices. Can contain more than one elements if `n` is greater than 1. Can also be empty for the\nlast chunk if you set `stream_options: {"include_usage": true}`.\n',
    )
    created: int = Field(
        ...,
        description='The Unix timestamp (in seconds) of when the chat completion was created. Each chunk has the same timestamp.',
    )
    model: str = Field(..., description='The model to generate the completion.')
    service_tier: Optional[ServiceTier1] = Field(
        None,
        description='The service tier used for processing the request. This field is only included if the `service_tier` parameter is specified in the request.',
        examples=['scale'],
    )
    system_fingerprint: Optional[str] = Field(
        None,
        description='This fingerprint represents the backend configuration that the model runs with.\nCan be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.\n',
    )
    object: Object5 = Field(
        ..., description='The object type, which is always `chat.completion.chunk`.'
    )
    usage: Optional[Usage] = Field(
        None,
        description='An optional field that will only be present when you set `stream_options: {"include_usage": true}` in your request.\nWhen present, it contains a null value except for the last chunk which contains the token usage statistics for the entire request.\n',
    )


class CreateChatCompletionImageResponse(BaseModel):
    pass


class Model3(Enum):
    dall_e_2 = 'dall-e-2'
    dall_e_3 = 'dall-e-3'


class Quality(Enum):
    standard = 'standard'
    hd = 'hd'


class ResponseFormat(Enum):
    url = 'url'
    b64_json = 'b64_json'


class Size(Enum):
    field_256x256 = '256x256'
    field_512x512 = '512x512'
    field_1024x1024 = '1024x1024'
    field_1792x1024 = '1792x1024'
    field_1024x1792 = '1024x1792'


class Style(Enum):
    vivid = 'vivid'
    natural = 'natural'


class CreateImageRequest(BaseModel):
    prompt: str = Field(
        ...,
        description='A text description of the desired image(s). The maximum length is 1000 characters for `dall-e-2` and 4000 characters for `dall-e-3`.',
        examples=['A cute baby sea otter'],
    )
    model: Optional[Union[str, Model3]] = Field(
        'dall-e-2',
        description='The model to use for image generation.',
        examples=['dall-e-3'],
    )
    n: Optional[conint(ge=1, le=10)] = Field(
        1,
        description='The number of images to generate. Must be between 1 and 10. For `dall-e-3`, only `n=1` is supported.',
        examples=[1],
    )
    quality: Optional[Quality] = Field(
        'standard',
        description='The quality of the image that will be generated. `hd` creates images with finer details and greater consistency across the image. This param is only supported for `dall-e-3`.',
        examples=['standard'],
    )
    response_format: Optional[ResponseFormat] = Field(
        'url',
        description='The format in which the generated images are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated.',
        examples=['url'],
    )
    size: Optional[Size] = Field(
        '1024x1024',
        description='The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024` for `dall-e-2`. Must be one of `1024x1024`, `1792x1024`, or `1024x1792` for `dall-e-3` models.',
        examples=['1024x1024'],
    )
    style: Optional[Style] = Field(
        'vivid',
        description='The style of the generated images. Must be one of `vivid` or `natural`. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images. This param is only supported for `dall-e-3`.',
        examples=['vivid'],
    )
    user: Optional[str] = Field(
        None,
        description='A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).\n',
        examples=['user-1234'],
    )


class Image(BaseModel):
    b64_json: Optional[str] = Field(
        None,
        description='The base64-encoded JSON of the generated image, if `response_format` is `b64_json`.',
    )
    url: Optional[str] = Field(
        None,
        description='The URL of the generated image, if `response_format` is `url` (default).',
    )
    revised_prompt: Optional[str] = Field(
        None,
        description='The prompt that was used to generate the image, if there was any revision to the prompt.',
    )


class Model4(Enum):
    dall_e_2 = 'dall-e-2'


class Size1(Enum):
    field_256x256 = '256x256'
    field_512x512 = '512x512'
    field_1024x1024 = '1024x1024'


class CreateImageEditRequest(BaseModel):
    image: bytes = Field(
        ...,
        description='The image to edit. Must be a valid PNG file, less than 4MB, and square. If mask is not provided, image must have transparency, which will be used as the mask.',
    )
    prompt: str = Field(
        ...,
        description='A text description of the desired image(s). The maximum length is 1000 characters.',
        examples=['A cute baby sea otter wearing a beret'],
    )
    mask: Optional[bytes] = Field(
        None,
        description='An additional image whose fully transparent areas (e.g. where alpha is zero) indicate where `image` should be edited. Must be a valid PNG file, less than 4MB, and have the same dimensions as `image`.',
    )
    model: Optional[Union[str, Model4]] = Field(
        'dall-e-2',
        description='The model to use for image generation. Only `dall-e-2` is supported at this time.',
        examples=['dall-e-2'],
    )
    n: Optional[conint(ge=1, le=10)] = Field(
        1,
        description='The number of images to generate. Must be between 1 and 10.',
        examples=[1],
    )
    size: Optional[Size1] = Field(
        '1024x1024',
        description='The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024`.',
        examples=['1024x1024'],
    )
    response_format: Optional[ResponseFormat] = Field(
        'url',
        description='The format in which the generated images are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated.',
        examples=['url'],
    )
    user: Optional[str] = Field(
        None,
        description='A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).\n',
        examples=['user-1234'],
    )


class CreateImageVariationRequest(BaseModel):
    image: bytes = Field(
        ...,
        description='The image to use as the basis for the variation(s). Must be a valid PNG file, less than 4MB, and square.',
    )
    model: Optional[Union[str, Model4]] = Field(
        'dall-e-2',
        description='The model to use for image generation. Only `dall-e-2` is supported at this time.',
        examples=['dall-e-2'],
    )
    n: Optional[conint(ge=1, le=10)] = Field(
        1,
        description='The number of images to generate. Must be between 1 and 10. For `dall-e-3`, only `n=1` is supported.',
        examples=[1],
    )
    response_format: Optional[ResponseFormat] = Field(
        'url',
        description='The format in which the generated images are returned. Must be one of `url` or `b64_json`. URLs are only valid for 60 minutes after the image has been generated.',
        examples=['url'],
    )
    size: Optional[Size1] = Field(
        '1024x1024',
        description='The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024`.',
        examples=['1024x1024'],
    )
    user: Optional[str] = Field(
        None,
        description='A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).\n',
        examples=['user-1234'],
    )


class Model6(Enum):
    text_moderation_latest = 'text-moderation-latest'
    text_moderation_stable = 'text-moderation-stable'


class CreateModerationRequest(BaseModel):
    input: Union[str, List[str]] = Field(..., description='The input text to classify')
    model: Optional[Union[str, Model6]] = Field(
        'text-moderation-latest',
        description='Two content moderations models are available: `text-moderation-stable` and `text-moderation-latest`.\n\nThe default is `text-moderation-latest` which will be automatically upgraded over time. This ensures you are always using our most accurate model. If you use `text-moderation-stable`, we will provide advanced notice before updating the model. Accuracy of `text-moderation-stable` may be slightly lower than for `text-moderation-latest`.\n',
        examples=['text-moderation-stable'],
    )


class Categories(BaseModel):
    hate: bool = Field(
        ...,
        description='Content that expresses, incites, or promotes hate based on race, gender, ethnicity, religion, nationality, sexual orientation, disability status, or caste. Hateful content aimed at non-protected groups (e.g., chess players) is harassment.',
    )
    hate_threatening: bool = Field(
        ...,
        alias='hate/threatening',
        description='Hateful content that also includes violence or serious harm towards the targeted group based on race, gender, ethnicity, religion, nationality, sexual orientation, disability status, or caste.',
    )
    harassment: bool = Field(
        ...,
        description='Content that expresses, incites, or promotes harassing language towards any target.',
    )
    harassment_threatening: bool = Field(
        ...,
        alias='harassment/threatening',
        description='Harassment content that also includes violence or serious harm towards any target.',
    )
    self_harm: bool = Field(
        ...,
        alias='self-harm',
        description='Content that promotes, encourages, or depicts acts of self-harm, such as suicide, cutting, and eating disorders.',
    )
    self_harm_intent: bool = Field(
        ...,
        alias='self-harm/intent',
        description='Content where the speaker expresses that they are engaging or intend to engage in acts of self-harm, such as suicide, cutting, and eating disorders.',
    )
    self_harm_instructions: bool = Field(
        ...,
        alias='self-harm/instructions',
        description='Content that encourages performing acts of self-harm, such as suicide, cutting, and eating disorders, or that gives instructions or advice on how to commit such acts.',
    )
    sexual: bool = Field(
        ...,
        description='Content meant to arouse sexual excitement, such as the description of sexual activity, or that promotes sexual services (excluding sex education and wellness).',
    )
    sexual_minors: bool = Field(
        ...,
        alias='sexual/minors',
        description='Sexual content that includes an individual who is under 18 years old.',
    )
    violence: bool = Field(
        ..., description='Content that depicts death, violence, or physical injury.'
    )
    violence_graphic: bool = Field(
        ...,
        alias='violence/graphic',
        description='Content that depicts death, violence, or physical injury in graphic detail.',
    )


class CategoryScores(BaseModel):
    hate: float = Field(..., description="The score for the category 'hate'.")
    hate_threatening: float = Field(
        ...,
        alias='hate/threatening',
        description="The score for the category 'hate/threatening'.",
    )
    harassment: float = Field(
        ..., description="The score for the category 'harassment'."
    )
    harassment_threatening: float = Field(
        ...,
        alias='harassment/threatening',
        description="The score for the category 'harassment/threatening'.",
    )
    self_harm: float = Field(
        ..., alias='self-harm', description="The score for the category 'self-harm'."
    )
    self_harm_intent: float = Field(
        ...,
        alias='self-harm/intent',
        description="The score for the category 'self-harm/intent'.",
    )
    self_harm_instructions: float = Field(
        ...,
        alias='self-harm/instructions',
        description="The score for the category 'self-harm/instructions'.",
    )
    sexual: float = Field(..., description="The score for the category 'sexual'.")
    sexual_minors: float = Field(
        ...,
        alias='sexual/minors',
        description="The score for the category 'sexual/minors'.",
    )
    violence: float = Field(..., description="The score for the category 'violence'.")
    violence_graphic: float = Field(
        ...,
        alias='violence/graphic',
        description="The score for the category 'violence/graphic'.",
    )


class Result(BaseModel):
    flagged: bool = Field(
        ..., description='Whether any of the below categories are flagged.'
    )
    categories: Categories = Field(
        ...,
        description='A list of the categories, and whether they are flagged or not.',
    )
    category_scores: CategoryScores = Field(
        ...,
        description='A list of the categories along with their scores as predicted by model.',
    )


class CreateModerationResponse(BaseModel):
    id: str = Field(
        ..., description='The unique identifier for the moderation request.'
    )
    model: str = Field(
        ..., description='The model used to generate the moderation results.'
    )
    results: List[Result] = Field(..., description='A list of moderation objects.')


class Purpose(Enum):
    assistants = 'assistants'
    batch = 'batch'
    fine_tune = 'fine-tune'
    vision = 'vision'


class CreateFileRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    file: bytes = Field(
        ..., description='The File object (not file name) to be uploaded.\n'
    )
    purpose: Purpose = Field(
        ...,
        description='The intended purpose of the uploaded file.\n\nUse "assistants" for [Assistants](/docs/api-reference/assistants) and [Message](/docs/api-reference/messages) files, "vision" for Assistants image file inputs, "batch" for [Batch API](/docs/guides/batch), and "fine-tune" for [Fine-tuning](/docs/api-reference/fine-tuning).\n',
    )


class Object7(Enum):
    file = 'file'


class DeleteFileResponse(BaseModel):
    id: str
    object: Object7
    deleted: bool


class CreateUploadRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    filename: str = Field(..., description='The name of the file to upload.\n')
    purpose: Purpose = Field(
        ...,
        description='The intended purpose of the uploaded file.\n\nSee the [documentation on File purposes](/docs/api-reference/files/create#files-create-purpose).\n',
    )
    bytes: int = Field(
        ..., description='The number of bytes in the file you are uploading.\n'
    )
    mime_type: str = Field(
        ...,
        description='The MIME type of the file.\n\nThis must fall within the supported MIME types for your file purpose. See the supported MIME types for assistants and vision.\n',
    )


class AddUploadPartRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    data: bytes = Field(..., description='The chunk of bytes for this Part.\n')


class CompleteUploadRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    part_ids: List[str] = Field(..., description='The ordered list of Part IDs.\n')
    md5: Optional[str] = Field(
        None,
        description='The optional md5 checksum for the file contents to verify if the bytes uploaded matches what you expect.\n',
    )


class CancelUploadRequest(BaseModel):
    pass
    model_config = ConfigDict(
        extra='forbid',
    )


class Model7(Enum):
    babbage_002 = 'babbage-002'
    davinci_002 = 'davinci-002'
    gpt_3_5_turbo = 'gpt-3.5-turbo'
    gpt_4o_mini = 'gpt-4o-mini'


class BatchSize(Enum):
    auto = 'auto'


class Hyperparameters(BaseModel):
    batch_size: Optional[Union[BatchSize, conint(ge=1, le=256)]] = Field(
        'auto',
        description='Number of examples in each batch. A larger batch size means that model parameters\nare updated less frequently, but with lower variance.\n',
    )
    learning_rate_multiplier: Optional[Union[BatchSize, PositiveFloat]] = Field(
        'auto',
        description='Scaling factor for the learning rate. A smaller learning rate may be useful to avoid\noverfitting.\n',
    )
    n_epochs: Optional[Union[BatchSize, conint(ge=1, le=50)]] = Field(
        'auto',
        description='The number of epochs to train the model for. An epoch refers to one full cycle\nthrough the training dataset.\n',
    )


class Type10(Enum):
    wandb = 'wandb'


class Wandb(BaseModel):
    project: str = Field(
        ...,
        description='The name of the project that the new run will be created under.\n',
        examples=['my-wandb-project'],
    )
    name: Optional[str] = Field(
        None,
        description='A display name to set for the run. If not set, we will use the Job ID as the name.\n',
    )
    entity: Optional[str] = Field(
        None,
        description='The entity to use for the run. This allows you to set the team or username of the WandB user that you would\nlike associated with the run. If not set, the default entity for the registered WandB API key is used.\n',
    )
    tags: Optional[List[str]] = Field(
        None,
        description='A list of tags to be attached to the newly created run. These tags are passed through directly to WandB. Some\ndefault tags are generated by OpenAI: "openai/finetune", "openai/{base-model}", "openai/{ftjob-abcdef}".\n',
    )


class Integration(BaseModel):
    type: Type10 = Field(
        ...,
        description='The type of integration to enable. Currently, only "wandb" (Weights and Biases) is supported.\n',
    )
    wandb: Wandb = Field(
        ...,
        description='The settings for your integration with Weights and Biases. This payload specifies the project that\nmetrics will be sent to. Optionally, you can set an explicit display name for your run, add tags\nto your run, and set a default entity (team, username, etc) to be associated with your run.\n',
    )


class CreateFineTuningJobRequest(BaseModel):
    model: Union[str, Model7] = Field(
        ...,
        description='The name of the model to fine-tune. You can select one of the\n[supported models](/docs/guides/fine-tuning/which-models-can-be-fine-tuned).\n',
        examples=['gpt-4o-mini'],
    )
    training_file: str = Field(
        ...,
        description='The ID of an uploaded file that contains training data.\n\nSee [upload file](/docs/api-reference/files/create) for how to upload a file.\n\nYour dataset must be formatted as a JSONL file. Additionally, you must upload your file with the purpose `fine-tune`.\n\nThe contents of the file should differ depending on if the model uses the [chat](/docs/api-reference/fine-tuning/chat-input) or [completions](/docs/api-reference/fine-tuning/completions-input) format.\n\nSee the [fine-tuning guide](/docs/guides/fine-tuning) for more details.\n',
        examples=['file-abc123'],
    )
    hyperparameters: Optional[Hyperparameters] = Field(
        None, description='The hyperparameters used for the fine-tuning job.'
    )
    suffix: Optional[constr(min_length=1, max_length=40)] = Field(
        None,
        description='A string of up to 18 characters that will be added to your fine-tuned model name.\n\nFor example, a `suffix` of "custom-model-name" would produce a model name like `ft:gpt-4o-mini:openai:custom-model-name:7p4lURel`.\n',
    )
    validation_file: Optional[str] = Field(
        None,
        description='The ID of an uploaded file that contains validation data.\n\nIf you provide this file, the data is used to generate validation\nmetrics periodically during fine-tuning. These metrics can be viewed in\nthe fine-tuning results file.\nThe same data should not be present in both train and validation files.\n\nYour dataset must be formatted as a JSONL file. You must upload your file with the purpose `fine-tune`.\n\nSee the [fine-tuning guide](/docs/guides/fine-tuning) for more details.\n',
        examples=['file-abc123'],
    )
    integrations: Optional[List[Integration]] = Field(
        None, description='A list of integrations to enable for your fine-tuning job.'
    )
    seed: Optional[conint(ge=0, le=2147483647)] = Field(
        None,
        description='The seed controls the reproducibility of the job. Passing in the same seed and job parameters should produce the same results, but may differ in rare cases.\nIf a seed is not specified, one will be generated for you.\n',
        examples=[42],
    )


class InputItem(PromptItem):
    pass


class Model8(Enum):
    text_embedding_ada_002 = 'text-embedding-ada-002'
    text_embedding_3_small = 'text-embedding-3-small'
    text_embedding_3_large = 'text-embedding-3-large'


class EncodingFormat(Enum):
    float = 'float'
    base64 = 'base64'


class CreateEmbeddingRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    input: Union[str, List[str], List[int], List[InputItem]] = Field(
        ...,
        description='Input text to embed, encoded as a string or array of tokens. To embed multiple inputs in a single request, pass an array of strings or array of token arrays. The input must not exceed the max input tokens for the model (8192 tokens for `text-embedding-ada-002`), cannot be an empty string, and any array must be 2048 dimensions or less. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.\n',
        examples=['The quick brown fox jumped over the lazy dog'],
    )
    model: Union[str, Model8] = Field(
        ...,
        description='ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.\n',
        examples=['text-embedding-3-small'],
    )
    encoding_format: Optional[EncodingFormat] = Field(
        'float',
        description='The format to return the embeddings in. Can be either `float` or [`base64`](https://pypi.org/project/pybase64/).',
        examples=['float'],
    )
    dimensions: Optional[conint(ge=1)] = Field(
        None,
        description='The number of dimensions the resulting output embeddings should have. Only supported in `text-embedding-3` and later models.\n',
    )
    user: Optional[str] = Field(
        None,
        description='A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).\n',
        examples=['user-1234'],
    )


class Usage1(BaseModel):
    prompt_tokens: int = Field(
        ..., description='The number of tokens used by the prompt.'
    )
    total_tokens: int = Field(
        ..., description='The total number of tokens used by the request.'
    )


class Model9(Enum):
    whisper_1 = 'whisper-1'


class ResponseFormat3(Enum):
    json = 'json'
    text = 'text'
    srt = 'srt'
    verbose_json = 'verbose_json'
    vtt = 'vtt'


class TimestampGranularity(Enum):
    word = 'word'
    segment = 'segment'


class CreateTranscriptionRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    file: bytes = Field(
        ...,
        description='The audio file object (not file name) to transcribe, in one of these formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.\n',
    )
    model: Union[str, Model9] = Field(
        ...,
        description='ID of the model to use. Only `whisper-1` (which is powered by our open source Whisper V2 model) is currently available.\n',
        examples=['whisper-1'],
    )
    language: Optional[str] = Field(
        None,
        description='The language of the input audio. Supplying the input language in [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) format will improve accuracy and latency.\n',
    )
    prompt: Optional[str] = Field(
        None,
        description="An optional text to guide the model's style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text/prompting) should match the audio language.\n",
    )
    response_format: Optional[ResponseFormat3] = Field(
        'json',
        description='The format of the transcript output, in one of these options: `json`, `text`, `srt`, `verbose_json`, or `vtt`.\n',
    )
    temperature: Optional[float] = Field(
        0,
        description='The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.\n',
    )
    timestamp_granularities__: Optional[List[TimestampGranularity]] = Field(
        ['segment'],
        alias='timestamp_granularities[]',
        description='The timestamp granularities to populate for this transcription. `response_format` must be set `verbose_json` to use timestamp granularities. Either or both of these options are supported: `word`, or `segment`. Note: There is no additional latency for segment timestamps, but generating word timestamps incurs additional latency.\n',
    )


class CreateTranscriptionResponseJson(BaseModel):
    text: str = Field(..., description='The transcribed text.')


class TranscriptionSegment(BaseModel):
    id: int = Field(..., description='Unique identifier of the segment.')
    seek: int = Field(..., description='Seek offset of the segment.')
    start: float = Field(..., description='Start time of the segment in seconds.')
    end: float = Field(..., description='End time of the segment in seconds.')
    text: str = Field(..., description='Text content of the segment.')
    tokens: List[int] = Field(
        ..., description='Array of token IDs for the text content.'
    )
    temperature: float = Field(
        ..., description='Temperature parameter used for generating the segment.'
    )
    avg_logprob: float = Field(
        ...,
        description='Average logprob of the segment. If the value is lower than -1, consider the logprobs failed.',
    )
    compression_ratio: float = Field(
        ...,
        description='Compression ratio of the segment. If the value is greater than 2.4, consider the compression failed.',
    )
    no_speech_prob: float = Field(
        ...,
        description='Probability of no speech in the segment. If the value is higher than 1.0 and the `avg_logprob` is below -1, consider this segment silent.',
    )


class TranscriptionWord(BaseModel):
    word: str = Field(..., description='The text content of the word.')
    start: float = Field(..., description='Start time of the word in seconds.')
    end: float = Field(..., description='End time of the word in seconds.')


class CreateTranscriptionResponseVerboseJson(BaseModel):
    language: str = Field(..., description='The language of the input audio.')
    duration: str = Field(..., description='The duration of the input audio.')
    text: str = Field(..., description='The transcribed text.')
    words: Optional[List[TranscriptionWord]] = Field(
        None, description='Extracted words and their corresponding timestamps.'
    )
    segments: Optional[List[TranscriptionSegment]] = Field(
        None,
        description='Segments of the transcribed text and their corresponding details.',
    )


class CreateTranslationRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    file: bytes = Field(
        ...,
        description='The audio file object (not file name) translate, in one of these formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm.\n',
    )
    model: Union[str, Model9] = Field(
        ...,
        description='ID of the model to use. Only `whisper-1` (which is powered by our open source Whisper V2 model) is currently available.\n',
        examples=['whisper-1'],
    )
    prompt: Optional[str] = Field(
        None,
        description="An optional text to guide the model's style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text/prompting) should be in English.\n",
    )
    response_format: Optional[str] = Field(
        'json',
        description='The format of the transcript output, in one of these options: `json`, `text`, `srt`, `verbose_json`, or `vtt`.\n',
    )
    temperature: Optional[float] = Field(
        0,
        description='The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.\n',
    )


class CreateTranslationResponseJson(BaseModel):
    text: str


class CreateTranslationResponseVerboseJson(BaseModel):
    language: str = Field(
        ..., description='The language of the output translation (always `english`).'
    )
    duration: str = Field(..., description='The duration of the input audio.')
    text: str = Field(..., description='The translated text.')
    segments: Optional[List[TranscriptionSegment]] = Field(
        None,
        description='Segments of the translated text and their corresponding details.',
    )


class Model11(Enum):
    tts_1 = 'tts-1'
    tts_1_hd = 'tts-1-hd'


class Voice(Enum):
    alloy = 'alloy'
    echo = 'echo'
    fable = 'fable'
    onyx = 'onyx'
    nova = 'nova'
    shimmer = 'shimmer'


class ResponseFormat4(Enum):
    mp3 = 'mp3'
    opus = 'opus'
    aac = 'aac'
    flac = 'flac'
    wav = 'wav'
    pcm = 'pcm'


class CreateSpeechRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    model: Union[str, Model11] = Field(
        ...,
        description='One of the available [TTS models](/docs/models/tts): `tts-1` or `tts-1-hd`\n',
    )
    input: constr(max_length=4096) = Field(
        ...,
        description='The text to generate audio for. The maximum length is 4096 characters.',
    )
    voice: Voice = Field(
        ...,
        description='The voice to use when generating the audio. Supported voices are `alloy`, `echo`, `fable`, `onyx`, `nova`, and `shimmer`. Previews of the voices are available in the [Text to speech guide](/docs/guides/text-to-speech/voice-options).',
    )
    response_format: Optional[ResponseFormat4] = Field(
        'mp3',
        description='The format to audio in. Supported formats are `mp3`, `opus`, `aac`, `flac`, `wav`, and `pcm`.',
    )
    speed: Optional[confloat(ge=0.25, le=4.0)] = Field(
        1.0,
        description='The speed of the generated audio. Select a value from `0.25` to `4.0`. `1.0` is the default.',
    )


class Object11(Enum):
    model = 'model'


class Model(BaseModel):
    id: str = Field(
        ...,
        description='The model identifier, which can be referenced in the API endpoints.',
    )
    created: int = Field(
        ..., description='The Unix timestamp (in seconds) when the model was created.'
    )
    object: Object11 = Field(
        ..., description='The object type, which is always "model".'
    )
    owned_by: str = Field(..., description='The organization that owns the model.')


class Purpose2(Enum):
    assistants = 'assistants'
    assistants_output = 'assistants_output'
    batch = 'batch'
    batch_output = 'batch_output'
    fine_tune = 'fine-tune'
    fine_tune_results = 'fine-tune-results'
    vision = 'vision'


class Status(Enum):
    uploaded = 'uploaded'
    processed = 'processed'
    error = 'error'


class OpenAIFile(BaseModel):
    id: str = Field(
        ...,
        description='The file identifier, which can be referenced in the API endpoints.',
    )
    bytes: int = Field(..., description='The size of the file, in bytes.')
    created_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the file was created.',
    )
    filename: str = Field(..., description='The name of the file.')
    object: Object7 = Field(..., description='The object type, which is always `file`.')
    purpose: Purpose2 = Field(
        ...,
        description='The intended purpose of the file. Supported values are `assistants`, `assistants_output`, `batch`, `batch_output`, `fine-tune`, `fine-tune-results` and `vision`.',
    )
    status: Status = Field(
        ...,
        description='Deprecated. The current status of the file, which can be either `uploaded`, `processed`, or `error`.',
    )
    status_details: Optional[str] = Field(
        None,
        description='Deprecated. For details on why a fine-tuning training file failed validation, see the `error` field on `fine_tuning.job`.',
    )


class Status1(Enum):
    pending = 'pending'
    completed = 'completed'
    cancelled = 'cancelled'
    expired = 'expired'


class Object13(Enum):
    upload = 'upload'


class Upload(BaseModel):
    id: str = Field(
        ...,
        description='The Upload unique identifier, which can be referenced in API endpoints.',
    )
    created_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the Upload was created.',
    )
    filename: str = Field(..., description='The name of the file to be uploaded.')
    bytes: int = Field(..., description='The intended number of bytes to be uploaded.')
    purpose: str = Field(
        ...,
        description='The intended purpose of the file. [Please refer here](/docs/api-reference/files/object#files/object-purpose) for acceptable values.',
    )
    status: Status1 = Field(..., description='The status of the Upload.')
    expires_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the Upload was created.',
    )
    object: Optional[Object13] = Field(
        None, description='The object type, which is always "upload".'
    )
    file: Optional[OpenAIFile] = Field(
        None, description='The ready File object after the Upload is completed.'
    )


class Object14(Enum):
    upload_part = 'upload.part'


class UploadPart(BaseModel):
    id: str = Field(
        ...,
        description='The upload Part unique identifier, which can be referenced in API endpoints.',
    )
    created_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the Part was created.',
    )
    upload_id: str = Field(
        ..., description='The ID of the Upload object that this Part was added to.'
    )
    object: Object14 = Field(
        ..., description='The object type, which is always `upload.part`.'
    )


class Object15(Enum):
    embedding = 'embedding'


class Embedding(BaseModel):
    index: int = Field(
        ..., description='The index of the embedding in the list of embeddings.'
    )
    embedding: List[float] = Field(
        ...,
        description='The embedding vector, which is a list of floats. The length of vector depends on the model as listed in the [embedding guide](/docs/guides/embeddings).\n',
    )
    object: Object15 = Field(
        ..., description='The object type, which is always "embedding".'
    )


class Error1(BaseModel):
    code: str = Field(..., description='A machine-readable error code.')
    message: str = Field(..., description='A human-readable error message.')
    param: str = Field(
        ...,
        description='The parameter that was invalid, usually `training_file` or `validation_file`. This field will be null if the failure was not parameter-specific.',
    )


class Hyperparameters1(BaseModel):
    n_epochs: Union[BatchSize, conint(ge=1, le=50)] = Field(
        ...,
        description='The number of epochs to train the model for. An epoch refers to one full cycle through the training dataset.\n"auto" decides the optimal number of epochs based on the size of the dataset. If setting the number manually, we support any number between 1 and 50 epochs.',
    )


class Object16(Enum):
    fine_tuning_job = 'fine_tuning.job'


class Status2(Enum):
    validating_files = 'validating_files'
    queued = 'queued'
    running = 'running'
    succeeded = 'succeeded'
    failed = 'failed'
    cancelled = 'cancelled'


class FineTuningIntegration(BaseModel):
    type: Type10 = Field(
        ...,
        description='The type of the integration being enabled for the fine-tuning job',
    )
    wandb: Wandb = Field(
        ...,
        description='The settings for your integration with Weights and Biases. This payload specifies the project that\nmetrics will be sent to. Optionally, you can set an explicit display name for your run, add tags\nto your run, and set a default entity (team, username, etc) to be associated with your run.\n',
    )


class Level(Enum):
    info = 'info'
    warn = 'warn'
    error = 'error'


class Object17(Enum):
    fine_tuning_job_event = 'fine_tuning.job.event'


class FineTuningJobEvent(BaseModel):
    id: str
    created_at: int
    level: Level
    message: str
    object: Object17


class Metrics(BaseModel):
    step: Optional[float] = None
    train_loss: Optional[float] = None
    train_mean_token_accuracy: Optional[float] = None
    valid_loss: Optional[float] = None
    valid_mean_token_accuracy: Optional[float] = None
    full_valid_loss: Optional[float] = None
    full_valid_mean_token_accuracy: Optional[float] = None


class Object18(Enum):
    fine_tuning_job_checkpoint = 'fine_tuning.job.checkpoint'


class FineTuningJobCheckpoint(BaseModel):
    id: str = Field(
        ...,
        description='The checkpoint identifier, which can be referenced in the API endpoints.',
    )
    created_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the checkpoint was created.',
    )
    fine_tuned_model_checkpoint: str = Field(
        ..., description='The name of the fine-tuned checkpoint model that is created.'
    )
    step_number: int = Field(
        ..., description='The step number that the checkpoint was created at.'
    )
    metrics: Metrics = Field(
        ..., description='Metrics at the step number during the fine-tuning job.'
    )
    fine_tuning_job_id: str = Field(
        ...,
        description='The name of the fine-tuning job that this checkpoint was created from.',
    )
    object: Object18 = Field(
        ...,
        description='The object type, which is always "fine_tuning.job.checkpoint".',
    )


class FinetuneCompletionRequestInput(BaseModel):
    prompt: Optional[str] = Field(
        None, description='The input prompt for this training example.'
    )
    completion: Optional[str] = Field(
        None, description='The desired completion for this training example.'
    )


class CompletionUsage(Usage):
    pass


class RunCompletionUsage(BaseModel):
    completion_tokens: int = Field(
        ..., description='Number of completion tokens used over the course of the run.'
    )
    prompt_tokens: int = Field(
        ..., description='Number of prompt tokens used over the course of the run.'
    )
    total_tokens: int = Field(
        ..., description='Total number of tokens used (prompt + completion).'
    )


class RunStepCompletionUsage(BaseModel):
    completion_tokens: int = Field(
        ...,
        description='Number of completion tokens used over the course of the run step.',
    )
    prompt_tokens: int = Field(
        ..., description='Number of prompt tokens used over the course of the run step.'
    )
    total_tokens: int = Field(
        ..., description='Total number of tokens used (prompt + completion).'
    )


class AssistantsApiResponseFormatOption(
    RootModel[
        Union[
            BatchSize,
            ResponseFormatText,
            ResponseFormatJsonObject,
            ResponseFormatJsonSchema,
        ]
    ]
):
    root: Union[
        BatchSize,
        ResponseFormatText,
        ResponseFormatJsonObject,
        ResponseFormatJsonSchema,
    ] = Field(
        ...,
        description='Specifies the format that the model must output. Compatible with [GPT-4o](/docs/models/gpt-4o), [GPT-4 Turbo](/docs/models/gpt-4-turbo-and-gpt-4), and all GPT-3.5 Turbo models since `gpt-3.5-turbo-1106`.\n\nSetting to `{ "type": "json_schema", "json_schema": {...} }` enables Structured Outputs which guarantees the model will match your supplied JSON schema. Learn more in the [Structured Outputs guide](/docs/guides/structured-outputs).\n\nSetting to `{ "type": "json_object" }` enables JSON mode, which guarantees the message the model generates is valid JSON.\n\n**Important:** when using JSON mode, you **must** also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly "stuck" request. Also note that the message content may be partially cut off if `finish_reason="length"`, which indicates the generation exceeded `max_tokens` or the conversation exceeded the max context length.\n',
    )


class CodeInterpreter(BaseModel):
    file_ids: Optional[List[str]] = Field(
        [],
        description='A list of [file](/docs/api-reference/files) IDs made available to the `code_interpreter`` tool. There can be a maximum of 20 files associated with the tool.\n',
        max_length=20,
    )


class FileSearch(BaseModel):
    vector_store_ids: Optional[List[str]] = Field(
        None,
        description='The ID of the [vector store](/docs/api-reference/vector-stores/object) attached to this assistant. There can be a maximum of 1 vector store attached to the assistant.\n',
        max_length=1,
    )


class ToolResources(BaseModel):
    code_interpreter: Optional[CodeInterpreter] = None
    file_search: Optional[FileSearch] = None


class Model12(Enum):
    gpt_4o = 'gpt-4o'
    gpt_4o_2024_08_06 = 'gpt-4o-2024-08-06'
    gpt_4o_2024_05_13 = 'gpt-4o-2024-05-13'
    gpt_4o_2024_08_06_1 = 'gpt-4o-2024-08-06'
    gpt_4o_mini = 'gpt-4o-mini'
    gpt_4o_mini_2024_07_18 = 'gpt-4o-mini-2024-07-18'
    gpt_4_turbo = 'gpt-4-turbo'
    gpt_4_turbo_2024_04_09 = 'gpt-4-turbo-2024-04-09'
    gpt_4_0125_preview = 'gpt-4-0125-preview'
    gpt_4_turbo_preview = 'gpt-4-turbo-preview'
    gpt_4_1106_preview = 'gpt-4-1106-preview'
    gpt_4_vision_preview = 'gpt-4-vision-preview'
    gpt_4 = 'gpt-4'
    gpt_4_0314 = 'gpt-4-0314'
    gpt_4_0613 = 'gpt-4-0613'
    gpt_4_32k = 'gpt-4-32k'
    gpt_4_32k_0314 = 'gpt-4-32k-0314'
    gpt_4_32k_0613 = 'gpt-4-32k-0613'
    gpt_3_5_turbo = 'gpt-3.5-turbo'
    gpt_3_5_turbo_16k = 'gpt-3.5-turbo-16k'
    gpt_3_5_turbo_0613 = 'gpt-3.5-turbo-0613'
    gpt_3_5_turbo_1106 = 'gpt-3.5-turbo-1106'
    gpt_3_5_turbo_0125 = 'gpt-3.5-turbo-0125'
    gpt_3_5_turbo_16k_0613 = 'gpt-3.5-turbo-16k-0613'


class CodeInterpreter1(BaseModel):
    file_ids: Optional[List[str]] = Field(
        [],
        description='A list of [file](/docs/api-reference/files) IDs made available to the `code_interpreter` tool. There can be a maximum of 20 files associated with the tool.\n',
        max_length=20,
    )


class ChunkingStrategy(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: BatchSize = Field(..., description='Always `auto`.')


class Type13(Enum):
    static = 'static'


class Static(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    max_chunk_size_tokens: conint(ge=100, le=4096) = Field(
        ...,
        description='The maximum number of tokens in each chunk. The default value is `800`. The minimum value is `100` and the maximum value is `4096`.',
    )
    chunk_overlap_tokens: int = Field(
        ...,
        description='The number of tokens that overlap between chunks. The default value is `400`.\n\nNote that the overlap must not exceed half of `max_chunk_size_tokens`.\n',
    )


class ChunkingStrategy1(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type13 = Field(..., description='Always `static`.')
    static: Static


class VectorStore(BaseModel):
    file_ids: Optional[List[str]] = Field(
        None,
        description='A list of [file](/docs/api-reference/files) IDs to add to the vector store. There can be a maximum of 10000 files in a vector store.\n',
        max_length=10000,
    )
    chunking_strategy: Optional[Union[ChunkingStrategy, ChunkingStrategy1]] = Field(
        None,
        description='The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.',
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description='Set of 16 key-value pairs that can be attached to a vector store. This can be useful for storing additional information about the vector store in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )


class FileSearch1(BaseModel):
    vector_store_ids: List[str] = Field(
        ...,
        description='The [vector store](/docs/api-reference/vector-stores/object) attached to this assistant. There can be a maximum of 1 vector store attached to the assistant.\n',
        max_length=1,
    )
    vector_stores: Optional[List[VectorStore]] = Field(
        None,
        description='A helper to create a [vector store](/docs/api-reference/vector-stores/object) with file_ids and attach it to this assistant. There can be a maximum of 1 vector store attached to the assistant.\n',
        max_length=1,
    )


class ChunkingStrategy2(ChunkingStrategy):
    pass


class ChunkingStrategy3(ChunkingStrategy1):
    pass


class VectorStore1(BaseModel):
    file_ids: Optional[List[str]] = Field(
        None,
        description='A list of [file](/docs/api-reference/files) IDs to add to the vector store. There can be a maximum of 10000 files in a vector store.\n',
        max_length=10000,
    )
    chunking_strategy: Optional[Union[ChunkingStrategy2, ChunkingStrategy3]] = Field(
        None,
        description='The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.',
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description='Set of 16 key-value pairs that can be attached to a vector store. This can be useful for storing additional information about the vector store in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )


class FileSearch2(BaseModel):
    vector_store_ids: Optional[List[str]] = Field(
        None,
        description='The [vector store](/docs/api-reference/vector-stores/object) attached to this assistant. There can be a maximum of 1 vector store attached to the assistant.\n',
        max_length=1,
    )
    vector_stores: List[VectorStore1] = Field(
        ...,
        description='A helper to create a [vector store](/docs/api-reference/vector-stores/object) with file_ids and attach it to this assistant. There can be a maximum of 1 vector store attached to the assistant.\n',
        max_length=1,
    )


class ToolResources1(BaseModel):
    code_interpreter: Optional[CodeInterpreter1] = None
    file_search: Optional[Union[FileSearch1, FileSearch2]] = None


class CodeInterpreter2(BaseModel):
    file_ids: Optional[List[str]] = Field(
        [],
        description='Overrides the list of [file](/docs/api-reference/files) IDs made available to the `code_interpreter` tool. There can be a maximum of 20 files associated with the tool.\n',
        max_length=20,
    )


class FileSearch3(BaseModel):
    vector_store_ids: Optional[List[str]] = Field(
        None,
        description='Overrides the [vector store](/docs/api-reference/vector-stores/object) attached to this assistant. There can be a maximum of 1 vector store attached to the assistant.\n',
        max_length=1,
    )


class ToolResources2(BaseModel):
    code_interpreter: Optional[CodeInterpreter2] = None
    file_search: Optional[FileSearch3] = None


class Object20(Enum):
    assistant_deleted = 'assistant.deleted'


class DeleteAssistantResponse(BaseModel):
    id: str
    deleted: bool
    object: Object20


class Type16(Enum):
    code_interpreter = 'code_interpreter'


class AssistantToolsCode(BaseModel):
    type: Type16 = Field(
        ..., description='The type of tool being defined: `code_interpreter`'
    )


class Type17(Enum):
    file_search = 'file_search'


class Ranker(Enum):
    auto = 'auto'
    default_2024_08_21 = 'default_2024_08_21'


class FileSearchRankingOptions(BaseModel):
    ranker: Optional[Ranker] = Field(
        None,
        description='The ranker to use for the file search. If not specified will use the `auto` ranker.',
    )
    score_threshold: Optional[confloat(ge=0.0, le=1.0)] = Field(
        None,
        description='The score threshold for the file search. All values must be a floating point number between 0 and 1.',
    )


class AssistantToolsFileSearchTypeOnly(BaseModel):
    type: Type17 = Field(
        ..., description='The type of tool being defined: `file_search`'
    )


class AssistantToolsFunction(BaseModel):
    type: Role4 = Field(..., description='The type of tool being defined: `function`')
    function: FunctionObject


class Type20(Enum):
    auto = 'auto'
    last_messages = 'last_messages'


class TruncationObject(BaseModel):
    type: Type20 = Field(
        ...,
        description='The truncation strategy to use for the thread. The default is `auto`. If set to `last_messages`, the thread will be truncated to the n most recent messages in the thread. When set to `auto`, messages in the middle of the thread will be dropped to fit the context length of the model, `max_prompt_tokens`.',
    )
    last_messages: Optional[conint(ge=1)] = Field(
        None,
        description='The number of most recent messages from the thread when constructing the context for the run.',
    )


class Type21(Enum):
    function = 'function'
    code_interpreter = 'code_interpreter'
    file_search = 'file_search'


class Function3(ChatCompletionFunctionCallOption):
    pass


class AssistantsNamedToolChoice(BaseModel):
    type: Type21 = Field(
        ...,
        description='The type of the tool. If type is `function`, the function name must be set',
    )
    function: Optional[Function3] = None


class Object21(Enum):
    thread_run = 'thread.run'


class Status3(Enum):
    queued = 'queued'
    in_progress = 'in_progress'
    requires_action = 'requires_action'
    cancelling = 'cancelling'
    cancelled = 'cancelled'
    failed = 'failed'
    completed = 'completed'
    incomplete = 'incomplete'
    expired = 'expired'


class Type22(Enum):
    submit_tool_outputs = 'submit_tool_outputs'


class Code(Enum):
    server_error = 'server_error'
    rate_limit_exceeded = 'rate_limit_exceeded'
    invalid_prompt = 'invalid_prompt'


class LastError(BaseModel):
    code: Code = Field(
        ...,
        description='One of `server_error`, `rate_limit_exceeded`, or `invalid_prompt`.',
    )
    message: str = Field(..., description='A human-readable description of the error.')


class Reason(Enum):
    max_completion_tokens = 'max_completion_tokens'
    max_prompt_tokens = 'max_prompt_tokens'


class IncompleteDetails(BaseModel):
    reason: Optional[Reason] = Field(
        None,
        description='The reason why the run is incomplete. This will point to which specific token limit was reached over the course of the run.',
    )


class ModifyRunRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )


class ToolOutput(BaseModel):
    tool_call_id: Optional[str] = Field(
        None,
        description='The ID of the tool call in the `required_action` object within the run object the output is being submitted for.',
    )
    output: Optional[str] = Field(
        None,
        description='The output of the tool call to be submitted to continue the run.',
    )


class SubmitToolOutputsRunRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    tool_outputs: List[ToolOutput] = Field(
        ..., description='A list of tools for which the outputs are being submitted.'
    )
    stream: Optional[bool] = Field(
        None,
        description='If `true`, returns a stream of events that happen during the Run as server-sent events, terminating when the Run enters a terminal state with a `data: [DONE]` message.\n',
    )


class Function4(BaseModel):
    name: str = Field(..., description='The name of the function.')
    arguments: str = Field(
        ...,
        description='The arguments that the model expects you to pass to the function.',
    )


class RunToolCallObject(BaseModel):
    id: str = Field(
        ...,
        description='The ID of the tool call. This ID must be referenced when you submit the tool outputs in using the [Submit tool outputs to run](/docs/api-reference/runs/submitToolOutputs) endpoint.',
    )
    type: Role4 = Field(
        ...,
        description='The type of tool call the output is required for. For now, this is always `function`.',
    )
    function: Function4 = Field(..., description='The function definition.')


class CodeInterpreter3(CodeInterpreter1):
    pass


class FileSearch5(FileSearch):
    pass


class ToolResources3(BaseModel):
    code_interpreter: Optional[CodeInterpreter3] = None
    file_search: Optional[FileSearch5] = None


class Object22(Enum):
    thread = 'thread'


class FileSearch6(BaseModel):
    vector_store_ids: Optional[List[str]] = Field(
        None,
        description='The [vector store](/docs/api-reference/vector-stores/object) attached to this thread. There can be a maximum of 1 vector store attached to the thread.\n',
        max_length=1,
    )


class ToolResources4(BaseModel):
    code_interpreter: Optional[CodeInterpreter3] = None
    file_search: Optional[FileSearch6] = None


class ThreadObject(BaseModel):
    id: str = Field(
        ..., description='The identifier, which can be referenced in API endpoints.'
    )
    object: Object22 = Field(
        ..., description='The object type, which is always `thread`.'
    )
    created_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the thread was created.',
    )
    tool_resources: ToolResources4 = Field(
        ...,
        description="A set of resources that are made available to the assistant's tools in this thread. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.\n",
    )
    metadata: Dict[str, Any] = Field(
        ...,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )


class ChunkingStrategy4(ChunkingStrategy):
    pass


class ChunkingStrategy5(ChunkingStrategy1):
    pass


class VectorStore2(BaseModel):
    file_ids: Optional[List[str]] = Field(
        None,
        description='A list of [file](/docs/api-reference/files) IDs to add to the vector store. There can be a maximum of 10000 files in a vector store.\n',
        max_length=10000,
    )
    chunking_strategy: Optional[Union[ChunkingStrategy4, ChunkingStrategy5]] = Field(
        None,
        description='The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.',
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description='Set of 16 key-value pairs that can be attached to a vector store. This can be useful for storing additional information about the vector store in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )


class FileSearch7(BaseModel):
    vector_store_ids: List[str] = Field(
        ...,
        description='The [vector store](/docs/api-reference/vector-stores/object) attached to this thread. There can be a maximum of 1 vector store attached to the thread.\n',
        max_length=1,
    )
    vector_stores: Optional[List[VectorStore2]] = Field(
        None,
        description='A helper to create a [vector store](/docs/api-reference/vector-stores/object) with file_ids and attach it to this thread. There can be a maximum of 1 vector store attached to the thread.\n',
        max_length=1,
    )


class ChunkingStrategy6(ChunkingStrategy):
    pass


class ChunkingStrategy7(ChunkingStrategy1):
    pass


class VectorStore3(BaseModel):
    file_ids: Optional[List[str]] = Field(
        None,
        description='A list of [file](/docs/api-reference/files) IDs to add to the vector store. There can be a maximum of 10000 files in a vector store.\n',
        max_length=10000,
    )
    chunking_strategy: Optional[Union[ChunkingStrategy6, ChunkingStrategy7]] = Field(
        None,
        description='The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.',
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description='Set of 16 key-value pairs that can be attached to a vector store. This can be useful for storing additional information about the vector store in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )


class FileSearch8(BaseModel):
    vector_store_ids: Optional[List[str]] = Field(
        None,
        description='The [vector store](/docs/api-reference/vector-stores/object) attached to this thread. There can be a maximum of 1 vector store attached to the thread.\n',
        max_length=1,
    )
    vector_stores: List[VectorStore3] = Field(
        ...,
        description='A helper to create a [vector store](/docs/api-reference/vector-stores/object) with file_ids and attach it to this thread. There can be a maximum of 1 vector store attached to the thread.\n',
        max_length=1,
    )


class ToolResources5(BaseModel):
    code_interpreter: Optional[CodeInterpreter3] = None
    file_search: Optional[Union[FileSearch7, FileSearch8]] = None


class FileSearch9(FileSearch6):
    pass


class ToolResources6(BaseModel):
    code_interpreter: Optional[CodeInterpreter3] = None
    file_search: Optional[FileSearch9] = None


class ModifyThreadRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    tool_resources: Optional[ToolResources6] = Field(
        None,
        description="A set of resources that are made available to the assistant's tools in this thread. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.\n",
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )


class Object23(Enum):
    thread_deleted = 'thread.deleted'


class DeleteThreadResponse(BaseModel):
    id: str
    deleted: bool
    object: Object23


class ListThreadsResponse(BaseModel):
    object: str = Field(..., examples=['list'])
    data: List[ThreadObject]
    first_id: str = Field(..., examples=['asst_abc123'])
    last_id: str = Field(..., examples=['asst_abc456'])
    has_more: bool = Field(..., examples=[False])


class Object24(Enum):
    thread_message = 'thread.message'


class Status4(Enum):
    in_progress = 'in_progress'
    incomplete = 'incomplete'
    completed = 'completed'


class Reason1(Enum):
    content_filter = 'content_filter'
    max_tokens = 'max_tokens'
    run_cancelled = 'run_cancelled'
    run_expired = 'run_expired'
    run_failed = 'run_failed'


class IncompleteDetails1(BaseModel):
    reason: Reason1 = Field(..., description='The reason the message is incomplete.')


class Role7(Enum):
    user = 'user'
    assistant = 'assistant'


class Attachment(BaseModel):
    file_id: Optional[str] = Field(
        None, description='The ID of the file to attach to the message.'
    )
    tools: Optional[
        List[Union[AssistantToolsCode, AssistantToolsFileSearchTypeOnly]]
    ] = Field(None, description='The tools to add this file to.')


class Object25(Enum):
    thread_message_delta = 'thread.message.delta'


class ModifyMessageRequest(ModifyRunRequest):
    pass


class Object26(Enum):
    thread_message_deleted = 'thread.message.deleted'


class DeleteMessageResponse(BaseModel):
    id: str
    deleted: bool
    object: Object26


class Type28(Enum):
    image_file = 'image_file'


class ImageFile(BaseModel):
    file_id: str = Field(
        ...,
        description='The [File](/docs/api-reference/files) ID of the image in the message content. Set `purpose="vision"` when uploading the File if you need to later display the file content.',
    )
    detail: Optional[Detail] = Field(
        'auto',
        description='Specifies the detail level of the image if specified by the user. `low` uses fewer tokens, you can opt in to high resolution using `high`.',
    )


class MessageContentImageFileObject(BaseModel):
    type: Type28 = Field(..., description='Always `image_file`.')
    image_file: ImageFile


class ImageFile1(BaseModel):
    file_id: Optional[str] = Field(
        None,
        description='The [File](/docs/api-reference/files) ID of the image in the message content. Set `purpose="vision"` when uploading the File if you need to later display the file content.',
    )
    detail: Optional[Detail] = Field(
        'auto',
        description='Specifies the detail level of the image if specified by the user. `low` uses fewer tokens, you can opt in to high resolution using `high`.',
    )


class MessageDeltaContentImageFileObject(BaseModel):
    index: int = Field(..., description='The index of the content part in the message.')
    type: Type28 = Field(..., description='Always `image_file`.')
    image_file: Optional[ImageFile1] = None


class ImageUrl1(BaseModel):
    url: AnyUrl = Field(
        ...,
        description='The external URL of the image, must be a supported image types: jpeg, jpg, png, gif, webp.',
    )
    detail: Optional[Detail] = Field(
        'auto',
        description='Specifies the detail level of the image. `low` uses fewer tokens, you can opt in to high resolution using `high`. Default value is `auto`',
    )


class MessageContentImageUrlObject(BaseModel):
    type: Type1 = Field(..., description='The type of the content part.')
    image_url: ImageUrl1


class ImageUrl2(BaseModel):
    url: Optional[str] = Field(
        None,
        description='The URL of the image, must be a supported image types: jpeg, jpg, png, gif, webp.',
    )
    detail: Optional[Detail] = Field(
        'auto',
        description='Specifies the detail level of the image. `low` uses fewer tokens, you can opt in to high resolution using `high`.',
    )


class MessageDeltaContentImageUrlObject(BaseModel):
    index: int = Field(..., description='The index of the content part in the message.')
    type: Type1 = Field(..., description='Always `image_url`.')
    image_url: Optional[ImageUrl2] = None


class MessageContentRefusalObject(BaseModel):
    type: Type2 = Field(..., description='Always `refusal`.')
    refusal: str


class MessageRequestContentTextObject(BaseModel):
    type: Type = Field(..., description='Always `text`.')
    text: str = Field(..., description='Text content to be sent to the model')


class Type35(Enum):
    file_citation = 'file_citation'


class FileCitation(BaseModel):
    file_id: str = Field(
        ..., description='The ID of the specific File the citation is from.'
    )


class MessageContentTextAnnotationsFileCitationObject(BaseModel):
    type: Type35 = Field(..., description='Always `file_citation`.')
    text: str = Field(
        ..., description='The text in the message content that needs to be replaced.'
    )
    file_citation: FileCitation
    start_index: conint(ge=0)
    end_index: conint(ge=0)


class Type36(Enum):
    file_path = 'file_path'


class FilePath(BaseModel):
    file_id: str = Field(..., description='The ID of the file that was generated.')


class MessageContentTextAnnotationsFilePathObject(BaseModel):
    type: Type36 = Field(..., description='Always `file_path`.')
    text: str = Field(
        ..., description='The text in the message content that needs to be replaced.'
    )
    file_path: FilePath
    start_index: conint(ge=0)
    end_index: conint(ge=0)


class MessageDeltaContentRefusalObject(BaseModel):
    index: int = Field(..., description='The index of the refusal part in the message.')
    type: Type2 = Field(..., description='Always `refusal`.')
    refusal: Optional[str] = None


class FileCitation1(BaseModel):
    file_id: Optional[str] = Field(
        None, description='The ID of the specific File the citation is from.'
    )
    quote: Optional[str] = Field(None, description='The specific quote in the file.')


class MessageDeltaContentTextAnnotationsFileCitationObject(BaseModel):
    index: int = Field(
        ..., description='The index of the annotation in the text content part.'
    )
    type: Type35 = Field(..., description='Always `file_citation`.')
    text: Optional[str] = Field(
        None, description='The text in the message content that needs to be replaced.'
    )
    file_citation: Optional[FileCitation1] = None
    start_index: Optional[conint(ge=0)] = None
    end_index: Optional[conint(ge=0)] = None


class FilePath1(BaseModel):
    file_id: Optional[str] = Field(
        None, description='The ID of the file that was generated.'
    )


class MessageDeltaContentTextAnnotationsFilePathObject(BaseModel):
    index: int = Field(
        ..., description='The index of the annotation in the text content part.'
    )
    type: Type36 = Field(..., description='Always `file_path`.')
    text: Optional[str] = Field(
        None, description='The text in the message content that needs to be replaced.'
    )
    file_path: Optional[FilePath1] = None
    start_index: Optional[conint(ge=0)] = None
    end_index: Optional[conint(ge=0)] = None


class Object27(Enum):
    thread_run_step = 'thread.run.step'


class Type41(Enum):
    message_creation = 'message_creation'
    tool_calls = 'tool_calls'


class Status5(Enum):
    in_progress = 'in_progress'
    cancelled = 'cancelled'
    failed = 'failed'
    completed = 'completed'
    expired = 'expired'


class Code1(Enum):
    server_error = 'server_error'
    rate_limit_exceeded = 'rate_limit_exceeded'


class LastError1(BaseModel):
    code: Code1 = Field(
        ..., description='One of `server_error` or `rate_limit_exceeded`.'
    )
    message: str = Field(..., description='A human-readable description of the error.')


class Object28(Enum):
    thread_run_step_delta = 'thread.run.step.delta'


class Type42(Enum):
    message_creation = 'message_creation'


class MessageCreation(BaseModel):
    message_id: str = Field(
        ..., description='The ID of the message that was created by this run step.'
    )


class RunStepDetailsMessageCreationObject(BaseModel):
    type: Type42 = Field(..., description='Always `message_creation`.')
    message_creation: MessageCreation


class MessageCreation1(BaseModel):
    message_id: Optional[str] = Field(
        None, description='The ID of the message that was created by this run step.'
    )


class RunStepDeltaStepDetailsMessageCreationObject(BaseModel):
    type: Type42 = Field(..., description='Always `message_creation`.')
    message_creation: Optional[MessageCreation1] = None


class Type44(Enum):
    tool_calls = 'tool_calls'


class Type48(Enum):
    logs = 'logs'


class RunStepDetailsToolCallsCodeOutputLogsObject(BaseModel):
    type: Type48 = Field(..., description='Always `logs`.')
    logs: str = Field(
        ..., description='The text output from the Code Interpreter tool call.'
    )


class RunStepDeltaStepDetailsToolCallsCodeOutputLogsObject(BaseModel):
    index: int = Field(..., description='The index of the output in the outputs array.')
    type: Type48 = Field(..., description='Always `logs`.')
    logs: Optional[str] = Field(
        None, description='The text output from the Code Interpreter tool call.'
    )


class Type50(Enum):
    image = 'image'


class Image1(BaseModel):
    file_id: str = Field(
        ..., description='The [file](/docs/api-reference/files) ID of the image.'
    )


class RunStepDetailsToolCallsCodeOutputImageObject(BaseModel):
    type: Type50 = Field(..., description='Always `image`.')
    image: Image1


class Image2(BaseModel):
    file_id: Optional[str] = Field(
        None, description='The [file](/docs/api-reference/files) ID of the image.'
    )


class RunStepDeltaStepDetailsToolCallsCodeOutputImageObject(BaseModel):
    index: int = Field(..., description='The index of the output in the outputs array.')
    type: Type50 = Field(..., description='Always `image`.')
    image: Optional[Image2] = None


class Ranker1(Enum):
    default_2024_08_21 = 'default_2024_08_21'


class RunStepDetailsToolCallsFileSearchRankingOptionsObject(BaseModel):
    ranker: Ranker1 = Field(..., description='The ranker used for the file search.')
    score_threshold: confloat(ge=0.0, le=1.0) = Field(
        ...,
        description='The score threshold for the file search. All values must be a floating point number between 0 and 1.',
    )


class ContentItem(BaseModel):
    type: Optional[Type] = Field(None, description='The type of the content.')
    text: Optional[str] = Field(None, description='The text content of the file.')


class RunStepDetailsToolCallsFileSearchResultObject(BaseModel):
    file_id: str = Field(
        ..., description='The ID of the file that result was found in.'
    )
    file_name: str = Field(
        ..., description='The name of the file that result was found in.'
    )
    score: confloat(ge=0.0, le=1.0) = Field(
        ...,
        description='The score of the result. All values must be a floating point number between 0 and 1.',
    )
    content: Optional[List[ContentItem]] = Field(
        None,
        description='The content of the result that was found. The content is only included if requested via the include query parameter.',
    )


class RunStepDeltaStepDetailsToolCallsFileSearchObject(BaseModel):
    index: int = Field(
        ..., description='The index of the tool call in the tool calls array.'
    )
    id: Optional[str] = Field(None, description='The ID of the tool call object.')
    type: Type17 = Field(
        ...,
        description='The type of tool call. This is always going to be `file_search` for this type of tool call.',
    )
    file_search: Dict[str, Any] = Field(
        ..., description='For now, this is always going to be an empty object.'
    )


class Function5(BaseModel):
    name: str = Field(..., description='The name of the function.')
    arguments: str = Field(..., description='The arguments passed to the function.')
    output: str = Field(
        ...,
        description='The output of the function. This will be `null` if the outputs have not been [submitted](/docs/api-reference/runs/submitToolOutputs) yet.',
    )


class RunStepDetailsToolCallsFunctionObject(BaseModel):
    id: str = Field(..., description='The ID of the tool call object.')
    type: Role4 = Field(
        ...,
        description='The type of tool call. This is always going to be `function` for this type of tool call.',
    )
    function: Function5 = Field(
        ..., description='The definition of the function that was called.'
    )


class Function6(BaseModel):
    name: Optional[str] = Field(None, description='The name of the function.')
    arguments: Optional[str] = Field(
        None, description='The arguments passed to the function.'
    )
    output: Optional[str] = Field(
        None,
        description='The output of the function. This will be `null` if the outputs have not been [submitted](/docs/api-reference/runs/submitToolOutputs) yet.',
    )


class RunStepDeltaStepDetailsToolCallsFunctionObject(BaseModel):
    index: int = Field(
        ..., description='The index of the tool call in the tool calls array.'
    )
    id: Optional[str] = Field(None, description='The ID of the tool call object.')
    type: Role4 = Field(
        ...,
        description='The type of tool call. This is always going to be `function` for this type of tool call.',
    )
    function: Optional[Function6] = Field(
        None, description='The definition of the function that was called.'
    )


class Anchor(Enum):
    last_active_at = 'last_active_at'


class VectorStoreExpirationAfter(BaseModel):
    anchor: Anchor = Field(
        ...,
        description='Anchor timestamp after which the expiration policy applies. Supported anchors: `last_active_at`.',
    )
    days: conint(ge=1, le=365) = Field(
        ...,
        description='The number of days after the anchor time that the vector store will expire.',
    )


class Object29(Enum):
    vector_store = 'vector_store'


class FileCounts(BaseModel):
    in_progress: int = Field(
        ..., description='The number of files that are currently being processed.'
    )
    completed: int = Field(
        ..., description='The number of files that have been successfully processed.'
    )
    failed: int = Field(
        ..., description='The number of files that have failed to process.'
    )
    cancelled: int = Field(..., description='The number of files that were cancelled.')
    total: int = Field(..., description='The total number of files.')


class Status6(Enum):
    expired = 'expired'
    in_progress = 'in_progress'
    completed = 'completed'


class VectorStoreObject(BaseModel):
    id: str = Field(
        ..., description='The identifier, which can be referenced in API endpoints.'
    )
    object: Object29 = Field(
        ..., description='The object type, which is always `vector_store`.'
    )
    created_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the vector store was created.',
    )
    name: str = Field(..., description='The name of the vector store.')
    usage_bytes: int = Field(
        ...,
        description='The total number of bytes used by the files in the vector store.',
    )
    file_counts: FileCounts
    status: Status6 = Field(
        ...,
        description='The status of the vector store, which can be either `expired`, `in_progress`, or `completed`. A status of `completed` indicates that the vector store is ready for use.',
    )
    expires_after: Optional[VectorStoreExpirationAfter] = None
    expires_at: Optional[int] = Field(
        None,
        description='The Unix timestamp (in seconds) for when the vector store will expire.',
    )
    last_active_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the vector store was last active.',
    )
    metadata: Dict[str, Any] = Field(
        ...,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )


class UpdateVectorStoreRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Optional[str] = Field(None, description='The name of the vector store.')
    expires_after: Optional[VectorStoreExpirationAfter] = None
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )


class ListVectorStoresResponse(BaseModel):
    object: str = Field(..., examples=['list'])
    data: List[VectorStoreObject]
    first_id: str = Field(..., examples=['vs_abc123'])
    last_id: str = Field(..., examples=['vs_abc456'])
    has_more: bool = Field(..., examples=[False])


class Object30(Enum):
    vector_store_deleted = 'vector_store.deleted'


class DeleteVectorStoreResponse(BaseModel):
    id: str
    deleted: bool
    object: Object30


class Object31(Enum):
    vector_store_file = 'vector_store.file'


class Status7(Enum):
    in_progress = 'in_progress'
    completed = 'completed'
    cancelled = 'cancelled'
    failed = 'failed'


class Code2(Enum):
    server_error = 'server_error'
    unsupported_file = 'unsupported_file'
    invalid_file = 'invalid_file'


class LastError2(BaseModel):
    code: Code2 = Field(
        ..., description='One of `server_error` or `rate_limit_exceeded`.'
    )
    message: str = Field(..., description='A human-readable description of the error.')


class Type57(Enum):
    other = 'other'


class OtherChunkingStrategyResponseParam(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type57 = Field(..., description='Always `other`.')


class StaticChunkingStrategy(Static):
    pass


class AutoChunkingStrategyRequestParam(ChunkingStrategy):
    pass


class StaticChunkingStrategyRequestParam(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Type13 = Field(..., description='Always `static`.')
    static: StaticChunkingStrategy


class ChunkingStrategyRequestParam(
    RootModel[
        Union[AutoChunkingStrategyRequestParam, StaticChunkingStrategyRequestParam]
    ]
):
    root: Union[
        AutoChunkingStrategyRequestParam, StaticChunkingStrategyRequestParam
    ] = Field(
        ...,
        description='The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy.',
    )


class CreateVectorStoreFileRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    file_id: str = Field(
        ...,
        description='A [File](/docs/api-reference/files) ID that the vector store should use. Useful for tools like `file_search` that can access files.',
    )
    chunking_strategy: Optional[ChunkingStrategyRequestParam] = None


class Object32(Enum):
    vector_store_file_deleted = 'vector_store.file.deleted'


class DeleteVectorStoreFileResponse(BaseModel):
    id: str
    deleted: bool
    object: Object32


class Object33(Enum):
    vector_store_files_batch = 'vector_store.files_batch'


class FileCounts1(BaseModel):
    in_progress: int = Field(
        ..., description='The number of files that are currently being processed.'
    )
    completed: int = Field(
        ..., description='The number of files that have been processed.'
    )
    failed: int = Field(
        ..., description='The number of files that have failed to process.'
    )
    cancelled: int = Field(..., description='The number of files that where cancelled.')
    total: int = Field(..., description='The total number of files.')


class VectorStoreFileBatchObject(BaseModel):
    id: str = Field(
        ..., description='The identifier, which can be referenced in API endpoints.'
    )
    object: Object33 = Field(
        ..., description='The object type, which is always `vector_store.file_batch`.'
    )
    created_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the vector store files batch was created.',
    )
    vector_store_id: str = Field(
        ...,
        description='The ID of the [vector store](/docs/api-reference/vector-stores/object) that the [File](/docs/api-reference/files) is attached to.',
    )
    status: Status7 = Field(
        ...,
        description='The status of the vector store files batch, which can be either `in_progress`, `completed`, `cancelled` or `failed`.',
    )
    file_counts: FileCounts1


class CreateVectorStoreFileBatchRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    file_ids: List[str] = Field(
        ...,
        description='A list of [File](/docs/api-reference/files) IDs that the vector store should use. Useful for tools like `file_search` that can access files.',
        max_length=500,
        min_length=1,
    )
    chunking_strategy: Optional[ChunkingStrategyRequestParam] = None


class Event(Enum):
    thread_created = 'thread.created'


class ThreadStreamEvent1(BaseModel):
    event: Event
    data: ThreadObject


class ThreadStreamEvent(RootModel[ThreadStreamEvent1]):
    root: ThreadStreamEvent1


class Event1(Enum):
    thread_run_created = 'thread.run.created'


class Event2(Enum):
    thread_run_queued = 'thread.run.queued'


class Event3(Enum):
    thread_run_in_progress = 'thread.run.in_progress'


class Event4(Enum):
    thread_run_requires_action = 'thread.run.requires_action'


class Event5(Enum):
    thread_run_completed = 'thread.run.completed'


class Event6(Enum):
    thread_run_incomplete = 'thread.run.incomplete'


class Event7(Enum):
    thread_run_failed = 'thread.run.failed'


class Event8(Enum):
    thread_run_cancelling = 'thread.run.cancelling'


class Event9(Enum):
    thread_run_cancelled = 'thread.run.cancelled'


class Event10(Enum):
    thread_run_expired = 'thread.run.expired'


class Event11(Enum):
    thread_run_step_created = 'thread.run.step.created'


class Event12(Enum):
    thread_run_step_in_progress = 'thread.run.step.in_progress'


class Event14(Enum):
    thread_run_step_completed = 'thread.run.step.completed'


class Event15(Enum):
    thread_run_step_failed = 'thread.run.step.failed'


class Event16(Enum):
    thread_run_step_cancelled = 'thread.run.step.cancelled'


class Event17(Enum):
    thread_run_step_expired = 'thread.run.step.expired'


class Event18(Enum):
    thread_message_created = 'thread.message.created'


class Event19(Enum):
    thread_message_in_progress = 'thread.message.in_progress'


class Event21(Enum):
    thread_message_completed = 'thread.message.completed'


class Event22(Enum):
    thread_message_incomplete = 'thread.message.incomplete'


class Event23(Enum):
    error = 'error'


class ErrorEvent(BaseModel):
    event: Event23
    data: Error


class Event24(Enum):
    done = 'done'


class Data(Enum):
    field_DONE_ = '[DONE]'


class DoneEvent(BaseModel):
    event: Event24
    data: Data


class Object34(Enum):
    batch = 'batch'


class Datum(BaseModel):
    code: Optional[str] = Field(
        None, description='An error code identifying the error type.'
    )
    message: Optional[str] = Field(
        None,
        description='A human-readable message providing more details about the error.',
    )
    param: Optional[str] = Field(
        None,
        description='The name of the parameter that caused the error, if applicable.',
    )
    line: Optional[int] = Field(
        None,
        description='The line number of the input file where the error occurred, if applicable.',
    )


class Errors(BaseModel):
    object: Optional[str] = Field(
        None, description='The object type, which is always `list`.'
    )
    data: Optional[List[Datum]] = None


class Status9(Enum):
    validating = 'validating'
    failed = 'failed'
    in_progress = 'in_progress'
    finalizing = 'finalizing'
    completed = 'completed'
    expired = 'expired'
    cancelling = 'cancelling'
    cancelled = 'cancelled'


class RequestCounts(BaseModel):
    total: int = Field(..., description='Total number of requests in the batch.')
    completed: int = Field(
        ..., description='Number of requests that have been completed successfully.'
    )
    failed: int = Field(..., description='Number of requests that have failed.')


class Batch(BaseModel):
    id: str
    object: Object34 = Field(
        ..., description='The object type, which is always `batch`.'
    )
    endpoint: str = Field(..., description='The OpenAI API endpoint used by the batch.')
    errors: Optional[Errors] = None
    input_file_id: str = Field(
        ..., description='The ID of the input file for the batch.'
    )
    completion_window: str = Field(
        ..., description='The time frame within which the batch should be processed.'
    )
    status: Status9 = Field(..., description='The current status of the batch.')
    output_file_id: Optional[str] = Field(
        None,
        description='The ID of the file containing the outputs of successfully executed requests.',
    )
    error_file_id: Optional[str] = Field(
        None,
        description='The ID of the file containing the outputs of requests with errors.',
    )
    created_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the batch was created.',
    )
    in_progress_at: Optional[int] = Field(
        None,
        description='The Unix timestamp (in seconds) for when the batch started processing.',
    )
    expires_at: Optional[int] = Field(
        None,
        description='The Unix timestamp (in seconds) for when the batch will expire.',
    )
    finalizing_at: Optional[int] = Field(
        None,
        description='The Unix timestamp (in seconds) for when the batch started finalizing.',
    )
    completed_at: Optional[int] = Field(
        None,
        description='The Unix timestamp (in seconds) for when the batch was completed.',
    )
    failed_at: Optional[int] = Field(
        None, description='The Unix timestamp (in seconds) for when the batch failed.'
    )
    expired_at: Optional[int] = Field(
        None, description='The Unix timestamp (in seconds) for when the batch expired.'
    )
    cancelling_at: Optional[int] = Field(
        None,
        description='The Unix timestamp (in seconds) for when the batch started cancelling.',
    )
    cancelled_at: Optional[int] = Field(
        None,
        description='The Unix timestamp (in seconds) for when the batch was cancelled.',
    )
    request_counts: Optional[RequestCounts] = Field(
        None, description='The request counts for different statuses within the batch.'
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )


class Method(Enum):
    POST = 'POST'


class BatchRequestInput(BaseModel):
    custom_id: Optional[str] = Field(
        None,
        description='A developer-provided per-request id that will be used to match outputs to inputs. Must be unique for each request in a batch.',
    )
    method: Optional[Method] = Field(
        None,
        description='The HTTP method to be used for the request. Currently only `POST` is supported.',
    )
    url: Optional[str] = Field(
        None,
        description='The OpenAI API relative URL to be used for the request. Currently `/v1/chat/completions`, `/v1/embeddings`, and `/v1/completions` are supported.',
    )


class Response(BaseModel):
    status_code: Optional[int] = Field(
        None, description='The HTTP status code of the response'
    )
    request_id: Optional[str] = Field(
        None,
        description='An unique identifier for the OpenAI API request. Please include this request ID when contacting support.',
    )
    body: Optional[Dict[str, Any]] = Field(
        None, description='The JSON body of the response'
    )


class Error2(BaseModel):
    code: Optional[str] = Field(None, description='A machine-readable error code.')
    message: Optional[str] = Field(None, description='A human-readable error message.')


class BatchRequestOutput(BaseModel):
    id: Optional[str] = None
    custom_id: Optional[str] = Field(
        None,
        description='A developer-provided per-request id that will be used to match outputs to inputs.',
    )
    response: Optional[Response] = None
    error: Optional[Error2] = Field(
        None,
        description='For requests that failed with a non-HTTP error, this will contain more information on the cause of the failure.',
    )


class ListBatchesResponse(BaseModel):
    data: List[Batch]
    first_id: Optional[str] = Field(None, examples=['batch_abc123'])
    last_id: Optional[str] = Field(None, examples=['batch_abc456'])
    has_more: bool
    object: Object


class AuditLogActorServiceAccount(BaseModel):
    id: Optional[str] = Field(None, description='The service account id.')


class AuditLogActorUser(BaseModel):
    id: Optional[str] = Field(None, description='The user id.')
    email: Optional[str] = Field(None, description='The user email.')


class Type61(Enum):
    user = 'user'
    service_account = 'service_account'


class AuditLogActorApiKey(BaseModel):
    id: Optional[str] = Field(None, description='The tracking id of the API key.')
    type: Optional[Type61] = Field(
        None,
        description='The type of API key. Can be either `user` or `service_account`.',
    )
    user: Optional[AuditLogActorUser] = None
    service_account: Optional[AuditLogActorServiceAccount] = None


class AuditLogActorSession(BaseModel):
    user: Optional[AuditLogActorUser] = None
    ip_address: Optional[str] = Field(
        None, description='The IP address from which the action was performed.'
    )


class Type62(Enum):
    session = 'session'
    api_key = 'api_key'


class AuditLogActor(BaseModel):
    type: Optional[Type62] = Field(
        None, description='The type of actor. Is either `session` or `api_key`.'
    )
    session: Optional[AuditLogActorSession] = None
    api_key: Optional[AuditLogActorApiKey] = None


class AuditLogEventType(Enum):
    api_key_created = 'api_key.created'
    api_key_updated = 'api_key.updated'
    api_key_deleted = 'api_key.deleted'
    invite_sent = 'invite.sent'
    invite_accepted = 'invite.accepted'
    invite_deleted = 'invite.deleted'
    login_succeeded = 'login.succeeded'
    login_failed = 'login.failed'
    logout_succeeded = 'logout.succeeded'
    logout_failed = 'logout.failed'
    organization_updated = 'organization.updated'
    project_created = 'project.created'
    project_updated = 'project.updated'
    project_archived = 'project.archived'
    service_account_created = 'service_account.created'
    service_account_updated = 'service_account.updated'
    service_account_deleted = 'service_account.deleted'
    user_added = 'user.added'
    user_updated = 'user.updated'
    user_deleted = 'user.deleted'


class Project(BaseModel):
    id: Optional[str] = Field(None, description='The project ID.')
    name: Optional[str] = Field(None, description='The project title.')


class Data1(BaseModel):
    scopes: Optional[List[str]] = Field(
        None,
        description='A list of scopes allowed for the API key, e.g. `["api.model.request"]`',
    )


class ApiKeyCreated(BaseModel):
    id: Optional[str] = Field(None, description='The tracking ID of the API key.')
    data: Optional[Data1] = Field(
        None, description='The payload used to create the API key.'
    )


class ChangesRequested(Data1):
    pass


class ApiKeyUpdated(BaseModel):
    id: Optional[str] = Field(None, description='The tracking ID of the API key.')
    changes_requested: Optional[ChangesRequested] = Field(
        None, description='The payload used to update the API key.'
    )


class ApiKeyDeleted(BaseModel):
    id: Optional[str] = Field(None, description='The tracking ID of the API key.')


class Data2(BaseModel):
    email: Optional[str] = Field(
        None, description='The email invited to the organization.'
    )
    role: Optional[str] = Field(
        None,
        description='The role the email was invited to be. Is either `owner` or `member`.',
    )


class InviteSent(BaseModel):
    id: Optional[str] = Field(None, description='The ID of the invite.')
    data: Optional[Data2] = Field(
        None, description='The payload used to create the invite.'
    )


class InviteAccepted(BaseModel):
    id: Optional[str] = Field(None, description='The ID of the invite.')


class InviteDeleted(InviteAccepted):
    pass


class LoginFailed(BaseModel):
    error_code: Optional[str] = Field(
        None, description='The error code of the failure.'
    )
    error_message: Optional[str] = Field(
        None, description='The error message of the failure.'
    )


class LogoutFailed(LoginFailed):
    pass


class Settings(BaseModel):
    threads_ui_visibility: Optional[str] = Field(
        None,
        description='Visibility of the threads page which shows messages created with the Assistants API and Playground. One of `ANY_ROLE`, `OWNERS`, or `NONE`.',
    )
    usage_dashboard_visibility: Optional[str] = Field(
        None,
        description='Visibility of the usage dashboard which shows activity and costs for your organization. One of `ANY_ROLE` or `OWNERS`.',
    )


class ChangesRequested1(BaseModel):
    title: Optional[str] = Field(None, description='The organization title.')
    description: Optional[str] = Field(
        None, description='The organization description.'
    )
    name: Optional[str] = Field(None, description='The organization name.')
    settings: Optional[Settings] = None


class OrganizationUpdated(BaseModel):
    id: Optional[str] = Field(None, description='The organization ID.')
    changes_requested: Optional[ChangesRequested1] = Field(
        None, description='The payload used to update the organization settings.'
    )


class Data3(BaseModel):
    name: Optional[str] = Field(None, description='The project name.')
    title: Optional[str] = Field(
        None, description='The title of the project as seen on the dashboard.'
    )


class ProjectCreated(BaseModel):
    id: Optional[str] = Field(None, description='The project ID.')
    data: Optional[Data3] = Field(
        None, description='The payload used to create the project.'
    )


class ChangesRequested2(BaseModel):
    title: Optional[str] = Field(
        None, description='The title of the project as seen on the dashboard.'
    )


class ProjectUpdated(BaseModel):
    id: Optional[str] = Field(None, description='The project ID.')
    changes_requested: Optional[ChangesRequested2] = Field(
        None, description='The payload used to update the project.'
    )


class ProjectArchived(BaseModel):
    id: Optional[str] = Field(None, description='The project ID.')


class Data4(BaseModel):
    role: Optional[str] = Field(
        None,
        description='The role of the service account. Is either `owner` or `member`.',
    )


class ServiceAccountCreated(BaseModel):
    id: Optional[str] = Field(None, description='The service account ID.')
    data: Optional[Data4] = Field(
        None, description='The payload used to create the service account.'
    )


class ChangesRequested3(Data4):
    pass


class ServiceAccountUpdated(BaseModel):
    id: Optional[str] = Field(None, description='The service account ID.')
    changes_requested: Optional[ChangesRequested3] = Field(
        None, description='The payload used to updated the service account.'
    )


class ServiceAccountDeleted(BaseModel):
    id: Optional[str] = Field(None, description='The service account ID.')


class Data5(BaseModel):
    role: Optional[str] = Field(
        None, description='The role of the user. Is either `owner` or `member`.'
    )


class UserAdded(BaseModel):
    id: Optional[str] = Field(None, description='The user ID.')
    data: Optional[Data5] = Field(
        None, description='The payload used to add the user to the project.'
    )


class ChangesRequested4(Data5):
    pass


class UserUpdated(BaseModel):
    id: Optional[str] = Field(None, description='The project ID.')
    changes_requested: Optional[ChangesRequested4] = Field(
        None, description='The payload used to update the user.'
    )


class UserDeleted(BaseModel):
    id: Optional[str] = Field(None, description='The user ID.')


class AuditLog(BaseModel):
    id: str = Field(..., description='The ID of this log.')
    type: AuditLogEventType
    effective_at: int = Field(
        ..., description='The Unix timestamp (in seconds) of the event.'
    )
    project: Optional[Project] = Field(
        None,
        description='The project that the action was scoped to. Absent for actions not scoped to projects.',
    )
    actor: AuditLogActor
    api_key_created: Optional[ApiKeyCreated] = Field(
        None,
        alias='api_key.created',
        description='The details for events with this `type`.',
    )
    api_key_updated: Optional[ApiKeyUpdated] = Field(
        None,
        alias='api_key.updated',
        description='The details for events with this `type`.',
    )
    api_key_deleted: Optional[ApiKeyDeleted] = Field(
        None,
        alias='api_key.deleted',
        description='The details for events with this `type`.',
    )
    invite_sent: Optional[InviteSent] = Field(
        None,
        alias='invite.sent',
        description='The details for events with this `type`.',
    )
    invite_accepted: Optional[InviteAccepted] = Field(
        None,
        alias='invite.accepted',
        description='The details for events with this `type`.',
    )
    invite_deleted: Optional[InviteDeleted] = Field(
        None,
        alias='invite.deleted',
        description='The details for events with this `type`.',
    )
    login_failed: Optional[LoginFailed] = Field(
        None,
        alias='login.failed',
        description='The details for events with this `type`.',
    )
    logout_failed: Optional[LogoutFailed] = Field(
        None,
        alias='logout.failed',
        description='The details for events with this `type`.',
    )
    organization_updated: Optional[OrganizationUpdated] = Field(
        None,
        alias='organization.updated',
        description='The details for events with this `type`.',
    )
    project_created: Optional[ProjectCreated] = Field(
        None,
        alias='project.created',
        description='The details for events with this `type`.',
    )
    project_updated: Optional[ProjectUpdated] = Field(
        None,
        alias='project.updated',
        description='The details for events with this `type`.',
    )
    project_archived: Optional[ProjectArchived] = Field(
        None,
        alias='project.archived',
        description='The details for events with this `type`.',
    )
    service_account_created: Optional[ServiceAccountCreated] = Field(
        None,
        alias='service_account.created',
        description='The details for events with this `type`.',
    )
    service_account_updated: Optional[ServiceAccountUpdated] = Field(
        None,
        alias='service_account.updated',
        description='The details for events with this `type`.',
    )
    service_account_deleted: Optional[ServiceAccountDeleted] = Field(
        None,
        alias='service_account.deleted',
        description='The details for events with this `type`.',
    )
    user_added: Optional[UserAdded] = Field(
        None, alias='user.added', description='The details for events with this `type`.'
    )
    user_updated: Optional[UserUpdated] = Field(
        None,
        alias='user.updated',
        description='The details for events with this `type`.',
    )
    user_deleted: Optional[UserDeleted] = Field(
        None,
        alias='user.deleted',
        description='The details for events with this `type`.',
    )


class ListAuditLogsResponse(BaseModel):
    object: Object
    data: List[AuditLog]
    first_id: str = Field(..., examples=['audit_log-defb456h8dks'])
    last_id: str = Field(..., examples=['audit_log-hnbkd8s93s'])
    has_more: bool


class Object37(Enum):
    organization_invite = 'organization.invite'


class Role10(Enum):
    owner = 'owner'
    reader = 'reader'


class Status10(Enum):
    accepted = 'accepted'
    expired = 'expired'
    pending = 'pending'


class Invite(BaseModel):
    object: Object37 = Field(
        ..., description='The object type, which is always `organization.invite`'
    )
    id: str = Field(
        ..., description='The identifier, which can be referenced in API endpoints'
    )
    email: str = Field(
        ...,
        description='The email address of the individual to whom the invite was sent',
    )
    role: Role10 = Field(..., description='`owner` or `reader`')
    status: Status10 = Field(..., description='`accepted`,`expired`, or `pending`')
    invited_at: int = Field(
        ..., description='The Unix timestamp (in seconds) of when the invite was sent.'
    )
    expires_at: int = Field(
        ..., description='The Unix timestamp (in seconds) of when the invite expires.'
    )
    accepted_at: Optional[int] = Field(
        None,
        description='The Unix timestamp (in seconds) of when the invite was accepted.',
    )


class InviteListResponse(BaseModel):
    object: Object = Field(..., description='The object type, which is always `list`')
    data: List[Invite]
    first_id: Optional[str] = Field(
        None, description='The first `invite_id` in the retrieved `list`'
    )
    last_id: Optional[str] = Field(
        None, description='The last `invite_id` in the retrieved `list`'
    )
    has_more: Optional[bool] = Field(
        None,
        description='The `has_more` property is used for pagination to indicate there are additional results.',
    )


class Role11(Enum):
    reader = 'reader'
    owner = 'owner'


class InviteRequest(BaseModel):
    email: str = Field(..., description='Send an email to this address')
    role: Role11 = Field(..., description='`owner` or `reader`')


class Object39(Enum):
    organization_invite_deleted = 'organization.invite.deleted'


class InviteDeleteResponse(BaseModel):
    object: Object39 = Field(
        ...,
        description='The object type, which is always `organization.invite.deleted`',
    )
    id: str
    deleted: bool


class Object40(Enum):
    organization_user = 'organization.user'


class User(BaseModel):
    object: Object40 = Field(
        ..., description='The object type, which is always `organization.user`'
    )
    id: str = Field(
        ..., description='The identifier, which can be referenced in API endpoints'
    )
    name: str = Field(..., description='The name of the user')
    email: str = Field(..., description='The email address of the user')
    role: Role10 = Field(..., description='`owner` or `reader`')
    added_at: int = Field(
        ..., description='The Unix timestamp (in seconds) of when the user was added.'
    )


class UserListResponse(BaseModel):
    object: Object
    data: List[User]
    first_id: str
    last_id: str
    has_more: bool


class UserRoleUpdateRequest(BaseModel):
    role: Role10 = Field(..., description='`owner` or `reader`')


class Object42(Enum):
    organization_user_deleted = 'organization.user.deleted'


class UserDeleteResponse(BaseModel):
    object: Object42
    id: str
    deleted: bool


class Object43(Enum):
    organization_project = 'organization.project'


class Status11(Enum):
    active = 'active'
    archived = 'archived'


class Project1(BaseModel):
    id: str = Field(
        ..., description='The identifier, which can be referenced in API endpoints'
    )
    object: Object43 = Field(
        ..., description='The object type, which is always `organization.project`'
    )
    name: str = Field(
        ..., description='The name of the project. This appears in reporting.'
    )
    created_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) of when the project was created.',
    )
    archived_at: Optional[int] = Field(
        None,
        description='The Unix timestamp (in seconds) of when the project was archived or `null`.',
    )
    status: Status11 = Field(..., description='`active` or `archived`')


class ProjectListResponse(BaseModel):
    object: Object
    data: List[Project1]
    first_id: str
    last_id: str
    has_more: bool


class ProjectCreateRequest(BaseModel):
    name: str = Field(
        ...,
        description='The friendly name of the project, this name appears in reports.',
    )


class ProjectUpdateRequest(BaseModel):
    name: str = Field(
        ...,
        description='The updated name of the project, this name appears in reports.',
    )


class DefaultProjectErrorResponse(BaseModel):
    code: int
    message: str


class Object45(Enum):
    organization_project_user = 'organization.project.user'


class Role14(Enum):
    owner = 'owner'
    member = 'member'


class ProjectUser(BaseModel):
    object: Object45 = Field(
        ..., description='The object type, which is always `organization.project.user`'
    )
    id: str = Field(
        ..., description='The identifier, which can be referenced in API endpoints'
    )
    name: str = Field(..., description='The name of the user')
    email: str = Field(..., description='The email address of the user')
    role: Role14 = Field(..., description='`owner` or `member`')
    added_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) of when the project was added.',
    )


class ProjectUserListResponse(BaseModel):
    object: str
    data: List[ProjectUser]
    first_id: str
    last_id: str
    has_more: bool


class ProjectUserCreateRequest(BaseModel):
    user_id: str = Field(..., description='The ID of the user.')
    role: Role14 = Field(..., description='`owner` or `member`')


class ProjectUserUpdateRequest(BaseModel):
    role: Role14 = Field(..., description='`owner` or `member`')


class Object46(Enum):
    organization_project_user_deleted = 'organization.project.user.deleted'


class ProjectUserDeleteResponse(BaseModel):
    object: Object46
    id: str
    deleted: bool


class Object47(Enum):
    organization_project_service_account = 'organization.project.service_account'


class ProjectServiceAccount(BaseModel):
    object: Object47 = Field(
        ...,
        description='The object type, which is always `organization.project.service_account`',
    )
    id: str = Field(
        ..., description='The identifier, which can be referenced in API endpoints'
    )
    name: str = Field(..., description='The name of the service account')
    role: Role14 = Field(..., description='`owner` or `member`')
    created_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) of when the service account was created',
    )


class ProjectServiceAccountListResponse(BaseModel):
    object: Object
    data: List[ProjectServiceAccount]
    first_id: str
    last_id: str
    has_more: bool


class ProjectServiceAccountCreateRequest(BaseModel):
    name: str = Field(..., description='The name of the service account being created.')


class Role18(Enum):
    member = 'member'


class Object50(Enum):
    organization_project_service_account_api_key = (
        'organization.project.service_account.api_key'
    )


class ProjectServiceAccountApiKey(BaseModel):
    object: Object50 = Field(
        ...,
        description='The object type, which is always `organization.project.service_account.api_key`',
    )
    value: str
    name: str
    created_at: int
    id: str


class Object51(Enum):
    organization_project_service_account_deleted = (
        'organization.project.service_account.deleted'
    )


class ProjectServiceAccountDeleteResponse(BaseModel):
    object: Object51
    id: str
    deleted: bool


class Object52(Enum):
    organization_project_api_key = 'organization.project.api_key'


class Owner(BaseModel):
    type: Optional[Type61] = Field(None, description='`user` or `service_account`')
    user: Optional[ProjectUser] = None
    service_account: Optional[ProjectServiceAccount] = None


class ProjectApiKey(BaseModel):
    object: Object52 = Field(
        ...,
        description='The object type, which is always `organization.project.api_key`',
    )
    redacted_value: str = Field(..., description='The redacted value of the API key')
    name: str = Field(..., description='The name of the API key')
    created_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) of when the API key was created',
    )
    id: str = Field(
        ..., description='The identifier, which can be referenced in API endpoints'
    )
    owner: Owner


class ProjectApiKeyListResponse(BaseModel):
    object: Object
    data: List[ProjectApiKey]
    first_id: str
    last_id: str
    has_more: bool


class Object54(Enum):
    organization_project_api_key_deleted = 'organization.project.api_key.deleted'


class ProjectApiKeyDeleteResponse(BaseModel):
    object: Object54
    id: str
    deleted: bool


class ListModelsResponse(BaseModel):
    object: Object
    data: List[Model]


class CreateCompletionRequest(BaseModel):
    model: Union[str, Model1] = Field(
        ...,
        description='ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.\n',
    )
    prompt: Union[str, List[str], List[int], List[PromptItem]] = Field(
        ...,
        description='The prompt(s) to generate completions for, encoded as a string, array of strings, array of tokens, or array of token arrays.\n\nNote that <|endoftext|> is the document separator that the model sees during training, so if a prompt is not specified the model will generate as if from the beginning of a new document.\n',
    )
    best_of: Optional[conint(ge=0, le=20)] = Field(
        1,
        description='Generates `best_of` completions server-side and returns the "best" (the one with the highest log probability per token). Results cannot be streamed.\n\nWhen used with `n`, `best_of` controls the number of candidate completions and `n` specifies how many to return – `best_of` must be greater than `n`.\n\n**Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use carefully and ensure that you have reasonable settings for `max_tokens` and `stop`.\n',
    )
    echo: Optional[bool] = Field(
        False, description='Echo back the prompt in addition to the completion\n'
    )
    frequency_penalty: Optional[confloat(ge=-2.0, le=2.0)] = Field(
        0,
        description="Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.\n\n[See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)\n",
    )
    logit_bias: Optional[Dict[str, int]] = Field(
        None,
        description='Modify the likelihood of specified tokens appearing in the completion.\n\nAccepts a JSON object that maps tokens (specified by their token ID in the GPT tokenizer) to an associated bias value from -100 to 100. You can use this [tokenizer tool](/tokenizer?view=bpe) to convert text to token IDs. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.\n\nAs an example, you can pass `{"50256": -100}` to prevent the <|endoftext|> token from being generated.\n',
    )
    logprobs: Optional[conint(ge=0, le=5)] = Field(
        None,
        description='Include the log probabilities on the `logprobs` most likely output tokens, as well the chosen tokens. For example, if `logprobs` is 5, the API will return a list of the 5 most likely tokens. The API will always return the `logprob` of the sampled token, so there may be up to `logprobs+1` elements in the response.\n\nThe maximum value for `logprobs` is 5.\n',
    )
    max_tokens: Optional[conint(ge=0)] = Field(
        16,
        description="The maximum number of [tokens](/tokenizer) that can be generated in the completion.\n\nThe token count of your prompt plus `max_tokens` cannot exceed the model's context length. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.\n",
        examples=[16],
    )
    n: Optional[conint(ge=1, le=128)] = Field(
        1,
        description='How many completions to generate for each prompt.\n\n**Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use carefully and ensure that you have reasonable settings for `max_tokens` and `stop`.\n',
        examples=[1],
    )
    presence_penalty: Optional[confloat(ge=-2.0, le=2.0)] = Field(
        0,
        description="Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.\n\n[See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)\n",
    )
    seed: Optional[conint(ge=-9223372036854775808, le=9223372036854775807)] = Field(
        None,
        description='If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same `seed` and parameters should return the same result.\n\nDeterminism is not guaranteed, and you should refer to the `system_fingerprint` response parameter to monitor changes in the backend.\n',
    )
    stop: Optional[Union[str, List[str]]] = Field(
        None,
        description='Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence.\n',
    )
    stream: Optional[bool] = Field(
        False,
        description='Whether to stream back partial progress. If set, tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a `data: [DONE]` message. [Example Python code](https://cookbook.openai.com/examples/how_to_stream_completions).\n',
    )
    stream_options: Optional[ChatCompletionStreamOptions] = None
    suffix: Optional[str] = Field(
        None,
        description='The suffix that comes after a completion of inserted text.\n\nThis parameter is only supported for `gpt-3.5-turbo-instruct`.\n',
        examples=['test.'],
    )
    temperature: Optional[confloat(ge=0.0, le=2.0)] = Field(
        1,
        description='What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.\n\nWe generally recommend altering this or `top_p` but not both.\n',
        examples=[1],
    )
    top_p: Optional[confloat(ge=0.0, le=1.0)] = Field(
        1,
        description='An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.\n\nWe generally recommend altering this or `temperature` but not both.\n',
        examples=[1],
    )
    user: Optional[str] = Field(
        None,
        description='A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).\n',
        examples=['user-1234'],
    )


class CreateCompletionResponse(BaseModel):
    id: str = Field(..., description='A unique identifier for the completion.')
    choices: List[Choice] = Field(
        ...,
        description='The list of completion choices the model generated for the input prompt.',
    )
    created: int = Field(
        ...,
        description='The Unix timestamp (in seconds) of when the completion was created.',
    )
    model: str = Field(..., description='The model used for completion.')
    system_fingerprint: Optional[str] = Field(
        None,
        description='This fingerprint represents the backend configuration that the model runs with.\n\nCan be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.\n',
    )
    object: Object1 = Field(
        ..., description='The object type, which is always "text_completion"'
    )
    usage: Optional[CompletionUsage] = None


class ChatCompletionTool(BaseModel):
    type: Role4 = Field(
        ...,
        description='The type of the tool. Currently, only `function` is supported.',
    )
    function: FunctionObject


class ChatCompletionToolChoiceOption(
    RootModel[Union[ChatCompletionToolChoiceOption1, ChatCompletionNamedToolChoice]]
):
    root: Union[ChatCompletionToolChoiceOption1, ChatCompletionNamedToolChoice] = Field(
        ...,
        description='Controls which (if any) tool is called by the model.\n`none` means the model will not call any tool and instead generates a message.\n`auto` means the model can pick between generating a message or calling one or more tools.\n`required` means the model must call one or more tools.\nSpecifying a particular tool via `{"type": "function", "function": {"name": "my_function"}}` forces the model to call that tool.\n\n`none` is the default when no tools are present. `auto` is the default if tools are present.\n',
    )


class ChatCompletionMessageToolCalls(RootModel[List[ChatCompletionMessageToolCall]]):
    root: List[ChatCompletionMessageToolCall] = Field(
        ...,
        description='The tool calls generated by the model, such as function calls.',
    )


class ChatCompletionResponseMessage(BaseModel):
    content: str = Field(..., description='The contents of the message.')
    refusal: str = Field(..., description='The refusal message generated by the model.')
    tool_calls: Optional[ChatCompletionMessageToolCalls] = None
    role: Role2 = Field(..., description='The role of the author of this message.')
    function_call: Optional[FunctionCall] = Field(
        None,
        description='Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.',
    )


class Choice1(BaseModel):
    finish_reason: FinishReason1 = Field(
        ...,
        description='The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,\n`length` if the maximum number of tokens specified in the request was reached,\n`content_filter` if content was omitted due to a flag from our content filters,\n`tool_calls` if the model called a tool, or `function_call` (deprecated) if the model called a function.\n',
    )
    index: int = Field(
        ..., description='The index of the choice in the list of choices.'
    )
    message: ChatCompletionResponseMessage
    logprobs: Logprobs2 = Field(
        ..., description='Log probability information for the choice.'
    )


class CreateChatCompletionResponse(BaseModel):
    id: str = Field(..., description='A unique identifier for the chat completion.')
    choices: List[Choice1] = Field(
        ...,
        description='A list of chat completion choices. Can be more than one if `n` is greater than 1.',
    )
    created: int = Field(
        ...,
        description='The Unix timestamp (in seconds) of when the chat completion was created.',
    )
    model: str = Field(..., description='The model used for the chat completion.')
    service_tier: Optional[ServiceTier1] = Field(
        None,
        description='The service tier used for processing the request. This field is only included if the `service_tier` parameter is specified in the request.',
        examples=['scale'],
    )
    system_fingerprint: Optional[str] = Field(
        None,
        description='This fingerprint represents the backend configuration that the model runs with.\n\nCan be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.\n',
    )
    object: Object2 = Field(
        ..., description='The object type, which is always `chat.completion`.'
    )
    usage: Optional[CompletionUsage] = None


class Choice2(BaseModel):
    finish_reason: FinishReason2 = Field(
        ...,
        description='The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence, `length` if the maximum number of tokens specified in the request was reached, `content_filter` if content was omitted due to a flag from our content filters, or `function_call` if the model called a function.\n',
    )
    index: int = Field(
        ..., description='The index of the choice in the list of choices.'
    )
    message: ChatCompletionResponseMessage


class CreateChatCompletionFunctionResponse(BaseModel):
    id: str = Field(..., description='A unique identifier for the chat completion.')
    choices: List[Choice2] = Field(
        ...,
        description='A list of chat completion choices. Can be more than one if `n` is greater than 1.',
    )
    created: int = Field(
        ...,
        description='The Unix timestamp (in seconds) of when the chat completion was created.',
    )
    model: str = Field(..., description='The model used for the chat completion.')
    system_fingerprint: Optional[str] = Field(
        None,
        description='This fingerprint represents the backend configuration that the model runs with.\n\nCan be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.\n',
    )
    object: Object2 = Field(
        ..., description='The object type, which is always `chat.completion`.'
    )
    usage: Optional[CompletionUsage] = None


class ImagesResponse(BaseModel):
    created: int
    data: List[Image]


class ListFilesResponse(BaseModel):
    data: List[OpenAIFile]
    object: Object


class ListFineTuningJobEventsResponse(BaseModel):
    data: List[FineTuningJobEvent]
    object: Object


class ListFineTuningJobCheckpointsResponse(BaseModel):
    data: List[FineTuningJobCheckpoint]
    object: Object
    first_id: Optional[str] = None
    last_id: Optional[str] = None
    has_more: bool


class CreateEmbeddingResponse(BaseModel):
    data: List[Embedding] = Field(
        ..., description='The list of embeddings generated by the model.'
    )
    model: str = Field(
        ..., description='The name of the model used to generate the embedding.'
    )
    object: Object = Field(..., description='The object type, which is always "list".')
    usage: Usage1 = Field(..., description='The usage information for the request.')


class FineTuningJob(BaseModel):
    id: str = Field(
        ...,
        description='The object identifier, which can be referenced in the API endpoints.',
    )
    created_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the fine-tuning job was created.',
    )
    error: Error1 = Field(
        ...,
        description='For fine-tuning jobs that have `failed`, this will contain more information on the cause of the failure.',
    )
    fine_tuned_model: str = Field(
        ...,
        description='The name of the fine-tuned model that is being created. The value will be null if the fine-tuning job is still running.',
    )
    finished_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the fine-tuning job was finished. The value will be null if the fine-tuning job is still running.',
    )
    hyperparameters: Hyperparameters1 = Field(
        ...,
        description='The hyperparameters used for the fine-tuning job. See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.',
    )
    model: str = Field(..., description='The base model that is being fine-tuned.')
    object: Object16 = Field(
        ..., description='The object type, which is always "fine_tuning.job".'
    )
    organization_id: str = Field(
        ..., description='The organization that owns the fine-tuning job.'
    )
    result_files: List[str] = Field(
        ...,
        description='The compiled results file ID(s) for the fine-tuning job. You can retrieve the results with the [Files API](/docs/api-reference/files/retrieve-contents).',
    )
    status: Status2 = Field(
        ...,
        description='The current status of the fine-tuning job, which can be either `validating_files`, `queued`, `running`, `succeeded`, `failed`, or `cancelled`.',
    )
    trained_tokens: int = Field(
        ...,
        description='The total number of billable tokens processed by this fine-tuning job. The value will be null if the fine-tuning job is still running.',
    )
    training_file: str = Field(
        ...,
        description='The file ID used for training. You can retrieve the training data with the [Files API](/docs/api-reference/files/retrieve-contents).',
    )
    validation_file: str = Field(
        ...,
        description='The file ID used for validation. You can retrieve the validation results with the [Files API](/docs/api-reference/files/retrieve-contents).',
    )
    integrations: Optional[List[FineTuningIntegration]] = Field(
        None,
        description='A list of integrations to enable for this fine-tuning job.',
        max_length=5,
    )
    seed: int = Field(..., description='The seed used for the fine-tuning job.')
    estimated_finish: Optional[int] = Field(
        None,
        description='The Unix timestamp (in seconds) for when the fine-tuning job is estimated to finish. The value will be null if the fine-tuning job is not running.',
    )


class FileSearch4(BaseModel):
    max_num_results: Optional[conint(ge=1, le=50)] = Field(
        None,
        description='The maximum number of results the file search tool should output. The default is 20 for `gpt-4*` models and 5 for `gpt-3.5-turbo`. This number should be between 1 and 50 inclusive.\n\nNote that the file search tool may output fewer than `max_num_results` results. See the [file search tool documentation](/docs/assistants/tools/file-search/customizing-file-search-settings) for more information.\n',
    )
    ranking_options: Optional[FileSearchRankingOptions] = None


class AssistantToolsFileSearch(BaseModel):
    type: Type17 = Field(
        ..., description='The type of tool being defined: `file_search`'
    )
    file_search: Optional[FileSearch4] = Field(
        None, description='Overrides for the file search tool.'
    )


class AssistantsApiToolChoiceOption(
    RootModel[Union[ChatCompletionToolChoiceOption1, AssistantsNamedToolChoice]]
):
    root: Union[ChatCompletionToolChoiceOption1, AssistantsNamedToolChoice] = Field(
        ...,
        description='Controls which (if any) tool is called by the model.\n`none` means the model will not call any tools and instead generates a message.\n`auto` is the default value and means the model can pick between generating a message or calling one or more tools.\n`required` means the model must call one or more tools before responding to the user.\nSpecifying a particular tool like `{"type": "file_search"}` or `{"type": "function", "function": {"name": "my_function"}}` forces the model to call that tool.\n',
    )


class SubmitToolOutputs(BaseModel):
    tool_calls: List[RunToolCallObject] = Field(
        ..., description='A list of the relevant tool calls.'
    )


class RequiredAction(BaseModel):
    type: Type22 = Field(
        ..., description='For now, this is always `submit_tool_outputs`.'
    )
    submit_tool_outputs: SubmitToolOutputs = Field(
        ..., description='Details on the tool outputs needed for this run to continue.'
    )


class RunObject(BaseModel):
    id: str = Field(
        ..., description='The identifier, which can be referenced in API endpoints.'
    )
    object: Object21 = Field(
        ..., description='The object type, which is always `thread.run`.'
    )
    created_at: int = Field(
        ..., description='The Unix timestamp (in seconds) for when the run was created.'
    )
    thread_id: str = Field(
        ...,
        description='The ID of the [thread](/docs/api-reference/threads) that was executed on as a part of this run.',
    )
    assistant_id: str = Field(
        ...,
        description='The ID of the [assistant](/docs/api-reference/assistants) used for execution of this run.',
    )
    status: Status3 = Field(
        ...,
        description='The status of the run, which can be either `queued`, `in_progress`, `requires_action`, `cancelling`, `cancelled`, `failed`, `completed`, `incomplete`, or `expired`.',
    )
    required_action: RequiredAction = Field(
        ...,
        description='Details on the action required to continue the run. Will be `null` if no action is required.',
    )
    last_error: LastError = Field(
        ...,
        description='The last error associated with this run. Will be `null` if there are no errors.',
    )
    expires_at: int = Field(
        ..., description='The Unix timestamp (in seconds) for when the run will expire.'
    )
    started_at: int = Field(
        ..., description='The Unix timestamp (in seconds) for when the run was started.'
    )
    cancelled_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the run was cancelled.',
    )
    failed_at: int = Field(
        ..., description='The Unix timestamp (in seconds) for when the run failed.'
    )
    completed_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the run was completed.',
    )
    incomplete_details: IncompleteDetails = Field(
        ...,
        description='Details on why the run is incomplete. Will be `null` if the run is not incomplete.',
    )
    model: str = Field(
        ...,
        description='The model that the [assistant](/docs/api-reference/assistants) used for this run.',
    )
    instructions: str = Field(
        ...,
        description='The instructions that the [assistant](/docs/api-reference/assistants) used for this run.',
    )
    tools: List[
        Union[AssistantToolsCode, AssistantToolsFileSearch, AssistantToolsFunction]
    ] = Field(
        ...,
        description='The list of tools that the [assistant](/docs/api-reference/assistants) used for this run.',
        max_length=20,
    )
    metadata: Dict[str, Any] = Field(
        ...,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )
    usage: RunCompletionUsage
    temperature: Optional[float] = Field(
        None,
        description='The sampling temperature used for this run. If not set, defaults to 1.',
    )
    top_p: Optional[float] = Field(
        None,
        description='The nucleus sampling value used for this run. If not set, defaults to 1.',
    )
    max_prompt_tokens: conint(ge=256) = Field(
        ...,
        description='The maximum number of prompt tokens specified to have been used over the course of the run.\n',
    )
    max_completion_tokens: conint(ge=256) = Field(
        ...,
        description='The maximum number of completion tokens specified to have been used over the course of the run.\n',
    )
    truncation_strategy: TruncationObject
    tool_choice: AssistantsApiToolChoiceOption
    parallel_tool_calls: ParallelToolCalls
    response_format: AssistantsApiResponseFormatOption


class ListRunsResponse(BaseModel):
    object: str = Field(..., examples=['list'])
    data: List[RunObject]
    first_id: str = Field(..., examples=['run_abc123'])
    last_id: str = Field(..., examples=['run_abc456'])
    has_more: bool = Field(..., examples=[False])


class CreateMessageRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    role: Role7 = Field(
        ...,
        description='The role of the entity that is creating the message. Allowed values include:\n- `user`: Indicates the message is sent by an actual user and should be used in most cases to represent user-generated messages.\n- `assistant`: Indicates the message is generated by the assistant. Use this value to insert messages from the assistant into the conversation.\n',
    )
    content: Union[
        str,
        List[
            Union[
                MessageContentImageFileObject,
                MessageContentImageUrlObject,
                MessageRequestContentTextObject,
            ]
        ],
    ]
    attachments: Optional[List[Attachment]] = Field(
        None,
        description='A list of files attached to the message, and the tools they should be added to.',
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )


class Text(BaseModel):
    value: str = Field(..., description='The data that makes up the text.')
    annotations: List[
        Union[
            MessageContentTextAnnotationsFileCitationObject,
            MessageContentTextAnnotationsFilePathObject,
        ]
    ]


class MessageContentTextObject(BaseModel):
    type: Type = Field(..., description='Always `text`.')
    text: Text


class Text1(BaseModel):
    value: Optional[str] = Field(None, description='The data that makes up the text.')
    annotations: Optional[
        List[
            Union[
                MessageDeltaContentTextAnnotationsFileCitationObject,
                MessageDeltaContentTextAnnotationsFilePathObject,
            ]
        ]
    ] = None


class MessageDeltaContentTextObject(BaseModel):
    index: int = Field(..., description='The index of the content part in the message.')
    type: Type = Field(..., description='Always `text`.')
    text: Optional[Text1] = None


class CodeInterpreter7(BaseModel):
    input: str = Field(..., description='The input to the Code Interpreter tool call.')
    outputs: List[
        Union[
            RunStepDetailsToolCallsCodeOutputLogsObject,
            RunStepDetailsToolCallsCodeOutputImageObject,
        ]
    ] = Field(
        ...,
        description='The outputs from the Code Interpreter tool call. Code Interpreter can output one or more items, including text (`logs`) or images (`image`). Each of these are represented by a different object type.',
    )


class RunStepDetailsToolCallsCodeObject(BaseModel):
    id: str = Field(..., description='The ID of the tool call.')
    type: Type16 = Field(
        ...,
        description='The type of tool call. This is always going to be `code_interpreter` for this type of tool call.',
    )
    code_interpreter: CodeInterpreter7 = Field(
        ..., description='The Code Interpreter tool call definition.'
    )


class CodeInterpreter8(BaseModel):
    input: Optional[str] = Field(
        None, description='The input to the Code Interpreter tool call.'
    )
    outputs: Optional[
        List[
            Union[
                RunStepDeltaStepDetailsToolCallsCodeOutputLogsObject,
                RunStepDeltaStepDetailsToolCallsCodeOutputImageObject,
            ]
        ]
    ] = Field(
        None,
        description='The outputs from the Code Interpreter tool call. Code Interpreter can output one or more items, including text (`logs`) or images (`image`). Each of these are represented by a different object type.',
    )


class RunStepDeltaStepDetailsToolCallsCodeObject(BaseModel):
    index: int = Field(
        ..., description='The index of the tool call in the tool calls array.'
    )
    id: Optional[str] = Field(None, description='The ID of the tool call.')
    type: Type16 = Field(
        ...,
        description='The type of tool call. This is always going to be `code_interpreter` for this type of tool call.',
    )
    code_interpreter: Optional[CodeInterpreter8] = Field(
        None, description='The Code Interpreter tool call definition.'
    )


class FileSearch10(BaseModel):
    ranking_options: Optional[RunStepDetailsToolCallsFileSearchRankingOptionsObject] = (
        None
    )
    results: Optional[List[RunStepDetailsToolCallsFileSearchResultObject]] = Field(
        None, description='The results of the file search.'
    )


class RunStepDetailsToolCallsFileSearchObject(BaseModel):
    id: str = Field(..., description='The ID of the tool call object.')
    type: Type17 = Field(
        ...,
        description='The type of tool call. This is always going to be `file_search` for this type of tool call.',
    )
    file_search: FileSearch10 = Field(
        ..., description='For now, this is always going to be an empty object.'
    )


class CreateVectorStoreRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    file_ids: Optional[List[str]] = Field(
        None,
        description='A list of [File](/docs/api-reference/files) IDs that the vector store should use. Useful for tools like `file_search` that can access files.',
        max_length=500,
    )
    name: Optional[str] = Field(None, description='The name of the vector store.')
    expires_after: Optional[VectorStoreExpirationAfter] = None
    chunking_strategy: Optional[
        Union[AutoChunkingStrategyRequestParam, StaticChunkingStrategyRequestParam]
    ] = Field(
        None,
        description='The chunking strategy used to chunk the file(s). If not set, will use the `auto` strategy. Only applicable if `file_ids` is non-empty.',
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )


class StaticChunkingStrategyResponseParam(StaticChunkingStrategyRequestParam):
    pass


class RunStreamEvent1(BaseModel):
    event: Event1
    data: RunObject


class RunStreamEvent2(BaseModel):
    event: Event2
    data: RunObject


class RunStreamEvent3(BaseModel):
    event: Event3
    data: RunObject


class RunStreamEvent4(BaseModel):
    event: Event4
    data: RunObject


class RunStreamEvent5(BaseModel):
    event: Event5
    data: RunObject


class RunStreamEvent6(BaseModel):
    event: Event6
    data: RunObject


class RunStreamEvent7(BaseModel):
    event: Event7
    data: RunObject


class RunStreamEvent8(BaseModel):
    event: Event8
    data: RunObject


class RunStreamEvent9(BaseModel):
    event: Event9
    data: RunObject


class RunStreamEvent10(BaseModel):
    event: Event10
    data: RunObject


class RunStreamEvent(
    RootModel[
        Union[
            RunStreamEvent1,
            RunStreamEvent2,
            RunStreamEvent3,
            RunStreamEvent4,
            RunStreamEvent5,
            RunStreamEvent6,
            RunStreamEvent7,
            RunStreamEvent8,
            RunStreamEvent9,
            RunStreamEvent10,
        ]
    ]
):
    root: Union[
        RunStreamEvent1,
        RunStreamEvent2,
        RunStreamEvent3,
        RunStreamEvent4,
        RunStreamEvent5,
        RunStreamEvent6,
        RunStreamEvent7,
        RunStreamEvent8,
        RunStreamEvent9,
        RunStreamEvent10,
    ]


class ProjectServiceAccountCreateResponse(BaseModel):
    object: Object47
    id: str
    name: str
    role: Role18 = Field(
        ..., description='Service accounts can only have one role of type `member`'
    )
    created_at: int
    api_key: ProjectServiceAccountApiKey


class ChatCompletionRequestAssistantMessage(BaseModel):
    content: Optional[
        Union[str, List[ChatCompletionRequestAssistantMessageContentPart]]
    ] = Field(
        None,
        description='The contents of the assistant message. Required unless `tool_calls` or `function_call` is specified.\n',
    )
    refusal: Optional[str] = Field(
        None, description='The refusal message by the assistant.'
    )
    role: Role2 = Field(
        ..., description='The role of the messages author, in this case `assistant`.'
    )
    name: Optional[str] = Field(
        None,
        description='An optional name for the participant. Provides the model information to differentiate between participants of the same role.',
    )
    tool_calls: Optional[ChatCompletionMessageToolCalls] = None
    function_call: Optional[FunctionCall] = Field(
        None,
        description='Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.',
    )


class FineTuneChatCompletionRequestAssistantMessage(
    ChatCompletionRequestAssistantMessage
):
    weight: Optional[Weight] = Field(
        None,
        description='Controls whether the assistant message is trained against (0 or 1)',
    )
    role: Role2 = Field(
        ..., description='The role of the messages author, in this case `assistant`.'
    )


class ListPaginatedFineTuningJobsResponse(BaseModel):
    data: List[FineTuningJob]
    has_more: bool
    object: Object


class FinetuneChatRequestInput(BaseModel):
    messages: Optional[
        List[
            Union[
                ChatCompletionRequestSystemMessage,
                ChatCompletionRequestUserMessage,
                FineTuneChatCompletionRequestAssistantMessage,
                ChatCompletionRequestToolMessage,
                ChatCompletionRequestFunctionMessage,
            ]
        ]
    ] = Field(None, min_length=1)
    tools: Optional[List[ChatCompletionTool]] = Field(
        None, description='A list of tools the model may generate JSON inputs for.'
    )
    parallel_tool_calls: Optional[ParallelToolCalls] = None
    functions: Optional[List[ChatCompletionFunctions]] = Field(
        None,
        description='A list of functions the model may generate JSON inputs for.',
        max_length=128,
        min_length=1,
    )


class AssistantObject(BaseModel):
    id: str = Field(
        ..., description='The identifier, which can be referenced in API endpoints.'
    )
    object: Role2 = Field(
        ..., description='The object type, which is always `assistant`.'
    )
    created_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the assistant was created.',
    )
    name: constr(max_length=256) = Field(
        ...,
        description='The name of the assistant. The maximum length is 256 characters.\n',
    )
    description: constr(max_length=512) = Field(
        ...,
        description='The description of the assistant. The maximum length is 512 characters.\n',
    )
    model: str = Field(
        ...,
        description='ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.\n',
    )
    instructions: constr(max_length=256000) = Field(
        ...,
        description='The system instructions that the assistant uses. The maximum length is 256,000 characters.\n',
    )
    tools: List[
        Union[AssistantToolsCode, AssistantToolsFileSearch, AssistantToolsFunction]
    ] = Field(
        ...,
        description='A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `file_search`, or `function`.\n',
        max_length=128,
    )
    tool_resources: Optional[ToolResources] = Field(
        None,
        description="A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.\n",
    )
    metadata: Dict[str, Any] = Field(
        ...,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )
    temperature: Optional[confloat(ge=0.0, le=2.0)] = Field(
        1,
        description='What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.\n',
        examples=[1],
    )
    top_p: Optional[confloat(ge=0.0, le=1.0)] = Field(
        1,
        description='An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.\n\nWe generally recommend altering this or temperature but not both.\n',
        examples=[1],
    )
    response_format: Optional[AssistantsApiResponseFormatOption] = None


class CreateAssistantRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    model: Union[str, Model12] = Field(
        ...,
        description='ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.\n',
        examples=['gpt-4o'],
    )
    name: Optional[constr(max_length=256)] = Field(
        None,
        description='The name of the assistant. The maximum length is 256 characters.\n',
    )
    description: Optional[constr(max_length=512)] = Field(
        None,
        description='The description of the assistant. The maximum length is 512 characters.\n',
    )
    instructions: Optional[constr(max_length=256000)] = Field(
        None,
        description='The system instructions that the assistant uses. The maximum length is 256,000 characters.\n',
    )
    tools: Optional[
        List[
            Union[AssistantToolsCode, AssistantToolsFileSearch, AssistantToolsFunction]
        ]
    ] = Field(
        [],
        description='A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `file_search`, or `function`.\n',
        max_length=128,
    )
    tool_resources: Optional[ToolResources1] = Field(
        None,
        description="A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.\n",
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )
    temperature: Optional[confloat(ge=0.0, le=2.0)] = Field(
        1,
        description='What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.\n',
        examples=[1],
    )
    top_p: Optional[confloat(ge=0.0, le=1.0)] = Field(
        1,
        description='An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.\n\nWe generally recommend altering this or temperature but not both.\n',
        examples=[1],
    )
    response_format: Optional[AssistantsApiResponseFormatOption] = None


class ModifyAssistantRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    model: Optional[str] = Field(
        None,
        description='ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.\n',
    )
    name: Optional[constr(max_length=256)] = Field(
        None,
        description='The name of the assistant. The maximum length is 256 characters.\n',
    )
    description: Optional[constr(max_length=512)] = Field(
        None,
        description='The description of the assistant. The maximum length is 512 characters.\n',
    )
    instructions: Optional[constr(max_length=256000)] = Field(
        None,
        description='The system instructions that the assistant uses. The maximum length is 256,000 characters.\n',
    )
    tools: Optional[
        List[
            Union[AssistantToolsCode, AssistantToolsFileSearch, AssistantToolsFunction]
        ]
    ] = Field(
        [],
        description='A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `file_search`, or `function`.\n',
        max_length=128,
    )
    tool_resources: Optional[ToolResources2] = Field(
        None,
        description="A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.\n",
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )
    temperature: Optional[confloat(ge=0.0, le=2.0)] = Field(
        1,
        description='What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.\n',
        examples=[1],
    )
    top_p: Optional[confloat(ge=0.0, le=1.0)] = Field(
        1,
        description='An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.\n\nWe generally recommend altering this or temperature but not both.\n',
        examples=[1],
    )
    response_format: Optional[AssistantsApiResponseFormatOption] = None


class ListAssistantsResponse(BaseModel):
    object: str = Field(..., examples=['list'])
    data: List[AssistantObject]
    first_id: str = Field(..., examples=['asst_abc123'])
    last_id: str = Field(..., examples=['asst_abc456'])
    has_more: bool = Field(..., examples=[False])


class CreateRunRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    assistant_id: str = Field(
        ...,
        description='The ID of the [assistant](/docs/api-reference/assistants) to use to execute this run.',
    )
    model: Optional[Union[str, Model12]] = Field(
        None,
        description='The ID of the [Model](/docs/api-reference/models) to be used to execute this run. If a value is provided here, it will override the model associated with the assistant. If not, the model associated with the assistant will be used.',
        examples=['gpt-4o'],
    )
    instructions: Optional[str] = Field(
        None,
        description='Overrides the [instructions](/docs/api-reference/assistants/createAssistant) of the assistant. This is useful for modifying the behavior on a per-run basis.',
    )
    additional_instructions: Optional[str] = Field(
        None,
        description='Appends additional instructions at the end of the instructions for the run. This is useful for modifying the behavior on a per-run basis without overriding other instructions.',
    )
    additional_messages: Optional[List[CreateMessageRequest]] = Field(
        None,
        description='Adds additional messages to the thread before creating the run.',
    )
    tools: Optional[
        List[
            Union[AssistantToolsCode, AssistantToolsFileSearch, AssistantToolsFunction]
        ]
    ] = Field(
        None,
        description='Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.',
        max_length=20,
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )
    temperature: Optional[confloat(ge=0.0, le=2.0)] = Field(
        1,
        description='What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.\n',
        examples=[1],
    )
    top_p: Optional[confloat(ge=0.0, le=1.0)] = Field(
        1,
        description='An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.\n\nWe generally recommend altering this or temperature but not both.\n',
        examples=[1],
    )
    stream: Optional[bool] = Field(
        None,
        description='If `true`, returns a stream of events that happen during the Run as server-sent events, terminating when the Run enters a terminal state with a `data: [DONE]` message.\n',
    )
    max_prompt_tokens: Optional[conint(ge=256)] = Field(
        None,
        description='The maximum number of prompt tokens that may be used over the course of the run. The run will make a best effort to use only the number of prompt tokens specified, across multiple turns of the run. If the run exceeds the number of prompt tokens specified, the run will end with status `incomplete`. See `incomplete_details` for more info.\n',
    )
    max_completion_tokens: Optional[conint(ge=256)] = Field(
        None,
        description='The maximum number of completion tokens that may be used over the course of the run. The run will make a best effort to use only the number of completion tokens specified, across multiple turns of the run. If the run exceeds the number of completion tokens specified, the run will end with status `incomplete`. See `incomplete_details` for more info.\n',
    )
    truncation_strategy: Optional[TruncationObject] = None
    tool_choice: Optional[AssistantsApiToolChoiceOption] = None
    parallel_tool_calls: Optional[ParallelToolCalls] = None
    response_format: Optional[AssistantsApiResponseFormatOption] = None


class CreateThreadRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    messages: Optional[List[CreateMessageRequest]] = Field(
        None,
        description='A list of [messages](/docs/api-reference/messages) to start the thread with.',
    )
    tool_resources: Optional[ToolResources5] = Field(
        None,
        description="A set of resources that are made available to the assistant's tools in this thread. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.\n",
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )


class MessageObject(BaseModel):
    id: str = Field(
        ..., description='The identifier, which can be referenced in API endpoints.'
    )
    object: Object24 = Field(
        ..., description='The object type, which is always `thread.message`.'
    )
    created_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the message was created.',
    )
    thread_id: str = Field(
        ...,
        description='The [thread](/docs/api-reference/threads) ID that this message belongs to.',
    )
    status: Status4 = Field(
        ...,
        description='The status of the message, which can be either `in_progress`, `incomplete`, or `completed`.',
    )
    incomplete_details: IncompleteDetails1 = Field(
        ...,
        description='On an incomplete message, details about why the message is incomplete.',
    )
    completed_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the message was completed.',
    )
    incomplete_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the message was marked as incomplete.',
    )
    role: Role7 = Field(
        ...,
        description='The entity that produced the message. One of `user` or `assistant`.',
    )
    content: List[
        Union[
            MessageContentImageFileObject,
            MessageContentImageUrlObject,
            MessageContentTextObject,
            MessageContentRefusalObject,
        ]
    ] = Field(
        ..., description='The content of the message in array of text and/or images.'
    )
    assistant_id: str = Field(
        ...,
        description='If applicable, the ID of the [assistant](/docs/api-reference/assistants) that authored this message.',
    )
    run_id: str = Field(
        ...,
        description='The ID of the [run](/docs/api-reference/runs) associated with the creation of this message. Value is `null` when messages are created manually using the create message or create thread endpoints.',
    )
    attachments: List[Attachment] = Field(
        ...,
        description='A list of files attached to the message, and the tools they were added to.',
    )
    metadata: Dict[str, Any] = Field(
        ...,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )


class Delta(BaseModel):
    role: Optional[Role7] = Field(
        None,
        description='The entity that produced the message. One of `user` or `assistant`.',
    )
    content: Optional[
        List[
            Union[
                MessageDeltaContentImageFileObject,
                MessageDeltaContentTextObject,
                MessageDeltaContentRefusalObject,
                MessageDeltaContentImageUrlObject,
            ]
        ]
    ] = Field(
        None, description='The content of the message in array of text and/or images.'
    )


class MessageDeltaObject(BaseModel):
    id: str = Field(
        ...,
        description='The identifier of the message, which can be referenced in API endpoints.',
    )
    object: Object25 = Field(
        ..., description='The object type, which is always `thread.message.delta`.'
    )
    delta: Delta = Field(
        ...,
        description='The delta containing the fields that have changed on the Message.',
    )


class ListMessagesResponse(BaseModel):
    object: str = Field(..., examples=['list'])
    data: List[MessageObject]
    first_id: str = Field(..., examples=['msg_abc123'])
    last_id: str = Field(..., examples=['msg_abc123'])
    has_more: bool = Field(..., examples=[False])


class RunStepDetailsToolCallsObject(BaseModel):
    type: Type44 = Field(..., description='Always `tool_calls`.')
    tool_calls: List[
        Union[
            RunStepDetailsToolCallsCodeObject,
            RunStepDetailsToolCallsFileSearchObject,
            RunStepDetailsToolCallsFunctionObject,
        ]
    ] = Field(
        ...,
        description='An array of tool calls the run step was involved in. These can be associated with one of three types of tools: `code_interpreter`, `file_search`, or `function`.\n',
    )


class RunStepDeltaStepDetailsToolCallsObject(BaseModel):
    type: Type44 = Field(..., description='Always `tool_calls`.')
    tool_calls: Optional[
        List[
            Union[
                RunStepDeltaStepDetailsToolCallsCodeObject,
                RunStepDeltaStepDetailsToolCallsFileSearchObject,
                RunStepDeltaStepDetailsToolCallsFunctionObject,
            ]
        ]
    ] = Field(
        None,
        description='An array of tool calls the run step was involved in. These can be associated with one of three types of tools: `code_interpreter`, `file_search`, or `function`.\n',
    )


class VectorStoreFileObject(BaseModel):
    id: str = Field(
        ..., description='The identifier, which can be referenced in API endpoints.'
    )
    object: Object31 = Field(
        ..., description='The object type, which is always `vector_store.file`.'
    )
    usage_bytes: int = Field(
        ...,
        description='The total vector store usage in bytes. Note that this may be different from the original file size.',
    )
    created_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the vector store file was created.',
    )
    vector_store_id: str = Field(
        ...,
        description='The ID of the [vector store](/docs/api-reference/vector-stores/object) that the [File](/docs/api-reference/files) is attached to.',
    )
    status: Status7 = Field(
        ...,
        description='The status of the vector store file, which can be either `in_progress`, `completed`, `cancelled`, or `failed`. The status `completed` indicates that the vector store file is ready for use.',
    )
    last_error: LastError2 = Field(
        ...,
        description='The last error associated with this vector store file. Will be `null` if there are no errors.',
    )
    chunking_strategy: Optional[
        Union[StaticChunkingStrategyResponseParam, OtherChunkingStrategyResponseParam]
    ] = Field(None, description='The strategy used to chunk the file.')


class ListVectorStoreFilesResponse(BaseModel):
    object: str = Field(..., examples=['list'])
    data: List[VectorStoreFileObject]
    first_id: str = Field(..., examples=['file-abc123'])
    last_id: str = Field(..., examples=['file-abc456'])
    has_more: bool = Field(..., examples=[False])


class MessageStreamEvent1(BaseModel):
    event: Event18
    data: MessageObject


class MessageStreamEvent2(BaseModel):
    event: Event19
    data: MessageObject


class MessageStreamEvent3(BaseModel):
    event: Object25
    data: MessageDeltaObject


class MessageStreamEvent4(BaseModel):
    event: Event21
    data: MessageObject


class MessageStreamEvent5(BaseModel):
    event: Event22
    data: MessageObject


class MessageStreamEvent(
    RootModel[
        Union[
            MessageStreamEvent1,
            MessageStreamEvent2,
            MessageStreamEvent3,
            MessageStreamEvent4,
            MessageStreamEvent5,
        ]
    ]
):
    root: Union[
        MessageStreamEvent1,
        MessageStreamEvent2,
        MessageStreamEvent3,
        MessageStreamEvent4,
        MessageStreamEvent5,
    ]


class ChatCompletionRequestMessage(
    RootModel[
        Union[
            ChatCompletionRequestSystemMessage,
            ChatCompletionRequestUserMessage,
            ChatCompletionRequestAssistantMessage,
            ChatCompletionRequestToolMessage,
            ChatCompletionRequestFunctionMessage,
        ]
    ]
):
    root: Union[
        ChatCompletionRequestSystemMessage,
        ChatCompletionRequestUserMessage,
        ChatCompletionRequestAssistantMessage,
        ChatCompletionRequestToolMessage,
        ChatCompletionRequestFunctionMessage,
    ]


class CreateChatCompletionRequest(BaseModel):
    messages: List[ChatCompletionRequestMessage] = Field(
        ...,
        description='A list of messages comprising the conversation so far. [Example Python code](https://cookbook.openai.com/examples/how_to_format_inputs_to_chatgpt_models).',
        min_length=1,
    )
    model: Union[str, Model2] = Field(
        ...,
        description='ID of the model to use. See the [model endpoint compatibility](/docs/models/model-endpoint-compatibility) table for details on which models work with the Chat API.',
        examples=['gpt-4o'],
    )
    frequency_penalty: Optional[confloat(ge=-2.0, le=2.0)] = Field(
        0,
        description="Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.\n\n[See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)\n",
    )
    logit_bias: Optional[Dict[str, int]] = Field(
        None,
        description='Modify the likelihood of specified tokens appearing in the completion.\n\nAccepts a JSON object that maps tokens (specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.\n',
    )
    logprobs: Optional[bool] = Field(
        False,
        description='Whether to return log probabilities of the output tokens or not. If true, returns the log probabilities of each output token returned in the `content` of `message`.',
    )
    top_logprobs: Optional[conint(ge=0, le=20)] = Field(
        None,
        description='An integer between 0 and 20 specifying the number of most likely tokens to return at each token position, each with an associated log probability. `logprobs` must be set to `true` if this parameter is used.',
    )
    max_tokens: Optional[int] = Field(
        None,
        description="The maximum number of [tokens](/tokenizer) that can be generated in the chat completion.\n\nThe total length of input tokens and generated tokens is limited by the model's context length. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.\n",
    )
    n: Optional[conint(ge=1, le=128)] = Field(
        1,
        description='How many chat completion choices to generate for each input message. Note that you will be charged based on the number of generated tokens across all of the choices. Keep `n` as `1` to minimize costs.',
        examples=[1],
    )
    presence_penalty: Optional[confloat(ge=-2.0, le=2.0)] = Field(
        0,
        description="Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.\n\n[See more information about frequency and presence penalties.](/docs/guides/text-generation/parameter-details)\n",
    )
    response_format: Optional[
        Union[ResponseFormatText, ResponseFormatJsonObject, ResponseFormatJsonSchema]
    ] = Field(
        None,
        description='An object specifying the format that the model must output. Compatible with [GPT-4o](/docs/models/gpt-4o), [GPT-4o mini](/docs/models/gpt-4o-mini), [GPT-4 Turbo](/docs/models/gpt-4-and-gpt-4-turbo) and all GPT-3.5 Turbo models newer than `gpt-3.5-turbo-1106`.\n\nSetting to `{ "type": "json_schema", "json_schema": {...} }` enables Structured Outputs which guarantees the model will match your supplied JSON schema. Learn more in the [Structured Outputs guide](/docs/guides/structured-outputs).\n\nSetting to `{ "type": "json_object" }` enables JSON mode, which guarantees the message the model generates is valid JSON.\n\n**Important:** when using JSON mode, you **must** also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly "stuck" request. Also note that the message content may be partially cut off if `finish_reason="length"`, which indicates the generation exceeded `max_tokens` or the conversation exceeded the max context length.\n',
    )
    seed: Optional[conint(ge=-9223372036854775808, le=9223372036854775807)] = Field(
        None,
        description='This feature is in Beta.\nIf specified, our system will make a best effort to sample deterministically, such that repeated requests with the same `seed` and parameters should return the same result.\nDeterminism is not guaranteed, and you should refer to the `system_fingerprint` response parameter to monitor changes in the backend.\n',
    )
    service_tier: Optional[ServiceTier] = Field(
        None,
        description="Specifies the latency tier to use for processing the request. This parameter is relevant for customers subscribed to the scale tier service:\n  - If set to 'auto', the system will utilize scale tier credits until they are exhausted.\n  - If set to 'default', the request will be processed using the default service tier with a lower uptime SLA and no latency guarentee.\n  - When not set, the default behavior is 'auto'.\n\n  When this parameter is set, the response body will include the `service_tier` utilized.\n",
    )
    stop: Optional[Union[str, List[str]]] = Field(
        None,
        description='Up to 4 sequences where the API will stop generating further tokens.\n',
    )
    stream: Optional[bool] = Field(
        False,
        description='If set, partial message deltas will be sent, like in ChatGPT. Tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a `data: [DONE]` message. [Example Python code](https://cookbook.openai.com/examples/how_to_stream_completions).\n',
    )
    stream_options: Optional[ChatCompletionStreamOptions] = None
    temperature: Optional[confloat(ge=0.0, le=2.0)] = Field(
        1,
        description='What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.\n\nWe generally recommend altering this or `top_p` but not both.\n',
        examples=[1],
    )
    top_p: Optional[confloat(ge=0.0, le=1.0)] = Field(
        1,
        description='An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.\n\nWe generally recommend altering this or `temperature` but not both.\n',
        examples=[1],
    )
    tools: Optional[List[ChatCompletionTool]] = Field(
        None,
        description='A list of tools the model may call. Currently, only functions are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for. A max of 128 functions are supported.\n',
    )
    tool_choice: Optional[ChatCompletionToolChoiceOption] = None
    parallel_tool_calls: Optional[ParallelToolCalls] = None
    user: Optional[str] = Field(
        None,
        description='A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).\n',
        examples=['user-1234'],
    )
    function_call: Optional[Union[FunctionCall3, ChatCompletionFunctionCallOption]] = (
        Field(
            None,
            description='Deprecated in favor of `tool_choice`.\n\nControls which (if any) function is called by the model.\n`none` means the model will not call a function and instead generates a message.\n`auto` means the model can pick between generating a message or calling a function.\nSpecifying a particular function via `{"name": "my_function"}` forces the model to call that function.\n\n`none` is the default when no functions are present. `auto` is the default if functions are present.\n',
        )
    )
    functions: Optional[List[ChatCompletionFunctions]] = Field(
        None,
        description='Deprecated in favor of `tools`.\n\nA list of functions the model may generate JSON inputs for.\n',
        max_length=128,
        min_length=1,
    )


class CreateThreadAndRunRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    assistant_id: str = Field(
        ...,
        description='The ID of the [assistant](/docs/api-reference/assistants) to use to execute this run.',
    )
    thread: Optional[CreateThreadRequest] = Field(
        None, description='If no thread is provided, an empty thread will be created.'
    )
    model: Optional[Union[str, Model12]] = Field(
        None,
        description='The ID of the [Model](/docs/api-reference/models) to be used to execute this run. If a value is provided here, it will override the model associated with the assistant. If not, the model associated with the assistant will be used.',
        examples=['gpt-4o'],
    )
    instructions: Optional[str] = Field(
        None,
        description='Override the default system message of the assistant. This is useful for modifying the behavior on a per-run basis.',
    )
    tools: Optional[
        List[
            Union[AssistantToolsCode, AssistantToolsFileSearch, AssistantToolsFunction]
        ]
    ] = Field(
        None,
        description='Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.',
        max_length=20,
    )
    tool_resources: Optional[ToolResources3] = Field(
        None,
        description="A set of resources that are used by the assistant's tools. The resources are specific to the type of tool. For example, the `code_interpreter` tool requires a list of file IDs, while the `file_search` tool requires a list of vector store IDs.\n",
    )
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )
    temperature: Optional[confloat(ge=0.0, le=2.0)] = Field(
        1,
        description='What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.\n',
        examples=[1],
    )
    top_p: Optional[confloat(ge=0.0, le=1.0)] = Field(
        1,
        description='An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.\n\nWe generally recommend altering this or temperature but not both.\n',
        examples=[1],
    )
    stream: Optional[bool] = Field(
        None,
        description='If `true`, returns a stream of events that happen during the Run as server-sent events, terminating when the Run enters a terminal state with a `data: [DONE]` message.\n',
    )
    max_prompt_tokens: Optional[conint(ge=256)] = Field(
        None,
        description='The maximum number of prompt tokens that may be used over the course of the run. The run will make a best effort to use only the number of prompt tokens specified, across multiple turns of the run. If the run exceeds the number of prompt tokens specified, the run will end with status `incomplete`. See `incomplete_details` for more info.\n',
    )
    max_completion_tokens: Optional[conint(ge=256)] = Field(
        None,
        description='The maximum number of completion tokens that may be used over the course of the run. The run will make a best effort to use only the number of completion tokens specified, across multiple turns of the run. If the run exceeds the number of completion tokens specified, the run will end with status `incomplete`. See `incomplete_details` for more info.\n',
    )
    truncation_strategy: Optional[TruncationObject] = None
    tool_choice: Optional[AssistantsApiToolChoiceOption] = None
    parallel_tool_calls: Optional[ParallelToolCalls] = None
    response_format: Optional[AssistantsApiResponseFormatOption] = None


class RunStepObject(BaseModel):
    id: str = Field(
        ...,
        description='The identifier of the run step, which can be referenced in API endpoints.',
    )
    object: Object27 = Field(
        ..., description='The object type, which is always `thread.run.step`.'
    )
    created_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the run step was created.',
    )
    assistant_id: str = Field(
        ...,
        description='The ID of the [assistant](/docs/api-reference/assistants) associated with the run step.',
    )
    thread_id: str = Field(
        ...,
        description='The ID of the [thread](/docs/api-reference/threads) that was run.',
    )
    run_id: str = Field(
        ...,
        description='The ID of the [run](/docs/api-reference/runs) that this run step is a part of.',
    )
    type: Type41 = Field(
        ...,
        description='The type of run step, which can be either `message_creation` or `tool_calls`.',
    )
    status: Status5 = Field(
        ...,
        description='The status of the run step, which can be either `in_progress`, `cancelled`, `failed`, `completed`, or `expired`.',
    )
    step_details: Union[
        RunStepDetailsMessageCreationObject, RunStepDetailsToolCallsObject
    ] = Field(..., description='The details of the run step.')
    last_error: LastError1 = Field(
        ...,
        description='The last error associated with this run step. Will be `null` if there are no errors.',
    )
    expired_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the run step expired. A step is considered expired if the parent run is expired.',
    )
    cancelled_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the run step was cancelled.',
    )
    failed_at: int = Field(
        ..., description='The Unix timestamp (in seconds) for when the run step failed.'
    )
    completed_at: int = Field(
        ...,
        description='The Unix timestamp (in seconds) for when the run step completed.',
    )
    metadata: Dict[str, Any] = Field(
        ...,
        description='Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.\n',
    )
    usage: RunStepCompletionUsage


class Delta1(BaseModel):
    step_details: Optional[
        Union[
            RunStepDeltaStepDetailsMessageCreationObject,
            RunStepDeltaStepDetailsToolCallsObject,
        ]
    ] = Field(None, description='The details of the run step.')


class RunStepDeltaObject(BaseModel):
    id: str = Field(
        ...,
        description='The identifier of the run step, which can be referenced in API endpoints.',
    )
    object: Object28 = Field(
        ..., description='The object type, which is always `thread.run.step.delta`.'
    )
    delta: Delta1 = Field(
        ...,
        description='The delta containing the fields that have changed on the run step.',
    )


class ListRunStepsResponse(BaseModel):
    object: str = Field(..., examples=['list'])
    data: List[RunStepObject]
    first_id: str = Field(..., examples=['step_abc123'])
    last_id: str = Field(..., examples=['step_abc456'])
    has_more: bool = Field(..., examples=[False])


class RunStepStreamEvent1(BaseModel):
    event: Event11
    data: RunStepObject


class RunStepStreamEvent2(BaseModel):
    event: Event12
    data: RunStepObject


class RunStepStreamEvent3(BaseModel):
    event: Object28
    data: RunStepDeltaObject


class RunStepStreamEvent4(BaseModel):
    event: Event14
    data: RunStepObject


class RunStepStreamEvent5(BaseModel):
    event: Event15
    data: RunStepObject


class RunStepStreamEvent6(BaseModel):
    event: Event16
    data: RunStepObject


class RunStepStreamEvent7(BaseModel):
    event: Event17
    data: RunStepObject


class RunStepStreamEvent(
    RootModel[
        Union[
            RunStepStreamEvent1,
            RunStepStreamEvent2,
            RunStepStreamEvent3,
            RunStepStreamEvent4,
            RunStepStreamEvent5,
            RunStepStreamEvent6,
            RunStepStreamEvent7,
        ]
    ]
):
    root: Union[
        RunStepStreamEvent1,
        RunStepStreamEvent2,
        RunStepStreamEvent3,
        RunStepStreamEvent4,
        RunStepStreamEvent5,
        RunStepStreamEvent6,
        RunStepStreamEvent7,
    ]


class AssistantStreamEvent(
    RootModel[
        Union[
            ThreadStreamEvent,
            RunStreamEvent,
            RunStepStreamEvent,
            MessageStreamEvent,
            ErrorEvent,
            DoneEvent,
        ]
    ]
):
    root: Union[
        ThreadStreamEvent,
        RunStreamEvent,
        RunStepStreamEvent,
        MessageStreamEvent,
        ErrorEvent,
        DoneEvent,
    ] = Field(
        ...,
        description='Represents an event emitted when streaming a Run.\n\nEach event in a server-sent events stream has an `event` and `data` property:\n\n```\nevent: thread.created\ndata: {"id": "thread_123", "object": "thread", ...}\n```\n\nWe emit events whenever a new object is created, transitions to a new state, or is being\nstreamed in parts (deltas). For example, we emit `thread.run.created` when a new run\nis created, `thread.run.completed` when a run completes, and so on. When an Assistant chooses\nto create a message during a run, we emit a `thread.message.created event`, a\n`thread.message.in_progress` event, many `thread.message.delta` events, and finally a\n`thread.message.completed` event.\n\nWe may add additional events over time, so we recommend handling unknown events gracefully\nin your code. See the [Assistants API quickstart](/docs/assistants/overview) to learn how to\nintegrate the Assistants API with streaming.\n',
    )
