*This project is currently in **Beta**. Please open up an issue [here](https://github.com/mxenabled/mx-platform-python/issues) to report issues using the MX Platform Python library.*

# MX Platform Python

The [MX Platform API](https://www.mx.com/products/platform-api) is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

## Documentation

Examples for the API endpoints can be found [here.](docs/MxPlatformApi.md).

## Requirements

Python >= 3.6

## Installation

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```shell
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import mx_platform_python
```

## Getting Started

Please follow the [installation procedure](#installation) and then run the following:

```python
import time
import mx_platform_python
from mx_platform_python.api import mx_platform_api
from mx_platform_python.model.user_response_body import UserResponseBody
from mx_platform_python.model.user_create_request_body import UserCreateRequestBody
from mx_platform_python.model.user_create_request import UserCreateRequest
from pprint import pprint

configuration = mx_platform_python.Configuration(
    # Configure with your Client ID/API Key from https://dashboard.mx.com
    username = 'Your Client ID',
    password = 'Your API Key',

    # Configure environment. https://int-api.mx.com for development, https://api.mx.com for production
    host = 'https://int-api.mx.com'
)

with mx_platform_python.ApiClient(configuration) as api_client:
    api_instance = mx_platform_api.MxPlatformApi(api_client)
    user_create_request_body = UserCreateRequestBody(
        user = UserCreateRequest(
            metadata = "Creating a user!"
        )
    )

    try:
        api_response = api_instance.create_user(user_create_request_body)
        pprint(api_response)
    except mx_platform_python.ApiException as e:
        print("Exception when calling MxPlatformApi->create_user: %s\n" % e)
```

## Development

This project was generated by the [OpenAPI Generator](https://openapi-generator.tech). To generate this library, verify you have the latest version of the `openapi-generator-cli` found [here.](https://github.com/OpenAPITools/openapi-generator#17---npm)

Running the following command in this repo's directory will generate this library using the [MX Platform API OpenAPI spec](https://github.com/mxenabled/openapi/blob/master/openapi/mx_platform_api_beta.yml) with our [configuration and templates.](https://github.com/mxenabled/mx-platform-ruby/tree/master/openapi)
```shell
openapi-generator-cli generate \
-i https://raw.githubusercontent.com/mxenabled/openapi/master/openapi/mx_platform_api_beta.yml \
-g python \
-c ./openapi/config.yml \
-t ./openapi/templates
```

## Contributing

Please [open an issue](https://github.com/mxenabled/mx-platform-python/issues) or [submit a pull request.](https://github.com/mxenabled/mx-platform-python/pulls)
