"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.  # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from mx_platform_python.api_client import ApiClient, Endpoint as _Endpoint
from mx_platform_python.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from mx_platform_python.model.account_numbers_response_body import AccountNumbersResponseBody
from mx_platform_python.model.account_owners_response_body import AccountOwnersResponseBody
from mx_platform_python.model.account_response_body import AccountResponseBody
from mx_platform_python.model.account_update_request_body import AccountUpdateRequestBody
from mx_platform_python.model.accounts_response_body import AccountsResponseBody
from mx_platform_python.model.categories_response_body import CategoriesResponseBody
from mx_platform_python.model.category_create_request_body import CategoryCreateRequestBody
from mx_platform_python.model.category_response_body import CategoryResponseBody
from mx_platform_python.model.category_update_request_body import CategoryUpdateRequestBody
from mx_platform_python.model.challenges_response_body import ChallengesResponseBody
from mx_platform_python.model.connect_widget_request_body import ConnectWidgetRequestBody
from mx_platform_python.model.connect_widget_response_body import ConnectWidgetResponseBody
from mx_platform_python.model.credentials_response_body import CredentialsResponseBody
from mx_platform_python.model.enhance_transactions_request_body import EnhanceTransactionsRequestBody
from mx_platform_python.model.enhance_transactions_response_body import EnhanceTransactionsResponseBody
from mx_platform_python.model.holding_response_body import HoldingResponseBody
from mx_platform_python.model.holdings_response_body import HoldingsResponseBody
from mx_platform_python.model.institution_response_body import InstitutionResponseBody
from mx_platform_python.model.institutions_response_body import InstitutionsResponseBody
from mx_platform_python.model.managed_account_create_request_body import ManagedAccountCreateRequestBody
from mx_platform_python.model.managed_account_update_request_body import ManagedAccountUpdateRequestBody
from mx_platform_python.model.managed_member_create_request_body import ManagedMemberCreateRequestBody
from mx_platform_python.model.managed_member_update_request_body import ManagedMemberUpdateRequestBody
from mx_platform_python.model.managed_transaction_create_request_body import ManagedTransactionCreateRequestBody
from mx_platform_python.model.managed_transaction_update_request_body import ManagedTransactionUpdateRequestBody
from mx_platform_python.model.member_create_request_body import MemberCreateRequestBody
from mx_platform_python.model.member_response_body import MemberResponseBody
from mx_platform_python.model.member_resume_request_body import MemberResumeRequestBody
from mx_platform_python.model.member_status_response_body import MemberStatusResponseBody
from mx_platform_python.model.member_update_request_body import MemberUpdateRequestBody
from mx_platform_python.model.members_response_body import MembersResponseBody
from mx_platform_python.model.merchant_location_response_body import MerchantLocationResponseBody
from mx_platform_python.model.merchant_response_body import MerchantResponseBody
from mx_platform_python.model.merchants_response_body import MerchantsResponseBody
from mx_platform_python.model.o_auth_window_response_body import OAuthWindowResponseBody
from mx_platform_python.model.statement_response_body import StatementResponseBody
from mx_platform_python.model.statements_response_body import StatementsResponseBody
from mx_platform_python.model.tag_create_request_body import TagCreateRequestBody
from mx_platform_python.model.tag_response_body import TagResponseBody
from mx_platform_python.model.tag_update_request_body import TagUpdateRequestBody
from mx_platform_python.model.tagging_create_request_body import TaggingCreateRequestBody
from mx_platform_python.model.tagging_response_body import TaggingResponseBody
from mx_platform_python.model.tagging_update_request_body import TaggingUpdateRequestBody
from mx_platform_python.model.taggings_response_body import TaggingsResponseBody
from mx_platform_python.model.tags_response_body import TagsResponseBody
from mx_platform_python.model.transaction_response_body import TransactionResponseBody
from mx_platform_python.model.transaction_rule_create_request_body import TransactionRuleCreateRequestBody
from mx_platform_python.model.transaction_rule_response_body import TransactionRuleResponseBody
from mx_platform_python.model.transaction_rule_update_request_body import TransactionRuleUpdateRequestBody
from mx_platform_python.model.transaction_rules_response_body import TransactionRulesResponseBody
from mx_platform_python.model.transaction_update_request_body import TransactionUpdateRequestBody
from mx_platform_python.model.transactions_response_body import TransactionsResponseBody
from mx_platform_python.model.user_create_request_body import UserCreateRequestBody
from mx_platform_python.model.user_response_body import UserResponseBody
from mx_platform_python.model.user_update_request_body import UserUpdateRequestBody
from mx_platform_python.model.users_response_body import UsersResponseBody
from mx_platform_python.model.widget_request_body import WidgetRequestBody
from mx_platform_python.model.widget_response_body import WidgetResponseBody


class MxPlatformApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.aggregate_member_endpoint = _Endpoint(
            settings={
                'response_type': (MemberResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/aggregate',
                'operation_id': 'aggregate_member',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.check_balances_endpoint = _Endpoint(
            settings={
                'response_type': (MemberResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/check_balance',
                'operation_id': 'check_balances',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.create_category_endpoint = _Endpoint(
            settings={
                'response_type': (CategoryResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/categories',
                'operation_id': 'create_category',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'category_create_request_body',
                ],
                'required': [
                    'user_guid',
                    'category_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'category_create_request_body':
                        (CategoryCreateRequestBody,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'user_guid': 'path',
                    'category_create_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_managed_account_endpoint = _Endpoint(
            settings={
                'response_type': (AccountResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/managed_members/{member_guid}/accounts',
                'operation_id': 'create_managed_account',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                    'managed_account_create_request_body',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                    'managed_account_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'managed_account_create_request_body':
                        (ManagedAccountCreateRequestBody,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'managed_account_create_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_managed_member_endpoint = _Endpoint(
            settings={
                'response_type': (MemberResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/managed_members',
                'operation_id': 'create_managed_member',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'managed_member_create_request_body',
                ],
                'required': [
                    'user_guid',
                    'managed_member_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'managed_member_create_request_body':
                        (ManagedMemberCreateRequestBody,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'user_guid': 'path',
                    'managed_member_create_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_managed_transaction_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}/transactions',
                'operation_id': 'create_managed_transaction',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_guid',
                    'member_guid',
                    'user_guid',
                    'managed_transaction_create_request_body',
                ],
                'required': [
                    'account_guid',
                    'member_guid',
                    'user_guid',
                    'managed_transaction_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_guid':
                        (str,),
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'managed_transaction_create_request_body':
                        (ManagedTransactionCreateRequestBody,),
                },
                'attribute_map': {
                    'account_guid': 'account_guid',
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'account_guid': 'path',
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'managed_transaction_create_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_member_endpoint = _Endpoint(
            settings={
                'response_type': (MemberResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members',
                'operation_id': 'create_member',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'member_create_request_body',
                ],
                'required': [
                    'user_guid',
                    'member_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'member_create_request_body':
                        (MemberCreateRequestBody,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'user_guid': 'path',
                    'member_create_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_tag_endpoint = _Endpoint(
            settings={
                'response_type': (TagResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/tags',
                'operation_id': 'create_tag',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'tag_create_request_body',
                ],
                'required': [
                    'user_guid',
                    'tag_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'tag_create_request_body':
                        (TagCreateRequestBody,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'user_guid': 'path',
                    'tag_create_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_tagging_endpoint = _Endpoint(
            settings={
                'response_type': (TaggingResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/taggings',
                'operation_id': 'create_tagging',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'tagging_create_request_body',
                ],
                'required': [
                    'user_guid',
                    'tagging_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'tagging_create_request_body':
                        (TaggingCreateRequestBody,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'user_guid': 'path',
                    'tagging_create_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_transaction_rule_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionRuleResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/transaction_rules',
                'operation_id': 'create_transaction_rule',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'transaction_rule_create_request_body',
                ],
                'required': [
                    'user_guid',
                    'transaction_rule_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'transaction_rule_create_request_body':
                        (TransactionRuleCreateRequestBody,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'user_guid': 'path',
                    'transaction_rule_create_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_user_endpoint = _Endpoint(
            settings={
                'response_type': (UserResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users',
                'operation_id': 'create_user',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_create_request_body',
                ],
                'required': [
                    'user_create_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_create_request_body':
                        (UserCreateRequestBody,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'user_create_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_category_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/categories/{category_guid}',
                'operation_id': 'delete_category',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'category_guid',
                    'user_guid',
                ],
                'required': [
                    'category_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'category_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'category_guid': 'category_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'category_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_managed_account_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}',
                'operation_id': 'delete_managed_account',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_guid',
                    'member_guid',
                    'user_guid',
                ],
                'required': [
                    'account_guid',
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_guid':
                        (str,),
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'account_guid': 'account_guid',
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'account_guid': 'path',
                    'member_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_managed_member_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/managed_members/{member_guid}',
                'operation_id': 'delete_managed_member',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_managed_transaction_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}/transactions/{transaction_guid}',
                'operation_id': 'delete_managed_transaction',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_guid',
                    'member_guid',
                    'transaction_guid',
                    'user_guid',
                ],
                'required': [
                    'account_guid',
                    'member_guid',
                    'transaction_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_guid':
                        (str,),
                    'member_guid':
                        (str,),
                    'transaction_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'account_guid': 'account_guid',
                    'member_guid': 'member_guid',
                    'transaction_guid': 'transaction_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'account_guid': 'path',
                    'member_guid': 'path',
                    'transaction_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_member_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}',
                'operation_id': 'delete_member',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_tag_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/tags/{tag_guid}',
                'operation_id': 'delete_tag',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'tag_guid',
                    'user_guid',
                ],
                'required': [
                    'tag_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tag_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'tag_guid': 'tag_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'tag_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_tagging_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/taggings/{tagging_guid}',
                'operation_id': 'delete_tagging',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'tagging_guid',
                    'user_guid',
                ],
                'required': [
                    'tagging_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tagging_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'tagging_guid': 'tagging_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'tagging_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_transaction_rule_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/transaction_rules/{transaction_rule_guid}',
                'operation_id': 'delete_transaction_rule',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'transaction_rule_guid',
                    'user_guid',
                ],
                'required': [
                    'transaction_rule_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transaction_rule_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'transaction_rule_guid': 'transaction_rule_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'transaction_rule_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_user_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}',
                'operation_id': 'delete_user',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                ],
                'required': [
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.download_statement_pdf_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/statements/{statement_guid}.pdf',
                'operation_id': 'download_statement_pdf',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'statement_guid',
                    'user_guid',
                ],
                'required': [
                    'member_guid',
                    'statement_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'statement_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'statement_guid': 'statement_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'statement_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+pdf'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.enhance_transactions_endpoint = _Endpoint(
            settings={
                'response_type': (EnhanceTransactionsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/transactions/enhance',
                'operation_id': 'enhance_transactions',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'enhance_transactions_request_body',
                ],
                'required': [
                    'enhance_transactions_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'enhance_transactions_request_body':
                        (EnhanceTransactionsRequestBody,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'enhance_transactions_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.extend_history_endpoint = _Endpoint(
            settings={
                'response_type': (MemberResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/extend_history',
                'operation_id': 'extend_history',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.fetch_statements_endpoint = _Endpoint(
            settings={
                'response_type': (MemberResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/fetch_statements',
                'operation_id': 'fetch_statements',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.identify_member_endpoint = _Endpoint(
            settings={
                'response_type': (MemberResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/identify',
                'operation_id': 'identify_member',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_account_numbers_by_account_endpoint = _Endpoint(
            settings={
                'response_type': (AccountNumbersResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/accounts/{account_guid}/account_numbers',
                'operation_id': 'list_account_numbers_by_account',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_guid',
                    'user_guid',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'account_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'account_guid': 'account_guid',
                    'user_guid': 'user_guid',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'account_guid': 'path',
                    'user_guid': 'path',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_account_numbers_by_member_endpoint = _Endpoint(
            settings={
                'response_type': (AccountNumbersResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/account_numbers',
                'operation_id': 'list_account_numbers_by_member',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_account_owners_by_member_endpoint = _Endpoint(
            settings={
                'response_type': (AccountOwnersResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/account_owners',
                'operation_id': 'list_account_owners_by_member',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_categories_endpoint = _Endpoint(
            settings={
                'response_type': (CategoriesResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/categories',
                'operation_id': 'list_categories',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'user_guid': 'path',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_default_categories_endpoint = _Endpoint(
            settings={
                'response_type': (CategoriesResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/categories/default',
                'operation_id': 'list_default_categories',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page',
                    'records_per_page',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_default_categories_by_user_endpoint = _Endpoint(
            settings={
                'response_type': (CategoriesResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/categories/default',
                'operation_id': 'list_default_categories_by_user',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'user_guid': 'path',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_favorite_institutions_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/institutions/favorites',
                'operation_id': 'list_favorite_institutions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page',
                    'records_per_page',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_holdings_endpoint = _Endpoint(
            settings={
                'response_type': (HoldingsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/holdings',
                'operation_id': 'list_holdings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'from_date',
                    'page',
                    'records_per_page',
                    'to_date',
                ],
                'required': [
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'from_date':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                    'to_date':
                        (str,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                    'from_date': 'from_date',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'user_guid': 'path',
                    'from_date': 'query',
                    'page': 'query',
                    'records_per_page': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_holdings_by_account_endpoint = _Endpoint(
            settings={
                'response_type': (HoldingsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/accounts/{account_guid}/holdings',
                'operation_id': 'list_holdings_by_account',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_guid',
                    'user_guid',
                    'from_date',
                    'page',
                    'records_per_page',
                    'to_date',
                ],
                'required': [
                    'account_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'from_date':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                    'to_date':
                        (str,),
                },
                'attribute_map': {
                    'account_guid': 'account_guid',
                    'user_guid': 'user_guid',
                    'from_date': 'from_date',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'account_guid': 'path',
                    'user_guid': 'path',
                    'from_date': 'query',
                    'page': 'query',
                    'records_per_page': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_holdings_by_member_endpoint = _Endpoint(
            settings={
                'response_type': (HoldingsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/holdings',
                'operation_id': 'list_holdings_by_member',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                    'from_date',
                    'page',
                    'records_per_page',
                    'to_date',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'from_date':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                    'to_date':
                        (str,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                    'from_date': 'from_date',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'from_date': 'query',
                    'page': 'query',
                    'records_per_page': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_institution_credentials_endpoint = _Endpoint(
            settings={
                'response_type': (CredentialsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/institutions/{institution_code}/credentials',
                'operation_id': 'list_institution_credentials',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'institution_code',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'institution_code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'institution_code':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'institution_code': 'institution_code',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'institution_code': 'path',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_institutions_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/institutions',
                'operation_id': 'list_institutions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'name',
                    'page',
                    'records_per_page',
                    'supports_account_identification',
                    'supports_account_statement',
                    'supports_account_verification',
                    'supports_transaction_history',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'name':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                    'supports_account_identification':
                        (bool,),
                    'supports_account_statement':
                        (bool,),
                    'supports_account_verification':
                        (bool,),
                    'supports_transaction_history':
                        (bool,),
                },
                'attribute_map': {
                    'name': 'name',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                    'supports_account_identification': 'supports_account_identification',
                    'supports_account_statement': 'supports_account_statement',
                    'supports_account_verification': 'supports_account_verification',
                    'supports_transaction_history': 'supports_transaction_history',
                },
                'location_map': {
                    'name': 'query',
                    'page': 'query',
                    'records_per_page': 'query',
                    'supports_account_identification': 'query',
                    'supports_account_statement': 'query',
                    'supports_account_verification': 'query',
                    'supports_transaction_history': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_managed_accounts_endpoint = _Endpoint(
            settings={
                'response_type': (AccountsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/managed_members/{member_guid}/accounts',
                'operation_id': 'list_managed_accounts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_managed_institutions_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/managed_institutions',
                'operation_id': 'list_managed_institutions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page',
                    'records_per_page',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_managed_members_endpoint = _Endpoint(
            settings={
                'response_type': (MembersResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/managed_members',
                'operation_id': 'list_managed_members',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'user_guid': 'path',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_managed_transactions_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}/transactions',
                'operation_id': 'list_managed_transactions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_guid',
                    'member_guid',
                    'user_guid',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'account_guid',
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_guid':
                        (str,),
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'account_guid': 'account_guid',
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'account_guid': 'path',
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_member_accounts_endpoint = _Endpoint(
            settings={
                'response_type': (AccountsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/accounts',
                'operation_id': 'list_member_accounts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'member_guid',
                    'member_is_managed_by_user',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'user_guid',
                    'member_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'member_guid':
                        (str,),
                    'member_is_managed_by_user':
                        (bool,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                    'member_guid': 'member_guid',
                    'member_is_managed_by_user': 'member_is_managed_by_user',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'user_guid': 'path',
                    'member_guid': 'path',
                    'member_is_managed_by_user': 'query',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_member_challenges_endpoint = _Endpoint(
            settings={
                'response_type': (ChallengesResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/challenges',
                'operation_id': 'list_member_challenges',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_member_credentials_endpoint = _Endpoint(
            settings={
                'response_type': (CredentialsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/credentials',
                'operation_id': 'list_member_credentials',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_members_endpoint = _Endpoint(
            settings={
                'response_type': (MembersResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members',
                'operation_id': 'list_members',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'user_guid': 'path',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_merchants_endpoint = _Endpoint(
            settings={
                'response_type': (MerchantsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/merchants',
                'operation_id': 'list_merchants',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page',
                    'records_per_page',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_statements_by_member_endpoint = _Endpoint(
            settings={
                'response_type': (StatementsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/statements',
                'operation_id': 'list_statements_by_member',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_taggings_endpoint = _Endpoint(
            settings={
                'response_type': (TaggingsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/taggings',
                'operation_id': 'list_taggings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'user_guid': 'path',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_tags_endpoint = _Endpoint(
            settings={
                'response_type': (TagsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/tags',
                'operation_id': 'list_tags',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'user_guid': 'path',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_transaction_rules_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionRulesResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/transaction_rules',
                'operation_id': 'list_transaction_rules',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'user_guid': 'path',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_transactions_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/transactions',
                'operation_id': 'list_transactions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'from_date',
                    'page',
                    'records_per_page',
                    'to_date',
                ],
                'required': [
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'from_date':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                    'to_date':
                        (str,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                    'from_date': 'from_date',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'user_guid': 'path',
                    'from_date': 'query',
                    'page': 'query',
                    'records_per_page': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_transactions_by_account_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/accounts/{account_guid}/transactions',
                'operation_id': 'list_transactions_by_account',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_guid',
                    'user_guid',
                    'from_date',
                    'page',
                    'records_per_page',
                    'to_date',
                ],
                'required': [
                    'account_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'from_date':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                    'to_date':
                        (str,),
                },
                'attribute_map': {
                    'account_guid': 'account_guid',
                    'user_guid': 'user_guid',
                    'from_date': 'from_date',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'account_guid': 'path',
                    'user_guid': 'path',
                    'from_date': 'query',
                    'page': 'query',
                    'records_per_page': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_transactions_by_member_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/transactions',
                'operation_id': 'list_transactions_by_member',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                    'from_date',
                    'page',
                    'records_per_page',
                    'to_date',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'from_date':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                    'to_date':
                        (str,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                    'from_date': 'from_date',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'from_date': 'query',
                    'page': 'query',
                    'records_per_page': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_transactions_by_tag_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/tags/{tag_guid}/transactions',
                'operation_id': 'list_transactions_by_tag',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tag_guid',
                    'user_guid',
                    'from_date',
                    'page',
                    'records_per_page',
                    'to_date',
                ],
                'required': [
                    'tag_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tag_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'from_date':
                        (str,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                    'to_date':
                        (str,),
                },
                'attribute_map': {
                    'tag_guid': 'tag_guid',
                    'user_guid': 'user_guid',
                    'from_date': 'from_date',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                    'to_date': 'to_date',
                },
                'location_map': {
                    'tag_guid': 'path',
                    'user_guid': 'path',
                    'from_date': 'query',
                    'page': 'query',
                    'records_per_page': 'query',
                    'to_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_user_accounts_endpoint = _Endpoint(
            settings={
                'response_type': (AccountsResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/accounts',
                'operation_id': 'list_user_accounts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'member_is_managed_by_user',
                    'page',
                    'records_per_page',
                ],
                'required': [
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'member_is_managed_by_user':
                        (bool,),
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                    'member_is_managed_by_user': 'member_is_managed_by_user',
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                },
                'location_map': {
                    'user_guid': 'path',
                    'member_is_managed_by_user': 'query',
                    'page': 'query',
                    'records_per_page': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_users_endpoint = _Endpoint(
            settings={
                'response_type': (UsersResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users',
                'operation_id': 'list_users',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'page',
                    'records_per_page',
                    'id',
                    'email',
                    'is_disabled',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'page':
                        (int,),
                    'records_per_page':
                        (int,),
                    'id':
                        (str,),
                    'email':
                        (str,),
                    'is_disabled':
                        (bool,),
                },
                'attribute_map': {
                    'page': 'page',
                    'records_per_page': 'records_per_page',
                    'id': 'id',
                    'email': 'email',
                    'is_disabled': 'is_disabled',
                },
                'location_map': {
                    'page': 'query',
                    'records_per_page': 'query',
                    'id': 'query',
                    'email': 'query',
                    'is_disabled': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_account_endpoint = _Endpoint(
            settings={
                'response_type': (AccountResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/accounts/{account_guid}',
                'operation_id': 'read_account',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_guid',
                    'user_guid',
                ],
                'required': [
                    'account_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'account_guid': 'account_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'account_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_account_by_member_endpoint = _Endpoint(
            settings={
                'response_type': (AccountResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/accounts/{account_guid}',
                'operation_id': 'read_account_by_member',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_guid',
                    'member_guid',
                    'user_guid',
                ],
                'required': [
                    'account_guid',
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_guid':
                        (str,),
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'account_guid': 'account_guid',
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'account_guid': 'path',
                    'member_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_category_endpoint = _Endpoint(
            settings={
                'response_type': (CategoryResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/categories/{category_guid}',
                'operation_id': 'read_category',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'category_guid',
                    'user_guid',
                ],
                'required': [
                    'category_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'category_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'category_guid': 'category_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'category_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_default_category_endpoint = _Endpoint(
            settings={
                'response_type': (CategoryResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/categories/{category_guid}',
                'operation_id': 'read_default_category',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'category_guid',
                ],
                'required': [
                    'category_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'category_guid':
                        (str,),
                },
                'attribute_map': {
                    'category_guid': 'category_guid',
                },
                'location_map': {
                    'category_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_holding_endpoint = _Endpoint(
            settings={
                'response_type': (HoldingResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/holdings/{holding_guid}',
                'operation_id': 'read_holding',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'holding_guid',
                    'user_guid',
                ],
                'required': [
                    'holding_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'holding_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'holding_guid': 'holding_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'holding_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_institution_endpoint = _Endpoint(
            settings={
                'response_type': (InstitutionResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/institutions/{institution_code}',
                'operation_id': 'read_institution',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'institution_code',
                ],
                'required': [
                    'institution_code',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'institution_code':
                        (str,),
                },
                'attribute_map': {
                    'institution_code': 'institution_code',
                },
                'location_map': {
                    'institution_code': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_managed_account_endpoint = _Endpoint(
            settings={
                'response_type': (AccountResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}',
                'operation_id': 'read_managed_account',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_guid',
                    'member_guid',
                    'user_guid',
                ],
                'required': [
                    'account_guid',
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_guid':
                        (str,),
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'account_guid': 'account_guid',
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'account_guid': 'path',
                    'member_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_managed_member_endpoint = _Endpoint(
            settings={
                'response_type': (MemberResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/managed_members/{member_guid}',
                'operation_id': 'read_managed_member',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_managed_transaction_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}/transactions/{transaction_guid}',
                'operation_id': 'read_managed_transaction',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_guid',
                    'member_guid',
                    'transaction_guid',
                    'user_guid',
                ],
                'required': [
                    'account_guid',
                    'member_guid',
                    'transaction_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_guid':
                        (str,),
                    'member_guid':
                        (str,),
                    'transaction_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'account_guid': 'account_guid',
                    'member_guid': 'member_guid',
                    'transaction_guid': 'transaction_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'account_guid': 'path',
                    'member_guid': 'path',
                    'transaction_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_member_endpoint = _Endpoint(
            settings={
                'response_type': (MemberResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}',
                'operation_id': 'read_member',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_member_status_endpoint = _Endpoint(
            settings={
                'response_type': (MemberStatusResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/status',
                'operation_id': 'read_member_status',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_merchant_endpoint = _Endpoint(
            settings={
                'response_type': (MerchantResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/merchants/{merchant_guid}',
                'operation_id': 'read_merchant',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'merchant_guid',
                ],
                'required': [
                    'merchant_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'merchant_guid':
                        (str,),
                },
                'attribute_map': {
                    'merchant_guid': 'merchant_guid',
                },
                'location_map': {
                    'merchant_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_merchant_location_endpoint = _Endpoint(
            settings={
                'response_type': (MerchantLocationResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/merchant_locations/{merchant_location_guid}',
                'operation_id': 'read_merchant_location',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'merchant_location_guid',
                ],
                'required': [
                    'merchant_location_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'merchant_location_guid':
                        (str,),
                },
                'attribute_map': {
                    'merchant_location_guid': 'merchant_location_guid',
                },
                'location_map': {
                    'merchant_location_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_statement_by_member_endpoint = _Endpoint(
            settings={
                'response_type': (StatementResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/statements/{statement_guid}',
                'operation_id': 'read_statement_by_member',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'statement_guid',
                    'user_guid',
                ],
                'required': [
                    'member_guid',
                    'statement_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'statement_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'statement_guid': 'statement_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'statement_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_tag_endpoint = _Endpoint(
            settings={
                'response_type': (TagResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/tags/{tag_guid}',
                'operation_id': 'read_tag',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tag_guid',
                    'user_guid',
                ],
                'required': [
                    'tag_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tag_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'tag_guid': 'tag_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'tag_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_tagging_endpoint = _Endpoint(
            settings={
                'response_type': (TaggingResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/taggings/{tagging_guid}',
                'operation_id': 'read_tagging',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'tagging_guid',
                    'user_guid',
                ],
                'required': [
                    'tagging_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tagging_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'tagging_guid': 'tagging_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'tagging_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_transaction_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/transactions/{transaction_guid}',
                'operation_id': 'read_transaction',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transaction_guid',
                    'user_guid',
                ],
                'required': [
                    'transaction_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transaction_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'transaction_guid': 'transaction_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'transaction_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_transaction_rule_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionRuleResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/transaction_rules/{transaction_rule_guid}',
                'operation_id': 'read_transaction_rule',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'transaction_rule_guid',
                    'user_guid',
                ],
                'required': [
                    'transaction_rule_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transaction_rule_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'transaction_rule_guid': 'transaction_rule_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'transaction_rule_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.read_user_endpoint = _Endpoint(
            settings={
                'response_type': (UserResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}',
                'operation_id': 'read_user',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                ],
                'required': [
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.request_connect_widget_url_endpoint = _Endpoint(
            settings={
                'response_type': (ConnectWidgetResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/connect_widget_url',
                'operation_id': 'request_connect_widget_url',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'connect_widget_request_body',
                ],
                'required': [
                    'user_guid',
                    'connect_widget_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'connect_widget_request_body':
                        (ConnectWidgetRequestBody,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'user_guid': 'path',
                    'connect_widget_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.request_o_auth_window_uri_endpoint = _Endpoint(
            settings={
                'response_type': (OAuthWindowResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/oauth_window_uri',
                'operation_id': 'request_o_auth_window_uri',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                    'client_redirect_url',
                    'referral_source',
                    'skip_aggregation',
                    'ui_message_webview_url_scheme',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'client_redirect_url':
                        (str,),
                    'referral_source':
                        (str,),
                    'skip_aggregation':
                        (bool,),
                    'ui_message_webview_url_scheme':
                        (str,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                    'client_redirect_url': 'client_redirect_url',
                    'referral_source': 'referral_source',
                    'skip_aggregation': 'skip_aggregation',
                    'ui_message_webview_url_scheme': 'ui_message_webview_url_scheme',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'client_redirect_url': 'query',
                    'referral_source': 'query',
                    'skip_aggregation': 'query',
                    'ui_message_webview_url_scheme': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.request_widget_url_endpoint = _Endpoint(
            settings={
                'response_type': (WidgetResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/widget_urls',
                'operation_id': 'request_widget_url',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'widget_request_body',
                    'accept_language',
                ],
                'required': [
                    'user_guid',
                    'widget_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'widget_request_body':
                        (WidgetRequestBody,),
                    'accept_language':
                        (str,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                    'accept_language': 'Accept-Language',
                },
                'location_map': {
                    'user_guid': 'path',
                    'widget_request_body': 'body',
                    'accept_language': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.resume_aggregation_endpoint = _Endpoint(
            settings={
                'response_type': (MemberResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/resume',
                'operation_id': 'resume_aggregation',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                    'member_resume_request_body',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                    'member_resume_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'member_resume_request_body':
                        (MemberResumeRequestBody,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'member_resume_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_account_by_member_endpoint = _Endpoint(
            settings={
                'response_type': (AccountResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/accounts/{account_guid}',
                'operation_id': 'update_account_by_member',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_guid',
                    'member_guid',
                    'user_guid',
                    'account_update_request_body',
                ],
                'required': [
                    'account_guid',
                    'member_guid',
                    'user_guid',
                    'account_update_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_guid':
                        (str,),
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'account_update_request_body':
                        (AccountUpdateRequestBody,),
                },
                'attribute_map': {
                    'account_guid': 'account_guid',
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'account_guid': 'path',
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'account_update_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_category_endpoint = _Endpoint(
            settings={
                'response_type': (CategoryResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/categories/{category_guid}',
                'operation_id': 'update_category',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'category_guid',
                    'user_guid',
                    'category_update_request_body',
                ],
                'required': [
                    'category_guid',
                    'user_guid',
                    'category_update_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'category_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'category_update_request_body':
                        (CategoryUpdateRequestBody,),
                },
                'attribute_map': {
                    'category_guid': 'category_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'category_guid': 'path',
                    'user_guid': 'path',
                    'category_update_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_managed_account_endpoint = _Endpoint(
            settings={
                'response_type': (AccountResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}',
                'operation_id': 'update_managed_account',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_guid',
                    'member_guid',
                    'user_guid',
                    'managed_account_update_request_body',
                ],
                'required': [
                    'account_guid',
                    'member_guid',
                    'user_guid',
                    'managed_account_update_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_guid':
                        (str,),
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'managed_account_update_request_body':
                        (ManagedAccountUpdateRequestBody,),
                },
                'attribute_map': {
                    'account_guid': 'account_guid',
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'account_guid': 'path',
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'managed_account_update_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_managed_member_endpoint = _Endpoint(
            settings={
                'response_type': (MemberResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/managed_members/{member_guid}',
                'operation_id': 'update_managed_member',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                    'managed_member_update_request_body',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                    'managed_member_update_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'managed_member_update_request_body':
                        (ManagedMemberUpdateRequestBody,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'managed_member_update_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_managed_transaction_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/managed_members/{member_guid}/accounts/{account_guid}/transactions/{transaction_guid}',
                'operation_id': 'update_managed_transaction',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_guid',
                    'member_guid',
                    'transaction_guid',
                    'user_guid',
                    'managed_transaction_update_request_body',
                ],
                'required': [
                    'account_guid',
                    'member_guid',
                    'transaction_guid',
                    'user_guid',
                    'managed_transaction_update_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_guid':
                        (str,),
                    'member_guid':
                        (str,),
                    'transaction_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'managed_transaction_update_request_body':
                        (ManagedTransactionUpdateRequestBody,),
                },
                'attribute_map': {
                    'account_guid': 'account_guid',
                    'member_guid': 'member_guid',
                    'transaction_guid': 'transaction_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'account_guid': 'path',
                    'member_guid': 'path',
                    'transaction_guid': 'path',
                    'user_guid': 'path',
                    'managed_transaction_update_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_member_endpoint = _Endpoint(
            settings={
                'response_type': (MemberResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}',
                'operation_id': 'update_member',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                    'member_update_request_body',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                    'member_update_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'member_update_request_body':
                        (MemberUpdateRequestBody,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                    'member_update_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_tag_endpoint = _Endpoint(
            settings={
                'response_type': (TagResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/tags/{tag_guid}',
                'operation_id': 'update_tag',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'tag_guid',
                    'user_guid',
                    'tag_update_request_body',
                ],
                'required': [
                    'tag_guid',
                    'user_guid',
                    'tag_update_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tag_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'tag_update_request_body':
                        (TagUpdateRequestBody,),
                },
                'attribute_map': {
                    'tag_guid': 'tag_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'tag_guid': 'path',
                    'user_guid': 'path',
                    'tag_update_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_tagging_endpoint = _Endpoint(
            settings={
                'response_type': (TaggingResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/taggings/{tagging_guid}',
                'operation_id': 'update_tagging',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'tagging_guid',
                    'user_guid',
                    'tagging_update_request_body',
                ],
                'required': [
                    'tagging_guid',
                    'user_guid',
                    'tagging_update_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'tagging_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'tagging_update_request_body':
                        (TaggingUpdateRequestBody,),
                },
                'attribute_map': {
                    'tagging_guid': 'tagging_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'tagging_guid': 'path',
                    'user_guid': 'path',
                    'tagging_update_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_transaction_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/transactions/{transaction_guid}',
                'operation_id': 'update_transaction',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'transaction_guid',
                    'user_guid',
                    'transaction_update_request_body',
                ],
                'required': [
                    'transaction_guid',
                    'user_guid',
                    'transaction_update_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transaction_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'transaction_update_request_body':
                        (TransactionUpdateRequestBody,),
                },
                'attribute_map': {
                    'transaction_guid': 'transaction_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'transaction_guid': 'path',
                    'user_guid': 'path',
                    'transaction_update_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_transaction_rule_endpoint = _Endpoint(
            settings={
                'response_type': (TransactionRuleResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/transaction_rules/{transaction_rule_guid}',
                'operation_id': 'update_transaction_rule',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'transaction_rule_guid',
                    'user_guid',
                    'transaction_rule_update_request_body',
                ],
                'required': [
                    'transaction_rule_guid',
                    'user_guid',
                    'transaction_rule_update_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'transaction_rule_guid':
                        (str,),
                    'user_guid':
                        (str,),
                    'transaction_rule_update_request_body':
                        (TransactionRuleUpdateRequestBody,),
                },
                'attribute_map': {
                    'transaction_rule_guid': 'transaction_rule_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'transaction_rule_guid': 'path',
                    'user_guid': 'path',
                    'transaction_rule_update_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_user_endpoint = _Endpoint(
            settings={
                'response_type': (UserResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}',
                'operation_id': 'update_user',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'user_guid',
                    'user_update_request_body',
                ],
                'required': [
                    'user_guid',
                    'user_update_request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'user_guid':
                        (str,),
                    'user_update_request_body':
                        (UserUpdateRequestBody,),
                },
                'attribute_map': {
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'user_guid': 'path',
                    'user_update_request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.verify_member_endpoint = _Endpoint(
            settings={
                'response_type': (MemberResponseBody,),
                'auth': [
                    'basicAuth'
                ],
                'endpoint_path': '/users/{user_guid}/members/{member_guid}/verify',
                'operation_id': 'verify_member',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'member_guid',
                    'user_guid',
                ],
                'required': [
                    'member_guid',
                    'user_guid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'member_guid':
                        (str,),
                    'user_guid':
                        (str,),
                },
                'attribute_map': {
                    'member_guid': 'member_guid',
                    'user_guid': 'user_guid',
                },
                'location_map': {
                    'member_guid': 'path',
                    'user_guid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.mx.api.v1+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def aggregate_member(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """Aggregate member  # noqa: E501

        Calling this endpoint initiates an aggregation event for the member. This brings in the latest account and transaction data from the connected institution. If this data has recently been updated, MX may not initiate an aggregation event.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.aggregate_member(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MemberResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.aggregate_member_endpoint.call_with_http_info(**kwargs)

    def check_balances(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """Check balances  # noqa: E501

        This endpoint operates much like the aggregate member endpoint except that it gathers only account balance information; it does not gather any transaction data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.check_balances(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MemberResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.check_balances_endpoint.call_with_http_info(**kwargs)

    def create_category(
        self,
        user_guid,
        category_create_request_body,
        **kwargs
    ):
        """Create category  # noqa: E501

        Use this endpoint to create a new custom category for a specific `user`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_category(user_guid, category_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.
            category_create_request_body (CategoryCreateRequestBody): Custom category object to be created

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CategoryResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        kwargs['category_create_request_body'] = \
            category_create_request_body
        return self.create_category_endpoint.call_with_http_info(**kwargs)

    def create_managed_account(
        self,
        member_guid,
        user_guid,
        managed_account_create_request_body,
        **kwargs
    ):
        """Create managed account  # noqa: E501

        Use this endpoint to create a partner-managed account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_managed_account(member_guid, user_guid, managed_account_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.
            managed_account_create_request_body (ManagedAccountCreateRequestBody): Managed account to be created.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AccountResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        kwargs['managed_account_create_request_body'] = \
            managed_account_create_request_body
        return self.create_managed_account_endpoint.call_with_http_info(**kwargs)

    def create_managed_member(
        self,
        user_guid,
        managed_member_create_request_body,
        **kwargs
    ):
        """Create managed member  # noqa: E501

        Use this endpoint to create a new partner-managed `member`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_managed_member(user_guid, managed_member_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.
            managed_member_create_request_body (ManagedMemberCreateRequestBody): Managed member to be created.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MemberResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        kwargs['managed_member_create_request_body'] = \
            managed_member_create_request_body
        return self.create_managed_member_endpoint.call_with_http_info(**kwargs)

    def create_managed_transaction(
        self,
        account_guid,
        member_guid,
        user_guid,
        managed_transaction_create_request_body,
        **kwargs
    ):
        """Create managed transaction  # noqa: E501

        Use this endpoint to create a new partner-managed `transaction`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_managed_transaction(account_guid, member_guid, user_guid, managed_transaction_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            account_guid (str): The unique id for an `account`.
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.
            managed_transaction_create_request_body (ManagedTransactionCreateRequestBody): Managed transaction to be created.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TransactionResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_guid'] = \
            account_guid
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        kwargs['managed_transaction_create_request_body'] = \
            managed_transaction_create_request_body
        return self.create_managed_transaction_endpoint.call_with_http_info(**kwargs)

    def create_member(
        self,
        user_guid,
        member_create_request_body,
        **kwargs
    ):
        """Create member  # noqa: E501

        This endpoint allows you to create a new member. Members are created with the required parameters credentials and institution_code, and the optional parameters id and metadata. When creating a member, youll need to include the correct type of credential required by the financial institution and provided by the user. You can find out which credential type is required with the `/institutions/{institution_code}/credentials` endpoint. If successful, the MX Platform API will respond with the newly-created member object. Once you successfully create a member, MX will immediately validate the provided credentials and attempt to aggregate data for accounts and transactions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_member(user_guid, member_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.
            member_create_request_body (MemberCreateRequestBody): Member object to be created with optional parameters (id and metadata) and required parameters (credentials and institution_code)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MemberResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        kwargs['member_create_request_body'] = \
            member_create_request_body
        return self.create_member_endpoint.call_with_http_info(**kwargs)

    def create_tag(
        self,
        user_guid,
        tag_create_request_body,
        **kwargs
    ):
        """Create tag  # noqa: E501

        Use this endpoint to create a new custom tag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_tag(user_guid, tag_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.
            tag_create_request_body (TagCreateRequestBody): Tag object to be created with required parameters (tag_guid)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TagResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        kwargs['tag_create_request_body'] = \
            tag_create_request_body
        return self.create_tag_endpoint.call_with_http_info(**kwargs)

    def create_tagging(
        self,
        user_guid,
        tagging_create_request_body,
        **kwargs
    ):
        """Create tagging  # noqa: E501

        Use this endpoint to create a new association between a tag and a particular transaction, according to their unique GUIDs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_tagging(user_guid, tagging_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.
            tagging_create_request_body (TaggingCreateRequestBody): Tagging object to be created with required parameters (tag_guid and transaction_guid)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TaggingResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        kwargs['tagging_create_request_body'] = \
            tagging_create_request_body
        return self.create_tagging_endpoint.call_with_http_info(**kwargs)

    def create_transaction_rule(
        self,
        user_guid,
        transaction_rule_create_request_body,
        **kwargs
    ):
        """Create transaction rule  # noqa: E501

        Use this endpoint to create a new transaction rule. The newly-created `transaction_rule` object will be returned if successful.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_transaction_rule(user_guid, transaction_rule_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.
            transaction_rule_create_request_body (TransactionRuleCreateRequestBody): TransactionRule object to be created with optional parameters (description) and required parameters (category_guid and match_description)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TransactionRuleResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        kwargs['transaction_rule_create_request_body'] = \
            transaction_rule_create_request_body
        return self.create_transaction_rule_endpoint.call_with_http_info(**kwargs)

    def create_user(
        self,
        user_create_request_body,
        **kwargs
    ):
        """Create user  # noqa: E501

        Use this endpoint to create a new user. The API will respond with the newly-created user object if successful. Disabling a user means that accounts and transactions associated with it will not be updated in the background by MX. It will also restrict access to that user’s data until they are no longer disabled.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_user(user_create_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            user_create_request_body (UserCreateRequestBody): User object to be created. (None of these parameters are required, but the user object cannot be empty)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UserResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_create_request_body'] = \
            user_create_request_body
        return self.create_user_endpoint.call_with_http_info(**kwargs)

    def delete_category(
        self,
        category_guid,
        user_guid,
        **kwargs
    ):
        """Delete category  # noqa: E501

        Use this endpoint to delete a specific custom category according to its unique GUID. The API will respond with an empty object and a status of `204 No Content`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_category(category_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            category_guid (str): The unique id for a `category`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['category_guid'] = \
            category_guid
        kwargs['user_guid'] = \
            user_guid
        return self.delete_category_endpoint.call_with_http_info(**kwargs)

    def delete_managed_account(
        self,
        account_guid,
        member_guid,
        user_guid,
        **kwargs
    ):
        """Delete managed account  # noqa: E501

        Use this endpoint to delete a partner-managed account according to its unique GUID. If successful, the API will respond with a status of `204 No Content`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_managed_account(account_guid, member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            account_guid (str): The unique id for an `account`.
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_guid'] = \
            account_guid
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.delete_managed_account_endpoint.call_with_http_info(**kwargs)

    def delete_managed_member(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """Delete managed member  # noqa: E501

        Use this endpoint to delete the specified partner-managed `member`. The endpoint will respond with a status of `204 No Content` without a resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_managed_member(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.delete_managed_member_endpoint.call_with_http_info(**kwargs)

    def delete_managed_transaction(
        self,
        account_guid,
        member_guid,
        transaction_guid,
        user_guid,
        **kwargs
    ):
        """Delete managed transaction  # noqa: E501

        Use this endpoint to delete the specified partner-managed `transaction`. The endpoint will respond with a status of `204 No Content` without a resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_managed_transaction(account_guid, member_guid, transaction_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            account_guid (str): The unique id for an `account`.
            member_guid (str): The unique id for a `member`.
            transaction_guid (str): The unique id for a `transaction`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_guid'] = \
            account_guid
        kwargs['member_guid'] = \
            member_guid
        kwargs['transaction_guid'] = \
            transaction_guid
        kwargs['user_guid'] = \
            user_guid
        return self.delete_managed_transaction_endpoint.call_with_http_info(**kwargs)

    def delete_member(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """Delete member  # noqa: E501

        Accessing this endpoint will permanently delete a member.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_member(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.delete_member_endpoint.call_with_http_info(**kwargs)

    def delete_tag(
        self,
        tag_guid,
        user_guid,
        **kwargs
    ):
        """Delete tag  # noqa: E501

        Use this endpoint to permanently delete a specific tag based on its unique GUID. If successful, the API will respond with status of `204 No Content`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_tag(tag_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            tag_guid (str): The unique id for a `tag`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tag_guid'] = \
            tag_guid
        kwargs['user_guid'] = \
            user_guid
        return self.delete_tag_endpoint.call_with_http_info(**kwargs)

    def delete_tagging(
        self,
        tagging_guid,
        user_guid,
        **kwargs
    ):
        """Delete tagging  # noqa: E501

        Use this endpoint to delete a tagging according to its unique GUID. If successful, the API will respond with an empty body and a status of 204 NO Content.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_tagging(tagging_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            tagging_guid (str): The unique id for a `tagging`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tagging_guid'] = \
            tagging_guid
        kwargs['user_guid'] = \
            user_guid
        return self.delete_tagging_endpoint.call_with_http_info(**kwargs)

    def delete_transaction_rule(
        self,
        transaction_rule_guid,
        user_guid,
        **kwargs
    ):
        """Delete transaction rule  # noqa: E501

        Use this endpoint to permanently delete a transaction rule based on its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transaction_rule(transaction_rule_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            transaction_rule_guid (str): The unique id for a `transaction_rule`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['transaction_rule_guid'] = \
            transaction_rule_guid
        kwargs['user_guid'] = \
            user_guid
        return self.delete_transaction_rule_endpoint.call_with_http_info(**kwargs)

    def delete_user(
        self,
        user_guid,
        **kwargs
    ):
        """Delete user  # noqa: E501

        Use this endpoint to delete the specified `user`. The response will have a status of `204 No Content` without an object.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user(user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        return self.delete_user_endpoint.call_with_http_info(**kwargs)

    def download_statement_pdf(
        self,
        member_guid,
        statement_guid,
        user_guid,
        **kwargs
    ):
        """Download statement pdf  # noqa: E501

        Use this endpoint to download a specified statement PDF.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_statement_pdf(member_guid, statement_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            statement_guid (str): The unique id for a `statement`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['statement_guid'] = \
            statement_guid
        kwargs['user_guid'] = \
            user_guid
        return self.download_statement_pdf_endpoint.call_with_http_info(**kwargs)

    def enhance_transactions(
        self,
        enhance_transactions_request_body,
        **kwargs
    ):
        """Enhance transactions  # noqa: E501

        Use this endpoint to categorize, cleanse, and classify transactions. These transactions are not persisted or stored on the MX platform.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.enhance_transactions(enhance_transactions_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            enhance_transactions_request_body (EnhanceTransactionsRequestBody): Transaction object to be enhanced

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            EnhanceTransactionsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['enhance_transactions_request_body'] = \
            enhance_transactions_request_body
        return self.enhance_transactions_endpoint.call_with_http_info(**kwargs)

    def extend_history(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """Extend history  # noqa: E501

        Some institutions allow developers to access an extended transaction history with up to 24 months of data associated with a particular member. The process for fetching and then reading this extended transaction history is much like standard aggregation, and it may trigger multi-factor authentication.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.extend_history(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique identifier for a `member`.
            user_guid (str): The unique identifier for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MemberResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.extend_history_endpoint.call_with_http_info(**kwargs)

    def fetch_statements(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """Fetch statements  # noqa: E501

        Use this endpoint to fetch the statements associated with a particular member.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.fetch_statements(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MemberResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.fetch_statements_endpoint.call_with_http_info(**kwargs)

    def identify_member(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """Identify member  # noqa: E501

        The identify endpoint begins an identification process for an already-existing member.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.identify_member(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MemberResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.identify_member_endpoint.call_with_http_info(**kwargs)

    def list_account_numbers_by_account(
        self,
        account_guid,
        user_guid,
        **kwargs
    ):
        """List account numbers by account  # noqa: E501

        This endpoint returns a list of account numbers associated with the specified `account`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_numbers_by_account(account_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            account_guid (str): The unique id for an `account`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AccountNumbersResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_guid'] = \
            account_guid
        kwargs['user_guid'] = \
            user_guid
        return self.list_account_numbers_by_account_endpoint.call_with_http_info(**kwargs)

    def list_account_numbers_by_member(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """List account numbers by member  # noqa: E501

        This endpoint returns a list of account numbers associated with the specified `member`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_numbers_by_member(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AccountNumbersResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.list_account_numbers_by_member_endpoint.call_with_http_info(**kwargs)

    def list_account_owners_by_member(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """List account owners by member  # noqa: E501

        This endpoint returns an array with information about every account associated with a particular member.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_account_owners_by_member(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AccountOwnersResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.list_account_owners_by_member_endpoint.call_with_http_info(**kwargs)

    def list_categories(
        self,
        user_guid,
        **kwargs
    ):
        """List categories  # noqa: E501

        Use this endpoint to list all categories associated with a `user`, including both default and custom categories.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_categories(user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CategoriesResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        return self.list_categories_endpoint.call_with_http_info(**kwargs)

    def list_default_categories(
        self,
        **kwargs
    ):
        """List default categories  # noqa: E501

        Use this endpoint to retrieve a list of all the default categories and subcategories offered within the MX Platform API. In other words, each item in the returned list will have its `is_default` field set to `true`. There are currently 119 default categories and subcategories. Both the _list default categories_ and _list default categories by user_ endpoints return the same results. The different routes are provided for convenience.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_default_categories(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CategoriesResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_default_categories_endpoint.call_with_http_info(**kwargs)

    def list_default_categories_by_user(
        self,
        user_guid,
        **kwargs
    ):
        """List default categories by user  # noqa: E501

        Use this endpoint to retrieve a list of all the default categories and subcategories, scoped by user, offered within the MX Platform API. In other words, each item in the returned list will have its `is_default` field set to `true`. There are currently 119 default categories and subcategories. Both the _list default categories_ and _list default categories by user_ endpoints return the same results. The different routes are provided for convenience.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_default_categories_by_user(user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CategoriesResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        return self.list_default_categories_by_user_endpoint.call_with_http_info(**kwargs)

    def list_favorite_institutions(
        self,
        **kwargs
    ):
        """List favorite institutions  # noqa: E501

        This endpoint returns a paginated list containing institutions that have been set as the partner’s favorites, sorted by popularity. Please contact MX to set a list of favorites.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_favorite_institutions(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_favorite_institutions_endpoint.call_with_http_info(**kwargs)

    def list_holdings(
        self,
        user_guid,
        **kwargs
    ):
        """List holdings  # noqa: E501

        This endpoint returns all holdings associated with the specified `user` across all accounts and members.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_holdings(user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            from_date (str): Filter holdings from this date.. [optional]
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            to_date (str): Filter holdings to this date.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            HoldingsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        return self.list_holdings_endpoint.call_with_http_info(**kwargs)

    def list_holdings_by_account(
        self,
        account_guid,
        user_guid,
        **kwargs
    ):
        """List holdings by account  # noqa: E501

        This endpoint returns all holdings associated with the specified `account`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_holdings_by_account(account_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            account_guid (str): The unique id for the `account`.
            user_guid (str): The unique id for the `user`.

        Keyword Args:
            from_date (str): Filter holdings from this date.. [optional]
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            to_date (str): Filter holdings to this date.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            HoldingsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_guid'] = \
            account_guid
        kwargs['user_guid'] = \
            user_guid
        return self.list_holdings_by_account_endpoint.call_with_http_info(**kwargs)

    def list_holdings_by_member(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """List holdings by member  # noqa: E501

        This endpoint returns all holdings associated with the specified `member` across all accounts.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_holdings_by_member(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            from_date (str): Filter holdings from this date.. [optional]
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            to_date (str): Filter holdings to this date.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            HoldingsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.list_holdings_by_member_endpoint.call_with_http_info(**kwargs)

    def list_institution_credentials(
        self,
        institution_code,
        **kwargs
    ):
        """List institution credentials  # noqa: E501

        Use this endpoint to see which credentials will be needed to create a member for a specific institution.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_institution_credentials(institution_code, async_req=True)
        >>> result = thread.get()

        Args:
            institution_code (str): The institution_code of the institution.

        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CredentialsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['institution_code'] = \
            institution_code
        return self.list_institution_credentials_endpoint.call_with_http_info(**kwargs)

    def list_institutions(
        self,
        **kwargs
    ):
        """List institutions  # noqa: E501

        This endpoint returns a list of institutions based on the specified search term or parameter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_institutions(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            name (str): This will list only institutions in which the appended string appears.. [optional]
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            supports_account_identification (bool): Filter only institutions which support account identification.. [optional]
            supports_account_statement (bool): Filter only institutions which support account statements.. [optional]
            supports_account_verification (bool): Filter only institutions which support account verification.. [optional]
            supports_transaction_history (bool): Filter only institutions which support extended transaction history.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_institutions_endpoint.call_with_http_info(**kwargs)

    def list_managed_accounts(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """List managed accounts  # noqa: E501

        Use this endpoint to retrieve a list of all the partner-managed accounts associated with the given partner-manage member.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_managed_accounts(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AccountsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.list_managed_accounts_endpoint.call_with_http_info(**kwargs)

    def list_managed_institutions(
        self,
        **kwargs
    ):
        """List managed institutions  # noqa: E501

        This endpoint returns a list of institutions which can be used to create partner-managed members.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_managed_institutions(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_managed_institutions_endpoint.call_with_http_info(**kwargs)

    def list_managed_members(
        self,
        user_guid,
        **kwargs
    ):
        """List managed members  # noqa: E501

        This endpoint returns a list of all the partner-managed members associated with the specified `user`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_managed_members(user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MembersResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        return self.list_managed_members_endpoint.call_with_http_info(**kwargs)

    def list_managed_transactions(
        self,
        account_guid,
        member_guid,
        user_guid,
        **kwargs
    ):
        """List managed transactions  # noqa: E501

        This endpoint returns a list of all the partner-managed transactions associated with the specified `account`, scoped through a `user` and a `member`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_managed_transactions(account_guid, member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            account_guid (str): The unique id for an `account`.
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TransactionsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_guid'] = \
            account_guid
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.list_managed_transactions_endpoint.call_with_http_info(**kwargs)

    def list_member_accounts(
        self,
        user_guid,
        member_guid,
        **kwargs
    ):
        """List accounts by member  # noqa: E501

        This endpoint returns a list of all the accounts associated with the specified `member`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_member_accounts(user_guid, member_guid, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.
            member_guid (str): The unique id for a `member`.

        Keyword Args:
            member_is_managed_by_user (bool): List only accounts whose member is managed by the user.. [optional]
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AccountsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        kwargs['member_guid'] = \
            member_guid
        return self.list_member_accounts_endpoint.call_with_http_info(**kwargs)

    def list_member_challenges(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """List member challenges  # noqa: E501

        Use this endpoint for information on what multi-factor authentication challenges need to be answered in order to aggregate a member. If the aggregation is not challenged, i.e., the member does not have a connection status of `CHALLENGED`, then code `204 No Content` will be returned. If the aggregation has been challenged, i.e., the member does have a connection status of `CHALLENGED`, then code `200 OK` will be returned - along with the corresponding credentials.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_member_challenges(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ChallengesResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.list_member_challenges_endpoint.call_with_http_info(**kwargs)

    def list_member_credentials(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """List member credentials  # noqa: E501

        This endpoint returns an array which contains information on every non-MFA credential associated with a specific member.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_member_credentials(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CredentialsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.list_member_credentials_endpoint.call_with_http_info(**kwargs)

    def list_members(
        self,
        user_guid,
        **kwargs
    ):
        """List members  # noqa: E501

        This endpoint returns an array which contains information on every member associated with a specific user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_members(user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MembersResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        return self.list_members_endpoint.call_with_http_info(**kwargs)

    def list_merchants(
        self,
        **kwargs
    ):
        """List merchants  # noqa: E501

        This endpoint returns a paginated list of all the merchants in the MX system.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_merchants(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MerchantsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_merchants_endpoint.call_with_http_info(**kwargs)

    def list_statements_by_member(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """List statements by member  # noqa: E501

        Use this endpoint to get an array of available statements.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_statements_by_member(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            StatementsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.list_statements_by_member_endpoint.call_with_http_info(**kwargs)

    def list_taggings(
        self,
        user_guid,
        **kwargs
    ):
        """List taggings  # noqa: E501

        Use this endpoint to retrieve a list of all the taggings associated with a specific user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_taggings(user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TaggingsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        return self.list_taggings_endpoint.call_with_http_info(**kwargs)

    def list_tags(
        self,
        user_guid,
        **kwargs
    ):
        """List tags  # noqa: E501

        Use this endpoint to list all tags associated with the specified `user`. Each user includes the `Business` tag by default.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_tags(user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TagsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        return self.list_tags_endpoint.call_with_http_info(**kwargs)

    def list_transaction_rules(
        self,
        user_guid,
        **kwargs
    ):
        """List transaction rules  # noqa: E501

        Use this endpoint to read the attributes of all existing transaction rules belonging to the user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transaction_rules(user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TransactionRulesResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        return self.list_transaction_rules_endpoint.call_with_http_info(**kwargs)

    def list_transactions(
        self,
        user_guid,
        **kwargs
    ):
        """List transactions  # noqa: E501

        Requests to this endpoint return a list of transactions associated with the specified `user`, accross all members and accounts associated with that `user`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions(user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            from_date (str): Filter transactions from this date.. [optional]
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            to_date (str): Filter transactions to this date.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TransactionsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        return self.list_transactions_endpoint.call_with_http_info(**kwargs)

    def list_transactions_by_account(
        self,
        account_guid,
        user_guid,
        **kwargs
    ):
        """List transactions by account  # noqa: E501

        This endpoint returns a list of the last 90 days of transactions associated with the specified account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions_by_account(account_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            account_guid (str): The unique id for an `account`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            from_date (str): Filter transactions from this date.. [optional]
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            to_date (str): Filter transactions to this date.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TransactionsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_guid'] = \
            account_guid
        kwargs['user_guid'] = \
            user_guid
        return self.list_transactions_by_account_endpoint.call_with_http_info(**kwargs)

    def list_transactions_by_member(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """List transactions by member  # noqa: E501

        Requests to this endpoint return a list of transactions associated with the specified `member`, accross all accounts associated with that `member`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions_by_member(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            from_date (str): Filter transactions from this date.. [optional]
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            to_date (str): Filter transactions to this date.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TransactionsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.list_transactions_by_member_endpoint.call_with_http_info(**kwargs)

    def list_transactions_by_tag(
        self,
        tag_guid,
        user_guid,
        **kwargs
    ):
        """List transactions by tag  # noqa: E501

        Use this endpoint to get a list of all transactions associated with a particular tag according to the tag’s unique GUID. In other words, a list of all transactions that have been assigned to a particular tag using the create a tagging endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions_by_tag(tag_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            tag_guid (str): The unique id for a `tag`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            from_date (str): Filter transactions from this date.. [optional]
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            to_date (str): Filter transactions to this date.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TransactionsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tag_guid'] = \
            tag_guid
        kwargs['user_guid'] = \
            user_guid
        return self.list_transactions_by_tag_endpoint.call_with_http_info(**kwargs)

    def list_user_accounts(
        self,
        user_guid,
        **kwargs
    ):
        """List accounts  # noqa: E501

        This endpoint returns a list of all the accounts associated with the specified `user`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_user_accounts(user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            member_is_managed_by_user (bool): List only accounts whose member is managed by the user.. [optional]
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AccountsResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        return self.list_user_accounts_endpoint.call_with_http_info(**kwargs)

    def list_users(
        self,
        **kwargs
    ):
        """List users  # noqa: E501

        Use this endpoint to list every user you've created in the MX Platform API.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_users(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            page (int): Specify current page.. [optional]
            records_per_page (int): Specify records per page.. [optional]
            id (str): The user `id` to search for.. [optional]
            email (str): The user `email` to search for.. [optional]
            is_disabled (bool): Search for users that are diabled.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UsersResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.list_users_endpoint.call_with_http_info(**kwargs)

    def read_account(
        self,
        account_guid,
        user_guid,
        **kwargs
    ):
        """Read account  # noqa: E501

        This endpoint returns the specified `account` resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_account(account_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            account_guid (str): The unique id for an `account`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AccountResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_guid'] = \
            account_guid
        kwargs['user_guid'] = \
            user_guid
        return self.read_account_endpoint.call_with_http_info(**kwargs)

    def read_account_by_member(
        self,
        account_guid,
        member_guid,
        user_guid,
        **kwargs
    ):
        """Read account by member  # noqa: E501

        This endpoint allows you to read the attributes of an `account` resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_account_by_member(account_guid, member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            account_guid (str): The unique id for an `account`.
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AccountResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_guid'] = \
            account_guid
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.read_account_by_member_endpoint.call_with_http_info(**kwargs)

    def read_category(
        self,
        category_guid,
        user_guid,
        **kwargs
    ):
        """Read a custom category  # noqa: E501

        Use this endpoint to read the attributes of either a default category or a custom category.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_category(category_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            category_guid (str): The unique id for a `category`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CategoryResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['category_guid'] = \
            category_guid
        kwargs['user_guid'] = \
            user_guid
        return self.read_category_endpoint.call_with_http_info(**kwargs)

    def read_default_category(
        self,
        category_guid,
        **kwargs
    ):
        """Read a default category  # noqa: E501

        Use this endpoint to read the attributes of a default category.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_default_category(category_guid, async_req=True)
        >>> result = thread.get()

        Args:
            category_guid (str): The unique id for a `category`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CategoryResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['category_guid'] = \
            category_guid
        return self.read_default_category_endpoint.call_with_http_info(**kwargs)

    def read_holding(
        self,
        holding_guid,
        user_guid,
        **kwargs
    ):
        """Read holding  # noqa: E501

        Use this endpoint to read the attributes of a specific `holding`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_holding(holding_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            holding_guid (str): The unique id for a `holding`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            HoldingResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['holding_guid'] = \
            holding_guid
        kwargs['user_guid'] = \
            user_guid
        return self.read_holding_endpoint.call_with_http_info(**kwargs)

    def read_institution(
        self,
        institution_code,
        **kwargs
    ):
        """Read institution  # noqa: E501

        This endpoint returns information about the institution specified by `institution_code`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_institution(institution_code, async_req=True)
        >>> result = thread.get()

        Args:
            institution_code (str): The institution_code of the institution.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            InstitutionResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['institution_code'] = \
            institution_code
        return self.read_institution_endpoint.call_with_http_info(**kwargs)

    def read_managed_account(
        self,
        account_guid,
        member_guid,
        user_guid,
        **kwargs
    ):
        """Read managed account  # noqa: E501

        Use this endpoint to read the attributes of a partner-managed account according to its unique guid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_managed_account(account_guid, member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            account_guid (str): The unique id for an `account`.
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AccountResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_guid'] = \
            account_guid
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.read_managed_account_endpoint.call_with_http_info(**kwargs)

    def read_managed_member(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """Read managed member  # noqa: E501

        This endpoint returns the attributes of the specified partner-managed `member`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_managed_member(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MemberResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.read_managed_member_endpoint.call_with_http_info(**kwargs)

    def read_managed_transaction(
        self,
        account_guid,
        member_guid,
        transaction_guid,
        user_guid,
        **kwargs
    ):
        """Read managed transaction  # noqa: E501

        Requests to this endpoint will return the attributes of the specified partner-managed `transaction`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_managed_transaction(account_guid, member_guid, transaction_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            account_guid (str): The unique id for an `account`.
            member_guid (str): The unique id for a `member`.
            transaction_guid (str): The unique id for a `transaction`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TransactionResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_guid'] = \
            account_guid
        kwargs['member_guid'] = \
            member_guid
        kwargs['transaction_guid'] = \
            transaction_guid
        kwargs['user_guid'] = \
            user_guid
        return self.read_managed_transaction_endpoint.call_with_http_info(**kwargs)

    def read_member(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """Read member  # noqa: E501

        Use this endpoint to read the attributes of a specific member.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_member(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MemberResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.read_member_endpoint.call_with_http_info(**kwargs)

    def read_member_status(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """Read member status  # noqa: E501

        This endpoint provides the status of the members most recent aggregation event. This is an important step in the aggregation process, and the results returned by this endpoint should determine what you do next in order to successfully aggregate a member. MX has introduced new, more detailed information on the current status of a members connection to a financial institution and the state of its aggregation - the connection_status field. These are intended to replace and expand upon the information provided in the status field, which will soon be deprecated; support for the status field remains for the time being.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_member_status(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MemberStatusResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.read_member_status_endpoint.call_with_http_info(**kwargs)

    def read_merchant(
        self,
        merchant_guid,
        **kwargs
    ):
        """Read merchant  # noqa: E501

        Returns information about a particular merchant, such as a logo, name, and website.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_merchant(merchant_guid, async_req=True)
        >>> result = thread.get()

        Args:
            merchant_guid (str): The unique id for a `merchant`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MerchantResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['merchant_guid'] = \
            merchant_guid
        return self.read_merchant_endpoint.call_with_http_info(**kwargs)

    def read_merchant_location(
        self,
        merchant_location_guid,
        **kwargs
    ):
        """Read merchant location  # noqa: E501

        This endpoint returns the specified merchant_location resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_merchant_location(merchant_location_guid, async_req=True)
        >>> result = thread.get()

        Args:
            merchant_location_guid (str): The unique id for a `merchant_location`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MerchantLocationResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['merchant_location_guid'] = \
            merchant_location_guid
        return self.read_merchant_location_endpoint.call_with_http_info(**kwargs)

    def read_statement_by_member(
        self,
        member_guid,
        statement_guid,
        user_guid,
        **kwargs
    ):
        """Read statement by member  # noqa: E501

        Use this endpoint to read a JSON representation of the statement.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_statement_by_member(member_guid, statement_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            statement_guid (str): The unique id for a `statement`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            StatementResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['statement_guid'] = \
            statement_guid
        kwargs['user_guid'] = \
            user_guid
        return self.read_statement_by_member_endpoint.call_with_http_info(**kwargs)

    def read_tag(
        self,
        tag_guid,
        user_guid,
        **kwargs
    ):
        """Read tag  # noqa: E501

        Use this endpoint to read the attributes of a particular tag according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_tag(tag_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            tag_guid (str): The unique id for a `tag`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TagResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tag_guid'] = \
            tag_guid
        kwargs['user_guid'] = \
            user_guid
        return self.read_tag_endpoint.call_with_http_info(**kwargs)

    def read_tagging(
        self,
        tagging_guid,
        user_guid,
        **kwargs
    ):
        """Read tagging  # noqa: E501

        Use this endpoint to read the attributes of a `tagging` according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_tagging(tagging_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            tagging_guid (str): The unique id for a `tagging`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TaggingResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tagging_guid'] = \
            tagging_guid
        kwargs['user_guid'] = \
            user_guid
        return self.read_tagging_endpoint.call_with_http_info(**kwargs)

    def read_transaction(
        self,
        transaction_guid,
        user_guid,
        **kwargs
    ):
        """Read transaction  # noqa: E501

        Requests to this endpoint will return the attributes of the specified `transaction`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_transaction(transaction_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            transaction_guid (str): The unique id for a `transaction`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TransactionResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['transaction_guid'] = \
            transaction_guid
        kwargs['user_guid'] = \
            user_guid
        return self.read_transaction_endpoint.call_with_http_info(**kwargs)

    def read_transaction_rule(
        self,
        transaction_rule_guid,
        user_guid,
        **kwargs
    ):
        """Read transaction rule  # noqa: E501

        Use this endpoint to read the attributes of an existing transaction rule based on the rule’s unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_transaction_rule(transaction_rule_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            transaction_rule_guid (str): The unique id for a `transaction_rule`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TransactionRuleResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['transaction_rule_guid'] = \
            transaction_rule_guid
        kwargs['user_guid'] = \
            user_guid
        return self.read_transaction_rule_endpoint.call_with_http_info(**kwargs)

    def read_user(
        self,
        user_guid,
        **kwargs
    ):
        """Read user  # noqa: E501

        Use this endpoint to read the attributes of a specific user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_user(user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UserResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        return self.read_user_endpoint.call_with_http_info(**kwargs)

    def request_connect_widget_url(
        self,
        user_guid,
        connect_widget_request_body,
        **kwargs
    ):
        """Request connect widget url  # noqa: E501

        This endpoint will return a URL for an embeddable version of MX Connect.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.request_connect_widget_url(user_guid, connect_widget_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.
            connect_widget_request_body (ConnectWidgetRequestBody): Optional config options for WebView (is_mobile_webview, current_institution_code, current_member_guid, update_credentials)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ConnectWidgetResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        kwargs['connect_widget_request_body'] = \
            connect_widget_request_body
        return self.request_connect_widget_url_endpoint.call_with_http_info(**kwargs)

    def request_o_auth_window_uri(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """Request oauth window uri  # noqa: E501

        This endpoint will generate an `oauth_window_uri` for the specified `member`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.request_o_auth_window_uri(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            client_redirect_url (str): A URL that MX will redirect to at the end of OAuth with additional query parameters. Only available with `referral_source=APP`.. [optional]
            referral_source (str): Must be either `BROWSER` or `APP` depending on the implementation. Defaults to `BROWSER`.. [optional]
            skip_aggregation (bool): Setting this parameter to `true` will prevent the member from automatically aggregating after being redirected from the authorization page.. [optional]
            ui_message_webview_url_scheme (str): A scheme for routing the user back to the application state they were previously in. Only available with `referral_source=APP`.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            OAuthWindowResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.request_o_auth_window_uri_endpoint.call_with_http_info(**kwargs)

    def request_widget_url(
        self,
        user_guid,
        widget_request_body,
        **kwargs
    ):
        """Request widget url  # noqa: E501

        This endpoint allows partners to get a URL by passing the `widget_type` in the request body, as well as configuring it in several different ways. In the case of Connect, that means setting the `widget_type` to `connect_widget`. Partners may also pass an optional `Accept-Language` header as well as a number of configuration options. Note that this is a `POST` request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.request_widget_url(user_guid, widget_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.
            widget_request_body (WidgetRequestBody): The widget url configuration options.

        Keyword Args:
            accept_language (str): The desired language of the widget.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            WidgetResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        kwargs['widget_request_body'] = \
            widget_request_body
        return self.request_widget_url_endpoint.call_with_http_info(**kwargs)

    def resume_aggregation(
        self,
        member_guid,
        user_guid,
        member_resume_request_body,
        **kwargs
    ):
        """Resume aggregation  # noqa: E501

        This endpoint answers the challenges needed when a member has been challenged by multi-factor authentication.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.resume_aggregation(member_guid, user_guid, member_resume_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.
            member_resume_request_body (MemberResumeRequestBody): Member object with MFA challenge answers

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MemberResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        kwargs['member_resume_request_body'] = \
            member_resume_request_body
        return self.resume_aggregation_endpoint.call_with_http_info(**kwargs)

    def update_account_by_member(
        self,
        account_guid,
        member_guid,
        user_guid,
        account_update_request_body,
        **kwargs
    ):
        """Update account by member  # noqa: E501

        This endpoint allows you to update certain attributes of an `account` resource.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_account_by_member(account_guid, member_guid, user_guid, account_update_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            account_guid (str): The unique id for an `account`.
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.
            account_update_request_body (AccountUpdateRequestBody): Account object to be created with optional parameters (is_hidden)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AccountResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_guid'] = \
            account_guid
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        kwargs['account_update_request_body'] = \
            account_update_request_body
        return self.update_account_by_member_endpoint.call_with_http_info(**kwargs)

    def update_category(
        self,
        category_guid,
        user_guid,
        category_update_request_body,
        **kwargs
    ):
        """Update category  # noqa: E501

        Use this endpoint to update the attributes of a custom category according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_category(category_guid, user_guid, category_update_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            category_guid (str): The unique id for a `category`.
            user_guid (str): The unique id for a `user`.
            category_update_request_body (CategoryUpdateRequestBody): Category object to be updated (While no single parameter is required, the `category` object cannot be empty)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CategoryResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['category_guid'] = \
            category_guid
        kwargs['user_guid'] = \
            user_guid
        kwargs['category_update_request_body'] = \
            category_update_request_body
        return self.update_category_endpoint.call_with_http_info(**kwargs)

    def update_managed_account(
        self,
        account_guid,
        member_guid,
        user_guid,
        managed_account_update_request_body,
        **kwargs
    ):
        """Update managed account  # noqa: E501

        Use this endpoint to update the attributes of a partner-managed account according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_managed_account(account_guid, member_guid, user_guid, managed_account_update_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            account_guid (str): The unique id for an `account`.
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.
            managed_account_update_request_body (ManagedAccountUpdateRequestBody): Managed account object to be updated (While no single parameter is required, the request body can't be empty)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AccountResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_guid'] = \
            account_guid
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        kwargs['managed_account_update_request_body'] = \
            managed_account_update_request_body
        return self.update_managed_account_endpoint.call_with_http_info(**kwargs)

    def update_managed_member(
        self,
        member_guid,
        user_guid,
        managed_member_update_request_body,
        **kwargs
    ):
        """Update managed member  # noqa: E501

        Use this endpoint to update the attributes of the specified partner_managed `member`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_managed_member(member_guid, user_guid, managed_member_update_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.
            managed_member_update_request_body (ManagedMemberUpdateRequestBody): Managed member object to be updated (While no single parameter is required, the request body can't be empty)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MemberResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        kwargs['managed_member_update_request_body'] = \
            managed_member_update_request_body
        return self.update_managed_member_endpoint.call_with_http_info(**kwargs)

    def update_managed_transaction(
        self,
        account_guid,
        member_guid,
        transaction_guid,
        user_guid,
        managed_transaction_update_request_body,
        **kwargs
    ):
        """Update managed transaction  # noqa: E501

        Use this endpoint to update the attributes of the specified partner_managed `transaction`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_managed_transaction(account_guid, member_guid, transaction_guid, user_guid, managed_transaction_update_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            account_guid (str): The unique id for an `account`.
            member_guid (str): The unique id for a `member`.
            transaction_guid (str): The unique id for a `transaction`.
            user_guid (str): The unique id for a `user`.
            managed_transaction_update_request_body (ManagedTransactionUpdateRequestBody): Managed transaction object to be updated (While no single parameter is required, the request body can't be empty)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TransactionResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_guid'] = \
            account_guid
        kwargs['member_guid'] = \
            member_guid
        kwargs['transaction_guid'] = \
            transaction_guid
        kwargs['user_guid'] = \
            user_guid
        kwargs['managed_transaction_update_request_body'] = \
            managed_transaction_update_request_body
        return self.update_managed_transaction_endpoint.call_with_http_info(**kwargs)

    def update_member(
        self,
        member_guid,
        user_guid,
        member_update_request_body,
        **kwargs
    ):
        """Update member  # noqa: E501

        Use this endpoint to update a members attributes. Only the credentials, id, and metadata parameters can be updated. To get a list of the required credentials for the member, use the list member credentials endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_member(member_guid, user_guid, member_update_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.
            member_update_request_body (MemberUpdateRequestBody): Member object to be updated (While no single parameter is required, the request body can't be empty)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MemberResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        kwargs['member_update_request_body'] = \
            member_update_request_body
        return self.update_member_endpoint.call_with_http_info(**kwargs)

    def update_tag(
        self,
        tag_guid,
        user_guid,
        tag_update_request_body,
        **kwargs
    ):
        """Update tag  # noqa: E501

        Use this endpoint to update the name of a specific tag according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_tag(tag_guid, user_guid, tag_update_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            tag_guid (str): The unique id for a `tag`.
            user_guid (str): The unique id for a `user`.
            tag_update_request_body (TagUpdateRequestBody): Tag object to be updated with required parameter (tag_guid)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TagResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tag_guid'] = \
            tag_guid
        kwargs['user_guid'] = \
            user_guid
        kwargs['tag_update_request_body'] = \
            tag_update_request_body
        return self.update_tag_endpoint.call_with_http_info(**kwargs)

    def update_tagging(
        self,
        tagging_guid,
        user_guid,
        tagging_update_request_body,
        **kwargs
    ):
        """Update tagging  # noqa: E501

        Use this endpoint to update a tagging.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_tagging(tagging_guid, user_guid, tagging_update_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            tagging_guid (str): The unique id for a `tagging`.
            user_guid (str): The unique id for a `user`.
            tagging_update_request_body (TaggingUpdateRequestBody): Tagging object to be updated with required parameter (tag_guid)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TaggingResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['tagging_guid'] = \
            tagging_guid
        kwargs['user_guid'] = \
            user_guid
        kwargs['tagging_update_request_body'] = \
            tagging_update_request_body
        return self.update_tagging_endpoint.call_with_http_info(**kwargs)

    def update_transaction(
        self,
        transaction_guid,
        user_guid,
        transaction_update_request_body,
        **kwargs
    ):
        """Update transaction  # noqa: E501

        Use this endpoint to update the `description` of a specific transaction according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_transaction(transaction_guid, user_guid, transaction_update_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            transaction_guid (str): The unique id for a `transaction`.
            user_guid (str): The unique id for a `user`.
            transaction_update_request_body (TransactionUpdateRequestBody): Transaction object to be updated with a new description

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TransactionResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['transaction_guid'] = \
            transaction_guid
        kwargs['user_guid'] = \
            user_guid
        kwargs['transaction_update_request_body'] = \
            transaction_update_request_body
        return self.update_transaction_endpoint.call_with_http_info(**kwargs)

    def update_transaction_rule(
        self,
        transaction_rule_guid,
        user_guid,
        transaction_rule_update_request_body,
        **kwargs
    ):
        """Update transaction_rule  # noqa: E501

        Use this endpoint to update the attributes of a specific transaction rule based on its unique GUID. The API will respond with the updated transaction_rule object. Any attributes not provided will be left unchanged.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_transaction_rule(transaction_rule_guid, user_guid, transaction_rule_update_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            transaction_rule_guid (str): The unique id for a `transaction_rule`.
            user_guid (str): The unique id for a `user`.
            transaction_rule_update_request_body (TransactionRuleUpdateRequestBody): TransactionRule object to be updated

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            TransactionRuleResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['transaction_rule_guid'] = \
            transaction_rule_guid
        kwargs['user_guid'] = \
            user_guid
        kwargs['transaction_rule_update_request_body'] = \
            transaction_rule_update_request_body
        return self.update_transaction_rule_endpoint.call_with_http_info(**kwargs)

    def update_user(
        self,
        user_guid,
        user_update_request_body,
        **kwargs
    ):
        """Update user  # noqa: E501

        Use this endpoint to update the attributes of the specified user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user(user_guid, user_update_request_body, async_req=True)
        >>> result = thread.get()

        Args:
            user_guid (str): The unique id for a `user`.
            user_update_request_body (UserUpdateRequestBody): User object to be updated (None of these parameters are required, but the user object cannot be empty.)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            UserResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['user_guid'] = \
            user_guid
        kwargs['user_update_request_body'] = \
            user_update_request_body
        return self.update_user_endpoint.call_with_http_info(**kwargs)

    def verify_member(
        self,
        member_guid,
        user_guid,
        **kwargs
    ):
        """Verify member  # noqa: E501

        The verify endpoint begins a verification process for a member.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.verify_member(member_guid, user_guid, async_req=True)
        >>> result = thread.get()

        Args:
            member_guid (str): The unique id for a `member`.
            user_guid (str): The unique id for a `user`.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MemberResponseBody
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['member_guid'] = \
            member_guid
        kwargs['user_guid'] = \
            user_guid
        return self.verify_member_endpoint.call_with_http_info(**kwargs)

