# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr

class AccountCreateRequest(BaseModel):
    """
    AccountCreateRequest
    """
    account_subtype: Optional[StrictStr] = None
    account_type: StrictStr = Field(...)
    apr: Optional[Union[StrictFloat, StrictInt]] = None
    apy: Optional[Union[StrictFloat, StrictInt]] = None
    available_balance: Optional[Union[StrictFloat, StrictInt]] = None
    balance: Optional[Union[StrictFloat, StrictInt]] = None
    cash_surrender_value: Optional[Union[StrictFloat, StrictInt]] = None
    credit_limit: Optional[Union[StrictFloat, StrictInt]] = None
    currency_code: Optional[StrictStr] = None
    death_benefit: Optional[StrictInt] = None
    interest_rate: Optional[Union[StrictFloat, StrictInt]] = None
    is_business: Optional[StrictBool] = None
    is_closed: Optional[StrictBool] = None
    is_hidden: Optional[StrictBool] = None
    loan_amount: Optional[Union[StrictFloat, StrictInt]] = None
    metadata: Optional[StrictStr] = None
    name: StrictStr = Field(...)
    nickname: Optional[StrictStr] = None
    original_balance: Optional[Union[StrictFloat, StrictInt]] = None
    property_type: Optional[StrictStr] = None
    skip_webhook: Optional[StrictBool] = None
    __properties = ["account_subtype", "account_type", "apr", "apy", "available_balance", "balance", "cash_surrender_value", "credit_limit", "currency_code", "death_benefit", "interest_rate", "is_business", "is_closed", "is_hidden", "loan_amount", "metadata", "name", "nickname", "original_balance", "property_type", "skip_webhook"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountCreateRequest:
        """Create an instance of AccountCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountCreateRequest:
        """Create an instance of AccountCreateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AccountCreateRequest.parse_obj(obj)

        _obj = AccountCreateRequest.parse_obj({
            "account_subtype": obj.get("account_subtype"),
            "account_type": obj.get("account_type"),
            "apr": obj.get("apr"),
            "apy": obj.get("apy"),
            "available_balance": obj.get("available_balance"),
            "balance": obj.get("balance"),
            "cash_surrender_value": obj.get("cash_surrender_value"),
            "credit_limit": obj.get("credit_limit"),
            "currency_code": obj.get("currency_code"),
            "death_benefit": obj.get("death_benefit"),
            "interest_rate": obj.get("interest_rate"),
            "is_business": obj.get("is_business"),
            "is_closed": obj.get("is_closed"),
            "is_hidden": obj.get("is_hidden"),
            "loan_amount": obj.get("loan_amount"),
            "metadata": obj.get("metadata"),
            "name": obj.get("name"),
            "nickname": obj.get("nickname"),
            "original_balance": obj.get("original_balance"),
            "property_type": obj.get("property_type"),
            "skip_webhook": obj.get("skip_webhook")
        })
        return _obj


