# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictInt, StrictStr

from typing import Optional

from mx_platform_python.models.spending_plan_account_response import SpendingPlanAccountResponse
from mx_platform_python.models.spending_plan_accounts_response import SpendingPlanAccountsResponse
from mx_platform_python.models.spending_plan_iteration_item_create_request_body import SpendingPlanIterationItemCreateRequestBody
from mx_platform_python.models.spending_plan_iteration_item_response import SpendingPlanIterationItemResponse
from mx_platform_python.models.spending_plan_iteration_items_response_body import SpendingPlanIterationItemsResponseBody
from mx_platform_python.models.spending_plan_iteration_response import SpendingPlanIterationResponse
from mx_platform_python.models.spending_plan_iterations_response import SpendingPlanIterationsResponse
from mx_platform_python.models.spending_plan_response import SpendingPlanResponse
from mx_platform_python.models.spending_plans_response_body import SpendingPlansResponseBody

from mx_platform_python.api_client import ApiClient
from mx_platform_python.api_response import ApiResponse
from mx_platform_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class SpendingPlanApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_spending_plan(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], **kwargs) -> SpendingPlanResponse:  # noqa: E501
        """Create spending plan  # noqa: E501

        This endpoint creates a new `spending_plan` for the user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_spending_plan(user_guid, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpendingPlanResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_spending_plan_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.create_spending_plan_with_http_info(user_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def create_spending_plan_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Create spending plan  # noqa: E501

        This endpoint creates a new `spending_plan` for the user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_spending_plan_with_http_info(user_guid, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpendingPlanResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_spending_plan" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "SpendingPlanResponse",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/spending_plans', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_spending_plan_iteration_item(self, spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_iteration_item_create_request_body : Annotated[SpendingPlanIterationItemCreateRequestBody, Field(..., description="Iteration item to be created with required parameters (planned_amount)")], **kwargs) -> SpendingPlanIterationItemResponse:  # noqa: E501
        """Create spending plan iteration item  # noqa: E501

        This endpoint creates a new `spending_plan_iteration_item`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_spending_plan_iteration_item(spending_plan_guid, user_guid, spending_plan_iteration_item_create_request_body, async_req=True)
        >>> result = thread.get()

        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_iteration_item_create_request_body: Iteration item to be created with required parameters (planned_amount) (required)
        :type spending_plan_iteration_item_create_request_body: SpendingPlanIterationItemCreateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpendingPlanIterationItemResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_spending_plan_iteration_item_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.create_spending_plan_iteration_item_with_http_info(spending_plan_guid, user_guid, spending_plan_iteration_item_create_request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def create_spending_plan_iteration_item_with_http_info(self, spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_iteration_item_create_request_body : Annotated[SpendingPlanIterationItemCreateRequestBody, Field(..., description="Iteration item to be created with required parameters (planned_amount)")], **kwargs) -> ApiResponse:  # noqa: E501
        """Create spending plan iteration item  # noqa: E501

        This endpoint creates a new `spending_plan_iteration_item`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_spending_plan_iteration_item_with_http_info(spending_plan_guid, user_guid, spending_plan_iteration_item_create_request_body, async_req=True)
        >>> result = thread.get()

        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_iteration_item_create_request_body: Iteration item to be created with required parameters (planned_amount) (required)
        :type spending_plan_iteration_item_create_request_body: SpendingPlanIterationItemCreateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpendingPlanIterationItemResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'spending_plan_guid',
            'user_guid',
            'spending_plan_iteration_item_create_request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_spending_plan_iteration_item" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['spending_plan_guid']:
            _path_params['spending_plan_guid'] = _params['spending_plan_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['spending_plan_iteration_item_create_request_body'] is not None:
            _body_params = _params['spending_plan_iteration_item_create_request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "SpendingPlanIterationItemResponse",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/spending_plans/{spending_plan_guid}/iterations/current/iteration_items', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_spending_plan(self, user_guid : Annotated[StrictStr, Field(..., description="The unique ID for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], **kwargs) -> None:  # noqa: E501
        """Delete spending plan  # noqa: E501

        Use this endpoint to delete a user's `spending_plan`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_spending_plan(user_guid, spending_plan_guid, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique ID for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_spending_plan_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_spending_plan_with_http_info(user_guid, spending_plan_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_spending_plan_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique ID for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete spending plan  # noqa: E501

        Use this endpoint to delete a user's `spending_plan`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_spending_plan_with_http_info(user_guid, spending_plan_guid, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique ID for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'spending_plan_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_spending_plan" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['spending_plan_guid']:
            _path_params['spending_plan_guid'] = _params['spending_plan_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/users/{user_guid}/spending_plans/{spending_plan_guid}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_spending_plan_account(self, user_guid : Annotated[StrictStr, Field(..., description="The unique ID for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], spending_plan_account_guid : Annotated[StrictStr, Field(..., description="The unique ID for the specified account.")], **kwargs) -> None:  # noqa: E501
        """Delete spending plan account  # noqa: E501

        Use this endpoint to delete a `spending_plan_account`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_spending_plan_account(user_guid, spending_plan_guid, spending_plan_account_guid, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique ID for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param spending_plan_account_guid: The unique ID for the specified account. (required)
        :type spending_plan_account_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_spending_plan_account_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_spending_plan_account_with_http_info(user_guid, spending_plan_guid, spending_plan_account_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_spending_plan_account_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique ID for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], spending_plan_account_guid : Annotated[StrictStr, Field(..., description="The unique ID for the specified account.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete spending plan account  # noqa: E501

        Use this endpoint to delete a `spending_plan_account`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_spending_plan_account_with_http_info(user_guid, spending_plan_guid, spending_plan_account_guid, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique ID for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param spending_plan_account_guid: The unique ID for the specified account. (required)
        :type spending_plan_account_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'spending_plan_guid',
            'spending_plan_account_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_spending_plan_account" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['spending_plan_guid']:
            _path_params['spending_plan_guid'] = _params['spending_plan_guid']

        if _params['spending_plan_account_guid']:
            _path_params['spending_plan_account_guid'] = _params['spending_plan_account_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/users/{user_guid}/spending_plans/{spending_plan_guid}/spending_plan_accounts/{spending_plan_account_guid}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_spending_plan_iteration_item(self, user_guid : Annotated[StrictStr, Field(..., description="The unique ID for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], iteration_item_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `iteration_item`.")], **kwargs) -> None:  # noqa: E501
        """Delete spending plan iteration item  # noqa: E501

        Use this endpoint to delete a spending plan `iteration_item`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_spending_plan_iteration_item(user_guid, spending_plan_guid, iteration_item_guid, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique ID for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param iteration_item_guid: The unique ID for the `iteration_item`. (required)
        :type iteration_item_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_spending_plan_iteration_item_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.delete_spending_plan_iteration_item_with_http_info(user_guid, spending_plan_guid, iteration_item_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_spending_plan_iteration_item_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique ID for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], iteration_item_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `iteration_item`.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete spending plan iteration item  # noqa: E501

        Use this endpoint to delete a spending plan `iteration_item`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_spending_plan_iteration_item_with_http_info(user_guid, spending_plan_guid, iteration_item_guid, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique ID for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param iteration_item_guid: The unique ID for the `iteration_item`. (required)
        :type iteration_item_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'spending_plan_guid',
            'iteration_item_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_spending_plan_iteration_item" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['spending_plan_guid']:
            _path_params['spending_plan_guid'] = _params['spending_plan_guid']

        if _params['iteration_item_guid']:
            _path_params['iteration_item_guid'] = _params['iteration_item_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/users/{user_guid}/spending_plans/{spending_plan_guid}/iterations/current/iteration_items/{iteration_item_guid}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_spending_plan_accounts(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> SpendingPlanAccountsResponse:  # noqa: E501
        """List spending plan accounts  # noqa: E501

        Use this endpoint to list all the spending plan accounts associated with the spending plan.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_spending_plan_accounts(user_guid, spending_plan_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpendingPlanAccountsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_spending_plan_accounts_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_spending_plan_accounts_with_http_info(user_guid, spending_plan_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_spending_plan_accounts_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List spending plan accounts  # noqa: E501

        Use this endpoint to list all the spending plan accounts associated with the spending plan.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_spending_plan_accounts_with_http_info(user_guid, spending_plan_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpendingPlanAccountsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'spending_plan_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_spending_plan_accounts" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['spending_plan_guid']:
            _path_params['spending_plan_guid'] = _params['spending_plan_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "SpendingPlanAccountsResponse",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/spending_plans/{spending_plan_guid}/spending_plan_accounts', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_spending_plan_iteration_items(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> SpendingPlanIterationItemsResponseBody:  # noqa: E501
        """List spending plan iteration items  # noqa: E501

        Use this endpoint to list all the spending plan `iteration_items` associated with the `iteration`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_spending_plan_iteration_items(user_guid, spending_plan_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpendingPlanIterationItemsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_spending_plan_iteration_items_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_spending_plan_iteration_items_with_http_info(user_guid, spending_plan_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_spending_plan_iteration_items_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List spending plan iteration items  # noqa: E501

        Use this endpoint to list all the spending plan `iteration_items` associated with the `iteration`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_spending_plan_iteration_items_with_http_info(user_guid, spending_plan_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpendingPlanIterationItemsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'spending_plan_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_spending_plan_iteration_items" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['spending_plan_guid']:
            _path_params['spending_plan_guid'] = _params['spending_plan_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "SpendingPlanIterationItemsResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/spending_plans/{spending_plan_guid}/iterations/current/iteration_items', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_spending_plan_iterations(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> SpendingPlanIterationsResponse:  # noqa: E501
        """List spending plan iterations  # noqa: E501

        Use this endpoint to list all the spending plan `iterations` associated with the `spending_plan`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_spending_plan_iterations(user_guid, spending_plan_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpendingPlanIterationsResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_spending_plan_iterations_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_spending_plan_iterations_with_http_info(user_guid, spending_plan_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_spending_plan_iterations_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List spending plan iterations  # noqa: E501

        Use this endpoint to list all the spending plan `iterations` associated with the `spending_plan`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_spending_plan_iterations_with_http_info(user_guid, spending_plan_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpendingPlanIterationsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'spending_plan_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_spending_plan_iterations" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['spending_plan_guid']:
            _path_params['spending_plan_guid'] = _params['spending_plan_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "SpendingPlanIterationsResponse",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/spending_plans/{spending_plan_guid}/iterations', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_spending_plans(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> SpendingPlansResponseBody:  # noqa: E501
        """List spending plans  # noqa: E501

        Use this endpoint to list all the spending plans associated with the user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_spending_plans(user_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpendingPlansResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_spending_plans_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_spending_plans_with_http_info(user_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_spending_plans_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List spending plans  # noqa: E501

        Use this endpoint to list all the spending plans associated with the user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_spending_plans_with_http_info(user_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpendingPlansResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_spending_plans" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "SpendingPlansResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/spending_plans', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_spending_plan_account(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], spending_plan_account_guid : Annotated[StrictStr, Field(..., description="The unique ID for the specified account.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> SpendingPlanAccountResponse:  # noqa: E501
        """Read spending plan account  # noqa: E501

        Use this endpoint to read the attributes of a specific spending plan account according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_spending_plan_account(user_guid, spending_plan_guid, spending_plan_account_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param spending_plan_account_guid: The unique ID for the specified account. (required)
        :type spending_plan_account_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpendingPlanAccountResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_spending_plan_account_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_spending_plan_account_with_http_info(user_guid, spending_plan_guid, spending_plan_account_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def read_spending_plan_account_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], spending_plan_account_guid : Annotated[StrictStr, Field(..., description="The unique ID for the specified account.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Read spending plan account  # noqa: E501

        Use this endpoint to read the attributes of a specific spending plan account according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_spending_plan_account_with_http_info(user_guid, spending_plan_guid, spending_plan_account_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param spending_plan_account_guid: The unique ID for the specified account. (required)
        :type spending_plan_account_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpendingPlanAccountResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'spending_plan_guid',
            'spending_plan_account_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_spending_plan_account" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['spending_plan_guid']:
            _path_params['spending_plan_guid'] = _params['spending_plan_guid']

        if _params['spending_plan_account_guid']:
            _path_params['spending_plan_account_guid'] = _params['spending_plan_account_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "SpendingPlanAccountResponse",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/spending_plans/{spending_plan_guid}/spending_plan_accounts/{spending_plan_account_guid}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_spending_plan_iteration(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], iteration_number : Annotated[StrictInt, Field(..., description="The current iteration number for the spending plan `iteration``.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> SpendingPlanIterationResponse:  # noqa: E501
        """Read a spending plan iteration  # noqa: E501

        Use this endpoint to read the attributes of a specific spending plan `iteration` according to its `iteration_number`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_spending_plan_iteration(user_guid, spending_plan_guid, iteration_number, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param iteration_number: The current iteration number for the spending plan `iteration``. (required)
        :type iteration_number: int
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpendingPlanIterationResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_spending_plan_iteration_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_spending_plan_iteration_with_http_info(user_guid, spending_plan_guid, iteration_number, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def read_spending_plan_iteration_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], iteration_number : Annotated[StrictInt, Field(..., description="The current iteration number for the spending plan `iteration``.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Read a spending plan iteration  # noqa: E501

        Use this endpoint to read the attributes of a specific spending plan `iteration` according to its `iteration_number`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_spending_plan_iteration_with_http_info(user_guid, spending_plan_guid, iteration_number, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param iteration_number: The current iteration number for the spending plan `iteration``. (required)
        :type iteration_number: int
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpendingPlanIterationResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'spending_plan_guid',
            'iteration_number',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_spending_plan_iteration" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['spending_plan_guid']:
            _path_params['spending_plan_guid'] = _params['spending_plan_guid']

        if _params['iteration_number']:
            _path_params['iteration_number'] = _params['iteration_number']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "SpendingPlanIterationResponse",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/spending_plans/{spending_plan_guid}/iterations/{iteration_number}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_spending_plan_iteration_item(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], iteration_item_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `iteration_item`.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> SpendingPlanIterationItemResponse:  # noqa: E501
        """Read a spending plan iteration item  # noqa: E501

        Use this endpoint to read the attributes of a specific spending plan `iteration_item` according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_spending_plan_iteration_item(user_guid, spending_plan_guid, iteration_item_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param iteration_item_guid: The unique ID for the `iteration_item`. (required)
        :type iteration_item_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpendingPlanIterationItemResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_spending_plan_iteration_item_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_spending_plan_iteration_item_with_http_info(user_guid, spending_plan_guid, iteration_item_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def read_spending_plan_iteration_item_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], iteration_item_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `iteration_item`.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Read a spending plan iteration item  # noqa: E501

        Use this endpoint to read the attributes of a specific spending plan `iteration_item` according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_spending_plan_iteration_item_with_http_info(user_guid, spending_plan_guid, iteration_item_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param iteration_item_guid: The unique ID for the `iteration_item`. (required)
        :type iteration_item_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpendingPlanIterationItemResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'spending_plan_guid',
            'iteration_item_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_spending_plan_iteration_item" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['spending_plan_guid']:
            _path_params['spending_plan_guid'] = _params['spending_plan_guid']

        if _params['iteration_item_guid']:
            _path_params['iteration_item_guid'] = _params['iteration_item_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "SpendingPlanIterationItemResponse",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/spending_plans/{spending_plan_guid}/iterations/current/iteration_items/{iteration_item_guid}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_spending_plan_user(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> SpendingPlanResponse:  # noqa: E501
        """Read a spending plan for a user  # noqa: E501

        Use this endpoint to read the attributes of a specific spending plan according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_spending_plan_user(user_guid, spending_plan_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpendingPlanResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_spending_plan_user_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_spending_plan_user_with_http_info(user_guid, spending_plan_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def read_spending_plan_user_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Read a spending plan for a user  # noqa: E501

        Use this endpoint to read the attributes of a specific spending plan according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_spending_plan_user_with_http_info(user_guid, spending_plan_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpendingPlanResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'spending_plan_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_spending_plan_user" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['spending_plan_guid']:
            _path_params['spending_plan_guid'] = _params['spending_plan_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "SpendingPlanResponse",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/spending_plans/{spending_plan_guid}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_spending_plan_iteration_item(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], iteration_item_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `iteration_item`.")], spending_plan_iteration_item_create_request_body : Annotated[SpendingPlanIterationItemCreateRequestBody, Field(..., description="Iteration item object to be updated with required parameter (iteration_item_guid)")], **kwargs) -> SpendingPlanIterationItemResponse:  # noqa: E501
        """Update a spending plan iteration item  # noqa: E501

        Use this endpoint to update an existing `spending_plan_iteration_item`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_spending_plan_iteration_item(user_guid, spending_plan_guid, iteration_item_guid, spending_plan_iteration_item_create_request_body, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param iteration_item_guid: The unique ID for the `iteration_item`. (required)
        :type iteration_item_guid: str
        :param spending_plan_iteration_item_create_request_body: Iteration item object to be updated with required parameter (iteration_item_guid) (required)
        :type spending_plan_iteration_item_create_request_body: SpendingPlanIterationItemCreateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpendingPlanIterationItemResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_spending_plan_iteration_item_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.update_spending_plan_iteration_item_with_http_info(user_guid, spending_plan_guid, iteration_item_guid, spending_plan_iteration_item_create_request_body, **kwargs)  # noqa: E501

    @validate_arguments
    def update_spending_plan_iteration_item_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique id for a `user`.")], spending_plan_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `spending_plan`.")], iteration_item_guid : Annotated[StrictStr, Field(..., description="The unique ID for the `iteration_item`.")], spending_plan_iteration_item_create_request_body : Annotated[SpendingPlanIterationItemCreateRequestBody, Field(..., description="Iteration item object to be updated with required parameter (iteration_item_guid)")], **kwargs) -> ApiResponse:  # noqa: E501
        """Update a spending plan iteration item  # noqa: E501

        Use this endpoint to update an existing `spending_plan_iteration_item`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_spending_plan_iteration_item_with_http_info(user_guid, spending_plan_guid, iteration_item_guid, spending_plan_iteration_item_create_request_body, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique id for a `user`. (required)
        :type user_guid: str
        :param spending_plan_guid: The unique ID for the `spending_plan`. (required)
        :type spending_plan_guid: str
        :param iteration_item_guid: The unique ID for the `iteration_item`. (required)
        :type iteration_item_guid: str
        :param spending_plan_iteration_item_create_request_body: Iteration item object to be updated with required parameter (iteration_item_guid) (required)
        :type spending_plan_iteration_item_create_request_body: SpendingPlanIterationItemCreateRequestBody
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpendingPlanIterationItemResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'spending_plan_guid',
            'iteration_item_guid',
            'spending_plan_iteration_item_create_request_body'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_spending_plan_iteration_item" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['spending_plan_guid']:
            _path_params['spending_plan_guid'] = _params['spending_plan_guid']

        if _params['iteration_item_guid']:
            _path_params['iteration_item_guid'] = _params['iteration_item_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['spending_plan_iteration_item_create_request_body'] is not None:
            _body_params = _params['spending_plan_iteration_item_create_request_body']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "SpendingPlanIterationItemResponse",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/spending_plans/{spending_plan_guid}/iterations/current/iteration_items/{iteration_item_guid}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
