# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictBool, StrictStr

class MemberResponse(BaseModel):
    """
    MemberResponse
    """
    aggregated_at: Optional[StrictStr] = None
    background_aggregation_is_disabled: Optional[StrictBool] = None
    connection_status: Optional[StrictStr] = None
    guid: Optional[StrictStr] = None
    id: Optional[StrictStr] = None
    institution_code: Optional[StrictStr] = None
    is_being_aggregated: Optional[StrictBool] = None
    is_managed_by_user: Optional[StrictBool] = None
    is_oauth: Optional[StrictBool] = None
    metadata: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    oauth_window_uri: Optional[StrictStr] = None
    successfully_aggregated_at: Optional[StrictStr] = None
    user_guid: Optional[StrictStr] = None
    user_id: Optional[StrictStr] = None
    __properties = ["aggregated_at", "background_aggregation_is_disabled", "connection_status", "guid", "id", "institution_code", "is_being_aggregated", "is_managed_by_user", "is_oauth", "metadata", "name", "oauth_window_uri", "successfully_aggregated_at", "user_guid", "user_id"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MemberResponse:
        """Create an instance of MemberResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if aggregated_at (nullable) is None
        # and __fields_set__ contains the field
        if self.aggregated_at is None and "aggregated_at" in self.__fields_set__:
            _dict['aggregated_at'] = None

        # set to None if connection_status (nullable) is None
        # and __fields_set__ contains the field
        if self.connection_status is None and "connection_status" in self.__fields_set__:
            _dict['connection_status'] = None

        # set to None if guid (nullable) is None
        # and __fields_set__ contains the field
        if self.guid is None and "guid" in self.__fields_set__:
            _dict['guid'] = None

        # set to None if id (nullable) is None
        # and __fields_set__ contains the field
        if self.id is None and "id" in self.__fields_set__:
            _dict['id'] = None

        # set to None if institution_code (nullable) is None
        # and __fields_set__ contains the field
        if self.institution_code is None and "institution_code" in self.__fields_set__:
            _dict['institution_code'] = None

        # set to None if is_being_aggregated (nullable) is None
        # and __fields_set__ contains the field
        if self.is_being_aggregated is None and "is_being_aggregated" in self.__fields_set__:
            _dict['is_being_aggregated'] = None

        # set to None if is_managed_by_user (nullable) is None
        # and __fields_set__ contains the field
        if self.is_managed_by_user is None and "is_managed_by_user" in self.__fields_set__:
            _dict['is_managed_by_user'] = None

        # set to None if is_oauth (nullable) is None
        # and __fields_set__ contains the field
        if self.is_oauth is None and "is_oauth" in self.__fields_set__:
            _dict['is_oauth'] = None

        # set to None if metadata (nullable) is None
        # and __fields_set__ contains the field
        if self.metadata is None and "metadata" in self.__fields_set__:
            _dict['metadata'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if oauth_window_uri (nullable) is None
        # and __fields_set__ contains the field
        if self.oauth_window_uri is None and "oauth_window_uri" in self.__fields_set__:
            _dict['oauth_window_uri'] = None

        # set to None if successfully_aggregated_at (nullable) is None
        # and __fields_set__ contains the field
        if self.successfully_aggregated_at is None and "successfully_aggregated_at" in self.__fields_set__:
            _dict['successfully_aggregated_at'] = None

        # set to None if user_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.user_guid is None and "user_guid" in self.__fields_set__:
            _dict['user_guid'] = None

        # set to None if user_id (nullable) is None
        # and __fields_set__ contains the field
        if self.user_id is None and "user_id" in self.__fields_set__:
            _dict['user_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MemberResponse:
        """Create an instance of MemberResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MemberResponse.parse_obj(obj)

        _obj = MemberResponse.parse_obj({
            "aggregated_at": obj.get("aggregated_at"),
            "background_aggregation_is_disabled": obj.get("background_aggregation_is_disabled"),
            "connection_status": obj.get("connection_status"),
            "guid": obj.get("guid"),
            "id": obj.get("id"),
            "institution_code": obj.get("institution_code"),
            "is_being_aggregated": obj.get("is_being_aggregated"),
            "is_managed_by_user": obj.get("is_managed_by_user"),
            "is_oauth": obj.get("is_oauth"),
            "metadata": obj.get("metadata"),
            "name": obj.get("name"),
            "oauth_window_uri": obj.get("oauth_window_uri"),
            "successfully_aggregated_at": obj.get("successfully_aggregated_at"),
            "user_guid": obj.get("user_guid"),
            "user_id": obj.get("user_id")
        })
        return _obj


