# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictBool, StrictStr

class InstitutionResponse(BaseModel):
    """
    InstitutionResponse
    """
    code: Optional[StrictStr] = None
    forgot_password_url: Optional[StrictStr] = None
    forgot_username_url: Optional[StrictStr] = None
    instructional_text: Optional[StrictStr] = None
    medium_logo_url: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    small_logo_url: Optional[StrictStr] = None
    supports_account_identification: Optional[StrictBool] = None
    supports_account_statement: Optional[StrictBool] = None
    supports_account_verification: Optional[StrictBool] = None
    supports_oauth: Optional[StrictBool] = None
    supports_transaction_history: Optional[StrictBool] = None
    trouble_signing_in_url: Optional[StrictStr] = None
    url: Optional[StrictStr] = None
    __properties = ["code", "forgot_password_url", "forgot_username_url", "instructional_text", "medium_logo_url", "name", "small_logo_url", "supports_account_identification", "supports_account_statement", "supports_account_verification", "supports_oauth", "supports_transaction_history", "trouble_signing_in_url", "url"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InstitutionResponse:
        """Create an instance of InstitutionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if code (nullable) is None
        # and __fields_set__ contains the field
        if self.code is None and "code" in self.__fields_set__:
            _dict['code'] = None

        # set to None if forgot_password_url (nullable) is None
        # and __fields_set__ contains the field
        if self.forgot_password_url is None and "forgot_password_url" in self.__fields_set__:
            _dict['forgot_password_url'] = None

        # set to None if forgot_username_url (nullable) is None
        # and __fields_set__ contains the field
        if self.forgot_username_url is None and "forgot_username_url" in self.__fields_set__:
            _dict['forgot_username_url'] = None

        # set to None if instructional_text (nullable) is None
        # and __fields_set__ contains the field
        if self.instructional_text is None and "instructional_text" in self.__fields_set__:
            _dict['instructional_text'] = None

        # set to None if medium_logo_url (nullable) is None
        # and __fields_set__ contains the field
        if self.medium_logo_url is None and "medium_logo_url" in self.__fields_set__:
            _dict['medium_logo_url'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if small_logo_url (nullable) is None
        # and __fields_set__ contains the field
        if self.small_logo_url is None and "small_logo_url" in self.__fields_set__:
            _dict['small_logo_url'] = None

        # set to None if supports_account_identification (nullable) is None
        # and __fields_set__ contains the field
        if self.supports_account_identification is None and "supports_account_identification" in self.__fields_set__:
            _dict['supports_account_identification'] = None

        # set to None if supports_account_statement (nullable) is None
        # and __fields_set__ contains the field
        if self.supports_account_statement is None and "supports_account_statement" in self.__fields_set__:
            _dict['supports_account_statement'] = None

        # set to None if supports_account_verification (nullable) is None
        # and __fields_set__ contains the field
        if self.supports_account_verification is None and "supports_account_verification" in self.__fields_set__:
            _dict['supports_account_verification'] = None

        # set to None if supports_oauth (nullable) is None
        # and __fields_set__ contains the field
        if self.supports_oauth is None and "supports_oauth" in self.__fields_set__:
            _dict['supports_oauth'] = None

        # set to None if supports_transaction_history (nullable) is None
        # and __fields_set__ contains the field
        if self.supports_transaction_history is None and "supports_transaction_history" in self.__fields_set__:
            _dict['supports_transaction_history'] = None

        # set to None if trouble_signing_in_url (nullable) is None
        # and __fields_set__ contains the field
        if self.trouble_signing_in_url is None and "trouble_signing_in_url" in self.__fields_set__:
            _dict['trouble_signing_in_url'] = None

        # set to None if url (nullable) is None
        # and __fields_set__ contains the field
        if self.url is None and "url" in self.__fields_set__:
            _dict['url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InstitutionResponse:
        """Create an instance of InstitutionResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return InstitutionResponse.parse_obj(obj)

        _obj = InstitutionResponse.parse_obj({
            "code": obj.get("code"),
            "forgot_password_url": obj.get("forgot_password_url"),
            "forgot_username_url": obj.get("forgot_username_url"),
            "instructional_text": obj.get("instructional_text"),
            "medium_logo_url": obj.get("medium_logo_url"),
            "name": obj.get("name"),
            "small_logo_url": obj.get("small_logo_url"),
            "supports_account_identification": obj.get("supports_account_identification"),
            "supports_account_statement": obj.get("supports_account_statement"),
            "supports_account_verification": obj.get("supports_account_verification"),
            "supports_oauth": obj.get("supports_oauth"),
            "supports_transaction_history": obj.get("supports_transaction_history"),
            "trouble_signing_in_url": obj.get("trouble_signing_in_url"),
            "url": obj.get("url")
        })
        return _obj


