# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictStr

class AccountOwnerResponse(BaseModel):
    """
    AccountOwnerResponse
    """
    account_guid: Optional[StrictStr] = None
    address: Optional[StrictStr] = None
    city: Optional[StrictStr] = None
    country: Optional[StrictStr] = None
    email: Optional[StrictStr] = None
    first_name: Optional[StrictStr] = None
    guid: Optional[StrictStr] = None
    last_name: Optional[StrictStr] = None
    member_guid: Optional[StrictStr] = None
    owner_name: Optional[StrictStr] = None
    phone: Optional[StrictStr] = None
    postal_code: Optional[StrictStr] = None
    state: Optional[StrictStr] = None
    user_guid: Optional[StrictStr] = None
    __properties = ["account_guid", "address", "city", "country", "email", "first_name", "guid", "last_name", "member_guid", "owner_name", "phone", "postal_code", "state", "user_guid"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountOwnerResponse:
        """Create an instance of AccountOwnerResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if account_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.account_guid is None and "account_guid" in self.__fields_set__:
            _dict['account_guid'] = None

        # set to None if address (nullable) is None
        # and __fields_set__ contains the field
        if self.address is None and "address" in self.__fields_set__:
            _dict['address'] = None

        # set to None if city (nullable) is None
        # and __fields_set__ contains the field
        if self.city is None and "city" in self.__fields_set__:
            _dict['city'] = None

        # set to None if country (nullable) is None
        # and __fields_set__ contains the field
        if self.country is None and "country" in self.__fields_set__:
            _dict['country'] = None

        # set to None if email (nullable) is None
        # and __fields_set__ contains the field
        if self.email is None and "email" in self.__fields_set__:
            _dict['email'] = None

        # set to None if first_name (nullable) is None
        # and __fields_set__ contains the field
        if self.first_name is None and "first_name" in self.__fields_set__:
            _dict['first_name'] = None

        # set to None if guid (nullable) is None
        # and __fields_set__ contains the field
        if self.guid is None and "guid" in self.__fields_set__:
            _dict['guid'] = None

        # set to None if last_name (nullable) is None
        # and __fields_set__ contains the field
        if self.last_name is None and "last_name" in self.__fields_set__:
            _dict['last_name'] = None

        # set to None if member_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.member_guid is None and "member_guid" in self.__fields_set__:
            _dict['member_guid'] = None

        # set to None if owner_name (nullable) is None
        # and __fields_set__ contains the field
        if self.owner_name is None and "owner_name" in self.__fields_set__:
            _dict['owner_name'] = None

        # set to None if phone (nullable) is None
        # and __fields_set__ contains the field
        if self.phone is None and "phone" in self.__fields_set__:
            _dict['phone'] = None

        # set to None if postal_code (nullable) is None
        # and __fields_set__ contains the field
        if self.postal_code is None and "postal_code" in self.__fields_set__:
            _dict['postal_code'] = None

        # set to None if state (nullable) is None
        # and __fields_set__ contains the field
        if self.state is None and "state" in self.__fields_set__:
            _dict['state'] = None

        # set to None if user_guid (nullable) is None
        # and __fields_set__ contains the field
        if self.user_guid is None and "user_guid" in self.__fields_set__:
            _dict['user_guid'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountOwnerResponse:
        """Create an instance of AccountOwnerResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AccountOwnerResponse.parse_obj(obj)

        _obj = AccountOwnerResponse.parse_obj({
            "account_guid": obj.get("account_guid"),
            "address": obj.get("address"),
            "city": obj.get("city"),
            "country": obj.get("country"),
            "email": obj.get("email"),
            "first_name": obj.get("first_name"),
            "guid": obj.get("guid"),
            "last_name": obj.get("last_name"),
            "member_guid": obj.get("member_guid"),
            "owner_name": obj.get("owner_name"),
            "phone": obj.get("phone"),
            "postal_code": obj.get("postal_code"),
            "state": obj.get("state"),
            "user_guid": obj.get("user_guid")
        })
        return _obj


