# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictStr

class MerchantResponse(BaseModel):
    """
    MerchantResponse
    """
    created_at: Optional[StrictStr] = None
    guid: Optional[StrictStr] = None
    logo_url: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    updated_at: Optional[StrictStr] = None
    website_url: Optional[StrictStr] = None
    __properties = ["created_at", "guid", "logo_url", "name", "updated_at", "website_url"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MerchantResponse:
        """Create an instance of MerchantResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if created_at (nullable) is None
        # and __fields_set__ contains the field
        if self.created_at is None and "created_at" in self.__fields_set__:
            _dict['created_at'] = None

        # set to None if guid (nullable) is None
        # and __fields_set__ contains the field
        if self.guid is None and "guid" in self.__fields_set__:
            _dict['guid'] = None

        # set to None if logo_url (nullable) is None
        # and __fields_set__ contains the field
        if self.logo_url is None and "logo_url" in self.__fields_set__:
            _dict['logo_url'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if updated_at (nullable) is None
        # and __fields_set__ contains the field
        if self.updated_at is None and "updated_at" in self.__fields_set__:
            _dict['updated_at'] = None

        # set to None if website_url (nullable) is None
        # and __fields_set__ contains the field
        if self.website_url is None and "website_url" in self.__fields_set__:
            _dict['website_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MerchantResponse:
        """Create an instance of MerchantResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return MerchantResponse.parse_obj(obj)

        _obj = MerchantResponse.parse_obj({
            "created_at": obj.get("created_at"),
            "guid": obj.get("guid"),
            "logo_url": obj.get("logo_url"),
            "name": obj.get("name"),
            "updated_at": obj.get("updated_at"),
            "website_url": obj.get("website_url")
        })
        return _obj


